/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.ui.IdvTimeline;
import ucar.unidata.ui.ChooserList;
import ucar.unidata.ui.Timeline;
import ucar.unidata.ui.event.PopupTriggerListener;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedObject;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.DateTime;

public class TimesChooser
extends IdvChooser {
    private static final String TIME_MATCHING_LABEL = "Match Time Driver";
    private static final String TIME_MATCHING_LABEL_INIT = "Select a Matching Display";
    private static final int TIMES_RELATIVERANGE = 0;
    private static final int TIMES_ABSOLUTE = 1;
    private static final int TIMES_RELATIVE = 2;
    protected static final String MSG_TIMES = "Please select one or more times";
    protected static final String LABEL_TIMES = "Times:";
    protected TwoFacedObject selectedDriver = null;
    private boolean ignoreTimeChangedEvents = false;
    private int ignoreCnt = 0;
    private ChooserList relTimesList;
    private boolean usingTimeline = false;
    private IdvTimeline popupTimeline;
    private IdvTimeline timeline;
    private JTabbedPane timesTab;
    private GuiUtils.CardLayoutPanel timesCardPanel;
    protected JComponent timesContainer;
    private JLabel absTimesLbl = new JLabel("  ");
    private ChooserList timesList;
    private List absoluteTimes = new ArrayList();
    private int[] currentSelectedAbsoluteTimes;
    private boolean doAbsoluteTimes = false;
    private int timesMode = 2;
    protected List timesComponents = new ArrayList();
    private List driverMenuList = new ArrayList();
    private List timeDrivers = new ArrayList();
    private boolean doTimeDrivers = false;
    JComponent centerPopup;
    JPopupMenu driverPopupMenu;
    JLabel driverLbl = new JLabel("Match Time Driver");
    private boolean readingDrivers = false;
    public JCheckBox drivercbx = null;
    JComponent timeDriverComp = null;

    public TimesChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
        this.setTimeDrivers(new ArrayList());
    }

    protected boolean haveAnyTimes() {
        if (this.timesList == null) {
            return false;
        }
        return this.timesList.getModel().getSize() > 0;
    }

    private boolean checkIgnore() {
        if (this.ignoreTimeChangedEvents) {
            return true;
        }
        this.pushIgnore();
        return false;
    }

    private void pushIgnore() {
        ++this.ignoreCnt;
        this.ignoreTimeChangedEvents = true;
    }

    private void popIgnore() {
        --this.ignoreCnt;
        if (this.ignoreCnt <= 0) {
            this.ignoreTimeChangedEvents = false;
            this.ignoreCnt = 0;
        }
    }

    public ChooserList getTimesList() {
        if (this.timesList == null) {
            this.timesList = new ChooserList(this.getAbsoluteTimeSelectMode());
            this.timesComponents.add(this.timesList);
            this.timesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (TimesChooser.this.checkIgnore()) {
                        return;
                    }
                    List items = Misc.toList(TimesChooser.this.getTimesList().getSelectedValues());
                    TimesChooser.this.setSelectedAbsoluteTimes(items);
                    TimesChooser.this.absoluteTimesSelectionChanged();
                    if (items.size() > 0 && TimesChooser.this.usingTimeline) {
                        items = DatedObject.sort(items, true);
                        Date startDate = ((DatedThing)items.get(0)).getDate();
                        Date endDate = ((DatedThing)items.get(items.size() - 1)).getDate();
                        if (TimesChooser.this.timeline.getUseDateSelection()) {
                            TimesChooser.this.timeline.getDateSelection().setStartFixedTime(startDate);
                            TimesChooser.this.timeline.getDateSelection().setEndFixedTime(endDate);
                        }
                        long visStart = TimesChooser.this.timeline.getStartDate().getTime();
                        long visEnd = TimesChooser.this.timeline.getEndDate().getTime();
                        long selStart = startDate.getTime();
                        long selEnd = endDate.getTime();
                        long width = visEnd - visStart;
                        if (items.size() >= 2) {
                            if (selStart < visStart || selStart > visEnd || selEnd < selStart || selEnd > visEnd) {
                                TimesChooser.this.timeline.setStartDate(new Date(selStart));
                                TimesChooser.this.timeline.setEndDate(new Date(selEnd));
                                TimesChooser.this.timeline.expandByPercent(2.0, false);
                            }
                        } else if (selStart < visStart || selStart > visEnd) {
                            TimesChooser.this.timeline.setStartDate(new Date(selStart - width / 2L));
                            TimesChooser.this.timeline.setEndDate(new Date(selStart + width / 2L));
                        }
                    }
                    TimesChooser.this.updateStatus();
                    TimesChooser.this.popIgnore();
                }
            });
        }
        return this.timesList;
    }

    public JPopupMenu getTimeDriverPopupMenu() {
        return this.driverPopupMenu;
    }

    protected int getAbsoluteTimeSelectMode() {
        return 2;
    }

    public ChooserList getRelativeTimesList() {
        if (this.relTimesList == null) {
            this.relTimesList = new ChooserList();
            this.relTimesList.setSelectionMode(0);
            this.timesComponents.add(this.relTimesList);
            Vector<String> items = new Vector<String>();
            for (int i = 0; i < 100; ++i) {
                if (i == 0) {
                    items.add("Most recent");
                    continue;
                }
                items.add(i + 1 + " most recent");
            }
            this.relTimesList.setListData(items);
            this.relTimesList.setSelectedIndex(this.getDefaultRelativeTimeIndex());
            this.relTimesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    TimesChooser.this.updateStatus();
                }
            });
            this.relTimesList.ensureIndexIsVisible(this.getDefaultRelativeTimeIndex());
        }
        return this.relTimesList;
    }

    protected void clearTimesList() {
        this.setAbsoluteTimes(new ArrayList());
    }

    public void readTimes() {
    }

    public void readDrivers() {
        if (this.readingDrivers) {
            return;
        }
        this.readingDrivers = true;
        List drivers = new ArrayList();
        try {
            this.showWaitCursor();
            this.setTimeDrivers(new ArrayList());
            drivers = this.updateTimeDriver();
            this.showNormalCursor();
        }
        catch (Exception exc) {
            TimesChooser.userMessage("Error reading drivers... ");
            this.showNormalCursor();
            this.readingDrivers = false;
            return;
        }
        this.readingDrivers = false;
        this.setTimeDrivers(drivers);
    }

    protected List updateTimeDriver() {
        List<ViewManager> vms = this.getIdv().getVMManager().getViewManagers();
        ArrayList<TwoFacedObject> driverNames = new ArrayList<TwoFacedObject>();
        for (ViewManager vm : vms) {
            try {
                if (vm.getTimeDriverTimes() == null) continue;
                driverNames.add(new TwoFacedObject((Object)vm.getName(), vm.getTimeDriverTimes()));
            }
            catch (Exception exception) {}
        }
        return driverNames;
    }

    protected JPanel makeTimesPanel() {
        return this.makeTimesPanel(true);
    }

    protected void absoluteTimesSelectionChanged() {
        this.updateStatus();
    }

    protected JPanel makeTimesPanel(boolean includeExtra) {
        return this.makeTimesPanel(includeExtra, true);
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        if (this.doAbsoluteTimes) {
            if (this.currentSelectedAbsoluteTimes == null || this.currentSelectedAbsoluteTimes.length == 0) {
                this.absTimesLbl.setText(" No times selected");
            } else if (this.currentSelectedAbsoluteTimes.length == 1) {
                this.absTimesLbl.setText(" 1 time selected");
            } else {
                this.absTimesLbl.setText(" " + this.currentSelectedAbsoluteTimes.length + " times selected");
            }
        }
    }

    protected JPanel makeTimesPanel(boolean includeExtra, boolean useTimeLine) {
        if (this.getIdv().getUseTimeDriver()) {
            return this.makeTimesPanel(includeExtra, useTimeLine, true);
        }
        return this.makeTimesPanel(includeExtra, useTimeLine, false);
    }

    protected JPanel makeTimesPanel(boolean includeExtra, boolean useTimeLine, boolean includeTimeDriver) {
        this.pushIgnore();
        JButton timelineBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Calendar16.gif", this, "popupTimeline");
        timelineBtn.setToolTipText("Select times in timeline");
        this.timeline = new IdvTimeline(new ArrayList(), 200){

            @Override
            public List getSunriseLocations() {
                return TimesChooser.this.getIdv().getIdvUIManager().getMapLocations();
            }

            @Override
            public void selectedDatesChanged() {
                super.selectedDatesChanged();
                if (TimesChooser.this.checkIgnore()) {
                    return;
                }
                TimesChooser.this.setSelectedAbsoluteTimes(TimesChooser.this.timeline.getSelected());
                TimesChooser.this.updateStatus();
                TimesChooser.this.absoluteTimesSelectionChanged();
                TimesChooser.this.popIgnore();
            }
        };
        this.timeline.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    TimesChooser.this.doTimeDrivers = false;
                }
            }
        });
        this.timeline.setUseDateSelection(true);
        Date toDate = new Date(System.currentTimeMillis() + DateUtil.daysToMillis(1.0));
        Date fromDate = new Date(System.currentTimeMillis() - DateUtil.daysToMillis(1.0));
        this.timeline.setRange(fromDate, toDate, true);
        this.timeline.setSticky(false);
        DateSelection dateSelection = new DateSelection(this.timeline.getStartDate(), this.timeline.getEndDate());
        this.timeline.setDateSelection(dateSelection);
        ChooserList timesList = this.getTimesList();
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ae) {
                boolean currentAbs;
                boolean bl = currentAbs = TimesChooser.this.timesTab.getSelectedIndex() == 1;
                if (currentAbs == TimesChooser.this.getDoAbsoluteTimes()) {
                    return;
                }
                TimesChooser.this.doAbsoluteTimes = currentAbs;
                if (TimesChooser.this.doAbsoluteTimes && !TimesChooser.this.haveAnyTimes()) {
                    Misc.run(TimesChooser.this, "readTimes");
                }
                TimesChooser.this.updateStatus();
                TimesChooser.this.enableTimeWidgets();
            }
        };
        this.drivercbx = new JCheckBox(TIME_MATCHING_LABEL, this.getDoTimeDrivers());
        this.drivercbx.setToolTipText("Use the times from the time driver in the view");
        this.drivercbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimesChooser.this.setDoTimeDrivers(((JCheckBox)e.getSource()).isSelected());
                if (!((JCheckBox)e.getSource()).isSelected()) {
                    TimesChooser.this.enableTimeWidgets();
                } else {
                    TimesChooser.this.readDrivers();
                    if (TimesChooser.this.driverMenuList == null || TimesChooser.this.driverMenuList.size() == 0) {
                        GuiUtils.showDialog("No Time Driver", new JLabel("Please set a time driver first."));
                        ((JCheckBox)e.getSource()).setSelected(false);
                        TimesChooser.this.setDoTimeDrivers(((JCheckBox)e.getSource()).isSelected());
                    } else {
                        TimesChooser.this.disableTimeWidgets();
                    }
                }
            }
        });
        this.timeDriverComp = this.drivercbx;
        JComponent timesExtra = this.getExtraTimeComponent();
        JComponent absoluteExtra = this.getExtraAbsoluteTimeComponent();
        JComponent relativeExtra = this.getExtraRelativeTimeComponent();
        this.timesCardPanel = new GuiUtils.CardLayoutPanel();
        this.timesContainer = GuiUtils.center(this.timesCardPanel);
        this.timesTab = GuiUtils.getNestedTabbedPane();
        this.usingTimeline = useTimeLine;
        this.timesTab.add("Relative", GuiUtils.centerBottom(this.getRelativeTimesList().getScroller(), relativeExtra));
        if (useTimeLine) {
            timesList.getScroller().setHorizontalScrollBarPolicy(31);
            Font f = timesList.getFont();
            f = f.deriveFont((float)f.getSize() - 2.0f);
            timesList.setFont(f);
            JSplitPane splitter = GuiUtils.hsplit((Component)this.timeline.getContents(false), (Component)timesList.getScroller(), 0.75);
            splitter.setOneTouchExpandable(true);
            this.timesTab.add("Absolute", GuiUtils.centerBottom(splitter, GuiUtils.leftRight(this.absTimesLbl, absoluteExtra)));
            this.timesTab.setPreferredSize(new Dimension(350, 150));
        } else {
            this.timesTab.add("Absolute", GuiUtils.centerBottom(timesList.getScroller(), absoluteExtra));
            this.timesTab.setPreferredSize(new Dimension(350, 150));
        }
        JPanel panel = includeExtra ? (includeTimeDriver ? GuiUtils.centerBottom(this.timesTab, GuiUtils.leftRight(this.timeDriverComp, timesExtra)) : GuiUtils.centerBottom(this.timesTab, GuiUtils.left(timesExtra))) : (includeTimeDriver ? GuiUtils.centerBottom(this.timesTab, GuiUtils.left(this.timeDriverComp)) : GuiUtils.center(this.timesTab));
        this.timesTab.addChangeListener(listener);
        this.popIgnore();
        return panel;
    }

    protected boolean checkActiveViewWithDriver() {
        List<ViewManager> vms = this.getIdv().getVMManager().getViewManagers();
        int size = vms.size();
        if (size == 1) {
            return true;
        }
        ViewManager vm0 = this.getIdv().getVMManager().getLastActiveViewManager();
        List<DateTime> tdt = null;
        try {
            tdt = vm0.getTimeDriverTimes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tdt != null) {
            return true;
        }
        LogUtil.userErrorMessage(new JLabel("<html>Error: there is no time driver in the current active view window, please select or set the view window with time driver! </html>"));
        return false;
    }

    @Override
    public void doLoad() {
        if (this.autoCreateDisplayCbx == null) {
            super.doLoad();
        } else if (this.drivercbx.isSelected() && this.autoCreateDisplayCbx.isSelected()) {
            if (!this.checkActiveViewWithDriver()) {
                return;
            }
            super.doLoad();
        } else {
            super.doLoad();
        }
    }

    protected void enableAbsoluteTimesList(boolean enabled) {
        if (this.usingTimeline) {
            this.timeline.setEnabled(enabled);
        }
        this.getTimesList().setEnabled(enabled);
    }

    protected void setAbsoluteTimes(List times) {
        List<DatedThing> newAbsoluteTimes = this.makeDatedObjects(times);
        if (Misc.equals(this.absoluteTimes, newAbsoluteTimes)) {
            return;
        }
        this.absoluteTimes = newAbsoluteTimes;
        this.pushIgnore();
        this.getTimesList().setListData(new Vector(this.absoluteTimes));
        this.getTimesList().ensureIndexIsVisible(this.absoluteTimes.size() - 1);
        this.setSelectedAbsoluteTimes(new ArrayList());
        if (this.usingTimeline) {
            try {
                Date startDate;
                Date endDate;
                this.timeline.setDatedThings(this.absoluteTimes, true);
                if (this.absoluteTimes.size() > 1) {
                    endDate = ((DatedThing)this.absoluteTimes.get(this.absoluteTimes.size() - 1)).getDate();
                    int index = Math.max(0, this.absoluteTimes.size() - this.getNumTimesToSelect());
                    startDate = ((DatedThing)this.absoluteTimes.get(index)).getDate();
                } else if (this.absoluteTimes.size() == 1) {
                    DatedThing theDate = (DatedThing)this.absoluteTimes.get(0);
                    endDate = new Date(theDate.getDate().getTime() + DateUtil.daysToMillis(1.0));
                    startDate = new Date(theDate.getDate().getTime() - DateUtil.daysToMillis(1.0));
                } else {
                    startDate = new Date(System.currentTimeMillis() - DateUtil.daysToMillis(1.0));
                    endDate = new Date(System.currentTimeMillis());
                }
                if (this.timeline.getDateSelection() == null) {
                    DateSelection dateSelection = new DateSelection(startDate, endDate);
                    this.timeline.setDateSelection(dateSelection);
                } else {
                    this.timeline.getDateSelection().setStartFixedTime(startDate);
                    this.timeline.getDateSelection().setEndFixedTime(endDate);
                }
                if (this.absoluteTimes.size() >= 2) {
                    endDate = ((DatedThing)this.absoluteTimes.get(this.absoluteTimes.size() - 1)).getDate();
                    int index = Math.max(0, this.absoluteTimes.size() - this.getNumTimesToSelect() * 2);
                    startDate = ((DatedThing)this.absoluteTimes.get(index)).getDate();
                } else if (this.absoluteTimes.size() != 1) {
                    startDate = new Date(System.currentTimeMillis() - DateUtil.daysToMillis(1.0));
                    endDate = new Date(System.currentTimeMillis());
                }
                long diff = endDate.getTime() - startDate.getTime();
                startDate = new Date(endDate.getTime() - 2L * diff);
                this.timeline.setRange(startDate, endDate, true);
                this.timeline.expandByPercent(1.2, false);
                this.timeline.makeCurrentRangeOriginal();
                if (this.timeline.getUseDateSelection()) {
                    this.timeline.setUseDateSelection(true);
                    this.setSelectedAbsoluteTimes(this.timeline.getSelected());
                    this.updateStatus();
                }
            }
            catch (Exception exc) {
                this.logException("Setting times", exc);
            }
        }
        this.popIgnore();
    }

    protected void setTimeDrivers(List drivers) {
        JMenuItem ji;
        int size = drivers.size();
        this.driverMenuList = new ArrayList();
        if (size > 0) {
            List atime = this.getAbsoluteTimes();
            TwoFacedObject twoObj = new TwoFacedObject((Object)TIME_MATCHING_LABEL_INIT, atime);
            ji = GuiUtils.makeMenuItem((String)twoObj.getLabel(), this, "updatetimeline", twoObj);
            this.driverMenuList.add(ji);
        }
        for (int i = 0; i < size; ++i) {
            TwoFacedObject driver = (TwoFacedObject)drivers.get(i);
            ji = GuiUtils.makeMenuItem((String)driver.getLabel(), this, "updatetimeline", driver);
            this.driverMenuList.add(ji);
        }
    }

    public void updatetimeline(TwoFacedObject id) {
        this.doTimeDrivers = true;
        this.selectedDriver = id;
        if (id.getLabel().toString().contains(TIME_MATCHING_LABEL_INIT)) {
            this.doTimeDrivers = false;
            List tt = (List)id.getId();
            this.absoluteTimes = null;
            this.setAbsoluteTimes(tt);
            return;
        }
        DateTime[] driverTimes = (DateTime[])id.getId();
        ArrayList<DateTime> dtimes = new ArrayList<DateTime>();
        for (int i = 0; i < driverTimes.length; ++i) {
            dtimes.add(driverTimes[i]);
        }
        Collections.sort(dtimes);
        int n = driverTimes.length;
        List<DatedThing> absTimes = null;
        ArrayList<DateTime> allTimes = new ArrayList<DateTime>();
        List<DateTime> selectedTimes = null;
        try {
            absTimes = this.makeDatedObjects(this.getAbsoluteTimes());
            for (DatedThing od : absTimes) {
                Date de = ((DatedObject)od).getDate();
                allTimes.add(new DateTime(de));
            }
            selectedTimes = DataUtil.selectTimesFromList(allTimes, dtimes);
            List<DatedThing> newAbsoluteTimes = this.makeDatedObjects(selectedTimes);
            int size = newAbsoluteTimes.size();
            if (size >= 1) {
                Date endDate = newAbsoluteTimes.get(size - 1).getDate();
                int index = Math.max(0, size - this.getNumTimesToSelect());
                Date startDate = newAbsoluteTimes.get(index).getDate();
                this.getTimeLine().setDateSelection(new Date[]{startDate, endDate});
            }
            int[] indices = new int[selectedTimes.size()];
            for (int i = 0; i < selectedTimes.size(); ++i) {
                if (newAbsoluteTimes.get(i) instanceof DatedThing && allTimes.get(i) instanceof DatedThing) {
                    System.out.println("dd");
                }
                indices[i] = allTimes.indexOf(selectedTimes.get(i));
            }
            this.setSelectedAbsoluteTimes(indices);
            this.absoluteTimesSelectionChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getNumTimesToSelect() {
        return 5;
    }

    protected boolean getHaveAbsoluteTimesSelected() {
        if (this.usingTimeline) {
            return this.timeline.getSelected().size() > 0;
        }
        return this.getTimesList().haveDataSelected();
    }

    protected Timeline getTimeLine() {
        return this.timeline;
    }

    protected List getAbsoluteTimes() {
        return DatedObject.getObjects(this.absoluteTimes);
    }

    protected List getTimeDrivers() {
        return this.timeDrivers;
    }

    protected List getSelectedAbsoluteTimes() {
        if (this.usingTimeline) {
            return DatedObject.getObjects(this.timeline.getSelected());
        }
        return DatedObject.getObjects(Misc.toList(this.getTimesList().getSelectedValues()));
    }

    protected void setSelectedAbsoluteTimes(List selectedTimes) {
        selectedTimes = this.makeDatedObjects(selectedTimes);
        List allTimes = this.absoluteTimes;
        int[] indices = new int[selectedTimes.size()];
        for (int i = 0; i < selectedTimes.size(); ++i) {
            indices[i] = allTimes.indexOf(selectedTimes.get(i));
        }
        this.setSelectedAbsoluteTimes(indices);
    }

    protected void setSelectedAbsoluteTimes(int[] indices) {
        if (Misc.arraysEquals(this.currentSelectedAbsoluteTimes, indices)) {
            return;
        }
        this.currentSelectedAbsoluteTimes = indices;
        this.pushIgnore();
        if (this.usingTimeline) {
            ArrayList selected = new ArrayList();
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] < 0 || indices[i] >= this.absoluteTimes.size()) continue;
                selected.add(this.absoluteTimes.get(indices[i]));
            }
            this.timeline.setSelected(selected);
        }
        if (!Misc.arraysEquals(this.getTimesList().getSelectedIndices(), indices)) {
            this.getTimesList().setSelectedIndices(indices);
            int selectedIndex = this.getTimesList().getSelectedIndex();
            if (selectedIndex >= 0) {
                this.getTimesList().ensureIndexIsVisible(selectedIndex);
            }
        }
        if (this.currentSelectedAbsoluteTimes == null || this.currentSelectedAbsoluteTimes.length == 0) {
            this.absTimesLbl.setText(" No times selected");
        } else if (this.currentSelectedAbsoluteTimes.length == 1) {
            this.absTimesLbl.setText(" 1 time selected");
        } else {
            this.absTimesLbl.setText(" " + this.currentSelectedAbsoluteTimes.length + " times selected");
        }
        this.popIgnore();
    }

    protected void setSelectedAbsoluteTime(int selectedIndex) {
        this.setSelectedAbsoluteTimes(new int[]{selectedIndex});
    }

    protected void setSelectedAbsoluteTime(int from, int to) {
        if (from > to) {
            return;
        }
        int[] indices = new int[to - from + 1];
        int cnt = 0;
        int i = from;
        while (i <= to) {
            indices[cnt++] = i++;
        }
        this.setSelectedAbsoluteTimes(indices);
    }

    protected List<DatedThing> makeDatedObjects(List items) {
        ArrayList<DatedObject> datedThings = new ArrayList<DatedObject>();
        try {
            for (int i = 0; i < items.size(); ++i) {
                Object object = items.get(i);
                Date date = null;
                if (object instanceof DatedThing) {
                    return items;
                }
                if (object instanceof AddeImageDescriptor) {
                    AddeImageDescriptor aid = (AddeImageDescriptor)object;
                    DateTime dttm = aid.getImageTime();
                    if (dttm == null) continue;
                    date = new Date((long)dttm.getValue(CommonUnit.secondsSinceTheEpoch) * 1000L);
                } else if (object instanceof DateTime) {
                    DateTime dttm = (DateTime)object;
                    date = new Date((long)dttm.getValue(CommonUnit.secondsSinceTheEpoch) * 1000L);
                }
                if (date == null) continue;
                DatedObject datedThing = new DatedObject(date, object);
                datedThings.add(datedThing);
            }
        }
        catch (Exception exc) {
            this.logException("Making list of dated things", exc);
        }
        return DatedObject.sort(datedThings, true);
    }

    public void popupTimeline() throws Exception {
        List datedObjects = this.absoluteTimes;
        if (datedObjects.size() == 0) {
            LogUtil.userMessage("No times in list");
            return;
        }
        List selected = new ArrayList<DatedObject>();
        List selectedTimes = this.getSelectedAbsoluteTimes();
        for (int i = 0; i < datedObjects.size(); ++i) {
            DatedObject datedObject = (DatedObject)datedObjects.get(i);
            if (!selectedTimes.contains(datedObject.getObject())) continue;
            selected.add(datedObject);
        }
        if (this.popupTimeline == null) {
            this.popupTimeline = new IdvTimeline(datedObjects, 400);
            this.popupTimeline.setUseDateSelection(false);
            DateSelection dateSelection = new DateSelection(this.popupTimeline.getStartDate(), this.popupTimeline.getEndDate());
            this.popupTimeline.setDateSelection(dateSelection);
        } else {
            this.popupTimeline.setDatedThings(datedObjects, true);
        }
        DatedThing endDate = null;
        DatedThing startDate = null;
        if (selected.size() > 0) {
            List tmp = DatedObject.sort(selected, true);
            endDate = (DatedThing)tmp.get(tmp.size() - 1);
            if (selected.size() == 1) {
                int index = datedObjects.indexOf(endDate);
                if (index >= 0) {
                    index = Math.max(0, index - 10);
                    startDate = (DatedThing)datedObjects.get(index);
                }
            } else {
                startDate = (DatedThing)tmp.get(0);
            }
        } else if (datedObjects.size() > 0) {
            endDate = (DatedThing)datedObjects.get(datedObjects.size() - 1);
            int index = Math.max(0, datedObjects.size() - 10);
            startDate = (DatedThing)datedObjects.get(index);
        }
        if (endDate != null && startDate != null) {
            this.popupTimeline.setStartDate(startDate.getDate());
            this.popupTimeline.setEndDate(endDate.getDate());
            this.popupTimeline.expandByPercent(1.2, false);
            this.popupTimeline.makeCurrentRangeOriginal();
        }
        this.popupTimeline.setSelected(selected);
        if (!this.popupTimeline.popup()) {
            return;
        }
        selected = this.popupTimeline.getSelected();
        int[] selectedIndices = new int[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            DatedObject datedObject = (DatedObject)selected.get(i);
            selectedIndices[i] = datedObjects.indexOf(datedObject);
        }
        this.setSelectedAbsoluteTimes(selectedIndices);
    }

    protected JComponent getExtraAbsoluteTimeComponent() {
        return new JPanel();
    }

    protected JComponent getExtraRelativeTimeComponent() {
        return new JPanel();
    }

    protected JComponent getExtraTimeComponent() {
        JPanel timesExtra = new JPanel();
        return timesExtra;
    }

    private void popupTimesMenu(JComponent near) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    DateTime[] times = (DateTime[])ae.getSource();
                    TimesChooser.this.setSelectedTimes(times);
                }
                catch (Exception exc) {
                    TimesChooser.this.logException("Setting times", exc);
                }
            }
        };
        List menuItems = this.makeTimeMenus(listener);
        if (menuItems.size() == 0) {
            menuItems.add(new JMenuItem("No times in displays"));
        }
        GuiUtils.showPopupMenu(menuItems, near);
    }

    protected void setSelectedTimes(DateTime[] times) {
    }

    protected int getDefaultRelativeTimeIndex() {
        return 0;
    }

    protected int getDefaultTimeDriverIndex() {
        return 0;
    }

    protected boolean haveTimeSelected() {
        return !this.getDoAbsoluteTimes() || this.getHaveAbsoluteTimesSelected();
    }

    public float getRelativeTimeIncrement() {
        return 1.0f;
    }

    public JComponent getRelativeTimesChooser() {
        return this.getRelativeTimesList().getScroller();
    }

    public int[] getRelativeTimeIndices() {
        int count = this.getRelativeTimesList().getSelectedIndex() + 1;
        int[] indices = new int[count];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    protected boolean getDoAbsoluteTimes() {
        return this.doAbsoluteTimes;
    }

    protected boolean getDoTimeDrivers() {
        return this.doTimeDrivers;
    }

    protected void setDoTimeDrivers(boolean value) {
        this.doTimeDrivers = value;
    }

    protected void setDoAbsoluteTimes(boolean yesorno) {
        this.doAbsoluteTimes = yesorno;
        if (this.timesTab != null) {
            if (yesorno) {
                this.timesTab.setSelectedIndex(1);
            } else {
                this.timesTab.setSelectedIndex(0);
            }
        }
    }

    protected boolean getDoRelativeTimes() {
        return !this.getDoAbsoluteTimes();
    }

    protected void enableWidgets() {
        this.checkTimesLists();
    }

    protected void enableTimeWidgets() {
        if (this.timesCardPanel == null) {
            return;
        }
        GuiUtils.enableTree(this.timesTab, true);
        GuiUtils.enableTree(this.timeline, true);
        this.drivercbx.setSelected(false);
        this.checkTimesLists();
    }

    protected void disableTimeWidgets() {
        if (this.timesCardPanel == null) {
            return;
        }
        this.enableAbsoluteTimesList(false);
        this.getRelativeTimesChooser().setEnabled(false);
        this.timesCardPanel.setEnabled(false);
        GuiUtils.enableTree(this.timesTab, false);
        GuiUtils.enableTree(this.timeline, false);
        GuiUtils.enableTree(this.timeDriverComp, true);
    }

    protected void checkTimesLists() {
        if (this.timesCardPanel == null) {
            return;
        }
        if (this.getDoAbsoluteTimes()) {
            this.timesCardPanel.show("absolute");
        } else {
            this.timesCardPanel.show("relative");
        }
    }

    public static void addTimeSelectionListener(final JList list, final Timeline timeline) {
        list.addMouseListener(new PopupTriggerListener(){

            @Override
            public void showPopup(MouseEvent e) {
                TimesChooser.popupTimeSelection(e, list, timeline);
            }
        });
        if (list.getToolTipText() == null) {
            list.setToolTipText("Use right mouse to show range selection popup menu");
        }
    }

    private static void popupTimeSelection(MouseEvent e, final JList list, final Timeline timeline) {
        if (!list.isEnabled()) {
            return;
        }
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        List dates = GuiUtils.getItems(list);
        if (dates.size() > 0 && dates.get(0) instanceof DateTime) {
            JMenuItem menuItem = new JMenuItem("Show Timeline");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Misc.runInABit(1L, new Runnable(){

                        @Override
                        public void run() {
                            TimesChooser.showTimelineDialog(list, timeline);
                        }
                    });
                }
            });
            items.add(menuItem);
        }
        GuiUtils.getConfigureStepSelectionItems(list, items);
        JPopupMenu popup = GuiUtils.makePopupMenu(items);
        popup.show(list, e.getX(), e.getY());
    }

    private static void showTimelineDialog(JList list, Timeline timeline) {
        try {
            DateSelection dateSelection;
            if (timeline == null) {
                timeline = new Timeline();
            }
            ArrayList<Object> selected = new ArrayList<Object>();
            Object[] tmp = list.getSelectedValues();
            for (int i = 0; i < tmp.length; ++i) {
                selected.add(new DatedObject(Util.makeDate((DateTime)tmp[i])));
            }
            final JDialog dialog = GuiUtils.createDialog(GuiUtils.getWindow(list), "", true);
            dialog.setUndecorated(true);
            final boolean[] ok = new boolean[]{false};
            List dates = GuiUtils.getItems(list);
            ArrayList<DatedObject> datedThings = new ArrayList<DatedObject>();
            for (DateTime dttm : dates) {
                datedThings.add(new DatedObject(Util.makeDate(dttm)));
            }
            timeline.setDatedThings(datedThings, true);
            if (selected.size() == dates.size()) {
                dateSelection = new DateSelection(timeline.getStartDate(), timeline.getEndDate());
            } else if (selected.size() == 0) {
                Date end = new Date(timeline.getStartDate().getTime() + 3600000L);
                dateSelection = new DateSelection(timeline.getStartDate(), end);
            } else {
                dateSelection = new DateSelection(((DatedObject)selected.get(0)).getDate(), ((DatedObject)selected.get(selected.size() - 1)).getDate());
            }
            timeline.setSelected(selected);
            timeline.setUseDateSelection(true);
            timeline.setDateSelection(dateSelection);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (ae.getActionCommand().equals(GuiUtils.CMD_OK)) {
                        ok[0] = true;
                    }
                    dialog.dispose();
                }
            };
            JPanel buttons = GuiUtils.makeOkCancelButtons(listener);
            JPanel contents = GuiUtils.centerBottom(timeline, buttons);
            buttons.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
            contents.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
            dialog.getContentPane().add(contents);
            dialog.pack();
            Point loc = list.getLocationOnScreen();
            dialog.setLocation(loc);
            GuiUtils.positionAndFitToScreen(dialog, dialog.getBounds());
            dialog.setVisible(true);
            if (ok[0]) {
                selected = new ArrayList();
                for (Date dttm : DatedObject.unwrap(timeline.getSelected())) {
                    selected.add(new DateTime(dttm));
                }
                if (selected.size() == 0) {
                    list.setSelectedIndices(new int[0]);
                } else {
                    GuiUtils.setSelectedItems(list, selected);
                }
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Showing timeline dialog", exc);
        }
    }
}

