/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.XmlChooser;
import ucar.unidata.idv.chooser.XmlHandler;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.XmlTree;
import ucar.unidata.util.CatalogUtil;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlUtil;

public class ThreddsHandler
extends XmlHandler {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(ThreddsHandler.class.getName());
    public static final String NULL_STRING = null;
    private JComboBox dataSourcesCbx;
    private JCheckBox loadIndividuallyCbx;
    private JCheckBox showThumbsCbx;
    private Hashtable<String, ImageIcon> thumbnails = new Hashtable();
    private HashSet pendingImageUrls = new HashSet();
    private ImageIcon remoteIcon;
    private ImageIcon datasetIcon;
    int cnt = 0;

    public ThreddsHandler(XmlChooser chooser, Element root, String path) {
        super(chooser, root, path);
        root.setAttribute("catalogurl", path);
    }

    @Override
    protected void updateStatus() {
        if (this.chooser.getHaveData()) {
            this.chooser.setStatus("Press \"" + "Add Source" + "\" to load the selected data", "buttons");
        } else {
            this.chooser.setStatus("Please select a dataset from the catalog");
        }
    }

    protected String getDocumentationLabel(Element node) {
        String type = XmlUtil.getAttribute((Node)node, "type", "");
        if (type.equals("summary")) {
            String text = XmlUtil.getChildText(node);
            if (text != null && text.length() < 50) {
                return "Summary: " + text;
            }
            return "Summary";
        }
        if (type.equals("rights")) {
            String text = XmlUtil.getChildText(node);
            if (text != null && text.length() < 50) {
                return "Rights: " + text;
            }
            return "Rights";
        }
        String title = XmlUtil.getAttribute((Node)node, "xlink:title", (String)null);
        if (title != null) {
            return title;
        }
        return "Documentation";
    }

    protected String getDocumentationToolTip(Element node) {
        String text = null;
        String title = null;
        String type = XmlUtil.getAttribute((Node)node, "type", "");
        if (type.equals("summary")) {
            text = XmlUtil.getChildText(node);
            title = "Summary";
        } else if (type.equals("rights")) {
            text = XmlUtil.getChildText(node);
            title = "Rights";
        } else {
            return null;
        }
        return "<html><b>" + title + "</b><hr>" + StringUtil.breakText(text, "<br>", 50) + "</html>";
    }

    private void shuffleDocNodes(Element node, Document doc) {
        if (XmlUtil.isTag(node, "documentation")) {
            return;
        }
        ArrayList<Element> docNodes = null;
        List children = XmlUtil.findChildren(node, null);
        for (int i = 0; i < children.size(); ++i) {
            Object tmp = children.get(i);
            if (!(tmp instanceof Element)) continue;
            Element child = (Element)tmp;
            if (XmlUtil.isTag(child, "documentation")) {
                node.removeChild(child);
                if (XmlUtil.getAttribute((Node)child, "xlink:title", "").indexOf("Imported from") >= 0) continue;
                if (docNodes == null) {
                    docNodes = new ArrayList<Element>();
                }
                docNodes.add(child);
                continue;
            }
            this.shuffleDocNodes(child, doc);
        }
        if (docNodes != null && docNodes.size() > 0) {
            if (docNodes.size() == 1) {
                node.appendChild((Element)docNodes.get(0));
            } else {
                Element newDocNode = doc.createElement("docparent");
                node.appendChild(newDocNode);
                for (int i = 0; i < docNodes.size(); ++i) {
                    newDocNode.appendChild((Element)docNodes.get(i));
                }
            }
        }
    }

    @Override
    protected JComponent doMakeContents() {
        this.showThumbsCbx = new JCheckBox("Show Thumbnail Images", !GuiUtils.isMac());
        this.showThumbsCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ThreddsHandler.this.updateTree();
            }
        });
        double version = CatalogUtil.getVersion(this.root);
        this.shuffleDocNodes(this.root, this.chooser.getDocument());
        this.loadIndividuallyCbx = new JCheckBox("Load Multiples Separately", false);
        this.loadIndividuallyCbx.setToolTipText("<html>You can select multiple data sets with a control-click.<br>When this checkbox is selected the IDV loads each one separately.<br>When unchecked the IDV tries to load them as a single data source<br>(e.g., as multiple times)</html>");
        this.dataSourcesCbx = XmlChooser.getDataSourcesComponent(false, this.chooser.getDataManager());
        JPanel dsComp = GuiUtils.inset((Component)GuiUtils.hbox((Component)new JLabel("Data Source Type: "), (Component)this.dataSourcesCbx, 5), 5);
        this.tree = new XmlTree(this.root, true, this.path){

            @Override
            public ImageIcon getIconForNode(Element node) {
                if (ThreddsHandler.this.remoteIcon == null) {
                    ThreddsHandler.this.datasetIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/folderclosed.png");
                    ThreddsHandler.this.remoteIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/remotecatalog.png");
                }
                if (XmlUtil.isTag(node, "catalogRef")) {
                    return ThreddsHandler.this.remoteIcon;
                }
                List propertyNodes = XmlUtil.findChildren(node, "property");
                String[] ids = ThreddsHandler.this.showThumbsCbx.isSelected() ? new String[]{"thumbnail", "icon"} : new String[]{"icon"};
                for (String id : ids) {
                    for (Element propertyNode : propertyNodes) {
                        String name = XmlUtil.getAttribute((Node)propertyNode, "name", "");
                        if (!name.equals(id)) continue;
                        String imageUrl = XmlUtil.getAttribute((Node)propertyNode, "value", "");
                        ImageIcon icon = (ImageIcon)ThreddsHandler.this.thumbnails.get(imageUrl);
                        if (icon == null) {
                            if (!ThreddsHandler.this.pendingImageUrls.contains(imageUrl)) {
                                ThreddsHandler.this.pendingImageUrls.add(imageUrl);
                                Misc.run(ThreddsHandler.this, "fetchImages", new String[]{id, imageUrl});
                            }
                            return super.getIconForNode(node);
                        }
                        return icon;
                    }
                }
                NodeList elements = XmlUtil.getElements(node);
                for (int i = 0; i < elements.getLength(); ++i) {
                    Element child = (Element)elements.item(i);
                    if (!XmlUtil.isTag(child, "dataset") && !XmlUtil.isTag(child, "catalogRef")) continue;
                    return ThreddsHandler.this.datasetIcon;
                }
                return super.getIconForNode(node);
            }

            @Override
            protected Document readXlinkXml(String href) throws Exception {
                Document doc = XmlUtil.getDocument(href, this.getClass());
                if (doc == null) {
                    LogUtil.userErrorMessage("Could not load catalog: " + href);
                    return null;
                }
                if (XmlUtil.isTag(doc.getDocumentElement(), "catalog")) {
                    return doc;
                }
                ThreddsHandler.this.chooser.makeUi(doc, doc.getDocumentElement(), href);
                return null;
            }

            @Override
            protected int getXlinkImportLevel() {
                return 2;
            }

            @Override
            protected boolean initXlinkRoot(Element root, Document doc, String url) {
                ThreddsHandler.this.shuffleDocNodes(root, doc);
                root.setAttribute("catalogurl", url);
                return true;
            }

            @Override
            public String getToolTipText(Element n) {
                ArrayList paths;
                if (XmlUtil.isTag(n, "documentation")) {
                    return ThreddsHandler.this.getDocumentationToolTip(n);
                }
                if (XmlUtil.isTag(n, "catalogRef")) {
                    String href = XmlUtil.getAttribute((Node)n, "xlink:href", (String)null);
                    if (href == null) {
                        return "Remote catalog: none defined";
                    }
                    return "Remote catalog: " + ThreddsHandler.this.tree.expandRelativeUrl(href);
                }
                if (XmlUtil.isTag(n, "dataset") && ThreddsHandler.this.collectUrlPaths(paths = new ArrayList(), n, ThreddsHandler.this.root, false) && paths.size() > 0) {
                    XmlChooser.PropertiedAction pa = (XmlChooser.PropertiedAction)paths.get(0);
                    String thumbnail = null;
                    List propertyNodes = XmlUtil.findChildren(n, "property");
                    for (Element propertyNode : propertyNodes) {
                        String name = XmlUtil.getAttribute((Node)propertyNode, "name", "");
                        if (!name.equals("thumbnail")) continue;
                        String value = XmlUtil.getAttribute((Node)propertyNode, "value", "");
                        thumbnail = "<img src=\"" + value + "\">";
                        break;
                    }
                    if (ThreddsHandler.this.showThumbsCbx.isSelected() && thumbnail != null) {
                        return "<html>Url: " + pa.action + "<br>" + thumbnail + "</html>";
                    }
                    return "Url: " + pa.action;
                }
                return super.getToolTipText(n);
            }

            @Override
            public String getLabel(Element n) {
                if (XmlUtil.isTag(n, "documentation")) {
                    return ThreddsHandler.this.getDocumentationLabel(n);
                }
                if (XmlUtil.isTag(n, "docparent")) {
                    return "Documentation";
                }
                String lbl = super.getLabel(n);
                lbl = lbl.replace("_", " ");
                return lbl;
            }

            @Override
            public void doDoubleClick(XmlTree theTree, XmlTree.XmlTreeNode node, Element element) {
                if (node instanceof XmlTree.XlinkTreeNode) {
                    XmlTree.XlinkTreeNode xn = (XmlTree.XlinkTreeNode)node;
                    if (xn.getHaveLoaded()) {
                        String href = xn.getHref();
                        href = theTree.expandRelativeUrl(node, href);
                        ThreddsHandler.this.chooser.makeUiFromPath(href);
                    }
                    return;
                }
                ThreddsHandler.this.processNodeInThread(element);
            }

            @Override
            public void doClick(XmlTree theTree, XmlTree.XmlTreeNode node, Element element) {
                List elements = ThreddsHandler.this.tree.getSelectedElements();
                boolean haveData = false;
                for (int i = 0; i < elements.size() && !haveData; ++i) {
                    haveData = CatalogUtil.getUrlPath((Element)elements.get(i)) != null;
                }
                ThreddsHandler.this.chooser.setHaveData(haveData);
            }

            @Override
            public void doRightClick(XmlTree theTree, XmlTree.XmlTreeNode node, Element element, MouseEvent event) {
                JPopupMenu popup = new JPopupMenu();
                if (ThreddsHandler.this.makePopupMenu(theTree, element, popup, node)) {
                    popup.show((Component)event.getSource(), event.getX(), event.getY());
                }
            }

            @Override
            protected void expandXlink(XmlTree.XlinkTreeNode node, String href) {
                ThreddsHandler.this.chooser.showWaitCursor();
                super.expandXlink(node, href);
                ThreddsHandler.this.chooser.showNormalCursor();
            }

            @Override
            public NodeList getXlinkImportElements(Element root) {
                Element child;
                int i;
                NodeList importElements = XmlUtil.getGrandChildren(root);
                for (i = 0; i < importElements.getLength(); ++i) {
                    child = (Element)importElements.item(i);
                    if (!this.shouldProcess(child)) continue;
                    return importElements;
                }
                importElements = XmlUtil.getElements(root);
                for (i = 0; i < importElements.getLength(); ++i) {
                    child = (Element)importElements.item(i);
                    if (!this.shouldProcess(child)) continue;
                    return importElements;
                }
                importElements = new XmlNodeList();
                ((XmlNodeList)importElements).add(root);
                return importElements;
            }
        };
        this.tree.defineLabelAttr("catalogRef", "xlink:title");
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addXlinkTag("catalogRef");
        if (version == 0.4) {
            this.tree.addTagsToProcess(Misc.newList(new Object[]{"catalog", "catalogRef", "collection", "dataset", "documentation"}));
        } else {
            this.tree.addTagsToProcess(Misc.newList(new Object[]{"catalogRef", "collection", "dataset", "documentation", "docparent"}));
            this.tree.addTagsToNotProcessButRecurse(Misc.newList("catalog"));
        }
        this.tree.setIconForTag(GuiUtils.getImageIcon("/auxdata/ui/icons/Information16.gif", this.getClass()), "documentation");
        JPanel ui = GuiUtils.inset((Component)GuiUtils.topCenterBottom(GuiUtils.left(dsComp), this.tree.getScroller(), GuiUtils.right(this.showThumbsCbx)), 5);
        return ui;
    }

    private void updateTree() {
        GuiUtils.invokeInSwingThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreddsHandler.this.tree.updateUI();
                    ThreddsHandler.this.tree.repaint();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    public void fetchImages(String[] tuple) {
        String id = tuple[0];
        String imageUrl = tuple[1];
        Image image = ImageUtils.readImage(imageUrl);
        if (id.equals("thumbnail")) {
            image = ImageUtils.resize(image, 100, -1);
            ImageUtils.waitOnImage(image);
        }
        ImageIcon icon = new ImageIcon(image);
        this.thumbnails.put(imageUrl, icon);
        this.pendingImageUrls.remove(imageUrl);
        this.updateTree();
    }

    private boolean makePopupMenu(final XmlTree theTree, final Element node, JPopupMenu popup, final XmlTree.XmlTreeNode treeNode) {
        String href;
        JMenuItem mi;
        String tagName = XmlUtil.getLocalName(node);
        boolean didone = false;
        if (tagName.equals("dataset") && CatalogUtil.getUrlPath(node) != null) {
            mi = new JMenuItem("Load Dataset");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ThreddsHandler.this.processNodeInThread(node);
                }
            });
            popup.add(mi);
            didone = true;
        }
        if (tagName.equals("documentation")) {
            mi = new JMenuItem("View Documentation");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ThreddsHandler.this.showDocumentation(node);
                }
            });
            popup.add(mi);
            didone = true;
        }
        if (tagName.equals("catalogRef") && (href = XmlUtil.getAttribute((Node)node, "xlink:href", (String)null)) != null) {
            mi = new JMenuItem("Load Remote Catalog");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ThreddsHandler.this.chooser.makeUiFromPath(theTree.expandRelativeUrl(treeNode, href));
                }
            });
            popup.add(mi);
            didone = true;
        }
        mi = new JMenuItem("Write Catalog");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ThreddsHandler.this.saveCatalog(theTree);
            }
        });
        popup.add(mi);
        didone = true;
        return didone;
    }

    private void saveCatalog(XmlTree tree) {
        try {
            String filename = FileManager.getWriteFile(FileManager.FILTER_XML, ".xml");
            if (filename == null) {
                return;
            }
            String xml = this.chooser.getXml();
            IOUtil.writeFile(filename, xml);
        }
        catch (Exception exc) {
            this.chooser.logException("Writing file", exc);
        }
    }

    @Override
    public void doLoad() {
        List elements = this.tree.getSelectedElements();
        this.processNodes(elements);
    }

    private void showDocumentation(Element node) {
        String doc = null;
        String title = null;
        if (XmlUtil.getAttribute((Node)node, "type", "").equals("summary")) {
            doc = XmlUtil.getChildText(node);
            title = "Summary";
        } else if (XmlUtil.getAttribute((Node)node, "type", "").equals("rights")) {
            doc = XmlUtil.getChildText(node);
            title = "Rights";
        } else {
            String xlink = XmlUtil.getAttribute((Node)node, "xlink:href", (String)null);
            if (xlink != null) {
                doc = IOUtil.readContents(xlink, (String)null);
                title = XmlUtil.getAttribute((Node)node, "xlink:title", "");
            }
        }
        if (doc == null) {
            LogUtil.userMessage("Could not find the documentation");
            return;
        }
        if (title == null) {
            title = "Documentation";
        }
        if (doc.indexOf("<html") < 0) {
            doc = StringUtil.breakText(doc, "<br>", 50);
        }
        try {
            doc = doc.replaceAll("(?s)<head>.*</head>", "");
            GuiUtils.showHtmlDialog(doc, title, null);
        }
        catch (Exception exc) {
            this.chooser.logException("Showing documentation", exc);
        }
    }

    private void processNodeInThread(Element node) {
        Misc.run(this, "processNode", node);
    }

    public void processNode(Element node) {
        if (node == null) {
            return;
        }
        this.processNodes(Misc.newList(node));
    }

    private void processNodes(List nodes) {
        double version = CatalogUtil.getVersion(this.root);
        ArrayList<String> urls = new ArrayList<String>();
        Hashtable<String, Object> properties = null;
        for (int i = 0; i < nodes.size(); ++i) {
            Element node = (Element)nodes.get(i);
            if (XmlUtil.isTag(node, "documentation")) {
                this.showDocumentation(node);
                continue;
            }
            if (!XmlUtil.isTag(node, "dataset")) continue;
            if (version == 0.4) {
                this.process04Dataset(node);
                continue;
            }
            if (version >= 0.6) {
                ArrayList urlPaths = new ArrayList();
                if (!this.collectUrlPaths(urlPaths, node, this.root, true)) {
                    return;
                }
                boolean loadAsGroup = true;
                if (!loadAsGroup) {
                    this.chooser.handleActions(urlPaths);
                    continue;
                }
                for (int actionIdx = 0; actionIdx < urlPaths.size(); ++actionIdx) {
                    XmlChooser.PropertiedAction action = (XmlChooser.PropertiedAction)urlPaths.get(actionIdx);
                    if (properties == null) {
                        properties = new Hashtable<String, Object>();
                        if (action.properties != null) {
                            properties.putAll(action.properties);
                        }
                    }
                    properties.put("prop.subproperties" + urls.size(), action.properties);
                    this.chooser.initSubProperties(action.properties);
                    urls.add(action.action);
                }
                continue;
            }
            IdvChooser.errorMessage("Unknown thredds version:" + version);
            return;
        }
        if (urls.size() > 0) {
            String dataSourceId;
            if (properties != null && properties.get("datatypeid") == null && (dataSourceId = this.chooser.getDataSourceId(this.dataSourcesCbx)) != null) {
                properties.put("datatypeid", dataSourceId);
            }
            if (this.chooser.makeDataSource(urls, null, properties)) {
                this.chooser.closeChooser();
            }
        }
    }

    private void process04Dataset(Element datasetNode) {
        String serverId = XmlUtil.getAttribute((Node)datasetNode, "serverID", NULL_STRING);
        if (serverId == null) {
            IdvChooser.errorMessage("No server id found");
            return;
        }
        String urlPath = XmlUtil.getAttribute((Node)datasetNode, "urlPath", NULL_STRING);
        if (urlPath == null) {
            IdvChooser.errorMessage("No urlPath found");
            return;
        }
        Element serverNode = XmlUtil.findElement(this.root, "server", "ID", serverId);
        if (serverNode == null) {
            IdvChooser.errorMessage("No server with id:" + serverId + " found");
            return;
        }
        String base = XmlUtil.getAttribute((Node)serverNode, "base", NULL_STRING);
        if (base == null) {
            IdvChooser.errorMessage("No base found for server:" + serverId);
            return;
        }
        String url = base + urlPath;
        Hashtable properties = new Hashtable();
        this.chooser.handleAction(url, this.getProperties(datasetNode, serverNode));
    }

    private Hashtable getProperties(Element datasetNode, Element serviceNode) {
        return this.getProperties(datasetNode, serviceNode, new Hashtable());
    }

    private Hashtable getProperties(Element datasetNode, Element serviceNode, Hashtable properties) {
        String dataType;
        List docLinks;
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        if ((docLinks = this.getDocLinks(datasetNode, null)) != null && docLinks.size() > 0) {
            properties.put("documentlinks", docLinks);
        }
        if ((dataType = CatalogUtil.findDataTypeForDataset(datasetNode, this.root, CatalogUtil.getVersion(this.root), true)) != null && (dataType.equals("unknown") || dataType.trim().length() == 0)) {
            dataType = null;
        }
        String serviceType = CatalogUtil.getServiceType(serviceNode);
        String dataSourceId = this.chooser.getDataSourceId(this.dataSourcesCbx);
        if (dataSourceId != null) {
            properties.put("datatypeid", dataSourceId);
        } else if (dataType != null && serviceType != null && !serviceType.equals("Resolver")) {
            properties.put("datatypeid", serviceType + "." + dataType);
        } else if (serviceType != null || dataType != null) {
            // empty if block
        }
        String title = CatalogUtil.getTitleFromDataset(datasetNode);
        if (title != null) {
            properties.put("TITLE", title);
        }
        return properties;
    }

    private List getDocLinksDown(Element docNode, List list) {
        String link = XmlUtil.getAttribute((Node)docNode, "xlink:href", (String)null);
        if (XmlUtil.isTag(docNode, "documentation")) {
            if (link != null) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(link);
            } else {
                String text;
                String type = XmlUtil.getAttribute((Node)docNode, "type", (String)null);
                if (type != null && type.equals("summary") && (text = XmlUtil.getChildText(docNode)) != null && text.trim().length() > 0) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add("<b>Summary:</b><hr>" + text);
                }
            }
        }
        XmlNodeList elements = XmlUtil.getElements(docNode, (String)null);
        for (int i = 0; i < elements.getLength(); ++i) {
            Element child = (Element)elements.item(i);
            list = this.getDocLinksDown(child, list);
        }
        return list;
    }

    private List getDocLinks(Node node, List list) {
        Node parent;
        if (node instanceof Element) {
            XmlNodeList elements = XmlUtil.getElements((Element)node, (String)null);
            for (int i = 0; i < elements.getLength(); ++i) {
                Element child = (Element)elements.item(i);
                if (!XmlUtil.isTag(child, "documentation") && !XmlUtil.isTag(child, "docparent")) continue;
                list = this.getDocLinksDown(child, list);
            }
        }
        if ((parent = node.getParentNode()) != null) {
            list = this.getDocLinks(parent, list);
        }
        return list;
    }

    public String getPropertyAttributeFromChild(Element parent, String nameValueLookingFor, String dflt) {
        if (parent == null) {
            return dflt;
        }
        XmlNodeList elements = XmlUtil.getElements(parent, "property");
        for (int i = 0; i < elements.getLength(); ++i) {
            String valueValue;
            Node child = elements.item(i);
            String nameValue = XmlUtil.getAttribute(child, "name", (String)null);
            if (nameValue == null || !nameValue.equals(nameValueLookingFor) || (valueValue = XmlUtil.getAttribute(child, "value", (String)null)) == null) continue;
            return valueValue;
        }
        Node nextParent = parent.getParentNode();
        if (nextParent instanceof Element) {
            return this.getPropertyAttributeFromChild((Element)nextParent, nameValueLookingFor, dflt);
        }
        return dflt;
    }

    private boolean collectUrlPaths(List urlPaths, Element datasetNode, Element root, boolean flagMissing) {
        Hashtable<String, String> properties;
        String url;
        String urlPath = CatalogUtil.getUrlPath(datasetNode);
        if (urlPath != null) {
            String datasetId;
            Element serviceNode = null;
            if (urlPath.indexOf("://") >= 0 || new File(urlPath).exists()) {
                url = urlPath;
            } else {
                serviceNode = CatalogUtil.findServiceNodeForDataset(datasetNode, flagMissing, null);
                if (serviceNode == null) {
                    return false;
                }
                url = CatalogUtil.getAbsoluteUrl(serviceNode, urlPath);
                if (url == null) {
                    if (flagMissing) {
                        IdvChooser.errorMessage("Could not read any dataset urls");
                    }
                    return false;
                }
            }
            properties = new Hashtable<String, String>();
            properties.put("Thredds.CatalogUrl", this.path);
            String groupId = this.getPropertyAttributeFromChild(datasetNode, "group", null);
            if (groupId != null) {
                properties.put("Thredds.DataGroup", groupId);
            }
            if ((datasetId = XmlUtil.getAttribute((Node)datasetNode, "id", (String)null)) != null) {
                properties.put("Thredds.DataSetId", datasetId);
            }
            List propertyNodes = XmlUtil.findChildren(datasetNode, "property");
            for (Element propertyNode : propertyNodes) {
                properties.put(XmlUtil.getAttribute(propertyNode, "name"), XmlUtil.getAttribute(propertyNode, "value"));
            }
            CatalogUtil.addServiceProperties(datasetNode, properties, urlPath);
            if (serviceNode != null) {
                String serviceType = CatalogUtil.getServiceType(serviceNode);
                this.getProperties(datasetNode, serviceNode, properties);
                if ("Resolver".equals(serviceType)) {
                    String resolverUrl = url;
                    Object[] result = CatalogUtil.getResolverData(resolverUrl, properties);
                    if (result == null) {
                        return false;
                    }
                    datasetNode = (Element)result[1];
                    serviceNode = (Element)result[2];
                    url = (String)result[3];
                    properties.put("RESOLVERURL", resolverUrl);
                    String title = CatalogUtil.getTitleFromDataset(datasetNode);
                    if (title != null && properties != null) {
                        properties.put("TITLE", title);
                    }
                }
            }
        } else {
            if (flagMissing) {
                IdvChooser.errorMessage("No url path found for dataset.");
            }
            return false;
        }
        urlPaths.add(new XmlChooser.PropertiedAction(url, properties));
        return true;
    }

    public static void main(String[] args) throws Exception {
        String doc = IOUtil.readContents("test.html", ThreddsHandler.class);
        doc = "hello<head>\nxxx</head>";
        doc = doc.replaceAll("(?s)<head>.+</head>", "");
        System.err.println("doc:" + doc);
    }
}

