/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.w3c.dom.Element;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.units.DateUnit;
import ucar.unidata.data.radar.RadarQuery;
import ucar.unidata.data.radar.TDSRadarDatasetCollection;
import ucar.unidata.geoloc.Station;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.TimesChooser;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PreferenceList;
import ucar.unidata.util.Product;
import ucar.unidata.util.TwoFacedObject;
import visad.CommonUnit;
import visad.DateTime;
import visad.georef.NamedLocation;

public class TDSRadarChooser1
extends TimesChooser {
    private JComponent outerContents;
    private TDSRadarDatasetCollection collection;
    private NamedStation selectedStation;
    private String selectedProduct;
    private String serverUrl;
    private JComboBox collectionSelector;
    private JComboBox productComboBox;
    private JComponent productLabel;
    private List compsThatNeedServer = new ArrayList();
    private List level3CompsThatNeedServer = new ArrayList();
    private PreferenceList urlListHandler;
    private JComboBox urlBox;
    private boolean okToDoUrlListEvents = true;
    private List datasetList;
    protected static final String CMD_CONNECT = "cmd.connect";
    private boolean isLevel3;
    public static final String[] level3_ExName = new String[]{"NVW", "DPA"};
    private boolean ignoreProductChange = false;
    protected static final String LABEL_SELECT = " -- Select -- ";

    public TDSRadarChooser1(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    public void doUpdate() {
        if (this.serverUrl == null || this.datasetList == null || this.datasetList.size() == 0 || this.selectedProduct == null) {
            if (this.urlBox != null) {
                this.setServer((String)this.urlBox.getSelectedItem());
            }
            return;
        }
        Misc.run(this, "stationOrProductChanged");
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        if (this.selectedStation == null) {
            this.setHaveData(false);
            this.setStatus("Please select a station", "stations");
            return;
        }
        if (this.isLevel3 && this.selectedProduct == null) {
            this.setHaveData(false);
            this.setStatus("Please select a level 3 product", "products");
            return;
        }
        boolean haveTimesSelected = this.getDoAbsoluteTimes() ? this.getSelectedAbsoluteTimes().size() > 0 : true;
        this.setHaveData(haveTimesSelected);
        if (haveTimesSelected) {
            this.setStatus("Press \"Add Source\" to load the selected radar data", "buttons");
        } else {
            this.setStatus("Please select times", "timepanel");
        }
    }

    @Override
    protected void newSelectedStations(List stations) {
        super.newSelectedStations(stations);
        if (stations == null || stations.size() == 0) {
            this.selectedStation = null;
        } else {
            NamedStation newStation = (NamedStation)stations.get(0);
            if (Misc.equals(newStation, this.selectedStation)) {
                return;
            }
            this.selectedStation = newStation;
        }
        Misc.run(this, "stationOrProductChanged");
    }

    @Override
    protected JComponent doMakeContents() {
        this.urlListHandler = this.getPreferenceList("idv.data.tds.radar.servers");
        ActionListener catListListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!TDSRadarChooser1.this.okToDoUrlListEvents) {
                    return;
                }
                TDSRadarChooser1.this.setServer((String)TDSRadarChooser1.this.urlBox.getSelectedItem());
            }
        };
        this.urlBox = this.urlListHandler.createComboBox(GuiUtils.CMD_UPDATE, catListListener, true);
        this.collectionSelector = new JComboBox();
        this.collectionSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TDSRadarChooser1.this.collectionSelector.getSelectedItem() == null) {
                    return;
                }
                String collectionUrl = TwoFacedObject.getIdString(TDSRadarChooser1.this.collectionSelector.getSelectedItem());
                if (collectionUrl.contains("level3")) {
                    TDSRadarChooser1.this.setLevel3Collection(collectionUrl);
                } else {
                    TDSRadarChooser1.this.setCollection(collectionUrl);
                }
            }
        });
        this.productLabel = this.addLevel3ServerComp(GuiUtils.rLabel("Product:"));
        this.productComboBox = new JComboBox();
        this.productComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TDSRadarChooser1.this.productComboBox.getSelectedItem() == null) {
                    return;
                }
                TDSRadarChooser1.this.selectedProduct = TDSRadarChooser1.this.productComboBox.getSelectedItem().toString();
                TDSRadarChooser1.this.resetProductBox();
                TDSRadarChooser1.this.productChanged();
            }
        });
        this.addLevel3ServerComp(this.productComboBox);
        JComponent stationMap = this.getStationMap();
        JComponent buttons = this.getDefaultButtons();
        JComponent timesPanel = this.makeTimesPanel(true, true);
        GuiUtils.tmpInsets = GRID_INSETS;
        JPanel top = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Catalog:"), this.urlBox}, 2, GuiUtils.WT_NYNY, GuiUtils.WT_N);
        JPanel topb = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Collections:"), GuiUtils.hbox(this.collectionSelector, GuiUtils.filler()), GuiUtils.hbox(this.productLabel, GuiUtils.filler()), GuiUtils.hbox(this.productComboBox, GuiUtils.filler())}, 4, GuiUtils.WT_NYNY, GuiUtils.WT_N);
        GuiUtils.tmpInsets = new Insets(0, 2, 0, 2);
        stationMap.setPreferredSize(new Dimension(230, 200));
        stationMap = this.registerStatusComp("stations", stationMap);
        timesPanel = this.registerStatusComp("timepanel", timesPanel);
        this.addServerComp(stationMap);
        this.addServerComp(timesPanel);
        JPanel contents = GuiUtils.doLayout(new Component[]{top, topb, stationMap, timesPanel}, 1, GuiUtils.WT_Y, new double[]{0.5, 0.25, 4.0, 1.0});
        contents = GuiUtils.inset((Component)contents, 5);
        GuiUtils.enableComponents(this.compsThatNeedServer, false);
        GuiUtils.enableComponents(this.level3CompsThatNeedServer, false);
        this.outerContents = GuiUtils.center(GuiUtils.topCenterBottom(this.getStatusComponent(), contents, buttons));
        return this.outerContents;
    }

    protected void productChanged() {
        this.stationOrProductChanged();
    }

    private void resetProductBox() {
        this.ignoreProductChange = true;
        this.productComboBox.setSelectedItem(LABEL_SELECT);
        this.ignoreProductChange = false;
    }

    @Override
    protected boolean shouldDoUpdateOnFirstDisplay() {
        return true;
    }

    private void setServer(String s) {
        this.datasetList = new ArrayList();
        this.serverUrl = s;
        try {
            List collections = this.getRadarCollections(this.serverUrl);
            GuiUtils.setListData(this.collectionSelector, collections);
        }
        catch (Exception e) {
            GuiUtils.setListData(this.collectionSelector, new ArrayList());
        }
    }

    private void setCollection(String s) {
        GuiUtils.enableComponents(this.level3CompsThatNeedServer, false);
        this.isLevel3 = false;
        GuiUtils.enableComponents(this.compsThatNeedServer, true);
        this.setAbsoluteTimes(new ArrayList());
        this.selectedStation = null;
        Misc.run(this, "initializeCollection", s);
    }

    private void setLevel3Collection(String s) {
        this.isLevel3 = true;
        GuiUtils.enableComponents(this.level3CompsThatNeedServer, true);
        GuiUtils.enableComponents(this.compsThatNeedServer, true);
        this.setAbsoluteTimes(new ArrayList());
        this.selectedProduct = null;
        this.selectedStation = null;
        Misc.run(this, "initializeLevel3Collection", s);
    }

    protected JComponent addServerComp(JComponent comp) {
        this.compsThatNeedServer.add(comp);
        return comp;
    }

    protected JComponent addLevel3ServerComp(JComponent comp) {
        this.level3CompsThatNeedServer.add(comp);
        return comp;
    }

    private List getRadarCollections(String radarServerURL) {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        ArrayList<TwoFacedObject> collections = new ArrayList<TwoFacedObject>();
        try {
            doc = builder.build(radarServerURL);
        }
        catch (JDOMException e) {
            TDSRadarChooser1.userMessage("Invalid catalog");
        }
        catch (IOException e) {
            TDSRadarChooser1.userMessage("Unable to open catalog");
        }
        org.jdom2.Element rootElem = doc.getRootElement();
        org.jdom2.Element serviceElem = this.readElements(rootElem, "service");
        String uriBase = serviceElem.getAttributeValue("base");
        org.jdom2.Element dsElem = this.readElements(rootElem, "dataset");
        String naming = "catalogRef";
        Namespace nss = rootElem.getNamespace("xlink");
        List<org.jdom2.Element> children = dsElem.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            org.jdom2.Element child = children.get(j);
            String childName = child.getName();
            if (!childName.equals(naming)) continue;
            String desc = child.getAttributeValue("title", nss);
            String urlpath = child.getAttributeValue("href", nss);
            String[] c = radarServerURL.split(uriBase);
            String ul = c[0] + uriBase + urlpath;
            TwoFacedObject twoObj = new TwoFacedObject((Object)desc, ul);
            collections.add(twoObj);
        }
        return collections;
    }

    public org.jdom2.Element readElements(org.jdom2.Element elem, String eleName) {
        List<org.jdom2.Element> children = elem.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            org.jdom2.Element child = children.get(j);
            String childName = child.getName();
            if (!childName.equals(eleName)) continue;
            return child;
        }
        return null;
    }

    public void initializeCollection(String url) {
        ArrayList<NamedStationImpl> stations = new ArrayList<NamedStationImpl>();
        try {
            StringBuffer errlog = new StringBuffer();
            try {
                this.collection = TDSRadarDatasetCollection.factory("test", url, errlog);
            }
            catch (Exception exc) {
                TDSRadarChooser1.userMessage("Invalid catalog");
                return;
            }
            List<Station> tdsStations = this.collection.getRadarStations();
            for (int i = 0; i < tdsStations.size(); ++i) {
                StationImpl stn = (StationImpl)tdsStations.get(i);
                NamedStationImpl station = new NamedStationImpl(stn.getName(), stn.getName(), stn.getLatitude(), stn.getLongitude(), stn.getAltitude(), CommonUnit.meter);
                stations.add(station);
            }
            this.getStationMap().setStations(stations);
        }
        catch (Exception exc) {
            TDSRadarChooser1.userMessage("Unable to load stations");
            return;
        }
        this.urlListHandler.saveState(this.urlBox);
    }

    public void initializeLevel3Collection(String url) {
        ArrayList<NamedStationImpl> stations = new ArrayList<NamedStationImpl>();
        try {
            StringBuffer errlog = new StringBuffer();
            try {
                this.collection = TDSRadarDatasetCollection.factory("test", url, errlog);
            }
            catch (Exception exc) {
                TDSRadarChooser1.userMessage("Invalid catalog");
                return;
            }
            List<Product> products = this.collection.getRadarProducts();
            List<Station> tdsStations = this.collection.getRadarStations();
            for (int i = 0; i < tdsStations.size(); ++i) {
                StationImpl stn = (StationImpl)tdsStations.get(i);
                NamedStationImpl station = new NamedStationImpl(stn.getName(), stn.getName(), stn.getLatitude(), stn.getLongitude(), stn.getAltitude(), CommonUnit.meter);
                stations.add(station);
            }
            ArrayList<TwoFacedObject> productNames = new ArrayList<TwoFacedObject>();
            for (Product product : products) {
                if (product.getID().contains("DPA") || product.getID().contains("NVW")) continue;
                String lable = product.getName() + " (" + product.getID() + ")";
                TwoFacedObject twoObj = new TwoFacedObject((Object)lable, product.getID());
                productNames.add(twoObj);
            }
            GuiUtils.setListData(this.productComboBox, productNames);
            this.getStationMap().setStations(stations);
        }
        catch (Exception exc) {
            TDSRadarChooser1.userMessage("Unable to load stations");
            return;
        }
        this.urlListHandler.saveState(this.urlBox);
    }

    public void stationOrProductChanged() {
        Vector<DateTime> times = new Vector<DateTime>();
        this.setHaveData(false);
        if (this.selectedStation != null && this.selectedProduct != null) {
            Date toDate = new Date(System.currentTimeMillis() + DateUtil.daysToMillis(1.0));
            Date fromDate = new Date(System.currentTimeMillis() - DateUtil.daysToMillis(3650.0));
            try {
                this.showWaitCursor();
                this.setAbsoluteTimes(new ArrayList());
                this.setStatus("Reading times for station: " + this.selectedStation, "");
                String pid = TwoFacedObject.getIdString(this.productComboBox.getSelectedItem());
                List<Date> allTimes = this.collection.getRadarStationTimes(this.selectedStation.getID(), pid, fromDate, toDate);
                for (int timeIdx = 0; timeIdx < allTimes.size(); ++timeIdx) {
                    Date timeObj = allTimes.get(timeIdx);
                    Date date = timeObj instanceof Date ? timeObj : DateUnit.getStandardOrISO(((Object)timeObj).toString());
                    times.add(new DateTime(date));
                }
                this.showNormalCursor();
            }
            catch (Exception exc) {
                TDSRadarChooser1.userMessage("Error reading times for station: " + this.selectedStation);
                this.setStatus("Select a different collection", "collections");
                this.showNormalCursor();
                return;
            }
        }
        this.setAbsoluteTimes(times);
        this.updateStatus();
    }

    @Override
    public void doLoadInThread() {
        Hashtable<String, NamedLocation> ht = new Hashtable<String, NamedLocation>();
        if (this.selectedStation != null) {
            ht.put("station location", this.selectedStation.getNamedLocation());
        } else {
            LogUtil.userMessage("No Station selected");
        }
        if (this.isLevel3 && this.selectedProduct == null) {
            LogUtil.userMessage("No Product selected");
        }
        try {
            RadarQuery radarQuery;
            DateSelection dateSelection = new DateSelection();
            String collectionUrl = TwoFacedObject.getIdString(this.collectionSelector.getSelectedItem());
            String pid = null;
            if (this.isLevel3) {
                pid = TwoFacedObject.getIdString(this.productComboBox.getSelectedItem());
                radarQuery = new RadarQuery(collectionUrl, this.selectedStation.getID(), pid, dateSelection);
            } else {
                radarQuery = new RadarQuery(collectionUrl, this.selectedStation.getID(), dateSelection);
            }
            ArrayList<String> urls = new ArrayList<String>();
            if (this.getDoAbsoluteTimes()) {
                ArrayList<Date> times = new ArrayList<Date>();
                List<DatedThing> selected = this.makeDatedObjects(this.getSelectedAbsoluteTimes());
                for (int i = 0; i < selected.size(); ++i) {
                    DatedThing datedThing = selected.get(i);
                    Date date = datedThing.getDate();
                    times.add(date);
                    URI uri = null;
                    try {
                        uri = this.collection.getRadarDatasetURI(this.selectedStation.getID(), pid, date);
                    }
                    catch (Exception excp) {
                        LogUtil.userMessage("incorrect times selected");
                        return;
                    }
                    urls.add(uri.toString());
                }
                if (urls.size() == 0) {
                    LogUtil.userMessage("No times selected");
                    return;
                }
                dateSelection.setTimes(times);
            } else {
                int count = this.getRelativeTimesList().getSelectedIndex() + 1;
                if (count == 0) {
                    LogUtil.userMessage("No relative times selected");
                    return;
                }
                Date toDate = new Date(System.currentTimeMillis() + DateUtil.daysToMillis(36500.0));
                Date fromDate = new Date(System.currentTimeMillis() - DateUtil.daysToMillis(3650.0));
                dateSelection.setStartFixedTime(fromDate);
                dateSelection.setEndFixedTime(toDate);
                dateSelection.setCount(count);
            }
            this.makeDataSource(radarQuery, "FILE.RADAR", ht);
        }
        catch (Exception exc) {
            this.logException("Loading radar data", exc);
        }
    }
}

