/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.w3c.dom.Element;
import ucar.nc2.units.DateUnit;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.radar.RadarQuery;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.IdvRadarDatasetCollection;
import ucar.unidata.idv.chooser.TimesChooser;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PreferenceList;
import ucar.unidata.util.Product;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;
import visad.CommonUnit;
import visad.DateTime;

public class TDSRadarChooser
extends TimesChooser {
    private JComponent outerContents;
    private IdvRadarDatasetCollection collection;
    private NamedStation selectedStation;
    private String selectedProduct;
    private String serverUrl;
    private JComboBox collectionSelector;
    private JComboBox productComboBox;
    private JComponent productLabel;
    private List<Component> compsThatNeedServer = new ArrayList<Component>();
    private List<Component> level3CompsThatNeedServer = new ArrayList<Component>();
    private PreferenceList urlListHandler;
    private JComboBox urlBox;
    private boolean okToDoUrlListEvents = true;
    private List datasetList;
    protected static final String CMD_CONNECT = "cmd.connect";
    private boolean isLevel3;
    public static final String[] level3_ExName = new String[]{"NVW", "DPA"};
    private boolean ignoreProductChange = false;
    private boolean readingTimes = false;
    protected static final String LABEL_SELECT = " -- Select -- ";
    private static final TwoFacedObject SELECT_OBJECT = new TwoFacedObject((Object)" -- Select -- ", " -- Select -- ");
    private boolean timeDriverEnabled = false;
    private JComponent timesPanel;

    public TDSRadarChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    public void doUpdate() {
        if (this.serverUrl == null || this.datasetList == null || this.datasetList.size() == 0 || this.isLevel3 && !this.haveSelectedProduct()) {
            if (this.urlBox != null) {
                this.setServer((String)this.urlBox.getSelectedItem());
            }
            return;
        }
        Misc.run(this, "stationOrProductChanged");
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        if (this.selectedStation == null) {
            this.setHaveData(false);
            this.setStatus("Please select a station", "stations");
            return;
        }
        if (this.isLevel3 && !this.haveSelectedProduct()) {
            this.setHaveData(false);
            this.setStatus("Please select a level 3 product", "products");
            return;
        }
        boolean haveTimesSelected = false;
        haveTimesSelected = this.getDoAbsoluteTimes() ? this.getSelectedAbsoluteTimes().size() > 0 : true;
        this.setHaveData(haveTimesSelected);
        if (haveTimesSelected) {
            this.setStatus("Press \"Add Source\" to load the selected radar data", "buttons");
        } else {
            this.setStatus("Please select times", "timepanel");
        }
        this.timeDriverEnabled = false;
    }

    private boolean haveSelectedProduct() {
        if (!this.isLevel3) {
            return true;
        }
        return this.selectedProduct != null && !this.selectedProduct.equals(SELECT_OBJECT);
    }

    @Override
    protected void newSelectedStations(List stations) {
        super.newSelectedStations(stations);
        if (stations == null || stations.size() == 0) {
            this.selectedStation = null;
        } else {
            NamedStation newStation = (NamedStation)stations.get(0);
            if (Misc.equals(newStation, this.selectedStation)) {
                return;
            }
            this.selectedStation = newStation;
        }
        Misc.run(this, "stationOrProductChanged");
    }

    @Override
    protected JComponent doMakeContents() {
        this.urlListHandler = this.getPreferenceList("idv.data.tds.radar.servers");
        ActionListener catListListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!TDSRadarChooser.this.okToDoUrlListEvents) {
                    return;
                }
                TDSRadarChooser.this.setServer((String)TDSRadarChooser.this.urlBox.getSelectedItem());
            }
        };
        this.urlBox = this.urlListHandler.createComboBox(GuiUtils.CMD_UPDATE, catListListener, true);
        this.collectionSelector = new JComboBox();
        this.collectionSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TDSRadarChooser.this.collectionSelector.getSelectedItem() == null) {
                    return;
                }
                String collectionUrl = TwoFacedObject.getIdString(TDSRadarChooser.this.collectionSelector.getSelectedItem());
                if (collectionUrl.contains("level3")) {
                    TDSRadarChooser.this.setLevel3Collection(collectionUrl);
                } else {
                    TDSRadarChooser.this.setCollection(collectionUrl);
                }
            }
        });
        this.productLabel = this.addLevel3ServerComp(this.padLabel("Product: "));
        this.productComboBox = new JComboBox();
        this.productComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selected = TDSRadarChooser.this.productComboBox.getSelectedItem();
                if (selected == null || selected.equals(SELECT_OBJECT)) {
                    TDSRadarChooser.this.selectedProduct = null;
                    return;
                }
                TDSRadarChooser.this.selectedProduct = selected.toString();
                TDSRadarChooser.this.productChanged();
            }
        });
        this.addLevel3ServerComp(this.productComboBox);
        JComponent stationMap = this.getStationMap();
        JComponent buttons = this.getDefaultButtons();
        this.timesPanel = this.getIdv().getUseTimeDriver() ? this.makeTimesPanel(true, true, true) : this.makeTimesPanel(true, true);
        stationMap.setPreferredSize(new Dimension(230, 200));
        stationMap = this.registerStatusComp("stations", stationMap);
        this.timesPanel = this.registerStatusComp("timepanel", this.timesPanel);
        this.addServerComp(stationMap);
        this.addServerComp(this.timesPanel);
        GuiUtils.tmpInsets = GRID_INSETS;
        JPanel contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Catalog:"), this.urlBox, GuiUtils.rLabel("Collections:"), GuiUtils.left(this.collectionSelector), GuiUtils.right(this.productLabel), GuiUtils.left(this.productComboBox), GuiUtils.valignLabel("Stations:"), stationMap, GuiUtils.valignLabel("Times:"), this.timesPanel}, 2, GuiUtils.WT_NY, new double[]{0.0, 0.0, 0.0, 1.0, 0.2});
        GuiUtils.enableComponents(this.compsThatNeedServer, false);
        GuiUtils.enableComponents(this.level3CompsThatNeedServer, false);
        this.showProductWidgets(false);
        this.outerContents = GuiUtils.center(GuiUtils.centerBottom(contents, buttons));
        return this.outerContents;
    }

    protected void productChanged() {
        Misc.run(this, "stationOrProductChanged");
    }

    private void resetProductBox() {
        this.ignoreProductChange = true;
        this.productComboBox.setSelectedItem(SELECT_OBJECT);
        this.ignoreProductChange = false;
    }

    @Override
    protected boolean shouldDoUpdateOnFirstDisplay() {
        return true;
    }

    private void setServer(String s) {
        this.serverUrl = s;
        this.datasetList = new ArrayList();
        try {
            this.datasetList = this.getRadarCollections(this.serverUrl);
            GuiUtils.setListData(this.collectionSelector, this.datasetList);
            for (int i = 0; i < this.datasetList.size(); ++i) {
                TwoFacedObject obj = (TwoFacedObject)this.datasetList.get(i);
                if (!((String)obj.getLabel()).contains("NEXRAD Level II Radar from IDD")) continue;
                this.collectionSelector.setSelectedIndex(i);
            }
        }
        catch (Exception e) {
            GuiUtils.setListData(this.collectionSelector, new ArrayList());
        }
    }

    private void setCollection(String s) {
        GuiUtils.enableComponents(this.level3CompsThatNeedServer, false);
        this.showProductWidgets(false);
        this.isLevel3 = false;
        GuiUtils.enableComponents(this.compsThatNeedServer, true);
        this.setAbsoluteTimes(new ArrayList());
        this.setTimeDrivers(new ArrayList());
        this.selectedProduct = null;
        this.selectedStation = null;
        Misc.run(this, "initializeCollection", s);
    }

    private void setLevel3Collection(String s) {
        this.isLevel3 = true;
        GuiUtils.enableComponents(this.level3CompsThatNeedServer, true);
        GuiUtils.enableComponents(this.compsThatNeedServer, true);
        this.setAbsoluteTimes(new ArrayList());
        this.setTimeDrivers(new ArrayList());
        this.selectedProduct = null;
        this.selectedStation = null;
        Misc.run(this, "initializeLevel3Collection", s);
    }

    private void showProductWidgets(boolean show) {
        if (this.productLabel != null) {
            this.productLabel.setEnabled(show);
        }
        if (this.productComboBox != null) {
            this.productComboBox.setEnabled(show);
        }
    }

    protected JComponent addServerComp(JComponent comp) {
        this.compsThatNeedServer.add(comp);
        return comp;
    }

    protected JComponent addLevel3ServerComp(JComponent comp) {
        this.level3CompsThatNeedServer.add(comp);
        return comp;
    }

    private List getRadarCollections(String radarServerURL) {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        ArrayList<TwoFacedObject> collections = new ArrayList<TwoFacedObject>();
        try {
            doc = builder.build(radarServerURL);
        }
        catch (JDOMException e) {
            TDSRadarChooser.userMessage("Invalid catalog");
            e.printStackTrace();
        }
        catch (IOException e) {
            TDSRadarChooser.userMessage("Unable to open catalog");
            e.printStackTrace();
        }
        org.jdom2.Element rootElem = doc.getRootElement();
        org.jdom2.Element serviceElem = this.readElements(rootElem, "service");
        String uriBase = serviceElem.getAttributeValue("base");
        org.jdom2.Element dsElem = this.readElements(rootElem, "dataset");
        String naming = "catalogRef";
        Namespace nss = rootElem.getNamespace("xlink");
        List<org.jdom2.Element> children = dsElem.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            org.jdom2.Element child = children.get(j);
            String childName = child.getName();
            if (!childName.equals(naming)) continue;
            String desc = child.getAttributeValue("title", nss);
            String urlpath = child.getAttributeValue("href", nss);
            String[] c = radarServerURL.split(uriBase);
            String ul = c[0] + uriBase + urlpath;
            TwoFacedObject twoObj = new TwoFacedObject((Object)desc, ul);
            collections.add(twoObj);
        }
        return collections;
    }

    public org.jdom2.Element readElements(org.jdom2.Element elem, String eleName) {
        List<org.jdom2.Element> children = elem.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            org.jdom2.Element child = children.get(j);
            String childName = child.getName();
            if (!childName.equals(eleName)) continue;
            return child;
        }
        return null;
    }

    public void initializeCollection(String url) {
        ArrayList<NamedStationImpl> stations = new ArrayList<NamedStationImpl>();
        try {
            StringBuffer errlog = new StringBuffer();
            try {
                this.collection = IdvRadarDatasetCollection.factory("test", url, errlog);
            }
            catch (Exception exc) {
                TDSRadarChooser.userMessage("Invalid catalog");
                return;
            }
            List<Station> tdsStations = this.collection.getRadarStations();
            for (int i = 0; i < tdsStations.size(); ++i) {
                StationImpl stn = (StationImpl)tdsStations.get(i);
                NamedStationImpl station = new NamedStationImpl(stn.getName(), stn.getName(), stn.getLatitude(), stn.getLongitude(), stn.getAltitude(), CommonUnit.meter);
                stations.add(station);
            }
            this.getStationMap().setStations(stations);
        }
        catch (Exception exc) {
            TDSRadarChooser.userMessage("Unable to load stations");
            return;
        }
        this.urlListHandler.saveState(this.urlBox);
    }

    public void initializeLevel3Collection(String url) {
        ArrayList<NamedStationImpl> stations = new ArrayList<NamedStationImpl>();
        ArrayList<String> exProducts = new ArrayList<String>();
        for (String ename : level3_ExName) {
            exProducts.add(ename);
        }
        try {
            StringBuffer errlog = new StringBuffer();
            try {
                this.collection = IdvRadarDatasetCollection.factory("test", url, errlog);
            }
            catch (Exception exc) {
                TDSRadarChooser.userMessage("Invalid catalog");
                return;
            }
            List products = this.collection.getRadarProducts();
            List<Station> tdsStations = this.collection.getRadarStations();
            for (int i = 0; i < tdsStations.size(); ++i) {
                StationImpl stn = (StationImpl)tdsStations.get(i);
                NamedStationImpl station = new NamedStationImpl(stn.getName(), stn.getName(), stn.getLatitude(), stn.getLongitude(), stn.getAltitude(), CommonUnit.meter);
                stations.add(station);
            }
            this.productComboBox.removeAllItems();
            ArrayList<TwoFacedObject> productNames = new ArrayList<TwoFacedObject>();
            productNames.add(SELECT_OBJECT);
            for (Product product : products) {
                if (exProducts.contains(product.getID())) continue;
                String lable = product.getName() + " (" + product.getID() + ")";
                TwoFacedObject twoObj = new TwoFacedObject((Object)lable, product.getID());
                productNames.add(twoObj);
            }
            GuiUtils.setListData(this.productComboBox, productNames);
            this.showProductWidgets(true);
            this.getStationMap().setStations(stations);
        }
        catch (Exception exc) {
            TDSRadarChooser.userMessage("Unable to load stations");
            return;
        }
        this.urlListHandler.saveState(this.urlBox);
    }

    public void stationOrProductChanged() {
        this.setHaveData(false);
        this.setDoTimeDrivers(false);
        this.drivercbx.setSelected(false);
        this.enableTimeWidgets();
        this.readTimes();
        this.readDrivers();
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTimes() {
        if (this.readingTimes) {
            return;
        }
        this.readingTimes = true;
        Vector<DateTime> times = new Vector<DateTime>();
        if (this.getDoAbsoluteTimes() && (!this.isLevel3 && this.selectedStation != null || this.isLevel3 && this.selectedStation != null && this.haveSelectedProduct())) {
            List timeSpan = this.collection.getRadarTimeSpan();
            Date fromDate = DateUnit.getStandardOrISO((String)timeSpan.get(0));
            Date toDate = DateUnit.getStandardOrISO((String)timeSpan.get(1));
            try {
                String xml;
                this.showWaitCursor();
                this.setAbsoluteTimes(new ArrayList());
                this.setStatus("Reading times for station: " + this.selectedStation, "");
                String pid = null;
                if (this.isLevel3) {
                    pid = TwoFacedObject.getIdString(this.productComboBox.getSelectedItem());
                }
                URI uri = this.collection.getQueryRadarStationURI(this.selectedStation.getID(), pid, fromDate, toDate);
                LogUtil.message("Reading radar catalog from server");
                try {
                    xml = IOUtil.readContents(uri.toString(), this.getClass());
                }
                finally {
                    LogUtil.message("");
                }
                Element root = XmlUtil.getRoot(xml);
                Element topDatasetNode = XmlUtil.findChild(root, "dataset");
                if (topDatasetNode == null) {
                    throw new IllegalStateException("Could not find dataset node in radar catalog");
                }
                List children = XmlUtil.findChildren(topDatasetNode, "dataset");
                ArrayList<Date> allTimes = new ArrayList<Date>();
                if (children == null || children.isEmpty()) {
                    String message = "No data available";
                    if (this.isLevel3) {
                        message = message + " for " + this.productComboBox.getSelectedItem().toString();
                    }
                    message = message + " at " + this.selectedStation.getID();
                    TDSRadarChooser.userMessage(message);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
                for (int i = 0; i < children.size(); ++i) {
                    Element child = (Element)children.get(i);
                    String dttmTxt = XmlUtil.getGrandChildText(child, "date", null);
                    if (dttmTxt == null) continue;
                    Date dttm = sdf.parse(dttmTxt);
                    allTimes.add(dttm);
                }
                for (Date date : allTimes) {
                    times.add(new DateTime(date));
                }
                this.showNormalCursor();
            }
            catch (Exception exc) {
                TDSRadarChooser.userMessage("Error reading times for station: " + this.selectedStation);
                this.setStatus("Select a different collection", "collections");
                this.showNormalCursor();
                this.readingTimes = false;
                return;
            }
        }
        this.readingTimes = false;
        this.setAbsoluteTimes(times);
    }

    public void updatetimelineOld(TwoFacedObject id) {
        RadarQuery radarQuery;
        super.updatetimeline(id);
        String collectionUrl = TwoFacedObject.getIdString(this.collectionSelector.getSelectedItem());
        DateSelection dateSelection = new DateSelection();
        String pid = null;
        if (this.isLevel3) {
            pid = TwoFacedObject.getIdString(this.productComboBox.getSelectedItem());
            radarQuery = new RadarQuery(collectionUrl, this.selectedStation.getID(), pid, dateSelection);
        } else {
            radarQuery = new RadarQuery(collectionUrl, this.selectedStation.getID(), dateSelection);
        }
        DateTime[] driverTimes = (DateTime[])id.getId();
        ArrayList<DateTime> dtimes = new ArrayList<DateTime>();
        for (int i = 0; i < driverTimes.length; ++i) {
            dtimes.add(driverTimes[i]);
        }
        Collections.sort(dtimes);
        int n = driverTimes.length;
        Date fromDate = DateUnit.getStandardOrISO(driverTimes[0].dateString() + "T" + driverTimes[0].timeString());
        Date toDate = DateUnit.getStandardOrISO(driverTimes[n - 1].dateString() + "T" + driverTimes[n - 1].timeString());
        List<Date> collectionTimes = null;
        List<DateTime> selectedTimes = null;
        try {
            collectionTimes = this.collection.getRadarStationTimes(radarQuery.getStation(), radarQuery.getProduct(), fromDate, toDate);
            selectedTimes = DataUtil.selectTimesFromList(collectionTimes, dtimes);
            List<DatedThing> newAbsoluteTimes = this.makeDatedObjects(selectedTimes);
            int size = newAbsoluteTimes.size();
            if (size > 1) {
                Date endDate = newAbsoluteTimes.get(size - 1).getDate();
                int index = Math.max(0, size - this.getNumTimesToSelect());
                Date startDate = newAbsoluteTimes.get(index).getDate();
                this.getTimeLine().setDateSelection(new Date[]{startDate, endDate});
            }
            this.setSelectedAbsoluteTimes(selectedTimes);
            this.setDoTimeDrivers(true);
            this.absoluteTimesSelectionChanged();
            this.timeDriverEnabled = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void doLoadInThread() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        if (this.selectedStation == null) {
            LogUtil.userMessage("No Station selected");
            return;
        }
        ht.put("station location", this.selectedStation.getNamedLocation());
        ht.put("Chooser_Do_Time_Matching", this.getDoTimeDrivers());
        if (this.isLevel3 && !this.haveSelectedProduct()) {
            LogUtil.userMessage("No Product selected");
            return;
        }
        try {
            RadarQuery radarQuery;
            DateSelection dateSelection = new DateSelection();
            String collectionUrl = TwoFacedObject.getIdString(this.collectionSelector.getSelectedItem());
            String pid = null;
            if (this.isLevel3) {
                pid = TwoFacedObject.getIdString(this.productComboBox.getSelectedItem());
                radarQuery = new RadarQuery(collectionUrl, this.selectedStation.getID(), pid, dateSelection);
            } else {
                radarQuery = new RadarQuery(collectionUrl, this.selectedStation.getID(), dateSelection);
            }
            ArrayList urls = new ArrayList();
            if (this.getDoAbsoluteTimes()) {
                Trace.msg("TDSRadarChoocer:getting absolute times");
                ArrayList<Date> times = new ArrayList<Date>();
                List<DatedThing> selected = this.makeDatedObjects(this.getSelectedAbsoluteTimes());
                for (DatedThing datedThing : selected) {
                    times.add(datedThing.getDate());
                }
                if (times.isEmpty()) {
                    LogUtil.userMessage("No times selected");
                    return;
                }
                dateSelection.setTimes(times);
                Trace.msg("TDSRadarChoocer:getting absolute times.end");
            } else {
                int count = this.getRelativeTimesList().getSelectedIndex() + 1;
                if (count == 0) {
                    LogUtil.userMessage("No relative times selected");
                    return;
                }
                List timeSpan = this.collection.getRadarTimeSpan();
                Date fromDate = DateUnit.getStandardOrISO((String)timeSpan.get(0));
                Date toDate = DateUnit.getStandardOrISO((String)timeSpan.get(1));
                dateSelection.setStartMode(3);
                dateSelection.setEndMode(3);
                dateSelection.setCount(count);
            }
            this.makeDataSource(radarQuery, "FILE.RADAR", ht);
        }
        catch (Exception exc) {
            this.logException("Loading radar data", exc);
        }
        this.drivercbx.setSelected(false);
        this.enableTimeWidgets();
        this.setDoTimeDrivers(false);
    }
}

