/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.TimesChooser;
import ucar.unidata.util.CatalogUtil;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PreferenceList;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;
import visad.DateTime;

public class TDSPointObsChooser
extends TimesChooser {
    private JComponent outerContents;
    private String serverUrl;
    private String collectionUrl;
    private JComboBox collectionSelector;
    private List<Component> compsThatNeedServer = new ArrayList<Component>();
    private PreferenceList urlListHandler;
    private JComboBox urlBox;
    private boolean okToDoUrlListEvents = true;
    private List datasetList;
    private Element capabilitiesElement;
    protected static final String CMD_CONNECT = "cmd.connect";
    private boolean ignoreProductChange = false;
    protected static final String LABEL_SELECT = " -- Select -- ";
    private static final TwoFacedObject SELECT_OBJECT = new TwoFacedObject((Object)" -- Select -- ", " -- Select -- ");
    private final String REQ_CAPABILITIES = "?req=capabilities";
    private final String TAG_LATLONBOX = "LatLonBox";
    private final String TAG_TIMESPAN = "TimeSpan";
    private DateSelection collectionDates;

    public TDSPointObsChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    public void doUpdate() {
        if (this.serverUrl == null || this.datasetList == null || this.datasetList.size() == 0) {
            if (this.urlBox != null) {
                this.setServer((String)this.urlBox.getSelectedItem());
            }
            return;
        }
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        boolean haveTimesSelected = false;
        haveTimesSelected = this.getDoAbsoluteTimes() ? this.getSelectedAbsoluteTimes().size() > 0 : true;
        this.setHaveData(haveTimesSelected);
        if (haveTimesSelected) {
            this.setStatus("Press \"Add Source\" to load the selected observation data", "buttons");
        } else {
            this.setStatus("Please select times", "timepanel");
        }
    }

    @Override
    protected JComponent doMakeContents() {
        this.urlListHandler = this.getPreferenceList("idv.data.tds.pointob.servers");
        ActionListener catListListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!TDSPointObsChooser.this.okToDoUrlListEvents) {
                    return;
                }
                TDSPointObsChooser.this.setServer((String)TDSPointObsChooser.this.urlBox.getSelectedItem());
            }
        };
        this.urlBox = this.urlListHandler.createComboBox(GuiUtils.CMD_UPDATE, catListListener, true);
        this.collectionSelector = new JComboBox();
        this.collectionSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TwoFacedObject selected = (TwoFacedObject)TDSPointObsChooser.this.collectionSelector.getSelectedItem();
                if (selected == null || selected.equals(SELECT_OBJECT)) {
                    return;
                }
                String collectionUrl = TwoFacedObject.getIdString(selected);
                TDSPointObsChooser.this.setCollection(collectionUrl);
            }
        });
        JComponent stationMap = this.getStationMap();
        JComponent buttons = this.getDefaultButtons();
        JComponent timesPanel = this.makeTimesPanel(true, true);
        stationMap.setPreferredSize(new Dimension(230, 200));
        stationMap = this.registerStatusComp("stations", stationMap);
        timesPanel = this.registerStatusComp("timepanel", timesPanel);
        this.addServerComp(stationMap);
        this.addServerComp(timesPanel);
        GuiUtils.tmpInsets = GRID_INSETS;
        JPanel contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Catalog:"), this.urlBox, GuiUtils.rLabel("Collections:"), GuiUtils.left(this.collectionSelector), GuiUtils.valignLabel("Coverage:"), stationMap, GuiUtils.valignLabel("Times:"), timesPanel}, 2, GuiUtils.WT_NY, new double[]{0.0, 0.0, 0.0, 1.0, 0.2});
        GuiUtils.enableComponents(this.compsThatNeedServer, false);
        this.outerContents = GuiUtils.center(GuiUtils.centerBottom(contents, buttons));
        return this.outerContents;
    }

    private void setServer(String s) {
        this.serverUrl = s;
        this.datasetList = new ArrayList();
        try {
            this.datasetList = this.getPointObsCollections(this.serverUrl);
            GuiUtils.setListData(this.collectionSelector, this.datasetList);
        }
        catch (Exception e) {
            GuiUtils.setListData(this.collectionSelector, new ArrayList());
        }
    }

    private void setCollection(String s) {
        GuiUtils.enableComponents(this.compsThatNeedServer, true);
        this.setAbsoluteTimes(new ArrayList());
        Misc.run(this, "initializeCollection", s);
    }

    protected JComponent addServerComp(JComponent comp) {
        this.compsThatNeedServer.add(comp);
        return comp;
    }

    @Override
    protected boolean shouldDoUpdateOnFirstDisplay() {
        return true;
    }

    private List getPointObsCollections(String pointobServerURL) {
        ArrayList<TwoFacedObject> collections = new ArrayList<TwoFacedObject>();
        Element root = null;
        try {
            root = XmlUtil.getRoot(pointobServerURL, this.getClass());
        }
        catch (Exception e) {
            TDSPointObsChooser.userMessage("Unable to open catalog: " + pointobServerURL);
            return collections;
        }
        root.setAttribute("catalogurl", pointobServerURL);
        List children = XmlUtil.findDescendants(root, "dataset");
        collections.add(SELECT_OBJECT);
        for (int j = 0; j < children.size(); ++j) {
            Element datasetNode = (Element)children.get(j);
            String desc = datasetNode.getAttribute("name");
            String urlPath = datasetNode.getAttribute("urlPath");
            Element serviceNode = CatalogUtil.findServiceNodeForDataset(datasetNode, true, null);
            if (serviceNode == null) continue;
            String url = CatalogUtil.getAbsoluteUrl(serviceNode, urlPath);
            TwoFacedObject twoObj = new TwoFacedObject((Object)desc, url);
            collections.add(twoObj);
        }
        return collections;
    }

    public void initializeCollection(String url) {
        Element root = null;
        try {
            root = XmlUtil.getRoot(url + "?req=capabilities", this.getClass());
        }
        catch (Exception e) {
            TDSPointObsChooser.userMessage("Unable to open collection: " + url);
            return;
        }
        this.collectionUrl = url;
        this.capabilitiesElement = root;
        this.collectionChanged();
        this.urlListHandler.saveState(this.urlBox);
    }

    public void collectionChanged() {
        this.setHaveData(false);
        this.readTimes();
        this.updateStatus();
    }

    @Override
    public void readTimes() {
        Vector<DateTime> times = new Vector<DateTime>();
        Trace.call1("TDSPointObsChooser.readTimes");
        if (this.capabilitiesElement != null) {
            Element timeSpan = XmlUtil.getElement(this.capabilitiesElement, "TimeSpan");
            this.collectionDates = new DateSelection();
            if (timeSpan != null) {
                try {
                    String startTime = XmlUtil.getGrandChildText(timeSpan, "begin");
                    String endTime = XmlUtil.getGrandChildText(timeSpan, "end");
                    String resolution = XmlUtil.getGrandChildText(timeSpan, "resolution");
                    Date fromDate = DateUtil.parse(startTime);
                    Date toDate = DateUtil.parse(endTime);
                    toDate = DateUtil.min(toDate, new Date());
                    this.collectionDates = new DateSelection(fromDate, toDate);
                    if (resolution != null) {
                        TimeDuration td = new TimeDuration(resolution);
                        double intervalMillis = td.getValueInSeconds() * 1000.0;
                        this.collectionDates.setInterval(intervalMillis);
                        this.collectionDates.setRoundTo(intervalMillis);
                    }
                    this.showWaitCursor();
                    this.setAbsoluteTimes(new ArrayList());
                    this.setStatus("Reading times: ", "timepanel");
                    if (this.getDoAbsoluteTimes()) {
                        double[] millis = this.collectionDates.getIntervalTicks();
                        for (int i = 0; i < millis.length; ++i) {
                            times.add(new DateTime(millis[i] / 1000.0));
                        }
                    }
                    this.showNormalCursor();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    TDSPointObsChooser.userMessage("Error reading times. ");
                    this.setStatus("Select a different collection", "collections");
                    this.showNormalCursor();
                    return;
                }
            }
        }
        Trace.call2("TDSPointObsChooser.readTimes");
        this.setAbsoluteTimes(times);
    }

    @Override
    public void doLoadInThread() {
        Hashtable<String, DateSelection> ht = new Hashtable<String, DateSelection>();
        try {
            DateSelection dateSelection = new DateSelection();
            if (this.getDoAbsoluteTimes()) {
                Trace.msg("TDSPointObsChoocer:getting absolute times");
                ArrayList<Date> times = new ArrayList<Date>();
                List<DatedThing> selected = this.makeDatedObjects(this.getSelectedAbsoluteTimes());
                for (DatedThing datedThing : selected) {
                    times.add(datedThing.getDate());
                }
                if (times.isEmpty()) {
                    LogUtil.userMessage("No times selected");
                    return;
                }
                dateSelection.setTimes(times);
                Trace.msg("TDSPointObsChoocer:getting absolute times.end");
            } else {
                int count = this.getRelativeTimesList().getSelectedIndex() + 1;
                if (count == 0) {
                    LogUtil.userMessage("No relative times selected");
                    return;
                }
                dateSelection.setEndMode(1);
                dateSelection.setCount(count);
                if (this.collectionDates.hasInterval()) {
                    dateSelection.setInterval(this.collectionDates.getInterval());
                }
            }
            ht.put("date_selection", dateSelection);
            this.makeDataSource("cdmremote:" + this.collectionUrl, "CDMREMOTE.POINT", ht);
        }
        catch (Exception exc) {
            this.logException("Loading radar data", exc);
        }
    }
}

