/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.AddeUtil;
import ucar.unidata.data.sounding.RaobDataSet;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.view.sounding.SoundingSelector;
import ucar.unidata.xml.XmlUtil;

public class RaobChooser
extends IdvChooser {
    public static final String DATASOURCE_RAOB = "RAOB";
    public static final String ATTR_SHOWSERVER = "showserver";
    private SoundingSelector soundingChooser;

    public RaobChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    public void doUpdate() {
        this.soundingChooser.doUpdate();
    }

    @Override
    protected JComponent doMakeContents() {
        boolean showServer = XmlUtil.getAttribute((Node)this.chooserNode, ATTR_SHOWSERVER, true);
        this.soundingChooser = new SoundingSelector(this, this.chooserManager, this.chooserNode){

            @Override
            public void doLoad() {
                RaobChooser.this.doLoad();
            }

            @Override
            public void doCancel() {
            }
        };
        this.initChooserPanel(this.soundingChooser);
        return this.soundingChooser.getContents();
    }

    @Override
    protected String getDefaultDisplayType() {
        return "raob_skewt";
    }

    @Override
    public void doLoadInThread() {
        List soundings = this.soundingChooser.getSelectedSoundings();
        if (soundings.size() == 0) {
            RaobChooser.userMessage("Please select one or more soundings.");
            return;
        }
        Hashtable<String, List> ht = new Hashtable<String, List>();
        this.getDataSourceProperties(ht);
        List dtime = this.soundingChooser.getSelectedTimes();
        ht.put(AddeUtil.ABSOLUTE_TIMES, dtime);
        this.makeDataSource(new RaobDataSet(this.soundingChooser.getSoundingAdapter(), soundings), DATASOURCE_RAOB, ht);
        this.soundingChooser.getAddeChooser().saveServerState();
    }
}

