/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.chooser.FileChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.PollingInfo;
import ucar.unidata.xml.XmlUtil;

public class PollingFileChooser
extends FileChooser {
    public static final String ATTR_DIRECTORY = "directory";
    public static final String ATTR_INTERVAL = "interval";
    public static final String ATTR_DATASOURCEID = "datasourceid";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_LOADLABEL = "loadlabel";
    private String dfltDataSourceId;
    private PollingInfo pollingInfo;

    public PollingFileChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    protected String getUpdateToolTip() {
        return super.getUpdateToolTip();
    }

    @Override
    protected JComponent doMakeContents() {
        this.pollingInfo = (PollingInfo)this.idv.getPreference("chooser.pollinginfo." + this.getId());
        if (this.pollingInfo == null) {
            this.pollingInfo = new PollingInfo();
            this.pollingInfo.setMode(1);
            this.pollingInfo.setName(this.getAttribute(ATTR_TITLE, ""));
            this.pollingInfo.setFilePattern(this.getAttribute("filepattern", ""));
            this.pollingInfo.setFilePath(this.getAttribute(ATTR_DIRECTORY, ""));
            this.pollingInfo.setIsActive(XmlUtil.getAttribute((Node)this.chooserNode, "pollon", true));
            this.pollingInfo.setInterval((long)(XmlUtil.getAttribute((Node)this.chooserNode, ATTR_INTERVAL, 5.0) * 60.0 * 1000.0));
            int fileCount = 1;
            String s = XmlUtil.getAttribute((Node)this.chooserNode, "filecount", "1");
            s = s.trim();
            fileCount = s.equals("all") ? Integer.MAX_VALUE : new Integer(s);
            this.pollingInfo.setFileCount(fileCount);
        }
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        if (!XmlUtil.hasAttribute(this.chooserNode, ATTR_DATASOURCEID)) {
            JComboBox dsComp = this.getDataSourcesComponent();
            comps.add(GuiUtils.rLabel("Data Source Type:"));
            comps.add(GuiUtils.left(dsComp));
        }
        this.pollingInfo.getPropertyComponents(comps, true, XmlUtil.hasAttribute(this.chooserNode, "filecount"));
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        contents = GuiUtils.left(contents);
        this.setHaveData(true);
        return GuiUtils.top(GuiUtils.vbox((Component)contents, this.getDefaultButtons()));
    }

    @Override
    public void doLoadInThread() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (!this.pollingInfo.applyProperties()) {
            return;
        }
        if (this.pollingInfo.hasName()) {
            properties.put("TITLE", this.pollingInfo.getName());
        }
        properties.put("prop.pollinfo", this.pollingInfo.cloneMe());
        String dataSourceId = XmlUtil.hasAttribute(this.chooserNode, ATTR_DATASOURCEID) ? XmlUtil.getAttribute(this.chooserNode, ATTR_DATASOURCEID) : this.getDataSourceId();
        this.makeDataSource(this.pollingInfo.getFiles(), dataSourceId, properties);
        this.idv.getStateManager().writePreference("chooser.pollinginfo." + this.getId(), this.pollingInfo);
    }

    @Override
    public void doUpdate() {
    }

    @Override
    public boolean canDoUpdate() {
        return false;
    }

    @Override
    protected String getLoadCommandName() {
        String loadLabel = this.getAttribute(ATTR_LOADLABEL, null);
        if (loadLabel != null) {
            return loadLabel;
        }
        return super.getLoadCommandName();
    }
}

