/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.ui.DateTimePicker;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.HtmlUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedMapPanel;
import ucar.unidata.view.geoloc.NavigatedPanel;

public class MesoWestChooser
extends IdvChooser
implements ActionListener {
    public static final String BASEURL = "https://mesowest.utah.edu/cgi-bin/droman/obs_lsa_export.cgi";
    public static final String ARG_CLAT = "clat";
    public static final String ARG_CLON = "clon";
    public static final String ARG_BOXRAD = "boxrad";
    public static final String ARG_HOUR1 = "hour1";
    public static final String ARG_DAY1 = "day1";
    public static final String ARG_MONTH1 = "month1";
    public static final String ARG_YEAR1 = "year1";
    public static final String ARG_RAWSFLAG = "rawsflag";
    public static final String ARG_PAST = "past";
    public static final String ARG_HOURS = "hours";
    public static final String ARG_MINUTES = "minutes";
    public static final int RAWS_NWS = 3;
    public static final int RAWS_NWSANDRAWS = 1;
    public static final int RAWS_ALL = 290;
    private static String projectionString = "<object class=\"ucar.unidata.geoloc.projection.LatLonProjection\"><property name=\"CenterLon\"><double>-109</double></property><property name=\"Name\"><string><![CDATA[US>States>West>Colorado]]></string></property><property name=\"DefaultMapArea\"><object class=\"ucar.unidata.geoloc.ProjectionRect\"><constructor><double>-124</double><double>31</double><double>-100</double><double>47</double></constructor></object></property></object>";
    private JTextField clatFld;
    private JTextField clonFld;
    private JComboBox radiiCbx;
    private DateTimePicker dateTimePicker;
    private NavigatedMapPanel map;
    private JLabel statusLbl;
    private JComboBox rawsBox;
    private JComboBox minutesBox;
    private JComboBox rangeBox;
    private JRadioButton mostRecentBtn;
    private JRadioButton dateBtn;

    public MesoWestChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    public boolean canDoUpdate() {
        return false;
    }

    @Override
    protected String getLoadToolTip() {
        return "Load the MesoWest Data";
    }

    private void doAnnotateMap(Graphics2D g) {
        NavigatedPanel np = this.map.getNavigatedPanel();
        ProjectionImpl project = np.getProjectionImpl();
        ArrayList<LatLonPointImpl> points = new ArrayList<LatLonPointImpl>();
        LatLonRect llr = np.getSelectedEarthRegion();
        if (llr == null) {
            return;
        }
        double width = llr.getWidth();
        double radii = width / 2.0;
        boolean maxedOut = false;
        if (radii > 5.0) {
            radii = 5.0;
            maxedOut = true;
        }
        if (maxedOut) {
            this.statusLbl.setText("Bounds radius > 5 degrees");
        } else {
            this.statusLbl.setText("");
        }
        this.statusLbl.repaint();
        double clat = llr.getLatMin() + (llr.getLatMax() - llr.getLatMin()) / 2.0;
        double clon = llr.getLonMin() + (llr.getLonMax() - llr.getLonMin()) / 2.0;
        points.add(new LatLonPointImpl(clat + radii, clon - radii));
        points.add(new LatLonPointImpl(clat + radii, clon + radii));
        points.add(new LatLonPointImpl(clat - radii, clon + radii));
        points.add(new LatLonPointImpl(clat - radii, clon - radii));
        g.setStroke(new BasicStroke(0.1f));
        GeneralPath path = new GeneralPath(0, points.size());
        for (int i = 0; i <= points.size(); ++i) {
            LatLonPoint llp = i >= points.size() ? (LatLonPoint)points.get(0) : (LatLonPoint)points.get(i);
            ProjectionPoint ppi = project.latLonToProj(llp, new ProjectionPointImpl());
            Point2D p = np.earthToScreen(llp);
            if (i == 0) {
                path.moveTo((float)ppi.getX(), (float)ppi.getY());
                if (!maxedOut) continue;
                continue;
            }
            path.lineTo((float)ppi.getX(), (float)ppi.getY());
        }
        g.setColor(Color.gray);
        g.draw(path);
    }

    private void selectionChanged() {
        this.map.redraw();
    }

    @Override
    protected JComponent doMakeContents() {
        Vector<TwoFacedObject> rawsList = new Vector<TwoFacedObject>();
        rawsList.add(new TwoFacedObject((Object)"NWS Only", new Integer(3)));
        rawsList.add(new TwoFacedObject((Object)"NWS and RAWS", new Integer(1)));
        rawsList.add(new TwoFacedObject((Object)"All Network", new Integer(290)));
        this.rawsBox = new JComboBox(rawsList);
        this.minutesBox = new JComboBox(new Vector());
        Vector<TwoFacedObject> rangeList = new Vector<TwoFacedObject>();
        rangeList.add(new TwoFacedObject((Object)"24 hours", new Integer(24)));
        rangeList.add(new TwoFacedObject((Object)"12 hours", new Integer(12)));
        rangeList.add(new TwoFacedObject((Object)"6 hours", new Integer(6)));
        rangeList.add(new TwoFacedObject((Object)"2 hours", new Integer(2)));
        this.rangeBox = new JComboBox(rangeList);
        this.rangeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MesoWestChooser.this.checkMinutes();
            }
        });
        this.checkMinutes();
        this.mostRecentBtn = new JRadioButton("Use most recent time", true);
        this.mostRecentBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MesoWestChooser.this.checkDateEnable();
            }
        });
        this.dateBtn = new JRadioButton("Select date:", true);
        this.dateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MesoWestChooser.this.checkDateEnable();
            }
        });
        GuiUtils.buttonGroup(this.mostRecentBtn, this.dateBtn);
        this.statusLbl = new JLabel("");
        this.map = new NavigatedMapPanel(true, true){

            @Override
            protected void annotateMap(Graphics2D g) {
                super.annotateMap(g);
                MesoWestChooser.this.doAnnotateMap(g);
            }

            @Override
            protected NavigatedPanel doMakeMapPanel() {
                return new NavigatedPanel(){

                    @Override
                    protected void selectedRegionChanged() {
                        super.selectedRegionChanged();
                        MesoWestChooser.this.selectionChanged();
                    }
                };
            }
        };
        NavigatedPanel np = this.map.getNavigatedPanel();
        np.setSelectRegionMode(true);
        np.setSelectedRegion(new LatLonRect(new LatLonPointImpl(39.0, -110.0), new LatLonPointImpl(43.0, -114.0)));
        this.map.repaint();
        try {
            ProjectionImpl proj = (ProjectionImpl)this.getIdv().decodeObject(projectionString);
            np.setProjectionImpl(proj);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        np.setPreferredSize(new Dimension(250, 300));
        this.dateTimePicker = new DateTimePicker();
        JPanel dateComp = GuiUtils.vbox(this.mostRecentBtn, GuiUtils.hbox(this.dateBtn, this.dateTimePicker));
        this.checkDateEnable();
        ArrayList<Component> comps = new ArrayList<Component>();
        comps.add(GuiUtils.rLabel("Date/Time:"));
        comps.add(GuiUtils.left(dateComp));
        comps.add(GuiUtils.rLabel("Range:"));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.rangeBox, (Component)GuiUtils.filler(20, 5), (Component)GuiUtils.rLabel("Interval: "), GuiUtils.left(this.minutesBox))));
        comps.add(GuiUtils.rLabel("Observations:"));
        comps.add(GuiUtils.left(this.rawsBox));
        comps.add(GuiUtils.rLabel("Location:"));
        comps.add(GuiUtils.centerBottom(np, GuiUtils.left(np.getNavToolBar())));
        comps.add(GuiUtils.filler());
        comps.add(GuiUtils.left(this.statusLabel));
        JComponent mainContents = GuiUtils.formLayout(comps);
        JComponent urlButtons = this.getDefaultButtons();
        this.setHaveData(true);
        return GuiUtils.top(GuiUtils.vbox(mainContents, urlButtons));
    }

    private void checkMinutes() {
        int hours = (Integer)this.getId(this.rangeBox);
        Object selected = this.minutesBox.getSelectedItem();
        Vector<TwoFacedObject> minutesList = new Vector<TwoFacedObject>();
        minutesList.add(new TwoFacedObject((Object)"60 Minutes", new Integer(60)));
        if (hours < 24) {
            minutesList.add(new TwoFacedObject((Object)"30 Minutes", new Integer(30)));
            if (hours < 12) {
                minutesList.add(new TwoFacedObject((Object)"15 Minutes", new Integer(15)));
                if (hours < 6) {
                    minutesList.add(new TwoFacedObject((Object)"5 Minutes", new Integer(5)));
                }
            }
        }
        GuiUtils.setListData(this.minutesBox, minutesList);
        if (selected != null && minutesList.contains(selected)) {
            this.minutesBox.setSelectedItem(selected);
        }
    }

    private void checkDateEnable() {
        GuiUtils.enableTree(this.dateTimePicker, !this.mostRecentBtn.isSelected());
    }

    @Override
    public void setStatus(String msg, String what) {
        super.setStatus("Press \"Add Source\" to load the data", "buttons");
    }

    @Override
    public void doLoadInThread() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        String dataSourceId = "FILE.POINTTEXT";
        properties.put("datatypeid", dataSourceId);
        Date date = this.dateTimePicker.getDate();
        GregorianCalendar cal = new GregorianCalendar(DateTimePicker.getDefaultTimeZone());
        cal.setTime(date);
        String hour = "" + cal.get(11);
        String day = "" + cal.get(5);
        String month = StringUtil.padLeft("" + (cal.get(2) + 1), 2, "0");
        String year = "" + cal.get(1);
        NavigatedPanel np = this.map.getNavigatedPanel();
        LatLonRect llr = np.getSelectedEarthRegion();
        if (llr == null) {
            LogUtil.userErrorMessage("You need to select a region");
            return;
        }
        double width = llr.getWidth();
        double centerLon = llr.getCenterLon();
        double radii = width / 2.0;
        boolean maxedOut = false;
        if (radii > 5.0) {
            radii = 5.0;
            maxedOut = true;
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.mostRecentBtn.isSelected()) {
            args.add(ARG_PAST);
            args.add("0");
        } else {
            args.addAll(Misc.toList(new Object[]{ARG_PAST, "1", ARG_HOUR1, hour, ARG_DAY1, day, ARG_MONTH1, month, ARG_YEAR1, year}));
        }
        args.addAll(Misc.toList(new Object[]{ARG_RAWSFLAG, this.getId(this.rawsBox).toString(), ARG_CLAT, llr.getLatMin() + (llr.getLatMax() - llr.getLatMin()) / 2.0 + "", ARG_CLON, llr.getLonMin() + (llr.getLonMax() - llr.getLonMin()) / 2.0 + "", ARG_BOXRAD, radii + "", ARG_HOURS, this.getId(this.rangeBox).toString(), ARG_MINUTES, this.getId(this.minutesBox).toString()}));
        String url = HtmlUtil.url(BASEURL, Misc.listToStringArray(args));
        if (this.makeDataSource(url, dataSourceId, properties)) {
            this.closeChooser();
        }
    }

    private Object getId(JComboBox box) {
        return ((TwoFacedObject)box.getSelectedItem()).getId();
    }
}

