/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.chooser.XmlChooser;
import ucar.unidata.idv.chooser.XmlHandler;
import ucar.unidata.ui.XmlTree;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;

public class MenuHandler
extends XmlHandler {
    public static final String TAG_MENUS = "menus";
    public static final String TAG_MENU = "menu";
    public static final String TAG_MENUITEM = "menuitem";
    public static final String ATTR_ACTION = "action";

    public MenuHandler(XmlChooser chooser, Element root, String path) {
        super(chooser, root, path);
    }

    @Override
    public JComponent doMakeContents() {
        XmlTree tree = new XmlTree(this.root, true){

            @Override
            public void doDoubleClick(XmlTree theTree, Element e) {
                if (e.getTagName().equals(MenuHandler.TAG_MENUITEM)) {
                    MenuHandler.this.chooser.handleAction(XmlUtil.getAttribute(e, MenuHandler.ATTR_ACTION));
                }
            }

            @Override
            public void doClick(XmlTree theTree, Element e) {
                MenuHandler.this.chooser.setHaveData(e.getTagName().equals(MenuHandler.TAG_MENUITEM));
            }
        };
        tree.addTagsToProcess(Misc.newList(TAG_MENUS, TAG_MENU, TAG_MENUITEM));
        JPanel topPanel = new JPanel();
        return GuiUtils.inset((Component)GuiUtils.topCenter(topPanel, tree.getScroller()), 5);
    }

    @Override
    public void doLoad() {
        String action;
        Element element = this.tree.getSelectedElement();
        if (element != null && (action = XmlUtil.getAttribute((Node)element, ATTR_ACTION, (String)null)) != null) {
            this.chooser.handleAction(action);
        }
    }
}

