/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import org.w3c.dom.Element;
import ucar.unidata.idv.chooser.FileChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.PollingInfo;
import ucar.unidata.util.TwoFacedObject;

public class Level2RadarChooser
extends FileChooser {
    private JComboBox stationsCbx;
    private List nexradStations;
    private static String UNKNOWN_STATION = "I'm Feeling Lucky";
    private static String DATA_TYPE = "FILE.LEVEL2RADAR";
    private static String CDM_DATA_TYPE = "FILE.RADAR";
    private JCheckBox typeCbx;

    public Level2RadarChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    protected String getLoadToolTip() {
        return "Load the selected Level II radar files";
    }

    @Override
    protected void getTopComponents(List comps) {
        this.stationsCbx = new JComboBox();
        List stations = Misc.newList(UNKNOWN_STATION);
        this.nexradStations = this.getStations();
        stations.addAll(this.nexradStations);
        DisplayControlBase.setStations(stations, this.stationsCbx, false);
        comps.add(GuiUtils.rLabel("Radar Location:"));
        this.typeCbx = new JCheckBox("Use CDM", true);
        this.typeCbx.setToolTipText("Unselect to use old Level II reader");
        comps.add(GuiUtils.left(this.stationsCbx));
        comps.add(GuiUtils.rLabel("Relative Times:"));
        comps.add(GuiUtils.left(this.getRecentFilesComponent()));
        if (this.getFileChooser() != null) {
            this.guessAtStation(this.getFileChooser().getCurrentDirectory());
        }
        super.getTopComponents(comps);
    }

    @Override
    protected boolean shouldShowRecentComponent() {
        return false;
    }

    @Override
    protected JFileChooser doMakeFileChooser(String path) {
        Level2RadarFileChooser fileChooser = new Level2RadarFileChooser(this, path);
        fileChooser.addChoosableFileFilter(new PatternFileFilter(".*\\.raw$", "Raw files"));
        fileChooser.setApproveButtonText("Add Source");
        fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
        if (path != null) {
            ((JFileChooser)fileChooser).setCurrentDirectory(new File(path));
        }
        return fileChooser;
    }

    @Override
    protected boolean selectFilesInner(File[] files, File directory) {
        Object selected = ((TwoFacedObject)this.stationsCbx.getSelectedItem()).getId();
        if (selected.equals(UNKNOWN_STATION) && this.typeCbx != null && !this.typeCbx.isSelected()) {
            Level2RadarChooser.userMessage("Unknown location of selected files, please select from list");
            return false;
        }
        int recentCnt = this.getFileCount();
        if (recentCnt <= 0 && (files == null || files.length == 0)) {
            Level2RadarChooser.userMessage("Please select one or more files");
            return false;
        }
        if (files != null && files.length > 0) {
            FileManager.addToHistory(files[0]);
        }
        String[] tmpDataLoc = this.getFileNames((File[])(recentCnt <= 0 ? files : null));
        if (recentCnt <= 0 && tmpDataLoc == null) {
            return false;
        }
        Hashtable properties = Misc.newHashtable("station location", selected);
        String pattern = this.getFilePattern();
        if (pattern != null && pattern.length() > 0) {
            properties.put("prop.filepattern", pattern.toLowerCase());
        } else {
            pattern = null;
        }
        if (recentCnt > 0) {
            properties.put("datasource.mostrecent", new Integer(recentCnt));
            tmpDataLoc = new String[]{directory.toString()};
            PollingInfo pollingInfo = new PollingInfo(directory.toString(), 60000L, pattern, false, false);
            pollingInfo.setMode(1);
            pollingInfo.setFileCount(recentCnt);
            properties.put("prop.pollinfo", pollingInfo);
        }
        String dataType = this.typeCbx != null && !this.typeCbx.isSelected() ? DATA_TYPE : CDM_DATA_TYPE;
        this.makeDataSource(tmpDataLoc, dataType, properties);
        return true;
    }

    private List getStations() {
        if (this.nexradStations == null) {
            this.nexradStations = new Vector();
            List radarLocations = this.getIdv().getResourceManager().findLocationsByType("radar");
            for (int i = 0; i < radarLocations.size(); ++i) {
                NamedStationTable nexrTable = (NamedStationTable)radarLocations.get(i);
                this.nexradStations.addAll(nexrTable.values());
            }
            Collections.sort(this.nexradStations);
        }
        return this.nexradStations;
    }

    protected void guessAtStation(File file) {
        if (file == null || !file.isDirectory()) {
            return;
        }
        if (this.nexradStations == null || this.nexradStations.isEmpty()) {
            return;
        }
        int dirLevel = 0;
        boolean found = false;
        for (File tmpFile = file; tmpFile != null && !found; tmpFile = tmpFile.getParentFile()) {
            String name = tmpFile.getName().toLowerCase();
            for (NamedStation station : this.nexradStations) {
                String id;
                if (station == null || name.indexOf((id = station.getIdentifier()).toLowerCase()) < 0) continue;
                this.stationsCbx.setSelectedItem(DisplayControlBase.createStationTfo(station));
                found = true;
                break;
            }
            ++dirLevel;
        }
        if (!found) {
            this.stationsCbx.setSelectedItem(UNKNOWN_STATION);
        }
    }

    public class Level2RadarFileChooser
    extends FileChooser.MyFileChooser {
        Level2RadarChooser myChooser;
        File lastDirectory;

        public Level2RadarFileChooser(Level2RadarChooser chooser, String path) {
            super(path);
            this.lastDirectory = null;
            this.myChooser = chooser;
        }

        @Override
        public void setCurrentDirectory(File file) {
            super.setCurrentDirectory(file);
            if (!Misc.equals(file, this.lastDirectory)) {
                if (this.myChooser != null) {
                    this.myChooser.guessAtStation(file);
                }
                this.lastDirectory = file;
            }
        }
    }
}

