/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.data.DataManager;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.chooser.FileChooser;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.XmlChooser;
import ucar.unidata.idv.chooser.adde.AddeChooser;
import ucar.unidata.idv.chooser.adde.AddeServer;
import ucar.unidata.idv.ui.IdvXmlUi;
import ucar.unidata.ui.XmlUi;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class IdvChooserManager
extends IdvManager {
    public static final String PROP_CHOOSER_TREEVIEW = "idv.chooser.treeview";
    public static final String PROP_CHOOSER_TREEVIEW_WIDTH = "idv.chooser.treeview.width";
    public static final String PROP_CHOOSER_TREEVIEW_USESPLITPANE = "idv.chooser.treeview.usesplitpane";
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(IdvChooserManager.class.getName());
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_HELPPATH = "helppath";
    public static final String ATTR_CHOOSERID = "id";
    public static final String TAG_DIRECTORY = "directory";
    public static final String TAG_TAB = "tab";
    public static final String TAG_LABEL = "label";
    public static final String ATTR_DATASOURCE = "datasource";
    public static final String ATTR_PATH = "path";
    public static final String ATTR_PATTERN = "pattern";
    public static final String ATTR_DOPOLLING = "dopolling";
    public static final String ATTR_POLLINTERVAL = "pollinterval";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_MENUTITLE = "menutitle";
    public static final String ATTR_SHOWINMENU = "showinmenu";
    XmlResourceCollection fixedChoosers;
    private List chooserIds = new ArrayList();
    private Hashtable idToName = new Hashtable();
    private Hashtable componentToChooserId = new Hashtable();
    XmlResourceCollection usersResources;
    private DataManager dataManager;
    private Element dataChooserRoot;
    private Document dataChooserDocument;
    private Hashtable tabNodeToPanel = new Hashtable();
    private List choosersWeAreCreating;
    private XmlChooser xmlChooser;
    private JComponent xmlChooserWrapper;
    private FileChooser fileChooser;
    private JComponent fileChooserWrapper;
    private boolean haveInitialized = false;
    private List addeServers = new ArrayList();
    private List<String> selectedDataSourceIds = null;

    public IdvChooserManager(IntegratedDataViewer idv) {
        super(idv);
        XmlResourceCollection addeServerResources = idv.getResourceManager().getXmlResources(IdvResourceManager.RSC_ADDESERVER);
        try {
            for (int resourceIdx = 0; resourceIdx < addeServerResources.size(); ++resourceIdx) {
                Element root = addeServerResources.getRoot(resourceIdx);
                if (root == null) continue;
                List servers = AddeServer.processXml(root);
                if (addeServerResources.isWritableResource(resourceIdx)) {
                    for (int serverIdx = 0; serverIdx < servers.size(); ++serverIdx) {
                        AddeServer addeServer = (AddeServer)servers.get(serverIdx);
                        addeServer.setIsLocal(true);
                        List groups = addeServer.getGroups();
                        for (int groupIdx = 0; groupIdx < groups.size(); ++groupIdx) {
                            AddeServer.Group group = (AddeServer.Group)groups.get(groupIdx);
                            group.setIsLocal(true);
                        }
                    }
                }
                this.addeServers.addAll(servers);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error processing adde server descriptions", exc);
        }
        this.addeServers = AddeServer.coalesce(this.addeServers);
        Object oldServers = this.getIdv().getStore().get("idv.data.adde.servers");
        if (oldServers != null && oldServers instanceof List) {
            List prefs = (List)oldServers;
            for (int i = 0; i < prefs.size(); ++i) {
                String server = (String)prefs.get(i);
                this.addAddeServer(server);
            }
            this.getIdv().getStore().remove("idv.data.adde.servers");
            this.getIdv().getStore().saveIfNeeded();
            this.writeAddeServers();
        }
        this.fixedChoosers = idv.getResourceManager().getXmlResources(IdvResourceManager.RSC_CHOOSERS);
        this.usersResources = idv.getResourceManager().getXmlResources(IdvResourceManager.RSC_USERCHOOSER);
        if (this.usersResources.hasWritableResource()) {
            this.dataChooserDocument = this.usersResources.getWritableDocument("<tabs></tabs>");
            this.dataChooserRoot = this.usersResources.getWritableRoot("<tabs></tabs>");
        }
    }

    public void removeAddeServerGroup(AddeServer server, AddeServer.Group group, boolean markAsInactive) {
        if (!markAsInactive) {
            server.getGroups().remove(group);
        } else {
            group.setActive(false);
            group.setIsLocal(true);
        }
        this.writeAddeServers();
    }

    public void activateAddeServerGroup(AddeServer server, AddeServer.Group group) {
        group.setActive(true);
        group.setIsLocal(true);
        this.writeAddeServers();
    }

    public AddeServer.Group addAddeServerGroup(AddeServer server, String groupName, String type) {
        AddeServer.Group group = server.findGroup(groupName);
        if (group != null) {
            return group;
        }
        group = new AddeServer.Group(type, groupName, groupName);
        group.setIsLocal(true);
        server.addGroup(group);
        this.writeAddeServers();
        return group;
    }

    public void writeAddeServers() {
        try {
            XmlResourceCollection addeServerResources = this.getIdv().getResourceManager().getXmlResources(IdvResourceManager.RSC_ADDESERVER);
            Element root = AddeServer.toXml(this.addeServers, true);
            addeServerResources.writeWritableResource(XmlUtil.toString(root));
            ++AddeChooser.serverTimeStamp;
        }
        catch (Exception exc) {
            LogUtil.logException("Error writing the local addeservers file", exc);
        }
    }

    public AddeServer addAddeServer(String name) {
        AddeServer addeServer;
        for (int i = 0; i < this.addeServers.size(); ++i) {
            addeServer = (AddeServer)this.addeServers.get(i);
            if (!addeServer.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return addeServer;
        }
        addeServer = new AddeServer(name);
        addeServer.setIsLocal(true);
        this.addeServers.add(addeServer);
        this.writeAddeServers();
        return addeServer;
    }

    public void removeAddeServer(AddeServer server, boolean markAsInactive) {
        if (!markAsInactive) {
            this.addeServers.remove(server);
        } else {
            server.setActive(false);
            server.setIsLocal(true);
        }
        this.writeAddeServers();
    }

    public List getAddeServers(String groupType) {
        return this.getAddeServers(groupType, true);
    }

    public List getAddeServers(String groupType, boolean onlyActive) {
        ArrayList servers = groupType == null ? new ArrayList(this.addeServers) : AddeServer.getServersWithType(groupType, this.addeServers);
        if (!onlyActive) {
            return servers;
        }
        ArrayList<AddeServer> activeServers = new ArrayList<AddeServer>();
        for (int i = 0; i < this.addeServers.size(); ++i) {
            AddeServer addeServer = (AddeServer)this.addeServers.get(i);
            if (!addeServer.getActive()) continue;
            activeServers.add(addeServer);
        }
        return activeServers;
    }

    public List getChoosers() {
        return this.getIdv().getIdvUIManager().getWindowGroup("choosers");
    }

    public JComponent getChooserContents() {
        return null;
    }

    public void init() {
        if (this.haveInitialized) {
            return;
        }
        this.haveInitialized = true;
    }

    public JComponent createChoosers(boolean inTabs) {
        return this.createChoosers(inTabs, new ArrayList(), null);
    }

    public JComponent createChoosers(boolean inTabs, List theseChoosers, Element choosersNode) {
        Element root;
        JComponent contents = null;
        StringBuffer sb = new StringBuffer();
        StringBuffer otherXml = new StringBuffer();
        String pre = null;
        String post = null;
        if (theseChoosers == null) {
            theseChoosers = new ArrayList();
        }
        this.choosersWeAreCreating = theseChoosers;
        for (int resourceIdx = 0; resourceIdx < this.fixedChoosers.size(); ++resourceIdx) {
            root = this.fixedChoosers.getRoot(resourceIdx);
            if (root == null) continue;
            NodeList nodeList = XmlUtil.getElements(root);
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element node = (Element)nodeList.item(j);
                if (node.getTagName().equals("components") || node.getTagName().equals("styles")) {
                    otherXml.append(XmlUtil.toString(node));
                    continue;
                }
                if (node.getTagName().equals("properties")) {
                    if (pre == null) {
                        XmlNodeList props = XmlUtil.getElements(node, "property");
                        for (int k = 0; k < props.getLength(); ++k) {
                            Element prop = (Element)props.item(k);
                            if (XmlUtil.getAttribute(prop, "name").equals("idv.chooser.toptag.open")) {
                                pre = XmlUtil.getAttribute(prop, "value");
                                continue;
                            }
                            if (!XmlUtil.getAttribute(prop, "name").equals("idv.chooser.toptag.close")) continue;
                            post = XmlUtil.getAttribute(prop, "value");
                        }
                    }
                    otherXml.append(XmlUtil.toString(node));
                    continue;
                }
                sb.append(XmlUtil.toString(node));
            }
        }
        if (pre == null || pre.trim().length() == 0) {
            if (inTabs) {
                pre = "<buttontabbedpane>";
                post = "</buttontabbedpane>";
            } else {
                String attrs = "usesplitpane=\"" + this.getIdv().getProperty(PROP_CHOOSER_TREEVIEW_USESPLITPANE, true) + "\"  ";
                attrs = attrs + "treewidth=\"" + this.getIdv().getProperty(PROP_CHOOSER_TREEVIEW_WIDTH, 200) + "\"";
                pre = "<treepanel " + attrs + ">";
                post = "</treepanel>";
            }
        }
        try {
            String xml = "<skin>" + otherXml + "<ui>" + pre + sb.toString() + post + "</ui></skin>";
            root = XmlUtil.getRoot(xml);
            XmlUi xmlUi = this.createXmlUi(root);
            this.collectIds(root);
            contents = (JComponent)xmlUi.getContents();
            this.pruneEmptyTabs(contents);
        }
        catch (Exception exc) {
            LogUtil.logException("Error processing chooser xml", exc);
            contents = new JPanel();
        }
        try {
            this.processChooserXml();
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Processing user chooser xml.", exc);
        }
        this.choosersWeAreCreating = null;
        Msg.translateTree(contents, true, false);
        return contents;
    }

    protected XmlUi createXmlUi(Element root) {
        return new IdvXmlUi(this.getIdv(), root);
    }

    private boolean pruneEmptyTabs(JComponent comp) {
        boolean anyContainedChoosers;
        Component[] components = comp.getComponents();
        boolean bl = anyContainedChoosers = this.componentToChooserId.get(comp) != null;
        if (anyContainedChoosers) {
            return true;
        }
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            JComponent child = (JComponent)components[i];
            anyContainedChoosers |= this.pruneEmptyTabs(child);
        }
        if (comp.getParent() != null && comp.getParent() instanceof JTabbedPane && !anyContainedChoosers) {
            comp.getParent().remove(comp);
        }
        return anyContainedChoosers;
    }

    public Component createChooser(Node chooserNode) {
        String className = XmlUtil.getAttribute(chooserNode, ATTR_CLASS);
        String id = IdvChooserManager.getChooserId((Element)chooserNode);
        IdvChooser chooser = null;
        try {
            Class theClass = Misc.findClass(className);
            if (theClass != null) {
                Class[] paramTypes = new Class[]{IdvChooserManager.class, Element.class};
                Object[] args = new Object[]{this, chooserNode};
                Constructor ctor = Misc.findConstructor(theClass, paramTypes);
                if (ctor != null) {
                    chooser = (IdvChooser)ctor.newInstance(args);
                    chooser.setHelpPath(XmlUtil.getAttribute(chooserNode, ATTR_HELPPATH, "idv.data.choosers"));
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Unable to create chooser class: " + className + " \nError: " + exc);
        }
        if (chooser == null) {
            throw new IllegalArgumentException("Unable to create chooser class: " + className);
        }
        JComponent contents = chooser.getContents();
        if (this.choosersWeAreCreating != null) {
            this.choosersWeAreCreating.add(chooser);
        }
        JComponent chooserContents = contents;
        this.componentToChooserId.put(chooserContents, id);
        if (chooser instanceof XmlChooser) {
            this.xmlChooserWrapper = chooserContents;
            this.xmlChooser = (XmlChooser)chooser;
        }
        if (chooser instanceof FileChooser) {
            this.fileChooserWrapper = chooserContents;
            this.fileChooser = (FileChooser)chooser;
        }
        return chooserContents;
    }

    public void showCatalogUrl(String url) {
        if (this.xmlChooser != null) {
            this.xmlChooser.makeUiFromPath(url);
            GuiUtils.showComponentInTabs(this.xmlChooserWrapper);
        }
    }

    public void showFileChooser(String path) {
        if (this.fileChooser != null) {
            this.fileChooser.getFileChooser().setCurrentDirectory(new File(path));
            GuiUtils.showComponentInTabs(this.fileChooserWrapper);
        }
    }

    public List makeChooserMenus(List items) {
        List choosers = this.getChoosers();
        if (choosers == null || choosers.size() == 0) {
            if (!this.getIdv().getIdvUIManager().haveBasicWindow()) {
                this.getIdv().getIdvUIManager().showBasicWindow(true);
            }
            choosers = this.getChoosers();
        }
        if (choosers == null || choosers.size() == 0) {
            return new ArrayList();
        }
        Hashtable<String, String> seen = new Hashtable<String, String>();
        for (int i = 0; i < choosers.size(); ++i) {
            final IdvChooser chooser = (IdvChooser)choosers.get(i);
            if (!chooser.getShowInMenu() || seen.get(chooser.getId()) != null) continue;
            seen.put(chooser.getId(), "");
            if (!this.getIdv().getPreferenceManager().shouldShowChooser(chooser.getId())) continue;
            JMenuItem mi = new JMenuItem(chooser.getMenuTitle());
            items.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GuiUtils.showComponentInTabs(chooser.getContents());
                }
            });
        }
        return items;
    }

    public static String getChooserId(Element node) {
        String chooserId = XmlUtil.getAttribute((Node)node, ATTR_CHOOSERID, (String)null);
        if (chooserId == null && (chooserId = XmlUtil.getAttribute((Node)node, ATTR_TITLE, (String)null)) == null) {
            chooserId = XmlUtil.getAttribute((Node)node, ATTR_CLASS, (String)null);
        }
        return chooserId;
    }

    private void collectIds(Element node) {
        String chooserId;
        String tagName = node.getTagName();
        if (tagName.equals("chooser") && !this.chooserIds.contains(chooserId = IdvChooserManager.getChooserId(node))) {
            this.chooserIds.add(chooserId);
            this.idToName.put(chooserId, XmlUtil.getAttribute((Node)node, ATTR_TITLE, chooserId));
        }
        NodeList nodeList = XmlUtil.getElements(node);
        for (int j = 0; j < nodeList.getLength(); ++j) {
            this.collectIds((Element)nodeList.item(j));
        }
    }

    public List getChooserIds() {
        return this.chooserIds;
    }

    public String getChooserName(String chooserId) {
        String name = (String)this.idToName.get(chooserId);
        if (name == null) {
            return chooserId;
        }
        return name;
    }

    public JMenu addUserChooserToMenu(JMenu menu, JMenu pullRight) {
        if (this.dataChooserRoot == null) {
            return pullRight;
        }
        List tabNodes = XmlUtil.findChildren(this.dataChooserRoot, TAG_TAB);
        for (int tabIdx = 0; tabIdx < tabNodes.size(); ++tabIdx) {
            Element tabNode = (Element)tabNodes.get(tabIdx);
            if (pullRight == null) {
                pullRight = new JMenu("Local");
                menu.add(pullRight);
            }
            JMenu tabMenu = new JMenu(XmlUtil.getAttribute(tabNode, ATTR_TITLE));
            pullRight.add(tabMenu);
            NodeList nodeList = XmlUtil.getElements(tabNode);
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element node = (Element)nodeList.item(j);
                if (!node.getNodeName().equals(TAG_DIRECTORY)) continue;
                JMenuItem mi = new JMenuItem(XmlUtil.getAttribute(node, "label"));
                mi.addActionListener(new ObjectListener(node){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        IdvChooserManager.this.makeDataSourceFromXml((Element)this.theObject);
                    }
                });
                tabMenu.add(mi);
            }
        }
        return pullRight;
    }

    private List<String> getSelectedDataSourceIds() {
        if (this.selectedDataSourceIds == null) {
            this.selectedDataSourceIds = (List)this.getIdv().getStore().getEncodedFile("selecteddatasourceids.xml");
        }
        if (this.selectedDataSourceIds == null) {
            this.selectedDataSourceIds = new ArrayList<String>();
        }
        return this.selectedDataSourceIds;
    }

    private void writeSelectedDataSourceIds() {
        if (this.selectedDataSourceIds != null) {
            this.getIdv().getStore().putEncodedFile("selecteddatasourceids.xml", this.selectedDataSourceIds);
        }
    }

    public List sortDataSourceIds(List ids) {
        ArrayList<TwoFacedObject> result = new ArrayList<TwoFacedObject>();
        for (String id : this.getSelectedDataSourceIds()) {
            TwoFacedObject tfo = TwoFacedObject.findId(id, ids);
            if (tfo == null) continue;
            ids.remove(tfo);
            result.add(tfo);
        }
        TwoFacedObject.sort(ids);
        result.addAll(ids);
        return result;
    }

    public void dataSourceIdSelected(String id) {
        List<String> ids = this.getSelectedDataSourceIds();
        ids.remove(id);
        ids.add(0, id);
        while (this.selectedDataSourceIds.size() > 15) {
            ids.remove(this.selectedDataSourceIds.size() - 1);
        }
        this.writeSelectedDataSourceIds();
    }

    public void makeDataSourceFromXml(Element theNode) {
        String title = XmlUtil.getAttribute(theNode, "label");
        String dataSource = XmlUtil.getAttribute(theNode, ATTR_DATASOURCE);
        String path = XmlUtil.getAttribute(theNode, ATTR_PATH);
        String pattern = XmlUtil.getAttribute((Node)theNode, ATTR_PATTERN, (String)null);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("TITLE", title);
        if (pattern != null) {
            // empty if block
        }
        this.getIdv().makeDataSource(path, dataSource, properties);
    }

    private void newPane() {
        if (this.dataChooserRoot == null) {
            return;
        }
        String paneName = GuiUtils.getInput("New Pane Name: ");
        if (paneName == null) {
            return;
        }
        Element tabElement = this.dataChooserDocument.createElement(TAG_TAB);
        tabElement.setAttribute(ATTR_TITLE, paneName);
        this.dataChooserRoot.appendChild(tabElement);
        this.writeChooserXml();
        this.processChooserXml();
    }

    public void closeDataChooser() {
        this.getIdv().getIdvUIManager().showDataSelector();
        super.close();
    }

    @Override
    protected boolean shouldMakeDialog() {
        return true;
    }

    @Override
    protected String getWindowTitle() {
        return "Data Source Chooser";
    }

    protected void popupXmlChooserDialog(Element tabNode, Element dirNode) {
        TwoFacedObject current;
        int index;
        if (this.dataChooserRoot == null) {
            return;
        }
        boolean edit = dirNode != null;
        List sources = this.dataManager.getFileDataSourceList();
        JComboBox dataSourceBox = new JComboBox(new Vector(sources));
        if (dirNode != null && (index = sources.indexOf(current = new TwoFacedObject((Object)"", XmlUtil.getAttribute(dirNode, ATTR_DATASOURCE)))) >= 0) {
            dataSourceBox.setSelectedIndex(index);
        }
        JTextField patternField = new JTextField(edit ? XmlUtil.getAttribute((Node)dirNode, ATTR_PATTERN, "") : "", 25);
        JTextField labelField = new JTextField(edit ? XmlUtil.getAttribute(dirNode, "label") : "", 25);
        JTextField fileField = new JTextField(edit ? XmlUtil.getAttribute(dirNode, ATTR_PATH) : "", 25);
        JCheckBox pollingCbx = new JCheckBox("Check this data source periodically for changes?", edit ? XmlUtil.getAttribute((Node)dirNode, ATTR_DOPOLLING, false) : false);
        JTextField intervalField = new JTextField(edit ? "" + XmlUtil.getAttribute((Node)dirNode, ATTR_POLLINTERVAL, 10) : "10", 5);
        JButton fileButton = GuiUtils.makeJButton("Select", new ObjectListener(fileField){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser(((JTextField)this.theObject).getText());
                chooser.setFileSelectionMode(2);
                chooser.setApproveButtonText("Select");
                chooser.showOpenDialog(null);
                File file = chooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                ((JTextField)this.theObject).setText(file.toString());
            }
        });
        JPanel intervalPanel = GuiUtils.doLayout(new Component[]{intervalField, new JLabel(" (Seconds)"), GuiUtils.filler()}, 3, GuiUtils.WT_NNY, GuiUtils.WT_N);
        JPanel dataSourcePanel = GuiUtils.doLayout(new Component[]{dataSourceBox, GuiUtils.filler()}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        GuiUtils.setHFill();
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        JPanel contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Label: "), labelField, GuiUtils.filler(), GuiUtils.rLabel("File or Directory: "), fileField, fileButton, GuiUtils.rLabel("Data Source Type: "), dataSourcePanel, GuiUtils.filler(), GuiUtils.rLabel("File Pattern: "), patternField, GuiUtils.filler(), GuiUtils.filler(), pollingCbx, GuiUtils.filler(), GuiUtils.rLabel("If so, how often:"), intervalPanel}, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
        int newPollingInterval = 0;
        boolean keepTrying = true;
        while (keepTrying) {
            int result;
            if (edit) {
                result = GuiUtils.makeDialog(null, "Edit Chooser Entry", contents, null, new String[]{"Delete", "OK", "Cancel"});
                if (result == 2) {
                    return;
                }
                if (result == 0) {
                    if (!GuiUtils.showYesNoDialog(null, "Are you sure you want to delete the entry?", "Delete Confirmation")) continue;
                    tabNode.removeChild(dirNode);
                    this.writeChooserXml();
                    this.processChooserXml();
                    return;
                }
            } else {
                result = GuiUtils.makeDialog(null, "Create Chooser Entry", contents, null, new String[]{"Create", "Cancel"});
                if (result == 1) {
                    return;
                }
            }
            try {
                newPollingInterval = new Integer(intervalField.getText().trim());
                keepTrying = false;
            }
            catch (Exception exc) {
                LogUtil.userErrorMessage(log_, "Bad polling interval:" + intervalField.getText());
            }
        }
        if (!edit) {
            dirNode = this.dataChooserDocument.createElement(TAG_DIRECTORY);
            tabNode.appendChild(dirNode);
        }
        dirNode.setAttribute(ATTR_DATASOURCE, (String)((TwoFacedObject)dataSourceBox.getSelectedItem()).getId());
        dirNode.setAttribute(ATTR_PATH, fileField.getText());
        dirNode.setAttribute(ATTR_PATTERN, patternField.getText());
        dirNode.setAttribute("label", labelField.getText());
        dirNode.setAttribute(ATTR_DOPOLLING, "" + pollingCbx.isSelected());
        dirNode.setAttribute(ATTR_POLLINTERVAL, "" + newPollingInterval);
        this.writeChooserXml();
        this.processChooserXml();
    }

    public void processChooserXml() {
        for (int i = this.usersResources.size() - 1; i >= 0; --i) {
            this.processChooserXml(this.usersResources.isWritable(i), this.usersResources.getRoot(i));
        }
    }

    public void processChooserXml(boolean writable, Element root) {
    }

    private void removeTab(Element tabNode) {
        if (this.dataChooserRoot == null) {
            return;
        }
        JPanel tabComponent = (JPanel)this.tabNodeToPanel.get(tabNode);
        this.dataChooserRoot.removeChild(tabNode);
        this.writeChooserXml();
        this.processChooserXml();
    }

    protected void writeChooserXml() {
        if (this.dataChooserRoot == null) {
            return;
        }
        try {
            this.usersResources.writeWritable();
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "writing chooser xml", exc);
        }
    }

    public JComboBox getDataSourcesComponent(boolean justFileSources, DataManager dataManager) {
        return this.getDataSourcesComponent(justFileSources, dataManager, true);
    }

    public JComboBox getDataSourcesComponent(boolean justFileSources, DataManager dataManager, boolean addLucky) {
        JComboBox dataSourcesCbx = new JComboBox();
        List<String> dataSources = new ArrayList();
        List fileDataSources = justFileSources ? dataManager.getFileDataSourceList() : dataManager.getAllDataSourceIds();
        dataSources.addAll(fileDataSources);
        dataSources = this.sortDataSourceIds(dataSources);
        if (addLucky) {
            dataSources.add(0, "I'm Feeling Lucky");
        }
        GuiUtils.setListData(dataSourcesCbx, dataSources);
        dataSourcesCbx.setToolTipText("<html>Optional way to specifically select<br>the type of datasource.</html>");
        return dataSourcesCbx;
    }
}

