/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.DataManager;
import ucar.unidata.data.DataSource;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.gis.GisFeatureRenderer;
import ucar.unidata.gis.mcidasmap.McidasMap;
import ucar.unidata.gis.shapefile.EsriShapefileRenderer;
import ucar.unidata.idv.IdvConstants;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.metdata.Station;
import ucar.unidata.ui.ChooserPanel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PreferenceList;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.CompositeRenderer;
import ucar.unidata.view.station.StationLocationMap;
import ucar.unidata.xml.XmlUtil;
import visad.DateTime;

public abstract class IdvChooser
extends ChooserPanel
implements IdvConstants {
    public static final String PROP_CHOOSER_MAPS = "idv.chooser.maps";
    public static final String PROP_STATUS_FOREGROUND = "idv.chooser.status.foreground";
    public static final String PROP_STATUS_BACKGROUND = "idv.chooser.status.background";
    public static final String PROP_STATUS_TEMPLATE = "idv.chooser.status.template";
    public static final String PROP_CHOOSER_PROJECTION_BOUNDS = "idv.chooser.projection.bounds";
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(IdvChooser.class.getName());
    public static final String PROP_CHOOSERCLASSNAME = "prop.chooserclassname";
    public static final Hashtable NULL_PROPERTIES = null;
    public static final String NULL_STRING = null;
    public static final String PREF_DEFAULTDIR = "Data.DefaultDir";
    public static final String PREF_POLLINGINFO = "chooser.pollinginfo";
    public static final String PREF_CATALOGLIST = "idv.data.catalog.list";
    public static final String PREF_ADDESERVERS = "idv.data.adde.servers";
    public static final String PREF_IMAGEDESCLIST = "idv.data.adde.image.descriptors";
    public static final String PREF_RADARDESCLIST = "idv.data.adde.radar.descriptors";
    public static final String PREF_TDSRADARSERVER = "idv.data.tds.radar.servers";
    public static final String PREF_TDSPOINTOBSERVER = "idv.data.tds.pointob.servers";
    private static Hashtable prefLists = new Hashtable();
    public static final String ATTR_ID = "id";
    public static final String ATTR_SHOWDETAILS = "showdetails";
    String id;
    IdvChooserManager chooserManager;
    IntegratedDataViewer idv;
    DataManager dataManager;
    Element chooserNode;
    private JComboBox dataSourcesCbx;
    private DataSource dataSource;
    boolean hasContentsBeenPainted = false;
    protected boolean ignoreDirHistory = false;
    protected JComboBox dirHistoryCbx;
    JCheckBox autoCreateDisplayCbx;
    protected StationLocationMap stationMap;
    private List selectedStations = new ArrayList();
    private ActionListener dataSourceListener;

    public IdvChooser(IntegratedDataViewer idv, Element chooserNode) {
        this(idv, null, chooserNode);
    }

    public IdvChooser(IdvChooserManager chooserManager, Element chooserNode) {
        this(chooserManager.getIdv(), chooserManager, chooserNode);
    }

    public IdvChooser(IntegratedDataViewer idv, IdvChooserManager chooserManager, Element chooserNode) {
        this.chooserNode = chooserNode;
        this.chooserManager = chooserManager;
        this.idv = idv;
        this.dataManager = idv.getDataManager();
        this.id = chooserNode != null ? XmlUtil.getAttribute((Node)chooserNode, ATTR_ID, this.getClass().getName()) : "noid";
        this.setMessageTemplate(this.idv.getProperty(PROP_STATUS_TEMPLATE, null));
        this.init();
    }

    @Override
    protected JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = GuiUtils.cLabel(" ");
            this.statusLabel.setOpaque(true);
            this.statusLabel.setForeground(this.getStatusLabelForeground());
            this.statusLabel.setBackground(this.getStatusLabelBackground());
        }
        return this.statusLabel;
    }

    public JComponent decorateButtons(JComponent buttons) {
        return buttons;
    }

    @Override
    public JComponent getDefaultButtons(ActionListener listener) {
        if (this.dataSource != null) {
            JButton reloadButton = GuiUtils.makeButton("Reload Data", this, "doLoad");
            return GuiUtils.wrap(reloadButton);
        }
        JComponent buttons = super.getDefaultButtons(listener);
        buttons = this.decorateButtons(buttons);
        JComponent extra = GuiUtils.filler(100, 1);
        String displayType = this.getDefaultDisplayType();
        if (displayType != null) {
            String id = "idv." + this.getId() + ".autocreate";
            boolean createDisplay = this.idv.getStore().get(id, true);
            this.autoCreateDisplayCbx = new JCheckBox("Create display", createDisplay);
            this.autoCreateDisplayCbx.setToolTipText("Automatically create a display when data is loaded");
            extra = GuiUtils.vbox(extra, this.autoCreateDisplayCbx);
        }
        buttons = GuiUtils.leftCenterRight(GuiUtils.filler(100, 1), GuiUtils.doLayout(new Component[]{this.getStatusComponent(), buttons}, 1, GuiUtils.WT_Y, GuiUtils.WT_N), GuiUtils.bottom(GuiUtils.right(extra)));
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        return buttons;
    }

    protected String getDefaultDisplayType() {
        return null;
    }

    protected void getDataSourceProperties(Hashtable ht) {
        if (this.autoCreateDisplayCbx != null) {
            String id = "idv." + this.getId() + ".autocreate";
            boolean current = this.idv.getStore().get(id, true);
            if (current != this.autoCreateDisplayCbx.isSelected()) {
                this.idv.getStore().put(id, this.autoCreateDisplayCbx.isSelected());
                this.idv.getStore().save();
            }
            if (this.autoCreateDisplayCbx.isSelected()) {
                String displayType = this.getDefaultDisplayType();
                ht.put("idv.data.autocreatedisplay", displayType);
            }
        }
    }

    protected String getDefaultMap() {
        return "/auxdata/maps/OUTLUSAM";
    }

    protected List getDefaultMaps() {
        String maps = this.getProperty(PROP_CHOOSER_MAPS, "/auxdata/maps/OUTLUSAM");
        return StringUtil.split(maps, ";", true, true);
    }

    protected void initStationMap(StationLocationMap stationMap) {
        List maps = this.getDefaultMaps();
        CompositeRenderer renderer = new CompositeRenderer();
        for (int i = 0; i < maps.size(); ++i) {
            GisFeatureRenderer mmr;
            String map = (String)maps.get(i);
            if (map.toLowerCase().endsWith(".shp") || map.toLowerCase().endsWith(".zip")) {
                try {
                    mmr = EsriShapefileRenderer.factory(IOUtil.getInputStream(map, this.getClass()));
                }
                catch (Exception exc) {
                    System.err.println("Failed to read map:" + map + "\n" + exc);
                    continue;
                }
                if (mmr == null) {
                    System.err.println("Failed to read map:" + map);
                    continue;
                }
            } else {
                mmr = new McidasMap(map);
            }
            mmr.setColor(MAP_COLOR);
            renderer.addRenderer(mmr);
        }
        stationMap.setMapRenderer(renderer);
        stationMap.setProjectionImpl(this.getDefaultProjection());
    }

    protected StationLocationMap createStationMap() {
        StationLocationMap map = new StationLocationMap(){

            @Override
            public void setDeclutter(boolean declutter) {
                super.setDeclutter(declutter);
                IdvChooser.this.updateStatus();
            }
        };
        return map;
    }

    protected boolean usingStations() {
        return this.stationMap != null;
    }

    protected boolean haveStationSelected() {
        return this.selectedStations != null && this.selectedStations.size() > 0;
    }

    protected void newSelectedStations(List stations) {
        this.selectedStations = new ArrayList(stations);
        this.updateStatus();
    }

    protected StationLocationMap getStationMap() {
        if (this.stationMap == null) {
            this.stationMap = this.createStationMap();
            this.registerStatusComp("stationmap", this.stationMap);
            this.initStationMap(this.stationMap);
            this.stationMap.setPreferredSize(new Dimension(300, 250));
            this.stationMap.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    IdvChooser.this.newSelectedStations(IdvChooser.this.stationMap.getSelectedStations());
                }
            });
        }
        return this.stationMap;
    }

    public List getSelectedStations() {
        return this.selectedStations;
    }

    protected String getSelectedStation() {
        List stations = this.getSelectedStations();
        if (stations.size() == 0) {
            return null;
        }
        return ((Station)stations.get(0)).getIdentifier();
    }

    protected void clearSelectedStations() {
        this.selectedStations = new ArrayList();
        if (this.stationMap != null) {
            this.stationMap.setSelectedStations(this.selectedStations);
        }
    }

    protected void clearStations() {
        if (this.stationMap != null) {
            this.stationMap.setStations(new ArrayList());
        }
    }

    protected boolean getHaveStations() {
        if (this.stationMap != null) {
            List stations = this.stationMap.getStations();
            return stations != null && !stations.isEmpty();
        }
        return false;
    }

    protected ProjectionImpl getDefaultProjection() {
        String prop = this.getProperty(PROP_CHOOSER_PROJECTION_BOUNDS, "40,-100,60,20");
        List<String> toks = StringUtil.split(prop, ",", true, true);
        if (toks.size() != 4) {
            System.err.println("Bad property value for:idv.chooser.projection.bounds " + prop);
            toks = StringUtil.split("40,-100,60,20", ",", true, true);
        }
        LambertConformal proj = new LambertConformal(new Integer(toks.get(0).toString()).intValue(), new Integer(toks.get(1).toString()).intValue(), new Integer(toks.get(2).toString()).intValue(), new Integer(toks.get(3).toString()).intValue());
        proj.setDefaultMapArea(this.getDefaultProjectionRect());
        return proj;
    }

    protected ProjectionRect getDefaultProjectionRect() {
        return new ProjectionRect(-2000.0, -1800.0, 2500.0, 1800.0);
    }

    public List makeTimeMenus(final ActionListener listener) {
        ArrayList<JMenuItem> menus = new ArrayList<JMenuItem>();
        List<ViewManager> vms = this.getIdv().getVMManager().getViewManagers();
        try {
            int cnt = 0;
            for (int i = 0; i < vms.size(); ++i) {
                ViewManager vm = vms.get(i);
                final DateTime[] times = vm.getAnimationTimes();
                if (times == null || times.length == 0) continue;
                String name = vm.getName();
                if (name == null || name.trim().length() == 0) {
                    name = "Display " + ++cnt;
                }
                JMenuItem mi = new JMenuItem("Times from " + name);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        listener.actionPerformed(new ActionEvent(times, 1, "times"));
                    }
                });
                menus.add(mi);
            }
        }
        catch (Exception exc) {
            this.logException("Making center menu", exc);
        }
        return menus;
    }

    public Element getXmlNode() {
        return this.chooserNode;
    }

    protected String getAttribute(String name, String dflt) {
        String value = XmlUtil.getAttribute((Node)this.chooserNode, name, (String)null);
        if (value == null) {
            return dflt;
        }
        return this.idv.getStateManager().applyMacros(value);
    }

    public String getProperty(String name, String dflt) {
        String retVal = this.idv.getProperty("idv." + this.getId() + "." + name, null);
        if (retVal == null) {
            retVal = this.idv.getProperty(name, dflt);
        }
        if (retVal == null) {
            retVal = XmlUtil.getAttribute((Node)this.chooserNode, name, dflt);
        }
        return retVal;
    }

    public boolean getProperty(String name, boolean dflt) {
        boolean hasIt = XmlUtil.hasAttribute(this.chooserNode, name);
        boolean retVal = dflt;
        retVal = hasIt ? XmlUtil.getAttribute((Node)this.chooserNode, name, dflt) : this.idv.getProperty("idv." + this.getId() + "." + name, dflt);
        return retVal;
    }

    public boolean getShowInMenu() {
        return XmlUtil.getAttribute((Node)this.chooserNode, "showinmenu", true);
    }

    public String getMenuTitle() {
        String title = XmlUtil.getAttribute((Node)this.chooserNode, "menutitle", (String)null);
        if (title != null) {
            return title;
        }
        return this.getTitle();
    }

    public String getTitle() {
        return XmlUtil.getAttribute((Node)this.chooserNode, "title", "Chooser");
    }

    protected void initChooserPanel(ChooserPanel chooserPanel) {
        chooserPanel.setHelpPath(this.helpPath);
    }

    protected JComboBox getDataSourcesComponent() {
        return this.getDataSourcesComponent(true);
    }

    protected JComboBox getDataSourcesComponent(boolean justFileSources) {
        if (this.dataSourcesCbx == null) {
            this.dataSourcesCbx = IdvChooser.getDataSourcesComponent(justFileSources, this.getDataManager());
        }
        return this.dataSourcesCbx;
    }

    public static JComboBox getDataSourcesComponent(boolean justFileSources, DataManager dataManager) {
        return IdvChooser.getDataSourcesComponent(justFileSources, dataManager, true);
    }

    public static JComboBox getDataSourcesComponent(boolean justFileSources, DataManager dataManager, boolean addLucky) {
        return dataManager.getDataContext().getIdv().getIdvChooserManager().getDataSourcesComponent(justFileSources, dataManager, addLucky);
    }

    protected String getDataSourceId() {
        return this.getDataSourceId(this.dataSourcesCbx);
    }

    protected String getDataSourceId(JComboBox dataSourcesCbx) {
        if (dataSourcesCbx == null) {
            return null;
        }
        Object selected = dataSourcesCbx.getSelectedItem();
        if (selected != null && selected instanceof TwoFacedObject) {
            String id = (String)((TwoFacedObject)selected).getId();
            this.chooserManager.dataSourceIdSelected(id);
            return id;
        }
        return null;
    }

    protected void resetDataSourceId() {
        if (this.dataSourcesCbx != null) {
            this.dataSourcesCbx.setSelectedIndex(0);
        }
    }

    protected boolean makeDataSource(Object definingObject, Hashtable properties) {
        return this.makeDataSource(definingObject, null, properties);
    }

    public void setDataSourceListener(ActionListener listener) {
        this.dataSourceListener = listener;
    }

    public boolean isReloadable() {
        return true;
    }

    protected boolean makeDataSource(Object definingObject, String dataType, Hashtable properties) {
        boolean result;
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        if (this.isReloadable()) {
            properties.put(PROP_CHOOSERCLASSNAME, this.getClass().getName());
        }
        if (this.dataSourceListener != null) {
            this.dataSourceListener.actionPerformed(new ActionEvent(new Object[]{definingObject, properties}, 1, ""));
            return true;
        }
        this.showWaitCursor();
        if (this.dataSource != null) {
            try {
                this.dataSource.reloadData(definingObject, properties);
            }
            catch (Exception exc) {
                this.logException("Error reloading data", exc);
            }
            result = false;
        } else {
            result = this.idv.makeDataSource(definingObject, dataType, properties);
        }
        this.showNormalCursor();
        if (result) {
            this.closeChooser();
            this.idv.getIdvUIManager().showDataSelector();
        }
        return result;
    }

    protected Object startTask() {
        Object taskId = JobManager.getManager().startLoad("chooser");
        return taskId;
    }

    protected void stopTask(Object taskId) {
        JobManager.getManager().stopLoad(taskId);
    }

    protected boolean stopTaskAndIsOk(Object taskId) {
        boolean ok = JobManager.getManager().canContinue(taskId);
        this.stopTask(taskId);
        return ok;
    }

    protected boolean taskOk(Object taskId) {
        return JobManager.getManager().canContinue(taskId);
    }

    @Override
    public void showWaitCursor() {
        if (this.contents != null) {
            super.showWaitCursor(this.contents);
        }
        this.idv.getIdvUIManager().showWaitCursor();
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(true);
        }
    }

    @Override
    public void showNormalCursor() {
        if (this.contents != null) {
            super.showNormalCursor(this.contents);
        }
        this.idv.getIdvUIManager().showNormalCursor();
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(false);
        }
    }

    @Override
    public void doClose() {
        this.closeChooser();
    }

    @Override
    public void doCancel() {
        super.doCancel();
        this.getIdv().clearWaitCursor();
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(false);
        }
        this.updateStatus();
    }

    protected void closeChooser() {
        if (this.dataSourceListener != null) {
            return;
        }
        if (this.chooserManager != null) {
            this.chooserManager.closeDataChooser();
        }
    }

    protected void init() {
    }

    private void contentsPainted() {
        if (this.hasContentsBeenPainted) {
            return;
        }
        this.hasContentsBeenPainted = true;
        if (this.shouldDoUpdateOnFirstDisplay()) {
            Misc.run(this, "doUpdate");
        }
    }

    protected boolean shouldDoUpdateOnFirstDisplay() {
        return false;
    }

    @Override
    public final JComponent getContents() {
        if (this.contents == null) {
            JComponent innerContents = this.doMakeContents();
            innerContents = GuiUtils.inset((Component)innerContents, 5);
            JPanel topPanel = new JPanel(new BorderLayout()){

                @Override
                public void paint(Graphics g) {
                    IdvChooser.this.contentsPainted();
                    super.paint(g);
                }
            };
            topPanel.add("Center", innerContents);
            this.setLayout(new BorderLayout());
            this.add("Center", topPanel);
            this.contents = this;
            this.updateStatus();
        }
        return this.contents;
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        if (this.getHaveData()) {
            this.setStatus("Press \"Add Source\" to load the selected data", "buttons");
        }
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public String getId() {
        return this.id;
    }

    public IntegratedDataViewer getIdv() {
        return this.idv;
    }

    @Override
    public void logException(String msg, Exception exc) {
        LogUtil.printException(log_, msg, exc);
    }

    public static void errorMessage(String msg) {
        LogUtil.userErrorMessage(log_, msg);
    }

    public static void userMessage(String msg) {
        LogUtil.userMessage(msg);
    }

    public PreferenceList getPreferenceList(String listProp) {
        boolean merge = this.idv.getProperty(listProp + ".merge", false);
        return this.getPreferenceList(listProp, merge, StringUtil.split(this.idv.getProperty(listProp + ".delete", null), ";"));
    }

    public PreferenceList getPreferenceList(String listProp, boolean mergeTheIdvProperty) {
        return this.getPreferenceList(listProp, mergeTheIdvProperty, StringUtil.split(this.idv.getProperty(listProp + ".delete", null), ";"));
    }

    public PreferenceList getPreferenceList(String listProp, boolean mergeTheIdvProperty, String butNotThisOne) {
        return this.getPreferenceList(listProp, mergeTheIdvProperty, butNotThisOne != null ? Misc.newList(butNotThisOne) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreferenceList getPreferenceList(String listProp, boolean mergeTheIdvProperty, List butNotThese) {
        Hashtable hashtable = prefLists;
        synchronized (hashtable) {
            String chosenProp = listProp + ".chosen";
            PreferenceList prefList = (PreferenceList)prefLists.get(listProp);
            if (prefList == null) {
                List propertyList = this.getPropList(listProp, mergeTheIdvProperty);
                Object chosenProperty = this.idv.getStore().get(chosenProp);
                if (butNotThese != null && !butNotThese.isEmpty()) {
                    for (String butNotThisOne : butNotThese) {
                        if (butNotThisOne == null) continue;
                        if (Misc.equals(butNotThisOne, chosenProperty)) {
                            chosenProperty = null;
                        }
                        if (propertyList == null) continue;
                        propertyList.remove(butNotThisOne);
                    }
                }
                prefList = new PreferenceList(propertyList, chosenProperty, listProp, chosenProp, this.idv.getStore());
                prefLists.put(listProp, prefList);
            }
            return prefList;
        }
    }

    public List getPropList(String property, boolean mergeTheIdvProperty) {
        Object fromPrefs = this.idv.getStore().get(property);
        ArrayList<String> prefList = null;
        if (fromPrefs != null && fromPrefs instanceof List && ((List)fromPrefs).size() > 0) {
            prefList = new ArrayList<String>((List)fromPrefs);
            if (!mergeTheIdvProperty) {
                return prefList;
            }
        }
        List<String> propertyList = StringUtil.split(this.idv.getProperty(property, ""), ";", true, true);
        if (!mergeTheIdvProperty || prefList == null) {
            return propertyList;
        }
        for (int i = 0; i < propertyList.size(); ++i) {
            String prop = propertyList.get(i);
            if (prefList.contains(prop)) continue;
            prefList.add(prop);
        }
        return prefList;
    }

    @Override
    public Color getStatusLabelBackground() {
        return this.getIdv().getColorProperty(PROP_STATUS_BACKGROUND, super.getStatusLabelBackground());
    }

    @Override
    public Color getStatusLabelForeground() {
        return this.getIdv().getColorProperty(PROP_STATUS_FOREGROUND, super.getStatusLabelForeground());
    }

    public void setDataSource(DataSource value) {
        this.dataSource = value;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

