/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.PollingInfo;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;

public class FileChooser
extends IdvChooser {
    public static final String ATTR_PATH = "path";
    public static final String ATTR_FILECOUNT = "filecount";
    public static final String ATTR_POLLON = "pollon";
    public static final String ATTR_DSCOMP = "showdatasourcemenu";
    public static final String ATTR_SHOWPATTERNFIELD = "showpatternfield";
    public static final String ATTR_FILEPATTERN = "filepattern";
    public static final String ATTR_FILTERS = "filters";
    public static final String ATTR_DATASOURCEID = "datasourceid";
    protected JComboBox recentFilesCbx;
    protected JCheckBox allowDirectorySelectionCbx;
    protected JTextField patternFld;
    private JLabel patternLbl;
    private JFileChooser fileChooser;
    private String dfltDataSourceId;
    private JCheckBox doPollingCbx;

    public FileChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    protected String[] getButtonLabels() {
        return new String[]{this.getLoadCommandName(), GuiUtils.CMD_UPDATE, GuiUtils.CMD_HELP};
    }

    @Override
    protected String getLoadToolTip() {
        return "Load the selected file";
    }

    @Override
    protected String getUpdateToolTip() {
        return "Rescan the directory";
    }

    protected JComponent getRecentFilesComponent() {
        int[] values = new int[]{0, 1, 2, 3, 4, 5, 6, 8, 10, 15, 20};
        return this.getRecentFilesComponent(values, 0, true);
    }

    protected JComponent getRecentFilesComponent(int[] values, int value, boolean addPatternField) {
        Vector<TwoFacedObject> relativeList = new Vector<TwoFacedObject>();
        TwoFacedObject selected = null;
        for (int i = 0; i < values.length; ++i) {
            String label = values[i] == Integer.MAX_VALUE ? "All Files" : (values[i] == 0 ? "Use Selected File(s)" : (values[i] == 1 ? "Use Most Recent File" : "Use Most Recent " + values[i] + " Files"));
            TwoFacedObject tfo = new TwoFacedObject((Object)label, new Integer(values[i]));
            if (values[i] == value) {
                selected = tfo;
            }
            relativeList.add(tfo);
        }
        this.recentFilesCbx = new JComboBox(relativeList);
        if (selected != null) {
            this.recentFilesCbx.setSelectedItem(selected);
        }
        if (!addPatternField) {
            return this.recentFilesCbx;
        }
        this.recentFilesCbx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TwoFacedObject tfo = (TwoFacedObject)FileChooser.this.recentFilesCbx.getSelectedItem();
                int v = (Integer)tfo.getId();
                FileChooser.this.setHaveData(v > 0);
                FileChooser.this.checkRecentPatternWidgetsEnable();
            }
        });
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(this.recentFilesCbx);
        this.patternLbl = GuiUtils.lLabel(" File Pattern: ");
        comps.add(this.patternLbl);
        this.patternFld = new JTextField(".*", 10);
        comps.add(this.patternFld);
        this.checkRecentPatternWidgetsEnable();
        return GuiUtils.hbox(comps);
    }

    protected int getFileCount() {
        return (Integer)((TwoFacedObject)this.recentFilesCbx.getSelectedItem()).getId();
    }

    protected void checkRecentPatternWidgetsEnable() {
        int recentCnt = this.getFileCount();
        this.patternFld.setEnabled(recentCnt > 0);
        this.patternLbl.setEnabled(recentCnt > 0);
    }

    protected String getFilePattern() {
        if (this.patternFld != null) {
            return this.patternFld.getText().trim();
        }
        return null;
    }

    @Override
    protected JComponent doMakeContents() {
        JComponent accessory;
        String path = (String)this.idv.getPreference("Data.DefaultDir" + this.getId());
        if (path == null) {
            path = XmlUtil.getAttribute((Node)this.chooserNode, ATTR_PATH, (String)null);
        }
        this.fileChooser = this.doMakeFileChooser(path);
        this.fileChooser.setPreferredSize(new Dimension(300, 300));
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setApproveButtonText("Add Source");
        ArrayList filters = new ArrayList();
        this.dfltDataSourceId = XmlUtil.getAttribute((Node)this.chooserNode, ATTR_DATASOURCEID, (String)null);
        String filterString = XmlUtil.getAttribute((Node)this.chooserNode, ATTR_FILTERS, (String)null);
        filters.addAll(this.getDataManager().getFileFilters());
        if (filterString != null) {
            filters.addAll(PatternFileFilter.createFilters(filterString));
        }
        if (!filters.isEmpty()) {
            for (int i = 0; i < filters.size(); ++i) {
                this.fileChooser.addChoosableFileFilter((FileFilter)filters.get(i));
            }
            this.fileChooser.setFileFilter(this.fileChooser.getAcceptAllFileFilter());
        }
        JComponent chooserPanel = (accessory = this.getAccessory()) == null ? this.fileChooser : GuiUtils.centerRight(this.fileChooser, GuiUtils.top(accessory));
        JPanel filePanel = GuiUtils.centerBottom(chooserPanel, this.getDefaultButtons());
        ArrayList topComps = new ArrayList();
        this.getTopComponents(topComps);
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel topComp = GuiUtils.doLayout(topComps, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        topComp = GuiUtils.left(topComp);
        this.setStatus("Please select a file");
        return GuiUtils.topCenter(topComp, filePanel);
    }

    protected JCheckBox getAllowDirectorySelectionCbx() {
        if (this.allowDirectorySelectionCbx == null) {
            this.allowDirectorySelectionCbx = new JCheckBox("Allow Directory Selection");
            this.allowDirectorySelectionCbx.setToolTipText("<html><p>Select this if you want</p><p>be able to choose a directory.</p></html>");
            this.allowDirectorySelectionCbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (FileChooser.this.allowDirectorySelectionCbx.isSelected()) {
                        FileChooser.this.fileChooser.setFileSelectionMode(2);
                    } else {
                        FileChooser.this.fileChooser.setFileSelectionMode(0);
                    }
                }
            });
        }
        return this.allowDirectorySelectionCbx;
    }

    protected void getTopComponents(List comps) {
        if (XmlUtil.getAttribute((Node)this.chooserNode, ATTR_DSCOMP, true)) {
            JComponent dsComp = this.getDataSourcesComponent();
            dsComp = GuiUtils.left(dsComp);
            comps.add(GuiUtils.rLabel("Data Source Type:"));
            comps.add(GuiUtils.left(dsComp));
        }
        if (XmlUtil.hasAttribute(this.chooserNode, ATTR_POLLON)) {
            this.doPollingCbx = new JCheckBox("Automatically check for changes", XmlUtil.getAttribute((Node)this.chooserNode, ATTR_POLLON, false));
            String pattern = XmlUtil.getAttribute((Node)this.chooserNode, ATTR_FILEPATTERN, (String)null);
            if (pattern != null || XmlUtil.getAttribute((Node)this.chooserNode, ATTR_SHOWPATTERNFIELD, false)) {
                this.patternFld = new JTextField(pattern, 10);
            }
            comps.add(GuiUtils.rLabel(""));
            JComponent widgetComp = this.doPollingCbx;
            if (this.patternFld != null) {
                widgetComp = GuiUtils.hbox((Component)widgetComp, (Component)new JLabel(" File Pattern: "), this.patternFld);
            }
            comps.add(GuiUtils.left(widgetComp));
        }
        if (this.shouldShowRecentComponent()) {
            comps.add(GuiUtils.rLabel("Use Relative Times:"));
            comps.add(GuiUtils.left(this.getRecentFilesComponent()));
        }
    }

    protected JFileChooser doMakeFileChooser(String path) {
        return new MyFileChooser(path);
    }

    @Override
    public void setHaveData(boolean haveData) {
        super.setHaveData(haveData);
        if (haveData) {
            this.setStatus("Press \"Add Source\" to load the selected file", "buttons");
        } else {
            this.setStatus("Please select a file");
        }
    }

    protected boolean shouldShowRecentComponent() {
        return false;
    }

    protected JComponent getAccessory() {
        return GuiUtils.left(GuiUtils.inset((Component)FileManager.makeDirectoryHistoryComponent(this.fileChooser, false), new Insets(13, 0, 0, 0)));
    }

    protected final void selectFiles(File[] files, File directory) {
        try {
            if (this.selectFilesInner(files, directory)) {
                this.idv.getStateManager().writePreference("Data.DefaultDir" + this.getId(), directory.getPath());
            }
        }
        catch (Exception excp) {
            this.logException("File selection", excp);
        }
    }

    protected JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    @Override
    public void doLoadInThread() {
        this.selectFiles(this.fileChooser.getSelectedFiles(), this.fileChooser.getCurrentDirectory());
    }

    @Override
    public void doUpdate() {
        this.fileChooser.rescanCurrentDirectory();
    }

    protected boolean selectFilesInner(File[] files, File directory) throws Exception {
        File file;
        String dataSourceId;
        if (files == null || files.length == 0) {
            FileChooser.userMessage("Please select a file");
            return false;
        }
        FileManager.addToHistory(files[0]);
        ArrayList<String> selectedFiles = new ArrayList<String>();
        String fileNotExistsError = "";
        boolean didXidv = false;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].exists()) {
                fileNotExistsError = fileNotExistsError + "File does not exist: " + files[i] + "\n";
                continue;
            }
            String filename = files[i].toString();
            if (this.idv.getArgsManager().isXidvFile(filename) || this.idv.getArgsManager().isZidvFile(filename) || this.idv.getArgsManager().isJnlpFile(filename)) {
                didXidv = this.idv.handleAction(filename, null);
                continue;
            }
            selectedFiles.add(filename);
        }
        if (didXidv) {
            this.closeChooser();
            return true;
        }
        if (selectedFiles.size() == 0) {
            return false;
        }
        if (fileNotExistsError.length() > 0) {
            FileChooser.userMessage(fileNotExistsError);
            return false;
        }
        ArrayList<String> definingObject = selectedFiles;
        if (selectedFiles.size() == 1) {
            definingObject = selectedFiles.get(0);
        }
        if ((dataSourceId = this.getDataSourceId()) == null) {
            dataSourceId = this.dfltDataSourceId;
        }
        if (dataSourceId == null && selectedFiles.size() == 1 && (file = new File(selectedFiles.get(0).toString())).isDirectory()) {
            if (!GuiUtils.showYesNoDialog(null, "Do you want to load all of the files in the selected directory: " + file, "Directory Load")) {
                return false;
            }
            definingObject = selectedFiles = new ArrayList();
            File[] subFiles = file.listFiles();
            for (int i = 0; i < subFiles.length; ++i) {
                if (subFiles[i].isDirectory()) continue;
                selectedFiles.add(subFiles[i].toString());
            }
        }
        Hashtable<String, PollingInfo> properties = new Hashtable<String, PollingInfo>();
        PollingInfo pollingInfo = new PollingInfo(this.doPollingCbx == null ? false : this.doPollingCbx.isSelected());
        String pattern = this.getFilePattern();
        if (pattern != null && pattern.length() > 0) {
            pollingInfo.setFilePattern(pattern);
        }
        properties.put("prop.pollinfo", pollingInfo);
        return this.makeDataSource(definingObject, dataSourceId, properties);
    }

    protected String[] getFileNames(File[] files) {
        if (files == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        String fileNotExistsError = "";
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].isDirectory()) continue;
            if (!files[i].exists()) {
                fileNotExistsError = fileNotExistsError + "File does not exist: " + files[i] + "\n";
                continue;
            }
            v.add(files[i].toString());
        }
        if (fileNotExistsError.length() > 0) {
            FileChooser.userMessage(fileNotExistsError);
            return null;
        }
        return v.isEmpty() ? null : StringUtil.listToStringArray(v);
    }

    public class MyFileChooser
    extends FileManager.MyFileChooser {
        public MyFileChooser(String path) {
            super(path);
            this.setFileHidingEnabled(FileManager.getFileHidingEnabled());
            this.setControlButtonsAreShown(false);
            this.setMultiSelectionEnabled(true);
        }

        @Override
        public void approveSelection() {
            FileChooser.this.doLoad();
        }

        @Override
        public void cancelSelection() {
            FileChooser.this.closeChooser();
        }

        @Override
        public void setSelectedFiles(File[] selectedFiles) {
            super.setSelectedFiles(selectedFiles);
            FileChooser.this.setHaveData(selectedFiles != null && selectedFiles.length != 0);
        }
    }
}

