/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.w3c.dom.Element;
import thredds.catalog.query.Location;
import thredds.catalog.query.Station;
import ucar.nc2.units.DateUnit;
import ucar.unidata.data.radar.DqcRadarDatasetCollection;
import ucar.unidata.data.radar.RadarQuery;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.TimesChooser;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import visad.CommonUnit;
import visad.DateTime;

public class DqcRadarChooser
extends TimesChooser {
    private JComponent outerContents;
    private DqcRadarDatasetCollection collection;
    private NamedStation selectedStation;
    private String collectionUrl = "http://thredds.ucar.edu/thredds/idd/radarLevel2";

    public DqcRadarChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    public void doUpdate() {
        if (this.collection == null) {
            return;
        }
        Misc.run(this, "stationChanged");
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        if (this.selectedStation == null) {
            this.setHaveData(false);
            this.setStatus("Please select a station", "stationmap");
            return;
        }
        boolean haveTimesSelected = this.getDoAbsoluteTimes() ? this.getSelectedAbsoluteTimes().size() > 0 : true;
        this.setHaveData(haveTimesSelected);
        if (haveTimesSelected) {
            this.setStatus("Press \"Add Source\" to load the selected radar data", "buttons");
        } else {
            this.setStatus("Please select times", "times");
        }
    }

    @Override
    protected void newSelectedStations(List stations) {
        super.newSelectedStations(stations);
        if (stations == null || stations.size() == 0) {
            this.selectedStation = null;
        } else {
            NamedStation newStation = (NamedStation)stations.get(0);
            if (Misc.equals(newStation, this.selectedStation)) {
                return;
            }
            this.selectedStation = newStation;
        }
        Misc.run(this, "stationChanged");
    }

    @Override
    protected JComponent doMakeContents() {
        this.getStationMap().setPreferredSize(new Dimension(230, 200));
        JComponent buttons = this.getDefaultButtons();
        JPanel timesPanel = this.makeTimesPanel(true, true);
        GuiUtils.tmpInsets = new Insets(0, 3, 0, 3);
        JPanel contents = GuiUtils.doLayout(new Component[]{this.getStationMap(), timesPanel}, 1, new double[]{3.0, 1.0}, GuiUtils.WT_Y);
        contents = GuiUtils.inset((Component)contents, 5);
        Misc.run(this, "initializeCollection");
        this.outerContents = GuiUtils.center(GuiUtils.topCenterBottom(this.getStatusComponent(), contents, buttons));
        return this.outerContents;
    }

    public void initializeCollection() {
        ArrayList<NamedStationImpl> stations = new ArrayList<NamedStationImpl>();
        try {
            StringBuffer errlog = new StringBuffer();
            try {
                this.collection = DqcRadarDatasetCollection.factory("Radar Collection", this.collectionUrl, errlog);
            }
            catch (Exception exc) {
                JTextArea lbl = new JTextArea("There was an error connecting to the radar collection:\n" + this.collectionUrl + "\n" + exc + "\n" + errlog);
                this.outerContents.removeAll();
                this.outerContents.add("Center", lbl);
                this.outerContents.layout();
                return;
            }
            List dqcStations = this.collection.getStations();
            for (int i = 0; i < dqcStations.size(); ++i) {
                Station stn = (Station)dqcStations.get(i);
                Location loc = stn.getLocation();
                NamedStationImpl station = new NamedStationImpl(stn.getValue(), stn.getValue(), loc.getLatitude(), loc.getLongitude(), 0.0, CommonUnit.meter);
                stations.add(station);
            }
            this.getStationMap().setStations(stations);
        }
        catch (Exception exc) {
            JTextArea lbl = new JTextArea("There was an error connecting to the radar collection:\n" + this.collectionUrl + "\n" + exc);
            this.outerContents.removeAll();
            this.outerContents.add("Center", lbl);
            this.outerContents.layout();
        }
    }

    public void stationChanged() {
        Vector<DateTime> times = new Vector<DateTime>();
        this.setHaveData(false);
        if (this.selectedStation != null) {
            Date toDate = new Date(System.currentTimeMillis() + DateUtil.daysToMillis(1.0));
            Date fromDate = new Date(System.currentTimeMillis() - DateUtil.daysToMillis(3650.0));
            try {
                this.showWaitCursor();
                this.setAbsoluteTimes(new ArrayList());
                this.setStatus("Reading times for station: " + this.selectedStation, "");
                ArrayList allTimes = this.collection.getRadarStationTimes(this.selectedStation.getID(), fromDate, toDate);
                for (int timeIdx = 0; timeIdx < allTimes.size(); ++timeIdx) {
                    Object timeObj = allTimes.get(timeIdx);
                    Date date = timeObj instanceof Date ? (Date)timeObj : DateUnit.getStandardOrISO(timeObj.toString());
                    times.add(new DateTime(date));
                }
                this.showNormalCursor();
            }
            catch (Exception exc) {
                this.logException("Getting times for station: " + this.selectedStation, exc);
                this.setStatus("", "");
            }
        }
        this.setAbsoluteTimes(times);
        this.updateStatus();
    }

    @Override
    public void doLoadInThread() {
        Hashtable ht = new Hashtable();
        try {
            DateSelection dateSelection = new DateSelection();
            RadarQuery radarQuery = new RadarQuery(this.collectionUrl, this.selectedStation.getID(), dateSelection);
            ArrayList<String> urls = new ArrayList<String>();
            if (this.getDoAbsoluteTimes()) {
                ArrayList<Date> times = new ArrayList<Date>();
                List<DatedThing> selected = this.makeDatedObjects(this.getSelectedAbsoluteTimes());
                for (int i = 0; i < selected.size(); ++i) {
                    DatedThing datedThing = selected.get(i);
                    Date date = datedThing.getDate();
                    times.add(date);
                    URI uri = this.collection.getRadarDatasetURI(this.selectedStation.getID(), date);
                    urls.add(uri.toString());
                }
                if (urls.size() == 0) {
                    LogUtil.userMessage("No times selected");
                    return;
                }
                dateSelection.setTimes(times);
            } else {
                int count = this.getRelativeTimesList().getSelectedIndex() + 1;
                if (count == 0) {
                    LogUtil.userMessage("No relative times selected");
                    return;
                }
                Date toDate = new Date();
                Date fromDate = new Date(System.currentTimeMillis() - DateUtil.daysToMillis(3650.0));
                dateSelection.setStartFixedTime(fromDate);
                dateSelection.setEndFixedTime(toDate);
                dateSelection.setCount(count);
            }
            this.makeDataSource(radarQuery, "FILE.RADAR", ht);
        }
        catch (Exception exc) {
            this.logException("Loading radar data", exc);
        }
    }
}

