/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import ucar.unidata.idv.SavedBundle;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.util.GuiUtils;

public class BundleChooser
extends IdvChooser {
    private JTree tree;

    public BundleChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    protected JComponent doMakeContents() {
        this.tree = new JTree();
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                BundleChooser.this.treeClick(event);
            }
        });
        this.doUpdate();
        Dimension defaultDimension = new Dimension(300, 400);
        JScrollPane scroller = GuiUtils.makeScrollPane(this.tree, (int)defaultDimension.getWidth(), (int)defaultDimension.getHeight());
        scroller.setPreferredSize(defaultDimension);
        JComponent bottomButtons = this.getDefaultButtons();
        return GuiUtils.centerBottom(scroller, bottomButtons);
    }

    @Override
    public void doUpdate() {
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("Bundles");
        DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot);
        Hashtable<String, DefaultMutableTreeNode> catNodes = new Hashtable<String, DefaultMutableTreeNode>();
        List<SavedBundle> bundles = this.getIdv().getPersistenceManager().getBundles(0);
        for (int i = 0; i < bundles.size(); ++i) {
            SavedBundle bundle = bundles.get(i);
            List categories = bundle.getCategories();
            DefaultMutableTreeNode catNode = treeRoot;
            String fullCat = "";
            for (int catIdx = 0; catIdx < categories.size(); ++catIdx) {
                String cat = (String)categories.get(catIdx);
                DefaultMutableTreeNode tmpNode = (DefaultMutableTreeNode)catNodes.get(fullCat = fullCat + "---" + cat);
                if (tmpNode == null) {
                    tmpNode = new DefaultMutableTreeNode(cat);
                    catNode.add(tmpNode);
                    catNodes.put(fullCat, tmpNode);
                }
                catNode = tmpNode;
            }
            DefaultMutableTreeNode bundleNode = new DefaultMutableTreeNode(bundle);
            catNode.add(bundleNode);
        }
        this.tree.setModel(treeModel);
    }

    @Override
    public void doLoadInThread() {
        TreePath[] paths = this.tree.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        this.loadBundle(this.getBundleAtPath(paths[0]));
    }

    public void loadBundle(SavedBundle bundle) {
        if (bundle == null) {
            return;
        }
        this.showWaitCursor();
        if (this.getIdv().handleAction(bundle.getUrl(), null)) {
            this.closeChooser();
        }
        this.showNormalCursor();
    }

    protected SavedBundle getBundleAtPath(TreePath path) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (last == null) {
            return null;
        }
        Object userData = last.getUserObject();
        if (userData == null || !(userData instanceof SavedBundle)) {
            return null;
        }
        return (SavedBundle)userData;
    }

    protected void treeClick(MouseEvent event) {
        this.setHaveData(false);
        SavedBundle bundle = this.getBundleAtPath(this.tree.getPathForLocation(event.getX(), event.getY()));
        if (bundle == null) {
            return;
        }
        this.setHaveData(true);
        if (event.getClickCount() > 1) {
            this.loadBundle(bundle);
        }
    }

    @Override
    public String getLoadCommandName() {
        return "Load bundle";
    }
}

