/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ucar.unidata.collab.SharableImpl;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.DisplayInfo;
import ucar.unidata.idv.IdvPreferenceManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.StateManager;
import ucar.unidata.idv.VMManager;
import ucar.unidata.idv.VectorGraphicsRenderer;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewState;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.publish.PublishManager;
import ucar.unidata.idv.ui.BottomLegend;
import ucar.unidata.idv.ui.IdvComponentGroup;
import ucar.unidata.idv.ui.IdvComponentHolder;
import ucar.unidata.idv.ui.IdvLegend;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.idv.ui.ImageSequenceGrabber;
import ucar.unidata.idv.ui.SideLegend;
import ucar.unidata.java3d.LightInfo;
import ucar.unidata.ui.Command;
import ucar.unidata.ui.CommandManager;
import ucar.unidata.ui.DropPanel;
import ucar.unidata.ui.FontSelector;
import ucar.unidata.ui.ImagePanel;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.Timeline;
import ucar.unidata.util.BooleanProperty;
import ucar.unidata.util.DatedObject;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.Removable;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlObjectStore;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.AnimationSetInfo;
import ucar.visad.display.AnimationWidget;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import ucar.visad.display.TextDisplayable;
import visad.ConstantMap;
import visad.ControlEvent;
import visad.ControlListener;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.DisplayRenderer;
import visad.FieldImpl;
import visad.GraphicsModeControl;
import visad.KeyboardBehavior;
import visad.ProjectionControl;
import visad.Real;
import visad.Set;
import visad.Text;
import visad.VisADException;
import visad.bom.annotations.ImageJ3D;
import visad.bom.annotations.ScreenAnnotatorJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;

public class ViewManager
extends SharableImpl
implements ActionListener,
ItemListener,
ControlListener,
DisplayListener {
    public static final String PREF_3DCLIP = "View.3Dclip";
    public static final String PREF_ANIREADOUT = "View.AniReadout";
    public static final String PREF_BGCOLOR = "View.BackgroundColor";
    public static final String PREF_BORDERCOLOR = "View.BorderHighlightColor";
    public static final String PREF_CONTOUR_LABELALIGN = "idv.contour.alignlabel";
    public static final String PREF_CONTOUR_LABELFONT = "idv.contour.labelfont";
    public static final String PREF_CONTOUR_LABELSIZE = "idv.contour.labelsize";
    public static final String PREF_DIMENSION = "View.Dimension";
    public static final String PREF_DISPLAYLISTCOLOR = "View.DisplayListColor";
    public static final String PREF_DISPLAYLISTFONT = "View.DisplayListFont";
    public static final String PREF_FGCOLOR = "View.ForegroundColor";
    public static final String PREF_LOGO = "idv.viewmanager.logo";
    public static final String PREF_LOGO_POSITION_OFFSET = "idv.viewmanager.logo.position";
    public static final String PREF_LOGO_SCALE = "idv.viewmanager.logo.scale";
    public static final String PREF_LOGO_VISIBILITY = "idv.viewmanager.logo.visible";
    public static final String PREF_PREFIX = "View.";
    public static final String PREF_SHAREVIEWS = "View.ShareViews";
    public static final String PREF_SHOWANIMATIONBOXES = "View.ShowAnimationBoxes";
    public static final String PREF_SHOWBOTTOMLEGEND = "View.ShowBottomLegend";
    public static final String PREF_SHOWCURSOR = "View.ShowCursor";
    public static final String PREF_SHOWDISPLAYLIST = "View.ShowDisplayList";
    public static final String PREF_SHOWSCALES = "View.ShowScales";
    public static final String PREF_SHOWSIDELEGEND = "View.ShowSideLegend";
    public static final String PREF_SHOWTOOLBAR = "View.ShowToolBar";
    public static final String PREF_SHOWTRANSECTSCALES = "View.ShowTransectScales";
    public static final String PREF_TOOLBARSFLOATABLE = "idv.viewmanager.toolbars.floatable";
    public static final String PREF_TOPBAR_VISIBLE = "View.TopBarVisible";
    public static final String PREF_WAITMSG = "View.WaitVisible";
    public static final String PREF_WIREFRAME = "View.Wireframe";
    public static final String PROP_COMPONENT_RESIZED = "View.ComponentResized";
    public static final String TAG_COLORPAIR = "colorpair";
    public static final String TAG_COLORPAIRS = "colorpairs";
    public static final int borderWidth = 3;
    static int cnt = 0;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(ViewManager.class.getName());
    private static final Border lineBorder = BorderFactory.createLineBorder(Color.gray);
    private static final Font defaultFont = FontSelector.DEFAULT_FONT;
    public static Color borderHighlightColor = Color.blue;
    protected static TwoFacedObject[] logoPoses = new TwoFacedObject[]{new TwoFacedObject((Object)"Lower Left", "ll"), new TwoFacedObject((Object)"Upper Left", "ul"), new TwoFacedObject((Object)"Upper Right", "ur"), new TwoFacedObject((Object)"Lower Right", "lr"), new TwoFacedObject((Object)"Center", "mm")};
    static int xxx = 0;
    private static JRadioButton allViewsBtn;
    private static JCheckBox backgroundTransparentBtn;
    private static JRadioButton contentsBtn;
    private static JRadioButton fullWindowBtn;
    private static JRadioButton hiBtn;
    protected static Border highlightBorder;
    private static JRadioButton lowBtn;
    private static JRadioButton mainDisplayBtn;
    private static JRadioButton medBtn;
    protected static Border normalBorder;
    private int animationSpeed = 1000;
    private JLabel[] aspectLbls = new JLabel[]{null, null, null};
    private JSlider[] aspectSliders = new JSlider[]{null, null, null};
    private String[] aspectText = new String[]{"X", "Y", "Z"};
    private Color background = null;
    private int componentResizeCnt = 0;
    private int currentVisibilityIdx = -1;
    int currentWaitKey = 0;
    private Color displayListColor = null;
    private Font displayListFont = null;
    private long fillLegendsTime = 0L;
    private Color foreground = null;
    private int fullScreenHeight = 0;
    private int fullScreenWidth = 0;
    private double initialSplitPaneLocation = 0.75;
    private boolean isShared = true;
    private boolean isDestroyed = false;
    protected boolean clickToFocus = true;
    protected boolean lastActive = false;
    private int lastDividerLoc = -1;
    private long lastFrameDoneTime = 0L;
    protected long lastTimeActivated = 0L;
    private String logoPosition = null;
    private float logoScale = -1.0f;
    private double[] originalAspectSliderValues = new double[]{0.0, 0.0, 0.0};
    private int outstandingWaits = 0;
    private int sideDividerLocation = -1;
    private boolean showToolbars = true;
    boolean mouseDown = false;
    private List<IdvLegend> legends = new ArrayList<IdvLegend>();
    private String legendState = "docked";
    private boolean legendOnLeft = false;
    private boolean initDone = false;
    private boolean ignoreLightChanges = false;
    private boolean haveInitialized = false;
    private boolean hasWindow = false;
    private int splitPaneLocation = -1;
    protected List toolbars = new ArrayList();
    protected List toolbarNames = new ArrayList();
    protected List toolbarIds = new ArrayList();
    private List timelines = new ArrayList();
    protected boolean showControlMenu = true;
    protected boolean showControlLegend = true;
    private boolean runVisibilityAnimation = false;
    private List<Removable> removables = new ArrayList<Removable>();
    private boolean receivedFirstFrameDone = false;
    boolean propertiesDialogShown = false;
    private Hashtable properties = new Hashtable();
    int mycnt = cnt++;
    DecimalFormat fmt = new DecimalFormat("####0.0###");
    private boolean fillLegendsPending = false;
    private List<DisplayInfo> displayInfos = new ArrayList<DisplayInfo>();
    private boolean dirty = false;
    private Hashtable booleanPropertyMap = new Hashtable();
    private List booleanProperties = new ArrayList();
    List aliases = new ArrayList();
    private Object TIMELINES_MUTEX = new Object();
    private Object MUTEX_DISPLAYLIST = new Object();
    private Object MASTER_MUTEX = new Object();
    private Object LEGENDMUTEX = new Object();
    boolean usingImagePanel = false;
    int xmycnt = xxx++;
    private Animation animation;
    private JCheckBoxMenuItem animationCB;
    protected JComponent animationHolder;
    private AnimationInfo animationInfo;
    private DateTime[] timesArray;
    protected JMenu animationMenu;
    private Timeline animationTimeline;
    private AnimationWidget animationWidget;
    private ScreenAnnotatorJ3D annotator;
    private double[] aspectRatio;
    private GuiUtils.ColorSwatch bgPropertiesSwatch;
    private Hashtable booleanPropertiesForPersistence;
    JComponent centerPanel;
    JComponent centerPanelWrapper;
    private CommandManager commandManager;
    JPanel contentsWrapper;
    private Dimension defaultSize;
    protected Rectangle displayBounds;
    private CompositeDisplayable displayListDisplayables;
    private GuiUtils.ColorSwatch dlPropertiesSwatch;
    private Animation externalAnimation;
    private AnimationWidget externalAnimationWidget;
    private GuiUtils.ColorSwatch fgPropertiesSwatch;
    private FontSelector fontSelector;
    JComponent fullContents;
    private JTextField fullScreenHeightFld;
    private JTextField fullScreenWidthFld;
    protected JFrame fullScreenWindow;
    private IntegratedDataViewer idv;
    private ImagePanel imagePanel;
    private double[] initMatrix;
    private String initProperties;
    private String initViewStateName;
    protected JComponent innerContents;
    private ImageSequenceGrabber isg;
    private IdvKeyboardBehavior keyboardBehavior;
    private List<TwoFacedObject> lastCoords;
    private double[] lastMatrix;
    private List<LightInfo> lights;
    private JToggleButton lockLightsBtn;
    private String logoFile;
    private JTextField logoFileField;
    private JTextField logoOffsetTextField;
    private JComboBox logoPositionBox;
    private JLabel logoSizeLabel;
    private JSlider logoSizer;
    private JCheckBox logoVisCbx;
    private JSplitPane mainSplitPane;
    private DisplayMaster master;
    JLabel matrixLabel;
    private JMenuBar menuBar;
    private double[] mousePressedMatrix;
    private String name;
    private JTextField nameFld;
    protected JLabel nameLabel;
    private ProjectionControl projectionControl;
    JDialog propertiesDialog;
    private Hashtable propertiesMap;
    private JComboBox publishCbx;
    private SideLegend sideLegend;
    private JComponent sideLegendComponent;
    private JComponent sideLegendContainer;
    private Hashtable skinProperties;
    JDialog timelineDialog;
    private JComponent timelineHolder;
    private Component topBar;
    JMenu viewMenu;
    private boolean wasSharing;
    protected long lastTimePolled = 0L;
    protected Rectangle windowBounds;

    public ViewManager() {
    }

    public ViewManager(ViewContext viewContext) {
        this.idv = (IntegratedDataViewer)viewContext;
        ViewManager.setHighlightBorder(this.getStore().get(PREF_BORDERCOLOR, Color.blue));
    }

    public ViewManager(ViewContext viewContext, AnimationInfo info) {
        this(viewContext, null, null, info);
    }

    public ViewManager(ViewContext viewContext, ViewDescriptor viewDescriptor, String properties) {
        this(viewContext, viewDescriptor, properties, null);
    }

    public ViewManager(ViewContext viewContext, DisplayMaster master, ViewDescriptor viewDescriptor, String properties) throws VisADException, RemoteException {
        this(viewContext, viewDescriptor, properties, null);
        this.setDisplayMaster(master);
    }

    public ViewManager(ViewContext viewContext, ViewDescriptor viewDescriptor, String properties, AnimationInfo info) {
        this(viewContext);
        this.animationInfo = info;
        this.initProperties = properties;
        if (viewDescriptor == null || viewDescriptor.nameEquals(ViewDescriptor.LASTACTIVE)) {
            viewDescriptor = new ViewDescriptor();
        }
        this.addViewDescriptor(viewDescriptor);
        ViewManager.setHighlightBorder(this.getStore().get(PREF_BORDERCOLOR, Color.blue));
    }

    protected void init() throws VisADException, RemoteException {
        if (this.haveInitialized) {
            return;
        }
        Trace.call1("ViewManager.init");
        this.haveInitialized = true;
        this.initSharable();
        Trace.call1("ViewManager.init getMaster()");
        this.getMaster();
        Trace.call2("ViewManager.init getMaster()");
        this.keyboardBehavior = new IdvKeyboardBehavior(this);
        this.getMaster().addKeyboardBehavior(this.keyboardBehavior);
        this.addRemovable(this.keyboardBehavior);
        Trace.call1("ViewManager.init setBooleanProperties()");
        this.setBooleanProperties(this);
        Trace.call2("ViewManager.init setBooleanProperties()");
        Animation animation = this.getAnimation();
        if (animation != null) {
            this.getMaster().setAnimation(animation, this.animationWidget);
        }
        Trace.call1("ViewManager.init initWith");
        this.initWith(this);
        Trace.call2("ViewManager.init initWith");
        Trace.call2("ViewManager.init");
        this.initDone = true;
    }

    public DateTime[] getAnimationTimes() {
        if (this.animationWidget != null) {
            return this.animationWidget.getTimes();
        }
        return null;
    }

    public List<DateTime> getTimeDriverTimes() throws VisADException, RemoteException {
        AnimationSetInfo asi;
        if (this.getAnimationInfo() != null && (asi = this.getAnimationInfo().getAnimationSetInfo()).getActive() && asi.getIsTimeDriver()) {
            Object[] times = this.getAnimationTimes();
            return Misc.toList(times);
        }
        for (DisplayControl control : this.getControls()) {
            if (!control.getIsTimeDriver()) continue;
            Set timeSet = control.getTimeSet();
            Object[] times = Animation.getDateTimeArray(timeSet);
            return Misc.toList(times);
        }
        return null;
    }

    public void setTimeDriverTimes(Date startTime, Date endTime) throws VisADException, RemoteException {
        AnimationInfo aninfo;
        AnimationSetInfo asi;
        if (this.animationWidget != null && (asi = (aninfo = this.getAnimationInfo()).getAnimationSetInfo()).getActive() && asi.getIsTimeDriver() && (startTime != null || endTime != null)) {
            if (startTime != null) {
                asi.setStartFixedTime(startTime);
                asi.setStartMode(2);
                asi.setStartOffsetMinutes(0.0);
            }
            if (endTime != null) {
                asi.setEndFixedTime(endTime);
                asi.setEndMode(2);
                asi.setEndOffsetMinutes(0.0);
            }
            this.animationWidget.setProperties(aninfo);
            this.animationWidget.resetProperties();
            this.animationWidget.animationSetChanged();
        }
    }

    protected boolean getHaveInitialized() {
        return this.haveInitialized;
    }

    protected boolean getInitDone() {
        return this.initDone;
    }

    public void initFromSkin(Element skinNode) {
        XmlNodeList elements = XmlUtil.getElements(skinNode, "property");
        for (int childIdx = 0; childIdx < elements.getLength(); ++childIdx) {
            String value;
            Element child = (Element)elements.item(childIdx);
            String name = XmlUtil.getAttribute(child, "name");
            if (this.setProperty(name, value = XmlUtil.getAttribute(child, "value"), true)) continue;
            if (this.skinProperties == null) {
                this.skinProperties = new Hashtable();
            }
            this.skinProperties.put(name, value);
        }
    }

    public void doDrop(Object object) {
        DisplayControl control = (DisplayControl)object;
        ViewManager vm = control.getViewManager();
        if (vm == null || vm == this) {
            return;
        }
        control.moveTo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initUI() {
        Object bottomLegend;
        Component topRight;
        try {
            this.init();
            if (this.initProperties != null) {
                String tmp = this.initProperties;
                this.initProperties = null;
                this.parseProperties(tmp);
            }
        }
        catch (Exception exp) {
            this.logException("Initializing UI", exp);
        }
        if (this.fullContents != null) {
            return;
        }
        JComponent baseContents = (JComponent)this.doMakeContents();
        baseContents = this.makeDropPanel(baseContents, false);
        this.innerContents = GuiUtils.center(baseContents);
        this.contentsWrapper = GuiUtils.center(this.innerContents);
        this.menuBar = this.doMakeMenuBar();
        if (this.menuBar != null) {
            this.menuBar.setBorderPainted(false);
            this.menuBar.setMargin(new Insets(0, 0, 0, 0));
            this.menuBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.menuBar.setOpaque(false);
        }
        this.nameLabel = GuiUtils.cLabel(" ");
        this.updateNameLabel();
        if (this.showToolbars) {
            this.initToolBars();
        }
        this.checkToolBarVisibility();
        if (this.animationWidget == null) {
            topRight = GuiUtils.filler();
        } else {
            this.animationHolder = GuiUtils.inset((Component)this.animationWidget.getContents(), new Insets(0, 0, 0, 4));
            topRight = this.animationHolder;
        }
        JPanel leftNav = GuiUtils.topCenter(GuiUtils.doLayout(this.toolbars, 1, GuiUtils.WT_N, GuiUtils.WT_N), null);
        this.topBar = GuiUtils.leftCenterRight(GuiUtils.bottom(this.menuBar), GuiUtils.bottom(this.nameLabel), topRight);
        this.centerPanel = GuiUtils.topCenter(this.topBar, this.contentsWrapper);
        this.topBar.setVisible(this.getTopBarVisible());
        if (this.getShowBottomLegend()) {
            bottomLegend = new BottomLegend(this);
            this.addRemovable((Removable)bottomLegend);
            List<IdvLegend> list = this.legends;
            synchronized (list) {
                this.legends.add((IdvLegend)bottomLegend);
            }
            JComponent contents = ((IdvLegend)bottomLegend).getContents();
            if (this.showControlLegend) {
                this.centerPanel = GuiUtils.vsplit((Component)this.centerPanel, (Component)contents, 1.0);
                ((IdvLegend)bottomLegend).setTheContainer(this.centerPanel);
                ((JSplitPane)this.centerPanel).setDividerSize(2);
            }
        }
        if (this.getShowSideLegend()) {
            if (this.sideLegend == null) {
                this.sideLegend = new SideLegend(this);
                this.addRemovable(this.sideLegend);
            }
            bottomLegend = this.legends;
            synchronized (bottomLegend) {
                this.legends.add(this.sideLegend);
            }
            this.sideLegendComponent = this.getSideComponent(this.sideLegend.getContents());
            this.sideLegendContainer = new JPanel(new BorderLayout());
            this.sideLegendContainer.add("Center", this.sideLegendComponent);
            this.sideLegend.setContentsToUse(this.sideLegendComponent);
            JComponent leftComp = this.legendOnLeft ? this.sideLegendContainer : this.centerPanel;
            JComponent rightComp = this.legendOnLeft ? this.centerPanel : this.sideLegendContainer;
            this.mainSplitPane = new JSplitPane(1, leftComp, rightComp);
            if (this.legendOnLeft) {
                this.mainSplitPane.setResizeWeight(0.2);
            } else {
                this.mainSplitPane.setResizeWeight(0.8);
            }
            this.mainSplitPane.setOneTouchExpandable(true);
            this.centerPanelWrapper = this.showControlLegend ? GuiUtils.center(this.mainSplitPane) : GuiUtils.center(this.centerPanel);
            this.insertSideLegend();
        } else {
            this.centerPanelWrapper = GuiUtils.center(this.centerPanel);
        }
        this.fullContents = GuiUtils.leftCenter(leftNav, this.centerPanelWrapper);
        this.fullContents.setBorder(this.getContentsBorder());
        this.fillLegends();
    }

    public void setSideLegendPosition(String state) {
        this.legendState = state;
        this.insertSideLegend();
    }

    protected void insertSideLegend() {
        if (this.legendState.equals("docked")) {
            this.sideLegend.unFloatLegend();
            this.sideLegendContainer.removeAll();
            this.sideLegendContainer.add("Center", this.sideLegendComponent);
            this.sideLegendContainer.repaint();
            if (this.lastDividerLoc >= 0) {
                this.mainSplitPane.setDividerLocation(this.lastDividerLoc);
            } else {
                this.mainSplitPane.resetToPreferredSizes();
            }
        } else if (this.legendState.equals("float")) {
            this.lastDividerLoc = this.mainSplitPane.getDividerLocation();
            this.sideLegendContainer.removeAll();
            this.sideLegendContainer.repaint();
            this.sideLegend.floatLegend();
            if (this.legendOnLeft) {
                this.mainSplitPane.setDividerLocation(0);
            } else {
                this.mainSplitPane.setDividerLocation(this.mainSplitPane.getBounds().width);
            }
        } else if (this.legendState.equals("hidden")) {
            this.lastDividerLoc = this.mainSplitPane.getDividerLocation();
            this.sideLegendContainer.removeAll();
            this.sideLegendContainer.repaint();
            this.sideLegend.unFloatLegend();
            this.sideLegendContainer.add("Center", this.sideLegendComponent);
            if (this.legendOnLeft) {
                this.mainSplitPane.setDividerLocation(0);
            } else {
                this.mainSplitPane.setDividerLocation(this.mainSplitPane.getBounds().width);
            }
        }
    }

    public DropPanel makeDropPanel(JComponent contents, boolean doBorder) {
        DropPanel dropPanel = new DropPanel(contents, doBorder){

            @Override
            public void handleDrop(Object object) {
                Misc.run(ViewManager.this, "doDrop", object);
            }

            @Override
            public boolean okToDrop(Object object) {
                if (!(object instanceof DisplayControl)) {
                    return false;
                }
                return ViewManager.this.okToImportDisplay((DisplayControl)object);
            }
        };
        return dropPanel;
    }

    public boolean okToImportDisplay(DisplayControl control) {
        ViewManager vm = control.getViewManager();
        return vm != null && vm != this && vm.getClass().equals(this.getClass());
    }

    public void setContentsBorder(Border b) {
        if (this.fullContents != null) {
            this.fullContents.setBorder(b);
        }
    }

    protected Border getContentsBorder() {
        return BorderFactory.createMatteBorder(1, 1, 0, 0, Color.gray);
    }

    public void showPropertiesDialog() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
                    if (!ViewManager.this.applyProperties()) {
                        return;
                    }
                    ViewManager.this.getIdvUIManager().viewManagerChanged(ViewManager.this);
                }
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                    ViewManager.this.propertiesDialog.dispose();
                    ViewManager.this.propertiesDialogShown = false;
                }
            }
        };
        JPanel buttons = GuiUtils.makeApplyOkCancelButtons(listener);
        JPanel comp = GuiUtils.inset((Component)GuiUtils.centerBottom(this.getPropertiesComponent(), buttons), 5);
        boolean newOne = false;
        if (this.propertiesDialog == null) {
            IdvWindow myWindow = this.getDisplayWindow();
            Window window = null;
            if (myWindow != null) {
                window = myWindow.getWindow();
            }
            this.propertiesDialog = GuiUtils.createDialog(window, "Properties", false);
            newOne = true;
        }
        this.propertiesDialog.getContentPane().removeAll();
        this.propertiesDialog.getContentPane().add(comp);
        this.propertiesDialog.pack();
        this.setMatrixLabel(true);
        if (newOne) {
            GuiUtils.showDialogNearSrc(this.viewMenu, this.propertiesDialog);
        } else {
            this.propertiesDialog.setVisible(true);
        }
        this.propertiesDialogShown = true;
    }

    public JComponent getPropertiesComponent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.addPropertiesComponents(tabbedPane);
        return tabbedPane;
    }

    protected JComponent getMainPropertiesComponent() {
        this.nameFld = new JTextField(this.name != null ? this.name : "", 20);
        this.propertiesMap = new Hashtable();
        ArrayList<JPanel> props = new ArrayList<JPanel>();
        for (int i = 0; i < this.booleanProperties.size(); ++i) {
            BooleanProperty bp = (BooleanProperty)this.booleanProperties.get(i);
            JCheckBox cbx = new JCheckBox(bp.getName(), bp.getValue());
            this.propertiesMap.put(cbx, bp);
            props.add(GuiUtils.left(cbx));
        }
        GuiUtils.tmpInsets = new Insets(0, 5, 0, 5);
        JPanel propsComp = GuiUtils.doLayout(props, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        this.bgPropertiesSwatch = new GuiUtils.ColorSwatch(this.getBackground(), "Set Background Color");
        this.fgPropertiesSwatch = new GuiUtils.ColorSwatch(this.getForeground(), "Set Foreground Color");
        ArrayList<JComponent> colorProps = new ArrayList<JComponent>();
        colorProps.add(GuiUtils.rLabel("Foreground:"));
        colorProps.add(this.fgPropertiesSwatch);
        colorProps.add(GuiUtils.rLabel("Background:"));
        colorProps.add(this.bgPropertiesSwatch);
        GuiUtils.tmpInsets = new Insets(2, 2, 2, 2);
        JPanel colorPanel = GuiUtils.doLayout(colorProps, 4, GuiUtils.WT_N, GuiUtils.WT_N);
        colorPanel.setBorder(BorderFactory.createTitledBorder("Colors"));
        this.fontSelector = new FontSelector(0, false, false);
        this.fontSelector.setFont(this.getDisplayListFont());
        this.dlPropertiesSwatch = new GuiUtils.ColorSwatch(this.getDisplayListColor(), "Set Display List Color");
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel fontPanel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("   Font: "), GuiUtils.left(this.fontSelector.getComponent()), GuiUtils.rLabel("  Color: "), GuiUtils.left(GuiUtils.hbox((Component)this.dlPropertiesSwatch, (Component)this.dlPropertiesSwatch.getClearButton(), 5))}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        fontPanel.setBorder(BorderFactory.createTitledBorder("Display List"));
        this.fullScreenWidthFld = new JTextField(this.fullScreenWidth > 0 ? "" + this.fullScreenWidth : "", 5);
        this.fullScreenHeightFld = new JTextField(this.fullScreenHeight > 0 ? "" + this.fullScreenHeight : "", 5);
        this.fullScreenWidthFld.setToolTipText("Leave blank or 0 for full screen");
        this.fullScreenHeightFld.setToolTipText("Leave blank or 0 for full screen");
        JPanel fullScreenPanel = GuiUtils.left(GuiUtils.hbox((Component)new JLabel("Width: "), (Component)this.fullScreenWidthFld, (Component)new JLabel("  Height: "), this.fullScreenHeightFld));
        fullScreenPanel.setBorder(BorderFactory.createTitledBorder("Full Screen Dimensions"));
        this.logoFileField = new JTextField(this.getLogoFile());
        this.logoFileField.setToolTipText("Enter a file or URL");
        JButton browseButton = new JButton("Browse..");
        browseButton.setToolTipText("Choose a logo from disk");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String filename = FileManager.getReadFile(FileManager.FILTER_IMAGE);
                if (filename == null) {
                    return;
                }
                ViewManager.this.logoFileField.setText(filename);
            }
        });
        String[] logos = this.parseLogoPosition(this.getLogoPosition());
        this.logoPositionBox = new JComboBox<TwoFacedObject>(logoPoses);
        this.logoPositionBox.setToolTipText("Set the logo position on the screen");
        this.logoPositionBox.setSelectedItem(this.findLoc(logos[0]));
        this.logoOffsetTextField = new JTextField(logos[1]);
        this.logoOffsetTextField.setToolTipText("Set an offset from the position (x,y)");
        this.logoSizeLabel = new JLabel("" + this.getLogoScale());
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ViewManager.this.logoSizeLabel.setText("" + (float)ViewManager.this.logoSizer.getValue() / 10.0f);
            }
        };
        JComponent[] sliderComps = GuiUtils.makeSliderPopup(0, 20, (int)(this.getLogoScale() * 10.0f), listener);
        this.logoSizer = (JSlider)sliderComps[1];
        sliderComps[0].setToolTipText("Change Logo Scale Value");
        JPanel logoPanel = GuiUtils.vbox((Component)GuiUtils.centerRight(this.logoFileField, browseButton), GuiUtils.hbox((Component)GuiUtils.leftCenter(GuiUtils.rLabel("Screen Position: "), this.logoPositionBox), (Component)GuiUtils.leftCenter(GuiUtils.rLabel("Offset: "), this.logoOffsetTextField), GuiUtils.leftCenter(GuiUtils.rLabel("Scale: "), GuiUtils.leftRight(this.logoSizeLabel, sliderComps[0]))));
        logoPanel.setBorder(BorderFactory.createTitledBorder("Logo"));
        propsComp = GuiUtils.vbox(new Component[]{propsComp, GuiUtils.inset((Component)colorPanel, new Insets(10, 5, 5, 5)), GuiUtils.inset((Component)fontPanel, new Insets(10, 5, 5, 5)), GuiUtils.inset((Component)fullScreenPanel, new Insets(10, 5, 5, 5)), GuiUtils.inset((Component)logoPanel, new Insets(10, 5, 5, 5))});
        return GuiUtils.vbox((Component)GuiUtils.left(GuiUtils.label("Name:  ", this.nameFld)), propsComp);
    }

    protected TwoFacedObject findLoc(String loc) {
        if (loc.equalsIgnoreCase("ll")) {
            return logoPoses[0];
        }
        if (loc.equalsIgnoreCase("ul")) {
            return logoPoses[1];
        }
        if (loc.equalsIgnoreCase("ur")) {
            return logoPoses[2];
        }
        if (loc.equalsIgnoreCase("lr")) {
            return logoPoses[3];
        }
        if (loc.equalsIgnoreCase("mm")) {
            return logoPoses[4];
        }
        return logoPoses[0];
    }

    protected String[] parseLogoPosition(String position) {
        String logoO;
        String logoP;
        if (position == null || position.isEmpty()) {
            logoP = "ll";
            logoO = "0,0";
        } else {
            int firstComma = position.indexOf(44);
            if (firstComma > 0) {
                logoP = position.substring(0, firstComma);
                logoO = position.substring(firstComma + 1);
            } else {
                logoP = position;
                logoO = "0,0";
            }
        }
        return new String[]{logoP, logoO};
    }

    protected String makeLogoPosition(String pos, String offset) {
        if (pos == null || pos.isEmpty()) {
            return "";
        }
        int firstComma = pos.indexOf(",");
        if (firstComma > 0) {
            return pos;
        }
        if (offset == null || offset.isEmpty()) {
            offset = "0,0";
        }
        return pos + "," + offset;
    }

    protected void addPropertiesComponents(JTabbedPane tabbedPane) {
        tabbedPane.add("Main", GuiUtils.inset((Component)GuiUtils.top(this.getMainPropertiesComponent()), 5));
        tabbedPane.add("Aspect Ratio", GuiUtils.inset((Component)GuiUtils.top(this.getAspectPropertiesComponent()), 5));
        if (this.lights != null) {
            try {
                if (this.lockLightsBtn == null) {
                    this.lockLightsBtn = GuiUtils.getToggleButton("/auxdata/ui/icons/link_break.png", 0, 0);
                    this.lockLightsBtn.setContentAreaFilled(false);
                    this.lockLightsBtn.setSelectedIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/link.png", this.getClass()));
                    this.lockLightsBtn.setSelected(false);
                    this.lockLightsBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                    this.lockLightsBtn.setToolTipText("Link stride changes between x & y");
                }
                ArrayList comps = new ArrayList();
                for (LightInfo lightInfo : this.lights) {
                    ObjectListener listener = new ObjectListener(lightInfo){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            LightInfo theLight = (LightInfo)this.theObject;
                            if (ViewManager.this.ignoreLightChanges) {
                                return;
                            }
                            ViewManager.this.ignoreLightChanges = true;
                            theLight.applyProperties();
                            if (ViewManager.this.lockLightsBtn.isSelected()) {
                                for (LightInfo light : ViewManager.this.lights) {
                                    if (light == theLight) continue;
                                    light.setVisible(theLight.getVisible(), true);
                                    light.updateLight();
                                }
                            }
                            ViewManager.this.ignoreLightChanges = false;
                        }

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            JSlider slider = (JSlider)e.getSource();
                            if (ViewManager.this.ignoreLightChanges || slider.getValueIsAdjusting()) {
                                return;
                            }
                            LightInfo theLight = (LightInfo)this.theObject;
                            ViewManager.this.ignoreLightChanges = true;
                            theLight.applyProperties();
                            if (ViewManager.this.lockLightsBtn.isSelected()) {
                                for (LightInfo light : ViewManager.this.lights) {
                                    if (light == theLight) continue;
                                    light.setColor(theLight.getColor(), true);
                                    light.updateLight();
                                }
                            }
                            ViewManager.this.ignoreLightChanges = false;
                        }
                    };
                    lightInfo.getPropertyComponents(comps, listener);
                }
                JComponent lightsComp = GuiUtils.formLayout(comps);
                tabbedPane.add("Lighting", GuiUtils.inset((Component)GuiUtils.top(GuiUtils.vbox(lightsComp, GuiUtils.left(this.lockLightsBtn))), 5));
            }
            catch (Exception exc) {
                this.logException("", exc);
            }
        }
    }

    public void aspectSliderChanged(int value) {
        for (int i = 0; i < 3; ++i) {
            this.aspectLbls[i].setText("" + (double)this.aspectSliders[i].getValue() / 10.0);
        }
    }

    public void resetAspectSliders() {
        if (this.aspectRatio == null) {
            this.aspectRatio = this.master.getDisplayAspect();
        }
        for (int i = 0; i < 3; ++i) {
            this.aspectSliders[i].setValue((int)(this.aspectRatio[i] * 10.0));
            this.aspectLbls[i].setText("" + this.aspectRatio[i]);
        }
    }

    private void initLights(DisplayRendererJ3D renderer) {
        if (this.lights == null) {
            this.lights = new ArrayList<LightInfo>();
            this.createInitialLights();
        }
        BranchGroup lightsNode = new BranchGroup();
        lightsNode.setCapability(17);
        lightsNode.setCapability(12);
        lightsNode.setCapability(13);
        lightsNode.setCapability(14);
        for (LightInfo lightInfo : this.lights) {
            lightsNode.addChild((Node)lightInfo.getLight());
        }
        renderer.getTrans().addChild((Node)lightsNode);
    }

    public void brighter() {
        if (this.lights == null) {
            return;
        }
        for (LightInfo lightInfo : this.lights) {
            lightInfo.brighter();
        }
    }

    private void createInitialLights() {
        Point3d[] locations = new Point3d[]{new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0)};
        Vector3f[] directions = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f)};
        String[] names = new String[]{"Over", "Under", "Top", "Bottom", "Right", "Left"};
        for (int i = 0; i < directions.length; ++i) {
            this.lights.add(new LightInfo(names[i], locations[i], directions[i]));
        }
    }

    protected JComponent getAspectPropertiesComponent() {
        try {
            DisplayMaster master = this.getMaster();
            JButton resetBtn = GuiUtils.makeButton("Reset", this, "resetAspectSliders");
            ArrayList<Component> comps = new ArrayList<Component>();
            comps.add(resetBtn);
            comps.add(GuiUtils.filler());
            for (int i = 0; i < 3; ++i) {
                this.aspectSliders[i] = GuiUtils.makeSlider(0, 100, 0, this, "aspectSliderChanged", true);
                this.aspectLbls[i] = new JLabel(" ");
                comps.add(GuiUtils.rLabel(this.aspectText[i]));
                comps.add(GuiUtils.centerRight(this.aspectSliders[i], this.aspectLbls[i]));
            }
            this.resetAspectSliders();
            this.originalAspectSliderValues = new double[]{(double)this.aspectSliders[0].getValue() / 10.0, (double)this.aspectSliders[1].getValue() / 10.0, (double)this.aspectSliders[2].getValue() / 10.0};
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            JPanel contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            this.matrixLabel = new JLabel("<html></html>");
            this.matrixLabel.setBorder(BorderFactory.createTitledBorder("Display Matrix Settings"));
            this.setMatrixLabel(true);
            contents = GuiUtils.centerBottom(contents, GuiUtils.inset((Component)this.matrixLabel, new Insets(20, 0, 0, 0)));
            return contents;
        }
        catch (Exception exc) {
            this.logException("Creating aspect dialog", exc);
            return null;
        }
    }

    private void setMatrixLabel(boolean force) {
        try {
            double[] currentMatrix;
            if (this.matrixLabel == null) {
                return;
            }
            if (!force && !this.propertiesDialogShown) {
                return;
            }
            if (!force) {
                try {
                    this.matrixLabel.getLocationOnScreen();
                }
                catch (Exception exc) {
                    return;
                }
            }
            boolean changed = !Misc.equals(this.lastMatrix, currentMatrix = this.getDisplayMatrix());
            List<TwoFacedObject> coords = null;
            if (this.getMaster() instanceof NavigatedDisplay && !Misc.equals(coords = ((NavigatedDisplay)this.getMaster()).getScreenCoordinates(), this.lastCoords)) {
                changed = true;
            }
            if (!changed) {
                return;
            }
            this.lastMatrix = currentMatrix;
            double[] trans = new double[]{0.0, 0.0, 0.0};
            double[] rot = new double[]{0.0, 0.0, 0.0};
            double[] scale = new double[]{0.0, 0.0, 0.0};
            this.getMaster().getMouseBehavior().instance_unmake_matrix(rot, scale, trans, currentMatrix);
            StringBuffer sb = new StringBuffer();
            sb.append("<html><table width=100%><tr><td width=33%></td><td width=33%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td width=33%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Y&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Z&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td></tr><tr><td align=right>Rotation:</td><td align=right>" + this.fmt(rot[0]) + "</td><td align=right>" + this.fmt(rot[1]) + "</td><td align=right>" + this.fmt(rot[2]) + "</td></tr>" + "<tr><td align=right>Translation:</td><td align=right>" + this.fmt(trans[0]) + "</td><td align=right>" + this.fmt(trans[1]) + "</td><td align=right>" + this.fmt(trans[2]) + "</td></tr>" + "<tr><td align=right>Scale:</td><td align=right>" + this.fmt(scale[0]) + "</td><td>" + this.fmt(scale[1]) + "</td><td>" + this.fmt(scale[2]) + "</td></tr>");
            if (this.getMaster() instanceof NavigatedDisplay) {
                NavigatedDisplay navDisplay = (NavigatedDisplay)this.getMaster();
                sb.append("<tr><td></td><td colspan=3 align=center>Box</td><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td colspan=2 align=center>Screen</td></tr>");
                for (TwoFacedObject tfo : coords) {
                    double[] xyz = (double[])tfo.getId();
                    int[] scoords = navDisplay.getScreenCoordinates(xyz);
                    sb.append("<tr align=right><td align=right>");
                    sb.append(tfo.toString() + ":");
                    sb.append("</td><td>");
                    sb.append(this.fmt(xyz[0]));
                    sb.append("</td><td>");
                    sb.append(this.fmt(xyz[1]));
                    sb.append("</td><td>");
                    sb.append(this.fmt(xyz[2]));
                    sb.append("</td><td>");
                    sb.append("</td><td>");
                    sb.append(scoords[0]);
                    sb.append("</td><td>");
                    sb.append(scoords[1]);
                    sb.append("</td></tr>");
                }
            }
            sb.append("</table>");
            this.matrixLabel.setText(sb.toString());
        }
        catch (Exception exc) {
            LogUtil.consoleMessage("Error:" + exc);
        }
    }

    private String fmt(double d) {
        if (d == -0.0) {
            d = 0.0;
        }
        return this.fmt.format(d);
    }

    public boolean applyProperties() {
        if (this.lights != null) {
            for (LightInfo lightInfo : this.lights) {
                lightInfo.applyProperties();
            }
        }
        int width = 0;
        int height = 0;
        width = this.fullScreenWidthFld.getText().trim().equals("") || this.fullScreenWidthFld.getText().trim().equals("0") ? 0 : new Integer(this.fullScreenWidthFld.getText().trim());
        height = this.fullScreenHeightFld.getText().trim().equals("") || this.fullScreenHeightFld.getText().trim().equals("0") ? 0 : new Integer(this.fullScreenHeightFld.getText().trim());
        if (width != this.fullScreenWidth || height != this.fullScreenHeight) {
            this.fullScreenWidth = width;
            this.fullScreenHeight = height;
            if (this.fullScreenWindow != null && width != 0 && height != 0) {
                Dimension theSize = new Dimension(width, height);
                JComponent navComponent = this.getComponent();
                navComponent.setMinimumSize(theSize);
                navComponent.setPreferredSize(theSize);
                GuiUtils.getWindow(navComponent).pack();
            }
        }
        try {
            this.setName(this.nameFld.getText());
            Enumeration keys = this.propertiesMap.keys();
            while (keys.hasMoreElements()) {
                JCheckBox cbx = (JCheckBox)keys.nextElement();
                BooleanProperty bp = (BooleanProperty)this.propertiesMap.get(cbx);
                bp.setValue(cbx.isSelected());
            }
            this.setColors(this.fgPropertiesSwatch.getSwatchColor(), this.bgPropertiesSwatch.getSwatchColor());
            Font f = this.fontSelector.getFont();
            this.setDisplayListFont(f);
            this.setDisplayListColor(this.dlPropertiesSwatch.getSwatchColor());
            this.updateDisplayList();
            double[] newAspectRatio = new double[]{(double)this.aspectSliders[0].getValue() / 10.0, (double)this.aspectSliders[1].getValue() / 10.0, (double)this.aspectSliders[2].getValue() / 10.0};
            if (!Arrays.equals(newAspectRatio, this.originalAspectSliderValues)) {
                this.aspectRatio = newAspectRatio;
                this.getMaster().setDisplayAspect(this.aspectRatio);
            }
            this.logoFile = this.logoFileField.getText().trim();
            String logoPos = ((TwoFacedObject)this.logoPositionBox.getSelectedItem()).getId().toString();
            String logoOff = this.logoOffsetTextField.getText().trim();
            this.setLogoPosition(this.makeLogoPosition(logoPos, logoOff));
            this.setLogoScale((float)this.logoSizer.getValue() / 10.0f);
            this.updateAnnotations();
            return true;
        }
        catch (Exception exp) {
            this.logException("Applying properties", exp);
            return false;
        }
    }

    protected void updateAnnotations() {
        try {
            DisplayImpl display = (DisplayImpl)this.getMaster().getDisplay();
            if (display instanceof DisplayImplJ3D) {
                if (this.annotator == null) {
                    this.annotator = new ScreenAnnotatorJ3D(display);
                }
                this.annotator.clear();
                Component comp = display.getComponent();
                if (comp == null) {
                    return;
                }
                Rectangle bounds = comp.getBounds();
                if (bounds.width == 0 || bounds.height == 0 || this.logoFile == null || this.logoFile.isEmpty() || !this.getLogoVisibility()) {
                    this.annotator.draw();
                    return;
                }
                Image logo = ImageUtils.readImage(this.logoFile, true, true);
                if (logo == null) {
                    System.err.println("Logo file: " + this.logoFile + " does not exist.");
                    return;
                }
                Point ap = ImageUtils.parsePoint(this.getLogoPosition(), bounds);
                int baseX = ap.x;
                int baseY = ap.y;
                float zval = this.getPerspectiveView() ? 1.0f : (display.getDisplayRenderer().getMode2D() ? 1.5f : 2.0f);
                ImageJ3D logoJ3D = new ImageJ3D(logo, this.getImageAnchor(this.getLogoPosition()), baseX, baseY, (double)zval, (double)this.getLogoScale());
                this.annotator.add(logoJ3D);
                this.annotator.draw();
            }
        }
        catch (Exception exp) {
            this.logException("updating annotations", exp);
        }
    }

    private int getImageAnchor(String loc) {
        int index = loc.indexOf(",");
        if (index > 0) {
            loc = loc.substring(0, index);
        }
        if (loc.equalsIgnoreCase("ll")) {
            return 23;
        }
        if (loc.equalsIgnoreCase("ul")) {
            return 20;
        }
        if (loc.equalsIgnoreCase("ur")) {
            return 21;
        }
        if (loc.equalsIgnoreCase("lr")) {
            return 22;
        }
        if (loc.equalsIgnoreCase("mm")) {
            return 24;
        }
        return 23;
    }

    public void initAfterUnPersistence(IntegratedDataViewer idv) throws VisADException, RemoteException {
        this.setIdv(idv);
        ViewManager.setHighlightBorder(this.getStore().get(PREF_BORDERCOLOR, Color.blue));
        this.initBooleanProperties();
    }

    public void initWith(ViewState viewState) throws Exception {
        double[] matrix = (double[])viewState.get(ViewState.PROP_MATRIX);
        if (matrix != null) {
            this.setDisplayMatrix(matrix);
        }
    }

    public final void initWith(ViewManager that) {
        this.initWith(that, false);
    }

    public final void initWith(ViewManager that, boolean ignoreWindow) {
        try {
            this.wasSharing = this.getSharing();
            this.setSharing(false);
            this.initWithInner(that, ignoreWindow);
            this.setSharing(this.wasSharing);
        }
        catch (Exception exp) {
            this.logException("initializing ViewManager", exp);
        }
    }

    protected void initWithInner(ViewManager that, boolean ignoreWindow) throws VisADException, RemoteException {
        Rectangle bounds;
        if (that != this) {
            this.aspectRatio = that.aspectRatio;
            List newAliases = that.aliases;
            for (int aliasIdx = 0; aliasIdx < newAliases.size(); ++aliasIdx) {
                ViewDescriptor vd = (ViewDescriptor)newAliases.get(aliasIdx);
                this.addViewDescriptor(vd);
            }
            this.properties.putAll(that.properties);
            if (that.lights != null) {
                this.lights = new ArrayList<LightInfo>();
                for (LightInfo lightInfo : that.lights) {
                    this.lights.add(new LightInfo(lightInfo));
                }
            }
        }
        if (that.name != null && that.name.trim().length() > 0) {
            this.setName(that.name);
        }
        if (!ignoreWindow && (bounds = that.windowBounds) != null) {
            this.setWindowBounds(bounds);
        }
        if (that.animationInfo != null && this.animationWidget != null) {
            this.animationInfo = that.animationInfo;
            this.animationWidget.setProperties(that.animationInfo);
        }
        if (this.initViewStateName == null && that.initMatrix != null) {
            this.setDisplayMatrix(that.initMatrix);
        }
        if (this != that) {
            this.wasSharing = that.getSharing();
            this.setSharing(this.wasSharing);
        }
        this.setBooleanProperties(that);
        this.setColors(that.getForeground(), that.getBackground());
        this.setDisplayListFont(that.getDisplayListFont());
        this.setLogoFile(that.getLogoFile());
        this.setLogoScale(that.getLogoScale());
        this.setLogoVisibility(that.getLogoVisibility());
        this.setLogoPosition(that.getLogoPosition());
        this.updateAnnotations();
        if (this.sideLegend != null && that.sideLegend != null) {
            this.sideLegend.initWith(that.sideLegend);
        }
        if (that.sideDividerLocation > 0) {
            this.sideDividerLocation = that.sideDividerLocation;
            if (this.mainSplitPane != null) {
                // empty if block
            }
        }
    }

    public void guiInitializationDone() {
        this.sideDividerLocation = -1;
        this.toFront();
    }

    public void setIdv(IntegratedDataViewer idv) {
        this.idv = idv;
    }

    public IntegratedDataViewer getIdv() {
        return this.idv;
    }

    protected void setBooleanProperties(ViewManager vm) throws VisADException, RemoteException {
        if (this.booleanPropertyMap.size() == 0) {
            this.initBooleanProperties();
        }
        for (int i = 0; i < this.booleanProperties.size(); ++i) {
            BooleanProperty myProperty = (BooleanProperty)this.booleanProperties.get(i);
            BooleanProperty hisProperty = vm.getBooleanProperty(myProperty.getId());
            if (hisProperty == null) continue;
            myProperty.setValue(hisProperty.getValue());
        }
    }

    protected void handleBooleanPropertyChange(String id, boolean value) throws Exception {
        if (id.equals(PREF_SHAREVIEWS)) {
            this.setSharing(value);
        } else if (id.equals(PREF_WIREFRAME)) {
            DisplayRenderer renderer = this.getDisplayRenderer();
            if (renderer != null) {
                renderer.setBoxOn(value);
            }
        } else if (id.equals(PREF_ANIREADOUT)) {
            if (this.master != null) {
                this.master.setAnimationStringVisible(value);
            }
        } else if (id.equals(PREF_TOPBAR_VISIBLE)) {
            if (this.topBar != null) {
                this.topBar.setVisible(value);
            }
        } else if (id.equals(PREF_WAITMSG)) {
            DisplayMaster master = this.getMaster();
            if (master != null) {
                master.setWaitMessageVisible(value);
            }
        } else if (id.equals(PREF_SHOWDISPLAYLIST)) {
            this.updateDisplayList();
        } else if (id.equals(PREF_LOGO_VISIBILITY)) {
            this.updateAnnotations();
        }
    }

    public void showTimeline() {
        if (this.timelineDialog == null) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String cmd = ae.getActionCommand();
                    if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                        ViewManager.this.timelineDialog.dispose();
                    }
                    if (cmd.equals(GuiUtils.CMD_UPDATE)) {
                        ViewManager.this.updateTimelines(true);
                    }
                }
            };
            this.timelineDialog = GuiUtils.createDialog("Animation Timeline", false);
            this.timelineDialog.getContentPane().add(GuiUtils.centerBottom(this.getTimelineComponent(), GuiUtils.makeButtons(listener, new String[]{GuiUtils.CMD_UPDATE, GuiUtils.CMD_CANCEL})));
            this.updateTimelines(true);
            this.timelineDialog.pack();
            this.timelineDialog.setLocation(200, 200);
        }
        this.timelineDialog.setVisible(true);
        GuiUtils.toFront(this.timelineDialog);
    }

    private void setAnimationTime(Date date) {
        if (this.animation != null) {
            try {
                this.animation.setAniValue(new DateTime(date));
            }
            catch (Exception exp) {
                this.logException("Setting animation time", exp);
            }
        }
    }

    protected void animationTimeChanged() {
    }

    private void updateTimelines(boolean force) {
        if (this.timelineDialog != null) {
            if (force) {
                JComponent jComponent = this.getTimelineComponent();
            }
            this.timelineDialog.invalidate();
            this.timelineDialog.validate();
            this.timelineDialog.repaint();
            Real value = this.animation.getCurrentAnimationValue();
            try {
                for (int i = 0; i < this.timelines.size(); ++i) {
                    MyTimeline timeline = (MyTimeline)this.timelines.get(i);
                    timeline.update(value);
                }
            }
            catch (Exception exp) {
                this.logException("Updating timeline", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getTimelineComponent() {
        try {
            Object object = this.TIMELINES_MUTEX;
            synchronized (object) {
                Insets lblInsets = new Insets(5, 0, 0, 0);
                List controls = this.getControls();
                List allTimes = new ArrayList();
                ArrayList<JComponent> comps = new ArrayList<JComponent>();
                ArrayList oldTimelines = new ArrayList(this.timelines);
                this.timelines = new ArrayList();
                if (this.animationWidget != null) {
                    List datedThings = DatedObject.wrap(Util.makeDates(this.animationWidget.getTimes()));
                    if (this.animationTimeline == null) {
                        this.animationTimeline = new MyTimeline(datedThings, 300, 100);
                    }
                    if (datedThings.size() > 0) {
                        allTimes.addAll(datedThings);
                        this.timelines.add(this.animationTimeline);
                        comps.add(GuiUtils.inset((Component)GuiUtils.lLabel("Animation Times"), lblInsets));
                        comps.add(this.animationTimeline.getContents(false));
                    }
                }
                for (int i = controls.size() - 1; i >= 0; --i) {
                    DateTime[] times;
                    List datedObjects;
                    DisplayControl control = (DisplayControl)controls.get(i);
                    Set timeSet = control.getTimeSet();
                    if (timeSet == null || (datedObjects = DatedObject.wrap(Util.makeDates(times = Animation.getDateTimeArray(timeSet)))).size() == 0) continue;
                    allTimes.addAll(datedObjects);
                    Timeline timeline = null;
                    for (int j = 0; j < oldTimelines.size(); ++j) {
                        MyTimeline oldTimeline = (MyTimeline)oldTimelines.get(j);
                        if (oldTimeline.control != control) continue;
                        timeline = oldTimeline;
                        oldTimelines.remove(oldTimeline);
                        break;
                    }
                    if (timeline == null) {
                        timeline = new MyTimeline(timeSet, datedObjects, 300, control);
                    }
                    if (this.timelines.size() > 0) {
                        timeline.setShortDisplay(true);
                    }
                    this.timelines.add(timeline);
                    comps.add(GuiUtils.inset((Component)GuiUtils.leftRight(((MyTimeline)timeline).label, ((MyTimeline)timeline).rightComp), lblInsets));
                    comps.add(timeline.getContents(false));
                }
                if ((allTimes = DatedObject.sort(allTimes, true)).size() > 1) {
                    Date startDate = ((DatedThing)allTimes.get(0)).getDate();
                    Date endDate = ((DatedThing)allTimes.get(allTimes.size() - 1)).getDate();
                    for (int i = 0; i < this.timelines.size(); ++i) {
                        MyTimeline timeline = (MyTimeline)this.timelines.get(i);
                        timeline.setStartDate(startDate);
                        timeline.setEndDate(endDate);
                        timeline.expandByPercent(1.1, false);
                    }
                }
                for (int i = 0; i < this.timelines.size(); ++i) {
                    MyTimeline timeline = (MyTimeline)this.timelines.get(i);
                    timeline.setGroup(this.timelines);
                }
                GuiUtils.tmpInsets = new Insets(1, 1, 1, 1);
                JPanel comp = GuiUtils.doLayout(comps, 1, GuiUtils.WT_Y, GuiUtils.WT_N);
                JScrollPane sp = new JScrollPane(GuiUtils.top(GuiUtils.inset((Component)comp, 5)), 20, 30);
                sp.setPreferredSize(new Dimension(300, 400));
                if (this.timelineHolder == null) {
                    this.timelineHolder = new JPanel(new BorderLayout());
                }
                this.timelineHolder.removeAll();
                this.timelineHolder.add("Center", sp);
                this.timelineHolder.invalidate();
                this.timelineHolder.repaint();
                return this.timelineHolder;
            }
        }
        catch (Exception exp) {
            this.logException("Creating timeline", exp);
            return new JPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisplayList() {
        try {
            Object object = this.MUTEX_DISPLAYLIST;
            synchronized (object) {
                String cat;
                TextDisplayable d;
                if (!this.hasDisplayMaster()) {
                    return;
                }
                if (this.displayListDisplayables == null) {
                    this.displayListDisplayables = new CompositeDisplayable();
                    this.displayListDisplayables.setUseTimesInAnimation(false);
                } else {
                    this.getMaster().removeDisplayable(this.displayListDisplayables);
                    this.displayListDisplayables.clearDisplayables();
                }
                if (!this.getShowDisplayList()) {
                    return;
                }
                List controls = this.getControls();
                Hashtable catMap = new Hashtable();
                ArrayList<String> cats = new ArrayList<String>();
                ArrayList<TextDisplayable> textDisplayables = new ArrayList<TextDisplayable>();
                if (this.sideLegend != null) {
                    for (String cat2 : this.sideLegend.getDisplayCategories()) {
                        cats.add(cat2);
                        catMap.put(cat2, new ArrayList());
                    }
                }
                for (int i = controls.size() - 1; i >= 0; --i) {
                    ArrayList<TextDisplayable> l;
                    DisplayControl control = (DisplayControl)controls.get(i);
                    if (!control.getShowInDisplayList() || !control.getDisplayVisibility() || (d = (TextDisplayable)control.getDisplayListDisplayable(this)) == null) continue;
                    cat = control.getDisplayCategory();
                    if (cat == null) {
                        cat = "Displays";
                    }
                    if ((l = (ArrayList<TextDisplayable>)catMap.get(cat)) == null) {
                        l = new ArrayList<TextDisplayable>();
                        catMap.put(cat, l);
                        cats.add(cat);
                    }
                    l.add(d);
                    textDisplayables.add(d);
                }
                boolean grouped = this.getStateManager().getPreferenceOrProperty("idv.displaylist.group", false);
                if (grouped) {
                    int count = 0;
                    for (int i = cats.size() - 1; i >= 0; --i) {
                        cat = (String)cats.get(i);
                        List displayables = (List)catMap.get(cat);
                        for (int j = displayables.size() - 1; j >= 0; --j) {
                            TextDisplayable d2 = (TextDisplayable)displayables.get(j);
                            if (!this.setDisplayablePosition(d2, ++count)) continue;
                            this.displayListDisplayables.addDisplayable(d2);
                        }
                    }
                } else {
                    for (int count = 0; count < textDisplayables.size(); ++count) {
                        d = (TextDisplayable)textDisplayables.get(count);
                        if (!this.setDisplayablePosition(d, count + 1)) continue;
                        this.displayListDisplayables.addDisplayable(d);
                    }
                }
                this.getMaster().addDisplayable(this.displayListDisplayables);
            }
        }
        catch (Exception exp) {
            this.logException("Setting display list", exp);
        }
    }

    private boolean setDisplayablePosition(Displayable d, int number) {
        try {
            DisplayMaster master = this.getMaster();
            DisplayImpl display = (DisplayImpl)master.getDisplay();
            Rectangle r = master.getScreenBounds();
            double[] xyz = new double[3];
            if (!r.isEmpty()) {
                float scale = (float)this.getDisplayListFont().getSize() / 12.0f;
                int x = r.x + (int)(0.5f * (float)r.width);
                int y = r.y + (int)((1.0 - 0.025 * (double)scale * (double)number) * (double)r.height);
                xyz = Util.getVWorldCoords(display, x, y, xyz);
                double zval = this.getPerspectiveView() ? xyz[2] : 2.0;
                d.addConstantMaps(new ConstantMap[]{new ConstantMap(xyz[0], Display.XAxis), new ConstantMap(xyz[1], Display.YAxis), new ConstantMap(zval, Display.ZAxis)});
                return true;
            }
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public boolean getPerspectiveView() {
        return false;
    }

    protected void getInitialBooleanProperties(List props) {
        props.add(new BooleanProperty(PREF_WIREFRAME, "Show Wireframe Box", "", true));
        props.add(new BooleanProperty(PREF_SHAREVIEWS, "Share Views", "", this.getSharing()));
        props.add(new BooleanProperty(PREF_ANIREADOUT, "Show Times In View", "Toggle animation readout in display", false));
        props.add(new BooleanProperty(PREF_WAITMSG, "Show \"Please Wait\" Message", "Toggle \"Please Wait\" message in display", true));
        props.add(new BooleanProperty(PREF_SHOWDISPLAYLIST, "Show Display List", "Show display labels in the display", true));
        props.add(new BooleanProperty(PREF_LOGO_VISIBILITY, "Show Logo", "Toggle logo in display", false));
        props.add(new BooleanProperty(PREF_TOPBAR_VISIBLE, "Show Top Bar", "Toggle top bar", true));
    }

    private void debug(String msg) {
    }

    protected void initBooleanProperties() {
        if (this.booleanPropertiesForPersistence == null) {
            // empty if block
        }
        ArrayList props = new ArrayList();
        this.getInitialBooleanProperties(props);
        if (this.booleanPropertiesForPersistence != null) {
            this.booleanPropertiesForPersistence = StateManager.processPropertyTable(this.booleanPropertiesForPersistence);
        }
        for (int i = 0; i < props.size(); ++i) {
            BooleanProperty bp = (BooleanProperty)props.get(i);
            this.initializeBooleanProperty(bp);
        }
    }

    protected void initializeBooleanProperty(BooleanProperty bp) {
        BooleanProperty existingBp;
        Boolean b;
        StateManager stateManager = this.getStateManager();
        XmlObjectStore store = this.getStore();
        boolean defaultValue = bp.getDefault();
        if (stateManager != null) {
            defaultValue = this.getStateManager().getProperty(bp.getId(), defaultValue);
        }
        if (store != null) {
            defaultValue = store.get(bp.getId(), defaultValue);
        }
        if (this.booleanPropertiesForPersistence != null && (b = (Boolean)this.booleanPropertiesForPersistence.get(bp.getId())) != null) {
            bp.setValue(b);
        }
        if ((existingBp = (BooleanProperty)this.booleanPropertyMap.get(bp.getId())) != null && this.booleanPropertiesForPersistence == null) {
            bp.setValue(existingBp.getValue());
        }
        BooleanProperty newBp = new BooleanProperty(bp){

            @Override
            public void setValueInner(boolean value) throws Exception {
                super.setValueInner(value);
                if (ViewManager.this.getHaveInitialized()) {
                    ViewManager.this.handleBooleanPropertyChange(this.getId(), value);
                }
            }
        };
        newBp.setDefault(defaultValue);
        this.addBooleanProperty(newBp);
    }

    protected boolean hasBooleanProperty(String propertyId) {
        return this.booleanPropertyMap.get(propertyId) != null;
    }

    protected BooleanProperty getBooleanProperty(String propertyId) {
        return this.getBooleanProperty(propertyId, true);
    }

    protected BooleanProperty getBooleanProperty(String propertyId, boolean dflt) {
        BooleanProperty bp;
        if (this.booleanPropertyMap.size() == 0) {
            this.initBooleanProperties();
        }
        if ((bp = (BooleanProperty)this.booleanPropertyMap.get(propertyId)) == null) {
            bp = new BooleanProperty(propertyId, propertyId, propertyId, dflt);
            this.booleanPropertyMap.put(bp.getId(), bp);
            this.initializeBooleanProperty(bp);
        }
        return bp;
    }

    protected void setBp(String propertyId, boolean value) {
        this.getBooleanProperty(propertyId).setValue(value);
    }

    protected boolean getBp(String propertyId) {
        return this.getBp(propertyId, true);
    }

    protected boolean getBp(String propertyId, boolean dflt) {
        return this.getBooleanProperty(propertyId, dflt).getValue();
    }

    public void setShareViews(boolean value) {
        this.setBp(PREF_SHAREVIEWS, value);
    }

    public boolean getShareViews() {
        return this.getBp(PREF_SHAREVIEWS);
    }

    public void setShowDisplayList(boolean value) {
        this.setBp(PREF_SHOWDISPLAYLIST, value);
    }

    public boolean getShowDisplayList() {
        return this.getBp(PREF_SHOWDISPLAYLIST);
    }

    public void setWaitMessageVisible(boolean value) {
        this.setBp(PREF_WAITMSG, value);
    }

    public boolean getWaitMessageVisible() {
        return this.getBp(PREF_WAITMSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBooleanProperty(BooleanProperty bp) {
        Hashtable hashtable = this.booleanPropertyMap;
        synchronized (hashtable) {
            if (this.booleanPropertyMap.get(bp.getId()) != null) {
                for (int i = 0; i < this.booleanProperties.size(); ++i) {
                    BooleanProperty other = (BooleanProperty)this.booleanProperties.get(i);
                    if (!other.getId().equals(bp.getId())) continue;
                    this.booleanProperties.remove(other);
                    break;
                }
            }
            this.booleanPropertyMap.put(bp.getId(), bp);
            this.booleanProperties.add(bp);
        }
    }

    public void setBooleanPropertiesForPersistence(Hashtable value) {
        this.booleanPropertiesForPersistence = value;
    }

    public Hashtable getBooleanPropertiesForPersistence() {
        Hashtable<String, Boolean> tmp = new Hashtable<String, Boolean>();
        for (BooleanProperty bp : this.booleanPropertyMap.values()) {
            if (!bp.hasValue()) continue;
            tmp.put(bp.getId(), new Boolean(bp.getValue()));
        }
        return tmp;
    }

    protected JCheckBoxMenuItem createCBMI(JMenu menu, String id) {
        JCheckBoxMenuItem mi = this.getBooleanProperty(id).createCBMI();
        String s = mi.getText();
        if (s.startsWith("Show ")) {
            s = s.substring(5);
            mi.setText(s);
        }
        if (menu != null) {
            menu.add(mi);
        }
        return mi;
    }

    public void setWireframe(boolean value) {
        this.setBp(PREF_WIREFRAME, value);
    }

    public boolean getWireframe() {
        return this.getBp(PREF_WIREFRAME);
    }

    public void setShowScales(boolean value) {
        this.setBp(PREF_SHOWSCALES, value);
    }

    public boolean getShowScales() {
        return this.getBp(PREF_SHOWSCALES);
    }

    public JSplitPane getSideLegendContainer() {
        return this.mainSplitPane;
    }

    protected JComponent getSideComponent(JComponent sideLegend) {
        return sideLegend;
    }

    public void setInitialSplitPaneLocation(double value) {
        this.initialSplitPaneLocation = value;
    }

    public void setLegendState(IdvLegend legend, String state) {
        this.legendState = state;
        this.insertSideLegend();
    }

    public void applyPreferences() {
        for (BooleanProperty bp : this.booleanPropertyMap.values()) {
            bp.setValue(this.getStore().get(bp.getId(), bp.getValue()));
        }
        this.checkToolBarVisibility();
        this.setColors(this.getStore().get(PREF_FGCOLOR, Color.white), this.getStore().get(PREF_BGCOLOR, Color.black));
        this.setDisplayListFont(this.getStore().get(PREF_DISPLAYLISTFONT, defaultFont));
        this.setDisplayListColor(this.getStore().get(PREF_DISPLAYLISTCOLOR, (Color)null));
        if (this.animationOk()) {
            this.animationInfo.setBoxesVisible(this.getShowAnimationBoxes());
            this.animationWidget.setProperties(this.animationInfo);
        }
        this.setLogoFile(this.getStore().get(PREF_LOGO, ""));
        this.setLogoVisibility(this.getStore().get(PREF_LOGO_VISIBILITY, false));
        this.setLogoScale(this.getStore().get(PREF_LOGO_SCALE, 1.0f));
        this.setLogoPosition(this.getStore().get(PREF_LOGO_POSITION_OFFSET, "ll,10,-10"));
        this.updateDisplayList();
        this.updateAnnotations();
    }

    public void checkToolBarVisibility() {
        for (int i = 0; i < this.toolbars.size(); ++i) {
            ((Component)this.toolbars.get(i)).setVisible(this.getStore().get(PREF_SHOWTOOLBAR + this.toolbarIds.get(i), true));
        }
    }

    public void setHasWindow(boolean value) {
        this.hasWindow = value;
    }

    public boolean getHasWindow() {
        return this.getDisplayWindow() != null;
    }

    public boolean getReallyHasWindow() {
        return this.hasWindow;
    }

    public void setWindowBounds(Rectangle r) {
        this.windowBounds = r;
        IdvWindow myWindow = this.getDisplayWindow();
        if (myWindow != null && r != null) {
            boolean wasVisible = myWindow.isVisible();
            myWindow.setBounds(r);
        }
    }

    public void setWindow(final IdvWindow w) {
        if (w == null) {
            return;
        }
        if (this.windowBounds != null) {
            w.setWindowBounds(this.windowBounds);
            this.windowBounds = null;
        }
        final WindowAdapter[] wa = new WindowAdapter[]{null};
        wa[0] = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ViewManager.this.destroy();
                w.removeWindowListener(wa[0]);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ViewManager.this.doClose();
            }
        };
        w.addWindowListener(wa[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IdvLegend> getLegends() {
        if (this.legends == null) {
            return new ArrayList<IdvLegend>();
        }
        List<IdvLegend> list = this.legends;
        synchronized (list) {
            return new ArrayList<IdvLegend>(this.legends);
        }
    }

    protected void doClose() {
        if (this.legends == null) {
            return;
        }
        for (IdvLegend legend : this.getLegends()) {
            legend.doClose();
        }
    }

    public void showLegend() {
        for (IdvLegend legend : this.getLegends()) {
            legend.showLegend();
        }
    }

    public IdvWindow getDisplayWindow() {
        if (this.fullContents == null) {
            return null;
        }
        return IdvWindow.findWindow(this.fullContents);
    }

    public void setSize(Dimension d) {
        this.defaultSize = d;
    }

    public Dimension getMySize() {
        if (this.defaultSize == null) {
            this.defaultSize = new Dimension(600, 400);
        }
        return this.defaultSize;
    }

    public void initPreferences(IdvPreferenceManager preferenceManager) {
    }

    public XmlObjectStore getStore() {
        return this.idv == null ? null : this.idv.getStore();
    }

    public List getProjectionList() {
        return this.getIdv().getIdvProjectionManager().getProjections();
    }

    public IdvResourceManager getResourceManager() {
        return this.idv == null ? null : this.idv.getResourceManager();
    }

    public StateManager getStateManager() {
        return this.idv == null ? null : this.idv.getStateManager();
    }

    public PublishManager getPublishManager() {
        return this.idv == null ? null : this.idv.getPublishManager();
    }

    public IdvUIManager getIdvUIManager() {
        return this.idv == null ? null : this.idv.getIdvUIManager();
    }

    public VMManager getVMManager() {
        return this.idv == null ? null : this.idv.getVMManager();
    }

    public void parseProperties(String properties) {
        if (properties == null) {
            return;
        }
        List<String> props = StringUtil.split(properties, ";");
        for (int i = 0; i < props.size(); ++i) {
            String nameValue = props.get(i);
            int idx = nameValue.indexOf("=");
            if (idx < 0) continue;
            String propName = nameValue.substring(0, idx).trim();
            String propValue = nameValue.substring(idx + 1);
            this.setProperty(propName, propValue, false);
        }
    }

    public boolean setProperty(String name, String value, boolean ignoreError) {
        try {
            return Misc.propertySet(this, name, value, ignoreError);
        }
        catch (Exception exc) {
            this.logException("setProperty:" + name + " value= " + value, exc);
            return false;
        }
    }

    public boolean getIsActive() {
        if (this.master == null) {
            return false;
        }
        return this.master.isActive();
    }

    public void setMasterInactive() {
        if (this.master == null) {
            return;
        }
        try {
            this.master.setDisplayInactive();
        }
        catch (Exception exp) {
            this.logException("setMasterInactive", exp);
        }
    }

    public void setMasterActive() {
        this.setMasterActive(false);
    }

    public void setMasterActive(boolean force) {
        if (this.master == null) {
            return;
        }
        try {
            if (force) {
                this.master.setActive(true);
            } else {
                this.master.setDisplayActive();
            }
        }
        catch (Exception exp) {
            this.logException("setMasterActive", exp);
        }
    }

    public int getSideDividerLocation() {
        JSplitPane tmp = this.mainSplitPane;
        if (tmp != null) {
            return tmp.getDividerLocation();
        }
        return -1;
    }

    public void setSideDividerLocation(int l) {
        this.sideDividerLocation = l;
    }

    protected void addCommand(Command cmd) {
        this.getCommandManager().add(cmd, false);
    }

    public void keyWasTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int code = keyEvent.getKeyCode();
        int id = keyEvent.getID();
        if (id == 401 && GuiUtils.isControlKey(keyEvent)) {
            if (code == 90 || code == 89) {
                // empty if block
            }
            return;
        }
        if (id != 402) {
            return;
        }
        if (code == 112) {
            this.runVisibilityAnimation = false;
            this.stepVisibilityToggle();
        } else if (code == 113) {
            this.turnOnOffAllDisplays(true);
        } else if (code == 114) {
            this.turnOnOffAllDisplays(false);
        } else {
            if (GuiUtils.isControlKey(keyEvent, 73)) {
                this.doSaveImageInThread();
                return;
            }
            if (GuiUtils.isControlKey(keyEvent, 77)) {
                this.startImageCapture();
                return;
            }
            if (GuiUtils.isControlKey(keyEvent, 66)) {
                this.getIdv().doSaveAs();
                return;
            }
            if (!Character.isDigit(c)) {
                return;
            }
        }
    }

    public void setAnimatedVisibility(boolean state) {
        if (state == this.runVisibilityAnimation) {
            return;
        }
        this.runVisibilityAnimation = state;
        if (this.runVisibilityAnimation) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    if (ViewManager.this.getIsDestroyed()) {
                        return;
                    }
                    while (ViewManager.this.runVisibilityAnimation && !ViewManager.this.getIsDestroyed() && !ViewManager.this.getDisplayInfos().isEmpty()) {
                        int sleepTime = ViewManager.this.stepVisibilityToggle();
                        try {
                            Thread.sleep(sleepTime < 0 ? (long)ViewManager.this.animationSpeed : (long)(sleepTime * 1000));
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                    if (ViewManager.this.getIsDestroyed()) {
                        return;
                    }
                    if (ViewManager.this.getDisplayInfos().isEmpty()) {
                        ViewManager.this.runVisibilityAnimation = false;
                    }
                }
            };
            t.start();
        }
    }

    public void turnOnOffAllDisplays(boolean on) {
        this.runVisibilityAnimation = false;
        List controls = this.getControls();
        for (int i = controls.size() - 1; i >= 0; --i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            if (control.getLockVisibilityToggle()) continue;
            control.setDisplayVisibility(on);
        }
    }

    protected void notifyDisplayControls(String property) {
        List controls = this.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            control.viewManagerChanged(property);
        }
    }

    private int stepVisibilityToggle() {
        DisplayControl control;
        int i;
        this.currentVisibilityIdx = this.currentVisibilityIdx == -1 ? 0 : ++this.currentVisibilityIdx;
        List controls = this.getControls();
        int visbilityAnimationPause = -1;
        for (int cnt = 0; cnt < controls.size(); ++cnt) {
            DisplayControl control2;
            if (this.currentVisibilityIdx >= controls.size()) {
                this.currentVisibilityIdx = 0;
            }
            if (!(control2 = (DisplayControl)controls.get(this.currentVisibilityIdx)).getLockVisibilityToggle()) {
                visbilityAnimationPause = control2.getVisbilityAnimationPause();
                break;
            }
            ++this.currentVisibilityIdx;
        }
        ArrayList<DisplayControl> unlockedControls = new ArrayList<DisplayControl>();
        for (i = 0; i < controls.size(); ++i) {
            control = (DisplayControl)controls.get(i);
            if (control.getLockVisibilityToggle()) continue;
            unlockedControls.add(control);
        }
        for (i = 0; i < controls.size(); ++i) {
            control = (DisplayControl)controls.get(i);
            if (control.getLockVisibilityToggle()) continue;
            if (unlockedControls.size() == 1) {
                control.setDisplayVisibility(!control.getDisplayVisibility());
                continue;
            }
            control.setDisplayVisibility(i == this.currentVisibilityIdx);
        }
        return visbilityAnimationPause;
    }

    private void stepVisibilityToggle(int idx) {
        List controls = this.getControls();
        if (--idx >= controls.size()) {
            return;
        }
        int cnt = 0;
        for (int i = controls.size() - 1; i >= 0; --i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            if (cnt == idx) {
                control.setDisplayVisibility(true);
            } else if (!control.getLockVisibilityToggle()) {
                control.setDisplayVisibility(false);
            }
            ++cnt;
        }
    }

    protected void addToolBar(Component component, String id, String name) {
        this.toolbars.add(component);
        this.toolbarIds.add(id);
        this.toolbarNames.add(name);
    }

    protected void initToolBars() {
    }

    public boolean getShowBottomLegend() {
        return this.getStore().get(PREF_SHOWBOTTOMLEGEND, false);
    }

    public boolean getShowSideLegend() {
        return this.getStore().get(PREF_SHOWSIDELEGEND, true);
    }

    public boolean getShowAnimationBoxes() {
        return this.getStore().get(PREF_SHOWANIMATIONBOXES, true);
    }

    public void setShowControlLegend(boolean b) {
        this.showControlLegend = b;
        this.legendState = this.showControlLegend ? "docked" : "hidden";
    }

    public boolean getShowControlLegend() {
        return this.showControlLegend;
    }

    public void setLegendState(String value) {
        this.legendState = value;
    }

    public String getLegendState() {
        return this.legendState;
    }

    protected JMenuBar doMakeMenuBar() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ArrayList items = this.doMakeMenuList();
        JMenuBar menuBar = GuiUtils.makeMenuBar(items);
        return menuBar;
    }

    public ArrayList doMakeMenuList() {
        return new ArrayList();
    }

    public List getControls() {
        ArrayList<DisplayControl> controls = new ArrayList<DisplayControl>();
        List<DisplayInfo> localDisplayInfos = this.getDisplayInfos();
        Hashtable<DisplayControl, DisplayControl> seen = new Hashtable<DisplayControl, DisplayControl>();
        for (int i = 0; i < localDisplayInfos.size(); ++i) {
            DisplayControl control = localDisplayInfos.get(i).getDisplayControl();
            if (seen.get(control) != null) continue;
            seen.put(control, control);
            controls.add(control);
        }
        return controls;
    }

    public void displayDataChanged(DisplayControl displayControl) {
        if (this.idv.getUseTimeDriver() && displayControl.getIsTimeDriver()) {
            this.reloadTimeDriverDataSources(displayControl);
        }
    }

    private void reloadTimeDriverDataSources(DisplayControl displayControl) {
        List<DataSourceImpl> uniqueSources = Collections.synchronizedList(new ArrayList());
        List dcSources = null;
        if (displayControl != null) {
            dcSources = ((DisplayControlImpl)displayControl).getDataSources();
        }
        if (this.idv.getUseTimeDriver() && (displayControl == null || displayControl.getIsTimeDriver())) {
            for (DisplayControl displayControl2 : this.getControls()) {
                if (displayControl != null && displayControl2.equals(displayControl) || !((DisplayControlImpl)displayControl2).getUsesTimeDriver()) continue;
                List controlSources = ((DisplayControlImpl)displayControl2).getDataSources();
                for (int i = 0; i < controlSources.size(); ++i) {
                    DataSourceImpl ds = (DataSourceImpl)controlSources.get(i);
                    if (displayControl == null && !uniqueSources.contains(ds)) {
                        uniqueSources.add(ds);
                        continue;
                    }
                    if (uniqueSources.contains(ds) || dcSources.contains(ds)) continue;
                    uniqueSources.add(ds);
                }
            }
        }
        for (DataSource dataSource : uniqueSources) {
            try {
                Misc.run(dataSource, "reloadData");
            }
            catch (Exception e) {
                this.logException("Error reloading data source for " + dataSource.getName(), e);
            }
        }
    }

    public void animationDriverChanged() {
        for (DisplayControl control : this.getControls()) {
            if (!((DisplayControlImpl)control).getIsTimeDriver()) continue;
            ((DisplayControlImpl)control).setIsTimeDriver(false);
            ((DisplayControlImpl)control).setUsesTimeDriver(true);
        }
        this.reloadTimeDriverDataSources(null);
    }

    public List getControlsForLegend() {
        ArrayList<DisplayControl> legendControls = new ArrayList<DisplayControl>();
        List controls = this.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            if (!control.getShowInLegend()) continue;
            legendControls.add(control);
        }
        return legendControls;
    }

    public void setColors(Color foreground, Color background) {
        if (foreground == null) {
            foreground = this.foreground;
        }
        this.foreground = foreground;
        if (background == null) {
            background = this.background;
        }
        this.background = background;
        if (!this.hasDisplayMaster()) {
            return;
        }
        this.getMaster().setBackground(background);
        this.getMaster().setForeground(foreground);
        if (this.legends == null) {
            return;
        }
        for (IdvLegend legend : this.getLegends()) {
            legend.setColors(foreground, background);
        }
    }

    private void setDisplayCategoryVisiblity(String category, boolean on) {
        List controls = this.getControls();
        for (int i = controls.size() - 1; i >= 0; --i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            if (!Misc.equals(control.getDisplayCategory(), category)) continue;
            control.setDisplayVisibility(on);
        }
    }

    public void displayControlChanged(DisplayControl displayControl) {
        this.fillLegends();
        if (this.timelineDialog != null) {
            this.timelineDialog.repaint();
        }
    }

    public void displayControlVisibilityChanged(DisplayControl displayControl) {
        if (this.timelineDialog != null) {
            this.timelineDialog.repaint();
        }
        this.updateDisplayList();
    }

    protected void fillLegends() {
        if (this.shouldDoThingsRightAway()) {
            this.reallyFillLegends();
        } else {
            this.dirty = true;
        }
    }

    protected void reallyFillLegends() {
        if (!this.getStateManager().isLoadingXml() || !this.shouldDoThingsRightAway()) {
            this.fillLegendsInner();
        } else {
            this.fillLegendsTime = System.currentTimeMillis() + 1000L;
            if (!this.fillLegendsPending) {
                this.fillLegendsPending = true;
                Misc.run(this, "fillLegendsLater");
            }
        }
    }

    public void fillLegendsLater() {
        while (this.fillLegendsPending) {
            long diff = this.fillLegendsTime - System.currentTimeMillis();
            if (diff > 0L) {
                Misc.sleep(diff);
                continue;
            }
            if (!this.fillLegendsPending) break;
            this.fillLegendsInner();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillLegendsInner() {
        this.fillLegendsPending = false;
        this.updateDisplayList();
        Object object = this.LEGENDMUTEX;
        synchronized (object) {
            for (IdvLegend legend : this.getLegends()) {
                legend.fillLegend();
            }
        }
    }

    public void initDisplayMenu(JMenu displayMenu) {
        List controls = this.getControls();
        JMenuItem item = null;
        boolean didone = false;
        int cnt = 0;
        if (this.getShowSideLegend()) {
            if (!this.legendState.equals("hidden")) {
                displayMenu.add(GuiUtils.makeMenuItem("Hide Legend", this, "setSideLegendPosition", "hidden"));
            }
            if (!this.legendState.equals("docked")) {
                displayMenu.add(GuiUtils.makeMenuItem("Embed Legend", this, "setSideLegendPosition", "docked"));
            }
            if (!this.legendState.equals("float")) {
                displayMenu.add(GuiUtils.makeMenuItem("Float Legend", this, "setSideLegendPosition", "float"));
            }
            displayMenu.addSeparator();
        }
        for (int i = controls.size() - 1; i >= 0; --i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            if (!didone) {
                didone = true;
                displayMenu.add(GuiUtils.makeMenuItem("Remove All Displays", this, "clearDisplays"));
                if (this.animationMenu == null) {
                    this.animationMenu = new JMenu("Visibility Animation");
                    this.animationCB = new JCheckBoxMenuItem("On");
                    this.animationCB.addActionListener(new ObjectListener(null){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            ViewManager.this.setAnimatedVisibility(((JCheckBoxMenuItem)event.getSource()).isSelected());
                        }
                    });
                    this.animationMenu.add(this.animationCB);
                    item = new JMenuItem("Faster");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            if (ViewManager.this.animationSpeed > 300) {
                                ViewManager.this.animationSpeed = ViewManager.this.animationSpeed - 200;
                            }
                        }
                    });
                    this.animationMenu.add(item);
                    item = new JMenuItem("Slower");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            ViewManager.this.animationSpeed = ViewManager.this.animationSpeed + 200;
                        }
                    });
                    this.animationMenu.add(item);
                }
                displayMenu.add(this.animationMenu);
                displayMenu.addSeparator();
            }
            String legendOrder = " #" + ++cnt + "  ";
            String label = legendOrder + " " + control.getMenuLabel();
            displayMenu.add(GuiUtils.makeMenu(label, control.getControlMenus(displayMenu)));
        }
        if (!didone) {
            displayMenu.add(new JLabel("No displays"));
        }
    }

    public void addDisplayListener(DisplayListener listener) {
        this.getMaster().addDisplayListener(listener);
    }

    public DisplayConventions getDisplayConventions() {
        return this.idv.getDisplayConventions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisplayInfo(DisplayInfo displayInfo) throws RemoteException, VisADException {
        Displayable displayable;
        if (this.getIsDestroyed()) {
            return;
        }
        List<DisplayInfo> list = this.displayInfos;
        synchronized (list) {
            this.displayInfos.remove(displayInfo);
        }
        if (this.master != null && (displayable = displayInfo.getDisplayable()) != null) {
            this.master.removeDisplayable(displayable);
        }
        this.fillLegends();
        this.updateTimelines(true);
    }

    public boolean getUseFastRendering(boolean b) {
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisplayInfos(List<DisplayInfo> displayInfos) throws RemoteException, VisADException {
        if (this.getIsDestroyed()) {
            return;
        }
        this.setMasterInactive();
        try {
            if (this.master != null) {
                for (DisplayInfo info : displayInfos) {
                    info.setDisplayableAdded(this.addDisplayInfo(info));
                }
            }
            if (this.shouldDoThingsRightAway()) {
                this.fillLegends();
                this.updateTimelines(true);
                if (!this.getStateManager().isLoadingXml()) {
                    this.toFront();
                }
            } else {
                this.dirty = true;
            }
        }
        finally {
            this.setMasterActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDisplayInfo(DisplayInfo displayInfo) throws RemoteException, VisADException {
        if (this.getIsDestroyed()) {
            return false;
        }
        List<DisplayInfo> list = this.displayInfos;
        synchronized (list) {
            if (this.displayInfos.contains(displayInfo)) {
                return true;
            }
            this.displayInfos.add(displayInfo);
        }
        if (this.master != null) {
            if (this.shouldDoThingsRightAway()) {
                this.master.addDisplayable(displayInfo.getDisplayable());
            } else {
                this.dirty = true;
            }
        }
        return true;
    }

    public void updateDisplayIfNeeded() throws VisADException, RemoteException {
        if (!this.dirty || this.master == null) {
            return;
        }
        this.dirty = false;
        List<DisplayInfo> tmpList = this.getDisplayInfos();
        this.master.setDisplayInactive();
        for (int i = 0; i < tmpList.size(); ++i) {
            DisplayInfo displayInfo = tmpList.get(i);
            this.master.addDisplayable(displayInfo.getDisplayable());
        }
        this.reallyFillLegends();
        this.master.draw();
    }

    public void toFront() {
        Window window = GuiUtils.getWindow(this.getComponent());
        if (window != null) {
            GuiUtils.toFront(window);
        }
    }

    public void clearDisplays() {
        if (this.getIsDestroyed()) {
            return;
        }
        try {
            List<DisplayInfo> tmpList = this.getDisplayInfos();
            for (int i = 0; i < tmpList.size(); ++i) {
                DisplayControl dc = tmpList.get(i).getDisplayControl();
                if (!dc.getCanDoRemoveAll()) continue;
                dc.doRemove();
            }
            this.fillLegends();
            this.updateTimelines(true);
        }
        catch (Exception exp) {
            this.logException("clearDisplays", exp);
        }
    }

    public void controlMoved(DisplayControl control) {
        this.fillLegends();
        this.getIdv().getIdvUIManager().getViewPanel().controlMoved(control);
    }

    protected JMenu makeShowMenu() {
        JMenu showMenu = new JMenu("Show");
        this.createCBMI(showMenu, PREF_WIREFRAME);
        this.createCBMI(showMenu, PREF_WAITMSG);
        this.createCBMI(showMenu, PREF_SHOWDISPLAYLIST);
        this.createCBMI(showMenu, PREF_TOPBAR_VISIBLE);
        return showMenu;
    }

    public JMenu makeViewMenu() {
        JMenu viewMenu = GuiUtils.makeDynamicMenu("View", this, "firstInitializeViewMenu");
        viewMenu.setMnemonic(GuiUtils.charToKeyCode("V"));
        if (this.viewMenu == null) {
            this.viewMenu = viewMenu;
        }
        return viewMenu;
    }

    public void addContextMenuItems(List menuItems) {
        menuItems.add(GuiUtils.makeMenuItem("Show Window", this, "toFront"));
        menuItems.add("separator");
        menuItems.addAll(this.doMakeMenuList());
    }

    public void firstInitializeViewMenu(JMenu viewMenu) {
        this.initializeViewMenu(viewMenu);
        Msg.translateTree(viewMenu);
    }

    public void initializeViewMenu(JMenu viewMenu) {
        if (this.showControlMenu) {
            JMenu displayMenu = GuiUtils.makeDynamicMenu("Displays", this, "initDisplayMenu");
            viewMenu.add(displayMenu);
            viewMenu.addSeparator();
        }
        ArrayList<JMenuItem> renderItems = new ArrayList<JMenuItem>();
        renderItems.add(GuiUtils.makeMenuItem("Make Frames", this, "makeFrames"));
        if (this.usingImagePanel) {
            renderItems.add(GuiUtils.makeMenuItem("Reset to display", this, "useDisplay"));
        } else if (this.imagePanel != null) {
            renderItems.add(GuiUtils.makeMenuItem("Reset to images", this, "useImages"));
        }
        JMenu captureMenu = new JMenu("Capture");
        viewMenu.add(captureMenu);
        JMenuItem mi = (JMenuItem)GuiUtils.setIcon(GuiUtils.makeMenuItem("Image...  Ctrl+I", this, "doSaveImageInThread"), "/auxdata/ui/icons/camera.png");
        captureMenu.add(mi);
        mi = (JMenuItem)GuiUtils.setIcon(GuiUtils.makeMenuItem("Movie...  Ctrl+M", this, "startImageCapture"), "/auxdata/ui/icons/film.png");
        captureMenu.add(mi);
        captureMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Print...", this, "doPrintImage", null, true), "/auxdata/ui/icons/printer.png"));
        viewMenu.add(this.makeShowMenu());
        if (this.viewMenu == null) {
            this.viewMenu = viewMenu;
        }
    }

    protected JMenu makeSavedViewsMenu() {
        return GuiUtils.makeDynamicMenu("Viewpoints", this, "initViewStateMenu");
    }

    public void initViewStateMenu(JMenu viewStateMenu) {
        viewStateMenu.add(GuiUtils.makeMenuItem("Save Current Viewpoint", this.getViewManager(), "doSaveState"));
        viewStateMenu.addSeparator();
        this.makeViewStateMenu(viewStateMenu);
    }

    public boolean isCompatibleWith(ViewManager vm) {
        String skin;
        IdvWindow thisWindow = this.getDisplayWindow();
        if (thisWindow != null && (skin = thisWindow.getSkinPath()) != null && !Misc.equals("/ucar/unidata/idv/resources/skins/skin.xml", skin)) {
            return false;
        }
        return this.getClass().equals(vm.getClass());
    }

    public boolean isCompatibleWith(ViewState viewState) {
        return this.getClass().getName().toString().equals(viewState.getViewClassName().trim());
    }

    protected void makeViewStateMenu(JMenu viewStateMenu) {
        this.getIdvUIManager().makeViewStateMenu(viewStateMenu, this);
    }

    public AnimationWidget getAnimationWidget() {
        return this.animationWidget;
    }

    public void setExternalAnimation(Animation value, AnimationWidget widget) {
        this.externalAnimation = value;
        this.externalAnimationWidget = widget;
    }

    public Animation getExternalAnimation() {
        return this.externalAnimation;
    }

    public AnimationWidget getExternalAnimationWidget() {
        return this.externalAnimationWidget;
    }

    public Animation getAnimation() {
        if (this.animation == null && this.animationOk()) {
            try {
                if (this.animationInfo == null) {
                    this.animationInfo = (AnimationInfo)this.getIdv().getPersistenceManager().getPrototype(AnimationInfo.class);
                    if (this.animationInfo == null) {
                        this.animationInfo = new AnimationInfo();
                        this.animationInfo.setBoxesVisible(this.getShowAnimationBoxes());
                    }
                }
                this.animationWidget = new AnimationWidget(this.animationInfo);
                this.animationWidget.setUniqueId(this.getUniqueId() + "_anim");
                this.animation = new Animation();
                this.animationWidget.setAnimation(this.animation);
                this.timesArray = this.animationWidget.getTimesArray();
                this.animation.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        AnimationInfo aniInfo = ViewManager.this.animationWidget.getAnimationInfo();
                        try {
                            if (evt.getPropertyName().equals("aniValue")) {
                                ViewManager.this.animationTimeChanged();
                                ViewManager.this.updateTimelines(false);
                                if (ViewManager.this.imagePanel != null) {
                                    ViewManager.this.imagePanel.setSelectedFile(ViewManager.this.animation.getCurrent());
                                }
                            } else if (evt.getPropertyName().equals("animationSet")) {
                                if (ViewManager.this.animationTimeline != null) {
                                    ViewManager.this.animationTimeline.setDatedThings(DatedObject.wrap(Util.makeDates(ViewManager.this.animationWidget.getTimes())));
                                }
                                if (aniInfo != null && aniInfo.getAnimationSetInfo().getActive() && aniInfo.getAnimationSetInfo().getIsTimeDriver() && !ViewManager.this.timesArray.equals(ViewManager.this.animationWidget.getTimesArray())) {
                                    long tt = (int)(aniInfo.getAnimationSetInfo().getPollMinutes() * 60.0 * 1000.0);
                                    if ((double)(System.currentTimeMillis() - ViewManager.this.lastTimePolled) >= (double)tt * 0.8) {
                                        ViewManager.this.animationDriverChanged();
                                        ViewManager.this.lastTimePolled = System.currentTimeMillis();
                                    } else if (!aniInfo.getAnimationSetInfo().equals(ViewManager.this.animationInfo.getAnimationSetInfo())) {
                                        ViewManager.this.animationDriverChanged();
                                        ViewManager.this.animationInfo.setAnimationSetInfo(aniInfo.getAnimationSetInfo());
                                        ViewManager.this.lastTimePolled = System.currentTimeMillis();
                                    }
                                    ViewManager.access$1402(ViewManager.this, ViewManager.this.animationWidget.getTimesArray());
                                }
                            }
                        }
                        catch (Exception exp) {
                            ViewManager.this.logException("updating timeline", exp);
                        }
                    }
                });
            }
            catch (Exception exp) {
                this.logException("getAnimation", exp);
            }
        }
        return this.animation;
    }

    public boolean animationOk() {
        return true;
    }

    public void setAnimationInfo(AnimationInfo value) {
        this.animationInfo = value;
    }

    public AnimationInfo getAnimationInfo() {
        if (this.animationWidget != null) {
            return this.animationWidget.getAnimationInfo();
        }
        return null;
    }

    public boolean getIsDestroyed() {
        return this.isDestroyed;
    }

    public void addRemovable(Removable removable) {
        this.removables.add(removable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        this.getIdvUIManager().viewManagerDestroyed(this);
        for (Removable removable : this.removables) {
            removable.doRemove();
        }
        this.removables = null;
        this.setMasterInactive();
        if (this.displayInfos != null) {
            List<DisplayInfo> tmpList = this.getDisplayInfos();
            for (int i = 0; i < tmpList.size(); ++i) {
                try {
                    tmpList.get(i).getDisplayControl().viewManagerDestroyed(this);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.getVMManager() != null) {
            this.getVMManager().removeViewManager(this);
        }
        while (this.outstandingWaits-- >= 0) {
        }
        this.removeSharable();
        if (this.timelineDialog != null) {
            this.timelineDialog.dispose();
        }
        if (this.propertiesDialog != null) {
            this.propertiesDialog.dispose();
        }
        if (this.animationWidget != null) {
            this.animationWidget.destroy();
        }
        if (this.master != null) {
            try {
                if (this.displayListDisplayables != null) {
                    this.master.removeDisplayable(this.displayListDisplayables);
                }
                this.master.destroy();
            }
            catch (Throwable exp) {
                Throwable wrappedExc = LogUtil.getInnerException(exp);
                LogUtil.consoleMessage("Had an error destroying the DisplayMaster:" + wrappedExc);
            }
            this.master = null;
        }
        if (this.animationMenu != null) {
            GuiUtils.empty(this.animationMenu, true);
        }
        if (this.viewMenu != null) {
            GuiUtils.empty(this.viewMenu, true);
        }
        if (this.menuBar != null) {
            GuiUtils.empty(this.menuBar, true);
        }
        if (this.fullContents != null) {
            GuiUtils.empty(this.fullContents, true);
        }
        this.timelineDialog = null;
        this.propertiesDialog = null;
        this.animationWidget = null;
        this.keyboardBehavior = null;
        this.displayListDisplayables = null;
        this.animation = null;
        this.legends = null;
        this.sideLegend = null;
        this.sideLegendComponent = null;
        this.mainSplitPane = null;
        this.animationMenu = null;
        this.viewMenu = null;
        this.menuBar = null;
        this.fullContents = null;
        this.idv = null;
        this.displayInfos.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DisplayInfo> getDisplayInfos() {
        List<DisplayInfo> list = this.displayInfos;
        synchronized (list) {
            ArrayList<DisplayInfo> tmp = new ArrayList<DisplayInfo>(this.displayInfos);
            return tmp;
        }
    }

    public String toString() {
        return "View:" + this.getViewDescriptor();
    }

    public String getTypeName() {
        return "View";
    }

    public ViewDescriptor getViewDescriptor() {
        if (this.aliases.size() > 0) {
            return (ViewDescriptor)this.aliases.get(0);
        }
        return null;
    }

    public void setViewDescriptor(ViewDescriptor vd) {
        this.addViewDescriptor(vd);
    }

    public void addViewDescriptor(ViewDescriptor vd) {
        if (vd != null && !vd.nameEquals(ViewDescriptor.LASTACTIVE) && !this.aliases.contains(vd)) {
            this.aliases.add(vd);
        }
    }

    public boolean isDefinedBy(ViewDescriptor vd) {
        if (!this.isClassOk(vd)) {
            return false;
        }
        for (int i = 0; i < this.aliases.size(); ++i) {
            ViewDescriptor viewDescriptor = (ViewDescriptor)this.aliases.get(i);
            if (!viewDescriptor.nameEquals(vd)) continue;
            return true;
        }
        return false;
    }

    public boolean canBe(ViewManager that) {
        return that.getClass().equals(this.getClass());
    }

    public boolean isClassOk(ViewDescriptor vd) {
        if (vd == null) {
            return false;
        }
        List classNames = vd.getClassNames();
        if (classNames == null || classNames.size() == 0) {
            return true;
        }
        String className = this.getClass().getName();
        return classNames.contains(className);
    }

    public ViewManager getViewManager() {
        return this;
    }

    @Override
    public String getUniqueId() {
        ViewDescriptor viewDescriptor = this.getViewDescriptor();
        if (viewDescriptor != null) {
            return viewDescriptor.getName();
        }
        return Misc.getUniqueId();
    }

    public JComponent getComponent() {
        return (JComponent)this.getMaster().getComponent();
    }

    public Container getContents() {
        if (this.fullContents == null) {
            this.initUI();
        }
        return this.fullContents;
    }

    public JComponent getInnerContents() {
        return null;
    }

    protected Container doMakeContents() {
        if (this.master == null) {
            return new JPanel();
        }
        Component mc = this.master.getComponent();
        return GuiUtils.topCenter(null, mc);
    }

    public void setCursorInDisplay(Cursor c) {
        JComponent comp = this.getComponent();
        if (comp != null) {
            comp.setCursor(c);
        }
    }

    public boolean hasDisplayMaster() {
        return this.master != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMaster getMaster() {
        if (this.master == null) {
            try {
                Object object = this.MASTER_MUTEX;
                synchronized (object) {
                    DisplayMaster tmpMaster;
                    if (this.master != null) {
                        return this.master;
                    }
                    if (this.initProperties != null) {
                        String tmp = this.initProperties;
                        this.initProperties = null;
                        this.parseProperties(tmp);
                    }
                    if ((tmpMaster = this.doMakeDisplayMaster()) == null) {
                        return null;
                    }
                    DisplayRenderer renderer = tmpMaster.getDisplay().getDisplayRenderer();
                    if (renderer instanceof DisplayRendererJ3D) {
                        this.initLights((DisplayRendererJ3D)renderer);
                    }
                    if (!this.shouldDoThingsRightAway()) {
                        tmpMaster.setDisplayInactive();
                    } else {
                        tmpMaster.setMouseFunctions(this.getIdv().getPreferenceManager().getMouseMap());
                        tmpMaster.setKeyboardEventMap(this.getIdv().getPreferenceManager().getKeyboardMap());
                        tmpMaster.setWheelEventMap(this.getIdv().getPreferenceManager().getWheelMap());
                    }
                    GraphicsModeControl gmc = tmpMaster.getDisplay().getGraphicsModeControl();
                    gmc.setCacheAppearances(true);
                    gmc.setMergeGeometries(true);
                    this.setDisplayMaster(tmpMaster);
                    if (this.shouldDoThingsRightAway()) {
                        Trace.call1("ViewManager.getMaster master.draw");
                        tmpMaster.draw();
                        Trace.call2("ViewManager.getMaster master.draw");
                        Trace.call1("ViewManager.getMaster updateDisplayList");
                        this.updateDisplayList();
                        Trace.call2("ViewManager.getMaster updateDisplayList");
                    }
                    this.master = tmpMaster;
                }
            }
            catch (Exception exc) {
                this.logException("Creating display master", exc);
            }
        }
        return this.master;
    }

    public boolean shouldDoThingsRightAway() {
        return true;
    }

    public boolean isInteractive() {
        return this.getIdv().getInteractiveMode();
    }

    protected DisplayMaster doMakeDisplayMaster() throws VisADException, RemoteException {
        return null;
    }

    public DisplayRenderer getDisplayRenderer() {
        if (this.master != null) {
            DisplayImpl vdisplay = (DisplayImpl)this.master.getDisplay();
            return vdisplay.getDisplayRenderer();
        }
        return null;
    }

    protected void setDisplayMaster(DisplayMaster master) {
        if (this.master != null) {
            // empty if block
        }
        this.master = master;
        DisplayImpl display = (DisplayImpl)master.getDisplay();
        display.addDisplayListener(this);
        display.enableEvent(1);
        display.enableEvent(25);
        this.resetProjectionControl();
    }

    protected void resetProjectionControl() {
        DisplayImpl display = (DisplayImpl)this.master.getDisplay();
        this.projectionControl = display.getProjectionControl();
        this.projectionControl.addControlListener(this);
    }

    public ProjectionControl getProjectionControl() {
        return this.projectionControl;
    }

    public CommandManager getCommandManager() {
        if (this.commandManager == null) {
            this.commandManager = new CommandManager(100);
        }
        return this.commandManager;
    }

    @Override
    public final void controlChanged(ControlEvent e) {
        if (!this.initDone || this.getIsDestroyed()) {
            return;
        }
        this.handleControlChanged(e);
    }

    protected void handleControlChanged(ControlEvent e) {
        this.setMatrixLabel(false);
    }

    @Override
    public void displayChanged(DisplayEvent de) throws VisADException, RemoteException {
        int eventId = de.getId();
        InputEvent inputEvent = de.getInputEvent();
        if (this.getIsDestroyed()) {
            return;
        }
        if (eventId == 1) {
            // empty if block
        }
        if (this.getIsShared() && !this.lastActive) {
            if (eventId == 1) {
                this.getVMManager().setLastActiveViewManager(this);
            } else if (!this.clickToFocus && eventId == 21) {
                this.getVMManager().setLastActiveViewManager(this);
            }
        }
        if (eventId == 16) {
            if (inputEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)inputEvent;
                if (keyEvent.getKeyCode() == 27) {
                    Misc.runInABit(100L, this, "resetFullScreen", null);
                } else if (keyEvent.getKeyCode() == 116) {
                    Misc.runInABit(100L, this, "toggleFullScreen", null);
                }
            }
        } else if (eventId == 22) {
            if (LogUtil.getTestMode()) {
                ++this.outstandingWaits;
                if (this.outstandingWaits == 1) {
                    this.getIdvUIManager().showWaitCursor();
                }
            } else {
                this.waitCursorInABit(++this.currentWaitKey);
            }
        } else if (eventId == 23) {
            ++this.currentWaitKey;
            if (this.outstandingWaits == 0) {
                return;
            }
            --this.outstandingWaits;
            if (this.outstandingWaits <= 0) {
                this.getIdvUIManager().showNormalCursor();
                this.outstandingWaits = 0;
            }
        } else if (eventId == 1) {
            this.mouseDown = true;
            this.mousePressedMatrix = this.getMaster().getProjectionMatrix();
        } else if (eventId == 7) {
            this.mouseDown = false;
            double[] currentMatrix = this.getMaster().getProjectionMatrix();
            if (this.mousePressedMatrix != null && !Arrays.equals(currentMatrix, this.mousePressedMatrix)) {
                this.addCommand(new MatrixCommand(this, this.mousePressedMatrix, currentMatrix));
            }
            this.mousePressedMatrix = null;
        } else if (eventId == 3) {
            if (!this.receivedFirstFrameDone) {
                this.doneFirstFrame();
            }
            this.lastFrameDoneTime = System.currentTimeMillis();
        } else if (eventId == 25) {
            final int myComponentResizeCnt = ++this.componentResizeCnt;
            Misc.runInABit(200L, new Runnable(){

                @Override
                public void run() {
                    if (ViewManager.this.isDestroyed) {
                        return;
                    }
                    if (myComponentResizeCnt == ViewManager.this.componentResizeCnt) {
                        ViewManager.this.updateAnnotations();
                        ViewManager.this.updateDisplayList();
                        ViewManager.this.notifyDisplayControls(ViewManager.PROP_COMPONENT_RESIZED);
                    }
                }
            });
        }
    }

    public long getLastFrameDoneTime() {
        return this.lastFrameDoneTime;
    }

    protected void doneFirstFrame() {
        if (this.getIsShared()) {
            this.setLastActive(this.lastActive);
        }
        this.receivedFirstFrameDone = true;
        List controls = this.getControls();
        for (int i = controls.size() - 1; i >= 0; --i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            control.firstFrameDone();
        }
        this.updateDisplayList();
    }

    private void waitCursorInABit(final int timeStamp) {
        Misc.runInABit(500L, new Runnable(){

            @Override
            public void run() {
                if (timeStamp != ViewManager.this.currentWaitKey) {
                    return;
                }
                ViewManager.this.outstandingWaits++;
                if (ViewManager.this.outstandingWaits == 1) {
                    ViewManager.this.getIdvUIManager().showWaitCursor();
                }
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    public void makeFrames() {
        ImageSequenceGrabber isg = new ImageSequenceGrabber(this, null, true);
    }

    public boolean useDisplay() {
        if (!this.usingImagePanel) {
            return false;
        }
        this.usingImagePanel = false;
        this.contentsWrapper.removeAll();
        this.contentsWrapper.add("Center", this.innerContents);
        this.contentsWrapper.revalidate();
        return true;
    }

    public void useImages() {
    }

    public void useImages(List images, boolean andShow) {
    }

    public synchronized void startImageCapture() {
        if (this.isg != null) {
            LogUtil.userMessage("The Movie Capture dialog window is open");
            this.isg.show();
            return;
        }
        this.isg = new ImageSequenceGrabber(this);
    }

    public void clearImageGrabber(ImageSequenceGrabber grabber) {
        if (this.isg == grabber) {
            this.isg = null;
        }
    }

    public void writeTestArchive(String archivePath) {
        try {
            String imageFile = archivePath + ".png";
            this.toFront();
            Misc.sleepSeconds(1L);
            System.err.println("Writing image:" + imageFile);
            this.writeImage(imageFile, true);
        }
        catch (Exception exc) {
            this.logException("writeTestArchive", exc);
        }
    }

    public void showWindow() {
        this.toFront();
    }

    public void writeImage(String fileName) {
        this.writeImage(fileName, false);
    }

    public void writeImage(String fileName, boolean block) {
        this.writeImage(new File(fileName), block);
    }

    public void writeImage(String fileName, boolean block, float quality) {
        this.writeImage(new File(fileName), block, quality);
    }

    public void writeImage(File file) {
        this.writeImage(file, false);
    }

    public void writeImage(File file, boolean block) {
        this.writeImage(file, block, false);
    }

    public void writeImage(File file, boolean block, boolean sync) {
        this.toFront();
        Misc.sleep(100L);
        this.master.saveCurrentDisplay(file, sync, block);
    }

    public void writeImage(File file, boolean block, float quality) {
        this.toFront();
        try {
            this.master.setDisplayActive();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Misc.sleep(100L);
        this.master.saveCurrentDisplay(file, true, block, quality);
    }

    public void doSaveState() {
        this.getVMManager().saveViewManagerState(this);
    }

    public void doSaveImage() {
        this.doSaveImage(false);
    }

    public void doPrintImage() {
        try {
            this.toFront();
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(((DisplayImpl)this.getMaster().getDisplay()).getPrintable());
            if (!printJob.printDialog()) {
                return;
            }
            printJob.print();
        }
        catch (Exception exc) {
            this.logException("There was an error printing the image", exc);
        }
    }

    public void setView(String view) {
        if (this.getMaster() instanceof NavigatedDisplay) {
            NavigatedDisplay navDisplay = (NavigatedDisplay)this.getMaster();
            navDisplay.setView(view);
        }
    }

    public void doSaveImageInThread() {
        Misc.run(this, "doSaveImage");
    }

    public GeoLocationInfo getVisibleGeoBounds() {
        return null;
    }

    public static boolean isVectorGraphicsFile(String filename) {
        return filename.toLowerCase().endsWith(".pdf") || filename.toLowerCase().endsWith(".ps") || filename.toLowerCase().endsWith(".eps") || filename.toLowerCase().endsWith(".svg");
    }

    public void doSaveImage(boolean andSaveBundle) {
        SecurityManager backup = System.getSecurityManager();
        System.setSecurityManager(null);
        try {
            String filename;
            if (hiBtn == null) {
                hiBtn = new JRadioButton("High", true);
                medBtn = new JRadioButton("Medium", false);
                lowBtn = new JRadioButton("Low", false);
                GuiUtils.buttonGroup(hiBtn, medBtn).add(lowBtn);
                backgroundTransparentBtn = new JCheckBox("BG Transparent");
                backgroundTransparentBtn.setToolTipText("Set the background color to be transparent");
                mainDisplayBtn = new JRadioButton("Current View", true);
                allViewsBtn = new JRadioButton("All Views", false);
                contentsBtn = new JRadioButton("Current View & Legend", false);
                fullWindowBtn = new JRadioButton("Full Window", false);
                GuiUtils.buttonGroup(mainDisplayBtn, allViewsBtn, fullWindowBtn).add(contentsBtn);
            }
            if (this.publishCbx == null) {
                this.publishCbx = this.getIdv().getPublishManager().makeSelector();
            }
            hiBtn.setBorder(null);
            medBtn.setBorder(null);
            lowBtn.setBorder(null);
            mainDisplayBtn.setBorder(null);
            allViewsBtn.setBorder(null);
            contentsBtn.setBorder(null);
            fullWindowBtn.setBorder(null);
            ArrayList<JComponent> comps = new ArrayList<JComponent>();
            comps.add(new JLabel("Capture What:"));
            comps.add(GuiUtils.inset((Component)GuiUtils.vbox(mainDisplayBtn, contentsBtn, allViewsBtn, fullWindowBtn), new Insets(2, 8, 10, 0)));
            comps.add(new JLabel("Quality:"));
            comps.add(GuiUtils.inset((Component)GuiUtils.hbox((Component)hiBtn, (Component)medBtn, lowBtn), new Insets(3, 0, 1, 0)));
            comps.add(backgroundTransparentBtn);
            if (this.publishCbx != null) {
                comps.add(GuiUtils.inset((Component)this.publishCbx, new Insets(10, 0, 0, 0)));
            }
            JPanel accessory = GuiUtils.vbox(comps);
            PatternFileFilter captureFilter = new PatternFileFilter(".+\\.jpg|.+\\.gif|.+\\.jpeg|.+\\.png|.+\\.pdf|.+\\.ps|.+\\.svg", "Image files (*.jpg,*.gif,*.png,*.pdf,*.ps,*.svg)");
            List filters = Misc.newList(captureFilter);
            GeoLocationInfo bounds = this.getVisibleGeoBounds();
            if (bounds != null) {
                filters.add(KmlDataSource.FILTER_KML);
            }
            if ((filename = FileManager.getWriteFile(filters, ".jpg", (JComponent)GuiUtils.top(GuiUtils.inset((Component)accessory, 5)))) != null) {
                String whichComponent;
                if (ViewManager.isVectorGraphicsFile(filename)) {
                    ArrayList<ViewManager> l = new ArrayList<ViewManager>();
                    if (allViewsBtn.isSelected()) {
                        for (Object o : this.getDisplayWindow().getViewManagers()) {
                            l.add((ViewManager)o);
                        }
                    } else {
                        l.add(this);
                    }
                    VectorGraphicsRenderer vectorRenderer = new VectorGraphicsRenderer(l, ViewManager.getColumnCountFromVM(l));
                    if (vectorRenderer.showConfigDialog()) {
                        vectorRenderer.renderTo(filename);
                        this.getIdv().getPublishManager().publishContent(filename, this, this.publishCbx);
                    }
                    System.setSecurityManager(backup);
                    return;
                }
                float quality = 1.0f;
                if (medBtn.isSelected()) {
                    quality = 0.6f;
                } else if (lowBtn.isSelected()) {
                    quality = 0.2f;
                }
                ArrayList<Component> views = new ArrayList<Component>();
                if (fullWindowBtn.isSelected()) {
                    views.add(this.getDisplayWindow().getComponent());
                    whichComponent = "full window";
                } else if (mainDisplayBtn.isSelected()) {
                    views.add(this.getMaster().getComponent());
                    whichComponent = "main display";
                } else if (allViewsBtn.isSelected()) {
                    ArrayList viewManagers = new ArrayList();
                    viewManagers.addAll(this.getDisplayWindow().getViewManagers());
                    for (IdvComponentGroup icg : this.getDisplayWindow().getComponentGroups()) {
                        for (IdvComponentHolder idh : icg.getDisplayComponents()) {
                            viewManagers.addAll(idh.getViewManagers());
                        }
                    }
                    for (ViewManager v : viewManagers) {
                        views.add(v.getComponent());
                    }
                    whichComponent = "all displays";
                } else {
                    views.add(this.getContents());
                    whichComponent = "contents";
                }
                List<BufferedImage> images = this.makeBufferedImages(views, whichComponent);
                BufferedImage image = (BufferedImage)ImageUtils.gridImages2(images, 0, Color.GRAY, ImageUtils.getColumnCountFromComps(views));
                if (image != null && backgroundTransparentBtn.isSelected()) {
                    image = ImageUtils.makeColorTransparent(image, this.getBackground());
                }
                if (KmlDataSource.isKmlFile(filename)) {
                    if (!this.checkForKmlImageCapture()) {
                        return;
                    }
                    String kmlFilename = filename;
                    String suffix = ".png";
                    filename = IOUtil.stripExtension(filename) + suffix;
                    if (kmlFilename.endsWith(".kml")) {
                        KmlDataSource.writeToFile(kmlFilename, bounds, filename);
                    } else {
                        String tail = IOUtil.stripExtension(IOUtil.getFileTail(kmlFilename));
                        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(kmlFilename));
                        zos.putNextEntry(new ZipEntry(tail + ".kml"));
                        byte[] kmlBytes = KmlDataSource.createKml(bounds, tail + suffix).getBytes();
                        zos.write(kmlBytes, 0, kmlBytes.length);
                        String tmpFile = IOUtil.joinDir(this.getIdv().getObjectStore().getUserTmpDirectory(), Math.random() + "" + System.currentTimeMillis() + suffix);
                        ImageUtils.writeImageToFile(image, tmpFile, quality);
                        byte[] imageBytes = IOUtil.readBytes(new FileInputStream(tmpFile));
                        zos.putNextEntry(new ZipEntry(tail + suffix));
                        zos.write(imageBytes, 0, imageBytes.length);
                        zos.close();
                        this.getIdv().getPublishManager().publishContent(kmlFilename, this, this.publishCbx);
                        return;
                    }
                }
                ImageUtils.writeImageToFile(image, filename, quality);
                this.getIdv().getPublishManager().publishContent(filename, this, this.publishCbx);
                if (andSaveBundle) {
                    filename = IOUtil.stripExtension(filename) + ".jnlp";
                    this.getIdv().getPersistenceManager().doSave(filename);
                }
            }
        }
        catch (Exception exp) {
            this.logException("doSaveImage", exp);
        }
        System.setSecurityManager(backup);
    }

    private static int getColumnCountFromVM(List<? extends ViewManager> viewManagers) {
        LinkedList<JComponent> l = new LinkedList<JComponent>();
        for (ViewManager viewManager : viewManagers) {
            l.add(viewManager.getComponent());
        }
        return ImageUtils.getColumnCountFromComps(l);
    }

    private List<BufferedImage> makeBufferedImages(List<Component> views, String whichComponent) throws AWTException {
        LinkedList<BufferedImage> bis = new LinkedList<BufferedImage>();
        List vms = this.getDisplayWindow().getViewManagers();
        if (allViewsBtn.isSelected()) {
            try {
                for (ViewManager c : vms) {
                    bis.add(c.getMaster().getImage(false));
                }
            }
            catch (Exception exception) {}
        } else if (mainDisplayBtn.isSelected()) {
            try {
                bis.add(this.getMaster().getImage(false));
            }
            catch (Exception exception) {}
        } else {
            for (Component c : views) {
                bis.add(this.makeBufferedImage(c, whichComponent));
            }
        }
        return bis;
    }

    public BufferedImage captureIslImage(Element scriptingNode) throws Exception {
        String capture = XmlUtil.getAttribute((org.w3c.dom.Node)scriptingNode, "capture", (String)null);
        if (capture == null) {
            return this.getMaster().getImage(false);
        }
        Component component = null;
        this.toFront();
        if (capture.equals("window")) {
            component = this.getDisplayWindow().getComponent();
        } else if (capture.equals("legend")) {
            component = this.getContents();
        } else {
            throw new IllegalArgumentException("Unknown image capture attribute:" + capture);
        }
        return this.makeMixedImage(component);
    }

    private BufferedImage makeMixedImage(Component component) throws Exception {
        Point baseLoc = component.getLocationOnScreen();
        Image mainImage = ImageUtils.getImage(component);
        Graphics graphics = mainImage.getGraphics();
        List viewManagers = this.getDisplayWindow().getViewManagers();
        ArrayList heavyWeightComponents = new ArrayList();
        for (ViewManager vm : viewManagers) {
            Component comp = vm.getMaster().getComponent();
            Dimension dim = comp.getSize();
            Point loc = comp.getLocationOnScreen();
            BufferedImage image = vm.getMaster().getImage(false);
            graphics.drawImage(image, loc.x - baseLoc.x, loc.y - baseLoc.y, null);
        }
        return ImageUtils.toBufferedImage(mainImage);
    }

    public BufferedImage makeBufferedImage(Component comp, String whichComponent) throws AWTException {
        Dimension dim = comp.getSize();
        Point loc = comp.getLocationOnScreen();
        GraphicsConfiguration gc = comp.getGraphicsConfiguration();
        Robot robot = new Robot(gc.getDevice());
        if (gc.getBounds().x > 0 || gc.getBounds().y > 0) {
            System.err.println("Offsetting location:" + loc + " by gc bounds: " + gc.getBounds().x + " " + gc.getBounds().y);
            loc.x -= gc.getBounds().x;
            loc.y -= gc.getBounds().y;
            System.err.println("new location:" + loc);
        }
        if (dim.width <= 0 || dim.height <= 0) {
            throw new IllegalStateException("Bad component size:" + dim.width + " X " + dim.height + " for component:" + whichComponent);
        }
        this.toFront();
        Misc.sleep(250L);
        BufferedImage image = null;
        try {
            image = robot.createScreenCapture(new Rectangle(loc.x, loc.y, dim.width, dim.height));
        }
        catch (Exception exc) {
            this.logException("Error capturing image for component:" + whichComponent + " location:" + loc.x + "x" + loc.y + " dimension:" + dim.width + "x" + dim.height, exc);
        }
        return image;
    }

    protected boolean checkForKmlImageCapture() {
        return false;
    }

    public int paintDisplayList(Graphics2D graphics, List<DisplayControl> displayControls, int width, int height, boolean bottom, Color color, Font font) throws VisADException, RemoteException {
        int offsetY;
        int startY;
        if (displayControls == null) {
            displayControls = this.getControls();
        }
        int cnt = 0;
        Font f = font != null ? font : this.getDisplayListFont();
        graphics.setFont(f);
        FontMetrics fm = graphics.getFontMetrics();
        int lineHeight = fm.getAscent() + fm.getDescent();
        int totalHeight = 0;
        if (bottom) {
            startY = height - 4;
            offsetY = -(lineHeight + 1);
            totalHeight = 4;
        } else {
            startY = 2 + lineHeight;
            offsetY = lineHeight + 1;
            totalHeight = lineHeight;
        }
        for (DisplayControl control : displayControls) {
            Color c;
            FieldImpl fi;
            Data rangeValue;
            Real now;
            Animation anime;
            Data data;
            if (!control.getShowInDisplayList() || (data = control.getDataForDisplayList()) == null) continue;
            String text = null;
            if (data instanceof Text) {
                text = ((Text)data).getValue();
            } else if (data instanceof FieldImpl && (anime = this.getAnimation()) != null && (now = anime.getCurrentAnimationValue()) != null && (rangeValue = (fi = (FieldImpl)data).evaluate(now, 100, 202)) != null && rangeValue instanceof Text) {
                text = ((Text)rangeValue).getValue();
            }
            if (text == null || text.length() == 0) continue;
            Color color2 = c = color != null ? color : this.getDisplayListColor();
            if (c == null) {
                c = ((DisplayControlImpl)control).getDisplayListColor();
            }
            graphics.setColor(c);
            int lineWidth = fm.stringWidth(text);
            graphics.drawString(text, width / 2 - lineWidth / 2, startY + offsetY * cnt);
            totalHeight += Math.abs(offsetY);
            ++cnt;
        }
        return totalHeight;
    }

    public void doPublishImage() {
        this.doPublishImage(null);
    }

    public void doPublishImage(final String props) {
        SecurityManager backup = System.getSecurityManager();
        System.setSecurityManager(null);
        try {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    String uid = Misc.getUniqueId();
                    String tail = uid + ".png";
                    String file = IOUtil.joinDir(ViewManager.this.getStore().getUserTmpDirectory(), tail);
                    ViewManager.this.writeImage(file, true);
                    ViewManager.this.getPublishManager().doPublish("Publish JPEG file", file, props);
                }
            });
        }
        catch (Exception exp) {
            this.logException("doSaveImage", exp);
        }
        System.setSecurityManager(backup);
    }

    public void logException(String msg, Throwable exc) {
        LogUtil.printException(log_, msg, exc);
    }

    public JMenu makeColorMenu() {
        return GuiUtils.makeDynamicMenu("Color", this, "initColorMenu");
    }

    public void initColorMenu(JMenu colorMenu) {
        colorMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Set Colors...", this, "showColorPairDialog"), "/auxdata/ui/icons/color_swatch.png"));
        JMenu deleteMenu = new JMenu("Delete");
        colorMenu.add(deleteMenu);
        colorMenu.addSeparator();
        boolean addedToDelete = false;
        XmlResourceCollection colors = this.getResourceManager().getXmlResources(IdvResourceManager.RSC_COLORPAIRS);
        boolean didone = false;
        for (int colorResourceIdx = 0; colorResourceIdx < colors.size(); ++colorResourceIdx) {
            Element root = colors.getRoot(colorResourceIdx, false);
            if (root == null) continue;
            List nodes = XmlUtil.findChildren(root, TAG_COLORPAIR);
            for (int colorIdx = 0; colorIdx < nodes.size(); ++colorIdx) {
                Element node = (Element)nodes.get(colorIdx);
                final Color fg = XmlUtil.getAttribute((org.w3c.dom.Node)node, "foreground", Color.black);
                final Color bg = XmlUtil.getAttribute((org.w3c.dom.Node)node, "background", Color.white);
                String label = XmlUtil.getAttribute(node, "label");
                JMenuItem mi = new JMenuItem(GuiUtils.getLocalName(label, colorResourceIdx == 0));
                try {
                    JLabel lbl = new JLabel("  T  ");
                    lbl.setSize(new Dimension(30, 20));
                    lbl.setForeground(fg);
                    lbl.setBackground(bg);
                    lbl.setOpaque(true);
                    Image image = ImageUtils.getImage(lbl);
                    mi.setIcon(new ImageIcon(image));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                colorMenu.add(mi);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ViewManager.this.setColors(fg, bg);
                    }
                });
                if (colorResourceIdx != 0) continue;
                addedToDelete = true;
                deleteMenu.add(GuiUtils.makeMenuItem(label, this, "removeColorPair", label));
            }
        }
        if (!addedToDelete) {
            deleteMenu.setEnabled(false);
            deleteMenu.setToolTipText("No user defined colors");
        }
        Msg.translateTree(colorMenu);
    }

    public void removeColorPair(String name) {
        XmlResourceCollection colors = this.getResourceManager().getXmlResources(IdvResourceManager.RSC_COLORPAIRS);
        Element root = colors.getWritableRoot("<colorpairs></colorpairs>");
        Element colorNode = XmlUtil.findElement(root, TAG_COLORPAIR, "label", name);
        try {
            if (colorNode != null) {
                root.removeChild(colorNode);
                colors.writeWritable();
            }
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "writing chooser xml", exc);
        }
    }

    public void showColorPairDialog() {
        final JDialog dialog = new JDialog((Frame)null, "Background/Foreground Color", true);
        JLabel bgLbl = GuiUtils.rLabel("Background:");
        JLabel fgLbl = GuiUtils.rLabel("Foreground:");
        final JComponent[] bgComps = GuiUtils.makeColorSwatchWidget(this.getBackground(), "Set Background Color");
        final JComponent[] fgComps = GuiUtils.makeColorSwatchWidget(this.getForeground(), "Set Foreground Color");
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel top = GuiUtils.doLayout(new Component[]{bgLbl, bgComps[0], bgComps[1], fgLbl, fgComps[0], fgComps[1]}, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_SAVEAS)) {
                    ViewManager.this.saveColors(fgComps[0].getBackground(), bgComps[0].getBackground());
                    return;
                }
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
                    ViewManager.this.setColors(fgComps[0].getBackground(), bgComps[0].getBackground());
                }
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                    dialog.dispose();
                }
            }
        };
        JPanel contents = GuiUtils.vbox((Component)top, GuiUtils.makeButtons(listener, new String[]{GuiUtils.CMD_SAVEAS, GuiUtils.CMD_APPLY, GuiUtils.CMD_OK, GuiUtils.CMD_CANCEL}));
        dialog.getContentPane().add(GuiUtils.inset((Component)contents, 5));
        dialog.pack();
        dialog.setLocation(GuiUtils.getLocation(null));
        dialog.setVisible(true);
    }

    private void saveColors(Color fg, Color bg) {
        Element colorPair;
        String name = "";
        XmlResourceCollection colors = this.getResourceManager().getXmlResources(IdvResourceManager.RSC_COLORPAIRS);
        Document colorDoc = colors.getWritableDocument("<colorpairs></colorpairs>");
        Element root = colors.getWritableRoot("<colorpairs></colorpairs>");
        while (true) {
            if ((name = GuiUtils.getInput("Please provide a name to save the colors as", "Color name: ", name)) == null) {
                return;
            }
            if ((name = name.trim()).length() == 0) {
                LogUtil.userMessage("Please enter a name for the new color pair");
                continue;
            }
            List nodes = XmlUtil.findChildren(root, TAG_COLORPAIR);
            boolean nameOk = true;
            colorPair = null;
            for (int colorIdx = 0; colorIdx < nodes.size(); ++colorIdx) {
                Element node = (Element)nodes.get(colorIdx);
                if (!XmlUtil.getAttribute((org.w3c.dom.Node)node, "label", "").equals(name)) continue;
                int result = GuiUtils.showYesNoCancelDialog(GuiUtils.getFrame(this.fullContents), "A color pair with the name: " + name + " already exists." + "Do you want to overwrite it?", "Color name exists");
                if (result == 2) {
                    return;
                }
                if (result == 1) {
                    nameOk = false;
                }
                colorPair = node;
                break;
            }
            if (nameOk) break;
        }
        if (colorPair == null) {
            colorPair = colorDoc.createElement(TAG_COLORPAIR);
        }
        colorPair.setAttribute("label", name);
        XmlUtil.setAttribute(colorPair, "foreground", fg);
        XmlUtil.setAttribute(colorPair, "background", bg);
        root.appendChild(colorPair);
        try {
            colors.writeWritable();
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "writing chooser xml", exc);
        }
    }

    public Color getForeground() {
        if (this.foreground == null) {
            this.foreground = this.getDefaultForeground();
        }
        return this.foreground;
    }

    protected Color getDefaultForeground() {
        return this.getStore().get(PREF_FGCOLOR, Color.white);
    }

    protected Color getDefaultBackground() {
        return this.getStore().get(PREF_BGCOLOR, Color.black);
    }

    public void setForeground(Color c) {
        this.foreground = c;
    }

    public Color getBackground() {
        if (this.background == null) {
            this.background = this.getDefaultBackground();
        }
        return this.background;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public void setSideLegend(SideLegend value) {
        this.sideLegend = value;
        if (this.sideLegend != null) {
            this.sideLegend.setViewManager(this);
        }
    }

    public SideLegend getSideLegend() {
        return this.sideLegend;
    }

    public boolean getToolbarsFloatable() {
        String prop = this.getSkinProperty(PREF_TOOLBARSFLOATABLE);
        if (prop == null) {
            return false;
        }
        return new Boolean(prop);
    }

    public void setShowToolBars(boolean v) {
        this.showToolbars = v;
    }

    public void setLastActive(boolean b) {
        IdvUIManager idvUIManager;
        if (!this.getIsShared()) {
            return;
        }
        this.lastActive = b;
        if (this.lastActive) {
            this.lastTimeActivated = System.currentTimeMillis();
        }
        VMManager vmManager = this.getVMManager();
        JComponent contents = this.innerContents;
        if (contents != null && vmManager != null) {
            boolean haveMany = vmManager.haveMoreThanOneMainViewManager();
            if (this.getIsShared()) {
                if (haveMany && b) {
                    contents.setBorder(ViewManager.getHighlightBorder());
                } else {
                    contents.setBorder(ViewManager.getNormalBorder());
                }
            }
        }
        if ((idvUIManager = this.getIdvUIManager()) != null) {
            idvUIManager.viewManagerActiveChanged(this);
        }
    }

    public static Border getNormalBorder() {
        if (normalBorder == null) {
            int bw = 3;
            Border outer = BorderFactory.createEmptyBorder(bw, bw, bw, bw);
            normalBorder = BorderFactory.createCompoundBorder(outer, lineBorder);
        }
        return normalBorder;
    }

    public static Border getHighlightBorder() {
        if (highlightBorder == null) {
            int bw = 3;
            MatteBorder outer = new MatteBorder(new Insets(bw, bw, bw, bw), borderHighlightColor);
            highlightBorder = BorderFactory.createCompoundBorder(outer, lineBorder);
        }
        return highlightBorder;
    }

    public static void setHighlightBorder(Color c) {
        borderHighlightColor = c;
        highlightBorder = null;
    }

    public boolean showHighlight() {
        boolean haveMany = this.getVMManager().haveMoreThanOneMainViewManager();
        return haveMany && this.lastActive;
    }

    public long getLastTimeActivated() {
        return this.lastTimeActivated;
    }

    public void setDisplayBounds(Rectangle value) {
        this.displayBounds = value;
    }

    public Rectangle getDisplayBounds() {
        if (this.master != null) {
            return this.master.getScreenBounds();
        }
        return this.displayBounds;
    }

    protected boolean isFullScreen() {
        return this.fullScreenWindow != null;
    }

    public void toggleFullScreen() {
        if (this.isFullScreen()) {
            this.resetFullScreen();
        } else {
            this.setFullScreen();
        }
    }

    public void resetFullScreen() {
        if (this.fullScreenWindow == null || this.innerContents == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JComponent navComponent = ViewManager.this.getComponent();
                ViewManager.this.innerContents.add("Center", navComponent);
                ViewManager.this.fullScreenWindow.setVisible(false);
                ViewManager.this.fullScreenWindow.dispose();
                ViewManager.this.fullScreenWindow = null;
                AnimationWidget animationWidget = ViewManager.this.getAnimationWidget();
                if (animationWidget != null && ViewManager.this.animationHolder != null) {
                    ViewManager.this.animationHolder.add(animationWidget.getContents());
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setFullScreen() {
        Dimension fixedSize = null;
        if (this.fullScreenWidth > 0 && this.fullScreenHeight > 0) {
            fixedSize = new Dimension(this.fullScreenWidth, this.fullScreenHeight);
        }
        if (this.innerContents == null) {
            return;
        }
        if (this.fullScreenWindow != null) {
            this.resetFullScreen();
            return;
        }
        JComponent navComponent = this.getComponent();
        this.innerContents.remove(navComponent);
        Dimension theSize = fixedSize;
        if (theSize == null) {
            theSize = Toolkit.getDefaultToolkit().getScreenSize();
            theSize.height -= 50;
        }
        navComponent.setMinimumSize(theSize);
        navComponent.setPreferredSize(theSize);
        AnimationWidget animationWidget = this.getAnimationWidget();
        JComponent rightPanel = (JComponent)GuiUtils.filler();
        if (animationWidget != null) {
            rightPanel = animationWidget.getContents();
        }
        JComponent menuBar = this.doMakeMenuBar();
        JButton cancelBtn1 = GuiUtils.makeImageButton("/auxdata/ui/icons/cancel.gif", this, "resetFullScreen");
        JButton cancelBtn2 = GuiUtils.makeImageButton("/auxdata/ui/icons/cancel.gif", this, "resetFullScreen");
        if (theSize.width < 300) {
            rightPanel = new JPanel();
            menuBar = new JPanel();
        }
        JPanel top = GuiUtils.leftRight(GuiUtils.hbox((Component)GuiUtils.bottom(cancelBtn1), menuBar), rightPanel);
        JPanel bottom = GuiUtils.left(GuiUtils.hbox(cancelBtn2, new JLabel(" ")));
        JPanel contents = GuiUtils.topCenterBottom(top, navComponent, bottom);
        this.fullScreenWindow = new JFrame();
        if (fixedSize == null) {
            this.fullScreenWindow.setUndecorated(true);
        }
        this.fullScreenWindow.getContentPane().add(contents);
        if (fixedSize == null) {
            this.fullScreenWindow.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
        this.fullScreenWindow.pack();
        int yOffset = 0;
        if (GuiUtils.isMac()) {
            yOffset = 23;
        }
        if (fixedSize == null) {
            this.fullScreenWindow.setLocation(0, 0 + yOffset);
        } else {
            this.fullScreenWindow.setLocation(20, 20 + yOffset);
        }
        this.fullScreenWindow.setVisible(true);
        navComponent.requestFocus();
    }

    public void setClickToFocus(boolean value) {
        this.clickToFocus = value;
    }

    public boolean getClickToFocus() {
        return this.clickToFocus;
    }

    public void setAliases(List value) {
        this.aliases = value;
        if (this.aliases != null && this.aliases.size() > 0) {
            this.aliases = Misc.newList(this.aliases.get(0));
        }
    }

    public List getAliases() {
        if (this.aliases.size() > 0) {
            return Misc.newList(this.aliases.get(0));
        }
        return this.aliases;
    }

    public void setDisplayMatrix(double[] newMatrix) throws VisADException, RemoteException {
        this.initMatrix = newMatrix;
        if (newMatrix == null || !this.hasDisplayMaster()) {
            return;
        }
        double[] displayMatrix = this.getProjectionControl().getMatrix();
        if (displayMatrix.length != newMatrix.length) {
            this.initMatrix = ProjectionControl.matrixDConvert(newMatrix);
        }
        if (this.getIdv().getArgsManager().getIsOffScreen()) {
            // empty if block
        }
        this.getMaster().setProjectionMatrix(this.initMatrix);
    }

    public double[] getDisplayMatrix() {
        if (this.getProjectionControl() == null) {
            return this.initMatrix;
        }
        return this.getProjectionControl().getMatrix();
    }

    public double[] getDisplayInitMatrix() {
        return this.initMatrix;
    }

    public void setAnimationStringVisible(boolean visible) {
        this.setAniReadout(visible);
    }

    public boolean getAnimationStringVisible() {
        return this.getAniReadout();
    }

    public void setTopBarVisible(boolean visible) {
        this.setBp(PREF_TOPBAR_VISIBLE, visible);
    }

    public boolean getTopBarVisible() {
        return this.getBp(PREF_TOPBAR_VISIBLE);
    }

    public void setAniReadout(boolean value) {
        this.setBp(PREF_ANIREADOUT, value);
    }

    public boolean getAniReadout() {
        return this.getBp(PREF_ANIREADOUT);
    }

    public void setName(String value) {
        this.name = value;
        this.updateNameLabel();
    }

    protected void updateNameLabel() {
        if (this.nameLabel == null) {
            return;
        }
        if (this.name != null) {
            this.nameLabel.setText(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setAspectRatio(double[] value) {
        this.aspectRatio = value;
    }

    public void printAspect(String msg) {
        if (this.aspectRatio == null) {
            System.err.println(this.xmycnt + " " + msg + " aspect is null");
        } else {
            System.err.println(this.xmycnt + " " + msg + " aspect: " + this.aspectRatio[0] + " " + this.aspectRatio[1] + " " + this.aspectRatio[2]);
        }
    }

    public double[] getAspectRatio() {
        return this.aspectRatio;
    }

    public void setSkinProperties(Hashtable value) {
        this.skinProperties = value;
    }

    public Hashtable getSkinProperties() {
        return this.skinProperties;
    }

    public String getSkinProperty(String name) {
        String prop = null;
        if (this.skinProperties != null) {
            prop = (String)this.skinProperties.get(name);
        }
        if (prop == null) {
            prop = (String)this.getStateManager().getProperty(name);
        }
        return prop;
    }

    public void setLegendOnLeft(boolean value) {
        this.legendOnLeft = value;
    }

    public boolean getLegendOnLeft() {
        return this.legendOnLeft;
    }

    public void setIsShared(boolean value) {
        this.isShared = value;
    }

    public boolean getIsShared() {
        return this.isShared;
    }

    public void setDisplayListFont(Font value) {
        this.displayListFont = value;
    }

    public Font getDisplayListFont() {
        if (this.displayListFont == null) {
            this.displayListFont = this.getStore().get(PREF_DISPLAYLISTFONT, defaultFont);
        }
        return this.displayListFont;
    }

    public void setDisplayListColor(Color value) {
        this.displayListColor = value;
    }

    public Color getDisplayListColor() {
        if (this.displayListColor == null) {
            this.displayListColor = this.getStore().get(PREF_DISPLAYLISTCOLOR, (Color)null);
        }
        return this.displayListColor;
    }

    public void setFullScreenWidth(int value) {
        this.fullScreenWidth = value;
    }

    public int getFullScreenWidth() {
        return this.fullScreenWidth;
    }

    public void setFullScreenHeight(int value) {
        this.fullScreenHeight = value;
    }

    public int getFullScreenHeight() {
        return this.fullScreenHeight;
    }

    public void setProperties(Hashtable value) {
        this.properties = value;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public void putProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public CoordinateSystem getDisplayCoordinateSystem() {
        return null;
    }

    public void setLights(List<LightInfo> value) {
        this.lights = value;
    }

    public List<LightInfo> getLights() {
        return this.lights;
    }

    public void setSplitPaneLocation(int value) {
        this.splitPaneLocation = value;
    }

    public int getSplitPaneLocation() {
        JSplitPane tmp = this.mainSplitPane;
        if (tmp != null) {
            return tmp.getDividerLocation();
        }
        return -1;
    }

    public void initViewState(ViewState viewState) {
        viewState.put(ViewState.PROP_MATRIX, this.getDisplayMatrix());
    }

    public ViewState doMakeViewState() {
        ViewState viewState = new ViewState(this.getClass().getName());
        this.initViewState(viewState);
        return viewState;
    }

    public void setInitViewStateName(String s) {
        this.initViewStateName = s;
    }

    public String getInitViewStateName() {
        return this.initViewStateName;
    }

    protected String getLogoFile() {
        if (this.logoFile == null) {
            this.logoFile = this.getIdv().getStateManager().getPreferenceOrProperty(PREF_LOGO, "");
        }
        return this.logoFile;
    }

    public void setLogoFile(String logo) {
        this.logoFile = logo;
    }

    public String getLogoPosition() {
        if (this.logoPosition == null) {
            this.logoPosition = this.getIdv().getStateManager().getPreferenceOrProperty(PREF_LOGO_POSITION_OFFSET, "");
        }
        return this.logoPosition;
    }

    public void setLogoPosition(String logop) {
        this.logoPosition = logop;
    }

    public float getLogoScale() {
        if (this.logoScale < 0.0f) {
            this.logoScale = (float)this.getIdv().getStateManager().getPreferenceOrProperty(PREF_LOGO_SCALE, 1.0);
        }
        return this.logoScale;
    }

    public void setLogoScale(float scale) {
        this.logoScale = scale;
    }

    public void setLogoVisibility(boolean on) {
        this.setBp(PREF_LOGO_VISIBILITY, on);
    }

    public boolean getLogoVisibility() {
        return this.getBp(PREF_LOGO_VISIBILITY);
    }

    public void ensureOnlyOneTimeDriver(DisplayControl displayControl) {
        if (this.getAnimationInfo() != null && this.getAnimationInfo().getAnimationSetInfo() != null && this.getAnimationInfo().getAnimationSetInfo().getActive()) {
            AnimationInfo ai = this.getAnimationWidget().getAnimationInfo();
            ai.getAnimationSetInfo().setIsTimeDriver(false);
            this.getAnimationWidget().setProperties(ai);
        }
        for (DisplayControl control : this.getControls()) {
            if (control.equals(displayControl) || !control.getIsTimeDriver()) continue;
            ((DisplayControlImpl)control).setIsTimeDriver(false);
            ((DisplayControlImpl)control).setUsesTimeDriver(true);
        }
    }

    public void setProjectionFromData(boolean value) {
    }

    static /* synthetic */ DateTime[] access$1402(ViewManager x0, DateTime[] x1) {
        x0.timesArray = x1;
        return x1;
    }

    private class MyTimeline
    extends Timeline {
        Real animationValue;
        DisplayControl control;
        JLabel label;
        JLabel rightComp;
        Set timeSet;

        public MyTimeline(List dates, int w, int h) {
            super(dates, w, h);
            this.setIsCapableOfSelection(false);
        }

        public MyTimeline(Set timeSet, List dates, int w, DisplayControl control) {
            super(dates, w);
            this.timeSet = timeSet;
            this.control = control;
            this.label = control.makeLegendLabel();
            this.rightComp = ViewManager.this.idv.getUseTimeDriver() ? GuiUtils.rLabel(control.getIsTimeDriver() ? "Time Driver" : "") : GuiUtils.rLabel("");
            this.setIsCapableOfSelection(false);
        }

        public List getSunriseLocations() {
            return ViewManager.this.getIdv().getIdvUIManager().getMapLocations();
        }

        @Override
        public Color getColorTimeUnselected() {
            return Color.black;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                super.mouseClicked(e);
                return;
            }
            ViewManager.this.setAnimationTime(this.toDate(e.getX()));
        }

        public void update(Real value) throws VisADException, RemoteException {
            if (this.control != null) {
                this.timeSet = this.control.getTimeSet();
                if (this.timeSet != null) {
                    DateTime[] times = Animation.getDateTimeArray(this.timeSet);
                    this.setDatedThings(DatedObject.wrap(Util.makeDates(times)));
                }
            }
            this.setAnimationValue(value);
        }

        public void setAnimationValue(Real value) throws VisADException, RemoteException {
            this.animationValue = value;
            if (this.timeSet != null && value != null) {
                int index = Util.findIndex(this.timeSet, value);
                List datedThings = this.getDatedThings();
                if (index >= 0 && index < datedThings.size()) {
                    this.setSelected(Misc.newList(datedThings.get(index)));
                    return;
                }
                if (this.getSelected().size() > 0) {
                    this.setSelected(new ArrayList());
                }
            }
            this.repaint();
        }

        @Override
        public void paintBackgroundDecoration(Graphics2D g) {
            super.paintBackgroundDecoration(g);
            Dimension d = this.getSize();
            if (this.control != null && !this.control.getDisplayVisibility()) {
                g.setColor(Color.lightGray);
                g.fillRect(0, 0, d.width, d.height);
            }
            if (this.animationValue instanceof DateTime) {
                try {
                    Date date = Util.makeDate((DateTime)this.animationValue);
                    int x = this.toLocation(date);
                    g.setColor(Color.gray);
                    g.fillRect(x - 1, 0, 2, d.height);
                }
                catch (Exception exp) {
                    ViewManager.this.logException("Painting timeline", exp);
                }
            }
        }
    }

    public static class MatrixCommand
    extends Command {
        double[] newMatrix;
        double[] oldMatrix;
        ViewManager viewManager;

        public MatrixCommand(ViewManager viewManager, double[] oldMatrix, double[] newMatrix) {
            this.viewManager = viewManager;
            this.oldMatrix = oldMatrix;
            this.newMatrix = newMatrix;
        }

        @Override
        public void redoCommand() {
            try {
                this.viewManager.getMaster().setProjectionMatrix(this.newMatrix);
            }
            catch (Exception exp) {
                this.viewManager.logException("setProjectionMatrix", exp);
            }
        }

        @Override
        public void undoCommand() {
            try {
                this.viewManager.getMaster().setProjectionMatrix(this.oldMatrix);
            }
            catch (Exception exp) {
                this.viewManager.logException("setProjectionMatrix", exp);
            }
        }
    }

    private static class IdvKeyboardBehavior
    implements KeyboardBehavior,
    Removable {
        ViewManager viewManager;

        public IdvKeyboardBehavior(ViewManager viewManager) {
            this.viewManager = viewManager;
        }

        @Override
        public void doRemove() {
            this.viewManager = null;
        }

        @Override
        public void mapKeyToFunction(int function, int keycode, int modifiers) {
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            this.viewManager.keyWasTyped(keyEvent);
        }

        @Override
        public void execFunction(int function) {
        }
    }
}

