/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Color;
import java.awt.Dimension;
import java.rmi.RemoteException;
import ucar.visad.display.XSDisplay;
import ucar.visad.quantities.Length;
import visad.AxisScale;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public class VerticalXSDisplay
extends XSDisplay {
    public static final String CURSOR_ALTITUDE = "cursorAltitude";
    private volatile Real cursorAltitude;

    public VerticalXSDisplay() throws VisADException, RemoteException {
        this(false, null);
    }

    public VerticalXSDisplay(boolean offScreen, Dimension dimension) throws VisADException, RemoteException {
        super("Vertical Cross Section", Length.getRealType(), RealType.Altitude, offScreen, dimension);
        this.setAxisParams();
    }

    private void setAxisParams() {
        AxisScale zscale;
        this.showAxisScales(true);
        AxisScale xscale = this.getXAxisScale();
        if (xscale != null) {
            this.setXAxisTitle();
            xscale.setSnapToBox(true);
            xscale.setColor(Color.blue);
            xscale.setAutoComputeTicks(true);
        }
        if ((zscale = this.getYAxisScale()) != null) {
            Unit unit;
            zscale.setSnapToBox(true);
            zscale.setColor(Color.blue);
            zscale.setAutoComputeTicks(true);
            RealType yAxisType = this.getYAxisType();
            if (yAxisType != null && (unit = yAxisType.getDefaultUnit()) != null) {
                zscale.setTitle(yAxisType.toString() + " (" + unit + ")");
            }
        }
    }

    protected void setCursorAltitude(Real altitude) throws VisADException, RemoteException {
        Real oldAltitude = this.cursorAltitude;
        this.cursorAltitude = altitude;
        this.firePropertyChange(CURSOR_ALTITUDE, oldAltitude, this.cursorAltitude);
    }

    public Real getCursorAltitude() {
        return this.cursorAltitude;
    }

    @Override
    public void setXDisplayUnit(Unit newUnit) {
        super.setXDisplayUnit(newUnit);
        this.setXAxisTitle();
    }

    @Override
    public void setYDisplayUnit(Unit newUnit) {
        super.setYDisplayUnit(newUnit);
        this.setYAxisTitle();
    }

    public void setXAxisTitle() {
        AxisScale xscale = this.getXAxisScale();
        if (xscale != null) {
            xscale.setTitle("Distance along transect (" + this.getXDisplayUnit() + ")");
        }
    }

    public void setYAxisTitle() {
        AxisScale yscale = this.getYAxisScale();
        if (yscale != null) {
            RealType yAxisType = this.getYAxisType();
            yscale.setTitle(yAxisType.toString() + " (" + this.getYDisplayUnit() + ")");
        }
    }
}

