/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.visad.Plotter;
import visad.DisplayImpl;
import visad.Real;
import visad.bom.SceneGraphRenderer;

public class VectorGraphicsRenderer
implements Plotter.Plottable {
    private int labelWidth = 200;
    private boolean ok = true;
    private String labelPos = "LR";
    private Color labelBG = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private boolean preview = false;
    private boolean doingPreview = false;
    private Dimension fullDim;
    private final BufferedImage images;
    private String labelHtml;

    public VectorGraphicsRenderer(ViewManager viewManager) {
        this(new ArrayList<ViewManager>(Arrays.asList(viewManager)), 1);
    }

    public VectorGraphicsRenderer(List<? extends ViewManager> viewManagers, int columns) {
        ArrayList<BufferedImage> l = new ArrayList<BufferedImage>();
        for (ViewManager viewManager : viewManagers) {
            l.add(this.makeImage(viewManager));
        }
        this.images = (BufferedImage)ImageUtils.gridImages2(l, 0, Color.GRAY, columns);
        this.fullDim = new Dimension(this.images.getWidth(), this.images.getHeight());
    }

    public void renderTo(String filename) throws Exception {
        Plotter plotter = new Plotter(filename);
        if (this.preview) {
            this.doingPreview = true;
            this.ok = true;
            plotter.plot(this);
            if (!this.ok) {
                return;
            }
        }
        this.doingPreview = false;
        plotter.plot(this);
    }

    public boolean showConfigDialog() {
        GuiUtils.ColorSwatch labelBGFld = new GuiUtils.ColorSwatch(this.labelBG, "Label Color", true);
        JTextField widthFld = new JTextField("" + this.labelWidth, 5);
        JTextArea ta = new JTextArea(this.labelHtml, 5, 50);
        ta.setToolTipText("<html>Can be HTML<br>Use '%time%' to include current animation time</html>");
        Vector positions = new Vector(Misc.toList(new Object[]{new TwoFacedObject((Object)"Upper Left", "UL"), new TwoFacedObject((Object)"Upper Right", "UR"), new TwoFacedObject((Object)"Lower Left", "LL"), new TwoFacedObject((Object)"Lower Right", "LR")}));
        JComboBox posBox = new JComboBox(positions);
        posBox.setSelectedItem(TwoFacedObject.findId(this.labelPos, positions));
        JCheckBox previewCbx = new JCheckBox("", this.preview);
        JPanel labelComp = GuiUtils.hbox(new Component[]{new JLabel("Position:"), posBox, new JLabel("Width:"), widthFld, GuiUtils.rLabel("Background:"), labelBGFld.getPanel()}, 5);
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel comp = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Preview:"), GuiUtils.left(previewCbx), GuiUtils.rLabel("Label:"), GuiUtils.left(labelComp), GuiUtils.rLabel(""), GuiUtils.makeScrollPane(ta, 200, 100)}, 2, GuiUtils.WT_NY, GuiUtils.WT_NY);
        comp = GuiUtils.topCenter(GuiUtils.inset((Component)new JLabel("Note: The display needs to be in an overhead view"), 5), comp);
        if (GuiUtils.showOkCancelDialog(null, "Legend Label", comp, null)) {
            this.labelHtml = ta.getText();
            this.labelPos = TwoFacedObject.getIdString(posBox.getSelectedItem());
            this.labelWidth = new Integer(widthFld.getText().trim());
            this.labelBG = labelBGFld.getSwatchColor();
            this.preview = previewCbx.isSelected();
            return true;
        }
        return false;
    }

    @Override
    public void plot(Graphics2D graphics) {
        if (this.doingPreview) {
            JPanel previewContents = GuiUtils.centerBottom(new JLabel(new ImageIcon(this.images)), GuiUtils.inset((Component)new JLabel("Note: The actual capture will take place after the preview window is dismissed so make sure the window is not occluded"), 5));
            this.ok = GuiUtils.showOkCancelDialog(null, "", previewContents, null);
        } else {
            graphics.drawImage((Image)this.images, 0, 0, null);
            graphics.setClip(0, 0, this.images.getWidth(), this.images.getHeight());
        }
    }

    private BufferedImage makeImage(ViewManager viewManager) {
        Dimension dim = new Dimension(viewManager.getComponent().getWidth(), viewManager.getComponent().getHeight());
        if (dim.height == 0 || dim.width == 0) {
            Dimension dimd;
            dim = dimd = viewManager.getIdv().getStateManager().getViewSize();
        }
        BufferedImage bimage = new BufferedImage(dim.width, dim.height, 2);
        Graphics2D graphics = (Graphics2D)bimage.getGraphics();
        try {
            boolean wasShowingScales;
            boolean wasShowingWireframe;
            boolean wasShowingDisplayList = viewManager.getShowDisplayList();
            if (wasShowingDisplayList) {
                viewManager.setShowDisplayList(false);
            }
            if (wasShowingWireframe = viewManager.getWireframe()) {
                viewManager.setWireframe(false);
            }
            if (wasShowingScales = viewManager.getShowScales()) {
                viewManager.setShowScales(false);
            }
            ArrayList<DisplayControl> onDisplays = new ArrayList<DisplayControl>();
            for (DisplayControl displayControl : viewManager.getControls()) {
                if (!displayControl.getDisplayVisibility()) continue;
                onDisplays.add(displayControl);
            }
            for (DisplayControl displayControl : onDisplays) {
                displayControl.toggleVisibilityForVectorGraphicsRendering(0);
            }
            viewManager.toFront();
            Misc.sleep(1000L);
            BufferedImage image = viewManager.getMaster().getImage(false);
            graphics.drawImage((Image)image, 0, 0, null);
            for (DisplayControl control : onDisplays) {
                control.toggleVisibilityForVectorGraphicsRendering(1);
            }
            if (wasShowingWireframe) {
                viewManager.setWireframe(true);
            }
            if (wasShowingScales) {
                viewManager.setShowScales(true);
            }
            Misc.sleep(500L);
            SceneGraphRenderer sceneGraphRenderer = new SceneGraphRenderer();
            DisplayImpl display = (DisplayImpl)viewManager.getMaster().getDisplay();
            boolean is3D = !viewManager.getDisplayRenderer().getMode2D();
            sceneGraphRenderer.setTransformToScreenCoords(is3D);
            sceneGraphRenderer.plot(graphics, display, viewManager.getDisplayCoordinateSystem(), dim.width, dim.height);
            for (DisplayControl control : onDisplays) {
                control.toggleVisibilityForVectorGraphicsRendering(2);
            }
            int height = dim.height;
            int width = dim.width;
            if (wasShowingDisplayList) {
                boolean cnt = false;
                Font f = viewManager.getDisplayListFont();
                graphics.setFont(f);
                FontMetrics fm = graphics.getFontMetrics();
                int lineHeight = fm.getAscent() + fm.getDescent();
                viewManager.paintDisplayList(graphics, onDisplays, width, height, true, null, null);
                viewManager.setShowDisplayList(true);
            }
            if (this.labelHtml != null && this.labelHtml.trim().length() > 0) {
                Real dttm = viewManager.getAnimation().getCurrentAnimationValue();
                String dttmString = dttm != null ? dttm.toString() : "none";
                this.labelHtml = this.labelHtml.replace("%time%", dttmString);
                JEditorPane editor = ImageUtils.getEditor(null, this.labelHtml, this.labelWidth, null, null);
                if (this.labelBG != null) {
                    editor.setBackground(this.labelBG);
                } else {
                    editor.setBackground(viewManager.getBackground());
                }
                editor.setBorder(BorderFactory.createBevelBorder(0));
                RepaintManager repaintManager = RepaintManager.currentManager(editor);
                repaintManager.setDoubleBufferingEnabled(false);
                Dimension cdim = editor.getSize();
                AffineTransform tform = graphics.getTransform();
                int dx = 0;
                int dy = 0;
                int pad = 5;
                if (this.labelPos.equals("LR")) {
                    dx = width - cdim.width - pad;
                    dy = height - cdim.height - pad;
                } else if (this.labelPos.equals("LL")) {
                    dx = pad;
                    dy = height - cdim.height - pad;
                } else if (this.labelPos.equals("UL")) {
                    dx = pad;
                    dy = pad;
                } else if (this.labelPos.equals("UR")) {
                    dx = width - cdim.width - pad;
                    dy = pad;
                }
                AffineTransform translate = AffineTransform.getTranslateInstance(dx, dy);
                tform.concatenate(translate);
                graphics.setTransform(tform);
                editor.paint(graphics);
                graphics.setTransform(tform);
                repaintManager.setDoubleBufferingEnabled(true);
            }
        }
        catch (Exception exc) {
            throw new WrapperException(exc);
        }
        return bimage;
    }

    @Override
    public Color[] getColours() {
        return new Color[]{Color.red, Color.green, Color.blue};
    }

    @Override
    public int[] getSize() {
        return new int[]{this.fullDim.width, this.fullDim.height};
    }

    public void setLabelHtml(String value) {
        this.labelHtml = value;
    }

    public String getLabelHtml() {
        return this.labelHtml;
    }

    public void setLabelPos(String value) {
        this.labelPos = value;
    }

    public String getLabelPos() {
        return this.labelPos;
    }

    public void setLabelBG(Color value) {
        this.labelBG = value;
    }

    public Color getLabelBG() {
        return this.labelBG;
    }

    public void setLabelWidth(int value) {
        this.labelWidth = value;
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public void setPreview(boolean value) {
        this.preview = value;
    }

    public boolean getPreview() {
        return this.preview;
    }
}

