/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class VariableRenamer {
    private IdvResourceManager resourceManager;
    private XmlResourceCollection varmapResourceCollection;
    private static final String TAG_VARRENAMER = "varrenamer";
    private HashMap<String, List<String>> varMaps = new HashMap();

    private void readVariableRenameResources() {
        for (int varRemapResourceIdx = 0; varRemapResourceIdx < this.varmapResourceCollection.size(); ++varRemapResourceIdx) {
            Element root = this.varmapResourceCollection.getRoot(varRemapResourceIdx, false);
            if (root == null) continue;
            List nodes = XmlUtil.findChildren(root, TAG_VARRENAMER);
            for (Object node1 : nodes) {
                List<Object> tmpList;
                Element node = (Element)node1;
                String oldVar = XmlUtil.getAttribute(node, "old");
                String newVar = XmlUtil.getAttribute(node, "new");
                if (!this.varMaps.containsKey(oldVar)) {
                    tmpList = new ArrayList<String>();
                    tmpList.add(newVar);
                    this.varMaps.put(oldVar, tmpList);
                    continue;
                }
                tmpList = this.varMaps.get(oldVar);
                tmpList.add(newVar);
                this.varMaps.put(oldVar, tmpList);
            }
        }
    }

    public List<String> renameVar(String oldName) {
        List<String> newNames = new ArrayList<String>();
        if (this.varMaps.containsKey(oldName)) {
            newNames = this.varMaps.get(oldName);
        } else {
            newNames.add(oldName);
        }
        return newNames;
    }

    private void init() {
        this.varmapResourceCollection = this.resourceManager.getXmlResources(IdvResourceManager.RSC_VARIABLERENAMER);
        this.readVariableRenameResources();
    }

    public VariableRenamer(IdvResourceManager rsm) {
        this.resourceManager = rsm;
        this.init();
    }
}

