/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import ucar.unidata.data.gis.Transect;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.TransectViewManager;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.ViewState;
import ucar.unidata.idv.control.TransectDrawingControl;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.xml.XmlResourceCollection;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.MapProjection;

public class VMManager
extends IdvManager {
    private List<ViewManager> viewManagers = new ArrayList<ViewManager>();
    private List viewpoints;
    private ViewManager lastActiveViewManager = null;

    public VMManager(IntegratedDataViewer idv) {
        super(idv);
        try {
            File oldFile = new File(IOUtil.joinDir(this.getStore().getUserDirectory(), "vmstate.xml"));
            File newFile = new File(IOUtil.joinDir(this.getStore().getUserDirectory(), "viewpoints.xml"));
            if (oldFile.exists() && !newFile.exists()) {
                IOUtil.moveFile(oldFile, newFile);
            }
        }
        catch (Exception exc) {
            VMManager.logException("moving vmstate.xml to viewpoints.xml", exc);
        }
    }

    public List<ViewManager> getViewManagers() {
        return new ArrayList<ViewManager>(this.viewManagers);
    }

    public List getViewManagers(Class c) {
        ArrayList<ViewManager> result = new ArrayList<ViewManager>();
        List<ViewManager> vms = this.getViewManagers();
        for (int i = 0; i < vms.size(); ++i) {
            ViewManager vm = vms.get(i);
            if (!c.isAssignableFrom(vm.getClass())) continue;
            result.add(vm);
        }
        return result;
    }

    public void captureAll() {
        List<ViewManager> vms = this.getViewManagers();
        String filename = FileManager.getWriteFile(FileManager.FILTER_IMAGE, ".jpg");
        if (filename == null) {
            return;
        }
        String root = IOUtil.stripExtension(filename);
        String ext = IOUtil.getFileExtension(filename);
        StringBuffer sb = new StringBuffer("<html>");
        sb.append("Since there were multiple images they were written out as:<ul>");
        for (int i = 0; i < vms.size(); ++i) {
            ViewManager vm = vms.get(i);
            String name = vm.getName();
            if (name == null || name.trim().length() == 0) {
                name = "" + (i + 1);
            }
            if (vms.size() != 1) {
                filename = root + name + ext;
            }
            sb.append("<li> " + filename);
            vm.writeImage(filename);
        }
        sb.append("</ul></html>");
        if (vms.size() > 1) {
            GuiUtils.showDialog("Captured Images", GuiUtils.inset((Component)new JLabel(sb.toString()), 5));
        }
    }

    public void applyPreferences() {
        for (int i = 0; i < this.viewManagers.size(); ++i) {
            this.viewManagers.get(i).applyPreferences();
        }
    }

    public void setLastActiveViewManager(ViewManager viewManager) {
        if (this.lastActiveViewManager != null) {
            this.lastActiveViewManager.setLastActive(false);
        }
        this.lastActiveViewManager = viewManager;
        if (this.lastActiveViewManager != null) {
            this.lastActiveViewManager.setLastActive(true);
        }
    }

    public boolean haveMoreThanOneMainViewManager() {
        int cnt = 0;
        for (int i = 0; i < this.viewManagers.size(); ++i) {
            if (this.viewManagers.get(i) instanceof MapViewManager || this.viewManagers.get(i) instanceof TransectViewManager) {
                ++cnt;
            }
            if (cnt <= 1) continue;
            return true;
        }
        return false;
    }

    public ViewManager getLastActiveViewManager() {
        if (this.lastActiveViewManager == null) {
            List windows = IdvWindow.getMainWindows();
            for (int i = 0; i < windows.size(); ++i) {
                IdvWindow window = (IdvWindow)windows.get(i);
                this.getIdvUIManager().handleWindowActivated(window);
                if (this.lastActiveViewManager != null) break;
            }
        }
        return this.lastActiveViewManager;
    }

    public ViewManager findViewManager(ViewDescriptor viewDescriptor) {
        ViewManager viewManager = null;
        if (viewDescriptor == null) {
            viewDescriptor = new ViewDescriptor(ViewDescriptor.LASTACTIVE);
        }
        if (viewDescriptor.nameEquals(ViewDescriptor.LASTACTIVE)) {
            viewManager = this.getLastActiveViewManager();
            if (viewManager != null && viewManager.isClassOk(viewDescriptor)) {
                return viewManager;
            }
            ArrayList<ViewManager> local = new ArrayList<ViewManager>(this.viewManagers);
            for (int i = 0; i < local.size(); ++i) {
                ViewManager vm = (ViewManager)local.get(i);
                if (!vm.isClassOk(viewDescriptor)) continue;
                return vm;
            }
        }
        return this.findViewManagerInList(viewDescriptor);
    }

    private ViewManager findViewManagerInList(ViewDescriptor viewDescriptor) {
        return VMManager.findViewManagerInList(viewDescriptor, new ArrayList<ViewManager>(this.viewManagers));
    }

    public static ViewManager findViewManagerInList(ViewDescriptor viewDescriptor, List vms) {
        for (int i = 0; i < vms.size(); ++i) {
            ViewManager vm = (ViewManager)vms.get(i);
            if (!vm.isDefinedBy(viewDescriptor)) continue;
            return vm;
        }
        return null;
    }

    public void transectViewsChanged() {
        List controls = this.findTransectDrawingControls();
        for (int i = 0; i < controls.size(); ++i) {
            TransectDrawingControl tdc = (TransectDrawingControl)controls.get(i);
            tdc.transectViewsChanged();
        }
    }

    public List findTransectDrawingControls() {
        ArrayList<DisplayControl> controls = new ArrayList<DisplayControl>();
        List displayControls = this.getIdv().getDisplayControls();
        for (int i = 0; i < displayControls.size(); ++i) {
            DisplayControl c = (DisplayControl)displayControls.get(i);
            if (!(c instanceof TransectDrawingControl)) continue;
            controls.add(c);
        }
        return controls;
    }

    public void updateAllLegends() {
        for (int i = 0; i < this.viewManagers.size(); ++i) {
            ViewManager vm = this.viewManagers.get(i);
            vm.fillLegends();
        }
    }

    public void writeVMState() {
        this.getVMState();
        ArrayList localViewpoints = new ArrayList();
        List tmp = this.viewpoints;
        for (Object o : tmp) {
            if (o instanceof ViewState && !((ViewState)o).getIsLocal()) continue;
            localViewpoints.add(o);
        }
        try {
            IdvResourceManager idvResourceManager = this.getResourceManager();
            this.getResourceManager();
            XmlResourceCollection rc = idvResourceManager.getXmlResources(IdvResourceManager.RSC_VIEWPOINTS);
            for (int i = 0; i < rc.size(); ++i) {
                if (!rc.isWritableResource(i)) continue;
                File f = new File(rc.get(i).toString());
                String contents = this.getIdv().encodeObject(localViewpoints, true, true);
                IOUtil.writeFile(f, contents);
                return;
            }
        }
        catch (Exception exc) {
            VMManager.logException("writing viewpoints", exc);
        }
    }

    public List getVMState() {
        if (this.viewpoints == null) {
            ArrayList tmp = new ArrayList();
            IdvResourceManager idvResourceManager = this.getResourceManager();
            this.getResourceManager();
            XmlResourceCollection rc = idvResourceManager.getXmlResources(IdvResourceManager.RSC_VIEWPOINTS);
            for (int i = 0; i < rc.size(); ++i) {
                String contents = rc.read(i);
                if (contents == null) continue;
                try {
                    List resources = (List)this.getIdv().getEncoderForRead().toObject(contents);
                    tmp.addAll(resources);
                    boolean local = rc.isWritable(i);
                    for (Object o : resources) {
                        if (!(o instanceof ViewState)) continue;
                        ((ViewState)o).setIsLocal(local);
                    }
                    continue;
                }
                catch (Exception exc) {
                    VMManager.logException("Creating VM list", exc);
                }
            }
            this.viewpoints = tmp;
        }
        return this.viewpoints;
    }

    protected void saveViewManagerState(ViewManager vm) {
        try {
            String name = vm instanceof MapViewManager ? "Map View" : "View";
            name = GuiUtils.getInput(null, "Name for saved view: ", name);
            if (name == null) {
                return;
            }
            ViewState viewState = vm.doMakeViewState();
            viewState.setName(name);
            this.getVMState().add(viewState);
            this.writeVMState();
        }
        catch (Exception exc) {
            VMManager.logException("Saving view state", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewManager(ViewManager newViewManager) {
        ViewManager vm = this.findViewManagerInList(newViewManager.getViewDescriptor());
        if (vm == null) {
            List<ViewManager> list = this.viewManagers;
            synchronized (list) {
                this.viewManagers.add(newViewManager);
            }
            try {
                Trace.call1("VMManager calling ViewManager.init");
                newViewManager.init();
                Trace.call2("VMManager calling ViewManager.init");
            }
            catch (Exception exc) {
                VMManager.logException("Adding view manager", exc);
            }
            this.setLastActiveViewManager(newViewManager);
        }
        this.getIdvUIManager().viewManagerAdded(newViewManager);
    }

    public void addViewManagers(List newVms) {
        for (int i = 0; i < newVms.size(); ++i) {
            ViewManager vm = (ViewManager)newVms.get(i);
            this.addViewManager(vm);
        }
    }

    public void removeAllViewManagers() {
        this.removeAllViewManagers(true);
    }

    public void removeAllViewManagers(boolean andDestroyThem) {
        ArrayList<ViewManager> local = new ArrayList<ViewManager>(this.viewManagers);
        for (int i = 0; i < local.size(); ++i) {
            ViewManager vm = (ViewManager)local.get(i);
            this.removeViewManager(vm);
            if (!andDestroyThem) continue;
            vm.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewManager(ViewManager viewManager) {
        if (this.lastActiveViewManager == viewManager) {
            this.setLastActiveViewManager(null);
        }
        List<ViewManager> list = this.viewManagers;
        synchronized (list) {
            this.viewManagers.remove(viewManager);
        }
        this.transectViewsChanged();
    }

    public void showProjectionManager() {
        for (int i = 0; i < this.viewManagers.size(); ++i) {
            ViewManager vm = this.viewManagers.get(i);
            if (!(vm instanceof MapViewManager)) continue;
            ((MapViewManager)vm).showProjectionManager();
            break;
        }
    }

    public void unpersistViewManagers(List newViewManagers) {
        try {
            for (int i = 0; i < newViewManagers.size(); ++i) {
                ViewManager newViewManager = (ViewManager)newViewManagers.get(i);
                newViewManager.initAfterUnPersistence(this.getIdv());
            }
        }
        catch (Exception exc) {
            VMManager.logException("Unpersisting view manager", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayMastersActive() {
        List<ViewManager> list = this.viewManagers;
        synchronized (list) {
            for (int i = 0; i < this.viewManagers.size(); ++i) {
                this.viewManagers.get(i).setMasterActive(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayMastersInactive() {
        List<ViewManager> list = this.viewManagers;
        synchronized (list) {
            for (int i = 0; i < this.viewManagers.size(); ++i) {
                this.viewManagers.get(i).setMasterInactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewManager findOrCreateViewManager(ViewDescriptor viewDescriptor, String properties) {
        List<ViewManager> list = this.viewManagers;
        synchronized (list) {
            ViewManager viewManager = this.findViewManager(viewDescriptor);
            if (viewManager == null) {
                viewManager = this.createViewManager(viewDescriptor, properties);
            }
            return viewManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewManager createViewManager(ViewDescriptor viewDescriptor, String properties) {
        List<ViewManager> list = this.viewManagers;
        synchronized (list) {
            try {
                ViewManager viewManager = null;
                if (viewDescriptor == null) {
                    viewDescriptor = new ViewDescriptor();
                }
                if (viewDescriptor.getClassNames().size() > 0) {
                    Class viewManagerClass = Misc.findClass((String)viewDescriptor.getClassNames().get(0));
                    Constructor ctor = Misc.findConstructor(viewManagerClass, new Class[]{IntegratedDataViewer.class, ViewDescriptor.class, String.class});
                    if (ctor == null) {
                        throw new IllegalArgumentException("cannot create ViewManager:" + viewManagerClass.getName());
                    }
                    viewManager = (ViewManager)ctor.newInstance(this.getIdv(), viewDescriptor, properties);
                } else {
                    viewManager = new MapViewManager(this.getIdv(), viewDescriptor, properties);
                }
                this.addViewManager(viewManager);
                return viewManager;
            }
            catch (Throwable e) {
                VMManager.logException("In getViewManager", e);
                return null;
            }
        }
    }

    public void center(EarthLocation el) throws VisADException, RemoteException {
        this.center(el, this.getViewManagers());
    }

    public void center(EarthLocation el, List viewManagers) throws VisADException, RemoteException {
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager viewManager = (ViewManager)viewManagers.get(i);
            if (!(viewManager instanceof MapViewManager)) continue;
            NavigatedDisplay navDisplay = ((MapViewManager)viewManager).getMapDisplay();
            navDisplay.center(el);
        }
    }

    public void center(MapProjection mp) throws VisADException, RemoteException {
        this.center(mp, this.getViewManagers());
    }

    public void center(MapProjection mp, List viewManagers) throws VisADException, RemoteException {
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager viewManager = (ViewManager)viewManagers.get(i);
            if (!(viewManager instanceof MapViewManager)) continue;
            MapViewManager mvm = (MapViewManager)viewManager;
            mvm.setMapProjection(mp, false);
        }
    }

    public void center(ProjectionRect pr) throws VisADException, RemoteException {
        this.center(pr, this.getViewManagers());
    }

    public void center(ProjectionRect pr, List viewManagers) throws VisADException, RemoteException {
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager viewManager = (ViewManager)viewManagers.get(i);
            if (!(viewManager instanceof MapViewManager)) continue;
            NavigatedDisplay navDisplay = ((MapViewManager)viewManager).getMapDisplay();
            navDisplay.setMapArea(pr);
        }
    }

    public void center() throws VisADException, RemoteException {
        this.center(this.getViewManagers());
    }

    public void center(List viewManagers) throws VisADException, RemoteException {
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager viewManager = (ViewManager)viewManagers.get(i);
            if (!(viewManager instanceof MapViewManager)) continue;
            ((MapViewManager)viewManager).setProjectionFromFirstDisplay();
        }
    }

    public void setTransect(Transect transect) {
        List<ViewManager> viewManagers = this.getViewManagers();
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager viewManager = viewManagers.get(i);
            if (!(viewManager instanceof TransectViewManager)) continue;
            ((TransectViewManager)viewManager).setTransect(transect);
        }
    }
}

