/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ucar.unidata.data.gis.Transect;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.DisplayInfo;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.NavigatedViewManager;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.TransectDrawingControl;
import ucar.unidata.util.BooleanProperty;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.TransectDisplay;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationWidget;
import ucar.visad.display.DisplayMaster;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Length;
import visad.Gridded2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;

public class TransectViewManager
extends NavigatedViewManager {
    public static final String PREF_GRIDLINES = "TransectView.Gridlines";
    private Real maxDataDistance;
    private Transect transect;
    private JTextField maxDistanceFld;
    private JComboBox distanceUnitBox;
    private static Unit KM = CommonUnits.KILOMETER;

    public TransectViewManager() {
    }

    public TransectViewManager(ViewContext viewContext) {
        super(viewContext);
    }

    public TransectViewManager(ViewContext viewContext, ViewDescriptor desc, String properties) throws VisADException, RemoteException {
        super(viewContext, desc, properties);
    }

    public TransectDisplay getTransectDisplay() {
        return (TransectDisplay)this.getMaster();
    }

    @Override
    protected DisplayMaster doMakeDisplayMaster() throws VisADException, RemoteException {
        Dimension dimension = this.getIdv().getStateManager().getViewSize();
        if (dimension == null && this.displayBounds != null) {
            dimension = new Dimension(this.displayBounds.width, this.displayBounds.height);
        }
        if (dimension == null || dimension.width == 0 || dimension.height == 0) {
            dimension = null;
        }
        TransectDisplay td = new TransectDisplay(this.getLine(this.getTransect(true)), this.getIdv().getArgsManager().getIsOffScreen(), dimension);
        td.setScalesVisible(this.getTransectLabelsVisible());
        Unit u = this.getIdv().getPreferenceManager().getDefaultDistanceUnit();
        if (u != null) {
            td.setHorizontalRangeUnit(u);
        }
        if (this.maxDataDistance == null) {
            try {
                if (u == null) {
                    u = KM;
                }
                this.maxDataDistance = new Real(Length.getRealType(), u.toThis(40000.0, KM), u);
            }
            catch (Exception exc) {
                this.logException("Making max distance unit", exc);
            }
        }
        td.setMaxDataDistance(this.maxDataDistance);
        this.setVerticalRangeUnitPreference(td);
        return td;
    }

    @Override
    public boolean getUseFastRendering(boolean b) {
        return true;
    }

    @Override
    public boolean addDisplayInfo(DisplayInfo displayInfo) throws RemoteException, VisADException {
        if (this.getIsDestroyed()) {
            return false;
        }
        return super.addDisplayInfo(displayInfo);
    }

    private void notfyDisplaysOfTransectChange() {
        List controls = this.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            control.transectChanged();
        }
    }

    private Gridded2DSet getLine(Transect transect) throws VisADException, RemoteException {
        List pointList = transect.getPoints();
        float[] lats = new float[pointList.size()];
        float[] lons = new float[pointList.size()];
        float[][] points = new float[][]{lats, lons};
        for (int i = 0; i < pointList.size(); ++i) {
            LatLonPointImpl llp = (LatLonPointImpl)pointList.get(i);
            lats[i] = (float)llp.getLatitude();
            lons[i] = (float)llp.getLongitude();
        }
        return new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, (float[][])points, points[0].length, null, null, null, false);
    }

    @Override
    protected void initWithInner(ViewManager that, boolean ignoreWindow) throws VisADException, RemoteException {
        if (!(that instanceof TransectViewManager)) {
            return;
        }
        super.initWithInner(that, ignoreWindow);
        TransectViewManager tvm = (TransectViewManager)that;
        if (this != that && tvm.transect != null) {
            this.setTransect(tvm.transect);
        }
    }

    @Override
    protected void updateNameLabel() {
        String name;
        if (this.nameLabel == null) {
            return;
        }
        String string = name = this.getName() == null ? "" : this.getName();
        if (this.transect != null) {
            if (name.trim().length() > 0) {
                name = name + ": ";
            }
            name = name + "" + this.transect.getName();
        }
        this.nameLabel.setText(name);
    }

    @Override
    protected void handleBooleanPropertyChange(String id, boolean value) throws Exception {
        if (id.equals(PREF_GRIDLINES)) {
            if (this.hasDisplayMaster()) {
                this.getTransectDisplay().setGridLinesVisible(value);
            }
        } else if (id.equals("View.ShowTransectScales")) {
            if (this.hasDisplayMaster()) {
                this.getNavigatedDisplay().setScalesVisible(value);
            }
        } else {
            super.handleBooleanPropertyChange(id, value);
        }
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        try {
            Real oldMaxDataDistance = this.maxDataDistance;
            Unit u = null;
            Object selected = this.distanceUnitBox.getSelectedItem();
            String unitName = TwoFacedObject.getIdString(selected);
            try {
                Unit newUnit = Util.parseUnit(unitName);
                if (!(selected instanceof TwoFacedObject)) {
                    selected = new TwoFacedObject((Object)selected.toString(), newUnit);
                }
                if (newUnit == null || !Unit.canConvert(newUnit, KM)) {
                    throw new Exception("Unit must be convertible with kilometers");
                }
                u = newUnit;
            }
            catch (Exception exc) {
                LogUtil.userMessage("Illegal unit :" + unitName + "\n" + exc);
            }
            this.maxDataDistance = new Real(Length.getRealType(), Misc.parseNumber(this.maxDistanceFld.getText().trim()), u);
            this.getTransectDisplay().setMaxDataDistance(this.maxDataDistance);
            if (!Misc.equals(oldMaxDataDistance, this.maxDataDistance)) {
                this.showDisplayTransect();
            }
        }
        catch (Exception exc) {
            LogUtil.userErrorMessage("Bad value:" + this.maxDistanceFld.getText().trim());
            return false;
        }
        return true;
    }

    @Override
    protected void addPropertiesComponents(JTabbedPane tabbedPane) {
        super.addPropertiesComponents(tabbedPane);
        Unit u = this.maxDataDistance.getUnit();
        this.maxDistanceFld = new JTextField(Misc.format(this.maxDataDistance.getValue()), 10);
        this.maxDistanceFld.setToolTipText("Maximum distance shown. e.g.: value[unit]");
        this.distanceUnitBox = this.getDisplayConventions().makeUnitBox(u, null);
        tabbedPane.add("Transect", GuiUtils.inset((Component)GuiUtils.topLeft(GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Max distance: "), this.maxDistanceFld, GuiUtils.rLabel("Unit: "), this.distanceUnitBox}, 2, GuiUtils.WT_N, GuiUtils.WT_N)), 5));
    }

    @Override
    protected JMenu makeShowMenu() {
        JMenu showMenu = super.makeShowMenu();
        this.createCBMI(showMenu, "View.AniReadout");
        this.createCBMI(showMenu, "View.ShowTransectScales");
        this.createCBMI(showMenu, PREF_GRIDLINES);
        return showMenu;
    }

    @Override
    protected void getInitialBooleanProperties(List props) {
        super.getInitialBooleanProperties(props);
        props.add(new BooleanProperty("View.ShowTransectScales", "Show Display Scales", "Show Display Scales", true));
        props.add(new BooleanProperty(PREF_GRIDLINES, "Show Grid Lines", "", true));
    }

    @Override
    protected Container doMakeContents() {
        JComponent navComponent = this.getComponent();
        navComponent.setPreferredSize(this.getMySize());
        return navComponent;
    }

    @Override
    protected void doneFirstFrame() {
        super.doneFirstFrame();
        this.showDisplayTransect();
    }

    @Override
    protected void matrixChanged() {
        super.matrixChanged();
        this.showDisplayTransect();
    }

    @Override
    protected void verticalRangeChanged() {
        super.matrixChanged();
        this.showDisplayTransect();
    }

    @Override
    protected void initBooleanProperties() {
        super.initBooleanProperties();
        BooleanProperty bp = this.getBooleanProperty("View.ShowScales");
        if (bp != null) {
            bp.setDefault(true);
        }
        if ((bp = this.getBooleanProperty(PREF_GRIDLINES)) != null) {
            bp.setDefault(true);
        }
        if ((bp = this.getBooleanProperty("View.Wireframe")) != null) {
            bp.setDefault(false);
        }
    }

    @Override
    public void initializeViewMenu(JMenu viewMenu) {
        super.initializeViewMenu(viewMenu);
        viewMenu.add(this.makeColorMenu());
        viewMenu.add(this.makeSavedViewsMenu());
        this.getViewpointControl().makeVerticalScaleMenuItem(viewMenu);
        viewMenu.addSeparator();
        this.createCBMI(viewMenu, "View.ShareViews");
        viewMenu.add(GuiUtils.makeMenuItem("Set Share Group", this, "showSharableDialog"));
        viewMenu.addSeparator();
        viewMenu.add(GuiUtils.makeMenuItem("Full Screen", this, "setFullScreen"));
        viewMenu.addSeparator();
        viewMenu.add(GuiUtils.makeMenuItem("Properties", this, "showPropertiesDialog"));
    }

    @Override
    public ArrayList doMakeMenuList() {
        ArrayList menus = super.doMakeMenuList();
        menus.add(this.makeViewMenu());
        menus.add(GuiUtils.makeDynamicMenu("Transects", this, "initializeTransectMenu"));
        return menus;
    }

    public void initializeTransectMenu(JMenu transectMenu) {
        int i;
        ArrayList<Transect> transects = new ArrayList<Transect>(this.getResourceManager().getTransects());
        transectMenu.removeAll();
        transectMenu.add(GuiUtils.makeMenuItem("Edit", this, "editTransects"));
        if (this.transect != null && !transects.contains(this.transect)) {
            transects.add(0, this.transect);
        }
        if (transects.size() > 0) {
            transectMenu.addSeparator();
        }
        List<ViewManager> vms = this.getIdv().getVMManager().getViewManagers();
        JMenu viewMenu = null;
        int cnt = 0;
        for (i = 0; i < vms.size(); ++i) {
            String name;
            if (!(vms.get(i) instanceof MapViewManager)) continue;
            MapViewManager mvm = (MapViewManager)vms.get(i);
            if (viewMenu == null) {
                viewMenu = new JMenu("From Views");
                transectMenu.add(viewMenu);
            }
            JMenu theMenu = new JMenu((name = mvm.getName()) == null ? "View " + ++cnt : name);
            viewMenu.add(theMenu);
            NavigatedDisplay nd = mvm.getMapDisplay();
            Rectangle b = nd.getScreenBounds();
            double[] pt1 = nd.getSpatialCoordinatesFromScreen(0, b.height / 2);
            double[] pt2 = nd.getSpatialCoordinatesFromScreen(b.width, b.height / 2);
            theMenu.add(GuiUtils.makeMenuItem("Horizontal", this, "setTransect", new Transect("", Util.toLLP(nd.getEarthLocation(pt1)), Util.toLLP(nd.getEarthLocation(pt2)))));
            pt1 = nd.getSpatialCoordinatesFromScreen(b.width / 2, 0);
            pt2 = nd.getSpatialCoordinatesFromScreen(b.width / 2, b.height);
            theMenu.add(GuiUtils.makeMenuItem("Vertical", this, "setTransect", new Transect("", Util.toLLP(nd.getEarthLocation(pt1)), Util.toLLP(nd.getEarthLocation(pt2)))));
        }
        for (i = 0; i < transects.size(); ++i) {
            Transect menuTransect = (Transect)transects.get(i);
            String prefix = "";
            if (Misc.equals(this.transect, menuTransect)) {
                prefix = "> ";
            }
            transectMenu.add(GuiUtils.makeMenuItem(prefix + menuTransect.toString(), this, "setTransect", menuTransect));
        }
    }

    private void showDisplayTransect() {
        try {
            if (this.hasDisplayMaster()) {
                List controls = this.getVMManager().findTransectDrawingControls();
                for (int i = 0; i < controls.size(); ++i) {
                    TransectDrawingControl tdc = (TransectDrawingControl)controls.get(i);
                    tdc.setDisplayedTransect(this);
                }
            }
        }
        catch (Exception exc) {
            this.logException("Showing the display transect", exc);
        }
    }

    @Override
    public void setLastActive(boolean b) {
        super.setLastActive(b);
        if (b) {
            // empty if block
        }
    }

    public void editTransects() {
        List controls = this.getVMManager().findTransectDrawingControls();
        if (controls.size() == 0) {
            this.getIdv().doMakeControl("transectdrawingcontrol");
            return;
        }
        for (int i = 0; i < controls.size(); ++i) {
            TransectDrawingControl tdc = (TransectDrawingControl)controls.get(i);
            tdc.show();
            ViewManager vm = tdc.getDefaultViewManager();
            if (vm == null) continue;
            vm.showWindow();
        }
    }

    public void setTransect(Transect value) {
        this.setTransect(value, false);
    }

    public void setTransect(Transect value, boolean force) {
        if (!force && Misc.equals(this.transect, value)) {
            return;
        }
        this.transect = value;
        this.updateNameLabel();
        if (!this.hasDisplayMaster()) {
            return;
        }
        TransectDisplay transectDisplay = this.getTransectDisplay();
        try {
            boolean wasRunning = false;
            int currentIndex = 0;
            AnimationWidget widget = this.getAnimationWidget();
            Animation animation = this.getAnimation();
            if (animation != null) {
                wasRunning = animation.isAnimating();
                currentIndex = animation.getCurrent();
            }
            transectDisplay.setTransect(this.getLine(this.transect));
            this.resetProjectionControl();
            this.showDisplayTransect();
            if (widget != null && wasRunning && !widget.isRunning()) {
                animation.setCurrent(currentIndex);
                widget.setRunning(true);
            }
        }
        catch (Exception exc) {
            this.logException("Setting transect", exc);
        }
        this.notfyDisplaysOfTransectChange();
    }

    public Transect getTransect() {
        return this.transect;
    }

    public Transect getAxisTransect() {
        EarthLocation[] els = this.getTransectDisplay().getScaleEndPoints();
        EarthLocation leftEl = els[0];
        EarthLocation rightEl = els[1];
        return new Transect("Transect", Misc.newList(new LatLonPointImpl(leftEl.getLatLonPoint().getLatitude().getValue(), leftEl.getLatLonPoint().getLongitude().getValue()), new LatLonPointImpl(rightEl.getLatLonPoint().getLatitude().getValue(), rightEl.getLatLonPoint().getLongitude().getValue())));
    }

    public Transect getTransect(boolean force) {
        if (this.transect == null && force) {
            List transects = this.getResourceManager().getTransects();
            if (transects.size() > 0) {
                this.transect = (Transect)transects.get(0);
            } else if (transects.size() == 0) {
                this.transect = new Transect("Transect", Misc.newList(new LatLonPointImpl(40.0, -120.0), new LatLonPointImpl(40.0, -100.0)));
            }
        }
        return this.transect;
    }

    public boolean getShowGridLines() {
        return this.getBp(PREF_GRIDLINES);
    }

    @Override
    public void keyWasTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int code = keyEvent.getKeyCode();
        if (keyEvent.getID() == 401) {
            if (GuiUtils.isControlKey(keyEvent)) {
                if (keyEvent.isShiftDown()) {
                    if (code == 37) {
                        this.transect.shiftPercent(0.0, -0.25, true, true);
                    } else if (code == 39) {
                        this.transect.shiftPercent(0.0, 0.25, true, true);
                    } else if (code == 38) {
                        this.transect.shiftPercent(0.25, 0.0, true, true);
                    } else if (code == 40) {
                        this.transect.shiftPercent(-0.25, 0.0, true, true);
                    } else {
                        return;
                    }
                    this.setTransect(this.transect, true);
                    return;
                }
                if (code == 37) {
                    this.getTransectDisplay().extendTransect(1.25);
                } else if (code == 39) {
                    this.getTransectDisplay().extendTransect(0.75);
                } else if (code == 38) {
                    this.getTransectDisplay().extendVerticalRange(0.75);
                } else if (code == 40) {
                    this.getTransectDisplay().extendVerticalRange(1.25);
                }
            } else if (code == 37) {
                this.getTransectDisplay().translate(-0.25, 0.0);
            } else if (code == 39) {
                this.getTransectDisplay().translate(0.25, 0.0);
            } else if (code == 38) {
                this.getTransectDisplay().translate(0.0, 0.25);
            } else if (code == 40) {
                this.getTransectDisplay().translate(0.0, -0.25);
            }
        }
        super.keyWasTyped(keyEvent);
    }

    public void setMaxDataDistance(Real value) {
        this.maxDataDistance = value;
    }

    public Real getMaxDataDistance() {
        return this.maxDataDistance;
    }

    @Override
    public String getTypeName() {
        return "Transect";
    }
}

