/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Container;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import ucar.unidata.idv.DisplayInfo;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.util.BooleanProperty;
import ucar.unidata.util.GuiUtils;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.TimeHeightDisplay;
import visad.VisADException;

public class TimeHeightViewManager
extends ViewManager {
    public static final String PREF_GRIDLINES = "TimeHeightView.Gridlines";
    private boolean clipOn = false;

    public TimeHeightViewManager() {
    }

    public TimeHeightViewManager(ViewContext viewContext) {
        super(viewContext);
    }

    public TimeHeightViewManager(ViewContext viewContext, ViewDescriptor desc, String properties) throws VisADException, RemoteException {
        super(viewContext, desc, properties);
    }

    public TimeHeightDisplay getTimeHeightDisplay() {
        return (TimeHeightDisplay)this.getMaster();
    }

    @Override
    protected DisplayMaster doMakeDisplayMaster() throws VisADException, RemoteException {
        return new TimeHeightDisplay();
    }

    @Override
    public boolean getUseFastRendering(boolean b) {
        return true;
    }

    @Override
    public boolean addDisplayInfo(DisplayInfo displayInfo) throws RemoteException, VisADException {
        if (this.getIsDestroyed()) {
            return false;
        }
        return super.addDisplayInfo(displayInfo);
    }

    @Override
    protected void handleBooleanPropertyChange(String id, boolean value) throws Exception {
        if (id.equals(PREF_GRIDLINES)) {
            if (this.hasDisplayMaster()) {
                this.getTimeHeightDisplay().setGridLinesVisible(value);
            }
        } else {
            super.handleBooleanPropertyChange(id, value);
        }
    }

    @Override
    protected JMenu makeShowMenu() {
        JMenu showMenu = super.makeShowMenu();
        this.createCBMI(showMenu, PREF_GRIDLINES);
        return showMenu;
    }

    @Override
    protected void getInitialBooleanProperties(List props) {
        super.getInitialBooleanProperties(props);
        props.add(new BooleanProperty(PREF_GRIDLINES, "Show Grid Lines", "", false));
    }

    @Override
    protected Container doMakeContents() {
        JComponent navComponent = this.getComponent();
        navComponent.setPreferredSize(this.getMySize());
        return navComponent;
    }

    @Override
    protected void initBooleanProperties() {
        super.initBooleanProperties();
        BooleanProperty bp = this.getBooleanProperty("View.ShowScales");
        if (bp != null) {
            bp.setDefault(true);
        }
        if ((bp = this.getBooleanProperty(PREF_GRIDLINES)) != null) {
            bp.setDefault(false);
        }
        if ((bp = this.getBooleanProperty("View.Wireframe")) != null) {
            bp.setDefault(true);
        }
    }

    @Override
    public void initializeViewMenu(JMenu viewMenu) {
        this.showControlMenu = false;
        super.initializeViewMenu(viewMenu);
        viewMenu.add(this.makeColorMenu());
        viewMenu.addSeparator();
        this.createCBMI(viewMenu, "View.ShareViews");
        viewMenu.add(GuiUtils.makeMenuItem("Set Share Group", this, "showSharableDialog"));
        viewMenu.addSeparator();
        viewMenu.add(GuiUtils.makeMenuItem("Properties", this, "showPropertiesDialog"));
    }

    public boolean getShowGridLines() {
        return this.getBp(PREF_GRIDLINES);
    }

    public void setClipping(boolean value) {
        this.clipOn = value;
        if (this.getTimeHeightDisplay() != null) {
            this.getTimeHeightDisplay().enableClipping(this.clipOn);
        }
    }

    public boolean getClipping() {
        return this.clipOn;
    }

    @Override
    public boolean animationOk() {
        return false;
    }

    @Override
    public boolean getShowSideLegend() {
        return false;
    }
}

