/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.idv.SystemMemoryManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.xml.PreferenceManager;
import ucar.unidata.xml.XmlObjectStore;

public class SystemPreference {
    private static final int MAX_SLIDER_VALUE = 101;
    private static final int MIN_SLIDER_VALUE = 0;
    private static final long TOLERANCE = Math.round((double)SystemMemoryManager.getTotalMemory() / 100.0);
    private static final boolean DISPLAY_SLIDER = SystemMemoryManager.isMemoryAvailable();
    private ButtonGroup jtbBg;
    private final MyMemory memory;
    private JSlider slider;
    private JRadioButton sliderButton;
    private JComponent sliderComp;
    private JLabel sliderLabel;
    private JComponent sliderSubComp;
    private JTextField text;
    private JRadioButton textButton;
    private JComponent textComp;
    private JComponent textSubComp;

    SystemPreference(AtomicLong memory) {
        this.memory = new MyMemory(memory);
        this.createText();
        if (DISPLAY_SLIDER) {
            this.createSlider();
            SystemPreference.containerXable(this.textSubComp, false);
            SystemPreference.containerXable(this.sliderSubComp, true);
            this.sliderButton.setSelected(true);
        }
        this.jtbBg = GuiUtils.buttonGroup(this.sliderButton, this.textButton);
    }

    private void createSlider() {
        String sliderLabelText = "Use {0,number,#}% ";
        final String postLabelText = " of available memory (%d/" + SystemMemoryManager.getTotalMemory() + " megabytes" + ")";
        this.sliderLabel = new JLabel(MessageFormat.format("Use {0,number,#}% ", Math.round(SystemMemoryManager.convertToPercent(this.memory.get()))));
        final JLabel postLabel = new JLabel(String.format(postLabelText, this.memory.get()));
        ChangeListener percentListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (SystemPreference.this.sliderComp == null || !SystemPreference.this.sliderComp.isEnabled()) {
                    return;
                }
                int sliderValue = ((JSlider)evt.getSource()).getValue();
                long n = SystemMemoryManager.convertToNumber(sliderValue);
                if (Math.abs(n - SystemPreference.this.memory.get()) > TOLERANCE) {
                    SystemPreference.this.memory.set(n);
                }
                SystemPreference.this.sliderLabel.setText(MessageFormat.format("Use {0,number,#}% ", sliderValue));
                postLabel.setText(String.format(postLabelText, SystemPreference.this.memory.get()));
            }
        };
        JComponent[] sliderComps = GuiUtils.makeSliderPopup(0, 101, Math.round(SystemMemoryManager.convertToPercent(this.memory.get())), percentListener);
        this.slider = (JSlider)sliderComps[1];
        this.slider.setMajorTickSpacing(20);
        this.slider.setExtent(1);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        sliderComps[0].setToolTipText("Set maximum memory by percent");
        this.sliderButton = new JRadioButton();
        this.sliderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemPreference.containerXable(SystemPreference.this.textSubComp, false);
                SystemPreference.containerXable(SystemPreference.this.sliderSubComp, true);
                SystemPreference.this.slider.setValue(Math.round(SystemMemoryManager.convertToPercent(SystemPreference.this.memory.get())));
                SystemPreference.this.textButton.setSelected(false);
                postLabel.setText(String.format(postLabelText, SystemPreference.this.memory.get()));
            }
        });
        this.sliderSubComp = GuiUtils.center(GuiUtils.hbox((Component)this.sliderLabel, (Component)sliderComps[0], postLabel));
        this.sliderComp = GuiUtils.hbox(this.sliderButton, this.sliderSubComp);
    }

    private void createText() {
        this.text = new JTextField(10);
        this.text.setText(this.memory.get() + "");
        this.text.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if ((c < '0' || c > '9') && c != '\b') {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String t = ((JTextField)e.getSource()).getText();
                if (t != null && t.length() > 0) {
                    SystemPreference.this.memory.set(new BigInteger(t).longValue());
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.textButton = new JRadioButton();
        this.textButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemPreference.containerXable(SystemPreference.this.sliderSubComp, false);
                SystemPreference.containerXable(SystemPreference.this.textSubComp, true);
                SystemPreference.this.text.setText(SystemPreference.this.memory.get() + "");
                SystemPreference.this.sliderButton.setSelected(false);
            }
        });
        this.textSubComp = GuiUtils.hbox(this.text, new JLabel(" megabytes"));
        this.textComp = DISPLAY_SLIDER ? GuiUtils.hbox(this.textButton, this.textSubComp) : this.textSubComp;
    }

    private static void containerXable(Container container, boolean enable) {
        if (container == null) {
            return;
        }
        for (Component c : container.getComponents()) {
            c.setEnabled(enable);
            if (!(c instanceof Container)) continue;
            SystemPreference.containerXable((Container)c, enable);
        }
    }

    public Component getComponent(boolean includeLabel) {
        JPanel widgets = GuiUtils.topBottom(this.sliderComp, this.textComp);
        if (includeLabel) {
            ArrayList<JPanel> formatComps = new ArrayList<JPanel>();
            formatComps.add(GuiUtils.topBottom(GuiUtils.rLabel("Memory:   "), new JPanel()));
            formatComps.add(GuiUtils.left(widgets));
            widgets = GuiUtils.inset((Component)GuiUtils.topLeft(GuiUtils.doLayout(formatComps, 2, GuiUtils.WT_N, GuiUtils.WT_N)), 5);
        }
        return widgets;
    }

    PreferenceManager getSystemManager() {
        return new PreferenceManager(){

            @Override
            public void applyPreference(XmlObjectStore store, Object data) {
                store.put("idv.memory", ((AtomicLong)data).get());
            }
        };
    }

    private static class MyMemory {
        private final AtomicLong memory;

        private MyMemory(AtomicLong memory) {
            this.memory = memory;
            this.set(memory.get());
        }

        private void set(long i) {
            this.memory.getAndSet(SystemMemoryManager.checkAndRepair(i));
        }

        private long get() {
            return this.memory.get();
        }
    }
}

