/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public class SystemMemoryManager {
    public static final long MINIMUM_MEMORY = 512L;
    public static final long MAXIMUM_MEMORY = 3072L;
    private static final long OS_32_MAX = 1536L;
    private static final SystemMemoryManager INSTANCE = new SystemMemoryManager();
    private final boolean is32;
    private final long memory;
    private final boolean windows;

    private SystemMemoryManager() {
        long mem = -1L;
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            Method m = osBean.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
            m.setAccessible(true);
            mem = (Long)m.invoke((Object)osBean, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.memory = mem > -1L ? Math.round((double)mem / 1024.0 / 1024.0) : mem;
        this.is32 = System.getProperty("os.arch").indexOf("64") < 0;
        this.windows = System.getProperty("os.name").contains("Windows");
    }

    public static boolean isMemoryAvailable() {
        return SystemMemoryManager.INSTANCE.memory > 0L;
    }

    public static long getTotalMemory() {
        long returnVal = !SystemMemoryManager.isMemoryAvailable() ? SystemMemoryManager.INSTANCE.memory : (SystemMemoryManager.INSTANCE.is32 ? Math.min(SystemMemoryManager.INSTANCE.memory - 512L, 1536L) : SystemMemoryManager.INSTANCE.memory - 512L);
        return SystemMemoryManager.isMemoryAvailable() ? Math.max(returnVal, 512L) : SystemMemoryManager.INSTANCE.memory;
    }

    public static long getDefaultMemory() {
        double percent = SystemMemoryManager.INSTANCE.is32 ? 0.7 : 0.8;
        long memory = Math.round((double)(SystemMemoryManager.getTotalMemory() - 512L) * percent + 512.0);
        return SystemMemoryManager.isMemoryAvailable() ? Math.min(Math.max(memory, 512L), 3072L) : 512L;
    }

    public static float convertToPercent(long memory) {
        float val = SystemMemoryManager.isMemoryAvailable() ? (SystemMemoryManager.getTotalMemory() == 512L ? (float)memory * 100.0f / 512.0f : (float)(memory - 512L) * 100.0f / (float)(SystemMemoryManager.getTotalMemory() - 512L)) : -1.0f;
        return val;
    }

    public static long convertToNumber(int percent) {
        return SystemMemoryManager.isMemoryAvailable() ? 512L + (long)Math.round((float)percent / 100.0f * (float)(SystemMemoryManager.getTotalMemory() - 512L)) : -1L;
    }

    public static long checkAndRepair(long memory) {
        long val = memory;
        if (memory < 512L) {
            val = 512L;
        }
        if (SystemMemoryManager.isMemoryAvailable() && memory > SystemMemoryManager.getTotalMemory()) {
            val = SystemMemoryManager.getTotalMemory();
        }
        return val;
    }
}

