/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataGroup;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvObjectStore;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.mac.MacBridge;
import ucar.unidata.ui.Help;
import ucar.unidata.ui.colortable.ColorTableEditor;
import ucar.unidata.ui.symbol.StationModelCanvas;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.NaiveTrustProvider;
import ucar.unidata.util.StringUtil;
import ucar.unidata.view.geoloc.NavigatedMapPanel;
import ucar.unidata.xml.XmlResourceCollection;

public class StateManager
extends IdvManager {
    private static final String PROP_VERSION_MAJOR = "idv.version.major";
    private static final String PROP_VERSION_MINOR = "idv.version.minor";
    private static final String PROP_BUILD_DATE = "idv.build.date";
    private static final String PROP_VERSION_REVISION = "idv.version.revision";
    static final String PROP_JYTHON_VERSION = "idv.jython.version";
    private Properties idvProperties;
    private static Properties oldToNewNames;
    private String version;
    private String buildDate;
    private String versionMajor;
    private String versionMinor;
    private String versionRevision;
    private String versionAbout;
    private String jythonVersion;
    private boolean runningIsl = false;
    private IdvObjectStore store;
    protected boolean showControlsInTree = false;
    protected String userName;
    private Dimension viewSize;
    public static final String PREF_SunAwtDisableMixing = "SunAwtDisableMixing";
    private boolean alwaysLoadBundlesSynchronously = false;

    public StateManager(IntegratedDataViewer idv) {
        super(idv);
    }

    public void setAlwaysLoadBundlesSynchronously(boolean value) {
        this.alwaysLoadBundlesSynchronously = value;
    }

    public boolean getShouldLoadBundlesSynchronously() {
        if (this.alwaysLoadBundlesSynchronously) {
            return true;
        }
        return this.getIdv().getArgsManager().getIsOffScreen() || !this.getIdv().getHaveInitialized();
    }

    private boolean processPropertyList(Properties props, List propertyFiles) {
        boolean didone = false;
        for (int i = 0; i < propertyFiles.size(); ++i) {
            try {
                Properties newProps = new Properties();
                newProps = Misc.readProperties((String)propertyFiles.get(i), newProps, this.getIdvClass());
                Hashtable processed = StateManager.processPropertyTable(newProps);
                props.putAll((Map<?, ?>)processed);
                didone = true;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return didone;
    }

    protected static Hashtable processPropertyTable(Hashtable newTable) {
        Hashtable processed = new Hashtable();
        Enumeration keys = newTable.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = newTable.get(key);
            String old = key;
            if ((key = StateManager.fixIds(key)).startsWith("idv.gui")) {
                key = StringUtil.replace(key, "idv.gui", "idv.ui");
            }
            if (key.startsWith("View..")) {
                key = StringUtil.replace(key, "View..", "View.");
            }
            if (key.startsWith("View.Map.")) {
                key = StringUtil.replace(key, "View.Map.", "View.");
            }
            processed.put(key, value);
        }
        return processed;
    }

    public static String fixIds(String id) {
        String newId;
        if (id.startsWith("application.")) {
            id = "idv" + id.substring(11);
        }
        if (oldToNewNames != null && (newId = (String)oldToNewNames.get(id)) != null) {
            return newId;
        }
        return id;
    }

    protected void loadProperties() {
        oldToNewNames = Misc.readProperties("/ucar/unidata/idv/resources/old.properties", null, this.getIdvClass());
        this.idvProperties = new Properties();
        boolean didone = this.processPropertyList(this.idvProperties, this.getArgsManager().propertyFiles);
        if (!didone) {
            throw new IllegalArgumentException("Failed to load in any property files");
        }
        String props = (String)this.idvProperties.get("idv.properties");
        if (props != null) {
            List l = this.getResourceManager().getResourcePaths(StringUtil.split(props, ";"));
            this.processPropertyList(this.idvProperties, l);
        }
        for (int i = 0; i < this.getArgsManager().argPropertyNames.size(); ++i) {
            this.idvProperties.put(this.getArgsManager().argPropertyNames.get(i), this.getArgsManager().argPropertyValues.get(i));
        }
        this.showControlsInTree = this.getProperty("idv.ui.showcontrolsintree", false);
        String topDir = this.getHelpRoot();
        Help.setTopDir(topDir);
        StationModelCanvas.setHelpTopDir(topDir);
        ColorTableEditor.setHelpTopDir(topDir);
    }

    public String getHelpRoot() {
        return this.getProperty("idv.help.topDir", "/auxdata/docs/userguide");
    }

    protected void initState(boolean interactiveMode) {
        boolean didAnyPrefrences;
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IDV");
        System.setProperty("sun.awt.disableMixing", "true");
        LogUtil.setTestMode(this.getArgsManager().noGui || this.getArgsManager().getIsOffScreen());
        this.loadProperties();
        if (this.getArgsManager().sitePathFromArgs != null) {
            this.getStore().put("SitePath", (Object)this.getArgsManager().sitePathFromArgs);
        }
        XmlResourceCollection preferencesRC = new XmlResourceCollection("idv.resource.preferences", "The user preferences");
        List prefPaths = this.getPreferencePaths();
        for (int i = 0; i < prefPaths.size(); ++i) {
            String path = (String)prefPaths.get(i);
            path = this.getResourceManager().getResourcePath(path);
            if (path == null || (path = path.trim()).length() == 0) continue;
            preferencesRC.addResource(path);
        }
        boolean bl = didAnyPrefrences = this.getStore().init(preferencesRC) > 0;
        if (this.getArgsManager().sitePathFromArgs != null) {
            this.getStore().put("SitePath", (Object)this.getArgsManager().sitePathFromArgs);
        }
        this.getResourceManager().clearResourceMacros();
        this.getStateManager().loadProperties();
        List<String> propertyRbiFiles = StringUtil.split(this.getProperty("idv.resourcefiles", ""), ";", true, true);
        propertyRbiFiles.addAll(0, this.getArgsManager().argRbiFiles);
        if (System.getProperty("javax.net.ssl.trustStore") == null) {
            NaiveTrustProvider.setAlwaysTrust(true);
        }
        this.getResourceManager().init(propertyRbiFiles);
        String ut = (String)this.getProperty(PREF_SunAwtDisableMixing);
        if (ut != null && ut.equalsIgnoreCase("no")) {
            System.setProperty("sun.awt.disableMixing", "false");
        }
        this.getStore().append(this.getResourceManager().getXmlResources(IdvResourceManager.RSC_PREFERENCES), true);
        Msg.init(this.getResourceManager().getResources(IdvResourceManager.RSC_MESSAGES));
        this.getIdvUIManager().loadLookAndFeel();
        this.versionAbout = null;
        this.version = null;
        this.getIdvUIManager().initSplash();
        this.getIdvUIManager().splashMsg("Initializing Resources");
        try {
            if (interactiveMode && this.getIdvUIManager().isMac()) {
                new MacBridge(this.getIdv());
            }
        }
        catch (Throwable ignore) {
            LogUtil.consoleMessage("Failed to create MacBridge:" + ignore);
        }
        this.getColorTableManager().init(this.getResourceManager().getResources(IdvResourceManager.RSC_COLORTABLES));
        this.getIdvProjectionManager().initProjections();
        this.getStationModelManager().init(this.getResourceManager().getXmlResources(IdvResourceManager.RSC_STATIONSYMBOLS), this.getResourceManager().getResources(IdvResourceManager.RSC_STATIONMODELS));
        this.getIdv().getParamDefaultsEditor();
        DataGroup.init(this.getResourceManager().getXmlResources(IdvResourceManager.RSC_PARAMGROUPS));
        DataAlias.init(this.getResourceManager().getXmlResources(IdvResourceManager.RSC_ALIASES));
        this.getStore().cleanupTmpDirectory();
        this.getDataManager().initResources(this.getResourceManager());
        ControlDescriptor.load(this.getIdv(), this.getResourceManager().getXmlResources(IdvResourceManager.RSC_CONTROLS));
        Object oldControls = this.getStore().get("idv.showcontrols");
        if (oldControls != null) {
            Hashtable<String, String> oldControlMap = null;
            if (oldControls instanceof Hashtable) {
                oldControlMap = (Hashtable<String, String>)oldControls;
            } else {
                List<String> controls = StringUtil.split(oldControls.toString(), ",");
                oldControlMap = new Hashtable<String, String>();
                for (int i = 0; i < controls.size(); ++i) {
                    oldControlMap.put(controls.get(i), controls.get(i));
                }
            }
            Hashtable<String, Boolean> newControlMap = new Hashtable<String, Boolean>();
            List cds = this.getIdv().getControlDescriptors();
            for (int i = 0; i < cds.size(); ++i) {
                ControlDescriptor cd = (ControlDescriptor)cds.get(i);
                if (oldControlMap.get(cd.getControlId()) != null) {
                    newControlMap.put(cd.getControlId(), new Boolean(true));
                    continue;
                }
                newControlMap.put(cd.getControlId(), new Boolean(false));
            }
            this.getStore().put("idv.controlstoshow", newControlMap);
            this.getStore().remove("idv.showcontrols");
        }
        this.getJythonManager().initUserFormulas(this.getResourceManager());
        this.getStore().saveIfNeeded();
        NavigatedMapPanel.DEFAULT_MAPS = Misc.newList("/auxdata/maps/OUTLSUPW", "/auxdata/maps/OUTLSUPU");
        this.getStore().setTmpDir((String)this.getProperty("idv.tmpdir"));
        FileManager.setFileHidingEnabled(new Boolean(this.getPreferenceOrProperty("idv.showhiddenfiles", "false")) == false);
    }

    protected void applyPreferences() {
        FileManager.setFileHidingEnabled(new Boolean(this.getPreferenceOrProperty("idv.showhiddenfiles", "false")) == false);
    }

    protected List getPreferencePaths() {
        String preferencesPaths = this.getProperty("idv.preferencepaths", "%USERPATH%/main.xml");
        return StringUtil.split(preferencesPaths, ";");
    }

    public String applyMacros(String s) {
        Enumeration<Object> keys = this.idvProperties.keys();
        while (keys.hasMoreElements()) {
            String key = StateManager.fixIds((String)keys.nextElement());
            String macro = "${" + key + "}";
            if (s.indexOf(macro) < 0) continue;
            String value = this.idvProperties.get(key).toString();
            s = StringUtil.replace(s, macro, value);
        }
        return s;
    }

    public Hashtable getProperties() {
        return this.idvProperties;
    }

    public Object getProperty(String name) {
        String fixedName;
        Object value = null;
        if (GuiUtils.isMac()) {
            value = this.idvProperties.get("mac." + name);
        }
        if (value == null) {
            value = this.idvProperties.get(name);
        }
        if (value == null && !name.equals(fixedName = StateManager.fixIds(name))) {
            return this.idvProperties.get(fixedName);
        }
        return value;
    }

    @Override
    public boolean getProperty(String name, boolean dflt) {
        String v = (String)this.getProperty(name);
        if (v != null) {
            return new Boolean(v.trim());
        }
        return dflt;
    }

    @Override
    public int getProperty(String name, int dflt) {
        String v = (String)this.getProperty(name);
        if (v != null) {
            return new Integer(v.trim());
        }
        return dflt;
    }

    public double getProperty(String name, double dflt) {
        String v = (String)this.getProperty(name);
        if (v != null) {
            return new Double(v.trim());
        }
        return dflt;
    }

    @Override
    public String getProperty(String name, String dflt) {
        String v = (String)this.getProperty(name);
        if (v != null) {
            return v.trim();
        }
        return dflt;
    }

    public Color getColorProperty(String name, Color dflt) {
        return GuiUtils.decodeColor((String)this.getProperty(name), dflt);
    }

    public void putProperty(String name, String value) {
        this.idvProperties.put(name, value);
    }

    public void putProperty(String name, boolean value) {
        this.idvProperties.put(name, "" + value);
    }

    @Override
    public IdvObjectStore getStore() {
        if (this.store == null) {
            this.store = this.doMakeObjectStore();
        }
        return this.store;
    }

    public String getDefaultHelpUrl() {
        return this.getProperty("idv.help.defaulturl", this.getHelpRoot());
    }

    public String getDefaultHelpTarget() {
        return "idv.index";
    }

    public boolean isLoadingXml() {
        return this.getProperty("idv.loadingxml", false);
    }

    public boolean getShowControlsInTree() {
        return this.showControlsInTree;
    }

    public String getUserName() {
        if (this.userName == null) {
            this.userName = Misc.getSystemProperty("user.name", "");
        }
        return this.userName;
    }

    public String getTitle() {
        return this.getProperty("idv.title", "Default title");
    }

    protected IdvObjectStore doMakeObjectStore() {
        IdvObjectStore store = new IdvObjectStore(this.getIdv(), this.getStoreSystemName(), this.getStoreName(), this.getIdv().getEncoderForRead(), this.getArgsManager().defaultUserDirectory);
        this.initObjectStore(store);
        return store;
    }

    protected void initObjectStore(IdvObjectStore store) {
        while (!store.userDirectoryOk()) {
            LogUtil.userMessage("<html>The IDV is unable to create or write to the local user's directory. <br>Please select a directory. </html>");
            File dir = FileManager.getDirectory(null, "Please select a local IDV directory");
            if (dir != null) {
                store.setOverrideDirectory(dir);
                continue;
            }
            System.exit(0);
        }
        if (store.getMadeUserDirectory()) {
            this.initNewUserDirectory(store.getUserDirectory());
        }
        this.initUserDirectory(store.getUserDirectory());
    }

    public String getStoreName() {
        String storeName = this.getProperty("idv.store.name", NULL_STRING);
        if (storeName != null && storeName.trim().length() > 0) {
            return storeName;
        }
        String className = this.getIdvClass().getName();
        int idx = className.lastIndexOf(".");
        if (idx >= 0) {
            className = className.substring(idx + 1);
        }
        return className;
    }

    public String getStoreSystemName() {
        return this.getProperty("idv.store.system", "unidata/idv");
    }

    protected void initNewUserDirectory(File dir) {
        try {
            String readMeFile = IOUtil.joinDir(dir, "README");
            FileOutputStream fos = new FileOutputStream(readMeFile);
            InputStream readmeInputStream = IOUtil.getInputStream("/ucar/unidata/idv/resources/README.store", this.getClass());
            IOUtil.writeTo(readmeInputStream, fos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initUserDirectory(File dir) {
        String defaultRbi;
        File rbiFile = new File(IOUtil.joinDir(dir, "idv.rbi"));
        if (!rbiFile.exists() && (defaultRbi = IOUtil.readContents("/ucar/unidata/idv/resources/usersExample.rbi", (String)null)) != null) {
            try {
                IOUtil.writeFile(rbiFile, defaultRbi);
            }
            catch (Exception exc) {
                StateManager.logException("Writing default rbi", exc);
            }
        }
    }

    public void writePreference(String pref, Object value) {
        this.getStore().put(pref, value);
        this.getStore().save();
    }

    public void writePreferences() {
        this.getStore().save();
    }

    public void putPreference(String pref, Object value) {
        this.getStore().put(pref, value);
    }

    public Object getPreference(String pref) {
        return this.getStore().get(pref);
    }

    public Object getPreference(String pref, Object dflt) {
        Object result = this.getPreference(pref);
        if (result == null) {
            return dflt;
        }
        return result;
    }

    public Object getPreferenceOrProperty(String pref) {
        Object o = this.getPreference(pref);
        if (o == null) {
            o = this.getProperty(pref, null);
        }
        return o;
    }

    public String getPreferenceOrProperty(String pref, String dflt) {
        Object o = this.getPreferenceOrProperty(pref);
        if (o != null) {
            return o.toString();
        }
        return dflt;
    }

    public double getPreferenceOrProperty(String pref, double dflt) {
        Object o = this.getPreferenceOrProperty(pref);
        if (o != null && !o.toString().isEmpty()) {
            return new Double(o.toString());
        }
        return dflt;
    }

    public boolean getPreferenceOrProperty(String pref, boolean dflt) {
        Object o = this.getPreferenceOrProperty(pref);
        if (o != null && !o.toString().isEmpty()) {
            return new Boolean(o.toString());
        }
        return dflt;
    }

    public boolean getShowDashboardOnStart() {
        return this.getStore().get("idv.ui.showdashboard", true) && this.getProperty("idv.ui.showdashboard", true);
    }

    public String getJythonVersion() {
        this.getVersion();
        return this.jythonVersion;
    }

    public String getVersionMajor() {
        this.getVersion();
        return this.versionMajor;
    }

    public String getVersionMinor() {
        this.getVersion();
        return this.versionMinor;
    }

    public String getVersionRevision() {
        this.getVersion();
        return this.versionRevision;
    }

    public String getVersionAbout() {
        this.getVersion();
        return this.versionAbout;
    }

    public String getVersion() {
        if (this.version == null) {
            try {
                Properties props = Misc.readProperties(this.getProperty("idv.version.file", "/ucar/unidata/idv/resources/build.properties"), null, this.getClass());
                this.buildDate = Misc.getProperty((Hashtable)props, PROP_BUILD_DATE, "");
                this.versionMajor = Misc.getProperty((Hashtable)props, PROP_VERSION_MAJOR, "no_major");
                this.versionMinor = Misc.getProperty((Hashtable)props, PROP_VERSION_MINOR, "no_minor");
                this.versionRevision = Misc.getProperty((Hashtable)props, PROP_VERSION_REVISION, "no_revision");
                this.jythonVersion = Misc.getProperty((Hashtable)props, PROP_JYTHON_VERSION, "");
                this.versionAbout = IOUtil.readContents(this.getProperty("idv.about.text", "/ucar/unidata/idv/resources/about.html"), "");
                this.version = this.versionMajor + "." + this.versionMinor + this.versionRevision;
                this.versionAbout = StringUtil.replace(this.versionAbout, "%idv.version%", this.version);
                this.versionAbout = StringUtil.replace(this.versionAbout, "%idv.build.date%", this.buildDate);
            }
            catch (Exception exc) {
                StateManager.logException("Reading version file", exc);
                this.version = "error";
                this.versionMajor = "";
                this.versionMinor = "";
                this.versionRevision = "";
                this.jythonVersion = "";
                this.versionAbout = "";
            }
        }
        return this.version;
    }

    public String getBuildDate() {
        this.getVersion();
        return this.buildDate;
    }

    public double getNumberVersion() {
        return new Double(this.getVersionMajor()) + new Double(this.getVersionMinor()) * 0.1;
    }

    public void setViewSize(Dimension value) {
        this.viewSize = value;
    }

    public Dimension getViewSize() {
        return this.viewSize;
    }

    public void setRunningIsl(boolean value) {
        this.runningIsl = value;
    }

    public boolean getRunningIsl() {
        return this.runningIsl;
    }
}

