/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.view.sounding.AerologicalDisplay;
import ucar.unidata.view.sounding.AerologicalDisplayConstants;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.DisplayMaster;
import visad.CoordinateSystem;
import visad.VisADException;

public class SoundingViewManager
extends ViewManager
implements AerologicalDisplayConstants {
    public static final String PREF_PREFIX = "View.SOUNDING";
    private String chartType = "skewT";
    private boolean saturationMixingRatioVisibility = false;
    private boolean saturationAdiabatVisibility = true;
    private boolean dryAdiabatVisibility = true;
    private boolean isobarsVisibility = true;

    public SoundingViewManager() {
    }

    public SoundingViewManager(ViewContext viewContext, ViewDescriptor desc, String properties) throws VisADException, RemoteException {
        this(viewContext, desc, properties, null);
    }

    public SoundingViewManager(ViewContext viewContext, ViewDescriptor desc, String properties, AnimationInfo animationInfo) throws VisADException, RemoteException {
        super(viewContext, desc, properties, animationInfo);
    }

    public SoundingViewManager(ViewContext viewContext, DisplayMaster master, ViewDescriptor viewDescriptor, String properties) throws VisADException, RemoteException {
        this(viewContext, viewDescriptor, properties, null);
        this.setDisplayMaster(master);
    }

    @Override
    public void initializeViewMenu(JMenu viewMenu) {
        this.showControlMenu = false;
        super.initializeViewMenu(viewMenu);
        viewMenu.add(this.makeColorMenu());
    }

    @Override
    protected DisplayMaster doMakeDisplayMaster() throws VisADException, RemoteException {
        AerologicalDisplay display = AerologicalDisplay.getInstance(this.chartType);
        this.setLineVisibility(display);
        return display;
    }

    public void setSoundingDisplay(AerologicalDisplay ad) {
        try {
            this.setLineVisibility(ad);
        }
        catch (Exception e) {
            LogUtil.logException("setting line Visibility", e);
        }
        this.setDisplayMaster(ad);
    }

    @Override
    public boolean getShowSideLegend() {
        return false;
    }

    @Override
    public String getTypeName() {
        return "Sounding View";
    }

    @Override
    public boolean animationOk() {
        return false;
    }

    @Override
    protected void addPropertiesComponents(JTabbedPane tabbedPane) {
        AerologicalDisplay soundingDisplay = this.getAerologicalDisplay();
        ArrayList<JRadioButton> chartTypes = new ArrayList<JRadioButton>();
        ButtonGroup bg = new ButtonGroup();
        JRadioButton rb = this.makeChartTypeButton("skewT");
        bg.add(rb);
        chartTypes.add(rb);
        rb = this.makeChartTypeButton("stuve");
        bg.add(rb);
        chartTypes.add(rb);
        rb = this.makeChartTypeButton("emagram");
        bg.add(rb);
        chartTypes.add(rb);
        JPanel types = GuiUtils.left(GuiUtils.vbox(chartTypes));
        types.setBorder(new TitledBorder("Display Types"));
        ArrayList<JCheckBox> lineControls = new ArrayList<JCheckBox>();
        lineControls.add(GuiUtils.makeCheckbox("Dry Adiabats", this, "dryAdiabatVisibility"));
        lineControls.add(GuiUtils.makeCheckbox("Saturation Adiabats", this, "saturationAdiabatVisibility"));
        lineControls.add(GuiUtils.makeCheckbox("Mixing Ratio", this, "saturationMixingRatioVisibility"));
        JPanel lines = GuiUtils.left(GuiUtils.vbox(lineControls));
        lines.setBorder(new TitledBorder("Line Visibility"));
        JPanel comp = GuiUtils.topLeft(GuiUtils.hbox((Component)GuiUtils.inset((Component)types, 5), GuiUtils.inset((Component)lines, 5)));
        tabbedPane.add("Chart", comp);
        super.addPropertiesComponents(tabbedPane);
    }

    private JRadioButton makeChartTypeButton(String type) {
        JRadioButton rb = new JRadioButton(SoundingViewManager.getTypeLabel(type), this.isChartType(type));
        rb.setActionCommand(type);
        rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton myRb = (JRadioButton)e.getSource();
                String type = myRb.getActionCommand();
                SoundingViewManager.this.setChartType(type);
            }
        });
        return rb;
    }

    @Override
    public boolean applyProperties() {
        try {
            this.getAerologicalDisplay().setCoordinateSystem(this.getChartType());
            this.setLineVisibility(this.getAerologicalDisplay());
        }
        catch (Exception excp) {
            return false;
        }
        return true;
    }

    private void setLineVisibility(AerologicalDisplay aeroDisplay) throws VisADException, RemoteException {
        if (aeroDisplay == null) {
            return;
        }
        aeroDisplay.setSaturationMixingRatioVisibility(this.saturationMixingRatioVisibility);
        aeroDisplay.setSaturationAdiabatVisibility(this.saturationAdiabatVisibility);
        aeroDisplay.setDryAdiabatVisibility(this.dryAdiabatVisibility);
        aeroDisplay.setIsobarsVisibility(this.isobarsVisibility);
    }

    public static String getTypeLabel(String chartType) {
        if (chartType.equals("skewT")) {
            return "Skew T";
        }
        if (chartType.equals("stuve")) {
            return "Stuve";
        }
        if (chartType.equals("emagram")) {
            return "Emagram";
        }
        return chartType;
    }

    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String value) {
        this.chartType = value;
    }

    private boolean isChartType(String type) {
        return this.getChartType().equals(type);
    }

    public boolean getSaturationAdiabatVisibility() {
        return this.saturationAdiabatVisibility;
    }

    public void setSaturationAdiabatVisibility(boolean value) {
        this.saturationAdiabatVisibility = value;
        if (this.getHaveInitialized()) {
            try {
                this.setLineVisibility(this.getAerologicalDisplay());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getDryAdiabatVisibility() {
        return this.dryAdiabatVisibility;
    }

    public boolean getIsobarsVisibility() {
        return this.isobarsVisibility;
    }

    public void setDryAdiabatVisibility(boolean value) {
        this.dryAdiabatVisibility = value;
        if (this.getHaveInitialized()) {
            try {
                this.setLineVisibility(this.getAerologicalDisplay());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setIsobarsVisibility(boolean value) {
        this.isobarsVisibility = value;
        if (this.getHaveInitialized()) {
            try {
                this.setLineVisibility(this.getAerologicalDisplay());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getSaturationMixingRatioVisibility() {
        return this.saturationMixingRatioVisibility;
    }

    public void setSaturationMixingRatioVisibility(boolean value) {
        this.saturationMixingRatioVisibility = value;
        if (this.getHaveInitialized()) {
            try {
                this.setLineVisibility(this.getAerologicalDisplay());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public CoordinateSystem getDisplayCoordinateSystem() {
        return this.getAerologicalDisplay().getCoordinateSystem();
    }

    private AerologicalDisplay getAerologicalDisplay() {
        return (AerologicalDisplay)this.getMaster();
    }
}

