/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.AttributeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.UnidataTdsDataPathRemapper;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class ServerUrlRemapper {
    private IntegratedDataViewer idv;
    private XmlResourceCollection urlmapResourceCollection;
    private static final String LATEST_XML_NAME = "latest.xml";
    private static final String TEST_TDS_43_UPDATE = "tds.update.test";
    private static final String TDS_PRE_43_BEST_NAME = "best";
    private static final String TDS_PRE_43_BEST_NAME_SUFFIX = ".ndc";
    private static final String BEST_REMAP_KEY = "best";
    private static final String FILES_REMAP_KEY = "files";
    private static final String TDS_DODS_SERVICE = "/dodsC/";
    private static final String TDS_CATALOG_SERVICE = "/catalog/";
    private static final String UNKNOWN_NCIDV_VERSION = "unknown";
    private String ncIdvVersion = "unknown";
    public static final String TAG_URLMAP = "urlmap";
    private HashMap<String, HashMap<String, String>> urlMaps = new HashMap();
    public static final String CDATA_ID = "#cdata-section";

    public ServerUrlRemapper(IntegratedDataViewer idv) {
        this.idv = idv;
        this.init();
    }

    private void init() {
        this.urlmapResourceCollection = this.idv.getResourceManager().getXmlResources(IdvResourceManager.RSC_URLMAPS);
        this.readUrlRemapResources();
    }

    private void readUrlRemapResources() {
        for (int urlRemapResourceIdx = 0; urlRemapResourceIdx < this.urlmapResourceCollection.size(); ++urlRemapResourceIdx) {
            Element root = this.urlmapResourceCollection.getRoot(urlRemapResourceIdx, false);
            if (root == null) continue;
            List nodes = XmlUtil.findChildren(root, TAG_URLMAP);
            for (Object node1 : nodes) {
                HashMap<Object, Object> tmpUrlMap;
                Element node = (Element)node1;
                String urlType = XmlUtil.getAttribute(node, "type");
                String tmpOldUrl = XmlUtil.getAttribute(node, "old");
                String tmpNewUrl = XmlUtil.getAttribute(node, "new");
                if (!tmpOldUrl.endsWith("/")) {
                    tmpOldUrl = tmpOldUrl + '/';
                }
                if (!tmpNewUrl.endsWith("/")) {
                    tmpNewUrl = tmpNewUrl + '/';
                }
                String oldUrl = tmpOldUrl;
                String newUrl = tmpNewUrl;
                if (this.urlMaps.containsKey(urlType)) {
                    tmpUrlMap = this.urlMaps.get(urlType);
                    if (tmpUrlMap.containsKey(oldUrl)) continue;
                    tmpUrlMap.put(oldUrl, newUrl);
                    this.urlMaps.put(urlType, tmpUrlMap);
                    continue;
                }
                tmpUrlMap = new HashMap<String, String>();
                tmpUrlMap.put(oldUrl, newUrl);
                this.urlMaps.put(urlType, tmpUrlMap);
            }
        }
    }

    private boolean getProperty(String name, boolean dflt) {
        return this.idv.getStateManager().getProperty(name, dflt);
    }

    private Node bundleWalker(String xml) throws SAXException, IOException, TransformerException {
        Document bundle;
        try {
            bundle = XmlUtil.getDocument(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        DocumentTraversal docTraversal = (DocumentTraversal)((Object)bundle);
        TreeWalker walker = docTraversal.createTreeWalker(bundle.getDocumentElement(), -1, null, false);
        ArrayList<String> topLevelTags = new ArrayList<String>();
        topLevelTags.add("version");
        topLevelTags.add("viewmanagers");
        topLevelTags.add("displaycontrols");
        Boolean inDatasourceTag = false;
        Boolean inPropertyTag = false;
        Boolean inSourcesTag = false;
        Boolean inDisplayControlsTag = false;
        AttributeMap propAttrs = (AttributeMap)walker.getRoot().getAttributes();
        String attrName = propAttrs.getNamedItem("class").getNodeValue();
        if (attrName.contains("ucar.unidata.data")) {
            inDatasourceTag = true;
        }
        if (attrName.contains("ucar.unidata.idv.control")) {
            inDisplayControlsTag = true;
        }
        Node thisNode = walker.nextNode();
        while (thisNode != null) {
            String name = thisNode.getNodeName();
            String value = thisNode.getNodeValue();
            if (value != null) {
                if (value.equals("datasources")) {
                    inDatasourceTag = true;
                } else if (value.equals("displaycontrols")) {
                    inDisplayControlsTag = true;
                } else if (topLevelTags.contains(value)) {
                    inDatasourceTag = false;
                    inDisplayControlsTag = false;
                }
            }
            if (inDatasourceTag.booleanValue() || inDisplayControlsTag.booleanValue()) {
                String newPath;
                String oldPath;
                if (name.equals("property")) {
                    propAttrs = (AttributeMap)thisNode.getAttributes();
                    attrName = propAttrs.getNamedItem("name").getNodeValue();
                    inSourcesTag = attrName.equals("Sources") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    inPropertyTag = attrName.equals("Properties") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                if (inSourcesTag.booleanValue()) {
                    if (thisNode.getNodeName().equals(CDATA_ID)) {
                        oldPath = thisNode.getNodeValue();
                        newPath = this.remapMotherlodeToThredds(oldPath);
                        thisNode.setNodeValue(newPath);
                    }
                } else if (inPropertyTag.booleanValue() && thisNode.getNodeName().equals(CDATA_ID) && thisNode.getNodeValue().equals("RESOLVERURL")) {
                    thisNode = walker.nextNode();
                    while (!thisNode.getNodeName().equals(CDATA_ID)) {
                        thisNode = walker.nextNode();
                    }
                    oldPath = thisNode.getNodeValue();
                    newPath = this.remapMotherlodeToThredds(oldPath);
                    thisNode.setNodeValue(newPath);
                }
            }
            thisNode = walker.nextNode();
        }
        return walker.getRoot();
    }

    private String remapMotherlodeToThredds(String oldPath) {
        return this.remapMotherlodeToThredds(oldPath, null);
    }

    private String remapMotherlodeToThredds(String oldPath, String oldPathType) {
        Boolean testTds = this.getProperty(TEST_TDS_43_UPDATE, Boolean.FALSE);
        HashMap<String, String> serverRemap = this.urlMaps.get("opendap");
        String newPath = oldPath = oldPath.replace(":-1/", "/");
        for (Map.Entry<String, String> oldServerName : serverRemap.entrySet()) {
            if (!oldPath.contains(oldServerName.getKey())) continue;
            newPath = oldPath.replace(oldServerName.getKey(), oldServerName.getValue());
            newPath = this.remapOldMotherlodeDatasetUrlPath(newPath, oldPathType);
            break;
        }
        return newPath;
    }

    private String remapOldMotherlodeDatasetUrlPath(String oldUrl, String oldPathType) {
        String newUrl = oldUrl;
        UnidataTdsDataPathRemapper remapper = new UnidataTdsDataPathRemapper();
        String[] breakUrl = null;
        if (oldUrl.contains(TDS_CATALOG_SERVICE)) {
            breakUrl = oldUrl.split(TDS_CATALOG_SERVICE);
        } else if (oldUrl.contains(TDS_DODS_SERVICE)) {
            breakUrl = oldUrl.split(TDS_DODS_SERVICE);
        }
        assert (breakUrl != null);
        if (breakUrl.length != 2) {
            return oldUrl;
        }
        String oldUrlPath = breakUrl[1];
        String map = null;
        map = FILES_REMAP_KEY;
        if (oldUrlPath.contains(LATEST_XML_NAME)) {
            oldUrlPath = oldUrlPath.split(LATEST_XML_NAME)[0];
        } else if (oldUrlPath.contains("best") || oldUrlPath.contains(TDS_PRE_43_BEST_NAME_SUFFIX)) {
            map = "best";
        } else {
            String[] parts = oldUrlPath.split("/");
            String fileName = parts[parts.length - 1];
            oldUrlPath = oldUrlPath.replace(fileName, "");
        }
        List<String> newUrlPaths = remapper.getMappedUrlPaths(oldUrlPath, map);
        if (newUrlPaths != null && newUrlPaths.size() == 1) {
            String newUrlPath = newUrlPaths.get(0);
            newUrl = oldUrl.replace(oldUrlPath, newUrlPath);
        }
        return newUrl;
    }

    public Element remapUrlsInBundle(String xml) throws TransformerException, SAXException, IOException {
        Node bundleNode = this.bundleWalker(xml);
        return (Element)bundleNode;
    }
}

