/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.IdvPersistenceManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;

public class SavedBundle {
    public static final int TYPE_FAVORITE = 0;
    public static final int TYPE_DISPLAY = 1;
    public static final int TYPE_DATA = 2;
    public static final String VALUE_FAVORITE = "favorite";
    public static final String VALUE_DATA = "data";
    public static final String VALUE_DISPLAY = "display";
    public static final String TAG_BUNDLES = "bundles";
    public static final String TAG_BUNDLE = "bundle";
    public static final String ATTR_URL = "url";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CATEGORY = "category";
    public static final String ATTR_TYPE = "type";
    private int type = 0;
    private String url;
    private String name;
    private List categories;
    private Object prototype;
    private boolean local = false;
    private String uniquePrefix;

    public SavedBundle(Element node, String dirRoot, IdvResourceManager resourceManager, boolean local) {
        this.type = this.type;
        this.local = local;
        String typeString = XmlUtil.getAttribute((Node)node, ATTR_TYPE, VALUE_FAVORITE);
        if (typeString.equals(VALUE_FAVORITE)) {
            this.type = 0;
        } else if (typeString.equals(VALUE_DATA)) {
            this.type = 2;
        } else if (typeString.equals(VALUE_DISPLAY)) {
            this.type = 1;
        }
        this.url = resourceManager.getResourcePath(XmlUtil.getAttribute(node, ATTR_URL));
        if (!(this.url.startsWith("/") || this.url.startsWith("http:") || this.url.startsWith("https:") || this.url.startsWith("ftp:"))) {
            this.url = dirRoot + "/" + this.url;
        }
        this.name = XmlUtil.getAttribute(node, ATTR_NAME);
        this.categories = IdvPersistenceManager.stringToCategories(XmlUtil.getAttribute(node, ATTR_CATEGORY));
    }

    public SavedBundle(String url, String name, List categories) {
        this(url, name, categories, false);
    }

    public SavedBundle(String url, String name, List categories, boolean local) {
        this(url, name, categories, null, local);
    }

    public SavedBundle(String url, String name, List categories, Object prototype, boolean local) {
        this(url, name, categories, prototype, local, 0);
    }

    public SavedBundle(String url, String name, List categories, Object prototype, boolean local, int type) {
        this.url = url;
        this.name = name;
        this.categories = new ArrayList(categories);
        this.prototype = prototype;
        this.local = local;
        this.type = type;
    }

    public void toXml(Document doc, Element root) {
        this.toXml(doc, root, false);
    }

    public void toXml(Document doc, Element root, boolean includeCategoryInUrl) {
        boolean isUrl;
        Element node = doc.createElement(TAG_BUNDLE);
        node.setAttribute(ATTR_CATEGORY, IdvPersistenceManager.categoriesToString(this.categories));
        node.setAttribute(ATTR_NAME, this.name);
        File f = new File(this.url);
        boolean bl = isUrl = !f.exists();
        if (isUrl) {
            node.setAttribute(ATTR_URL, this.url);
        } else if (includeCategoryInUrl) {
            node.setAttribute(ATTR_URL, this.getCategorizedName());
        } else {
            node.setAttribute(ATTR_URL, IOUtil.getFileTail(this.url));
        }
        if (this.type == 2) {
            node.setAttribute(ATTR_TYPE, VALUE_DATA);
        } else if (this.type == 1) {
            node.setAttribute(ATTR_TYPE, VALUE_DISPLAY);
        } else {
            node.setAttribute(ATTR_TYPE, VALUE_FAVORITE);
        }
        root.appendChild(node);
    }

    protected void setUniquePrefix(String p) {
        this.uniquePrefix = p;
    }

    public String getCategorizedName() {
        String catString = StringUtil.join("_", this.categories);
        if (this.uniquePrefix != null) {
            catString = this.uniquePrefix + catString;
        }
        return catString + IOUtil.getFileTail(this.url);
    }

    public static List<SavedBundle> processBundleXml(Element root, String dirRoot, IdvResourceManager resourceManager, boolean local) {
        ArrayList<SavedBundle> bundles = new ArrayList<SavedBundle>();
        if (root == null) {
            return bundles;
        }
        List bundleNodes = XmlUtil.findChildren(root, TAG_BUNDLE);
        for (int i = 0; i < bundleNodes.size(); ++i) {
            Element node = (Element)bundleNodes.get(i);
            bundles.add(new SavedBundle(node, dirRoot, resourceManager, local));
        }
        return bundles;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setCategories(List value) {
        this.categories = value;
    }

    public List getCategories() {
        return this.categories;
    }

    public Object getPrototype() {
        return this.prototype;
    }

    public String getLabel() {
        return IdvPersistenceManager.categoriesToString(this.categories) + ">" + this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setType(int value) {
        this.type = value;
    }

    public int getType() {
        return this.type;
    }

    public void setLocal(boolean value) {
        this.local = value;
    }

    public boolean getLocal() {
        return this.local;
    }
}

