/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.unidata.data.DataGroup;
import ucar.unidata.data.DerivedDataDescriptor;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.idv.IdvBase;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvPersistenceManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.SavedBundle;
import ucar.unidata.idv.control.DisplaySetting;
import ucar.unidata.idv.ui.ParamInfo;
import ucar.unidata.ui.colortable.ColorTableManager;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.HtmlUtil;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.MenuUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.PluginClassLoader;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import visad.DateTime;

public class PluginManager
extends IdvManager {
    public static final String PLUGIN_PROTOCOL = "idvresource";
    public static final String TAG_PLUGIN = "plugin";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_CATEGORY = "category";
    public static final String ATTR_DESC = "description";
    public static final String ATTR_URL = "url";
    private int jarCnt = 0;
    private JFrame pluginWindow;
    private JFrame createWindow;
    private JFileChooser createFileChooser;
    private List rbiCheckBoxes;
    private JList createList;
    private JCheckBox mergeCbx = new JCheckBox("Merge Plugin", true);
    private Vector createFileList = new Vector();
    private JTextField jarFileFld;
    private JCheckBox autoInstallCbx;
    private List propertyInfos;
    private Hashtable propertyDescriptions;
    private Hashtable propertyLabels;
    private JComponent propertyPanel;
    Hashtable properties;
    private JTextArea pluginText;
    private JLabel pluginTextLbl;
    private JEditorPane availablePluginEditor;
    private JEditorPane loadedPluginEditor;
    private JScrollPane availablePluginScroller;
    private List myPlugins = new ArrayList();
    private List otherPlugins = new ArrayList();
    private Hashtable categoryToggle = new Hashtable();
    private List pluginClassLoaders = new ArrayList();
    private File localPluginDir;
    private List pluginErrorMessages = new ArrayList();
    private List pluginErrorExceptions = new ArrayList();
    private JComboBox categoryBox;
    private JTextField nameFld = new JTextField(10);

    public PluginManager(IntegratedDataViewer idv) {
        super(idv);
        try {
            String extDir = IOUtil.joinDir(this.getStore().getUserDirectory().toString(), "plugins");
            IOUtil.makeDir(extDir);
            List installPlugins = this.getArgsManager().installPlugins;
            for (int i = 0; i < installPlugins.size(); ++i) {
                String plugin = (String)installPlugins.get(i);
                this.installPlugin(plugin, false);
            }
            if (this.getArgsManager().pluginsOk) {
                this.loadPlugins();
            }
        }
        catch (Exception exc) {
            PluginManager.logException("Loading plugins", exc);
        }
    }

    public void viewPluginFile(Object[] args) {
        try {
            JarFile jarFile = (JarFile)args[0];
            JarEntry jarEntry = (JarEntry)args[1];
            InputStream is = jarFile.getInputStream(jarEntry);
            byte[] bytes = IOUtil.readBytes(is);
            is.close();
            if (args.length == 2) {
                String s = "";
                s = jarEntry.getName().endsWith(".class") ? "Binary file" : new String(bytes);
                this.pluginTextLbl.setText(jarEntry.getName());
                this.pluginText.setText(s);
                this.pluginText.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                this.pluginText.setCaretPosition(0);
            } else {
                String toFile = FileManager.getWriteFile(IOUtil.getFileTail(jarEntry.getName()));
                if (toFile == null) {
                    return;
                }
                IOUtil.writeBytes(new File(toFile), bytes);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error viewing plugin file", exc);
        }
    }

    public void listPlugin(String file) {
        if (!(file = PluginManager.decode(file)).endsWith(".jar")) {
            LogUtil.userMessage("File: " + file + " is a single file. Not a jar file");
            return;
        }
        try {
            JarFile jarFile = new JarFile(file);
            List entries = Misc.toList(jarFile.entries());
            ArrayList<JPanel> comps = new ArrayList<JPanel>();
            for (int i = 0; i < entries.size(); ++i) {
                String name;
                JarEntry entry = (JarEntry)entries.get(i);
                if (entry.isDirectory() || (name = entry.getName()).toLowerCase().endsWith("manifest.mf")) continue;
                JLabel label = new JLabel(name);
                JButton viewBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/FindAgain16.gif", this, "viewPluginFile", new Object[]{jarFile, entry});
                viewBtn.setToolTipText("View this file");
                JButton exportBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Save16.gif", this, "viewPluginFile", new Object[]{jarFile, entry, new Boolean(true)});
                exportBtn.setToolTipText("Export this file");
                Insets btnInsets = new Insets(1, 1, 1, 5);
                JPanel rowComp = GuiUtils.doLayout(new Component[]{GuiUtils.inset((Component)exportBtn, btnInsets), GuiUtils.inset((Component)viewBtn, btnInsets), label}, 3, GuiUtils.WT_NNY, GuiUtils.WT_N);
                rowComp = GuiUtils.inset((Component)rowComp, new Insets(2, 0, 2, 0));
                comps.add(rowComp);
            }
            JPanel panel = GuiUtils.vbox(comps);
            panel = GuiUtils.inset((Component)GuiUtils.top(panel), 5);
            JScrollPane listScroll = GuiUtils.makeScrollPane(panel, 500, 250);
            listScroll.setPreferredSize(new Dimension(650, 250));
            this.pluginTextLbl = new JLabel(" ");
            this.pluginText = new JTextArea(10, 10);
            this.pluginText.setEditable(false);
            JScrollPane textScroll = GuiUtils.makeScrollPane(this.pluginText, 500, 250);
            textScroll.setPreferredSize(new Dimension(500, 250));
            JSplitPane contents = GuiUtils.vsplit((Component)listScroll, (Component)GuiUtils.topCenter(GuiUtils.inset((Component)this.pluginTextLbl, 5), textScroll), 0.5);
            GuiUtils.makeDialog(null, "Plugin List", contents, null, new String[]{GuiUtils.CMD_OK});
        }
        catch (Exception exc) {
            LogUtil.logException("Error listing plugin:" + file, exc);
        }
    }

    public String selectJarFile() {
        String jarFile = FileManager.getWriteFile(FileManager.FILTER_JAR, "jar");
        if (jarFile == null) {
            return null;
        }
        this.jarFileFld.setText(jarFile);
        return jarFile;
    }

    private String getTmpFile(String filename) {
        int cnt = 1;
        String tmpFile = this.getIdv().getObjectStore().getTmpFile(filename);
        while (new File(tmpFile).exists()) {
            tmpFile = this.getIdv().getObjectStore().getTmpFile(cnt + "_" + filename);
            ++cnt;
        }
        return tmpFile;
    }

    public void addText(String text, String filename) {
        try {
            String tmpFile = this.getTmpFile(filename);
            IOUtil.writeFile(tmpFile, text);
            this.addObject(tmpFile);
        }
        catch (Exception exc) {
            PluginManager.logException("Error writing text plugin file", exc);
        }
    }

    public void addObjects(List objects) {
        this.showCreatePlugin();
        for (int i = 0; i < objects.size(); ++i) {
            Wrapper wrapper = new Wrapper(objects.get(i));
            if (this.createFileList.contains(wrapper)) continue;
            this.createFileList.add(wrapper);
        }
        this.createList.setListData(this.createFileList);
    }

    public void addObject(Object obj) {
        this.addObjects(Misc.newList(obj));
    }

    private boolean isObject(Object obj, Class c) {
        List l;
        if (c.isAssignableFrom(obj.getClass())) {
            return true;
        }
        if (obj instanceof List && (l = (List)obj).size() > 0) {
            return this.isObject(l.get(0), c);
        }
        return false;
    }

    public void createPlugin() {
        if (this.createWindow == null) {
            this.showCreatePlugin();
            return;
        }
        String jarFile = this.jarFileFld.getText().trim();
        if (jarFile.length() == 0) {
            jarFile = this.selectJarFile();
            if (jarFile == null) {
                return;
            }
        } else {
            String tail = IOUtil.getFileTail(jarFile);
            if (tail.indexOf(".") < 0) {
                jarFile = jarFile + ".jar";
            }
        }
        try {
            ArrayList<SavedBundle> bundles = new ArrayList<SavedBundle>();
            ArrayList<Object> files = new ArrayList<Object>();
            List resources = this.getResourceManager().getResourcesForUser();
            StringBuffer rbiSB = null;
            for (int i = 0; i < resources.size(); ++i) {
                JCheckBox cbx = (JCheckBox)this.rbiCheckBoxes.get(i);
                if (!cbx.isSelected()) continue;
                if (rbiSB == null) {
                    rbiSB = new StringBuffer();
                    rbiSB.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                    rbiSB.append("<resourcebundle>\n");
                }
                IdvResourceManager.IdvResource resource = (IdvResourceManager.IdvResource)resources.get(i);
                rbiSB.append(XmlUtil.tag("resources", XmlUtil.attrs(ATTR_NAME, resource.getId(), "removeprevious", "true")));
                rbiSB.append("\n");
            }
            if (rbiSB != null) {
                rbiSB.append("</resourcebundle>\n");
                String tmpFile = this.getTmpFile("idv.rbi");
                IOUtil.writeFile(tmpFile, rbiSB.toString());
                files.add(tmpFile);
            }
            StringBuffer propertiesSB = null;
            for (int i = 0; i < this.propertyInfos.size(); ++i) {
                String newValue;
                JTextComponent fld;
                PropertyInfo pi = (PropertyInfo)this.propertyInfos.get(i);
                if (pi.widget instanceof JTextField) {
                    fld = (JTextField)pi.widget;
                    newValue = fld.getText().trim();
                } else if (pi.widget instanceof JTextArea) {
                    fld = (JTextArea)pi.widget;
                    String delimiter = pi.delimiter;
                    delimiter = delimiter == null ? ";" : delimiter.trim();
                    newValue = StringUtil.join(delimiter, StringUtil.split(fld.getText().trim(), "\n", true, true));
                } else {
                    JCheckBox box = (JCheckBox)pi.widget;
                    newValue = box.isSelected() ? "true" : "false";
                }
                if (pi.value.trim().equals(newValue.trim())) continue;
                if (propertiesSB == null) {
                    propertiesSB = new StringBuffer();
                }
                propertiesSB.append(pi.key);
                propertiesSB.append(" = ");
                propertiesSB.append(newValue);
                propertiesSB.append("\n");
            }
            if (propertiesSB != null) {
                String tmpFile = this.getTmpFile("idv.properties");
                IOUtil.writeFile(tmpFile, propertiesSB.toString());
                files.add(tmpFile);
            }
            Hashtable objects = new Hashtable();
            for (int i = 0; i < this.createFileList.size(); ++i) {
                Wrapper wrapper = (Wrapper)this.createFileList.get(i);
                Object obj = wrapper.obj;
                if (obj instanceof String) {
                    files.add(obj);
                    continue;
                }
                if (this.isObject(obj, DerivedDataDescriptor.class)) {
                    this.add(objects, obj, "derived.xml");
                    continue;
                }
                if (this.isObject(obj, ParamInfo.class)) {
                    this.add(objects, obj, "paramdefaults.xml");
                    continue;
                }
                if (this.isObject(obj, DisplaySetting.class)) {
                    this.add(objects, obj, "displaysettings.xml");
                    continue;
                }
                if (this.isObject(obj, DataGroup.class)) {
                    this.add(objects, obj, "paramgroups.xml");
                    continue;
                }
                if (this.isObject(obj, ColorTable.class)) {
                    this.add(objects, obj, "colortables.xml");
                    continue;
                }
                if (this.isObject(obj, ProjectionImpl.class)) {
                    this.add(objects, obj, "projections.xml");
                    continue;
                }
                if (this.isObject(obj, StationModel.class)) {
                    this.add(objects, obj, "stationmodels.xml");
                    continue;
                }
                if (this.isObject(obj, SavedBundle.class)) {
                    if (obj instanceof SavedBundle) {
                        bundles.add((SavedBundle)obj);
                        continue;
                    }
                    bundles.addAll((List)obj);
                    continue;
                }
                System.err.println("Unknown object type:" + obj.getClass().getName());
            }
            if (bundles.size() > 0) {
                Hashtable<String, String> seen = new Hashtable<String, String>();
                for (int i = 0; i < bundles.size(); ++i) {
                    SavedBundle savedBundle = (SavedBundle)bundles.get(i);
                    String urlOrFile = savedBundle.getUrl();
                    try {
                        new URL(urlOrFile);
                        continue;
                    }
                    catch (MalformedURLException mue) {
                        String path = savedBundle.getCategorizedName();
                        int cnt = 0;
                        while (seen.get(path) != null) {
                            savedBundle.setUniquePrefix("v" + cnt++ + "_");
                            path = savedBundle.getCategorizedName();
                        }
                        seen.put(path, path);
                        files.add(new TwoFacedObject((Object)path, urlOrFile));
                    }
                }
                String bundlesXml = IdvPersistenceManager.getBundleXml(bundles, true);
                String uid = "bundles.xml";
                String bundlesFile = this.getIdv().getObjectStore().getTmpFile(uid);
                IOUtil.writeFile(bundlesFile, bundlesXml);
                files.add(bundlesFile);
                for (int i = 0; i < bundles.size(); ++i) {
                    SavedBundle savedBundle = (SavedBundle)bundles.get(i);
                    savedBundle.setUniquePrefix(null);
                }
            }
            Enumeration keys = objects.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                this.addEncodedObject(files, objects.get(key), key);
            }
            if (files.size() == 0) {
                LogUtil.userMessage("No files have been selected");
                return;
            }
            IOUtil.writeJarFile(jarFile, files, null, true);
            if (this.autoInstallCbx.isSelected()) {
                this.installPlugin(jarFile, true);
                this.updatePlugins();
            }
            LogUtil.userMessage("Plugin file has been written");
        }
        catch (Exception exc) {
            PluginManager.logException("Error writing plugin file:" + jarFile, exc);
        }
    }

    private void add(Hashtable objects, Object object, String filename) {
        ArrayList<Object> l = (ArrayList<Object>)objects.get(filename);
        if (l == null) {
            l = new ArrayList<Object>();
            objects.put(filename, l);
        }
        if (object instanceof List) {
            l.addAll((List)object);
        } else {
            l.add(object);
        }
    }

    private void addEncodedObject(List files, Object object, String filename) throws Exception {
        String tmpFile = this.getIdv().getObjectStore().getTmpFile(filename);
        String xml = this.getIdv().encodeObject(object, true);
        IOUtil.writeFile(tmpFile, xml);
        files.add(tmpFile);
    }

    public void closeCreatePlugin() {
        if (this.createWindow != null) {
            this.createWindow.setVisible(false);
        }
    }

    public void applyPreferences() {
        if (this.createFileChooser != null) {
            this.createFileChooser.setFileHidingEnabled(FileManager.getFileHidingEnabled());
        }
    }

    public void addCreateFile() {
        if (this.createFileChooser == null) {
            this.createFileChooser = new JFileChooser();
            this.createFileChooser.setCurrentDirectory(new File(this.getResourceManager().getUserPath()));
            this.createFileChooser.setMultiSelectionEnabled(true);
            this.applyPreferences();
        }
        if (this.createFileChooser.showOpenDialog(null) == 0) {
            File[] files = this.createFileChooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                this.addCreateFile(files[i].toString());
            }
        }
    }

    public void addCreateFile(String file) {
        this.addCreateFile(file, null);
    }

    private JComponent getBundleComponent(String name) {
        if (this.categoryBox == null) {
            this.categoryBox = this.getPersistenceManager().makeCategoryBox();
        }
        Object selected = this.categoryBox.getSelectedItem();
        GuiUtils.setListData(this.categoryBox, this.getPersistenceManager().getFavoritesCategories());
        if (selected != null) {
            this.categoryBox.setSelectedItem(selected);
        }
        if (name != null) {
            this.nameFld.setText(name);
        }
        return GuiUtils.top(GuiUtils.vbox(new JLabel("Name:"), this.nameFld, new JLabel("Category:"), this.categoryBox));
    }

    private void addCreateFile(String file, String label) {
        if (this.getArgsManager().isBundleFile(file)) {
            String name = IOUtil.getFileTail(IOUtil.stripExtension(file));
            if (!GuiUtils.showOkCancelDialog(null, "Favorite Bundle Category", GuiUtils.inset((Component)this.getBundleComponent(name), 10), null)) {
                return;
            }
            this.makeSavedBundle(file);
            return;
        }
        Wrapper wrapper = new Wrapper(file, label);
        this.showCreatePlugin();
        if (!this.createFileList.contains(wrapper)) {
            this.createFileList.add(wrapper);
            this.createList.setListData(this.createFileList);
            this.createList.setSelectedIndex(this.createFileList.size() - 1);
        }
    }

    public void removeCreateFile() {
        this.showCreatePlugin();
        Vector newList = new Vector(this.createFileList);
        int[] indices = this.createList.getSelectedIndices();
        int lastIndex = 0;
        for (int i = 0; i < indices.length; ++i) {
            lastIndex = indices[i];
            Object o = this.createFileList.get(indices[i]);
            newList.remove(o);
        }
        this.createFileList = newList;
        this.createList.setListData(this.createFileList);
        if (this.createFileList.size() > 0) {
            while (lastIndex >= this.createFileList.size()) {
                --lastIndex;
            }
            if (lastIndex >= 0) {
                this.createList.setSelectedIndex(lastIndex);
            }
        }
    }

    public void initializeColorTableMenu(JMenu menu) {
        ArrayList items = new ArrayList();
        ObjectListener listener = new ObjectListener(this){

            @Override
            public void actionPerformed(ActionEvent ae, Object object) {
                PluginManager.this.addObject(object);
            }
        };
        this.getIdv().getColorTableManager().makeColorTableMenu(listener, items);
        GuiUtils.makeMenu(menu, items);
    }

    public void initializeStationModelsMenu(JMenu menu) {
        this.initializeMenu(menu, this.getIdv().getStationModelManager().getStationModels(), "Layout Models");
    }

    public void initializeFavoritesMenu(JMenu menu) {
        List<SavedBundle> favorites = this.getPersistenceManager().getBundles(0);
        List<SavedBundle> displays = this.getPersistenceManager().getBundles(1);
        List<SavedBundle> data = this.getPersistenceManager().getBundles(2);
        boolean multiples = favorites.size() > 0 && displays.size() > 0;
        multiples |= favorites.size() > 0 && data.size() > 0;
        multiples |= displays.size() > 0 && data.size() > 0;
        JMenu theMenu = menu;
        if (favorites.size() > 0) {
            if (multiples) {
                theMenu = new JMenu("Bundles");
                menu.add(theMenu);
            }
            this.initializeMenu(theMenu, favorites, "Favorites");
        }
        theMenu = menu;
        if (displays.size() > 0) {
            if (multiples) {
                theMenu = new JMenu("Displays");
                menu.add(theMenu);
            }
            this.initializeMenu(theMenu, displays, "Display Favorites");
        }
        theMenu = menu;
        if (data.size() > 0) {
            if (multiples) {
                theMenu = new JMenu("Data");
                menu.add(theMenu);
            }
            this.initializeMenu(theMenu, data, "Data Favorites");
        }
        GuiUtils.limitMenuSize(menu, "Favorites", 20);
    }

    public void initializeFormulasMenu(JMenu menu) {
        this.initializeMenu(menu, this.getIdv().getJythonManager().getDescriptors(), "Formulas");
    }

    public void loadBundlesFromDisk() {
        String file = FileManager.getReadFileOrURL("Bundle to load into plugin", this.getArgsManager().getBundleFileFilters(), this.getBundleComponent(null));
        if (file == null) {
            return;
        }
        if ((file = file.trim()).length() == 0) {
            return;
        }
        this.makeSavedBundle(file);
    }

    private void makeSavedBundle(String file) {
        Object cat;
        String name = this.nameFld.getText().trim();
        if (name.length() == 0) {
            name = IOUtil.stripExtension(IOUtil.getFileTail(file));
        }
        if ((cat = this.categoryBox.getSelectedItem()) == null) {
            cat = "";
        }
        SavedBundle savedBundle = new SavedBundle(file, name, IdvPersistenceManager.stringToCategories(cat.toString()));
        this.addObject(savedBundle);
    }

    public void initializeParamDefaultsMenu(JMenu menu) {
        this.initializeMenu(menu, this.getIdv().getParamDefaultsEditor().getParamInfos(true), "Param Defaults");
    }

    public void initializeProjectionsMenu(JMenu menu) {
        List projections = this.getIdv().getIdvProjectionManager().getProjections();
        MapViewManager.makeProjectionsMenu(menu, projections, this, "addObject");
    }

    public void initializeMenu(JMenu menu, List list, String name) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            String label = obj instanceof SavedBundle ? ((SavedBundle)obj).getLabel() : obj.toString();
            items.add(GuiUtils.makeMenuItem(label, this, "addObject", obj));
        }
        MenuUtil.makeMenu(menu, items);
        GuiUtils.limitMenuSize(menu, name, 20);
    }

    public void addPreferences() {
        this.addCreateFile(this.getResourceManager().getResourcePath(this.getStateManager().getPreferencePaths().get(0).toString()));
    }

    public void showCreatePlugin() {
        if (this.createWindow == null) {
            this.autoInstallCbx = new JCheckBox("Install", false);
            this.autoInstallCbx.setToolTipText("Automatically install the plugin when it is created");
            this.createWindow = GuiUtils.createFrame(GuiUtils.getApplicationTitle() + "Plugin Creator");
            this.createList = new JList();
            this.createList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (GuiUtils.isDeleteEvent(e)) {
                        PluginManager.this.removeCreateFile();
                    }
                }
            });
            this.jarFileFld = new JTextField("", 30);
            JButton deleteBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/plugin_delete.png", this, "removeCreateFile");
            JScrollPane listScroll = GuiUtils.makeScrollPane(this.createList, 150, 250);
            JButton writeBtn = GuiUtils.makeButton("Write Plugin: ", this, "createPlugin");
            JButton browseBtn = GuiUtils.makeButton("Browse", this, "selectJarFile");
            JPanel fileComp = GuiUtils.leftCenterRight(GuiUtils.inset((Component)GuiUtils.hbox((Component)this.autoInstallCbx, (Component)writeBtn, 5), 2), GuiUtils.hfill(this.jarFileFld), GuiUtils.inset((Component)browseBtn, 2));
            GuiUtils.tmpInsets = GuiUtils.INSETS_2;
            JComponent center = GuiUtils.doLayout(new Component[]{GuiUtils.top(deleteBtn), listScroll}, 2, GuiUtils.WT_NY, GuiUtils.WT_Y);
            List resources = this.getResourceManager().getResourcesForUser();
            this.rbiCheckBoxes = new ArrayList();
            for (int i = 0; i < resources.size(); ++i) {
                IdvResourceManager.IdvResource resource = (IdvResourceManager.IdvResource)resources.get(i);
                this.rbiCheckBoxes.add(new JCheckBox(resource.getDescription(), false));
            }
            this.properties = this.getIdv().getStateManager().getProperties();
            List<String> propertyKeys = new ArrayList();
            this.propertyDescriptions = new Hashtable();
            this.propertyLabels = new Hashtable();
            Enumeration keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                if (!key.startsWith("idv.") || key.endsWith(".propignore") || this.properties.get(key + ".propignore") != null || key.endsWith(".propcategory") || key.endsWith(".propdelimiter") || key.endsWith(".propwidth")) continue;
                if (key.endsWith(".proplabel")) {
                    this.propertyLabels.put(key, this.properties.get(key));
                    continue;
                }
                if (key.startsWith("idv.loadingxml")) continue;
                if (key.endsWith(".propdesc")) {
                    this.propertyDescriptions.put(key, this.properties.get(key));
                    continue;
                }
                propertyKeys.add(key);
            }
            propertyKeys = Misc.sort(propertyKeys);
            this.propertyInfos = new ArrayList();
            Rectangle scrollRect = new Rectangle(1, 1, 1, 1);
            ArrayList<String> cats = new ArrayList<String>();
            ArrayList<String> catNames = new ArrayList<String>();
            ArrayList catLists = new ArrayList();
            cats.add("idv.ui");
            catNames.add("User Interface");
            catLists.add(new ArrayList());
            cats.add("idv.data");
            catNames.add("Data");
            catLists.add(new ArrayList());
            cats.add("idv.misc");
            catNames.add("Miscellaneous");
            catLists.add(new ArrayList());
            Insets labelInset = new Insets(0, 10, 0, 0);
            for (int i = 0; i < propertyKeys.size(); ++i) {
                String text;
                PropertyInfo pi = new PropertyInfo();
                this.propertyInfos.add(pi);
                pi.key = (String)propertyKeys.get(i);
                pi.value = (String)this.properties.get(pi.key);
                String label = (String)this.propertyLabels.get(pi.key + ".proplabel");
                String desc = (String)this.propertyDescriptions.get(pi.key + ".propdesc");
                pi.delimiter = (String)this.properties.get(pi.key + ".propdelimiter");
                String labelToolTip = null;
                if (label == null) {
                    label = pi.key;
                } else {
                    labelToolTip = pi.key;
                }
                JComponent propLabel = new JLabel(label);
                if (labelToolTip != null) {
                    propLabel.setToolTipText(labelToolTip);
                }
                if ((text = pi.value.trim()).equals("true") || text.equals("false")) {
                    pi.widget = new JCheckBox("", text.equals("true"));
                } else if (pi.delimiter != null) {
                    pi.delimiter = pi.delimiter.trim();
                    pi.widget = new JTextArea(StringUtil.join("\n", StringUtil.split(text, pi.delimiter, true, true)), 4, 20);
                    pi.value = StringUtil.join(pi.delimiter, StringUtil.split(((JTextArea)pi.widget).getText(), "\n", true, true));
                    pi.outerWidget = desc != null ? GuiUtils.vbox(new JLabel(desc), new JScrollPane(pi.widget)) : new JScrollPane(pi.widget);
                    pi.outerWidget = GuiUtils.inset((Component)pi.outerWidget, new Insets(2, 0, 2, 0));
                    propLabel = GuiUtils.top(propLabel);
                } else {
                    String width = (String)this.properties.get(pi.key + ".propwidth");
                    if (width != null) {
                        pi.widget = new JTextField(text, new Integer(width.trim()));
                        ((JTextField)pi.widget).setCaretPosition(0);
                        pi.outerWidget = GuiUtils.left(pi.widget);
                    } else {
                        pi.widget = new JTextField(text, 30);
                        ((JTextField)pi.widget).setCaretPosition(0);
                    }
                }
                if (desc != null) {
                    pi.widget.setToolTipText(desc);
                }
                List comps = null;
                for (int catIdx = 0; catIdx < cats.size(); ++catIdx) {
                    if (!pi.key.startsWith((String)cats.get(catIdx))) continue;
                    comps = (List)catLists.get(catIdx);
                    break;
                }
                if (comps == null) {
                    comps = (List)catLists.get(catLists.size() - 1);
                }
                comps.add(GuiUtils.inset((Component)propLabel, labelInset));
                comps.add(pi.getComponentToDisplay());
            }
            ArrayList<Component> compsToDisplay = new ArrayList<Component>();
            for (int catIdx = 0; catIdx < cats.size(); ++catIdx) {
                String name = (String)catNames.get(catIdx);
                JLabel catLabel = new JLabel("<html><h2 style=\"margin-bottom:2pt;\">" + name + "</h2></html>");
                compsToDisplay.add(catLabel);
                compsToDisplay.add(GuiUtils.filler());
                compsToDisplay.addAll((List)catLists.get(catIdx));
            }
            this.propertyPanel = GuiUtils.doLayout(compsToDisplay, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            Msg.SkipPanel skipPanel = new Msg.SkipPanel(new BorderLayout());
            skipPanel.add("Center", this.propertyPanel);
            this.propertyPanel = skipPanel;
            this.propertyPanel = GuiUtils.makeScrollPane(GuiUtils.inset((Component)this.propertyPanel, 5), 200, 200);
            this.propertyPanel.setPreferredSize(new Dimension(150, 200));
            this.propertyPanel.setSize(150, 200);
            JComponent rbiPanel = GuiUtils.vbox(this.rbiCheckBoxes);
            rbiPanel = GuiUtils.makeScrollPane(rbiPanel, 200, 300);
            rbiPanel.setSize(new Dimension(150, 250));
            rbiPanel = GuiUtils.topCenter(new JLabel("Select the system resources to exclude"), GuiUtils.top(rbiPanel));
            JTabbedPane tab = new JTabbedPane();
            tab.add("Resources", center);
            tab.add("Excludes", GuiUtils.inset((Component)rbiPanel, 5));
            tab.add("Properties", GuiUtils.inset((Component)this.propertyPanel, 5));
            center = tab;
            center = GuiUtils.centerBottom(center, GuiUtils.inset((Component)fileComp, 5));
            JMenuBar menuBar = new JMenuBar();
            JMenu fileMenu = new JMenu("File");
            fileMenu.add(GuiUtils.makeMenuItem("Add File", this, "addCreateFile"));
            fileMenu.add(GuiUtils.makeMenuItem("Add Preferences", this, "addPreferences"));
            JMenu resourceMenu = new JMenu("Add Resource");
            resourceMenu.add(GuiUtils.makeDynamicMenu("Favorites", this, "initializeFavoritesMenu"));
            resourceMenu.add(GuiUtils.makeMenuItem("Bundle from disk", this, "loadBundlesFromDisk"));
            resourceMenu.add(GuiUtils.makeDynamicMenu("Color Tables", this, "initializeColorTableMenu"));
            resourceMenu.add(GuiUtils.makeDynamicMenu("Layout Models", this, "initializeStationModelsMenu"));
            resourceMenu.add(GuiUtils.makeDynamicMenu("Projections", this, "initializeProjectionsMenu"));
            resourceMenu.add(GuiUtils.makeDynamicMenu("Formulas", this, "initializeFormulasMenu"));
            resourceMenu.add(GuiUtils.makeDynamicMenu("Parameter Defaults", this, "initializeParamDefaultsMenu"));
            fileMenu.add(resourceMenu);
            fileMenu.addSeparator();
            fileMenu.add(GuiUtils.makeMenuItem("Import Plugin", this, "importPlugin"));
            fileMenu.addSeparator();
            fileMenu.add(GuiUtils.makeMenuItem("Close", this, "closeCreatePlugin"));
            JMenu helpMenu = new JMenu("Help");
            helpMenu.add(GuiUtils.makeMenuItem("Plugin Creator", this, "showCreatorHelp"));
            menuBar.add(fileMenu);
            menuBar.add(helpMenu);
            JPanel bottom = GuiUtils.inset((Component)GuiUtils.wrap(GuiUtils.makeButton("Close", this, "closeCreatePlugin")), 2);
            JPanel contents = GuiUtils.topCenterBottom(menuBar, center, bottom);
            this.createWindow.getContentPane().add(contents);
            GuiUtils.decorateFrame(this.createWindow, menuBar);
            this.createWindow.pack();
            Msg.translateTree(this.createWindow);
            this.createWindow.setLocation(100, 100);
        }
        GuiUtils.toFront(this.createWindow);
    }

    public void showCreatorHelp() {
        this.getIdv().getIdvUIManager().showHelp("idv.misc.plugincreator");
    }

    public void showManagerHelp() {
        this.getIdv().getIdvUIManager().showHelp("idv.misc.plugins");
    }

    public void showPluginList() {
        this.updatePlugins();
    }

    protected void closeResources() {
        for (int i = 0; i < this.pluginClassLoaders.size(); ++i) {
            ((PluginClassLoader)this.pluginClassLoaders.get(i)).closeJar();
        }
    }

    protected void loadPlugins() throws Exception {
        String path;
        int resourceIdx;
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        ResourceCollection rc = idvResourceManager.getResources(IdvResourceManager.RSC_PLUGINS);
        ArrayList<String> plugins = new ArrayList<String>(this.getArgsManager().plugins);
        for (resourceIdx = 0; resourceIdx < rc.size(); ++resourceIdx) {
            path = rc.get(resourceIdx).toString();
            if (this.localPluginDir == null && rc.isWritable(resourceIdx)) {
                this.localPluginDir = new File(path);
            }
            plugins.add(path);
        }
        for (resourceIdx = 0; resourceIdx < plugins.size(); ++resourceIdx) {
            path = plugins.get(resourceIdx).toString();
            this.handlePlugin(path);
        }
    }

    protected void addError(String message, Throwable exc) {
        this.pluginErrorExceptions.add(exc);
        this.pluginErrorMessages.add(message);
    }

    public void handlePlugin(String path) throws Exception {
        if (!this.getArgsManager().pluginsOk) {
            return;
        }
        this.pluginErrorMessages = new ArrayList();
        this.pluginErrorExceptions = new ArrayList();
        File f = new File(path);
        if (path.endsWith(".jar")) {
            this.loadJar(path);
            this.checkForErrors(path);
        } else if (!path.endsWith("index.xml")) {
            if (f.exists() && f.isDirectory()) {
                this.scourPlugins(f);
                File[] files = f.listFiles();
                files = IOUtil.sortFilesOnAge(files, false);
                for (int jarFileIdx = 0; jarFileIdx < files.length; ++jarFileIdx) {
                    if (!this.pluginFileOK(files[jarFileIdx])) continue;
                    String filename = files[jarFileIdx].toString();
                    String decodedFilename = PluginManager.decode(filename);
                    if (IOUtil.getFileTail(decodedFilename).endsWith(".jar")) {
                        this.loadJar(filename);
                    } else {
                        this.loadPlugin(filename, true);
                    }
                    this.checkForErrors(filename);
                }
            } else {
                this.loadPlugin(f.toString(), true);
                this.checkForErrors(f.toString());
            }
        }
    }

    private void checkForErrors(String path) {
        if (this.pluginErrorMessages.size() > 0) {
            path = IOUtil.getFileTail(path);
            LogUtil.printExceptions("<html>Errors have occurred loading plugin:<br><i>" + path + "</i></html>", this.pluginErrorMessages, this.pluginErrorExceptions);
            this.pluginErrorMessages = new ArrayList();
            this.pluginErrorExceptions = new ArrayList();
        }
    }

    protected void loadPlugin(String filename, boolean topLevel) throws Exception {
        if (!this.getArgsManager().pluginsOk) {
            return;
        }
        this.loadPlugin(filename, "", topLevel);
    }

    private void addPluginToList(String file) {
        if (this.localPluginDir != null && this.localPluginDir.equals(new File(file).getParentFile())) {
            if (!this.myPlugins.contains(file)) {
                this.myPlugins.add(file);
            }
        } else if (!this.otherPlugins.contains(file)) {
            this.otherPlugins.add(file);
        }
    }

    public void removePlugin(String file) {
        this.removePlugin(new File(file));
    }

    public void removePlugin(File file) {
        this.myPlugins.remove(file.toString());
        try {
            String deleteThisFile = file + ".deletethis";
            IOUtil.writeFile(deleteThisFile, "");
        }
        catch (Exception exc) {
            System.err.println(exc);
        }
        Plugin p = (Plugin)Plugin.pathToPlugin.get(PluginManager.decode(file));
        if (p != null) {
            p.delete();
        }
        this.updatePlugins();
    }

    protected void loadPlugin(String filename, String prefix, boolean topLevel) throws Exception {
        this.loadPlugin(filename, prefix, topLevel, null);
    }

    protected void loadPlugin(String filename, String prefix, boolean topLevel, String label) throws Exception {
        if (!this.getArgsManager().pluginsOk) {
            return;
        }
        if (this.getArgsManager().isRbiFile(filename)) {
            Element root;
            if (topLevel) {
                this.addPluginToList(filename);
            }
            if ((root = XmlUtil.getRoot(prefix + filename, this.getClass())) != null) {
                this.getResourceManager().processRbi(root, true);
            }
            return;
        }
        String tail = IOUtil.getFileTail(filename);
        List resources = this.getResourceManager().getResources();
        for (int i = 0; i < resources.size(); ++i) {
            Matcher matcher;
            IdvResourceManager.IdvResource idvResource = (IdvResourceManager.IdvResource)resources.get(i);
            Pattern pattern = idvResource.getPattern();
            if (pattern == null || !(matcher = pattern.matcher(filename)).find()) continue;
            if (topLevel) {
                this.addPluginToList(filename);
            }
            ResourceCollection rc = this.getResourceManager().getResources(idvResource);
            String fullPath = prefix + filename;
            if (!(rc.contains(filename) || rc.contains(fullPath) || rc.contains("/" + filename))) {
                rc.addResourceAtStart(fullPath, label);
            }
            return;
        }
        if (filename.endsWith(".properties")) {
            if (topLevel) {
                this.addPluginToList(filename);
            }
            this.getArgsManager().propertyFiles.add(prefix + filename);
            this.getStateManager().loadProperties();
            return;
        }
        if (topLevel) {
            // empty if block
        }
    }

    protected void loadJar(String jarFilePath) {
        this.addPluginToList(jarFilePath);
        Trace.msg("IdvResourceManager.loadJar:" + jarFilePath);
        try {
            String entry;
            int i;
            ++this.jarCnt;
            if (!new File(jarFilePath).exists()) {
                String fileName = PluginManager.encode(jarFilePath);
                String tmpDir = this.getStore().getUserTmpDirectory().toString();
                tmpDir = IOUtil.joinDir(tmpDir, "plugins");
                IOUtil.makeDir(tmpDir);
                File newFile = new File(IOUtil.joinDir(tmpDir, Misc.getUniqueId() + ".jar"));
                byte[] bytes = IOUtil.readBytes(IOUtil.getInputStream(jarFilePath, this.getClass()));
                IOUtil.writeBytes(newFile, bytes);
                jarFilePath = newFile.toString();
            }
            String jarLabel = IOUtil.getFileTail(PluginManager.decode(jarFilePath));
            String prefix = jarFilePath + "!/";
            PluginClassLoader cl = new PluginClassLoader(jarFilePath, this.getClass().getClassLoader()){

                @Override
                protected void handleError(String msg, Throwable exc) {
                    PluginManager.this.addError(msg, exc);
                }

                @Override
                protected void checkClass(Class c) throws Exception {
                    IdvBase.addPluginClass(c);
                    if (DateFormat.class.isAssignableFrom(c) && !Modifier.isPrivate(c.getModifiers())) {
                        DateTime.setDateFormatClass(c);
                    } else if (IOServiceProvider.class.isAssignableFrom(c)) {
                        NetcdfFile.registerIOProvider(c);
                    } else if (CoordSysBuilderIF.class.isAssignableFrom(c)) {
                        CoordSysBuilderIF csbi = (CoordSysBuilderIF)c.newInstance();
                        CoordSysBuilder.registerConvention(csbi.getConventionUsed(), c);
                    } else if (CoordTransBuilder.class.isAssignableFrom(c)) {
                        CoordTransBuilder csbi = (CoordTransBuilder)c.newInstance();
                        CoordTransBuilder.registerTransform(c.getName(), c);
                    } else if (TypedDatasetFactoryIF.class.isAssignableFrom(c)) {
                        TypedDatasetFactoryIF tdfi = (TypedDatasetFactoryIF)c.newInstance();
                        TypedDatasetFactory.registerFactory(tdfi.getScientificDataType(), c);
                    }
                }
            };
            this.pluginClassLoaders.add(cl);
            Misc.addClassLoader(cl);
            List entries = cl.getEntryNames();
            for (i = 0; i < entries.size(); ++i) {
                entry = (String)entries.get(i);
                if (!this.getArgsManager().isRbiFile(entry)) continue;
                this.loadPlugin(entry, prefix, false);
            }
            for (i = 0; i < entries.size(); ++i) {
                entry = (String)entries.get(i);
                if (this.getArgsManager().isRbiFile(entry)) continue;
                if (entry.endsWith(".jar")) {
                    String jarFile = prefix + entry;
                    this.loadJar(jarFile);
                    continue;
                }
                this.loadPlugin(entry, prefix, false, "From: " + jarLabel);
            }
        }
        catch (Exception exc) {
            this.addError("Opening jars", exc);
        }
    }

    public String getPluginHtml() {
        StringBuffer sb = new StringBuffer();
        int cnt = 0;
        for (int i = 0; i < this.myPlugins.size(); ++i) {
            File file = new File(this.myPlugins.get(i).toString());
            if (!file.exists()) continue;
            if (cnt == 0) {
                sb.append("<h3>Plugins</h3>\n<ul>\n");
            }
            ++cnt;
            sb.append("<li>" + file);
        }
        if (cnt > 0) {
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public void importPlugin() {
        String filename = FileManager.getReadFile("Open Plugin", Misc.newList(FileManager.FILTER_JAR), GuiUtils.top(this.mergeCbx));
        if (filename == null) {
            return;
        }
        this.importPlugin(filename, this.mergeCbx.isSelected());
    }

    public void importPlugin(String filename) {
        this.importPlugin(PluginManager.decode(filename), true);
    }

    public void importPlugin(String filename, boolean merge) {
        try {
            this.showCreatePlugin();
            String dir = IOUtil.joinDir(this.getStore().getUserTmpDirectory(), "plugin_" + Misc.getUniqueId());
            IOUtil.makeDir(dir);
            if (!merge) {
                this.createFileList = new Vector();
                this.createList.setListData(this.createFileList);
            }
            if (!filename.toLowerCase().endsWith(".jar")) {
                this.installPlugin(filename, true);
                this.updatePlugins();
                return;
            }
            Pattern bundlesPattern = IdvResourceManager.RSC_BUNDLEXML.getPattern();
            Pattern ctPattern = IdvResourceManager.RSC_COLORTABLES.getPattern();
            String newJarFilePath = IOUtil.joinDir(dir, IOUtil.getFileTail(filename));
            IOUtil.writeTo(IOUtil.getInputStream(filename, this.getClass()), new FileOutputStream(newJarFilePath));
            JarFile jarFile = new JarFile(newJarFilePath);
            List entries = Misc.toList(jarFile.entries());
            List resources = this.getResourceManager().getResources();
            for (int i = 0; i < entries.size(); ++i) {
                JarEntry entry = (JarEntry)entries.get(i);
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                InputStream is = jarFile.getInputStream(entry);
                String cleanName = IOUtil.cleanFileName(name);
                String tmpFile = IOUtil.joinDir(dir, cleanName);
                IOUtil.writeTo(is, new FileOutputStream(tmpFile));
                is.close();
                if (this.getArgsManager().isXidvFile(name) || name.toLowerCase().endsWith("manifest.mf")) continue;
                if (bundlesPattern.matcher(name).find()) {
                    Element root = XmlUtil.getRoot(tmpFile, this.getClass());
                    List<SavedBundle> bundles = SavedBundle.processBundleXml(root, dir, this.getResourceManager(), true);
                    this.addObjects(bundles);
                    continue;
                }
                if (ctPattern.matcher(name).find()) {
                    ColorTableManager ctm = new ColorTableManager();
                    ctm.init(new ResourceCollection("tmp", Misc.newList(tmpFile)));
                    this.addObjects(ctm.getColorTables());
                    continue;
                }
                String label = IOUtil.getFileTail(name);
                for (int resourceIdx = 0; resourceIdx < resources.size(); ++resourceIdx) {
                    IdvResourceManager.IdvResource idvResource = (IdvResourceManager.IdvResource)resources.get(resourceIdx);
                    if (idvResource.getPattern() == null || !idvResource.getPattern().matcher(name).find()) continue;
                    label = idvResource.getDescription() + ":" + label;
                }
                this.addCreateFile(tmpFile, label);
            }
        }
        catch (Throwable exc) {
            PluginManager.logException("Opening plugin", exc);
        }
    }

    public void installPluginFromFile() {
        String filename = FileManager.getReadFile(FileManager.FILTER_JAR);
        if (filename != null) {
            this.installPluginFromFile(filename);
        }
    }

    public void installPluginFromFile(String filename) {
        try {
            this.installPlugin(filename, true);
            this.updatePlugins();
            this.notifyUser();
        }
        catch (Throwable exc) {
            PluginManager.logException("Installing plugin", exc);
        }
    }

    protected void notifyUser() {
        if (!this.getInstallManager().isRestartable()) {
            LogUtil.userMessage("You will need to restart the IDV for this change to take effect");
            return;
        }
        if (GuiUtils.askYesNo("Plugin Confirmation", new JLabel("<html>You will need to restart the IDV for this change to take effect<br>Do you want to restart?"))) {
            try {
                this.getInstallManager().restart();
            }
            catch (Throwable exc) {
                PluginManager.logException("Restarting the IDV", exc);
            }
        }
    }

    public void installPluginFromUrl() {
        String filename = "";
        while ((filename = GuiUtils.getInput("Please enter the URL to an IDV  plugins jar file", "URL: ", filename)) != null && filename.trim().length() != 0) {
            try {
                this.installPlugin(filename, true);
                this.updatePlugins();
                this.notifyUser();
                return;
            }
            catch (Throwable exc) {
                PluginManager.logException("Installing plugin", exc);
                continue;
            }
            break;
        }
        return;
    }

    private void createPluginList() {
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        XmlResourceCollection xrc = idvResourceManager.getXmlResources(IdvResourceManager.RSC_PLUGININDEX);
        double version = this.getStateManager().getNumberVersion();
        for (int i = 0; i < xrc.size(); ++i) {
            String path = xrc.get(i).toString();
            path = IOUtil.getFileRoot(path);
            Element root = xrc.getRoot(i);
            if (root == null) continue;
            List children = XmlUtil.findChildren(root, TAG_PLUGIN);
            for (int pluginIdx = 0; pluginIdx < children.size(); ++pluginIdx) {
                Element pluginNode = (Element)children.get(pluginIdx);
                String name = XmlUtil.getAttribute(pluginNode, ATTR_NAME);
                String desc = XmlUtil.getAttribute((Node)pluginNode, ATTR_DESC, name);
                String size = XmlUtil.getAttribute((Node)pluginNode, ATTR_SIZE, (String)null);
                String url = XmlUtil.getAttribute(pluginNode, ATTR_URL);
                if (IOUtil.isRelativePath(url)) {
                    url = path + "/" + url;
                }
                String category = XmlUtil.getAttribute((Node)pluginNode, ATTR_CATEGORY, "Miscellaneous");
                Plugin plugin = new Plugin(name, desc, url, category);
                plugin.size = size;
                if (!XmlUtil.hasAttribute(pluginNode, ATTR_VERSION)) continue;
                String versionStr = XmlUtil.getAttribute((Node)pluginNode, ATTR_VERSION, "" + version);
                try {
                    plugin.version = new Double(versionStr);
                }
                catch (NumberFormatException nfe) {
                    plugin.version = version;
                }
                plugin.versionOk = plugin.version <= version;
            }
        }
        if (this.localPluginDir != null) {
            this.scourPlugins(this.localPluginDir);
            File[] files = this.localPluginDir.listFiles();
            files = IOUtil.sortFilesOnAge(files, false);
            for (int fileIdx = 0; fileIdx < files.length; ++fileIdx) {
                File file = files[fileIdx];
                if (!this.pluginFileOK(file)) continue;
                new Plugin(file);
            }
        }
    }

    private boolean pluginFileOK(File file) {
        if (file.toString().endsWith(".deletethis")) {
            return false;
        }
        File deleteFile = new File(file.toString() + ".deletethis");
        if (deleteFile.exists()) {
            return false;
        }
        return !file.getName().startsWith(".tmp.");
    }

    private void scourPlugins(File dir) {
        File[] files = dir.listFiles();
        for (int jarFileIdx = 0; jarFileIdx < files.length; ++jarFileIdx) {
            String filename = files[jarFileIdx].toString();
            if (!filename.endsWith(".deletethis")) continue;
            File deleteFile = new File(filename);
            deleteFile.delete();
            deleteFile = new File(IOUtil.stripExtension(filename));
            if (!deleteFile.exists()) continue;
            deleteFile.delete();
        }
    }

    public void installPlugin(final String plugin) {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                PluginManager.this.installPluginInThread(plugin);
            }
        });
    }

    public void installPluginInThread(String plugin) {
        try {
            Plugin p = (Plugin)Plugin.pathToPlugin.get(plugin);
            File f = this.installPlugin(plugin, false);
            if (f == null) {
                return;
            }
            if (p != null) {
                p.install();
                p.file = f;
            }
            this.updatePlugins();
            this.notifyUser();
        }
        catch (Throwable exc) {
            PluginManager.logException("Installing plugin: " + plugin, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File installPlugin(String plugin, boolean andLoad) throws Exception {
        String filename = PluginManager.encode(plugin);
        String tmpFilename = ".tmp." + filename;
        String extDir = IOUtil.joinDir(this.getStore().getUserDirectory().toString(), "plugins");
        File newTmpFile = new File(IOUtil.joinDir(extDir, tmpFilename));
        File newFile = new File(IOUtil.joinDir(extDir, filename));
        Object loadId = JobManager.getManager().startLoad("Installing plugin", true);
        Object bytes = null;
        try {
            URL url = IOUtil.getURL(plugin, this.getClass());
            if (IOUtil.writeTo(url, newTmpFile, loadId) <= 0L) {
                newTmpFile.delete();
                File file = null;
                return file;
            }
            IOUtil.moveFile(newTmpFile, newFile);
        }
        finally {
            JobManager.getManager().stopLoad(loadId);
        }
        if (andLoad) {
            new Plugin(newFile);
        }
        if (andLoad) {
            this.handlePlugin(newFile.toString());
        }
        return newFile;
    }

    private void makePluginDialog() {
        Component[] availableComps = GuiUtils.getHtmlComponent("", this.getIdv(), 700, 300);
        this.availablePluginEditor = (JEditorPane)availableComps[0];
        this.availablePluginScroller = (JScrollPane)availableComps[1];
        Component[] loadedComps = GuiUtils.getHtmlComponent("", this.getIdv(), 700, 200);
        this.loadedPluginEditor = (JEditorPane)loadedComps[0];
        JComponent contents = GuiUtils.vsplit((Component)((JComponent)loadedComps[1]), (Component)((JComponent)availableComps[1]), 150);
        contents.setSize(new Dimension(700, 500));
        JButton closeBtn = GuiUtils.makeButton("Close", this, "closePluginDialog");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(GuiUtils.makeMenuItem("Plugin Manager", this, "showManagerHelp"));
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        fileMenu.add(GuiUtils.makeMenuItem("Install Plugin From File", this, "installPluginFromFile"));
        fileMenu.add(GuiUtils.makeMenuItem("Install Plugin From URL", this, "installPluginFromUrl"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Close", this, "closePluginDialog"));
        String[] keys = new String[]{"/auxdata/ui/icons/add.png", "Install Plugin", "/auxdata/ui/icons/plugin_delete.png", "Delete Plugin", "/auxdata/ui/icons/DocumentOpen16.png", "Send to Plugin Creator", "/auxdata/ui/icons/FindAgain16.gif", "View Contents"};
        ArrayList<JLabel> keyComps = new ArrayList<JLabel>();
        keyComps.add(new JLabel("Key:  "));
        for (int keyIdx = 0; keyIdx < keys.length; keyIdx += 2) {
            keyComps.add(new JLabel(GuiUtils.getImageIcon(keys[keyIdx], this.getClass())));
            keyComps.add(new JLabel(" " + keys[keyIdx + 1] + "  "));
        }
        JPanel bottom = GuiUtils.hbox(keyComps);
        bottom = GuiUtils.inset((Component)bottom, 4);
        contents = GuiUtils.topCenterBottom(menuBar, contents, bottom);
        contents = GuiUtils.centerBottom(contents, GuiUtils.center(GuiUtils.inset((Component)GuiUtils.wrap(closeBtn), 5)));
        this.pluginWindow = GuiUtils.createFrame(GuiUtils.getApplicationTitle() + "Plugin Manager");
        this.pluginWindow.getContentPane().add(contents);
        GuiUtils.decorateFrame(this.pluginWindow, menuBar);
        this.pluginWindow.pack();
        Msg.translateTree(this.pluginWindow);
        this.pluginWindow.setLocation(100, 100);
    }

    public void closePluginDialog() {
        if (this.pluginWindow != null) {
            this.pluginWindow.setVisible(false);
        }
    }

    public static String decode(File f) {
        return PluginManager.decode(f.getName());
    }

    public static String decode(String filename) {
        try {
            return URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println("decoding error:" + uee);
            return null;
        }
    }

    public static String encode(String filename) {
        try {
            return URLEncoder.encode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println("encoding error:" + uee);
            return null;
        }
    }

    public void toggleCategory(String category) {
        Boolean show = (Boolean)this.categoryToggle.get(category);
        show = show == null ? Boolean.FALSE : new Boolean(show == false);
        this.categoryToggle.put(category, show);
        this.updatePlugins(false);
    }

    public void updatePlugins() {
        this.updatePlugins(true);
    }

    public void updatePlugins(boolean doLoaded) {
        boolean firstTime = false;
        if (this.pluginWindow == null) {
            this.makePluginDialog();
            this.createPluginList();
            firstTime = true;
        }
        StringBuffer loadedBuff = new StringBuffer("<b>Installed Plugins</b><br><table width=\"100%\" border=\"0\">");
        ArrayList comps = new ArrayList();
        ArrayList havePlugins = new ArrayList();
        ArrayList pluginComps = new ArrayList();
        ArrayList<String> cats = new ArrayList<String>();
        Hashtable<String, StringBuffer> catBuffs = new Hashtable<String, StringBuffer>();
        for (int i = 0; i < Plugin.plugins.size(); ++i) {
            String encodedPath;
            Plugin plugin = (Plugin)Plugin.plugins.get(i);
            StringBuffer catBuff = (StringBuffer)catBuffs.get(plugin.category);
            if (catBuff == null) {
                catBuff = new StringBuffer();
                cats.add(plugin.category);
                catBuffs.put(plugin.category, catBuff);
            }
            String prefix = "";
            if (plugin.file != null) {
                encodedPath = PluginManager.encode(plugin.file.toString());
                prefix = "&nbsp;<a href=\"jython:idv.getPluginManager().listPlugin('" + encodedPath + "');\"><img src=\"idvresource:/auxdata/ui/icons/FindAgain16.gif\" border=\"0\"></a>";
            } else {
                encodedPath = PluginManager.encode(plugin.url.toString());
                prefix = "&nbsp;";
            }
            prefix = prefix + "<a href=\"jython:idv.getPluginManager().importPlugin('" + encodedPath + "');\"><img alt='Import Plugin into Plugin Creator' src=\"idvresource:/auxdata/ui/icons/DocumentOpen16.png\" border=\"0\"></a>";
            String sizeString = "";
            if (plugin.size != null) {
                int s = new Integer(plugin.size);
                sizeString = "&nbsp;" + HtmlUtil.b(s / 1000 + "KB");
            }
            StringBuffer addDelete = new StringBuffer();
            String installHtml = "<a href=\"jython:idv.getPluginManager().installPlugin('" + plugin.url + "')\">";
            if (!plugin.versionOk) {
                addDelete.append(HtmlUtil.b("requires IDV: " + plugin.version));
            } else if (plugin.deleted) {
                addDelete.append(HtmlUtil.b("removed"));
            } else if (plugin.installed) {
                String extra = "";
                if (plugin.hasOriginal) {
                    extra = installHtml + HtmlUtil.img("idvresource:/auxdata/ui/icons/Refresh16.gif") + "</a>";
                }
                String deleteHtml = "<a href=\"jython:idv.getPluginManager().removePlugin('" + plugin.getFilePath() + "')\">";
                addDelete.append(deleteHtml + HtmlUtil.img("idvresource:/auxdata/ui/icons/plugin_delete.png") + "</a>&nbsp;" + extra);
                loadedBuff.append(HtmlUtil.open("tr", HtmlUtil.attr("valign", "top")));
                loadedBuff.append(HtmlUtil.col(addDelete.toString(), HtmlUtil.attr("width", "50")));
                loadedBuff.append(HtmlUtil.col(plugin.category + "&gt;" + plugin.name));
                loadedBuff.append(HtmlUtil.col(prefix, HtmlUtil.attr("width", "50")));
                loadedBuff.append(HtmlUtil.close("tr"));
            } else {
                addDelete.append(installHtml + HtmlUtil.img("idvresource:/auxdata/ui/icons/add.png"));
            }
            String rowExtra = plugin.installed ? HtmlUtil.attr("bgcolor", "#dddddd") : "";
            catBuff.append(HtmlUtil.open("tr", rowExtra + HtmlUtil.attr("valign", "top")));
            catBuff.append(HtmlUtil.col(addDelete.toString(), HtmlUtil.attrs("width", "10%", "align", "right")));
            catBuff.append(HtmlUtil.col(plugin.name.replace(" ", "&nbsp;"), HtmlUtil.attr("width", "20%")));
            catBuff.append(HtmlUtil.col(plugin.desc, HtmlUtil.attr("width", "50%")));
            catBuff.append(HtmlUtil.col(sizeString, HtmlUtil.attrs("width", "10%", "align", "right")));
            catBuff.append(HtmlUtil.col(prefix, HtmlUtil.attr("width", "10%")));
            catBuff.append(HtmlUtil.close("tr"));
        }
        StringBuffer sb = new StringBuffer("<b>Available Plugins</b><br><table border=\"0\" width=\"100%\">\n");
        for (int i = 0; i < cats.size(); ++i) {
            String category = (String)cats.get(i);
            StringBuffer catBuff = (StringBuffer)catBuffs.get(category);
            Boolean show = (Boolean)this.categoryToggle.get(category);
            if (show == null) {
                show = new Boolean(false);
                this.categoryToggle.put(category, show);
            }
            String toggleHref = "<a href=\"jython:idv.getPluginManager().toggleCategory('" + category + "')\">";
            String catToShow = StringUtil.replace(category, " ", "&nbsp;");
            if (show == null || show.booleanValue()) {
                sb.append("<tr><td colspan=\"3\">" + toggleHref + "<img src=\"idvresource:/auxdata/ui/icons/CategoryOpen.gif\"  border=\"0\"></a>&nbsp; <b><span style=\"xxxxfont-size:18\">" + catToShow + "</span></b></td></tr>");
                sb.append(catBuff.toString());
                continue;
            }
            sb.append("<tr><td colspan=\"3\">" + toggleHref + "<img src=\"idvresource:/auxdata/ui/icons/CategoryClosed.gif\" border=\"0\"></a>&nbsp; <b><span style=\"xxxxfont-size:18\">" + catToShow + "</span></b></td></tr>");
        }
        sb.append("</table>");
        loadedBuff.append("</table>");
        if (doLoaded) {
            this.loadedPluginEditor.setText(loadedBuff.toString());
            this.loadedPluginEditor.invalidate();
            this.loadedPluginEditor.repaint();
        }
        this.availablePluginEditor.setVisible(false);
        this.availablePluginEditor.setText(sb.toString());
        this.availablePluginEditor.invalidate();
        this.availablePluginEditor.setVisible(true);
        this.availablePluginEditor.repaint();
        if (firstTime) {
            GuiUtils.showDialogNearSrc(null, this.pluginWindow);
        } else {
            this.pluginWindow.setVisible(true);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Error:  Usage: PluginManager jarfile <file1 file2 ...>");
            System.exit(1);
        }
        List files = Misc.toList(args);
        files.remove(0);
        IOUtil.writeJarFile(args[0], files, "/foo/bar");
    }

    private static class Wrapper {
        Object obj;
        String label = "";

        public Wrapper(Object obj) {
            this(obj, null);
        }

        public Wrapper(Object obj, String label) {
            this.obj = obj;
            if (label == null) {
                this.setLabel(obj, true);
            } else {
                this.label = label;
            }
        }

        private void setLabel(Object obj, boolean addObj) {
            String suffix = "";
            if (addObj) {
                suffix = ": ";
            }
            if (obj instanceof ColorTable) {
                this.label = "Color Table" + suffix + (addObj ? obj.toString() : "");
            } else if (obj instanceof StationModel) {
                this.label = "Layout Model" + suffix + (addObj ? obj.toString() : "");
            } else if (obj instanceof SavedBundle) {
                SavedBundle bundle = (SavedBundle)obj;
                this.label = addObj ? "Bundle" + suffix + bundle.getLabel() : "Bundle" + suffix;
            } else if (obj instanceof Projection) {
                this.label = "Projection" + suffix + (addObj ? obj.toString() : "");
            } else if (obj instanceof DerivedDataDescriptor) {
                this.label = "Formula" + suffix + (addObj ? obj.toString() : "");
            } else if (obj instanceof ParamInfo) {
                this.label = "Param Default" + suffix + (addObj ? obj.toString() : "");
            } else if (obj instanceof DisplaySetting) {
                this.label = "Display Setting" + suffix + (addObj ? obj.toString() : "");
            } else if (obj instanceof DataGroup) {
                this.label = "Param Group" + suffix + (addObj ? obj.toString() : "");
            } else if (obj instanceof List) {
                List l = (List)obj;
                if (l.size() > 0) {
                    this.setLabel(l.get(0), false);
                }
            } else if (obj.toString().endsWith(".py")) {
                this.label = "Jython" + suffix + (addObj ? obj.toString() : "");
            } else {
                this.label = obj.toString();
                return;
            }
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Wrapper)) {
                return false;
            }
            return Misc.equals(this.obj, ((Wrapper)o).obj);
        }
    }

    private static class Plugin {
        static Hashtable pathToPlugin = new Hashtable();
        static List plugins = new ArrayList();
        File file;
        boolean deleted = false;
        boolean installed = false;
        String name;
        String desc;
        String url;
        String category;
        boolean versionOk = true;
        double version = Double.MAX_VALUE;
        boolean hasOriginal = false;
        String size;

        public Plugin(String name, String desc, String url, String category) {
            this.name = name;
            this.desc = desc;
            this.url = url;
            this.hasOriginal = true;
            this.category = category;
            pathToPlugin.put(url, this);
            plugins.add(this);
        }

        public Plugin(File f) {
            this.file = f;
            this.url = PluginManager.decode(f);
            Plugin p = (Plugin)pathToPlugin.get(this.url);
            this.installed = true;
            if (p != null) {
                this.size = p.size;
                this.name = p.name;
                this.desc = p.desc;
                this.category = p.category;
                this.hasOriginal = p.hasOriginal;
                int index = plugins.indexOf(p);
                plugins.remove(p);
                plugins.add(index, this);
            } else {
                this.category = "Miscellaneous";
                this.name = IOUtil.getFileTail(this.url);
                this.desc = "";
                plugins.add(this);
            }
            pathToPlugin.put(this.url, this);
        }

        public void install() {
            this.deleted = false;
            this.installed = true;
        }

        public void delete() {
            this.installed = false;
            this.deleted = true;
        }

        public String getFilePath() {
            String path = this.file.toString();
            path = path.replaceAll("\\\\", "/");
            return path;
        }

        public String toString() {
            return this.name + " installed:" + this.installed + " deleted:" + this.deleted;
        }
    }

    private static class PropertyInfo {
        String delimiter;
        String key;
        String value;
        String label;
        JComponent widget;
        JComponent outerWidget;

        public PropertyInfo() {
        }

        public PropertyInfo(String key, String value, JComponent widget) {
            this.key = key;
            this.value = value;
            this.widget = widget;
        }

        public JComponent getComponentToDisplay() {
            if (this.outerWidget != null) {
                return this.outerWidget;
            }
            return this.widget;
        }
    }
}

