/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.Hashtable;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.HttpServer;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;

public class OneInstanceServer
extends HttpServer {
    public static final String ARG_ARGS = "args";
    IntegratedDataViewer idv;
    InetAddress localHost;

    public OneInstanceServer(IntegratedDataViewer idv, int port) {
        super(port);
        this.idv = idv;
    }

    @Override
    protected void handleError(String msg, Exception exc) {
        LogUtil.consoleMessage(msg);
        LogUtil.consoleMessage("Exception:" + exc);
    }

    static String assembleUrl(int port, String[] args) throws Exception {
        return "http://localhost:" + port + "?" + ARG_ARGS + "=" + URLEncoder.encode(XmlUtil.encodeBase64(Misc.serialize((Serializable)args)), "UTF-8");
    }

    @Override
    protected HttpServer.RequestHandler doMakeRequestHandler(Socket socket) throws Exception {
        InetAddress inet;
        if (this.localHost == null) {
            this.localHost = InetAddress.getLocalHost();
        }
        if (!(inet = socket.getInetAddress()).getHostAddress().equals("127.0.0.1")) {
            return null;
        }
        return new OneInstanceRequestHandler(this.idv, this, socket);
    }

    public static class OneInstanceRequestHandler
    extends HttpServer.RequestHandler {
        IntegratedDataViewer idv;

        public OneInstanceRequestHandler(IntegratedDataViewer idv, HttpServer server, Socket socket) throws Exception {
            super(server, socket);
            this.idv = idv;
        }

        @Override
        protected void handleRequest(String path, Hashtable formArgs, Hashtable httpArgs, String content) throws Exception {
            String argStr = (String)formArgs.get(OneInstanceServer.ARG_ARGS);
            byte[] argBytes = XmlUtil.decodeBase64(argStr);
            String[] args = (String[])Misc.deserialize(argBytes);
            this.writeResult(true, "ok", "text");
            this.idv.getArgsManager().processInstanceArgs(args);
            this.idv.getIdvUIManager().toFrontMainWindows();
        }
    }
}

