/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.LayoutUtil;
import ucar.unidata.util.Misc;

public class OldVersionCheck {
    private static final String IDV_VERSION_URL = "https://docs.unidata.ucar.edu/idv/docs/javadoc/index.html";
    private static final IDVVersion currentIDVVersion = OldVersionCheck.getCurrentIDVVersion();

    public static void check(IntegratedDataViewer idv) throws Exception {
        String oldVersionKey = "idv_old_version_" + OldVersionCheck.getIDVVersion().stringForShell() + "_" + currentIDVVersion.stringForShell() + "_dontwarn";
        Object oldVersionDontWarn = idv.getPreference(oldVersionKey);
        boolean dontShowOldWarn = Boolean.parseBoolean(oldVersionDontWarn == null ? false + "" : oldVersionDontWarn.toString());
        boolean dontShowOldWarnRsp = false;
        if (OldVersionCheck.isIDVold() && !dontShowOldWarn) {
            dontShowOldWarnRsp = OldVersionCheck.showOldVersionMessage();
        }
        if (dontShowOldWarnRsp) {
            idv.getStore().put(oldVersionKey, dontShowOldWarnRsp);
        }
    }

    private static String getHTML() {
        return "<!doctype html>\n<html lang=\"en\">\n<head>\n  <meta charset=\"utf-8\">\n  <title>New IDV Version</title>\n  <meta name=\"New IDV Version\" content=\"New IDV Version\">\n</head>\n<body>\n<p>There is a new verion of the IDV (" + currentIDVVersion + ") available.</p>" + "<a href=\"http://www.unidata.ucar.edu/downloads/idv/current/index.jsp\">Download now</a>." + "</body>\n" + "</html>";
    }

    private static boolean showOldVersionMessage() {
        JEditorPane ep = new JEditorPane("text/html", OldVersionCheck.getHTML());
        JCheckBox cb = new JCheckBox("Don't show again");
        CheckboxListener cbl = new CheckboxListener(cb);
        cb.addItemListener(cbl);
        JPanel doLayout = LayoutUtil.doLayout(new Component[]{ep, cb}, 1, LayoutUtil.WT_Y, LayoutUtil.WT_Y);
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    Desktop desktop;
                    Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                        try {
                            desktop.browse(e.getURL().toURI());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        ep.setEditable(false);
        ep.setBackground(new JLabel().getBackground());
        JOptionPane.showOptionDialog(null, doLayout, "New IDV Version", 2, 1, null, new String[]{"Close"}, "default");
        return cbl.show;
    }

    private static boolean isIDVold() {
        IDVVersion currentVersion;
        IDVVersion thisVersion = OldVersionCheck.getIDVVersion();
        return thisVersion.compareTo(currentVersion = currentIDVVersion) > 0;
    }

    static IDVVersion getIDVVersion() {
        Properties properties = new Properties();
        Misc.readProperties("/ucar/unidata/idv/resources/version.properties", properties, OldVersionCheck.class);
        return new IDVVersion(properties.getProperty("idv.version.major") + "." + properties.getProperty("idv.version.minor") + properties.getProperty("idv.version.revision"));
    }

    static IDVVersion getCurrentIDVVersion() {
        StringBuilder response = new StringBuilder();
        try {
            String inputLine;
            URL website = new URL(IDV_VERSION_URL);
            URLConnection connection = website.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (MalformedURLException e) {
            return OldVersionCheck.getIDVVersion();
        }
        catch (IOException e) {
            return OldVersionCheck.getIDVVersion();
        }
        return OldVersionCheck.parseOutVersion(response.toString());
    }

    static IDVVersion parseOutVersion(String response) {
        Pattern p = Pattern.compile("Unidata IDV API v\\d+\\.\\d+([a-z][0-9a-zA-Z])?");
        String version = "";
        Matcher matcher = p.matcher(response);
        while (matcher.find()) {
            version = matcher.group(0);
        }
        String[] parts = version.split("\\s+");
        if (parts.length == 0) {
            return OldVersionCheck.getIDVVersion();
        }
        String first = parts[parts.length - 1];
        if (first.length() > 0) {
            String v = first.substring(1);
            return new IDVVersion(v);
        }
        return OldVersionCheck.getIDVVersion();
    }

    static class IDVVersion
    implements Comparable<IDVVersion> {
        private int version;
        private String versionStr;

        IDVVersion(String major, String minor, String revisionChar, String revisionNum) {
            this.idvVersionInternal(major, minor, revisionChar, revisionNum);
        }

        IDVVersion(String idvversion) {
            String[] parts = idvversion.split("\\.");
            String major = parts[0];
            String[] parts2 = parts[1].split("[a-z]");
            String minor = parts2[0];
            String revisionChar = null;
            String revisionNum = null;
            String[] rev = idvversion.split(major + "." + minor);
            if (rev.length > 1) {
                String r = rev[1];
                revisionChar = r.substring(0, 1);
                revisionNum = r.substring(1, r.length());
            }
            this.idvVersionInternal(major, minor, revisionChar, revisionNum);
        }

        private void idvVersionInternal(String major, String minor, String revisionChar, String revisionNum) {
            int mjr = Integer.parseInt(major.trim());
            int mnr = Integer.parseInt(minor.trim());
            String revStr = revisionChar == null || revisionNum == null ? "" : (revisionChar + revisionNum).trim();
            int revChar = IDVVersion.digitizeRevisionChar(revisionChar == null ? "" : revisionChar.trim());
            int revNum = IDVVersion.digitizeRevisionNum(revisionNum == null ? "" : revisionNum.trim());
            this.version = revNum + (revChar << 8) + (mnr << 16) + (mjr << 24);
            this.versionStr = mjr + "." + mnr + revStr;
        }

        @Override
        public int compareTo(IDVVersion o) {
            int v2 = o.version;
            int v1 = this.version;
            if (v2 == v1) {
                return 0;
            }
            if (v1 > v2) {
                return -1;
            }
            if (this.equals(o)) {
                return 0;
            }
            return 1;
        }

        private static int digitizeRevisionChar(String c) {
            if (c.equals("")) {
                return 0;
            }
            if (c.equals("b")) {
                return 1;
            }
            if (c.equals("u")) {
                return 2;
            }
            return 3;
        }

        private static int digitizeRevisionNum(String n) {
            try {
                return Integer.parseInt(n);
            }
            catch (NumberFormatException e) {
                return 255;
            }
        }

        public String toString() {
            return this.versionStr;
        }

        String stringForShell() {
            return this.toString().replaceAll("\\.|\\s+", "_");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.version;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IDVVersion other = (IDVVersion)obj;
            return this.version == other.version;
        }
    }

    private static final class CheckboxListener
    implements ItemListener {
        private JCheckBox cb;
        private boolean show = false;

        CheckboxListener(JCheckBox cb) {
            this.cb = cb;
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            this.show = this.cb.isSelected();
        }
    }
}

