/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import ucar.unidata.collab.Sharable;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.ui.CursorReadoutWindow;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.util.BooleanProperty;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.NavigatedDisplayCursorReadout;
import ucar.unidata.view.geoloc.NavigatedDisplayToolBar;
import ucar.unidata.view.geoloc.VertScaleDialog;
import ucar.unidata.view.geoloc.VertScaleInfo;
import ucar.unidata.view.geoloc.ViewpointControl;
import ucar.visad.Util;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.RubberBandBox;
import visad.ActionImpl;
import visad.ControlEvent;
import visad.CoordinateSystem;
import visad.DisplayEvent;
import visad.Gridded2DSet;
import visad.Unit;
import visad.VisADException;

public abstract class NavigatedViewManager
extends ViewManager {
    public static final String CMD_NAV_DOWN = "cmd.nav.down";
    public static final String CMD_NAV_HOME = "cmd.nav.home";
    public static final String CMD_NAV_LEFT = "cmd.nav.left";
    public static final String CMD_NAV_RIGHT = "cmd.nav.right";
    public static final String CMD_NAV_ROTATELEFT = "cmd.nav.rotateleft";
    public static final String CMD_NAV_ROTATERIGHT = "cmd.nav.rotateright";
    public static final String CMD_NAV_SMALLDOWN = "cmd.nav.small.down";
    public static final String CMD_NAV_SMALLLEFT = "cmd.nav.small.left";
    public static final String CMD_NAV_SMALLRIGHT = "cmd.nav.small.right";
    public static final String CMD_NAV_SMALLROTATELEFT = "cmd.nav.small.rotateleft";
    public static final String CMD_NAV_SMALLROTATERIGHT = "cmd.nav.small.rotateright";
    public static final String CMD_NAV_SMALLTILTDOWN = "cmd.nav.small.tiltdown";
    public static final String CMD_NAV_SMALLTILTUP = "cmd.nav.small.tiltup";
    public static final String CMD_NAV_SMALLUP = "cmd.nav.small.up";
    public static final String CMD_NAV_SMALLZOOMIN = "cmd.nav.small.zoomin";
    public static final String CMD_NAV_SMALLZOOMOUT = "cmd.nav.small.zoomout";
    public static final String CMD_NAV_UP = "cmd.nav.up";
    public static final String CMD_NAV_ZOOMIN = "cmd.nav.zoomin";
    public static final String CMD_NAV_ZOOMOUT = "cmd.nav.zoomout";
    public static final String PROP_VERTICALRANGE = "idv.viewmanager.verticalrange";
    public static final String SHARE_MATRIX = "MapViewManager.SHARE_MATRIX";
    public static final String SHARE_RUBBERBAND = "NavigatedViewManager.SHARE_RUBBERBAND";
    public static final double ZOOM_FACTOR = 1.2;
    public static final double TRANSLATE_FACTOR = 0.1;
    private double[] lastSharedMatrix = null;
    private long mouseMovedTime = -1L;
    private long mousePressedTime = -1L;
    private Unit tmpVertRangeUnit = null;
    protected CursorReadoutWindow cursorReadoutWindow;
    private double[] lastVerticalRange;
    private Unit lastVerticalRangeUnit;
    private Point mouseStartPoint;
    private NavigatedDisplayCursorReadout readout;
    private double[] startMoveMatrix;
    private double[] tmpVerticalRange;
    private VertScaleDialog vertRangeWidget;
    private ViewpointControl viewpointControl;

    public NavigatedViewManager() {
    }

    public NavigatedViewManager(ViewContext viewContext) {
        super(viewContext);
    }

    public NavigatedViewManager(ViewContext viewContext, ViewDescriptor desc, String properties) throws VisADException, RemoteException {
        super(viewContext, desc, properties);
    }

    private void initVerticalRange() {
        List<String> toks;
        String typeName = this.getTypeName().toLowerCase();
        String verticalRangeStr = this.getIdv().getProperty("idv.viewmanager." + typeName + ".verticalrange", null);
        if (verticalRangeStr != null && (toks = StringUtil.split(verticalRangeStr, ",", true, true)).size() >= 2) {
            this.tmpVerticalRange = new double[]{new Double(toks.get(0).toString()), new Double(toks.get(1).toString())};
            if (toks.size() == 3) {
                try {
                    this.tmpVertRangeUnit = Util.parseUnit(toks.get(2).toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public NavigatedDisplay getNavigatedDisplay() {
        return (NavigatedDisplay)this.getMaster();
    }

    @Override
    protected void setDisplayMaster(DisplayMaster master) {
        super.setDisplayMaster(master);
        try {
            NavigatedDisplay navDisplay = (NavigatedDisplay)master;
            if (this.tmpVertRangeUnit != null) {
                navDisplay.setVerticalRangeUnit(this.tmpVertRangeUnit);
            }
            if (this.tmpVerticalRange != null) {
                navDisplay.setVerticalRange(this.tmpVerticalRange[0], this.tmpVerticalRange[1]);
            }
            navDisplay.setCursorStringOn(false);
            final RubberBandBox rbb = navDisplay.getRubberBandBox();
            if (rbb != null) {
                rbb.addAction(new ActionImpl("Box Change"){

                    @Override
                    public void doAction() throws VisADException, RemoteException {
                        Gridded2DSet bounds = rbb.getBounds();
                        if (bounds != null) {
                            NavigatedViewManager.this.rubberBandBoxChanged();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.logException("setDisplayMaster", e);
        }
    }

    @Override
    protected void init() throws VisADException, RemoteException {
        if (this.getHaveInitialized()) {
            return;
        }
        super.init();
        this.initVerticalRange();
        if (this.isInteractive()) {
            if (this.readout == null) {
                this.readout = new NavigatedDisplayCursorReadout(this.getNavigatedDisplay(), null){

                    @Override
                    protected JLabel getValueDisplay() {
                        IdvWindow window;
                        JLabel label = super.getValueDisplay();
                        if (label == null && (window = IdvWindow.findWindow(NavigatedViewManager.this.fullContents)) != null) {
                            label = window.getMsgLabel();
                            this.setValueDisplay(label);
                        }
                        return label;
                    }
                };
            }
            this.readout.setActive(this.getShowCursor());
            IdvWindow myWindow = IdvWindow.findWindow(this.fullContents);
            this.initReadout(myWindow);
        }
    }

    @Override
    protected void initWithInner(ViewManager that, boolean ignoreWindow) throws VisADException, RemoteException {
        if (!(that instanceof NavigatedViewManager)) {
            return;
        }
        super.initWithInner(that, ignoreWindow);
        NavigatedViewManager nvm = (NavigatedViewManager)that;
        if (this != that) {
            double[] verticalRange;
            Unit verticalRangeUnit = nvm.getVerticalRangeUnit();
            if (verticalRangeUnit != null) {
                this.setVerticalRangeUnit(verticalRangeUnit);
            }
            if ((verticalRange = nvm.getVerticalRange()) != null) {
                this.setVerticalRange(verticalRange);
            }
        }
    }

    private void initReadout(IdvWindow w) {
        if (w != null && this.readout != null) {
            this.readout.setValueDisplay(w.getMsgLabel());
        }
        this.setReadoutFormat();
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        if (this.vertRangeWidget == null) {
            return false;
        }
        boolean b = this.vertRangeWidget.isAxisVisible();
        return this.vertRangeWidget.doApply();
    }

    @Override
    protected void addPropertiesComponents(JTabbedPane tabbedPane) {
        super.addPropertiesComponents(tabbedPane);
        this.vertRangeWidget = this.getViewpointControl().makeVerticalRangeWidget(this.getNavigatedDisplay().getVerticalRangeVisible());
        tabbedPane.add("Vertical Scale", GuiUtils.topLeft(this.vertRangeWidget));
    }

    @Override
    protected void initToolBars() {
        this.addToolBar(this.doMakeZoomPanToolBar(1), "zoompan", "Zoom/Pan toolbar");
        JButton backButton = this.getCommandManager().getBackButton();
        JButton forwardButton = this.getCommandManager().getForwardButton();
        backButton.setToolTipText("<html>Undo the viewpoint/projection change<br>Shift-click to go 10 steps back</html>");
        forwardButton.setToolTipText("<html>Redo the viewpoint/projection change<br>Shift-click to go 10 steps forward</html>");
        JToolBar undoToolbar = new JToolBar(1);
        undoToolbar.setFloatable(this.getToolbarsFloatable());
        undoToolbar.add(backButton);
        undoToolbar.add(forwardButton);
        this.addToolBar(GuiUtils.top(undoToolbar), "undoredo", "Undo/Redo toolbar");
    }

    protected boolean hasViewpointControl() {
        return this.viewpointControl != null;
    }

    protected ViewpointControl getViewpointControl() {
        if (this.viewpointControl == null) {
            ViewpointControl tmp = new ViewpointControl(this.getNavigatedDisplay()){

                @Override
                public void changePerspectiveView(boolean v) {
                    if (NavigatedViewManager.this.viewpointControl == null) {
                        return;
                    }
                    super.changePerspectiveView(v);
                    NavigatedViewManager.this.perspectiveViewChanged(v);
                }

                @Override
                protected void applyVerticalRange(VertScaleInfo transfer) throws Exception {
                    if (NavigatedViewManager.this.viewpointControl == null) {
                        return;
                    }
                    super.applyVerticalRange(transfer);
                    NavigatedViewManager.this.verticalRangeChanged();
                }
            };
            tmp.setPerspectiveView(this.getPerspectiveView());
            this.viewpointControl = tmp;
        }
        return this.viewpointControl;
    }

    protected void perspectiveViewChanged(boolean v) {
        this.updateDisplayList();
        this.updateAnnotations();
    }

    protected void verticalScaleChanged() {
    }

    @Override
    public void destroy() {
        this.viewpointControl = null;
        if (this.readout != null) {
            this.readout.destroy();
        }
        this.readout = null;
        super.destroy();
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (!this.getInitDone()) {
            return;
        }
        if (from != null && !from.getClass().equals(this.getClass())) {
            return;
        }
        if (dataId.equals(SHARE_MATRIX)) {
            try {
                this.lastSharedMatrix = (double[])data[0];
                this.setDisplayMatrix(this.lastSharedMatrix);
                this.matrixChanged();
            }
            catch (Exception e) {
                this.logException("setDisplayMatrix", e);
            }
            return;
        }
        if (dataId.equals(SHARE_RUBBERBAND)) {
            this.notifyDisplayControls(SHARE_RUBBERBAND);
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    protected void rubberBandBoxChanged() throws VisADException {
        if (!this.getInitDone()) {
            return;
        }
        this.doShare((Object)SHARE_RUBBERBAND, "");
        this.notifyDisplayControls(SHARE_RUBBERBAND);
    }

    @Override
    protected void handleControlChanged(ControlEvent e) {
        this.checkHistoryMatrix();
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        if (!(this.lastVerticalRangeUnit == null || this.lastVerticalRange == null || Misc.equals(this.lastVerticalRangeUnit, navDisplay.getVerticalRangeUnit()) && Arrays.equals(this.lastVerticalRange, navDisplay.getVerticalRange()))) {
            this.verticalRangeChanged();
        }
        this.lastVerticalRangeUnit = navDisplay.getVerticalRangeUnit();
        this.lastVerticalRange = navDisplay.getVerticalRange();
        super.handleControlChanged(e);
    }

    @Override
    public void displayChanged(DisplayEvent de) throws VisADException, RemoteException {
        MouseEvent mouseEvent;
        if (this.getIsDestroyed()) {
            return;
        }
        int eventId = de.getId();
        InputEvent inputEvent = de.getInputEvent();
        if (inputEvent instanceof MouseEvent && eventId == 1) {
            this.mousePressedTime = System.currentTimeMillis();
            this.getViewpointControl().setAutoRotate(false);
            this.startMoveMatrix = this.getProjectionControl().getMatrix();
            mouseEvent = (MouseEvent)inputEvent;
            this.mouseStartPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.getClickCount() > 1 && mouseEvent.isShiftDown()) {
                NavigatedDisplay navDisplay = this.getNavigatedDisplay();
                double[] box = navDisplay.getSpatialCoordinatesFromScreen(mouseEvent.getX(), mouseEvent.getY());
                navDisplay.center(navDisplay.getEarthLocation(box));
            }
        }
        if (eventId == 1 || eventId == 18) {
            this.mouseMovedTime = System.currentTimeMillis();
            mouseEvent = (MouseEvent)inputEvent;
            int[][][] functionMap = this.getMaster().getMouseFunctionMap();
            if (functionMap != null) {
                int shiftIdx;
                int ctrlIdx = GuiUtils.isControlKey(mouseEvent) ? 1 : 0;
                int n = shiftIdx = mouseEvent.isShiftDown() ? 1 : 0;
                int mouseIdx = SwingUtilities.isLeftMouseButton(mouseEvent) && !SwingUtilities.isRightMouseButton(mouseEvent) ? 0 : (SwingUtilities.isMiddleMouseButton(mouseEvent) ? 1 : (SwingUtilities.isRightMouseButton(mouseEvent) && !SwingUtilities.isLeftMouseButton(mouseEvent) ? 2 : 1));
                int function = functionMap[mouseIdx][ctrlIdx][shiftIdx];
                if (function == 3) {
                    if (this.cursorReadoutWindow == null) {
                        this.cursorReadoutWindow = new CursorReadoutWindow(this);
                    }
                    this.cursorReadoutWindow.handleMousePressedOrDragged(mouseEvent);
                }
            }
        } else if (eventId == 7) {
            Point mouseStart;
            mouseEvent = (MouseEvent)inputEvent;
            if (this.cursorReadoutWindow != null) {
                this.cursorReadoutWindow.handleMouseReleased(mouseEvent);
                this.cursorReadoutWindow = null;
            }
            if ((mouseStart = this.mouseStartPoint) != null) {
                Point toPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                double distance = GuiUtils.distance(mouseStart.x, mouseStart.y, toPoint.x, toPoint.y);
                long deltaTime = System.currentTimeMillis() - this.mouseMovedTime;
                if (System.currentTimeMillis() - this.mousePressedTime > 0L) {
                    double speed = distance / (double)(System.currentTimeMillis() - this.mousePressedTime);
                    if (distance > 50.0 && deltaTime < 200L && speed > 0.5) {
                        double[] endMatrix = this.getProjectionControl().getMatrix();
                        this.mouseFlicked(mouseStart, toPoint, this.startMoveMatrix, endMatrix, speed);
                    }
                }
            }
            this.mouseMovedTime = -1L;
        }
        super.displayChanged(de);
    }

    protected void mouseFlicked(Point startPoint, Point endPoint, double[] startMatrix, double[] endMatrix, double speed) {
    }

    @Override
    protected void animationTimeChanged() {
        super.animationTimeChanged();
        if (this.cursorReadoutWindow != null) {
            this.cursorReadoutWindow.updateReadout();
        }
    }

    protected void matrixChanged() {
    }

    protected void verticalRangeChanged() {
    }

    protected void setReadoutFormat() {
        String format;
        if (this.readout != null && (format = (String)this.getStore().get("Data.LatLonFormat")) != null) {
            this.readout.setFormatPattern(format);
        }
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
        this.setReadoutFormat();
    }

    @Override
    protected void handleBooleanPropertyChange(String id, boolean value) throws Exception {
        if (id.equals("View.ShowCursor")) {
            if (this.readout != null) {
                this.readout.setActive(value);
            }
        } else if (id.equals("View.3Dclip")) {
            if (this.hasDisplayMaster()) {
                this.getNavigatedDisplay().enableClipping(value);
            }
        } else {
            super.handleBooleanPropertyChange(id, value);
        }
    }

    @Override
    protected void getInitialBooleanProperties(List props) {
        super.getInitialBooleanProperties(props);
        props.add(new BooleanProperty("View.3Dclip", "Clip View At Box", "", false));
        props.add(new BooleanProperty("View.ShowCursor", "Show Cursor Readout", "", true));
        props.add(new BooleanProperty("View.ShowDisplayList", "Show Display List", "", false));
    }

    protected void checkHistoryMatrix() {
        try {
            if (!this.getInitDone()) {
                return;
            }
            double[] newMatrix = this.getProjectionControl().getMatrix();
            if (this.lastSharedMatrix == null || !Arrays.equals(newMatrix, this.lastSharedMatrix)) {
                this.matrixChanged();
                if (this.lastSharedMatrix != null && !this.getCommandManager().getApplyingCommand() && !this.mouseDown) {
                    this.addCommand(new ViewManager.MatrixCommand(this, this.lastSharedMatrix, this.getMaster().getProjectionMatrix()));
                }
                this.lastSharedMatrix = newMatrix;
                this.doShare((Object)SHARE_MATRIX, (Object)newMatrix);
            }
        }
        catch (Exception exc) {
            this.logException("controlChanged", exc);
        }
    }

    @Override
    public void setWindow(IdvWindow w) {
        super.setWindow(w);
        this.initReadout(w);
    }

    public Component doMakeViewPointToolBar(int orientation) {
        JToolBar toolbar = this.getViewpointControl().getToolBar(this.getToolbarsFloatable());
        toolbar.setOrientation(orientation);
        return GuiUtils.top(toolbar);
    }

    protected Component doMakeZoomPanToolBar(int orientation) {
        NavigatedDisplayToolBar toolbar = this.getNavigatedDisplay().getNavigationToolBar(orientation, this.getToolbarsFloatable());
        return GuiUtils.top(toolbar);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(CMD_NAV_ZOOMIN)) {
            this.getNavigatedDisplay().zoom(1.2);
        } else if (cmd.equals(CMD_NAV_ROTATELEFT)) {
            this.getNavigatedDisplay().rotateZ(-5.0);
        } else if (cmd.equals(CMD_NAV_ROTATERIGHT)) {
            this.getNavigatedDisplay().rotateZ(5.0);
        } else if (cmd.equals(CMD_NAV_ZOOMOUT)) {
            this.getNavigatedDisplay().zoom(0.8333333333333334);
        } else if (cmd.equals(CMD_NAV_HOME)) {
            try {
                this.getNavigatedDisplay().resetProjection();
            }
            catch (Exception exception) {}
        } else if (cmd.equals(CMD_NAV_RIGHT)) {
            this.getNavigatedDisplay().translate(-0.1, 0.0);
        } else if (cmd.equals(CMD_NAV_LEFT)) {
            this.getNavigatedDisplay().translate(0.1, 0.0);
        } else if (cmd.equals(CMD_NAV_UP)) {
            this.getNavigatedDisplay().translate(0.0, -0.1);
        } else if (cmd.equals(CMD_NAV_DOWN)) {
            this.getNavigatedDisplay().translate(0.0, 0.1);
        } else if (cmd.equals(CMD_NAV_SMALLZOOMIN)) {
            this.getNavigatedDisplay().zoom(1.2);
        } else if (cmd.equals(CMD_NAV_SMALLZOOMOUT)) {
            this.getNavigatedDisplay().zoom(0.8333333333333334);
        } else if (cmd.equals(CMD_NAV_SMALLROTATELEFT)) {
            this.getNavigatedDisplay().rotateZ(-2.0);
        } else if (cmd.equals(CMD_NAV_SMALLROTATERIGHT)) {
            this.getNavigatedDisplay().rotateZ(2.0);
        } else if (cmd.equals(CMD_NAV_SMALLTILTUP)) {
            this.getNavigatedDisplay().rotateX(-2.0);
        } else if (cmd.equals(CMD_NAV_SMALLTILTDOWN)) {
            this.getNavigatedDisplay().rotateX(2.0);
        } else if (cmd.equals(CMD_NAV_SMALLRIGHT)) {
            this.getNavigatedDisplay().translate(-0.02, 0.0);
        } else if (cmd.equals(CMD_NAV_SMALLLEFT)) {
            this.getNavigatedDisplay().translate(0.02, 0.0);
        } else if (cmd.equals(CMD_NAV_SMALLUP)) {
            this.getNavigatedDisplay().translate(0.0, -0.02);
        } else if (cmd.equals(CMD_NAV_SMALLDOWN)) {
            this.getNavigatedDisplay().translate(0.0, 0.02);
        } else {
            super.actionPerformed(event);
            return;
        }
        this.checkHistoryMatrix();
    }

    @Override
    protected JMenu makeShowMenu() {
        JMenu showMenu = super.makeShowMenu();
        this.createCBMI(showMenu, "View.3Dclip");
        this.createCBMI(showMenu, "View.ShowCursor");
        return showMenu;
    }

    public void setShowCursor(boolean value) {
        this.setBp("View.ShowCursor", value);
    }

    public boolean getShowCursor() {
        return this.getBp("View.ShowCursor");
    }

    public void setLabelsVisible(boolean value) {
        this.setBp("View.ShowScales", value);
    }

    public boolean getLabelsVisible() {
        return this.getBp("View.ShowScales");
    }

    public void setTransectLabelsVisible(boolean value) {
        this.setBp("View.ShowTransectScales", value);
    }

    public boolean getTransectLabelsVisible() {
        return this.getBp("View.ShowTransectScales");
    }

    public void setClipping(boolean value) {
        this.setBp("View.3Dclip", value);
    }

    public boolean getClipping() {
        return this.getBp("View.3Dclip");
    }

    public void setVerticalRangeUnit(Unit u) {
        this.tmpVertRangeUnit = u;
        if (u == null) {
            return;
        }
        if (!this.hasDisplayMaster()) {
            return;
        }
        try {
            this.getNavigatedDisplay().setVerticalRangeUnit(u);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Unit getVerticalRangeUnit() {
        if (!this.hasDisplayMaster()) {
            return this.tmpVertRangeUnit;
        }
        return this.getNavigatedDisplay().getVerticalRangeUnit();
    }

    public double[] getVerticalRange() {
        if (!this.hasDisplayMaster()) {
            return this.tmpVerticalRange;
        }
        return this.getNavigatedDisplay().getVerticalRange();
    }

    public void setVerticalRange(double[] r) {
        this.tmpVerticalRange = r;
        if (r == null) {
            return;
        }
        if (!this.hasDisplayMaster()) {
            return;
        }
        try {
            this.getNavigatedDisplay().setVerticalRange(r[0], r[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setVerticalRangeUnitPreference(NavigatedDisplay nd) throws VisADException, RemoteException {
        Unit u = null;
        try {
            u = Util.parseUnit(this.getIdv().getObjectStore().get("idv.verticalunit", "m"));
        }
        catch (Exception exc) {
            u = null;
        }
        if (u != null) {
            double[] range = nd.getVerticalRange();
            Unit defaultUnit = nd.getVerticalRangeUnit();
            if (!u.equals(defaultUnit) && Unit.canConvert(u, defaultUnit)) {
                range = u.toThis(range, defaultUnit);
                nd.setVerticalRangeUnit(u);
                nd.setVerticalRange(range[0], range[1]);
            }
        }
    }

    @Override
    public CoordinateSystem getDisplayCoordinateSystem() {
        return this.getNavigatedDisplay().getDisplayCoordinateSystem();
    }
}

