/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectArray;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.Resource;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.VisADException;

public class MultiPaneIdv
extends IntegratedDataViewer {
    JPanel mainPanel;
    JPanel leftPanel;
    ViewManager currentViewManager;
    ArrayList otherViewManagers = new ArrayList();
    JPanel contents;
    JCheckBox doClickCbx;
    int viewManagerCnt = 0;
    ImageIcon downArrowIcon;

    public MultiPaneIdv(String[] args) throws VisADException, RemoteException {
        super(args);
        this.init();
    }

    @Override
    public ViewManager getViewManager(ViewDescriptor viewDescriptor) {
        return this.currentViewManager;
    }

    public void viewClicked(ViewManager viewManager, DisplayEvent e) {
        if (viewManager == this.currentViewManager) {
            return;
        }
        int idx = this.otherViewManagers.indexOf(viewManager);
        this.otherViewManagers.remove(viewManager);
        this.otherViewManagers.add(idx, this.currentViewManager);
        this.currentViewManager = viewManager;
        this.updateViewManagers();
    }

    public Component doMakeContents(IdvWindow frame) throws VisADException, RemoteException {
        this.doClickCbx = new JCheckBox("Enable click", true);
        JPanel topLeft = new JPanel();
        topLeft.add(this.doClickCbx);
        this.currentViewManager = this.getViewManager(new ViewDescriptor("awips" + ++this.viewManagerCnt), false, this.getViewManagerProperties());
        this.currentViewManager.addDisplayListener(new ViewManagerListener(this, this.currentViewManager));
        for (int i = 0; i < 3; ++i) {
            ViewManager other = this.getViewManager(new ViewDescriptor("awips" + ++this.viewManagerCnt), false, this.getViewManagerProperties());
            other.addDisplayListener(new ViewManagerListener(this, other));
            this.otherViewManagers.add(other);
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.contents = new JPanel(new BorderLayout());
        JPanel leftWrapper = new JPanel();
        GuiUtils.doLayout(leftWrapper, new Component[]{topLeft, GuiUtils.inset((Component)this.leftPanel, 2)}, 1, GuiUtils.WT_Y, GuiUtils.WT_NY);
        this.contents.add("West", leftWrapper);
        this.contents.add("Center", this.mainPanel);
        this.updateViewManagers();
        return this.contents;
    }

    @Override
    public void createNewWindow() {
        try {
            ViewManager other = this.getViewManager(new ViewDescriptor("awips" + ++this.viewManagerCnt), false, this.getViewManagerProperties());
            other.addDisplayListener(new ViewManagerListener(this, other));
            this.otherViewManagers.add(other);
            this.updateViewManagers();
        }
        catch (Exception excp) {
            this.logException("createNewWindow", excp);
        }
    }

    public void updateViewManagers() {
        Misc.runInABit(1L, new Runnable(){

            @Override
            public void run() {
                MultiPaneIdv.this.updateViewManagersInner();
            }
        });
    }

    public synchronized void updateViewManagersInner() {
        if (this.downArrowIcon == null) {
            this.downArrowIcon = new ImageIcon(Resource.getImage("/auxdata/ui/icons/SortDown.gif"));
        }
        this.mainPanel.removeAll();
        this.leftPanel.removeAll();
        this.mainPanel.add(this.currentViewManager.getContents());
        for (int i = 0; i < this.otherViewManagers.size(); ++i) {
            ViewManager other = (ViewManager)this.otherViewManagers.get(i);
            JLabel menuBtn = new JLabel(this.downArrowIcon);
            menuBtn.addMouseListener(new ObjectListener(new ObjectArray(other, menuBtn)){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ViewManager vm = (ViewManager)((ObjectArray)this.theObject).getObject1();
                    Component src = (Component)((ObjectArray)this.theObject).getObject2();
                    JPopupMenu menu = GuiUtils.makePopupMenu(vm.doMakeMenuList());
                    menu.show(src, e.getX(), e.getY());
                }
            });
            JComponent otherContents = other.getInnerContents();
            otherContents.setPreferredSize(new Dimension(100, 100));
            JPanel p = GuiUtils.topCenter(menuBtn, otherContents);
            p.setBorder(BorderFactory.createBevelBorder(0, Color.gray, Color.gray));
            this.leftPanel.add(p);
        }
        this.contents.revalidate();
    }

    public static void main(String[] args) throws Exception {
        LogUtil.configure();
        MultiPaneIdv idv = new MultiPaneIdv(args);
    }

    class ViewManagerListener
    implements DisplayListener {
        ViewManager viewManager;
        MultiPaneIdv idv;

        public ViewManagerListener(MultiPaneIdv idv, ViewManager viewManager) {
            this.viewManager = viewManager;
            this.idv = idv;
        }

        @Override
        public void displayChanged(DisplayEvent e) {
            if (e.isRemote()) {
                return;
            }
            if (e.getId() == 6) {
                this.idv.viewClicked(this.viewManager, e);
            }
        }
    }
}

