/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.gis.maps.MapData;
import ucar.unidata.gis.maps.MapInfo;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.DisplayInfo;
import ucar.unidata.idv.IdvPreferenceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.NavigatedViewManager;
import ucar.unidata.idv.StateManager;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.ViewState;
import ucar.unidata.idv.control.MapDisplayControl;
import ucar.unidata.idv.control.ZSlider;
import ucar.unidata.idv.flythrough.Flythrough;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.idv.ui.ContourInfoDialog;
import ucar.unidata.idv.ui.EarthNavPanel;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.idv.ui.PipPanel;
import ucar.unidata.ui.Command;
import ucar.unidata.ui.FontSelector;
import ucar.unidata.util.BooleanProperty;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.GlobeDisplay;
import ucar.unidata.view.geoloc.LatLonAxisScaleInfo;
import ucar.unidata.view.geoloc.LatLonScalePanel;
import ucar.unidata.view.geoloc.MapProjectionDisplay;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.ViewpointInfo;
import ucar.unidata.xml.PreferenceManager;
import ucar.unidata.xml.XmlObjectStore;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.GeoUtils;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.LineDrawing;
import visad.ConstantMap;
import visad.DisplayEvent;
import visad.DisplayRealType;
import visad.FieldImpl;
import visad.FlatField;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;
import visad.util.Util;

public class MapViewManager
extends NavigatedViewManager {
    public static final String PROP_CLIPDISTANCE_GLOBE_FRONT = "idv.clipdistance.globe.front";
    public static final String PROP_CLIPDISTANCE_GLOBE_BACK = "idv.clipdistance.globe.back";
    public static final String PROP_CLIPDISTANCE_MAP_FRONT = "idv.clipdistance.map.front";
    public static final String PROP_CLIPDISTANCE_MAP_BACK = "idv.clipdistance.map.back";
    public static final String CMD_FLY_LEFT = "cmd.fly.left";
    public static final String CMD_FLY_RIGHT = "cmd.fly.right";
    public static final String CMD_FLY_FORWARD = "cmd.fly.forward";
    public static final String CMD_FLY_BACK = "cmd.fly.back";
    public static final String PREF_ADDRESS_LIST = "view.address.list";
    public static final String PREF_ADDRESS_REPROJECT = "view.address.reproject";
    public static final String PREF_AUTOROTATE = "View.AutoRotate";
    public static final String PREF_PERSPECTIVEVIEW = "View.PerspectiveView";
    public static final String PREF_PROJ_DFLT = "View.ProjectionDflt";
    public static final String PREF_PROJ_USEFROMDATA = "View.UseFromData";
    public static final String PREF_SHOWPIP = "View.ShowPip";
    public static final String PREF_USE_PROGRESSIVE_RESOLUTION = "View.UseProgressiveResolution";
    public static final String PR_LABEL = "Enable Adaptive Resolution";
    public static final String PREF_SHOWGLOBEBACKGROUND = "View.ShowGlobeBackground";
    public static final String PREF_GLOBEBACKGROUND = "View.GlobeBackground";
    public static final String PREF_SHOWEARTHNAVPANEL = "View.ShowEarthNavPanel";
    public static final String SHARE_PROJECTION = "MapViewManager.SHARE_PROJECTION";
    private String initialMapResources;
    private MapProjection mainProjection;
    private String mainProjectionName = null;
    private String defaultProjectionName = null;
    private ArrayList projectionHistory = new ArrayList();
    private JMenu projectionsMenu;
    private String mapState;
    private boolean useGlobeDisplay = false;
    private boolean use3D = true;
    EarthNavPanel earthNavPanel;
    JPanel earthNavPanelWrapper;
    private PipPanel pipPanel;
    private Object PIP_MUTEX = new Object();
    private JComponent pipPanelWrapper;
    private static JCheckBox addressReprojectCbx;
    private JCheckBox fixViewpointCbx;
    private JCheckBox fixProjectionCbx;
    JToggleButton rotateBtn;
    ContourInfoDialog cid;
    private Color globeBackgroundColor = null;
    private double globeBackgroundLevel = -0.01;
    private LineDrawing globeBackgroundDisplayable;
    private JComponent globeBackgroundColorComp;
    private ZSlider globeBackgroundLevelSlider;
    private Flythrough flythrough;
    private boolean showMaps = true;
    private String initMapPaths;
    private float initMapWidth = -1.0f;
    private Color initMapColor = null;
    private boolean initLatLonVisible = false;
    private int initLatLonWidth = 1;
    private float initLatLonSpacing = 15.0f;
    private Color initLatLonColor = Color.white;
    private Rectangle2D.Float initLatLonBounds;
    private boolean defaultGlobeBackground = false;
    private double displayProjectionZoom = 0.0;
    private boolean doNotSetProjection = false;
    private LatLonScalePanel latLonScaleWidget;
    private LatLonAxisScaleInfo latAxisScaleInfo;
    private LatLonAxisScaleInfo lonAxisScaleInfo;

    public MapViewManager() {
    }

    public MapViewManager(ViewContext viewContext) {
        super(viewContext);
    }

    public MapViewManager(ViewContext viewContext, ViewDescriptor desc, String properties) throws VisADException, RemoteException {
        super(viewContext, desc, properties);
    }

    public ProjectionImpl getDefaultProjection() {
        return this.getIdv().getIdvProjectionManager().getDefaultProjection();
    }

    @Override
    protected DisplayMaster doMakeDisplayMaster() throws VisADException, RemoteException {
        int mode;
        StateManager stateManager = this.getStateManager();
        IntegratedDataViewer idv = this.getIdv();
        if (idv == null || stateManager == null) {
            return null;
        }
        boolean mode3d = stateManager.getProperty("idv.3d", this.use3D);
        mode3d = this.getStore().get("View.Dimension", mode3d);
        this.use3D = mode3d && this.use3D;
        int n = mode = this.use3D ? 0 : 2;
        if (!Util.canDoJava3D()) {
            mode = 1;
        }
        boolean useGlobe = this.getUseGlobeDisplay() && mode != 1;
        Dimension dimension = stateManager.getViewSize();
        if (dimension == null) {
            if (this.getFullScreenWidth() > 0 && this.getFullScreenHeight() > 0) {
                dimension = new Dimension(this.getFullScreenWidth(), this.getFullScreenHeight());
            } else if (this.displayBounds != null) {
                dimension = new Dimension(this.displayBounds.width, this.displayBounds.height);
            }
        }
        if (dimension == null || dimension.width == 0 || dimension.height == 0) {
            dimension = null;
        }
        NavigatedDisplay navDisplay = null;
        if (useGlobe) {
            GlobeDisplay globeDisplay = new GlobeDisplay(idv.getArgsManager().getIsOffScreen(), dimension, null);
            globeDisplay.setClipDistanceFront(this.getStateManager().getProperty(PROP_CLIPDISTANCE_GLOBE_FRONT, NavigatedDisplay.CLIP_FRONT_DEFAULT));
            globeDisplay.setClipDistanceBack(this.getStateManager().getProperty(PROP_CLIPDISTANCE_GLOBE_BACK, NavigatedDisplay.CLIP_BACK_DEFAULT));
            navDisplay = globeDisplay;
            this.setGlobeBackground(globeDisplay);
            navDisplay.setPolygonOffset(this.getStateManager().getProperty("idv.globe.polygonoffset", 1));
            navDisplay.setPolygonOffsetFactor(this.getStateManager().getProperty("idv.globe.polygonoffsetfactor", 1));
        } else {
            Trace.call1("MapViewManager.doMakeDisplayMaster projection");
            if (this.mainProjection == null) {
                if (this.initLatLonBounds != null) {
                    this.doNotSetProjection = true;
                    this.mainProjection = ucar.visad.Util.makeMapProjection(this.initLatLonBounds.getY() - this.initLatLonBounds.getHeight(), this.initLatLonBounds.getX(), this.initLatLonBounds.getY(), this.initLatLonBounds.getX() + this.initLatLonBounds.getWidth(), false);
                } else {
                    ProjectionImpl dfltProjection = null;
                    if (this.defaultProjectionName != null && (dfltProjection = idv.getIdvProjectionManager().findProjectionByName(this.defaultProjectionName)) != null) {
                        this.doNotSetProjection = true;
                    }
                    if (dfltProjection == null) {
                        dfltProjection = this.getDefaultProjection();
                    }
                    this.mainProjection = new ProjectionCoordinateSystem(dfltProjection);
                }
            }
            if (!idv.getArgsManager().isScriptingMode()) {
                this.addProjectionToHistory(this.mainProjection, "Default");
            }
            Trace.call1("MapViewManager.new MPD");
            MapProjectionDisplay mapDisplay = MapProjectionDisplay.getInstance(this.mainProjection, mode, idv.getArgsManager().getIsOffScreen(), dimension);
            Trace.call2("MapViewManager.new MPD");
            mapDisplay.setClipDistanceFront(this.getStateManager().getProperty(PROP_CLIPDISTANCE_MAP_FRONT, NavigatedDisplay.CLIP_FRONT_DEFAULT));
            mapDisplay.setClipDistanceBack(this.getStateManager().getProperty(PROP_CLIPDISTANCE_MAP_BACK, NavigatedDisplay.CLIP_BACK_DEFAULT));
            if (this.getLatAxisScaleInfo() != null) {
                mapDisplay.setLatScaleInfo(this.getLatAxisScaleInfo());
            }
            if (this.getLonAxisScaleInfo() != null) {
                mapDisplay.setLonScaleInfo(this.getLonAxisScaleInfo());
            }
            if (this.initLatLonBounds == null) {
                double[] dArray;
                double[] aspect = this.getAspectRatio();
                if (aspect == null) {
                    aspect = new double[]{1.0, 1.0, 0.4};
                }
                if (mode == 1) {
                    double[] dArray2 = new double[2];
                    dArray2[0] = aspect[0];
                    dArray = dArray2;
                    dArray2[1] = aspect[1];
                } else {
                    dArray = aspect;
                }
                mapDisplay.setDisplayAspect(dArray);
            } else {
                double[] aspect = new double[]{1.0, this.initLatLonBounds.getHeight() / this.initLatLonBounds.getWidth(), 1.0};
                double[] dArray = mapDisplay.getMouseBehavior().make_matrix(0.0, 0.0, 0.0, aspect[0], aspect[1], 1.0, 0.0, 0.0, 0.0);
            }
            navDisplay = mapDisplay;
            navDisplay.setPerspectiveView(this.getPerspectiveView());
            if (this.defaultProjectionName != null && this.displayProjectionZoom != 0.0) {
                navDisplay.zoom(this.displayProjectionZoom);
            }
            this.defaultProjectionName = null;
            this.initLatLonBounds = null;
            Trace.call2("MapViewManager.doMakeDisplayMaster projection");
            navDisplay.setPolygonOffset(this.getStateManager().getProperty("idv.map.polygonoffset", 1));
            navDisplay.setPolygonOffsetFactor(this.getStateManager().getProperty("idv.map.polygonoffsetfactor", 1));
        }
        return navDisplay;
    }

    public EarthLocation getScreenCenter() throws VisADException, RemoteException {
        return this.getNavigatedDisplay().getEarthLocation(this.getNavigatedDisplay().getScreenCenter());
    }

    public List<TwoFacedObject> getScreenCoordinates() throws VisADException, RemoteException {
        List<TwoFacedObject> l = this.getNavigatedDisplay().getScreenCoordinates();
        ArrayList<TwoFacedObject> result = new ArrayList<TwoFacedObject>();
        for (TwoFacedObject tfo : l) {
            result.add(new TwoFacedObject((Object)tfo.toString(), this.getNavigatedDisplay().getEarthLocation((double[])tfo.getId())));
        }
        return result;
    }

    @Override
    protected void init() throws VisADException, RemoteException {
        if (this.getHaveInitialized()) {
            return;
        }
        super.init();
        Trace.call1("MapViewManager.init checkDefaultMap", " showMap:" + this.showMaps);
        this.checkDefaultMap();
        Trace.call2("MapViewManager.init checkDefaultMap");
        if (this.useGlobeDisplay) {
            this.initializeBooleanProperty(new BooleanProperty(PREF_SHOWGLOBEBACKGROUND, "Show Globe Background", "Show Globe Background", this.defaultGlobeBackground));
        }
    }

    @Override
    protected void initUI() {
        super.initUI();
        if (this.flythrough != null) {
            this.flythrough.init(this);
            if (this.flythrough.getShown()) {
                this.flythrough.show();
            }
        }
    }

    @Override
    protected void fillLegends() {
        super.fillLegends();
        if (this.flythrough != null) {
            this.flythrough.displayControlChanged();
        }
    }

    @Override
    protected void perspectiveViewChanged(boolean v) {
        this.setPerspectiveView(v);
        super.perspectiveViewChanged(v);
        this.notifyDisplayControls(PREF_PERSPECTIVEVIEW);
    }

    @Override
    protected void verticalScaleChanged() {
        this.verticalRangeChanged();
    }

    @Override
    protected void verticalRangeChanged() {
        super.verticalRangeChanged();
        this.notifyDisplayControls(SHARE_PROJECTION);
    }

    public boolean shouldAnimateViewChanges() {
        return !this.getStateManager().getRunningIsl();
    }

    @Override
    public void displayChanged(DisplayEvent event) throws VisADException, RemoteException {
        NavigatedDisplay navDisplay;
        if (this.getIsDestroyed()) {
            return;
        }
        this.checkPipPanel();
        if (this.flythrough != null) {
            this.flythrough.displayChanged(event);
        }
        if (!(navDisplay = this.getMapDisplay()).getAutoRotate() && this.getViewpointControl().getAutoRotate()) {
            this.getViewpointControl().setAutoRotate(false);
        }
        int id = event.getId();
        InputEvent inputEvent = event.getInputEvent();
        if (id == 16 && inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            if (GuiUtils.isControlKey(keyEvent, 78)) {
                EarthLocation center = this.getScreenCenter();
                this.getMapDisplay().centerAndZoom(center, null, 1.0, this.shouldAnimateViewChanges(), true);
                return;
            }
            if (GuiUtils.isControlKey(keyEvent, 83)) {
                EarthLocation center = this.getScreenCenter();
                this.getMapDisplay().centerAndZoom(center, null, 1.0, this.shouldAnimateViewChanges(), false);
                return;
            }
            if (GuiUtils.isControlKey(keyEvent) && (keyEvent.getKeyCode() == 72 || keyEvent.getKeyCode() == 74 || keyEvent.getKeyCode() == 75 || keyEvent.getKeyCode() == 76)) {
                double[] matrix = this.getProjectionControl().getMatrix();
                double[] rot = new double[3];
                double[] scale = new double[3];
                double[] trans = new double[3];
                MouseBehavior mouseBehavior = this.getNavigatedDisplay().getMouseBehavior();
                mouseBehavior.instance_unmake_matrix(rot, scale, trans, matrix);
                double[] t = null;
                if (keyEvent.getKeyCode() == 72) {
                    t = mouseBehavior.make_matrix(-5.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                } else if (keyEvent.getKeyCode() == 74) {
                    t = mouseBehavior.make_matrix(5.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                } else if (keyEvent.getKeyCode() == 75) {
                    t = mouseBehavior.make_matrix(0.0, -5.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                } else if (keyEvent.getKeyCode() == 76) {
                    t = mouseBehavior.make_matrix(0.0, 5.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                }
                matrix = mouseBehavior.multiply_matrix(t, matrix);
                this.getMaster().setProjectionMatrix(matrix);
                return;
            }
        }
        super.displayChanged(event);
    }

    @Override
    protected void mouseFlicked(Point startPoint, Point endPoint, double[] startMatrix, double[] endMatrix, double speed) {
        if (!this.getUseGlobeDisplay()) {
            return;
        }
        double[] trans = new double[]{0.0, 0.0, 0.0};
        double[] rot1 = new double[]{0.0, 0.0, 0.0};
        double[] rot2 = new double[]{0.0, 0.0, 0.0};
        double[] scale = new double[]{0.0, 0.0, 0.0};
        this.getNavigatedDisplay().getMouseBehavior().instance_unmake_matrix(rot1, scale, trans, startMatrix);
        this.getNavigatedDisplay().getMouseBehavior().instance_unmake_matrix(rot2, scale, trans, endMatrix);
        if (rot1[0] == rot2[0] && rot1[1] == rot2[1]) {
            return;
        }
        double distance = GuiUtils.distance(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        if (distance == 0.0) {
            return;
        }
        double percentX = (double)(endPoint.x - startPoint.x) / distance;
        double percentY = (double)(endPoint.y - startPoint.y) / distance;
        this.getNavigatedDisplay().setRotationMultiplierMatrix((speed *= 2.0) * -percentY, speed * -percentX, 0.0);
        this.getViewpointControl().setAutoRotate(true);
    }

    @Override
    protected boolean checkForKmlImageCapture() {
        if (this.getIdv().getArgsManager().getIsOffScreen()) {
            return true;
        }
        NavigatedDisplay navDisplay = this.getMapDisplay();
        double[] rotMatrix = navDisplay.getRotation();
        if (rotMatrix[0] != 0.0 || rotMatrix[1] != 0.0 || rotMatrix[2] != 0.0) {
            JPanel question;
            if (this.fixViewpointCbx == null) {
                this.fixViewpointCbx = new JCheckBox("Fix it", true);
            }
            if (!GuiUtils.askOkCancel("KML Capture", question = GuiUtils.vbox(new JLabel("The viewpoint is not overhead. This will result in an incorrect image capture."), GuiUtils.left(this.fixViewpointCbx)))) {
                return false;
            }
            if (this.fixViewpointCbx.isSelected()) {
                try {
                    navDisplay.resetProjection();
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            } else {
                return true;
            }
        }
        int cnt = 0;
        while (true) {
            String msg;
            JPanel question;
            ++cnt;
            Rectangle sb = navDisplay.getDisplayComponent().getBounds();
            LatLonPoint ul = this.getMapDisplay().getEarthLocation(this.getMapDisplay().getSpatialCoordinatesFromScreen(0, 0)).getLatLonPoint();
            LatLonPoint ur = this.getMapDisplay().getEarthLocation(this.getMapDisplay().getSpatialCoordinatesFromScreen(sb.width, 0)).getLatLonPoint();
            LatLonPoint lr = this.getMapDisplay().getEarthLocation(this.getMapDisplay().getSpatialCoordinatesFromScreen(sb.width, sb.height)).getLatLonPoint();
            LatLonPoint ll = this.getMapDisplay().getEarthLocation(this.getMapDisplay().getSpatialCoordinatesFromScreen(0, sb.height)).getLatLonPoint();
            double width = Math.abs(ul.getLongitude().getValue() - ur.getLongitude().getValue());
            double height = Math.abs(ul.getLatitude().getValue() - ll.getLatitude().getValue());
            boolean projOk = true;
            if (!this.isClose(width, ul.getLongitude().getValue(), ll.getLongitude().getValue())) {
                projOk = false;
            }
            if (!this.isClose(width, ur.getLongitude().getValue(), lr.getLongitude().getValue())) {
                projOk = false;
            }
            if (!this.isClose(height, ul.getLatitude().getValue(), ur.getLatitude().getValue())) {
                projOk = false;
            }
            if (!this.isClose(height, ll.getLatitude().getValue(), lr.getLatitude().getValue())) {
                projOk = false;
            }
            if (projOk) {
                return true;
            }
            if (this.fixProjectionCbx == null) {
                this.fixProjectionCbx = new JCheckBox("Fix it", true);
            }
            if (!GuiUtils.askOkCancel("KML Capture", question = GuiUtils.vbox(new JLabel(msg = cnt == 1 ? "The projection is not lat/lon. This will result in an incorrect image capture." : "For some reason the projection is still not lat/lon."), GuiUtils.left(this.fixProjectionCbx)))) {
                return false;
            }
            if (!this.fixProjectionCbx.isSelected()) {
                return true;
            }
            if (!this.fixProjectionCbx.isSelected()) continue;
            try {
                this.setCurrentAsProjection();
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
            Misc.sleep(1000L);
        }
    }

    private boolean isClose(double span, double value1, double value2) {
        return !(Math.abs((value1 - value2) / span) > 0.01);
    }

    private void checkDefaultMap() {
        if (!this.showMaps) {
            return;
        }
        MapDisplayControl defaultMap = this.findDefaultMap();
        if (defaultMap == null) {
            try {
                MapInfo mapInfo;
                ControlDescriptor mapCD = this.getIdv().getControlDescriptor("mapdisplay");
                if (mapCD == null) {
                    return;
                }
                if (this.mapState != null) {
                    Trace.call1("checkDefaultMap-1");
                    mapInfo = new MapInfo(XmlUtil.getRoot(this.mapState));
                    mapInfo.setJustLoadedLocalMaps(true);
                    Trace.call2("checkDefaultMap-1");
                } else {
                    Iterator<String> xrc = this.getResourceManager().getMapResources(this.getUseGlobeDisplay());
                    mapInfo = new MapInfo((XmlResourceCollection)((Object)xrc), false, true);
                }
                if (this.initLatLonVisible) {
                    mapInfo.getLatData().setVisible(true);
                    mapInfo.getLatData().setLineWidth(this.initLatLonWidth);
                    mapInfo.getLatData().setSpacing(this.initLatLonSpacing);
                    mapInfo.getLatData().setColor(this.initLatLonColor);
                    mapInfo.getLonData().setVisible(true);
                    mapInfo.getLonData().setLineWidth(this.initLatLonWidth);
                    mapInfo.getLonData().setSpacing(this.initLatLonSpacing);
                    mapInfo.getLonData().setColor(this.initLatLonColor);
                }
                if (this.initMapPaths != null) {
                    for (MapData mapData : mapInfo.getMapDataList()) {
                        mapData.setVisible(false);
                        if (this.initMapWidth > 0.0f) {
                            mapData.setLineWidth(this.initMapWidth);
                        }
                        if (this.initMapColor == null) continue;
                        mapData.setColor(this.initMapColor);
                    }
                    for (String mapPath : StringUtil.split(this.initMapPaths, ",", true, true)) {
                        for (MapData mapData : mapInfo.getMapDataList()) {
                            if (!Misc.equals(mapData.getSource(), mapPath)) continue;
                            mapData.setVisible(true);
                        }
                    }
                }
                Trace.call1("checkDefaultMap-making map");
                defaultMap = new MapDisplayControl(this, mapInfo);
                defaultMap.setIsDefaultMap(true);
                Hashtable<String, String> newProperties = new Hashtable<String, String>(mapCD.getProperties());
                newProperties.put("displayName", "Default Background Maps");
                mapCD.initControl((DisplayControl)defaultMap, new ArrayList(), this.getIdv(), newProperties, null);
                Trace.call2("checkDefaultMap-making map");
            }
            catch (Exception exc) {
                this.logException("Initializing maps", exc);
            }
        }
    }

    @Override
    public boolean canBe(ViewManager that) {
        if (!super.canBe(that)) {
            return false;
        }
        MapViewManager mvm = (MapViewManager)that;
        if (this.getUseGlobeDisplay() != mvm.getUseGlobeDisplay()) {
            return false;
        }
        return this.getUse3D() == mvm.getUse3D();
    }

    @Override
    public void initWith(ViewState viewState) throws Exception {
        double[] aspect;
        MapProjection thatProjection = (MapProjection)viewState.get(ViewState.PROP_PROJECTION);
        if (thatProjection != null) {
            this.setMapProjection(thatProjection, false, "Projection");
        }
        if ((aspect = (double[])viewState.get(ViewState.PROP_ASPECTRATIO)) != null) {
            this.setAspectRatio(aspect);
        }
        super.initWith(viewState);
    }

    @Override
    protected void animationTimeChanged() {
        super.animationTimeChanged();
        if (this.flythrough != null) {
            this.flythrough.animationTimeChanged();
        }
    }

    @Override
    protected void initWithInner(ViewManager that, boolean ignoreWindow) throws VisADException, RemoteException {
        LatLonAxisScaleInfo lonAxisScaleInfo;
        if (this.getInitViewStateName() != null) {
            List vms = this.getIdv().getVMManager().getVMState();
            for (int i = 0; i < vms.size(); ++i) {
                ViewState viewState = (ViewState)vms.get(i);
                if (!viewState.getName().equals(this.getInitViewStateName())) continue;
                if (this.isCompatibleWith(viewState)) {
                    try {
                        this.initWith(viewState);
                        break;
                    }
                    catch (Exception exc) {
                        throw new RuntimeException(exc);
                    }
                }
                this.setInitViewStateName(null);
                break;
            }
        }
        if (!(that instanceof MapViewManager)) {
            return;
        }
        if (this.displayProjectionZoom != 0.0) {
            this.getMapDisplay().zoom(this.displayProjectionZoom);
        }
        boolean useDisplayRegion = this.getStateManager().getProperty("idv.usedisplayarea", false);
        if (this.doNotSetProjection) {
            return;
        }
        MapViewManager mvm = (MapViewManager)that;
        MapProjection thatProjection = mvm.getMainProjection();
        if (this.getInitViewStateName() == null) {
            this.setAspectRatio(that.getAspectRatio());
        }
        if (mvm.flythrough != null && mvm.flythrough != this.flythrough) {
            if (this.flythrough != null) {
                this.flythrough.destroy();
            }
            this.flythrough = mvm.flythrough;
            this.flythrough.setViewManager(this);
            if (this.flythrough.getShown()) {
                this.flythrough.show();
            }
        }
        boolean setProjection = false;
        if (thatProjection != null && !useDisplayRegion) {
            setProjection = this.setMapProjection(thatProjection, false, mvm.mainProjectionName);
        }
        if (this.getInitViewStateName() == null && !setProjection && this.getAspectRatio() != null) {
            this.getMapDisplay().setDisplayAspect(this.getAspectRatio());
        }
        if (!this.getUseGlobeDisplay()) {
            this.getMapDisplay().saveProjection();
        }
        this.globeBackgroundColor = mvm.globeBackgroundColor;
        this.globeBackgroundLevel = mvm.globeBackgroundLevel;
        if (this.globeBackgroundDisplayable != null) {
            this.setGlobeBackground((GlobeDisplay)this.getMapDisplay());
        }
        super.initWithInner(that, ignoreWindow);
        try {
            MapDisplayControl defaultMap;
            if (mvm.mapState != null && (defaultMap = this.findDefaultMap()) != null) {
                MapInfo mapInfo = new MapInfo(XmlUtil.getRoot(mvm.mapState));
                MapDisplayControl newMap = new MapDisplayControl(this, mapInfo);
                newMap.init((DataChoice)null);
                defaultMap.loadNewMap(newMap);
            }
        }
        catch (Exception exc) {
            this.logException("Initializing with MapViewManager", exc);
        }
        LatLonAxisScaleInfo latAxisScaleInfo = mvm.getLatAxisScaleInfo();
        if (latAxisScaleInfo != null) {
            this.setLatAxisScaleInfo(latAxisScaleInfo);
        }
        if ((lonAxisScaleInfo = mvm.getLonAxisScaleInfo()) != null) {
            this.setLonAxisScaleInfo(lonAxisScaleInfo);
        }
    }

    @Override
    public void initViewState(ViewState viewState) {
        super.initViewState(viewState);
        viewState.put(ViewState.PROP_GLOBE, new Boolean(this.getUseGlobeDisplay()));
        if (!this.getUseGlobeDisplay()) {
            viewState.put(ViewState.PROP_PROJECTION, this.getMainProjection());
        }
    }

    @Override
    public JComponent getInnerContents() {
        return (JComponent)this.getMapDisplay().getComponent();
    }

    public void setMapState(String ms) {
        this.mapState = ms;
    }

    @Override
    public void initPreferences(IdvPreferenceManager preferenceManager) {
        super.initPreferences(preferenceManager);
        final JComponent[] bgComps = GuiUtils.makeColorSwatchWidget(this.getStore().get("View.BackgroundColor", this.getBackground()), "Set Background Color");
        final JComponent[] fgComps = GuiUtils.makeColorSwatchWidget(this.getStore().get("View.ForegroundColor", this.getForeground()), "Set Foreground Color");
        final JComponent[] border = GuiUtils.makeColorSwatchWidget(this.getStore().get("View.BorderHighlightColor", ViewManager.borderHighlightColor), "Set Selected Panel Border Color");
        final JComponent[] globeComps = GuiUtils.makeColorSwatchWidget(this.getGlobeBackgroundColorToUse(), "Globe Background Color");
        StateManager stateManager = this.getStateManager();
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel colorPanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("  Background:"), bgComps[0], bgComps[1], GuiUtils.rLabel("  Foreground:"), fgComps[0], fgComps[1], GuiUtils.rLabel("  Selected Panel:"), border[0], border[1], GuiUtils.rLabel("  Globe Background:"), globeComps[0], globeComps[1]}, 3, GuiUtils.WT_N, GuiUtils.WT_N));
        colorPanel = GuiUtils.vbox(new JLabel("Color Scheme:"), colorPanel);
        this.cid = new ContourInfoDialog("Preferences", false, null, false);
        ContourInfo ci = new ContourInfo(null, 0.0f, 0.0f, 10.0f, true, false, false, 1, 0, 1, (int)stateManager.getPreferenceOrProperty("idv.contour.labelsize", 12.0), ContourInfoDialog.getContourFont(stateManager.getPreferenceOrProperty("idv.contour.labelfont")), stateManager.getPreferenceOrProperty("idv.contour.alignlabel", true));
        this.cid.setState(ci);
        JPanel contourPanel = GuiUtils.vbox(new JLabel("Contour Labels:"), GuiUtils.inset((Component)this.cid.getLabelPanel(), new Insets(5, 20, 0, 0)));
        contourPanel = GuiUtils.topCenter(contourPanel, GuiUtils.filler());
        colorPanel = GuiUtils.hbox((Component)colorPanel, contourPanel);
        final FontSelector fontSelector = new FontSelector(0, false, false);
        Font f = this.getStore().get("View.DisplayListFont", this.getDisplayListFont());
        fontSelector.setFont(f);
        final GuiUtils.ColorSwatch dlColorWidget = new GuiUtils.ColorSwatch(this.getStore().get("View.DisplayListColor", this.getDisplayListColor()), "Set Display List Color");
        JPanel fontPanel = GuiUtils.vbox(GuiUtils.lLabel("Display List:"), GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Font:"), GuiUtils.left(fontSelector.getComponent()), GuiUtils.rLabel("Color:"), GuiUtils.left(GuiUtils.hbox((Component)dlColorWidget, (Component)dlColorWidget.getSetButton(), (Component)dlColorWidget.getClearButton(), 5))}, 2, GuiUtils.WT_N, GuiUtils.WT_N));
        List projections = this.getProjectionList();
        final JComboBox projBox = new JComboBox();
        final Hashtable projMap = new Hashtable();
        TreeSet<Object> projNames = new TreeSet<Object>(Collator.getInstance());
        for (int p = 0; p < projections.size(); ++p) {
            String projName = ((ProjectionImpl)projections.get(p)).getName();
            projMap.put(projName, projections.get(p));
            projNames.add(projName);
        }
        GuiUtils.setListData(projBox, projNames.toArray());
        ProjectionImpl defaultProj = this.getDefaultProjection();
        if (defaultProj != null) {
            if (defaultProj instanceof ProjectionImpl) {
                projBox.setSelectedItem(defaultProj.getName());
            } else {
                projBox.setSelectedItem(defaultProj);
            }
        }
        final JCheckBox logoVizBox = new JCheckBox("Show Logo in View", stateManager.getPreferenceOrProperty("idv.viewmanager.logo.visible", false));
        final JTextField logoField = new JTextField(stateManager.getPreferenceOrProperty("idv.viewmanager.logo", ""));
        logoField.setToolTipText("Enter a file or URL");
        JButton browseButton = new JButton("Browse..");
        browseButton.setToolTipText("Choose a logo from disk");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String filename = FileManager.getReadFile(FileManager.FILTER_IMAGE);
                if (filename == null) {
                    return;
                }
                logoField.setText(filename);
            }
        });
        String[] logos = this.parseLogoPosition(stateManager.getPreferenceOrProperty("idv.viewmanager.logo.position", ""));
        final JComboBox<TwoFacedObject> logoPosBox = new JComboBox<TwoFacedObject>(logoPoses);
        logoPosBox.setToolTipText("Set the logo position on the screen");
        logoPosBox.setSelectedItem(this.findLoc(logos[0]));
        final JTextField logoOffsetField = new JTextField(logos[1]);
        logoOffsetField.setToolTipText("Set an offset from the position (x,y)");
        float logoScaleFactor = (float)stateManager.getPreferenceOrProperty("idv.viewmanager.logo.scale", 1.0);
        final JLabel logoSizeLab = new JLabel("" + logoScaleFactor);
        JComponent[] sliderComps = GuiUtils.makeSliderPopup(0, 20, (int)(logoScaleFactor * 10.0f), null);
        final JSlider logoScaleSlider = (JSlider)sliderComps[1];
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                logoSizeLab.setText("" + (float)logoScaleSlider.getValue() / 10.0f);
            }
        };
        logoScaleSlider.addChangeListener(listener);
        sliderComps[0].setToolTipText("Change Logo Scale Value");
        JPanel logoPanel = GuiUtils.vbox(GuiUtils.left(logoVizBox), GuiUtils.centerRight(logoField, browseButton), GuiUtils.hbox((Component)GuiUtils.leftCenter(GuiUtils.rLabel("Screen Position: "), logoPosBox), (Component)GuiUtils.leftCenter(GuiUtils.rLabel("Offset: "), logoOffsetField), GuiUtils.leftCenter(GuiUtils.rLabel("Scale: "), GuiUtils.leftRight(logoSizeLab, sliderComps[0]))));
        logoPanel = GuiUtils.vbox(GuiUtils.lLabel("Logo: "), GuiUtils.left(GuiUtils.inset((Component)logoPanel, new Insets(5, 5, 0, 0))));
        PreferenceManager miscManager = new PreferenceManager(){

            @Override
            public void applyPreference(XmlObjectStore theStore, Object data) {
                IdvPreferenceManager.applyWidgets((Hashtable)data, theStore);
                if (projBox.getSelectedItem() instanceof String) {
                    theStore.put(MapViewManager.PREF_PROJ_DFLT, projMap.get(projBox.getSelectedItem()));
                } else {
                    theStore.put(MapViewManager.PREF_PROJ_DFLT, projBox.getSelectedItem());
                }
                theStore.put("View.BackgroundColor", (Object)bgComps[0].getBackground());
                theStore.put(MapViewManager.PREF_GLOBEBACKGROUND, (Object)globeComps[0].getBackground());
                theStore.put("View.ForegroundColor", (Object)fgComps[0].getBackground());
                theStore.put("View.BorderHighlightColor", (Object)border[0].getBackground());
                theStore.put("View.DisplayListFont", (Object)fontSelector.getFont());
                theStore.put("View.DisplayListColor", (Object)dlColorWidget.getSwatchColor());
                MapViewManager.this.checkToolBarVisibility();
                ViewManager.setHighlightBorder(border[0].getBackground());
                MapViewManager.this.cid.doApply();
                ContourInfo ci = MapViewManager.this.cid.getInfo();
                theStore.put("idv.contour.labelsize", ci.getLabelSize());
                theStore.put("idv.contour.labelfont", ci.getFont());
                theStore.put("idv.contour.alignlabel", ci.getAlignLabels());
                theStore.put("idv.viewmanager.logo", (Object)logoField.getText());
                String lpos = ((TwoFacedObject)logoPosBox.getSelectedItem()).getId().toString();
                String loff = logoOffsetField.getText().trim();
                theStore.put("idv.viewmanager.logo.position", (Object)MapViewManager.this.makeLogoPosition(lpos, loff));
                theStore.put("idv.viewmanager.logo.visible", logoVizBox.isSelected());
                theStore.put("idv.viewmanager.logo.scale", (float)logoScaleSlider.getValue() / 10.0f);
            }
        };
        Hashtable widgets = new Hashtable();
        ArrayList miscList = new ArrayList();
        Object[][] miscObjects = new Object[][]{{"View:", null, null}, {"Show Wireframe Box", "View.Wireframe", new Boolean(this.getWireframe())}, {"Show Cursor Readout", "View.ShowCursor", new Boolean(this.getShowCursor())}, {"Clip View At Box", "View.3Dclip", new Boolean(this.getClipping())}, {"Show Display List", "View.ShowDisplayList", new Boolean(this.getShowDisplayList())}, {"Show Times In View", "View.AniReadout", new Boolean(this.getAniReadout())}, {"Show Map Display Scales", "View.ShowScales", new Boolean(this.getLabelsVisible())}, {"Show Transect Display Scales", "View.ShowTransectScales", new Boolean(this.getTransectLabelsVisible())}, {"Show \"Please Wait\" Message", "View.WaitVisible", new Boolean(this.getWaitMessageVisible())}, {"Reset Projection With New Data", PREF_PROJ_USEFROMDATA}, {PR_LABEL, PREF_USE_PROGRESSIVE_RESOLUTION, new Boolean(this.getUseProgressiveResolution())}, {"Use 3D View", "View.Dimension"}, {"Show Globe Background", PREF_SHOWGLOBEBACKGROUND, new Boolean(this.getStore().get(PREF_SHOWGLOBEBACKGROUND, this.defaultGlobeBackground))}};
        Object[][] legendObjects = new Object[][]{{"Legends:", null, null}, {"Show Side Legend", "View.ShowSideLegend", new Boolean(this.getShowSideLegend())}, {"Show Bottom Legend", "View.ShowBottomLegend", new Boolean(this.getShowBottomLegend())}, {"Show Animation Boxes", "View.ShowAnimationBoxes", new Boolean(this.getShowAnimationBoxes())}, {"Show Clock On Dashboard", "idv.monitor.showclock.dashboard", new Boolean(this.getStateManager().getPreferenceOrProperty("idv.monitor.showclock.dashboard", "true"))}, {"Show Clock On View Windows", "idv.monitor.showclock.view", new Boolean(this.getStateManager().getPreferenceOrProperty("idv.monitor.showclock.view", "true"))}, {"Show Overview Map", PREF_SHOWPIP, new Boolean(this.getStore().get(PREF_SHOWPIP, false))}};
        Object[][] toolbarObjects = new Object[][]{{"Toolbars:", null, null}, {"Show Earth Navigation Panel", PREF_SHOWEARTHNAVPANEL, new Boolean(this.getShowEarthNavPanel())}, {"Show Viewpoint Toolbar", "View.ShowToolBarperspective"}, {"Show Zoom/Pan Toolbar", "View.ShowToolBarzoompan"}, {"Show Undo/Redo Toolbar", "View.ShowToolBarundoredo"}};
        JPanel miscPanel = IdvPreferenceManager.makePrefPanel(miscObjects, widgets, this.getStore());
        JPanel legendPanel = IdvPreferenceManager.makePrefPanel(legendObjects, widgets, this.getStore());
        JPanel toolbarPanel = IdvPreferenceManager.makePrefPanel(toolbarObjects, widgets, this.getStore());
        JPanel projPanel = GuiUtils.vbox(GuiUtils.lLabel("Default Projection: "), GuiUtils.left(GuiUtils.inset(projBox, new Insets(5, 20, 0, 0))));
        JPanel colorFontPanel = GuiUtils.vbox((Component)GuiUtils.top(colorPanel), GuiUtils.top(fontPanel));
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel miscContents = GuiUtils.doLayout(Misc.newList(new Component[]{GuiUtils.top(legendPanel), GuiUtils.top(toolbarPanel), GuiUtils.top(miscPanel), GuiUtils.top(colorFontPanel), GuiUtils.top(projPanel), GuiUtils.top(logoPanel)}), 2, GuiUtils.WT_N, GuiUtils.WT_N);
        miscContents = GuiUtils.inset((Component)GuiUtils.left(miscContents), 5);
        preferenceManager.add("View", "View Preferences", miscManager, miscContents, widgets);
    }

    public void goToAddress() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                MapViewManager.this.goToAddressInner();
            }
        });
    }

    private void goToAddressInner() {
        try {
            if (addressReprojectCbx == null) {
                addressReprojectCbx = new JCheckBox("Reproject", this.getStore().get(PREF_ADDRESS_REPROJECT, true));
                addressReprojectCbx.setToolTipText("When checked make a simple map projection over the location");
                List savedAddresses = (List)this.getStore().get(PREF_ADDRESS_LIST);
                if (savedAddresses != null) {
                    GeoUtils.setSavedAddresses(savedAddresses);
                }
            }
            this.getIdvUIManager().showWaitCursor();
            LatLonPoint llp = GeoUtils.getLocationOfAddress(GuiUtils.left(this.getUseGlobeDisplay() ? GuiUtils.filler() : addressReprojectCbx));
            this.getIdvUIManager().showNormalCursor();
            if (llp == null) {
                return;
            }
            this.getStore().put(PREF_ADDRESS_LIST, (Object)GeoUtils.getSavedAddresses());
            this.getStore().put(PREF_ADDRESS_REPROJECT, addressReprojectCbx.isSelected());
            float x = (float)llp.getLongitude().getValue();
            float y = (float)llp.getLatitude().getValue();
            float offset = 0.016666668f;
            Rectangle2D.Float rect = new Rectangle2D.Float(x - offset, y - offset, offset * 2.0f, offset * 2.0f);
            if (!this.getUseGlobeDisplay() && addressReprojectCbx.isSelected()) {
                TrivialMapProjection mp = new TrivialMapProjection(RealTupleType.SpatialEarth2DTuple, rect);
                this.setMapProjection(mp, true);
            } else {
                this.getMapDisplay().center(GeoUtils.toEarthLocation(llp), this.shouldAnimateViewChanges());
            }
        }
        catch (Exception e) {
            this.getIdvUIManager().showNormalCursor();
            this.logException("Error going to address", e);
        }
    }

    public NavigatedDisplay getMapDisplay() {
        return (NavigatedDisplay)this.getMaster();
    }

    public boolean isDisplay3D() {
        return this.getMapDisplay().getDisplayMode() == 0;
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (!this.getInitDone()) {
            return;
        }
        if (dataId.equals(SHARE_PROJECTION)) {
            this.setMapProjection((MapProjection)data[0], false);
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    @Override
    protected JComponent getSideComponent(JComponent sideLegend) {
        this.pipPanel = new PipPanel(this);
        this.pipPanel.setPreferredSize(new Dimension(100, 100));
        JButton closeBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Cancel16.gif", this, "hidePip");
        this.pipPanelWrapper = GuiUtils.topCenter(GuiUtils.right(closeBtn), this.pipPanel);
        if (!this.getShowPip()) {
            this.pipPanelWrapper.setVisible(false);
        }
        return GuiUtils.centerBottom(sideLegend, this.pipPanelWrapper);
    }

    @Override
    protected Container doMakeContents() {
        NavigatedDisplay navDisplay = this.getMapDisplay();
        JComponent navComponent = this.getComponent();
        navComponent.setPreferredSize(this.getMySize());
        this.earthNavPanelWrapper = new JPanel(new BorderLayout());
        JPanel contents = GuiUtils.centerBottom(navComponent, this.earthNavPanelWrapper);
        this.earthNavPanel = new EarthNavPanel(this);
        if (this.getShowEarthNavPanel()) {
            this.earthNavPanelWrapper.add("Center", this.earthNavPanel);
        }
        return contents;
    }

    @Override
    protected void initToolBars() {
        if (this.isDisplay3D()) {
            this.addToolBar(this.doMakeViewPointToolBar(1), "perspective", "Viewpoint toolbar");
        }
        super.initToolBars();
    }

    public void setViewpointInfo(ViewpointInfo viewpointInfo) {
        this.getViewpointControl().setViewpointInfo(viewpointInfo);
    }

    @Override
    public void initializeViewMenu(JMenu viewMenu) {
        super.initializeViewMenu(viewMenu);
        if (this.isDisplay3D()) {
            viewMenu.add(this.getViewpointControl().getMenu());
        }
        viewMenu.add(this.makeColorMenu());
        viewMenu.addSeparator();
        if (this.isFullScreen()) {
            viewMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Reset Full Screen", this, "resetFullScreen"), "/auxdata/ui/icons/arrow_in.png"));
        } else {
            viewMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Full Screen", this, "setFullScreen"), "/auxdata/ui/icons/arrow_out.png"));
        }
        viewMenu.addSeparator();
        viewMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Animation Timeline", this, "showTimeline"), "/auxdata/ui/icons/timeline_marker.png"));
        viewMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Flythrough", this, "showFlythrough"), "/auxdata/ui/icons/plane.png"));
        viewMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Properties", this, "showPropertiesDialog"), "/auxdata/ui/icons/information.png"));
    }

    @Override
    public ArrayList doMakeMenuList() {
        ArrayList menus = super.doMakeMenuList();
        menus.add(this.makeViewMenu());
        menus.add(this.makeProjectionMenu());
        return menus;
    }

    @Override
    protected JMenu makeShowMenu() {
        JMenu showMenu = super.makeShowMenu();
        if (this.globeBackgroundDisplayable != null) {
            this.createCBMI(showMenu, PREF_SHOWGLOBEBACKGROUND);
        }
        this.createCBMI(showMenu, "View.ShowScales");
        this.createCBMI(showMenu, "View.AniReadout");
        this.createCBMI(showMenu, PREF_SHOWPIP);
        this.createCBMI(showMenu, PREF_SHOWEARTHNAVPANEL);
        this.createCBMI(showMenu, "idv.viewmanager.logo.visible");
        return showMenu;
    }

    public void center(MapProjection mp) throws RemoteException, VisADException {
        LatLonPoint center = mp.getCenterLatLon();
        this.getNavigatedDisplay().center(new EarthLocationTuple(center.getLatitude(), center.getLongitude(), new Real(RealType.Altitude, 0.0)), true);
    }

    public void setProjectionFromFirstDisplay() {
        List controls = this.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            DisplayControl display = (DisplayControl)controls.get(i);
            MapProjection mp = display.getDataProjection();
            if (!this.displayProjectionOk(mp)) continue;
            this.setMapProjection(mp, true, this.getDisplayConventions().getMapProjectionLabel(mp, display));
            break;
        }
    }

    protected void updateProjection() throws RemoteException, VisADException {
        if (this.mainProjection == null || !(this.mainProjection instanceof ProjectionCoordinateSystem)) {
            return;
        }
        ProjectionImpl myProjection = ((ProjectionCoordinateSystem)this.mainProjection).getProjection();
        ProjectionImpl newProjection = this.getIdv().getIdvProjectionManager().findProjectionByName(myProjection.getName());
        if (newProjection != null && !myProjection.equals(newProjection)) {
            double[] matrix = this.getDisplayMatrix();
            this.setProjection(newProjection);
            this.setDisplayMatrix(matrix);
        }
    }

    public void setProjectionByName(String projName) {
        ProjectionImpl p;
        int i;
        List projections = this.getProjectionList();
        for (i = 0; i < projections.size(); ++i) {
            p = (ProjectionImpl)projections.get(i);
            if (!p.getName().equals(projName)) continue;
            this.setProjection(p);
            return;
        }
        for (i = 0; i < projections.size(); ++i) {
            p = (ProjectionImpl)projections.get(i);
            if (!StringUtil.stringMatch(p.getName(), projName)) continue;
            this.setProjection(p);
            return;
        }
    }

    public void setProjection(ProjectionImpl p) {
        p = p.constructCopy();
        try {
            this.setMapProjection(new ProjectionCoordinateSystem(p), true);
            if (this.pipPanel != null) {
                this.pipPanel.setProjectionImpl(p);
            }
        }
        catch (Exception excp) {
            this.logException("setMapProjection ()", excp);
        }
    }

    public void setMapProjection(MapProjection projection, boolean fromWidget) {
        this.setMapProjection(projection, fromWidget, null);
    }

    public MapProjection getMainProjection() {
        return this.mainProjection;
    }

    public void setMainProjection(MapProjection projection) {
        this.mainProjection = projection;
    }

    public String getMainProjectionName() {
        return this.mainProjectionName;
    }

    public void setMainProjectionName(String projectionName) {
        this.mainProjectionName = projectionName;
    }

    public void setDefaultProjectionName(String value) {
        this.defaultProjectionName = value;
    }

    public String getDefaultProjectionName() {
        return this.defaultProjectionName;
    }

    private void addProjectionToHistory(MapProjection projection, String name) {
        String encodedProjection = this.getIdv().encodeObject(projection, false);
        TwoFacedObject tfo = TwoFacedObject.findId(encodedProjection, this.projectionHistory);
        if (tfo != null) {
            this.projectionHistory.remove(tfo);
            this.projectionHistory.add(0, tfo);
            return;
        }
        tfo = new TwoFacedObject((Object)name, encodedProjection);
        this.projectionHistory.add(0, tfo);
        String label = name != null ? name : projection.toString();
    }

    public boolean setMapProjection(MapProjection projection, boolean fromWidget, String name) {
        return this.setMapProjection(projection, fromWidget, name, false);
    }

    public boolean setMapProjection(MapProjection projection, boolean fromWidget, String name, boolean checkDefault) {
        return this.setMapProjection(projection, fromWidget, name, checkDefault, true);
    }

    public boolean setMapProjection(MapProjection projection, boolean fromWidget, String name, boolean checkDefault, boolean addToCommandHistory) {
        return this.setMapProjection(projection, fromWidget, name, checkDefault, addToCommandHistory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMapProjection(MapProjection projection, boolean fromWidget, String name, boolean checkDefault, boolean addToCommandHistory, boolean maintainViewpoint) {
        IdvUIManager.startTime = System.currentTimeMillis();
        if (checkDefault) {
            if (!this.getUseProjectionFromData()) {
                return false;
            }
            if (this.doNotSetProjection) {
                return false;
            }
        }
        if (projection == null) {
            return false;
        }
        if (this.getUseGlobeDisplay() && !this.getViewpointControl().getAutoRotate()) {
            try {
                LatLonPoint center = projection.getCenterLatLon();
                this.getNavigatedDisplay().center(new EarthLocationTuple(center.getLatitude(), center.getLongitude(), new Real(RealType.Altitude, 0.0)), true);
                return true;
            }
            catch (Exception e) {
                this.logException("setProjection", e);
                return false;
            }
        }
        boolean actuallyChangedProjection = false;
        double[] matrix = this.getDisplayMatrix();
        try {
            this.setMasterInactive();
            if (addToCommandHistory && this.mainProjection != null) {
                this.addCommand(new ProjectionCommand(this, this.mainProjectionName, this.mainProjection, name, projection));
            }
            if (!Misc.equals(this.mainProjection, projection)) {
                if (name == null) {
                    name = this.getDisplayConventions().getMapProjectionName(projection);
                }
                if (this.projectionHistory.size() == 0 && this.mainProjection != null) {
                    this.addProjectionToHistory(this.mainProjection, "Default");
                }
                this.mainProjectionName = name;
                this.addProjectionToHistory(projection, name);
                this.mainProjection = projection;
                if (fromWidget) {
                    this.doShare((Object)SHARE_PROJECTION, projection);
                }
                try {
                    actuallyChangedProjection = true;
                    this.getMapDisplay().setMapProjection(this.mainProjection);
                    this.setAspectRatio(this.getMapDisplay().getDisplayAspect());
                    this.setDisplayMatrix(matrix);
                }
                catch (Exception e) {
                    this.logException("setProjection", e);
                }
                this.notifyDisplayControls(SHARE_PROJECTION);
                this.checkPipPanel();
            }
            try {
                if (!maintainViewpoint && projection.equals(this.mainProjection)) {
                    this.getMaster().resetProjection();
                }
            }
            catch (Exception e) {
                this.logException("setProjection", e);
            }
        }
        finally {
            this.updateDisplayList();
            this.setMasterActive();
        }
        return actuallyChangedProjection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPipPanel() {
        try {
            Object object = this.PIP_MUTEX;
            synchronized (object) {
                if (this.pipPanel == null) {
                    return;
                }
                this.pipPanel.resetDrawBounds();
            }
        }
        catch (Exception exc) {
            this.pipPanel = null;
            this.logException("Error setting pip panel", exc);
        }
    }

    @Override
    public boolean okToImportDisplay(DisplayControl control) {
        if (!super.okToImportDisplay(control)) {
            return false;
        }
        MapViewManager vm = (MapViewManager)control.getViewManager();
        return this.getUseGlobeDisplay() == vm.getUseGlobeDisplay();
    }

    @Override
    protected void doneFirstFrame() {
        super.doneFirstFrame();
        this.checkPipPanel();
    }

    private MapDisplayControl findDefaultMap() {
        List controls = this.getControls();
        for (int i = controls.size() - 1; i >= 0; --i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            if (!(control instanceof MapDisplayControl) || !((MapDisplayControl)control).getIsDefaultMap()) continue;
            return (MapDisplayControl)control;
        }
        return null;
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        if (this.useGlobeDisplay && this.globeBackgroundDisplayable != null) {
            this.globeBackgroundColor = this.globeBackgroundColorComp.getBackground();
            this.globeBackgroundLevel = this.globeBackgroundLevelSlider.getValue();
            this.setGlobeBackground((GlobeDisplay)this.getMapDisplay());
            return true;
        }
        return this.applyAxisVisibility();
    }

    private boolean applyAxisVisibility() {
        if (this.latLonScaleWidget == null) {
            return false;
        }
        boolean b = !this.useGlobeDisplay && (this.getBp("View.ShowScales") || this.latLonScaleWidget.isLatVisible() || this.latLonScaleWidget.isLonVisible());
        this.setBp("View.ShowScales", b);
        return this.latLonScaleWidget.doApply();
    }

    @Override
    protected void addPropertiesComponents(JTabbedPane tabbedPane) {
        super.addPropertiesComponents(tabbedPane);
        if (!this.useGlobeDisplay) {
            MapProjectionDisplay mpDisplay = (MapProjectionDisplay)this.getNavigatedDisplay();
            mpDisplay.getLatScaleInfo().setVisible(this.getBp("View.ShowScales"));
            mpDisplay.getLonScaleInfo().setVisible(this.getBp("View.ShowScales"));
            this.latLonScaleWidget = new LatLonScalePanel(mpDisplay);
            tabbedPane.add("Horizontal Scale", GuiUtils.topLeft(this.latLonScaleWidget));
        }
        if (this.globeBackgroundDisplayable == null) {
            return;
        }
        this.globeBackgroundLevelSlider = new ZSlider(this.globeBackgroundLevel);
        JComponent levelComp = this.globeBackgroundLevelSlider.getContents();
        JComponent[] bgComps = GuiUtils.makeColorSwatchWidget(this.getGlobeBackgroundColorToUse(), "Globe Background Color");
        this.globeBackgroundColorComp = bgComps[0];
        JComponent comp = GuiUtils.formLayout(new Component[]{GuiUtils.rLabel("Color:"), GuiUtils.left(bgComps[0]), GuiUtils.rLabel("Level:"), levelComp});
        tabbedPane.add("Globe Background", GuiUtils.top(comp));
    }

    private void setGlobeBackground(GlobeDisplay globe) {
        try {
            if (this.globeBackgroundDisplayable == null) {
                FlatField ff;
                FlatField d = ff = ucar.visad.Util.makeField(-180.0f, 180.0f, 180, 90.0f, -90.0f, 180, 1.0f, "celsius");
                this.globeBackgroundDisplayable = new LineDrawing("background");
                this.globeBackgroundDisplayable.setData(d);
                globe.addDisplayable(this.globeBackgroundDisplayable);
            }
            this.globeBackgroundDisplayable.setColor(this.getGlobeBackgroundColorToUse());
            this.globeBackgroundDisplayable.setVisible(this.getGlobeBackgroundShow());
            DisplayRealType drt = globe.getDisplayAltitudeType();
            double[] range = new double[2];
            double realPosition = 1.0;
            if (drt.getRange(range)) {
                double pcnt = (this.globeBackgroundLevel - -1.0) / 2.0;
                realPosition = Math.min(range[0] + (range[1] - range[0]) * pcnt, range[1]);
            }
            ConstantMap constantMap = new ConstantMap(realPosition, drt);
            this.globeBackgroundDisplayable.addConstantMap(constantMap);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public void destroy() {
        if (this.flythrough != null) {
            try {
                this.flythrough.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.flythrough = null;
        }
        super.destroy();
    }

    public void showFlythrough() {
        if (this.flythrough == null) {
            this.flythrough = new Flythrough(this);
        }
        this.flythrough.show();
    }

    public void flythrough(float[][] pts) {
        if (this.flythrough == null) {
            this.flythrough = new Flythrough(this);
        }
        this.flythrough.flythrough(pts);
    }

    public void flythrough(List<FlythroughPoint> pts) {
        if (this.flythrough == null) {
            this.flythrough = new Flythrough(this);
        }
        this.flythrough.flythrough(pts);
    }

    @Override
    public final void initAfterUnPersistence(IntegratedDataViewer idv) throws VisADException, RemoteException {
        super.initAfterUnPersistence(idv);
    }

    @Override
    public void displayDataChanged(DisplayControl display) {
        this.displayDataChanged(display, false);
    }

    public void displayDataChanged(DisplayControl display, boolean fromInitialLoad) {
        try {
            if (this.getUseProjectionFromData() && !this.getStateManager().getProperty("idv.loadingxml", false)) {
                MapProjection mp = display.getDataProjection();
                if (this.getUseGlobeDisplay() && !this.getViewpointControl().getAutoRotate()) {
                    LatLonPoint center = mp.getCenterLatLon();
                    this.getNavigatedDisplay().center(new EarthLocationTuple(center.getLatitude(), center.getLongitude(), new Real(RealType.Altitude, 0.0)), true);
                    return;
                }
                if (this.displayProjectionOk(mp) && (this.mainProjection == null || !mp.equals(this.mainProjection))) {
                    boolean maintainViewpoint = !fromInitialLoad;
                    this.setMapProjection(mp, true, this.getDisplayConventions().getMapProjectionLabel(mp, display), true, true, maintainViewpoint);
                    if (this.displayProjectionZoom != 0.0) {
                        this.getMapDisplay().zoom(this.displayProjectionZoom);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.displayDataChanged(display);
    }

    @Override
    public void addDisplayInfos(List<DisplayInfo> displayInfos) throws RemoteException, VisADException {
        MapDisplayControl defaultMap;
        if (this.getIsDestroyed()) {
            return;
        }
        if (displayInfos.size() == 0) {
            return;
        }
        DisplayControl display = displayInfos.get(0).getDisplayControl();
        if (display instanceof MapDisplayControl && ((MapDisplayControl)display).getIsDefaultMap() && (defaultMap = this.findDefaultMap()) != null && defaultMap != display) {
            defaultMap.loadNewMap((MapDisplayControl)display);
            this.displayControlChanged(defaultMap);
            return;
        }
        this.displayDataChanged(display, true);
        super.addDisplayInfos(displayInfos);
    }

    public void checkProjection(FieldImpl data, DisplayControl display) {
        try {
            MapProjection mp = GridUtil.getNavigation(data);
            if (mp == null) {
                return;
            }
            this.setMapProjection(mp, false, this.getDisplayConventions().getMapProjectionLabel(mp, display));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(CMD_FLY_FORWARD) && this.flythrough != null) {
            this.flythrough.driveForward();
        } else if (cmd.equals(CMD_FLY_BACK) && this.flythrough != null) {
            this.flythrough.driveBack();
        } else if (cmd.equals(CMD_FLY_LEFT) && this.flythrough != null) {
            this.flythrough.driveLeft();
        } else if (cmd.equals(CMD_FLY_RIGHT) && this.flythrough != null) {
            this.flythrough.driveRight();
        } else if (cmd.equals("cmd.nav.zoomin")) {
            this.getMapDisplay().zoom(1.2);
        } else if (cmd.equals("cmd.nav.rotateleft")) {
            this.getMapDisplay().rotateZ(-5.0);
        } else if (cmd.equals("cmd.nav.rotateright")) {
            this.getMapDisplay().rotateZ(5.0);
        } else if (cmd.equals("cmd.nav.zoomout")) {
            this.getMapDisplay().zoom(0.8333333333333334);
        } else if (cmd.equals("cmd.nav.home")) {
            try {
                this.getMapDisplay().resetProjection();
            }
            catch (Exception exception) {}
        } else if (cmd.equals("cmd.nav.right")) {
            this.getMapDisplay().translate(-0.1, 0.0);
        } else if (cmd.equals("cmd.nav.left")) {
            this.getMapDisplay().translate(0.1, 0.0);
        } else if (cmd.equals("cmd.nav.up")) {
            this.getMapDisplay().translate(0.0, -0.1);
        } else if (cmd.equals("cmd.nav.down")) {
            this.getMapDisplay().translate(0.0, 0.1);
        } else if (cmd.equals("cmd.nav.small.zoomin")) {
            this.getMapDisplay().zoom(1.2);
        } else if (cmd.equals("cmd.nav.small.zoomout")) {
            this.getMapDisplay().zoom(0.8333333333333334);
        } else if (cmd.equals("cmd.nav.small.rotateleft")) {
            this.getMapDisplay().rotateZ(-2.0);
        } else if (cmd.equals("cmd.nav.small.rotateright")) {
            this.getMapDisplay().rotateZ(2.0);
        } else if (cmd.equals("cmd.nav.small.tiltup")) {
            this.getMapDisplay().rotateX(-2.0);
        } else if (cmd.equals("cmd.nav.small.tiltdown")) {
            this.getMapDisplay().rotateX(2.0);
        } else if (cmd.equals("cmd.nav.small.right")) {
            this.getMapDisplay().translate(-0.02, 0.0);
        } else if (cmd.equals("cmd.nav.small.left")) {
            this.getMapDisplay().translate(0.02, 0.0);
        } else if (cmd.equals("cmd.nav.small.up")) {
            this.getMapDisplay().translate(0.0, -0.02);
        } else if (cmd.equals("cmd.nav.small.down")) {
            this.getMapDisplay().translate(0.0, 0.02);
        }
    }

    @Override
    public GeoLocationInfo getVisibleGeoBounds() {
        NavigatedDisplay navDisplay = this.getMapDisplay();
        Rectangle screenBounds = navDisplay.getDisplayComponent().getBounds();
        if (!this.getIdv().getArgsManager().getIsOffScreen()) {
            // empty if block
        }
        double[] ulXY = this.getMapDisplay().getSpatialCoordinatesFromScreen(0, 0);
        double[] lrXY = this.getMapDisplay().getSpatialCoordinatesFromScreen(screenBounds.width, screenBounds.height);
        LatLonPoint ulLLP = this.getMapDisplay().getEarthLocation(ulXY).getLatLonPoint();
        LatLonPoint lrLLP = this.getMapDisplay().getEarthLocation(lrXY).getLatLonPoint();
        double minX = Math.min(ulLLP.getLongitude().getValue(), lrLLP.getLongitude().getValue());
        double maxX = Math.max(ulLLP.getLongitude().getValue(), lrLLP.getLongitude().getValue());
        double minY = Math.min(ulLLP.getLatitude().getValue(), lrLLP.getLatitude().getValue());
        double maxY = Math.max(ulLLP.getLatitude().getValue(), lrLLP.getLatitude().getValue());
        Rectangle2D.Float rect = new Rectangle2D.Float((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
        return new GeoLocationInfo(maxY, minX, minY, maxX);
    }

    public void setCurrentAsProjection() {
        try {
            NavigatedDisplay display = this.getMapDisplay();
            Rectangle screenBounds = display.getComponent().getBounds();
            LatLonPoint ulLLP = null;
            LatLonPoint lrLLP = null;
            int sw = screenBounds.width;
            int sh = screenBounds.height;
            int x = 0;
            for (int y = 0; x < sw && y < sh; ++x, ++y) {
                double[] ulXY = display.getSpatialCoordinatesFromScreen(x, y);
                ulLLP = this.getMapDisplay().getEarthLocation(ulXY).getLatLonPoint();
                if (!ulLLP.getLatitude().isMissing() && !ulLLP.getLongitude().isMissing()) break;
                ulLLP = null;
            }
            while (sw > 0 && sh > 0) {
                double[] lrXY = display.getSpatialCoordinatesFromScreen(sw, sh);
                lrLLP = this.getMapDisplay().getEarthLocation(lrXY).getLatLonPoint();
                if (!lrLLP.getLatitude().isMissing() && !lrLLP.getLongitude().isMissing()) break;
                lrLLP = null;
                --sw;
                --sh;
            }
            if (ulLLP == null || lrLLP == null) {
                LogUtil.userMessage("Could not create a valid projection");
                return;
            }
            double minX = Math.min(ulLLP.getLongitude().getValue(), lrLLP.getLongitude().getValue());
            double maxX = Math.max(ulLLP.getLongitude().getValue(), lrLLP.getLongitude().getValue());
            double minY = Math.min(ulLLP.getLatitude().getValue(), lrLLP.getLatitude().getValue());
            double maxY = Math.max(ulLLP.getLatitude().getValue(), lrLLP.getLatitude().getValue());
            Rectangle2D.Float rect = new Rectangle2D.Float((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
            MapProjection mp = ucar.visad.Util.makeMapProjection(minY, minX, maxY, maxX);
            this.setMapProjection(mp, true);
            this.getMapDisplay().zoom(1.2);
            this.getMapDisplay().saveProjection();
        }
        catch (Exception exp) {
            this.logException("Setting projection", exp);
        }
    }

    public void showProjectionManager() {
        this.getIdv().showIdvProjectionManager();
    }

    public void setMapArea(ProjectionRect mapArea) {
        try {
            this.getMapDisplay().setMapArea(mapArea);
        }
        catch (Exception e) {
            this.logException("setMapArea", e);
        }
    }

    private boolean displayProjectionOk(MapProjection mp) {
        if (mp == null) {
            return false;
        }
        if (this.doNotSetProjection) {
            return false;
        }
        Rectangle2D rect = mp.getDefaultMapArea();
        if (rect.getWidth() == 0.0 || rect.getHeight() == 0.0) {
            return false;
        }
        if (rect.getWidth() / rect.getHeight() < 0.1) {
            return false;
        }
        return !(rect.getHeight() / rect.getWidth() < 0.075);
    }

    public void initializeProjectionMenu(JMenu projectionsMenu) {
        List projections = this.getProjectionList();
        List controls = this.getControls();
        if (!this.getUseGlobeDisplay()) {
            // empty if block
        }
        ProjectionImpl currentProjection = null;
        if (this.mainProjection != null && this.mainProjection instanceof ProjectionCoordinateSystem) {
            currentProjection = ((ProjectionCoordinateSystem)this.mainProjection).getProjection();
        }
        MapViewManager.makeProjectionsMenu(projectionsMenu, projections, this, "setProjection", currentProjection);
    }

    public void initializeDisplaysProjectionMenu(JMenu displaysMenu) {
        List controls = this.getControls();
        int cnt = 0;
        for (int i = 0; i < controls.size(); ++i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            final MapProjection mp = control.getDataProjection();
            if (!this.displayProjectionOk(mp)) continue;
            final String label = this.getDisplayConventions().getMapProjectionLabel(mp, control);
            JMenuItem mi = new JMenuItem(label);
            displaysMenu.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MapViewManager.this.setMapProjection(mp, false, label);
                }
            });
            ++cnt;
        }
        if (cnt == 0) {
            displaysMenu.add(new JMenuItem("None Defined"));
        }
    }

    public static void makeProjectionsMenu(JMenu projectionsMenu, List projections, Object object, String method) {
        MapViewManager.makeProjectionsMenu(projectionsMenu, projections, object, method, null);
    }

    public static void makeProjectionsMenu(JMenu projectionsMenu, List projections, Object object, String method, ProjectionImpl currentProjection) {
        List<String> names;
        if (currentProjection != null && (names = StringUtil.split(currentProjection.getName(), ">", true, true)).size() > 0) {
            String name = "Current: " + names.get(names.size() - 1);
            JMenuItem mi = GuiUtils.makeMenuItem(name, object, method, currentProjection);
            projectionsMenu.add(mi);
            projectionsMenu.addSeparator();
        }
        Hashtable<String, JMenu> catMenus = new Hashtable<String, JMenu>();
        for (int i = 0; i < projections.size(); ++i) {
            ProjectionImpl p = (ProjectionImpl)projections.get(i);
            List<String> names2 = StringUtil.split(p.getName(), ">", true, true);
            JMenu theMenu = projectionsMenu;
            String catSoFar = "";
            int catIdx = 0;
            for (catIdx = 0; catIdx < names2.size() - 1; ++catIdx) {
                String cat = names2.get(catIdx);
                JMenu tmpMenu = (JMenu)catMenus.get(catSoFar = catSoFar + "-" + cat);
                if (tmpMenu == null) {
                    tmpMenu = new JMenu(cat);
                    catMenus.put(catSoFar, tmpMenu);
                    theMenu.add(tmpMenu);
                }
                theMenu = tmpMenu;
            }
            String name = catIdx < names2.size() ? names2.get(catIdx) : "";
            boolean isCurrent = Misc.equals(p, currentProjection);
            if (isCurrent) {
                // empty if block
            }
            JMenuItem mi = GuiUtils.makeMenuItem(name, object, method, p);
            theMenu.add(mi);
            if (!isCurrent) continue;
            GuiUtils.italicizeFont(mi.getComponent());
        }
    }

    public void initializeProjectionHistoryMenu(JMenu menu) {
        menu.removeAll();
        for (int i = 0; i < this.projectionHistory.size(); ++i) {
            final TwoFacedObject tfo = (TwoFacedObject)this.projectionHistory.get(i);
            JMenuItem mi = new JMenuItem(tfo.toString());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String encodedProjection = (String)tfo.getId();
                        MapProjection mp = (MapProjection)MapViewManager.this.getIdv().decodeObject(encodedProjection);
                        MapViewManager.this.setMapProjection(mp, true);
                    }
                    catch (Exception exc) {
                        MapViewManager.this.logException("Failed to instantiate the projection", exc);
                    }
                }
            });
            menu.add(mi);
        }
    }

    @Override
    public boolean isCompatibleWith(ViewManager vm) {
        if (!super.isCompatibleWith(vm)) {
            return false;
        }
        MapViewManager that = (MapViewManager)vm;
        return this.getUseGlobeDisplay() == that.getUseGlobeDisplay();
    }

    @Override
    public boolean isCompatibleWith(ViewState viewState) {
        if (!super.isCompatibleWith(viewState)) {
            return false;
        }
        Boolean b = (Boolean)viewState.get(ViewState.PROP_GLOBE);
        if (b != null) {
            return this.getUseGlobeDisplay() == b.booleanValue();
        }
        return true;
    }

    private JMenu makeProjectionMenu() {
        JMenu projMenu = new JMenu("Projections");
        projMenu.setMnemonic(GuiUtils.charToKeyCode("P"));
        this.projectionsMenu = GuiUtils.makeDynamicMenu("Predefined", this, "initializeProjectionMenu");
        JMenu displaysMenu = GuiUtils.makeDynamicMenu("From Displays", this, "initializeDisplaysProjectionMenu");
        if (!this.getUseGlobeDisplay()) {
            projMenu.add(this.projectionsMenu);
            projMenu.add(displaysMenu);
        }
        projMenu.add(this.makeSavedViewsMenu());
        JMenu projectionHistoryMenu = GuiUtils.makeDynamicMenu("History", this, "initializeProjectionHistoryMenu");
        if (!this.getUseGlobeDisplay()) {
            projMenu.add(projectionHistoryMenu);
        }
        if (!this.getUseGlobeDisplay()) {
            projMenu.addSeparator();
            projMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("New/Edit...", this, "showProjectionManager"), "/auxdata/ui/icons/world_edit.png"));
            projMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Use Displayed Area", this, "setCurrentAsProjection"), "/auxdata/ui/icons/world_rect.png"));
        }
        projMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Go to Address", this, "goToAddress"), "/auxdata/ui/icons/house_go.png"));
        projMenu.addSeparator();
        if (!this.getUseGlobeDisplay()) {
            this.createCBMI(projMenu, PREF_PROJ_USEFROMDATA).setToolTipText("Automatically change the projection to the native data projection of new displays");
        } else {
            this.createCBMI(projMenu, PREF_PROJ_USEFROMDATA).setToolTipText("Automatically change viewpoint to the native data projection of new displays");
        }
        this.createCBMI(projMenu, PREF_USE_PROGRESSIVE_RESOLUTION).setToolTipText("Adapt the data resolution to match the display resolution");
        this.createCBMI(projMenu, "View.ShareViews");
        projMenu.add(GuiUtils.makeMenuItem("Set Share Group", this, "showSharableDialog"));
        return projMenu;
    }

    public void setMapConfigFile(String location) {
    }

    public void setUseGlobeDisplay(boolean use) {
        this.useGlobeDisplay = use;
    }

    public boolean getUseGlobeDisplay() {
        return this.useGlobeDisplay;
    }

    public void setUse3D(boolean use) {
        this.use3D = use;
    }

    public boolean getUse3D() {
        return this.use3D;
    }

    @Override
    protected void handleBooleanPropertyChange(String id, boolean value) throws Exception {
        super.handleBooleanPropertyChange(id, value);
        if (id.equals(PREF_AUTOROTATE)) {
            if (this.hasViewpointControl()) {
                this.getViewpointControl().setAutoRotate(value);
            }
        } else if (id.equals("View.ShowScales")) {
            if (this.hasDisplayMaster()) {
                this.getNavigatedDisplay().setScalesVisible(value);
            }
        } else if (id.equals(PREF_SHOWEARTHNAVPANEL)) {
            if (this.earthNavPanelWrapper != null) {
                this.earthNavPanelWrapper.removeAll();
                if (value) {
                    this.earthNavPanelWrapper.add("Center", this.earthNavPanel);
                }
            }
        } else if (id.equals(PREF_SHOWPIP)) {
            if (this.pipPanelWrapper != null) {
                this.pipPanelWrapper.setVisible(value);
            }
        } else if (!id.equals(PREF_USE_PROGRESSIVE_RESOLUTION)) {
            if (id.equals(PREF_SHOWGLOBEBACKGROUND)) {
                if (this.globeBackgroundDisplayable != null) {
                    this.globeBackgroundDisplayable.setVisible(value);
                }
            } else if (id.equals(PREF_PERSPECTIVEVIEW) && this.hasViewpointControl()) {
                this.getViewpointControl().setPerspectiveView(value);
            }
        }
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
        this.applyAxisVisibility();
    }

    @Override
    protected void getInitialBooleanProperties(List props) {
        super.getInitialBooleanProperties(props);
        props.add(new BooleanProperty("View.ShowScales", "Show Display Scales", "Show Display Scales", false));
        props.add(new BooleanProperty(PREF_PROJ_USEFROMDATA, "Auto-set Projection", "Use projection from newly loaded data", true));
        props.add(new BooleanProperty(PREF_PERSPECTIVEVIEW, "Perspective View", "Toggle perspective view", false));
        props.add(new BooleanProperty(PREF_AUTOROTATE, "Auto-rotate", "", false));
        props.add(new BooleanProperty(PREF_SHOWEARTHNAVPANEL, "Show Earth Navigation Panel", "Show Earth Navigation Panel", false));
        props.add(new BooleanProperty(PREF_SHOWPIP, "Show Overview Map", "Show Overview Map", false));
        props.add(new BooleanProperty(PREF_USE_PROGRESSIVE_RESOLUTION, PR_LABEL, PR_LABEL, true));
        if (this.useGlobeDisplay) {
            props.add(new BooleanProperty(PREF_SHOWGLOBEBACKGROUND, "Show Globe Background", "Show Globe Background", this.defaultGlobeBackground));
        }
    }

    public void setAutoRotate(boolean value) {
        this.setBp(PREF_AUTOROTATE, value);
    }

    public boolean getAutoRotate() {
        return this.getBp(PREF_AUTOROTATE);
    }

    public void setPerspectiveView(boolean value) {
        this.setBp(PREF_PERSPECTIVEVIEW, value);
    }

    @Override
    public boolean getPerspectiveView() {
        return this.getBp(PREF_PERSPECTIVEVIEW);
    }

    public void setShowMap(boolean value) {
    }

    public void setShowElevation(boolean value) {
    }

    @Override
    public void setProjectionFromData(boolean value) {
        this.setUseProjectionFromData(value);
    }

    public void setUseProjectionFromData(boolean value) {
        this.setBp(PREF_PROJ_USEFROMDATA, value);
    }

    public boolean getUseProjectionFromData() {
        return this.getBp(PREF_PROJ_USEFROMDATA);
    }

    public void setBgColor(boolean bgColor) {
        if (!bgColor) {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        } else {
            this.setBackground(Color.black);
            this.setForeground(Color.white);
        }
    }

    public void setShowEarthNavPanel(boolean value) {
        this.setBp(PREF_SHOWEARTHNAVPANEL, value);
    }

    public boolean getShowEarthNavPanel() {
        return this.getBp(PREF_SHOWEARTHNAVPANEL);
    }

    public void hidePip() {
        this.setShowPip(false);
    }

    public void setShowPip(boolean value) {
        this.setBp(PREF_SHOWPIP, value);
    }

    public boolean getShowPip() {
        return this.getBp(PREF_SHOWPIP, false);
    }

    public void setUseProgressiveResolution(boolean value) {
        this.setBp(PREF_USE_PROGRESSIVE_RESOLUTION, value);
    }

    public boolean getUseProgressiveResolution() {
        return this.getBp(PREF_USE_PROGRESSIVE_RESOLUTION, true);
    }

    public void setInitialMapResources(String value) {
        this.initialMapResources = value;
    }

    @Override
    public String getTypeName() {
        if (this.getUseGlobeDisplay()) {
            return "Globe";
        }
        return "Map";
    }

    public float getDefaultMapPosition() {
        if (this.getUseGlobeDisplay()) {
            return (float)this.getStateManager().getProperty("idv.map.globe.level", 0.005f);
        }
        return (float)this.getStateManager().getProperty("idv.map.map.level", -0.99f);
    }

    public void setGlobeBackgroundColor(Color value) {
        this.globeBackgroundColor = value;
    }

    public Color getGlobeBackgroundColor() {
        return this.globeBackgroundColor;
    }

    public Color getGlobeBackgroundColorToUse() {
        Color backgroundColor = this.globeBackgroundColor;
        if (backgroundColor == null) {
            backgroundColor = this.getStore().get(PREF_GLOBEBACKGROUND, Color.white);
        }
        return backgroundColor;
    }

    public void setGlobeBackgroundShow(boolean value) {
        this.defaultGlobeBackground = value;
        this.setBp(PREF_SHOWGLOBEBACKGROUND, value);
    }

    public boolean getGlobeBackgroundShow() {
        if (this.hasBooleanProperty(PREF_SHOWGLOBEBACKGROUND)) {
            return this.getBp(PREF_SHOWGLOBEBACKGROUND, false);
        }
        XmlObjectStore store = this.getStore();
        if (store != null) {
            return store.get(PREF_SHOWGLOBEBACKGROUND, false);
        }
        return false;
    }

    public void setGlobeBackgroundLevel(double value) {
        this.globeBackgroundLevel = value;
    }

    public double getGlobeBackgroundLevel() {
        return this.globeBackgroundLevel;
    }

    public void setFlythrough(Flythrough value) {
        this.flythrough = value;
    }

    public Flythrough getFlythrough() {
        return this.flythrough;
    }

    public void setShowMaps(boolean value) {
        this.showMaps = value;
    }

    public boolean getShowMaps() {
        return this.showMaps;
    }

    public void setDisplayProjectionZoom(double value) {
        this.displayProjectionZoom = value;
    }

    public double getDisplayProjectionZoom() {
        return this.displayProjectionZoom;
    }

    public void setInitMapPaths(String value) {
        this.initMapPaths = value;
    }

    public String getInitMapPaths() {
        return this.initMapPaths;
    }

    public void setInitLatLonVisible(boolean v) {
        this.initLatLonVisible = v;
    }

    public void setInitLatLonColor(Color v) {
        this.initLatLonColor = v;
    }

    public void setInitLatLonWidth(int v) {
        this.initLatLonWidth = v;
    }

    public void setInitLatLonSpacing(float v) {
        this.initLatLonSpacing = v;
    }

    public void setInitMapWidth(float value) {
        this.initMapWidth = value;
    }

    public float getInitMapWidth() {
        return this.initMapWidth;
    }

    public void setInitMapColor(Color value) {
        this.initMapColor = value;
    }

    public Color getInitMapColor() {
        return this.initMapColor;
    }

    public void setInitLatLonBounds(Rectangle2D.Float value) {
        this.initLatLonBounds = value;
    }

    public Rectangle2D.Float getInitLatLonBounds() {
        return this.initLatLonBounds;
    }

    public LatLonAxisScaleInfo getLatAxisScaleInfo() {
        if (!this.hasDisplayMaster()) {
            return this.latAxisScaleInfo;
        }
        if (!this.useGlobeDisplay) {
            MapProjectionDisplay d = (MapProjectionDisplay)this.getNavigatedDisplay();
            return d.getLatScaleInfo();
        }
        return null;
    }

    public void setLatAxisScaleInfo(LatLonAxisScaleInfo axisScaleInfo) throws RemoteException, VisADException {
        this.latAxisScaleInfo = axisScaleInfo;
        if (!this.hasDisplayMaster()) {
            return;
        }
        if (!this.useGlobeDisplay) {
            MapProjectionDisplay d = (MapProjectionDisplay)this.getNavigatedDisplay();
            d.setLatScaleInfo(axisScaleInfo);
        }
    }

    public LatLonAxisScaleInfo getLonAxisScaleInfo() {
        if (!this.hasDisplayMaster()) {
            return this.lonAxisScaleInfo;
        }
        if (!this.useGlobeDisplay) {
            MapProjectionDisplay d = (MapProjectionDisplay)this.getNavigatedDisplay();
            return d.getLonScaleInfo();
        }
        return null;
    }

    public void setLonAxisScaleInfo(LatLonAxisScaleInfo axisScaleInfo) throws RemoteException, VisADException {
        this.lonAxisScaleInfo = axisScaleInfo;
        if (!this.hasDisplayMaster()) {
            return;
        }
        if (!this.useGlobeDisplay) {
            MapProjectionDisplay d = (MapProjectionDisplay)this.getNavigatedDisplay();
            d.setLonScaleInfo(axisScaleInfo);
        }
    }

    public static class ProjectionCommand
    extends Command {
        MapViewManager viewManager;
        String oldName;
        String oldProjection;
        String newName;
        String newProjection;

        public ProjectionCommand(MapViewManager viewManager, String oldName, MapProjection oldProjection, String newName, MapProjection newProjection) {
            this.viewManager = viewManager;
            this.oldName = oldName;
            this.oldProjection = this.encode(oldProjection);
            this.newName = newName;
            this.newProjection = this.encode(newProjection);
        }

        private String encode(MapProjection projection) {
            try {
                return this.viewManager.getIdv().encodeObject(projection, false);
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }

        private MapProjection decode(String xml) {
            try {
                return (MapProjection)this.viewManager.getIdv().decodeObject(xml);
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }

        @Override
        public void redoCommand() {
            this.viewManager.setMapProjection(this.decode(this.newProjection), true, this.newName, false, false);
        }

        @Override
        public void undoCommand() {
            this.viewManager.setMapProjection(this.decode(this.oldProjection), true, this.oldName, false, false);
        }
    }
}

