/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import ucar.nc2.time.CalendarDate;

public class LibVersionUtil {
    private static HashMap<String, String> getBuildInfo() throws IOException {
        HashMap<String, String> buildInfo = new HashMap<String, String>();
        Enumeration<URL> resources = CalendarDate.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            try {
                String implTitle;
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attrs = manifest.getMainAttributes();
                if (attrs == null || (implTitle = attrs.getValue("Implementation-Title")) == null || !implTitle.contains("CDM")) continue;
                buildInfo.put("version", attrs.getValue("Implementation-Version"));
                String strDate = attrs.getValue("Built-On");
                CalendarDate cd = CalendarDate.parseISOformat(null, strDate);
                buildInfo.put("buildDate", cd.toString());
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buildInfo;
    }

    public static String getNcidvVersion() {
        try {
            HashMap<String, String> myHash = LibVersionUtil.getBuildInfo();
            String ncIdvBuildInfo = myHash.get("version") + "-" + myHash.get("buildDate");
            return ncIdvBuildInfo;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            HashMap<String, String> myHash = LibVersionUtil.getBuildInfo();
            String ncIdvBuildInfo = myHash.get("version") + "-" + myHash.get("buildDate");
            System.out.println(ncIdvBuildInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

