/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.JTextComponent;
import org.python.core.PyFunction;
import org.python.core.PyList;
import org.python.core.PyStringMap;
import org.python.core.PySyntaxError;
import org.python.core.PyTableCode;
import org.python.core.PyTuple;
import org.python.util.PythonInterpreter;
import org.w3c.dom.Element;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DerivedDataDescriptor;
import ucar.unidata.data.DescriptorDataSource;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.PluginManager;
import ucar.unidata.idv.ui.FormulaDialog;
import ucar.unidata.idv.ui.JythonShell;
import ucar.unidata.ui.Help;
import ucar.unidata.ui.TextSearcher;
import ucar.unidata.ui.TreePanel;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;
import visad.VisADException;
import visad.python.JPythonEditor;

public class JythonManager
extends IdvManager
implements ActionListener {
    public static final String PROP_JYTHON_EDITOR = "idv.jython.editor";
    private static final Color COLOR_DISABLED = new Color(210, 210, 210);
    private boolean inError = false;
    private String tmpJython = "";
    private TreePanel treePanel;
    private ArrayList libHolders = new ArrayList();
    private JTextArea tmpTextArea = new JTextArea();
    private LibHolder tmpHolder;
    private DescriptorDataSource descriptorDataSource;
    List descriptors;
    private PythonInterpreter uiInterpreter = null;
    private TextSearcher textSearcher;
    private PythonInterpreter derivedDataInterpreter;
    private LibHolder mainHolder;
    private List interpreters = new ArrayList();
    private JMenuItem editFileMenuItem;
    private String pythonDir = IOUtil.joinDir(this.getStore().getUserDirectory().toString(), "python");
    private static Object MUTEX = new Object();
    private static Hashtable seenMethods = new Hashtable();
    private static Hashtable seenPaths = new Hashtable();

    public JythonManager(IntegratedDataViewer idv) {
        super(idv);
        if (!new File(this.pythonDir).exists()) {
            try {
                IOUtil.makeDir(this.pythonDir);
                File oldFile = new File(IOUtil.joinDir(this.getStore().getUserDirectory(), "default.py"));
                File newFile = new File(IOUtil.joinDir(this.pythonDir, "default.py"));
                if (oldFile.exists()) {
                    IOUtil.moveFile(oldFile, new File(this.pythonDir));
                } else {
                    IOUtil.writeFile(newFile.toString(), "");
                }
            }
            catch (Exception exc) {
                JythonManager.logException("Moving  jython lib", exc);
            }
        }
        this.writeJythonLib();
        this.initPython();
    }

    private void writeJythonLib() {
        try {
            String pythonLibDir = IOUtil.joinDir(this.getStore().getJythonCacheDir(), "Lib");
            if (new File(pythonLibDir).exists()) {
                return;
            }
            IOUtil.makeDir(pythonLibDir);
            InputStream is = null;
            try {
                is = IOUtil.getInputStream("/jythonlib.jar", this.getClass());
            }
            catch (Exception exc) {
                is = IOUtil.getInputStream("/lib/jythonlib.jar", this.getClass());
            }
            ZipInputStream zin = new ZipInputStream(is);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                String entryName = ze.getName();
                String dest = IOUtil.joinDir(pythonLibDir, entryName);
                if (ze.isDirectory()) {
                    IOUtil.makeDir(dest);
                    continue;
                }
                IOUtil.writeTo(zin, new FileOutputStream(dest));
            }
        }
        catch (Exception exc) {
            JythonManager.logException("Making jython lib directory", exc);
        }
    }

    private void initPython() {
        if (this.getArgsManager().isScriptingMode()) {
            this.initPythonInner();
        } else {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    JythonManager.this.initPythonInner();
                }
            });
        }
    }

    private void initPythonInner() {
        String cacheDir = this.getStore().getJythonCacheDir();
        ResourceCollection rc = this.getResourceManager().getResources(IdvResourceManager.RSC_JYTHONTOCOPY);
        rc.clearCache();
        try {
            for (int i = 0; i < rc.size(); ++i) {
                String path = rc.get(i).toString();
                String name = IOUtil.getFileTail(path);
                File localFile = new File(IOUtil.joinDir(cacheDir, name));
                String contents = rc.read(i);
                if (contents == null) continue;
                IOUtil.writeFile(localFile.getPath(), contents);
            }
        }
        catch (Exception exc) {
            JythonManager.logException("Writing jython lib", exc);
        }
        Properties pythonProps = new Properties();
        if (cacheDir != null) {
            pythonProps.put("python.home", cacheDir);
        }
        PythonInterpreter.initialize(System.getProperties(), pythonProps, this.getArgsManager().commandLineArgs);
        this.doMakeContents();
        if (!this.getArgsManager().isScriptingMode()) {
            this.makeFormulasFromLib();
        }
    }

    private void makeFormulasFromLib() {
        List procedures = this.findJythonMethods(true);
        for (int i = 0; i < procedures.size(); ++i) {
            PyFunction func = (PyFunction)procedures.get(i);
            String doc = func.__doc__.toString().trim();
            if (doc.equals("None")) continue;
            List<String> lines = StringUtil.split(doc, "\n", true, true);
            String formulaId = null;
            String desc = null;
            String group = null;
            Hashtable<String, String> attrProps = null;
            for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
                String line = lines.get(lineIdx);
                if (line.startsWith("@formulaid")) {
                    formulaId = line.substring("@formulaid".length()).trim();
                    continue;
                }
                if (line.startsWith("@description")) {
                    desc = line.substring("@description".length()).trim();
                    continue;
                }
                if (line.startsWith("@group")) {
                    group = line.substring("@group".length()).trim();
                    continue;
                }
                if (!line.startsWith("@param")) continue;
                line = line.substring("@param".length()).trim();
                String[] toks = StringUtil.split(line, " ", 2);
                if (attrProps == null) {
                    attrProps = new Hashtable<String, String>();
                }
                attrProps.put(toks[0], "[" + toks[1] + "]");
            }
            if (formulaId == null && desc == null) continue;
            if (formulaId == null) {
                formulaId = func.__name__;
            }
            ArrayList<DataCategory> categories = new ArrayList<DataCategory>();
            if (group != null) {
                categories.add(DataCategory.parseCategory(group, true));
            }
            DerivedDataDescriptor ddd = new DerivedDataDescriptor(this.getIdv(), formulaId, desc != null ? desc : func.__name__, this.makeCallString(func, attrProps), categories);
            this.descriptorDataSource.addDescriptor(ddd);
        }
    }

    public void showJythonEditor() {
        super.show();
    }

    private LibHolder findVisibleComponent() {
        for (int i = 0; i < this.libHolders.size(); ++i) {
            LibHolder holder = (LibHolder)this.libHolders.get(i);
            try {
                holder.outerContents.getLocationOnScreen();
                return holder;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public void exportSelectedToPlugin() {
        boolean hasTransferableText;
        LibHolder holder = this.findVisibleComponent();
        String text = "";
        holder.copy();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                if (holder.getText().indexOf(text) < 0) {
                    text = null;
                }
            }
            catch (Exception ex) {
                LogUtil.logException("Accessing clipboard", ex);
                return;
            }
        }
        if (text == null || text.trim().length() == 0) {
            LogUtil.userMessage("No text selected");
            return;
        }
        this.getIdv().getPluginManager().addText(text, "jython.py");
    }

    public void exportToPlugin() {
        LibHolder holder = this.findVisibleComponent();
        this.getIdv().getPluginManager().addText(holder.getText(), "jython.py");
    }

    @Override
    protected JComponent doMakeContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            ResourceCollection resources = this.getResourceManager().getResources(IdvResourceManager.RSC_JYTHON);
            if (resources == null) {
                LogUtil.userMessage("No Jython resources defined");
                return null;
            }
            this.treePanel = new TreePanel();
            this.libHolders = new ArrayList();
            boolean systemCnt = true;
            Hashtable<String, String> seen = new Hashtable<String, String>();
            for (int i = 0; i < resources.size(); ++i) {
                String showInEditor = resources.getProperty("showineditor", i);
                if (showInEditor != null && showInEditor.equals("false")) continue;
                String path = resources.get(i).toString();
                ArrayList<String> files = new ArrayList<String>();
                File file = new File(path);
                if (file.exists() && file.isDirectory()) {
                    Object[] libFiles = file.listFiles(new PatternFileFilter(".*\\.py$"));
                    files.addAll(Misc.toList(libFiles));
                } else {
                    files.add(path);
                }
                for (int fileIdx = 0; fileIdx < files.size(); ++fileIdx) {
                    boolean editable;
                    String text;
                    path = files.get(fileIdx).toString();
                    file = new File(path);
                    String canonicalPath = StringUtil.replace(path, "\\", "/");
                    if (seen.get(canonicalPath) != null) continue;
                    seen.put(canonicalPath, canonicalPath);
                    String label = resources.getLabel(i);
                    if (label == null) {
                        label = IOUtil.getFileTail(PluginManager.decode(path));
                    }
                    if ((text = IOUtil.readContents(path, (String)null)) != null && Misc.isHtml(text)) continue;
                    boolean bl = editable = resources.isWritableResource(i) || file.exists() && file.canWrite();
                    if (!editable && (new File(path).isDirectory() || text == null)) continue;
                    LibHolder libHolder = this.makeLibHolder(editable, label, path, text);
                    String category = resources.getProperty("category", i);
                    String treeCategory = null;
                    if (libHolder.isEditable()) {
                        treeCategory = "Local Jython";
                    } else if (category != null) {
                        treeCategory = category;
                    }
                    this.treePanel.addComponent(libHolder.outerContents, treeCategory, label, null);
                }
            }
            String tmpPath = this.getIdv().getStore().getTmpFile("tmp.py");
            this.tmpHolder = this.makeLibHolder(false, "Temporary Jython", tmpPath, "");
            this.treePanel.addComponent(this.tmpHolder.outerContents, null, "Temporary", null);
            JMenuBar menuBar = new JMenuBar();
            JMenu fileMenu = GuiUtils.makeDynamicMenu("File", this, "makeFileMenu");
            JMenu helpMenu = new JMenu("Help");
            menuBar.add(fileMenu);
            menuBar.add(helpMenu);
            helpMenu.add(GuiUtils.makeMenuItem("Show Jython Help", this, "showHelp"));
            this.textSearcher = new TextSearcher(){

                @Override
                public TextSearcher.TextWrapper getTextWrapper() {
                    return JythonManager.this.findVisibleComponent();
                }
            };
            this.contents = GuiUtils.topCenterBottom(menuBar, this.treePanel, this.textSearcher);
            this.setMenuBar(menuBar);
            return this.contents;
        }
        catch (Throwable exc) {
            JythonManager.logException("Creating jython editor", exc);
            return null;
        }
    }

    public boolean saveOnExit() {
        if (this.getArgsManager().isScriptingMode()) {
            return true;
        }
        ArrayList<LibHolder> toSave = new ArrayList<LibHolder>();
        for (int i = this.libHolders.size() - 1; i >= 0; --i) {
            LibHolder holder = (LibHolder)this.libHolders.get(i);
            if (holder.saveBtn == null || !holder.isEditable() || !holder.saveBtn.isEnabled()) continue;
            toSave.add(holder);
        }
        if (toSave.size() > 0) {
            int response = GuiUtils.showYesNoCancelDialog(null, "Do you want to save the modified Jython before exiting?", "Save Jython");
            if (response == 2) {
                return false;
            }
            if (response == 0) {
                for (int i = toSave.size() - 1; i >= 0; --i) {
                    LibHolder holder = (LibHolder)toSave.get(i);
                    if (this.writeJythonLib(holder)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private LibHolder makeLibHolder(boolean editable, String label, String path, String text) throws VisADException {
        LibHolder libHolder;
        final LibHolder[] holderArray = new LibHolder[]{null};
        final MyPythonEditor jythonEditor = new MyPythonEditor(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                if (holderArray[0] != null && holderArray[0].saveBtn != null) {
                    holderArray[0].saveBtn.setEnabled(true);
                    holderArray[0].functions = null;
                }
                super.undoableEditHappened(e);
            }
        };
        jythonEditor.getTextComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GuiUtils.isControlKey(e, 70)) {
                    // empty if block
                }
            }
        });
        jythonEditor.getTextComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JPopupMenu popup;
                int idx;
                holderArray[0].setSearchIndex(new Point(e.getX(), e.getY()));
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                JTextComponent comp = jythonEditor.getTextComponent();
                int point = comp.viewToModel(new Point(e.getX(), e.getY()));
                String text = comp.getText();
                String token = "";
                ArrayList<Object> items = new ArrayList<Object>();
                JMenuItem helpMenuItem = null;
                if (idx < 0 || idx >= text.length()) {
                    return;
                }
                for (idx = point; idx >= 0; --idx) {
                    char c = text.charAt(idx);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    token = c + token;
                }
                int len = text.length();
                for (idx = point + 1; idx < len; ++idx) {
                    char c = text.charAt(idx);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    token = token + c;
                }
                if (token.length() == 0) {
                    token = comp.getSelectedText();
                }
                if (token != null && token.trim().length() > 0) {
                    token = token.trim();
                    List funcs = JythonManager.this.findJythonMethods(true, Misc.newList(holderArray[0]));
                    for (int i = 0; i < funcs.size(); ++i) {
                        PyFunction func = (PyFunction)funcs.get(i);
                        if (!func.__name__.equals(token)) continue;
                        items.add(GuiUtils.makeMenuItem("Make formula for " + token, JythonManager.this, "makeFormula", func));
                        String helpLink = "idv.tools.jythonlib." + func.__name__;
                        if (!Help.getDefaultHelp().isValidID(helpLink)) break;
                        helpMenuItem = GuiUtils.makeMenuItem("Help", JythonManager.this, "showHelp", helpLink);
                        break;
                    }
                }
                if (holderArray[0].isEditable()) {
                    items.add(GuiUtils.makeMenu("Insert Procedure Call", JythonManager.this.makeProcedureMenu(jythonEditor, "insertText", null)));
                    items.add(GuiUtils.makeMenu("Insert Idv Action", JythonManager.this.getIdv().getIdvUIManager().makeActionMenu(jythonEditor, "insertText", true)));
                }
                if (helpMenuItem != null) {
                    items.add("separator");
                    items.add(helpMenuItem);
                }
                if ((popup = GuiUtils.makePopupMenu(items)) == null) {
                    return;
                }
                popup.show(jythonEditor.getTextComponent(), e.getX(), e.getY());
            }
        });
        jythonEditor.setPreferredSize(new Dimension(500, 400));
        JPanel wrapper = GuiUtils.center(jythonEditor);
        holderArray[0] = libHolder = new LibHolder(editable, this, label, jythonEditor, path, wrapper);
        if (this.mainHolder == null) {
            this.mainHolder = libHolder;
        }
        this.libHolders.add(libHolder);
        if (text == null) {
            text = "";
        }
        if (text != null) {
            jythonEditor.setText(text);
        }
        if (libHolder.saveBtn != null) {
            libHolder.saveBtn.setEnabled(false);
        }
        return libHolder;
    }

    public void makeFormula(PyFunction func) {
        String name = func.__name__;
        DerivedDataDescriptor ddd = null;
        for (int dddIdx = 0; dddIdx < this.descriptors.size(); ++dddIdx) {
            DerivedDataDescriptor tmp = (DerivedDataDescriptor)this.descriptors.get(dddIdx);
            if (!tmp.getId().equals(name)) continue;
            ddd = tmp;
            break;
        }
        boolean isNew = true;
        if (ddd != null) {
            isNew = false;
            if (!GuiUtils.askOkCancel("Formula Exists", "<html>A formula with the name: " + name + " already exists.</br>Do you want to edit it?</html>")) {
                return;
            }
        }
        if (ddd == null) {
            ddd = new DerivedDataDescriptor(this.getIdv(), name, "", this.makeCallString(func, null), new ArrayList());
        }
        this.showFormulaDialog(ddd, isNew);
    }

    public void makeNewLibrary() {
        String name = "";
        try {
            String fullName;
            while (true) {
                if ((name = GuiUtils.getInput("Enter name for library", "Name: ", name)) == null) {
                    return;
                }
                fullName = IOUtil.cleanFileName(name);
                if (!fullName.endsWith(".py")) {
                    fullName = fullName + ".py";
                }
                if (!new File(fullName = IOUtil.joinDir(this.pythonDir, fullName)).exists()) break;
                LogUtil.userErrorMessage("A jython library with the given name already exists");
            }
            IOUtil.writeFile(fullName, "");
            LibHolder libHolder = this.makeLibHolder(true, name, fullName, "");
            this.treePanel.addComponent(libHolder.outerContents, "Local Jython", name, null);
        }
        catch (Exception exc) {
            JythonManager.logException("An error occurred creating the jython library", exc);
        }
    }

    public List getLibHolders() {
        return this.libHolders;
    }

    public void removeLibrary(LibHolder holder) {
        if (!GuiUtils.askYesNo("Remove Jython Library", "Are you sure you want to remove the library: " + IOUtil.getFileTail(holder.filePath))) {
            return;
        }
        try {
            this.libHolders.remove(holder);
            this.treePanel.removeComponent(holder.outerContents);
            new File(holder.filePath).delete();
        }
        catch (Exception exc) {
            JythonManager.logException("An error occurred removing jython library", exc);
        }
    }

    public void makeFileMenu(JMenu fileMenu) {
        LibHolder holder = this.findVisibleComponent();
        fileMenu.add(GuiUtils.makeMenuItem("New Jython Library...", this, "makeNewLibrary"));
        if (holder != null && holder.isEditable() && holder.editProcess == null) {
            fileMenu.add(GuiUtils.makeMenuItem("Remove  Library", this, "removeLibrary", holder));
            fileMenu.add(GuiUtils.makeMenuItem("Save", this, "writeJythonLib", holder));
            if (this.getStateManager().getPreferenceOrProperty(PROP_JYTHON_EDITOR, "").trim().length() > 0) {
                this.editFileMenuItem = GuiUtils.makeMenuItem("Edit in External Editor", this, "editInExternalEditor");
                fileMenu.add(this.editFileMenuItem);
            }
        }
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Export to Plugin", this, "exportToPlugin"), "/auxdata/ui/icons/plugin_add.png"));
        fileMenu.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Export Selected to Plugin", this, "exportSelectedToPlugin"), "/auxdata/ui/icons/plugin_add.png"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Close", this, "close"));
    }

    protected void applicationClosing() {
        if (this.getArgsManager().isScriptingMode()) {
            return;
        }
        for (int i = this.libHolders.size() - 1; i >= 0; --i) {
            LibHolder holder = (LibHolder)this.libHolders.get(i);
            if (holder.editProcess == null) continue;
            try {
                holder.editProcess.destroy();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void editInExternalEditor() {
        Misc.run(this, "editInExternalEditorInner", this.findVisibleComponent());
    }

    public void editInExternalEditorInner(final LibHolder holder) {
        try {
            if (holder == null || !holder.isEditable() || holder.editProcess != null) {
                return;
            }
            if (!this.writeJythonLib(holder)) {
                return;
            }
            holder.wrapper.removeAll();
            holder.wrapper.repaint();
            this.editFileMenuItem.setEnabled(false);
            holder.pythonEditor.setEnabled(false);
            String filename = holder.filePath;
            File file = new File(filename);
            long fileTime = file.lastModified();
            String command = this.getStateManager().getPreferenceOrProperty(PROP_JYTHON_EDITOR, "").trim();
            if (command.length() == 0) {
                return;
            }
            List<String> toks = StringUtil.split(command, " ", true, true);
            if (command.indexOf("%filename%") < 0) {
                toks.add("%filename%");
            }
            for (int i = 0; i < toks.size(); ++i) {
                String tok = toks.get(i);
                toks.set(i, StringUtil.replace(tok, "%filename%", filename));
            }
            try {
                holder.editProcess = Runtime.getRuntime().exec(Misc.listToStringArray(toks));
            }
            catch (Exception exc) {
                holder.editProcess = null;
                JythonManager.logException("An error occurred editing jython library", exc);
            }
            if (holder.editProcess != null) {
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            holder.editProcess.waitFor();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        holder.editProcess = null;
                    }
                });
            }
            while (holder.editProcess != null) {
                Misc.sleep(1000L);
                if (file.lastModified() == fileTime) continue;
                fileTime = file.lastModified();
                try {
                    String text = IOUtil.readContents(file);
                    holder.setText(text, false);
                    this.evaluateLibJython(false, holder);
                }
                catch (Exception exc) {
                    JythonManager.logException("An error occurred editing jython library", exc);
                }
            }
            holder.pythonEditor.setEnabled(true);
            holder.wrapper.add("Center", holder.pythonEditor);
            holder.wrapper.repaint();
            this.editFileMenuItem.setEnabled(true);
        }
        catch (Exception exc) {
            JythonManager.logException("An error occurred editing jython library", exc);
        }
    }

    @Override
    public String getWindowTitle() {
        return "Jython libraries";
    }

    public void showHelp() {
        this.showHelp("idv.tools.jython");
    }

    public void showHelp(String help) {
        this.getIdvUIManager().showHelp(help);
    }

    public PythonInterpreter createInterpreter() {
        PythonInterpreter interp = new PythonInterpreter();
        this.addInterpreter(interp);
        return interp;
    }

    public JythonShell createShell() {
        return new JythonShell(this.getIdv());
    }

    private void addInterpreter(PythonInterpreter interp) {
        this.interpreters.add(interp);
        this.initInterpreter(interp);
    }

    public void removeInterpreter(PythonInterpreter interp) {
        this.interpreters.remove(interp);
    }

    private void applyJythonResources(PythonInterpreter interp, ResourceCollection resources) {
        if (resources == null || interp == null) {
            return;
        }
        for (int i = resources.size() - 1; i >= 0; --i) {
            String resourceName = resources.get(i).toString();
            InputStream is = null;
            try {
                is = IOUtil.getInputStream(resourceName, this.getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (is == null) continue;
            try {
                interp.execfile(is, resourceName);
                continue;
            }
            catch (PySyntaxError pse) {
                String result;
                if (resources.isHttp(i) && ((result = resources.read(i, false)) == null || Misc.isHtml(result))) continue;
                LogUtil.userErrorMessage("Syntax error in the Python library:" + resourceName + "\n" + pse);
                this.inError = true;
                continue;
            }
            catch (Exception exc) {
                JythonManager.logException("An error occurred reading jython library: " + resourceName, exc);
                this.inError = true;
            }
        }
    }

    public boolean getInError() {
        return this.inError;
    }

    private void initBasicInterpreter(PythonInterpreter interpreter) {
        JythonManager.doBasicImports(interpreter);
        interpreter.set("idv", this.getIdv());
        interpreter.set("interpreter", interpreter);
        interpreter.set("datamanager", this.getDataManager());
        interpreter.set("installmanager", this.getInstallManager());
    }

    private static void doBasicImports(PythonInterpreter interpreter) {
        interpreter.exec("import sys");
        interpreter.exec("import java");
        interpreter.exec("sys.add_package('visad')");
        interpreter.exec("sys.add_package('visad.python')");
        interpreter.exec("sys.add_package('visad.data.units')");
        interpreter.exec("from visad.python.JPythonMethods import *");
        interpreter.exec("import ucar.unidata.data.grid.GridUtil as GridUtil");
        interpreter.exec("import ucar.unidata.data.DataSelection as DataSelection");
        interpreter.exec("import ucar.unidata.data.GeoLocationInfo as GeoLocationInfo");
        interpreter.exec("import ucar.unidata.data.GeoSelection as GeoSelection");
        interpreter.exec("from java.lang import Integer");
        interpreter.exec("import ucar.unidata.data.grid.GridMath as GridMath");
        interpreter.exec("import ucar.unidata.data.DataUtil as DataUtil");
        interpreter.exec("import ucar.visad.Util as Util");
        interpreter.exec("import ucar.unidata.util.StringUtil as StringUtil");
        interpreter.exec("import ucar.unidata.data.grid.DerivedGridFactory as DerivedGridFactory");
        interpreter.exec("import ucar.unidata.data.grid.GridTrajectory as GridTrajectory");
    }

    private void initInterpreter(PythonInterpreter interpreter) {
        int i;
        this.initBasicInterpreter(interpreter);
        if (DerivedDataDescriptor.classes != null) {
            for (i = 0; i < DerivedDataDescriptor.classes.size(); ++i) {
                String c = (String)DerivedDataDescriptor.classes.get(i);
                int i1 = c.lastIndexOf(".");
                String pkg = c.substring(0, i1);
                String className = c.substring(i1 + 1);
                interpreter.exec("sys.add_package('" + pkg + "')");
                interpreter.exec("from " + pkg + " import " + className);
            }
        }
        for (i = this.libHolders.size() - 1; i >= 0; --i) {
            LibHolder holder = (LibHolder)this.libHolders.get(i);
            String jython = holder.getText();
            interpreter.exec(jython);
        }
    }

    public String getUsersJythonText() {
        this.getContents();
        return this.mainHolder.getText();
    }

    public void appendTmpJython(String jython) {
        String oldJython = this.tmpHolder.getText();
        if (oldJython.indexOf(jython) < 0) {
            String newJython = oldJython + "\n\n## Imported jython from bundle\n" + jython;
            this.tmpHolder.setText(newJython);
        }
        this.evaluateLibJython(false, this.tmpHolder);
    }

    public void appendJythonFromBundle(String jython) {
        String oldJython = this.getUsersJythonText();
        if (oldJython.indexOf(jython) >= 0) {
            return;
        }
        String newJython = oldJython + "\n\n## Imported jython from bundle\n" + jython;
        this.mainHolder.setText(newJython);
        this.writeJythonLib(this.mainHolder);
    }

    public void appendJython(String jython) {
        String oldJython = this.getUsersJythonText();
        String newJython = oldJython + "\n\n\n" + jython;
        this.mainHolder.setText(newJython);
        this.show();
        GuiUtils.showComponentInTabs(this.mainHolder.outerContents);
    }

    private boolean evaluateLibJython(boolean forWriting, LibHolder holderToWrite) {
        boolean ok = false;
        String what = "";
        try {
            if (this.interpreters.size() == 0) {
                this.getDerivedDataInterpreter();
            }
            List holders = Misc.newList(holderToWrite);
            for (int i = 0; i < holders.size(); ++i) {
                LibHolder holder = (LibHolder)holders.get(i);
                if (!holder.isEditable()) continue;
                String jython = holder.getText();
                for (int interpIdx = 0; interpIdx < this.interpreters.size(); ++interpIdx) {
                    ((PythonInterpreter)this.interpreters.get(interpIdx)).exec(jython);
                }
            }
            ok = true;
        }
        catch (PySyntaxError pse) {
            try {
                if (forWriting) {
                    if (GuiUtils.showYesNoDialog(null, "There was an error in the Python library:" + pse, "Python error", "Save anyways", "Cancel")) {
                        return true;
                    }
                }
                JythonManager.logException("There was an error in the Python library:" + pse, pse);
            }
            catch (Throwable exc) {
                JythonManager.logException("Writing jython library " + exc.getClass().getName(), exc);
            }
        }
        catch (Throwable exc) {
            JythonManager.logException("Writing jython library " + exc.getClass().getName(), exc);
        }
        return ok;
    }

    public boolean writeJythonLib(LibHolder holder) {
        if (this.evaluateLibJython(true, holder)) {
            try {
                IOUtil.writeFile(holder.filePath, holder.getText());
                if (holder.saveBtn != null) {
                    holder.saveBtn.setEnabled(false);
                }
                return true;
            }
            catch (Throwable exc) {
                JythonManager.logException("Writing jython library " + exc.getClass().getName(), exc);
            }
        }
        return false;
    }

    protected static boolean checkUntrustedJython(String jython) {
        jython = StringUtil.removeWhitespace(jython);
        String argPattern = "([^()',]+|'[^']*')";
        String argsPattern = "((" + argPattern + ",)*" + argPattern + "?)";
        String pattern = "^((idv|datamanager).[^\\s(]+\\(" + argsPattern + "\\);?)+$";
        if (!StringUtil.stringMatch(jython, pattern)) {
            pattern = "^(idv.get[a-zA-Z]+\\(\\).[^\\s(]+\\(" + argsPattern + "\\);?)+$";
            return StringUtil.stringMatch(jython, pattern);
        }
        return true;
    }

    public void evaluateUntrusted(String jythonCode) {
        this.evaluateUntrusted(jythonCode, null);
    }

    public void evaluateUntrusted(String jythonCode, Hashtable properties) {
        if (!JythonManager.checkUntrustedJython(jythonCode)) {
            LogUtil.userMessage("Malformed jython code:\n" + jythonCode);
            return;
        }
        this.evaluateTrusted(jythonCode, properties);
    }

    public void evaluateTrusted(String code) {
        this.evaluateTrusted(code, null);
    }

    public void evaluateTrusted(String code, Hashtable properties) {
        PythonInterpreter interp = this.getUiInterpreter();
        if (properties != null) {
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String param = (String)keys.nextElement();
                Object value = properties.get(param);
                interp.set(param, value);
            }
        }
        interp.exec(code);
    }

    private PythonInterpreter getUiInterpreter() {
        if (this.uiInterpreter == null) {
            this.uiInterpreter = new PythonInterpreter();
            this.addInterpreter(this.uiInterpreter);
        }
        return this.uiInterpreter;
    }

    public void dataGroupsChanged() {
        for (int dddIdx = 0; dddIdx < this.descriptors.size(); ++dddIdx) {
            DerivedDataDescriptor ddd = (DerivedDataDescriptor)this.descriptors.get(dddIdx);
            ddd.updateDataGroups();
        }
    }

    protected void initUserFormulas(IdvResourceManager newIrm) {
        if (this.descriptorDataSource != null) {
            return;
        }
        try {
            this.descriptors = DerivedDataDescriptor.init(this.getIdv(), newIrm.getXmlResources(IdvResourceManager.RSC_DERIVED));
            if (this.descriptors.size() == 0) {
                return;
            }
            this.descriptorDataSource = new DescriptorDataSource("Formulas", "Formulas");
            for (int dddIdx = 0; dddIdx < this.descriptors.size(); ++dddIdx) {
                DerivedDataDescriptor ddd = (DerivedDataDescriptor)this.descriptors.get(dddIdx);
                this.descriptorDataSource.addDescriptor(ddd);
            }
        }
        catch (Throwable exc) {
            JythonManager.logException("Initializing user formulas", exc);
        }
    }

    protected List selectFormulas() {
        Vector<TwoFacedObject> formulas = new Vector<TwoFacedObject>();
        for (int i = 0; i < this.descriptors.size(); ++i) {
            DerivedDataDescriptor ddd = (DerivedDataDescriptor)this.descriptors.get(i);
            DataCategory cat = ddd.getDisplayCategory();
            String label = "";
            if (cat != null) {
                label = cat.toString(">") + ">";
            }
            label = label + ddd.getDescription();
            formulas.add(new TwoFacedObject((Object)label, ddd));
        }
        JList formulaList = new JList(formulas);
        JScrollPane scroller = GuiUtils.makeScrollPane(formulaList, 200, 300);
        JPanel contents = GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.cLabel("Please select the formulas you would like to export"), 4), scroller);
        if (!GuiUtils.showOkCancelDialog(null, "Export Formulas", GuiUtils.inset((Component)contents, 5), null)) {
            return null;
        }
        Object[] items = formulaList.getSelectedValues();
        if (items == null || items.length == 0) {
            return null;
        }
        ArrayList<Object> selected = new ArrayList<Object>();
        for (int i = 0; i < items.length; ++i) {
            TwoFacedObject tfo = (TwoFacedObject)items[i];
            selected.add(tfo.getId());
        }
        return selected;
    }

    public void exportFormulasToPlugin() {
        List selected = this.selectFormulas();
        if (selected == null || selected.size() == 0) {
            return;
        }
        this.getIdv().getPluginManager().addObject(selected);
    }

    public void exportFormulas() {
        List selected = this.selectFormulas();
        if (selected == null || selected.size() == 0) {
            return;
        }
        String xml = DerivedDataDescriptor.toXml(selected);
        String filename = FileManager.getWriteFile(FILTER_XML, ".xml");
        if (filename == null) {
            return;
        }
        try {
            IOUtil.writeFile(filename, xml);
        }
        catch (Exception exc) {
            JythonManager.logException("Writing file: " + filename, exc);
        }
    }

    public void importFormulas() {
        String filename = FileManager.getReadFile(FILTER_XML);
        if (filename == null) {
            return;
        }
        try {
            Element root = XmlUtil.getRoot(filename, this.getClass());
            List fileDescriptors = DerivedDataDescriptor.readDescriptors(this.getIdv(), root, true);
            List localDescriptors = this.getLocalDescriptors();
            for (int i = 0; i < fileDescriptors.size(); ++i) {
                DerivedDataDescriptor ddd = (DerivedDataDescriptor)fileDescriptors.get(i);
                if (localDescriptors.contains(ddd)) continue;
                this.addFormula(ddd);
            }
            this.writeUserFormulas();
            this.getIdvUIManager().dataSourceChanged(this.descriptorDataSource);
        }
        catch (Exception exc) {
            JythonManager.logException("Importing  formulas", exc);
        }
    }

    protected void writeUserFormulas() {
        List descriptors = this.getLocalDescriptors();
        try {
            String filename = this.getResourceManager().getXmlResources(IdvResourceManager.RSC_DERIVED).getWritable();
            String xml = DerivedDataDescriptor.toXml(descriptors);
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(xml.getBytes());
            fos.close();
        }
        catch (Throwable exc) {
            JythonManager.logException("Writing user formulas", exc);
            return;
        }
    }

    public void doMakeDataChoiceMenuItems(DataChoice dataChoice, List items) {
        final DerivedDataDescriptor ddd = ((DerivedDataChoice)dataChoice).getDataDescriptor();
        JMenuItem mi = new JMenuItem("Edit Formula");
        items.add(mi);
        mi.addActionListener(new ObjectListener(dataChoice){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JythonManager.this.showFormulaDialog(ddd.getIsLocalUsers() ? ddd : new DerivedDataDescriptor(ddd));
            }
        });
        mi = new JMenuItem("Copy Formula");
        items.add(mi);
        mi.addActionListener(new ObjectListener(dataChoice){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JythonManager.this.showFormulaDialog(new DerivedDataDescriptor(ddd));
            }
        });
        if (ddd.getIsLocalUsers()) {
            mi = new JMenuItem("Remove Formula");
            items.add(mi);
            mi.addActionListener(new ObjectListener(dataChoice){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    JythonManager.this.removeFormula((DerivedDataChoice)this.theObject);
                }
            });
        }
        mi = new JMenuItem("Evaluate Formula");
        mi.addActionListener(new ObjectListener(dataChoice){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        JythonManager.this.evaluateDataChoice((DataChoice)theObject);
                    }
                });
            }
        });
        items.add(mi);
        mi = new JMenuItem("Evaluate and Save");
        mi.addActionListener(new ObjectListener(dataChoice){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        JythonManager.this.getIdv().evaluateAndSave((DataChoice)theObject);
                    }
                });
            }
        });
        items.add(mi);
        items.add(GuiUtils.makeMenuItem("Export to Plugin", this.getIdv().getPluginManager(), "addObject", ddd));
    }

    public void deleteKeyPressed(DataChoice dataChoice) {
        if (dataChoice == null || !(dataChoice instanceof DerivedDataChoice)) {
            return;
        }
        DerivedDataDescriptor ddd = ((DerivedDataChoice)dataChoice).getDataDescriptor();
        if (ddd.getIsLocalUsers()) {
            this.removeFormula((DerivedDataChoice)dataChoice);
        }
    }

    public void evaluateDataChoice(DataChoice dataChoice) {
        DataChoice clonedDataChoice = dataChoice.createClone();
        this.showWaitCursor();
        try {
            clonedDataChoice.getData(new DataSelection());
        }
        catch (DataCancelException dataCancelException) {
        }
        catch (Exception exc) {
            JythonManager.logException("Evaluating data choice", exc);
        }
        this.showNormalCursor();
    }

    public void removeFormula(DerivedDataChoice dataChoice) {
        this.removeFormula(dataChoice.getDataDescriptor());
    }

    public void removeFormula(DerivedDataDescriptor ddd) {
        if (ddd.getIsLocalUsers()) {
            this.descriptors.remove(ddd);
            this.descriptorDataSource.removeDescriptor(ddd);
            this.writeUserFormulas();
            this.getIdvUIManager().dataSourceChanged(this.descriptorDataSource);
        } else {
            LogUtil.userMessage("Can't remove a system formula");
        }
    }

    public void descriptorChanged(DerivedDataDescriptor ddd) {
        ddd.setIsLocalUsers(true);
        if (!this.descriptors.contains(ddd)) {
            this.descriptors.add(ddd);
            this.descriptorDataSource.addDescriptor(ddd);
        }
        this.writeUserFormulas();
        this.getIdvUIManager().dataSourceChanged(this.descriptorDataSource);
    }

    public void addFormula(DerivedDataDescriptor ddd) {
        this.descriptorChanged(ddd);
    }

    public List doMakeFormulaDataSourceMenuItems(DataSource dataSource) {
        ArrayList<AbstractButton> menuItems = new ArrayList<AbstractButton>();
        menuItems.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Create Formula", this, "showFormulaDialog"), "/auxdata/ui/icons/formula_add.png"));
        menuItems.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Edit Jython Library", this, "showJythonEditor"), "/auxdata/ui/icons/EditJython16.gif"));
        menuItems.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Import Formulas", this, "importFormulas"), "/auxdata/ui/icons/formula_import.png"));
        menuItems.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Export Formulas", this, "exportFormulas"), "/auxdata/ui/icons/formula_export.png"));
        menuItems.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Export Formulas to Plugin", this, "exportFormulasToPlugin"), "/auxdata/ui/icons/plugin_add.png"));
        if (dataSource instanceof DescriptorDataSource) {
            menuItems.add(GuiUtils.makeMenu("Edit Formulas", this.doMakeEditMenuItems((DescriptorDataSource)dataSource)));
        }
        return menuItems;
    }

    public List doMakeEditMenuItems() {
        return this.doMakeEditMenuItems(this.descriptorDataSource);
    }

    public List doMakeEditMenuItems(DescriptorDataSource dds) {
        int i;
        ArrayList<JMenuItem> editMenuItems = new ArrayList<JMenuItem>();
        List descriptors = dds.getDescriptors();
        Hashtable<String, JMenu> catMenus = new Hashtable<String, JMenu>();
        ArrayList<JMenuItem> topItems = new ArrayList<JMenuItem>();
        JMenu derivedMenu = null;
        for (i = 0; i < descriptors.size(); ++i) {
            DataCategory dc;
            DerivedDataDescriptor ddd = (DerivedDataDescriptor)descriptors.get(i);
            JMenu catMenu = null;
            String catSoFar = "";
            JMenuItem mi = GuiUtils.makeMenuItem(GuiUtils.getLocalName(ddd.getDescription(), ddd.getIsLocalUsers()), this, "showFormulaDialog", ddd);
            if (dc == null) {
                if (ddd.getIsDefault() && !ddd.getIsEndUser()) {
                    if (derivedMenu == null) {
                        derivedMenu = new JMenu("Derived Quantities");
                    }
                    derivedMenu.add(mi);
                    continue;
                }
                topItems.add(mi);
                continue;
            }
            for (dc = ddd.getDisplayCategory(); dc != null; dc = dc.getChild()) {
                String name = dc.getName();
                JMenu tmpMenu = (JMenu)catMenus.get(catSoFar = catSoFar + "-" + name);
                if (tmpMenu == null) {
                    tmpMenu = new JMenu(name);
                    catMenus.put(catSoFar, tmpMenu);
                    if (catMenu == null) {
                        editMenuItems.add(tmpMenu);
                    } else {
                        catMenu.add(tmpMenu);
                    }
                }
                catMenu = tmpMenu;
            }
            if (catMenu == null) {
                editMenuItems.add(mi);
                continue;
            }
            catMenu.add(mi);
        }
        if (derivedMenu != null) {
            editMenuItems.add(derivedMenu);
        }
        for (i = 0; i < topItems.size(); ++i) {
            editMenuItems.add((JMenuItem)topItems.get(i));
        }
        return editMenuItems;
    }

    public void showFormulaDialog() {
        this.showFormulaDialog(null);
    }

    public List getDescriptors() {
        return this.descriptors;
    }

    public List getEndUserDescriptors() {
        ArrayList<DerivedDataDescriptor> formulas = new ArrayList<DerivedDataDescriptor>();
        for (int i = 0; i < this.descriptors.size(); ++i) {
            DerivedDataDescriptor ddd = (DerivedDataDescriptor)this.descriptors.get(i);
            if (!ddd.getIsEndUser()) continue;
            formulas.add(ddd);
        }
        return formulas;
    }

    public List getLocalDescriptors() {
        ArrayList<DerivedDataDescriptor> formulas = new ArrayList<DerivedDataDescriptor>();
        for (int i = 0; i < this.descriptors.size(); ++i) {
            DerivedDataDescriptor ddd = (DerivedDataDescriptor)this.descriptors.get(i);
            if (!ddd.getIsLocalUsers()) continue;
            formulas.add(ddd);
        }
        return formulas;
    }

    public List getDefaultDescriptors() {
        ArrayList<DerivedDataDescriptor> formulas = new ArrayList<DerivedDataDescriptor>();
        for (int i = 0; i < this.descriptors.size(); ++i) {
            DerivedDataDescriptor ddd = (DerivedDataDescriptor)this.descriptors.get(i);
            if (!ddd.getIsDefault()) continue;
            formulas.add(ddd);
        }
        return formulas;
    }

    public void showFormulaDialog(DerivedDataDescriptor descriptor) {
        this.showFormulaDialog(descriptor, descriptor == null);
    }

    public void showFormulaDialog(DerivedDataDescriptor descriptor, boolean isNew) {
        ArrayList<String> categories = new ArrayList<String>();
        DescriptorDataSource dds = this.getDescriptorDataSource();
        if (dds != null) {
            List descriptors = dds.getDescriptors();
            for (int i = 0; i < descriptors.size(); ++i) {
                String catStr;
                DataCategory cat;
                DerivedDataDescriptor ddd = (DerivedDataDescriptor)descriptors.get(i);
                if (!ddd.getIsEndUser() || (cat = ddd.getDisplayCategory()) == null || categories.contains(catStr = cat.toString())) continue;
                categories.add(catStr);
            }
        }
        new FormulaDialog(this.getIdv(), descriptor, null, categories, isNew);
    }

    public DescriptorDataSource getDescriptorDataSource() {
        return this.descriptorDataSource;
    }

    public PythonInterpreter getDerivedDataInterpreter() {
        return this.getDerivedDataInterpreter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PythonInterpreter getDerivedDataInterpreter(String methodName) {
        Object object = MUTEX;
        synchronized (object) {
            if (this.derivedDataInterpreter == null) {
                this.derivedDataInterpreter = this.createInterpreter();
            }
            if (methodName != null && seenMethods.get(methodName) == null) {
                seenMethods.put(methodName, methodName);
                int i1 = methodName.lastIndexOf(".");
                int i2 = methodName.indexOf(".");
                if (i1 >= 0 && i2 >= 0) {
                    String fullPath = methodName.substring(0, i1);
                    if (i1 != i2 && seenPaths.get(fullPath) == null) {
                        i1 = fullPath.lastIndexOf(".");
                        String pkg = fullPath.substring(0, i1);
                        String className = fullPath.substring(i1 + 1);
                        this.derivedDataInterpreter.exec("sys.add_package('" + pkg + "')");
                        this.derivedDataInterpreter.exec("from " + pkg + " import " + className);
                    }
                }
            }
        }
        return this.derivedDataInterpreter;
    }

    public List makeProcedureMenu(final Object object, final String method, final String prefix) {
        ArrayList<JMenu> menuItems = new ArrayList<JMenu>();
        List holders = this.getLibHolders();
        for (int i = 0; i < holders.size(); ++i) {
            ArrayList subItems = new ArrayList();
            final LibHolder libHolder = (LibHolder)holders.get(i);
            final JMenu menu = new JMenu(libHolder.getName());
            menu.addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent e) {
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuSelected(MenuEvent e) {
                    List funcs = libHolder.getFunctions();
                    menu.removeAll();
                    int cnt = 0;
                    for (int itemIdx = 0; itemIdx < funcs.size(); ++itemIdx) {
                        Object[] pair = (Object[])funcs.get(itemIdx);
                        PyFunction func = (PyFunction)pair[1];
                        StringBuffer sb = new StringBuffer();
                        sb.append(JythonManager.this.makeCallString(func, null));
                        String s = sb.toString();
                        if (prefix != null && !s.startsWith(prefix)) continue;
                        JMenuItem menuItem = GuiUtils.makeMenuItem(s, object, method, s);
                        if (!func.__doc__.toString().equals("None")) {
                            String doc = "<html><pre>" + func.__doc__.toString().trim() + "</html>";
                            menuItem.setToolTipText(doc);
                        }
                        menu.add(menuItem);
                        ++cnt;
                    }
                    if (cnt == 0) {
                        menu.add(new JMenuItem("No procedures"));
                    }
                }
            });
            menuItems.add(menu);
        }
        return menuItems;
    }

    private String makeCallString(PyFunction func, Hashtable props) {
        StringBuffer sb = new StringBuffer();
        sb.append(func.__name__ + "(");
        PyTableCode tc = (PyTableCode)func.__code__;
        for (int argIdx = 0; argIdx < tc.co_argcount; ++argIdx) {
            String attrs;
            if (argIdx > 0) {
                sb.append(", ");
            }
            String param = tc.co_varnames[argIdx];
            String string = attrs = props != null ? (String)props.get(param) : "";
            if (attrs == null) {
                attrs = "";
            }
            sb.append(param + attrs);
        }
        sb.append(")");
        return sb.toString();
    }

    public List findJythonMethods(boolean justList) {
        return this.findJythonMethods(justList, this.getLibHolders());
    }

    public List findJythonMethods(boolean justList, List holders) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (holders == null) {
            return result;
        }
        for (int i = 0; i < holders.size(); ++i) {
            ArrayList<PyFunction> subItems = new ArrayList<PyFunction>();
            LibHolder libHolder = (LibHolder)holders.get(i);
            List funcs = libHolder.getFunctions();
            for (int itemIdx = 0; itemIdx < funcs.size(); ++itemIdx) {
                Object[] pair = (Object[])funcs.get(itemIdx);
                PyFunction func = (PyFunction)pair[1];
                subItems.add(func);
            }
            if (justList) {
                result.addAll(subItems);
                continue;
            }
            result.add(new Object[]{libHolder.getName(), subItems});
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            Object[] pair;
            int itemIdx;
            PythonInterpreter interpreter = new PythonInterpreter();
            JythonManager.doBasicImports(interpreter);
            String mod = IOUtil.stripExtension(IOUtil.getFileTail(args[i]));
            interpreter.execfile(new FileInputStream(args[i]), mod);
            PyStringMap seq = (PyStringMap)interpreter.getLocals();
            PyList keys = seq.keys();
            PyList items = seq.items();
            StringBuffer sb = new StringBuffer();
            String modDoc = "";
            List<Object[]> funcs = new ArrayList();
            for (itemIdx = 0; itemIdx < items.__len__(); ++itemIdx) {
                pair = (Object[])items.__finditem__(itemIdx);
                if (!(pair.__finditem__(1) instanceof PyFunction)) {
                    if (!pair.__finditem__(0).toString().equals("__doc__")) continue;
                    modDoc = pair.__finditem__(1).toString();
                    continue;
                }
                funcs.add(new Object[]{pair.__finditem__(0).toString(), pair.__finditem__(1)});
            }
            funcs = Misc.sortTuples(funcs, true);
            for (itemIdx = 0; itemIdx < funcs.size(); ++itemIdx) {
                pair = (Object[])funcs.get(itemIdx);
                PyFunction func = (PyFunction)pair[1];
                sb.append("\n<meta name=\"jhid\" value=\"" + func.__name__ + "\">");
                sb.append("\n<p><a name=\"" + func.__name__ + "\"></a><code class=\"command\">" + func.__name__ + "(");
                PyTableCode tc = (PyTableCode)func.__code__;
                for (int argIdx = 0; argIdx < tc.co_argcount; ++argIdx) {
                    if (argIdx > 0) {
                        sb.append(", ");
                    }
                    sb.append(tc.co_varnames[argIdx]);
                }
                sb.append("):</code><p style=\"padding:0;margin-left:20;margin-top:0\">\n");
                if (!func.__doc__.toString().equals("None")) {
                    String doc = func.__doc__.toString().trim();
                    doc = StringUtil.replace(doc, "[", "\\[");
                    doc = StringUtil.replace(doc, "]", "\\]");
                    List<String> toks = StringUtil.split(doc, "\n", true, true);
                    sb.append(StringUtil.join("\n", toks));
                }
                sb.append("</p>");
            }
            System.out.println("<a name=\"" + mod + "\">");
            System.out.println("<h2> Module: " + mod + "</h2>");
            if (!modDoc.equals("None")) {
                System.out.println(modDoc);
            }
            System.out.println("<hr>");
            System.out.println(sb.toString());
        }
    }

    private static class MyPythonEditor
    extends JPythonEditor {
        public JTextComponent getLineNumberComponent() {
            return this.lineNumbers;
        }
    }

    public static class LibHolder
    extends TextSearcher.TextWrapper {
        JythonManager jythonManager;
        private boolean editable;
        List functions;
        String label;
        MyPythonEditor pythonEditor;
        String filePath;
        JComponent wrapper;
        JComponent outerContents;
        JButton saveBtn;
        Process editProcess;

        public LibHolder(boolean editable, JythonManager jythonManager, String label, MyPythonEditor editor, String filePath, JComponent wrapper) {
            this.pythonEditor = editor;
            this.setTextComponent(this.pythonEditor.getTextComponent());
            this.editable = editable;
            this.jythonManager = jythonManager;
            this.label = label;
            this.filePath = filePath;
            this.wrapper = wrapper;
            JButton bottom = null;
            if (editable) {
                bottom = this.saveBtn = GuiUtils.makeButton("Save", jythonManager, "writeJythonLib", this);
            }
            this.outerContents = GuiUtils.topCenterBottom(GuiUtils.inset((Component)new JLabel(label), 5), wrapper, GuiUtils.wrap(this.saveBtn));
            if (!editable) {
                this.pythonEditor.getTextComponent().setEditable(false);
                this.pythonEditor.getTextComponent().setBackground(COLOR_DISABLED);
                this.pythonEditor.getLineNumberComponent().setBackground(COLOR_DISABLED);
            }
        }

        public String getName() {
            return this.label;
        }

        public List getFunctions() {
            if (this.functions == null) {
                this.functions = new ArrayList();
                PythonInterpreter interpreter = new PythonInterpreter();
                interpreter.exec("import sys");
                interpreter.exec("import java");
                try {
                    interpreter.exec(this.getText());
                }
                catch (Exception exc) {
                    return this.functions;
                }
                PyStringMap seq = (PyStringMap)interpreter.getLocals();
                PyList items = seq.items();
                for (int itemIdx = 0; itemIdx < items.__len__(); ++itemIdx) {
                    PyTuple pair = (PyTuple)items.__finditem__(itemIdx);
                    if (!(pair.__finditem__(1) instanceof PyFunction)) continue;
                    this.functions.add(new Object[]{pair.__finditem__(0).toString(), pair.__finditem__(1)});
                }
                this.functions = Misc.sortTuples(this.functions, true);
            }
            return this.functions;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public String getText() {
            return this.pythonEditor.getText();
        }

        public void setText(String text) {
            this.setText(text, true);
        }

        public void setText(String text, boolean andEnable) {
            this.pythonEditor.setText(text);
            if (andEnable && this.saveBtn != null) {
                this.saveBtn.setEnabled(true);
                this.functions = null;
            }
        }

        public void copy() {
            this.pythonEditor.copy();
        }
    }
}

