/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import HTTPClient.CookieModule;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.w3c.dom.Node;
import ucar.unidata.data.CacheDataSource;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataContext;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceResults;
import ucar.unidata.data.DerivedDataDescriptor;
import ucar.unidata.data.DescriptorDataSource;
import ucar.unidata.data.gis.WmsDataSource;
import ucar.unidata.data.gis.WmsSelection;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.DataSourceHistory;
import ucar.unidata.idv.DefaultIdv;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.FileHistory;
import ucar.unidata.idv.History;
import ucar.unidata.idv.IdvBase;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvMonitor;
import ucar.unidata.idv.IdvPreferenceManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.ImageServer;
import ucar.unidata.idv.OldVersionCheck;
import ucar.unidata.idv.OneInstanceServer;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.collab.CollabManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.ui.DataSelector;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.idv.ui.QuicklinkPanel;
import ucar.unidata.ui.HelpActionLabel;
import ucar.unidata.ui.symbol.StationModelManager;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PropertyValue;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.VisADPersistence;
import visad.Data;
import visad.VisADException;
import visad.data.DataCacheManager;
import visad.java3d.UniverseBuilderJ3D;
import visad.util.Util;

public class IntegratedDataViewer
extends IdvBase
implements ControlContext,
ViewContext,
DataContext,
ActionListener,
HyperlinkListener,
LogUtil.DialogManager {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(IntegratedDataViewer.class.getName());
    private boolean haveInitialized = false;
    private boolean ignoreRemoveDisplayControl = false;
    private List historyList = null;
    private Object MUTEX_HISTORY = new Object();
    protected List displayControls = new ArrayList();
    protected List controlDescriptors = new ArrayList();
    protected Hashtable controlDescriptorMap = new Hashtable();
    private ImageServer imageServer;
    private OneInstanceServer oneInstanceServer;
    private IdvMonitor idvMonitor;
    private List backgroundImages;
    private static final String JAVA3D_VERSION = "1.2";
    private JCheckBox overwriteDataCbx;
    private boolean interactiveMode = true;
    private boolean tryingOneInstance = false;
    private boolean oneInstanceInterrupted = false;
    private static String NO_VERSION = "No version";

    public IntegratedDataViewer() throws VisADException, RemoteException {
        this(new String[0]);
    }

    public IntegratedDataViewer(String[] args) throws VisADException, RemoteException {
        this(args, true);
    }

    private void bailOut() {
        if (this.interactiveMode) {
            System.exit(1);
        }
    }

    public IntegratedDataViewer(boolean interactiveMode) throws VisADException, RemoteException {
        this(new String[0], interactiveMode);
    }

    public IntegratedDataViewer(String[] args, boolean interactiveMode) throws VisADException, RemoteException {
        super(args);
        this.interactiveMode = interactiveMode;
        LogUtil.setDialogManager(this);
        this.checkSystem();
        CookieModule.setCookiePolicyHandler(null);
        super.setIdv(this);
        if (!interactiveMode) {
            this.getArgsManager().setIsOffScreen(true);
        }
        this.getArgsManager().propertyFiles.add("/ucar/unidata/idv/resources/idv.properties");
        this.initPropertyFiles(this.getArgsManager().propertyFiles);
        try {
            this.getArgsManager().parseArgs();
        }
        catch (Throwable exc) {
            this.logException("Processing arguments", exc);
            this.bailOut();
            return;
        }
        if (this.argsManager.oneInstancePort > 0 && !this.argsManager.noOneInstance) {
            this.checkOneInstance(this.argsManager.oneInstancePort);
        }
        try {
            Trace.call1("initState");
            this.getStateManager().initState(interactiveMode);
            Trace.call2("initState");
        }
        catch (Throwable exc) {
            this.logException("Fatal error initializing resources", exc);
            this.bailOut();
            return;
        }
        if (this.argsManager.oneInstancePort <= 0 && !this.argsManager.noOneInstance && this.getProperty("idv.oneinstanceport", -1) > 0) {
            this.checkOneInstance(this.getProperty("idv.oneinstanceport", -1));
        }
        FileManager.setStore(this.getStore(), "Idv.FileWriteDirectory", "Idv.FileReadDirectory");
        FileManager.setFixFileLockup(this.getProperty("idv.fixfilelockup", false));
        long minFrameCycleTime = this.getProperty("idv.minimumframecycletime", 0);
        if (minFrameCycleTime != 0L) {
            System.err.println("Setting minFrameCycleTime to:" + minFrameCycleTime);
            UniverseBuilderJ3D.setMinimumFrameCycleTime(minFrameCycleTime);
        }
        this.getJythonManager();
        this.getDataManager();
        this.getPublishManager().initPublisher();
    }

    public boolean getServerMode() {
        return !this.interactiveMode;
    }

    public boolean getInteractiveMode() {
        return this.interactiveMode && !this.getArgsManager().isScriptingMode();
    }

    protected void checkSystem() {
        if (!Util.canDoJava3D(JAVA3D_VERSION)) {
            if (this.interactiveMode) {
                LogUtil.userMessage("<html>This application needs Java 3D 1.2 or higher to run.<br>Please see the User's Guide for more information.</html>");
                this.bailOut();
            } else {
                throw new IllegalArgumentException("This application needs Java 3D 1.2 or higher to run.<br>Please see the User's Guide for more information.");
            }
        }
    }

    private synchronized void checkOneInstance(final int port) {
        this.tryingOneInstance = true;
        Misc.run(new Runnable(){

            @Override
            public void run() {
                IntegratedDataViewer.this.checkOneInstanceInner(port);
                boolean tmp = IntegratedDataViewer.this.tryingOneInstance;
                IntegratedDataViewer.this.tryingOneInstance = false;
                try {
                    if (tmp) {
                        IntegratedDataViewer.this.notify();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        try {
            if (this.tryingOneInstance) {
                this.wait(10000L);
                if (this.tryingOneInstance) {
                    this.tryingOneInstance = false;
                    LogUtil.userErrorMessage("The IDV was unable to connect to the one instance port: " + port);
                }
                this.tryingOneInstance = false;
            }
        }
        catch (Exception exc) {
            System.err.println("err:" + exc);
            exc.printStackTrace();
        }
    }

    public void waitUntilDisplaysAreDone() {
        IdvManager.waitUntilDisplaysAreDone(this.getIdvUIManager());
    }

    private synchronized void checkOneInstanceInner(final int port) {
        try {
            String url = OneInstanceServer.assembleUrl(port, this.argsManager.originalArgs);
            String result = IOUtil.readContents(url, (String)null);
            if (!this.tryingOneInstance) {
                return;
            }
            this.tryingOneInstance = false;
            if (result != null && result.trim().equals("ok")) {
                System.exit(0);
            }
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    IntegratedDataViewer.this.startOneInstanceServer(port);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startOneInstanceServer(int port) {
        try {
            this.oneInstanceServer = new OneInstanceServer(this, port);
            this.oneInstanceServer.init();
        }
        catch (Exception exc) {
            this.logException("Trying to create a one-instance server on port:" + port, exc);
        }
    }

    protected final void init() {
        GuiUtils.setApplicationTitle("Unidata IDV - ");
        Misc.run(new Runnable(){

            @Override
            public void run() {
                try {
                    IntegratedDataViewer.this.initInner();
                }
                catch (Throwable exc) {
                    IntegratedDataViewer.this.logException("Initializing the IDV", exc);
                }
            }
        });
    }

    protected void loadDataFiles(List files) {
        String period = ".";
        DataSourceResults results = new DataSourceResults();
        for (int i = 0; i < files.size(); ++i) {
            if (i == 0) {
                this.getIdvUIManager().splashMsg("Loading initial data" + period);
            }
            results.merge(this.getDataManager().createDataSource(files.get(i).toString()));
            period = period + ".";
            this.getIdvUIManager().splashMsg("Loading Initial Data" + period);
        }
        this.getIdvUIManager().showResults(results);
    }

    protected void initInner() throws VisADException, RemoteException {
        int i;
        this.getIdvUIManager().doBasicInitialization();
        if (this.argsManager.traceMode) {
            this.getTestManager().startTrace();
        }
        if (this.argsManager.jythonCode != null) {
            try {
                LogUtil.setTestMode(true);
                this.getJythonManager().evaluateTrusted(this.argsManager.jythonCode);
                LogUtil.setTestMode(false);
            }
            catch (Throwable exc) {
                Misc.fatal(exc);
            }
        }
        if (this.argsManager.testMode) {
            this.haveInitialized = true;
            this.getTestManager().doTest();
            return;
        }
        List fileMappingIds = this.getArgsManager().fileMappingIds;
        List fileMappingFiles = this.getArgsManager().fileMappingFiles;
        for (i = 0; i < fileMappingIds.size(); ++i) {
            this.getPersistenceManager().addFileMapping(fileMappingIds.get(i).toString(), (List)fileMappingFiles.get(i));
        }
        this.getIdvUIManager().init();
        this.loadDataFiles(this.argsManager.initDataFiles);
        this.getArgsManager().processInitialBundles();
        this.initCacheManager();
        this.haveInitialized = true;
        this.getIdvUIManager().initDone();
        this.getArgsManager().initDone();
        this.startMonitor();
        if (!this.getStateManager().getRunningIsl()) {
            try {
                OldVersionCheck.check(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < this.argsManager.displayTemplates.size(); i += 3) {
            String datasourcePath = (String)this.argsManager.displayTemplates.get(i);
            String param = (String)this.argsManager.displayTemplates.get(i + 1);
            String bundle = (String)this.argsManager.displayTemplates.get(i + 2);
            DataSource dataSource = this.makeOneDataSource(datasourcePath, null, null);
            if (dataSource == null) continue;
            DataChoice choice = dataSource.findDataChoice(param);
            if (choice == null) {
                LogUtil.userMessage("No parameter found: " + param + " in data source:" + datasourcePath);
                continue;
            }
            DisplayControl control = this.getPersistenceManager().instantiateFromTemplate(bundle);
            if (control == null) {
                LogUtil.userMessage("Unable to create display from template:" + bundle);
                continue;
            }
            control.init("display", new ArrayList(), Misc.newList(choice), (ControlContext)this, new Hashtable(), null);
        }
        if (!this.getArgsManager().isScriptingMode()) {
            this.getIdvChooserManager();
        }
        if (this.argsManager.imageServerPort > 0 || this.argsManager.imageServerPropertyFile != null) {
            this.runImageServer(this.argsManager.imageServerPort, this.argsManager.imageServerPropertyFile);
        }
        if (!this.getArgsManager().isScriptingMode()) {
            HelpActionLabel.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    IntegratedDataViewer.this.handleAction(ae.getActionCommand(), null);
                }
            });
        }
        this.initDone();
    }

    public void initDone() {
        this.argsManager.initParams = new ArrayList();
        this.argsManager.initDisplays = new ArrayList();
        if (!this.getArgsManager().getIsOffScreen()) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    try {
                        IntegratedDataViewer.this.getInstallManager().automaticallyCheckForUpdates();
                        IOUtil.readContents("https://www.unidata.ucar.edu/software/idv/resources/bundles.xml", this.getClass());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected void startMonitor() {
        if (this.idvMonitor != null) {
            return;
        }
        final String monitorPort = this.getProperty("idv.monitorport", "");
        if (monitorPort != null && monitorPort.trim().length() > 0 && !monitorPort.trim().equals("none")) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    try {
                        IntegratedDataViewer.this.idvMonitor = new IdvMonitor(IntegratedDataViewer.this, new Integer(monitorPort));
                        IntegratedDataViewer.this.idvMonitor.init();
                    }
                    catch (Exception exc) {
                        LogUtil.consoleMessage("Unable to start IDV monitor on port:" + monitorPort);
                        LogUtil.consoleMessage("Error:" + exc);
                    }
                }
            });
        }
    }

    public void initCacheManager() {
        CacheManager.setTmpDir(new File(this.getStore().getUserTmpDirectory()));
        CacheManager.setDoCache(this.getStore().get("idv.docache", true));
        double size = this.getStore().get("idv.cachesize", 20.0);
        CacheManager.setMaxFileCacheSize((int)(size * 1000000.0));
        CacheManager.addCacheListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IntegratedDataViewer.this.clearCachedData();
            }
        });
    }

    protected void clearCachedData() {
        List dataSources = this.getDataSources();
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource dataSource = (DataSource)dataSources.get(i);
            dataSource.clearCachedData();
        }
    }

    public boolean getHaveInitialized() {
        return this.haveInitialized;
    }

    public boolean okToShowWindows() {
        return !this.getArgsManager().getIsOffScreen();
    }

    public void initPropertyFiles(List files) {
    }

    private void checkVersion() {
        String currentVersion;
        String lastVersion = this.getStore().get("LastVersion", NO_VERSION);
        if (lastVersion.equals(currentVersion = this.getStateManager().getVersion())) {
            return;
        }
        this.getStore().put("LastVersion", (Object)currentVersion);
        this.getStore().saveIfNeeded();
        if (GuiUtils.showYesNoDialog(null, "<html><center>You are now running IDV version " + currentVersion + "<p>Would you like to see the Release Notes?</center></html>", "Show Release Notes?")) {
            this.getIdvUIManager().showHelp("idv.releasenotes");
        }
    }

    public void registerHelpKey(JComponent comp, final String helpId) {
        System.err.println("register");
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                System.err.println("key pressed");
                if (e.getKeyCode() == 112) {
                    IntegratedDataViewer.this.getIdvUIManager().showHelp(helpId);
                }
            }
        });
    }

    public JComponent makeHelpButton(String helpId) {
        return this.makeHelpButton(helpId, "Show Help");
    }

    public JComponent makeHelpButton(String helpId, String toolTip) {
        JButton btn = GuiUtils.makeImageButton("/auxdata/ui/icons/Help16.gif", this.getIdvUIManager(), "showHelp", helpId);
        if (toolTip != null) {
            btn.setToolTipText(toolTip);
        }
        return btn;
    }

    public void loadRbiFile(String filename) {
    }

    @Override
    public List getLocationList() {
        return this.getResourceManager().getLocationList();
    }

    protected List getProjections() {
        return this.getIdvProjectionManager().getProjections();
    }

    protected void addControlDescriptor(ControlDescriptor cd) {
        if (this.controlDescriptorMap.get(cd.getControlId()) == null) {
            this.controlDescriptors.add(cd);
            this.controlDescriptorMap.put(cd.getControlId(), cd);
        }
    }

    protected void initPreferences(IdvPreferenceManager preferenceManager) {
        preferenceManager.initPreferences();
    }

    public DataSelector createDataSelector() {
        return this.getIdvUIManager().createDataSelector();
    }

    public DataChoice selectDataChoice(ControlDescriptor descriptor) {
        return this.getIdvUIManager().selectDataChoice(descriptor);
    }

    @Override
    public List selectDataChoices(List fullParamNames) {
        if (LogUtil.getTestMode()) {
            return null;
        }
        if (fullParamNames.size() == 0) {
            return new ArrayList();
        }
        return this.getIdvUIManager().selectDataChoices(fullParamNames);
    }

    @Override
    public List selectUserChoices(String msg, List userChoices) {
        if (LogUtil.getTestMode()) {
            return null;
        }
        return this.getIdvUIManager().selectUserChoices(msg, userChoices);
    }

    @Override
    public void dataSourceChanged(DataSource source) {
        this.getIdvUIManager().dataSourceChanged(source);
    }

    public void evaluateAndSave(DataChoice dataChoice) {
        DataChoice clonedDataChoice = dataChoice.createClone();
        this.showWaitCursor();
        try {
            Data d = clonedDataChoice.getData(new DataSelection());
            if (d == null) {
                return;
            }
            this.saveInCacheInner(clonedDataChoice, d, null, clonedDataChoice.getName());
        }
        catch (DataCancelException d) {
        }
        catch (Exception exc) {
            this.logException("Evaluating data choice", exc);
        }
        this.showNormalCursor();
    }

    public void saveInCache(DataChoice dataChoice, Data data) {
        this.saveInCache(dataChoice, data, null, dataChoice.getName());
    }

    public void saveInCache(DataChoice dataChoice, Data data, DataSelection dataSelection) {
        this.saveInCache(dataChoice, data, dataSelection, dataChoice.getName());
    }

    public void saveInCache(DataChoice dataChoice, Data data, String name) {
        this.saveInCache(dataChoice, data, null, name);
    }

    public void saveInCache(DataChoice dataChoice, Data data, DataSelection dataSelection, String name) {
        DataChoice clonedDataChoice = dataChoice.createClone();
        this.saveInCacheInner(clonedDataChoice, data, dataSelection, name);
    }

    private void saveInCacheInner(DataChoice clonedDataChoice, Data data, DataSelection dataSelection, String name) {
        try {
            name = GuiUtils.getInput("Please enter a name for this data:", "Name: ", name, null, null, "Save In Cache");
            if (name == null) {
                return;
            }
            CacheDataSource cds = null;
            List dataSources = this.getDataSources();
            for (int i = 0; i < dataSources.size(); ++i) {
                DataSource dataSource = (DataSource)dataSources.get(i);
                if (!(dataSource instanceof CacheDataSource)) continue;
                cds = (CacheDataSource)dataSource;
                break;
            }
            if (cds == null) {
                cds = (CacheDataSource)this.makeOneDataSource("", "CACHED", new Hashtable());
            }
            cds.addDataChoice(clonedDataChoice, name, data, dataSelection);
        }
        catch (Exception exc) {
            this.logException("Evaluating data choice", exc);
        }
        this.showNormalCursor();
    }

    public List getDerivedDataChoices(DataSource dataSource, List dataChoices) {
        List derivedList = DerivedDataDescriptor.getDerivedDataChoices(this, dataChoices, this.getJythonManager().getDescriptors());
        return derivedList;
    }

    @Override
    public JMenu doMakeDataChoiceMenu(DataChoice dataChoice) {
        return this.getIdvUIManager().doMakeDataChoiceMenu(dataChoice);
    }

    public String getViewManagerProperties() {
        return this.getProperty("idv.viewmanager.properties", "");
    }

    public void createNewWindow() {
        this.getIdvUIManager().createNewWindow();
    }

    public ViewManager getViewManager() {
        return this.getViewManager(ViewDescriptor.LASTACTIVE, true, null);
    }

    @Override
    public ViewManager getViewManager(ViewDescriptor viewDescriptor) {
        return this.getViewManager(viewDescriptor, true, null);
    }

    @Override
    public ViewManager getViewManager(ViewDescriptor viewDescriptor, boolean newWindow, String properties) {
        ViewManager viewManager = this.getVMManager().findViewManager(viewDescriptor);
        if (viewManager != null) {
            return viewManager;
        }
        if (this.getArgsManager().getIsOffScreen() || !this.getIdv().okToShowWindows() && !newWindow) {
            ViewManager vm = this.getVMManager().createViewManager(viewDescriptor, properties);
            return vm;
        }
        IdvWindow window = this.getIdvUIManager().createNewWindow();
        if (window != null) {
            List viewManagers = window.getViewManagers();
            for (int i = 0; i < viewManagers.size(); ++i) {
                ViewManager tmpViewManager = (ViewManager)viewManagers.get(i);
                if (viewManager != null || !tmpViewManager.isDefinedBy(viewDescriptor)) continue;
                viewManager = tmpViewManager;
            }
            if (viewManager == null && viewManagers.size() > 0) {
                viewManager = (ViewManager)viewManagers.get(0);
            }
            if (viewManager != null) {
                viewManager.addViewDescriptor(viewDescriptor);
            }
        }
        return viewManager;
    }

    public List getAllControlDescriptors() {
        return this.controlDescriptors;
    }

    public List getControlDescriptors() {
        return this.getControlDescriptors(false);
    }

    public List getControlDescriptors(boolean includeTemplates) {
        ArrayList<ControlDescriptor> l = new ArrayList<ControlDescriptor>();
        for (int i = 0; i < this.controlDescriptors.size(); ++i) {
            ControlDescriptor controlDescriptor = (ControlDescriptor)this.controlDescriptors.get(i);
            if (!this.getPreferenceManager().shouldShowControl(controlDescriptor)) continue;
            l.add(controlDescriptor);
        }
        if (includeTemplates) {
            this.getPersistenceManager().getControlDescriptors(l);
        }
        return l;
    }

    public ControlDescriptor getControlDescriptor(String name) {
        return (ControlDescriptor)this.controlDescriptorMap.get(name);
    }

    public List getDisplayControls() {
        return new ArrayList(this.displayControls);
    }

    public boolean getAllDisplaysIntialized() {
        for (DisplayControl control : this.getDisplayControls()) {
            if (control.isInitDone()) continue;
            return false;
        }
        return true;
    }

    public void toFront(DisplayControl control) {
        this.displayControls.remove(control);
        this.displayControls.add(control);
    }

    public void controlHasBeenInitialized(DisplayControl control) {
        if (this.collabManager != null) {
            this.collabManager.controlHasBeenInitialized(control);
        }
    }

    @Override
    public void addDisplayControl(DisplayControl control) {
        this.displayControls.add(control);
        this.getIdvUIManager().addDisplayControl(control);
    }

    @Override
    public void removeDisplayControl(DisplayControl control) {
        if (!this.ignoreRemoveDisplayControl) {
            this.displayControls.remove(control);
            this.getIdvUIManager().removeDisplayControl(control);
        }
        if (this.collabManager != null) {
            this.collabManager.writeRemoveDisplayControl(control);
        }
    }

    public void removeAllDisplays() {
        this.removeAllDisplays(true);
    }

    public void removeAllDisplays(boolean payAttentionToCanDoRemoveAll) {
        try {
            this.getVMManager().setDisplayMastersInactive();
            List tmp = this.getDisplayControls();
            this.displayControls = new ArrayList();
            this.ignoreRemoveDisplayControl = true;
            for (int i = 0; i < tmp.size(); ++i) {
                DisplayControl dc = (DisplayControl)tmp.get(i);
                if (!payAttentionToCanDoRemoveAll || dc.getCanDoRemoveAll()) {
                    dc.doRemove();
                    this.getIdvUIManager().removeDisplayControl(dc);
                    continue;
                }
                this.displayControls.add(dc);
            }
            this.getVMManager().setDisplayMastersActive();
            this.ignoreRemoveDisplayControl = false;
            this.getIdvUIManager().displayControlsChanged();
            Runtime.getRuntime().gc();
        }
        catch (Throwable exc) {
            this.logException("removeAllDisplays", exc);
            exc.printStackTrace();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        this.hyperlinkUpdate(e, null);
    }

    public void hyperlinkUpdate(HyperlinkEvent e, Hashtable properties) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String url = e.getURL() == null ? e.getDescription() : e.getURL().toString();
        this.handleAction(url, properties);
    }

    protected boolean handleFileOrUrlAction(String action, Hashtable properties) {
        boolean ok = false;
        boolean isFile = false;
        if (action.startsWith("idv:")) {
            action = StringUtil.replace(action, "&", "&amp;");
            action = action.substring("idv:".length());
            this.getJythonManager().evaluateUntrusted(action, properties);
            return true;
        }
        if (action.startsWith("jython:")) {
            this.getJythonManager().evaluateTrusted(action.substring(7), properties);
            ok = true;
        } else if (action.startsWith("help:")) {
            this.getIdvUIManager().showHelp(action.substring(5));
            ok = true;
        } else if (this.getArgsManager().isRbiFile(action)) {
            this.loadRbiFile(action);
            ok = true;
            isFile = true;
        } else {
            if (this.getArgsManager().isXidvFile(action) || this.getArgsManager().isZidvFile(action)) {
                this.getPersistenceManager().decodeXmlFile(action, true);
                return true;
            }
            if (this.getArgsManager().isIslFile(action)) {
                final String scriptFile = action;
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        IntegratedDataViewer.this.getImageGenerator().processScriptFile(scriptFile);
                    }
                });
                ok = true;
                isFile = true;
            } else if (this.getArgsManager().isJnlpFile(action)) {
                this.getPersistenceManager().decodeJnlpFile(action);
                ok = true;
                isFile = true;
            }
        }
        if (isFile) {
            this.addToHistoryList(action);
        }
        if (ok) {
            // empty if block
        }
        return ok;
    }

    public boolean handleAction(String action) {
        return this.handleAction(action, null);
    }

    @Override
    public boolean handleAction(String action, Hashtable properties) {
        return this.handleAction(action, properties, true);
    }

    public boolean handleAction(String action, Hashtable properties, boolean checkForAlias) {
        History history;
        String execPath;
        if (this.getIdvUIManager().isAction(action)) {
            String newAction = this.getIdvUIManager().getAction(action);
            if (newAction == null) {
                LogUtil.userMessage("Unknown action:" + action);
                return true;
            }
            action = newAction;
        }
        try {
            if (this.handleFileOrUrlAction(action, properties)) {
                return true;
            }
        }
        catch (IllegalStateException ise) {
            return false;
        }
        if (IOUtil.isHtmlFile(action) && (execPath = this.getProperty("idv.browser.path", null)) != null && execPath.trim().length() > 0) {
            try {
                Process process = Runtime.getRuntime().exec(execPath + " " + action);
                process.waitFor();
            }
            catch (Exception exc) {
                this.logException("Executing the browser:" + execPath, exc);
            }
            return true;
        }
        if (checkForAlias && (history = History.findWithAlias(action.trim(), this.getHistory(), null)) != null) {
            return history.process(this);
        }
        if (this.dataManager.validDatasourceId(action, properties)) {
            return this.makeDataSource(action, null, properties, true);
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.handleAction(event.getActionCommand(), null);
    }

    public void removeDataSource(DataSource dataSource) {
        try {
            this.dataManager.removeDataSource(dataSource);
            if (this.collabManager != null) {
                this.collabManager.writeRemoveDataSource(dataSource);
            }
            this.getIdvUIManager().removeDataSource(dataSource);
        }
        catch (Exception exc) {
            this.logException("Removing data source:" + dataSource, exc);
        }
    }

    public void removeAllDataSources() {
        this.dataManager.removeAllDataSources();
        this.getIdvUIManager().removeAllDataSources();
    }

    public void reloadAllDataSources() {
        Misc.run(this.dataManager, "reloadAllDataSources");
    }

    @Override
    public List getDataSources() {
        return this.getDataManager().getDataSources();
    }

    @Override
    public List getAllDataSources() {
        ArrayList<DescriptorDataSource> dataSources = new ArrayList<DescriptorDataSource>(this.getDataSources());
        if (this.getJythonManager().getDescriptorDataSource() != null) {
            dataSources.add(0, this.getIdv().getJythonManager().getDescriptorDataSource());
        }
        return dataSources;
    }

    public DataSource makeOneDataSource(Object definingObject, String dataType, Hashtable properties) {
        DataSourceResults results = this.createDataSource(definingObject, dataType, properties, true);
        this.getIdvUIManager().showResults(results);
        if (results.anyOk()) {
            return (DataSource)results.getDataSources().get(0);
        }
        return null;
    }

    public boolean makeDataSource(Object definingObject, String dataType, Hashtable properties) {
        return this.makeDataSource(definingObject, dataType, properties, true);
    }

    public void makeDataSource(DataSourceDescriptor descriptor) {
        this.makeDataSource("", descriptor.getId(), new Hashtable());
    }

    public boolean makeDataSource(Object definingObject, String dataType, Hashtable properties, boolean checkAlias) {
        return this.makeDataSource(definingObject, dataType, properties, checkAlias, null);
    }

    private boolean isABundle(Object obj) {
        return obj instanceof String && (this.getArgsManager().isXidvFile((String)obj) || this.getArgsManager().isZidvFile((String)obj));
    }

    public boolean makeDataSource(Object definingObject, String dataType, Hashtable properties, boolean checkAlias, String displayType) {
        List listOfBundles = new ArrayList();
        if (this.isABundle(definingObject)) {
            listOfBundles = Misc.newList(definingObject);
            definingObject = null;
        } else if (definingObject instanceof List) {
            List tmp = definingObject;
            definingObject = new ArrayList();
            for (int i = 0; i < tmp.size(); ++i) {
                Object obj = tmp.get(i);
                if (this.isABundle(obj)) {
                    listOfBundles.add(obj);
                    continue;
                }
                ((List)definingObject).add(obj);
            }
            if (((List)definingObject).size() == 0) {
                definingObject = null;
            }
        }
        for (int i = 0; i < listOfBundles.size(); ++i) {
            this.doOpen((String)listOfBundles.get(i));
        }
        if (definingObject == null) {
            return true;
        }
        DataSourceResults results = this.createDataSource(definingObject, dataType, properties, checkAlias);
        this.getIdvUIManager().showResults(results);
        if (results.allOk() && !results.anyOk()) {
            return false;
        }
        if (!results.allOk()) {
            return false;
        }
        if (displayType != null) {
            DisplayControl dc = this.createDisplay(results, "", displayType, "", true);
            return dc != null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveHistoryToFront(History history) {
        Object object = this.MUTEX_HISTORY;
        synchronized (object) {
            this.historyList.remove(history);
            this.historyList.add(0, history);
            this.writeHistoryList();
        }
    }

    public DataSourceResults makeDataSourceFromXml(String dataSourceXml) {
        return this.getPersistenceManager().makeDataSourceFromXml(dataSourceXml);
    }

    public DataSourceResults createDataSource(Object definingObject, String dataType, Hashtable properties, boolean checkAlias) {
        DataSourceHistory history;
        this.showWaitCursor();
        DataSourceResults results = null;
        boolean createDataSourceFromAlias = false;
        if (checkAlias && definingObject instanceof String && (history = (DataSourceHistory)History.findWithAlias(definingObject.toString().trim(), this.getHistory(), DataSourceHistory.class)) != null) {
            results = this.makeDataSourceFromXml(history.getDataSourceXml());
        }
        if (results == null) {
            results = this.dataManager.createDataSource(definingObject, dataType, properties);
        } else {
            createDataSourceFromAlias = true;
        }
        List dataSources = results.getDataSources();
        List data = results.getSuccessData();
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource dataSource = (DataSource)dataSources.get(i);
            Object dataSourceData = data.get(i);
            String dataSourceXml = this.encodeObject(dataSource, true);
            if (this.collabManager != null) {
                this.collabManager.write(CollabManager.MSG_DATASOURCE, dataSourceXml);
            }
            if (createDataSourceFromAlias) continue;
            String identifier = dataSource.getClass().getName() + "_" + this.encodeObject(dataSourceData, false);
            identifier = new String(XmlUtil.encodeBase64(identifier.getBytes()));
            this.addToHistoryList(new DataSourceHistory(dataSource.toString(), dataSourceXml, identifier));
        }
        this.showNormalCursor();
        return results;
    }

    @Override
    public String selectDataType(Object definingObject) {
        return this.selectDataType(definingObject, "<html>Unable to figure out how to read the data:<br>&nbsp;<p>&nbsp;&nbsp;&nbsp;<i>" + definingObject + "</i>" + "<br>&nbsp;<p>Please specify a data source type<br>&nbsp;</html>");
    }

    @Override
    public String selectDataType(Object definingObject, String message) {
        JComboBox dataSourcesCbx = IdvChooser.getDataSourcesComponent(false, this.getDataManager(), false);
        JLabel label = new JLabel(message);
        JPanel contents = GuiUtils.vbox((Component)GuiUtils.inset((Component)label, 5), GuiUtils.inset((Component)GuiUtils.left(GuiUtils.label("Data Source Type:  ", dataSourcesCbx)), 5));
        if (!GuiUtils.showOkCancelDialog(null, "Select data source type", contents = GuiUtils.inset((Component)contents, 5), null, null)) {
            return null;
        }
        Object selected = dataSourcesCbx.getSelectedItem();
        if (selected != null && selected instanceof TwoFacedObject) {
            return (String)((TwoFacedObject)selected).getId();
        }
        return (String)selected;
    }

    @Override
    public boolean loadDataSource(DataSource dataSource) {
        boolean keepDataSource = true;
        try {
            if (dataSource == null) {
                return false;
            }
            String dataType = dataSource.getTypeName();
            LogUtil.message("Loading  data:" + dataSource.getName());
            if (!this.getProperty("idv.loadingxml", false)) {
                if (this.getStore().get("idv.autodisplays.enable", true)) {
                    Object notifyWindow = null;
                    List pairs = this.getAutoDisplayEditor().getDisplaysForDataSource(dataSource);
                    for (int i = 0; i < pairs.size(); i += 2) {
                        DataChoice dc = (DataChoice)pairs.get(i);
                        ControlDescriptor cd = (ControlDescriptor)pairs.get(i + 1);
                        this.doMakeControl(dc, cd, NULL_STRING);
                    }
                    if (notifyWindow != null) {
                        // empty if block
                    }
                }
                for (int pIdx = 0; pIdx < this.argsManager.initParams.size(); ++pIdx) {
                    DataChoice choice = dataSource.findDataChoice(this.argsManager.initParams.get(pIdx));
                    if (choice == null) continue;
                    ControlDescriptor cd = this.getControlDescriptor(this.argsManager.initDisplays.get(pIdx).toString());
                    if (cd != null) {
                        this.doMakeControl(choice, cd, NULL_STRING);
                        continue;
                    }
                    log_.error("Unknown display specifier:" + this.argsManager.initDisplays.get(pIdx));
                }
                if (dataType != null) {
                    this.createDefaultDisplays(dataType, dataSource);
                }
            }
            if (dataType == null || this.getDataManager().getProperty(dataType, "show_in_tree", true)) {
                this.getIdvUIManager().addDataSource(dataSource);
            } else {
                keepDataSource = false;
            }
        }
        catch (Throwable exp) {
            this.logException("loadDataSource", exp);
        }
        LogUtil.clearMessage("Loading  data:" + dataSource.getName());
        return keepDataSource;
    }

    public int getMaxRenderThreadCount() {
        return this.getStore().get("idv.threads.render.max", Runtime.getRuntime().availableProcessors());
    }

    public int getMaxDataThreadCount() {
        return this.getStore().get("idv.threads.render.data", 4);
    }

    public boolean getUseTimeDriver() {
        return this.getProperty("idv.usetimedriver", false);
    }

    private void createDefaultDisplays(String dataType, DataSource dataSource) {
        String defaultDisplay = (String)dataSource.getProperty("idv.data.autocreatedisplay");
        if (defaultDisplay == null) {
            defaultDisplay = this.dataManager.getProperty(dataType, "default_display");
        }
        if (defaultDisplay != null) {
            dataSource.createAutoDisplay(defaultDisplay, this);
        }
    }

    public void createImage(String imageName, String dataSourceName, String paramName, String displayName) {
        DisplayControl displayControl = this.createDisplay(dataSourceName, paramName, displayName, null);
        if (displayControl == null) {
            LogUtil.userMessage("Unknown display type: " + displayName);
            return;
        }
        displayControl.saveImage(imageName);
    }

    public DisplayControl createDisplay(String dataSourceName, String paramName, String displayName, String properties) {
        return this.createDisplay(dataSourceName, paramName, displayName, properties, true);
    }

    @Override
    public DisplayControl createDisplay(String dataSourceName, String paramName, String displayName, String properties, boolean initDisplayInThread) {
        try {
            DataSourceResults results = this.dataManager.createDataSource(dataSourceName);
            if (results.anyFailed()) {
                this.getIdvUIManager().showResults(results);
                return null;
            }
            return this.createDisplay(results, paramName, displayName, properties, initDisplayInThread);
        }
        catch (Throwable excp) {
            throw new IllegalArgumentException("Error creating display:" + excp);
        }
    }

    private DisplayControl createDisplay(DataSourceResults results, String paramName, String displayName, String properties, boolean initDisplayInThread) {
        try {
            List dataSources = results.getDataSources();
            if (dataSources.size() == 0) {
                throw new IllegalArgumentException("Unable to load data source:");
            }
            DataSource dataSource = (DataSource)dataSources.get(0);
            DataChoice dataChoice = dataSource.findDataChoice(paramName);
            if (dataChoice == null) {
                throw new IllegalArgumentException("Unable to find parameter:" + paramName);
            }
            ControlDescriptor desc = this.getControlDescriptor(displayName);
            if (desc == null) {
                throw new IllegalArgumentException("Unknown display:" + displayName);
            }
            return this.doMakeControl(Misc.newList(dataChoice), desc, properties, NULL_DATA_SELECTION, initDisplayInThread);
        }
        catch (Throwable excp) {
            throw new IllegalArgumentException("Error creating display:" + excp);
        }
    }

    @Override
    public void showWindow(DisplayControl control, IdvWindow window) {
        this.getIdvUIManager().showWindow(control, window);
    }

    public List getBackgroundImages() {
        if (this.backgroundImages == null) {
            this.backgroundImages = WmsSelection.parseWmsResources(this.getResourceManager().getXmlResources(IdvResourceManager.RSC_BACKGROUNDWMS));
        }
        return this.backgroundImages;
    }

    public void doMakeBackgroundImage() {
        DataSource dataSource = null;
        List dataSources = this.getAllDataSources();
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource tmp = (DataSource)dataSources.get(i);
            if (!(tmp instanceof WmsDataSource)) continue;
            WmsDataSource wmsDataSource = (WmsDataSource)tmp;
            if (!Misc.equals(this.getBackgroundImages(), wmsDataSource.getWmsSelections())) continue;
            dataSource = tmp;
            break;
        }
        if (dataSource == null) {
            Hashtable properties = Misc.newHashtable("TITLE", "Background images");
            dataSource = this.makeOneDataSource(this.getBackgroundImages(), "WMS", properties);
        } else {
            this.createDefaultDisplays("WMS", dataSource);
        }
    }

    public DisplayControl doMakeControl(DataChoice dataChoice, ControlDescriptor descriptor, String properties) {
        if (dataChoice == null) {
            return null;
        }
        return this.doMakeControl(Misc.newList(dataChoice), descriptor, properties, null, true);
    }

    public DisplayControl doMakeControl(String controlName) {
        ControlDescriptor cd = this.getControlDescriptor(controlName);
        if (cd != null) {
            return this.doMakeControl(new ArrayList(), cd);
        }
        return null;
    }

    public DisplayControl doMakeControl(String controlName, DataChoice dataChoice) {
        return this.doMakeControl(controlName, Misc.newList(dataChoice));
    }

    public DisplayControl doMakeControl(String controlName, List dataChoices) {
        ControlDescriptor cd = this.getControlDescriptor(controlName);
        if (cd != null) {
            return this.doMakeControl(dataChoices, cd);
        }
        return null;
    }

    public DisplayControl doMakeControl(List dataChoices, ControlDescriptor descriptor) {
        return this.doMakeControl(dataChoices, descriptor, (String)null, null);
    }

    public DisplayControl doMakeControl(DataChoice dataChoice, ControlDescriptor descriptor, String properties, DataSelection dataSelection) {
        if (dataChoice == null || descriptor == null) {
            return null;
        }
        return this.doMakeControl(Misc.newList(dataChoice), descriptor, properties, dataSelection, true);
    }

    public DisplayControl doMakeControl(List dataChoices, ControlDescriptor descriptor, String propertiesString, DataSelection dataSelection) {
        Hashtable properties = propertiesString == null ? null : StringUtil.parsePropertiesString(propertiesString);
        return this.doMakeControl(dataChoices, descriptor, properties, dataSelection);
    }

    public DisplayControl doMakeControl(List dataChoices, ControlDescriptor descriptor, Hashtable properties, DataSelection dataSelection) {
        return this.doMakeControl(dataChoices, descriptor, properties, dataSelection, true);
    }

    public DisplayControl doMakeControl(List dataChoices, ControlDescriptor descriptor, String propertiesString, DataSelection dataSelection, boolean initDisplayInThread) {
        Hashtable properties = propertiesString == null ? null : StringUtil.parsePropertiesString(propertiesString);
        return this.doMakeControl(dataChoices, descriptor, properties, dataSelection, initDisplayInThread);
    }

    public DisplayControl doMakeControl(List dataChoices, ControlDescriptor descriptor, Hashtable properties, DataSelection dataSelection, boolean initDisplayInThread) {
        if (dataChoices == null || descriptor == null) {
            return null;
        }
        LogUtil.message("Creating control: " + descriptor);
        DisplayControl control = null;
        try {
            control = descriptor.doMakeDisplay(dataChoices, this, properties, dataSelection, initDisplayInThread);
        }
        catch (Throwable exp) {
            this.logException("doMakeControl", exp);
        }
        LogUtil.clearMessage("Creating control: " + descriptor);
        return control;
    }

    public String encodeObject(Object object, boolean prettyPrint) {
        return this.encodeObject(object, prettyPrint, false);
    }

    public String encodeObject(Object object, boolean prettyPrint, boolean withHeader) {
        return withHeader ? XmlUtil.toStringWithHeader(this.getEncoderForWrite().toElement(object), "  ", "\n", prettyPrint) : XmlUtil.toString((Node)this.getEncoderForWrite().toElement(object), prettyPrint);
    }

    public Object decodeObject(String xml) throws Exception {
        return this.getEncoderForRead().toObject(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistoryList() {
        Object object = this.MUTEX_HISTORY;
        synchronized (object) {
            this.historyList = new ArrayList();
            this.writeHistoryList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getHistory() {
        Object object = this.MUTEX_HISTORY;
        synchronized (object) {
            if (this.historyList == null) {
                try {
                    ArrayList tmp = (ArrayList)this.getStore().getEncodedFile("history.xml");
                    this.historyList = new ArrayList();
                    if (tmp == null) {
                        tmp = new ArrayList();
                    }
                    for (Object o : tmp) {
                        if (o == null) continue;
                        this.historyList.add(o);
                    }
                }
                catch (Exception exc) {
                    this.logException("Creating history list", exc);
                }
            }
            return new ArrayList(this.historyList);
        }
    }

    public void addToHistoryList(String filename) {
        this.addToHistoryList(new FileHistory(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHistoryList() {
        Object object = this.MUTEX_HISTORY;
        synchronized (object) {
            this.getStore().putEncodedFile("history.xml", this.historyList);
        }
        QuicklinkPanel.updateHistoryLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToHistoryList(History newHistory) {
        this.getHistory();
        Object object = this.MUTEX_HISTORY;
        synchronized (object) {
            while (this.historyList.contains(newHistory)) {
                this.historyList.remove(newHistory);
            }
            for (int i = 0; i < this.historyList.size(); ++i) {
                Object obj = this.historyList.get(i);
                obj.equals(newHistory);
            }
            ArrayList tmpList = new ArrayList(this.historyList);
            for (int i = tmpList.size() - 1; i >= 0 && this.historyList.size() >= 20; --i) {
                History history = (History)tmpList.get(i);
                if (history.hasAlias()) continue;
                this.historyList.remove(history);
                --i;
            }
            this.historyList.add(0, newHistory);
            this.writeHistoryList();
        }
    }

    public void doSaveAs() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                IntegratedDataViewer.this.getPersistenceManager().doSaveAs();
            }
        });
    }

    public void doSave() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                IntegratedDataViewer.this.getPersistenceManager().doSave();
            }
        });
    }

    public void doSaveAsDefault() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                IntegratedDataViewer.this.getPersistenceManager().doSaveAsDefault();
            }
        });
    }

    public void doOpenDefault() {
        this.getPersistenceManager().doOpenDefault();
    }

    public void doOpen(String filename, boolean checkUserPreference, boolean andRemove) {
        this.doOpenInThread(filename, checkUserPreference, andRemove);
    }

    public boolean getChangeDataPaths() {
        return this.getChangeDataPathCbx().isSelected();
    }

    public JCheckBox getChangeDataPathCbx() {
        if (this.overwriteDataCbx == null) {
            this.overwriteDataCbx = new JCheckBox("Change data paths", false);
            this.overwriteDataCbx.setToolTipText("Change the file paths that the data sources use");
        }
        return this.overwriteDataCbx;
    }

    private void doOpenInThread(String filename, boolean checkUserPreference, boolean andRemove) {
        boolean overwriteData = false;
        if (filename == null) {
            filename = FileManager.getReadFile("Open File", Misc.newList(this.getArgsManager().getXidvZidvFileFilter(), FILTER_JNLP, FILTER_ISL), GuiUtils.top(this.getChangeDataPathCbx()));
            if (filename == null) {
                return;
            }
            overwriteData = this.getChangeDataPathCbx().isSelected();
        }
        if (this.getArgsManager().isXidvFile(filename)) {
            this.getPersistenceManager().decodeXmlFile(filename, checkUserPreference, overwriteData);
            return;
        }
        this.handleAction(filename, null);
    }

    public void doOpen() {
        this.doOpen(null, true, true);
    }

    public void doOpen(String bundleUri) {
        this.doOpen(bundleUri, true, true);
    }

    public void doImport() {
        this.doOpen(null, false, false);
    }

    public void doClearDefaults() {
        if (!GuiUtils.showYesNoDialog(null, "Are you sure you want to delete your default bundle?", "Delete confirmation")) {
            return;
        }
        this.resourceManager.clearDefaultBundles();
    }

    public XmlEncoder getEncoderForRead() {
        return this.getEncoder(true);
    }

    public XmlEncoder getEncoderForWrite() {
        return this.getEncoder(false);
    }

    @Override
    protected XmlEncoder getEncoder() {
        return this.getEncoder(true);
    }

    protected XmlEncoder getEncoder(boolean forRead) {
        XmlEncoder encoder = new XmlEncoder();
        encoder.defineObjectId(this, "idv");
        if (this.dataManager != null) {
            this.dataManager.initEncoder(encoder, forRead);
        }
        encoder.registerNewClassName("ucar.unidata.repository.InteractiveRepositoryClient", "org.ramadda.repository.client.InteractiveRepositoryClient");
        encoder.registerNewClassName("org.ramadda.repository.InteractiveRepositoryClient", "org.ramadda.repository.client.InteractiveRepositoryClient");
        encoder.registerNewClassName("ucar.unidata.idv.FlythroughPoint", "ucar.unidata.idv.flythrough.FlythroughPoint");
        encoder.addClassPatternReplacement("ucar.unidata.apps.geon", "org.unavco.idv.geon");
        encoder.addClassPatternReplacement("ucar.unidata.repository", "org.ramadda.repository");
        encoder.addClassPatternReplacement("org.ramadda.repository.idv.RamaddaPublisher", "org.ramadda.geodata.publisher.RamaddaPublisher");
        VisADPersistence.init(encoder);
        this.initEncoder(encoder, forRead);
        return encoder;
    }

    protected void initEncoder(XmlEncoder encoder, boolean forRead) {
    }

    public boolean quit() {
        StationModelManager smm;
        if (this.getStore().get("idv.ui.showquitconfirm", true)) {
            JCheckBox cbx = new JCheckBox("Always ask", true);
            JPanel comp = GuiUtils.vbox(new JLabel("<html><b>Do you really want to exit?</b></html>"), GuiUtils.inset((Component)cbx, new Insets(4, 15, 0, 10)));
            int result = JOptionPane.showConfirmDialog(LogUtil.getCurrentWindow(), comp, "Exit Confirmation", 0);
            if (result != 0) {
                return false;
            }
            this.getStore().put("idv.ui.showquitconfirm", cbx.isSelected());
        }
        if (!(smm = this.getStationModelManager()).checkCloseWindow()) {
            return false;
        }
        if (!this.getJythonManager().saveOnExit()) {
            return false;
        }
        this.getStore().saveIfNeeded();
        this.getStore().cleanupTmpFiles();
        this.getPluginManager().closeResources();
        this.getJythonManager().applicationClosing();
        if (this.interactiveMode) {
            this.exit(0);
        }
        return true;
    }

    protected void exit(int exitCode) {
        System.exit(exitCode);
    }

    public void showConsole() {
        LogUtil.showConsole();
    }

    public void logException(String msg, Throwable exc) {
        LogUtil.printException(log_, msg, exc);
    }

    @Override
    public void showWaitCursor() {
        this.getIdvUIManager().showWaitCursor();
    }

    @Override
    public void showNormalCursor() {
        this.getIdvUIManager().showNormalCursor();
    }

    public void clearWaitCursor() {
        this.getIdvUIManager().clearWaitCursor();
    }

    public void closeCurrentWindow() {
        this.getIdvUIManager().closeCurrentWindow();
    }

    public void waitLabelClicked() {
        this.clearWaitCursor();
        JobManager.getManager().stopAllLoads();
    }

    public static void main(String[] args) throws Exception {
        DefaultIdv.main(args);
    }

    public static void processScript(String scriptFile) throws Exception {
        IntegratedDataViewer idv = new IntegratedDataViewer(false);
        try {
            idv.getImageGenerator().processScriptFile(scriptFile);
        }
        finally {
            idv.cleanup();
        }
    }

    public void cleanup() {
        this.getStore().cleanupTmpFiles();
        this.removeAllDisplays();
        this.idv.removeAllDataSources();
        this.getVMManager().removeAllViewManagers();
        this.getIdvUIManager().disposeAllWindows();
        this.getIdvUIManager().clearWaitCursor();
        CacheManager.clearCache();
    }

    public void printCache() {
        CacheManager.printStats();
    }

    protected byte[] getStaticImage(String bundle) throws Exception {
        Trace.call1("getStaticImage-decode");
        this.getPersistenceManager().decodeXmlFile(bundle, false);
        Trace.call2("getStaticImage-decode");
        Trace.call1("getStaticImage-capture");
        this.getImageGenerator().captureImage("test.png");
        Trace.call2("getStaticImage-capture");
        this.removeAllDisplays();
        this.removeAllDataSources();
        this.getVMManager().removeAllViewManagers();
        CacheManager.clearCache();
        FileInputStream fis = new FileInputStream("test.png");
        byte[] bytes = IOUtil.readBytes(fis);
        fis.close();
        return bytes;
    }

    public void printCacheStats() {
        CacheManager.printStats();
    }

    public void printDataCacheStats() {
        DataCacheManager.getCacheManager().printStats();
    }

    public void flushDataCache() {
        DataCacheManager.getCacheManager().flushAllCachedData();
    }

    public void applyPreferences() {
        this.getStateManager().applyPreferences();
        this.getVMManager().applyPreferences();
        this.getPluginManager().applyPreferences();
        List l = this.getDisplayControls();
        if (l == null || l.isEmpty()) {
            return;
        }
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            ((DisplayControl)iter.next()).applyPreferences();
        }
    }

    protected void runImageServer(int port, String propertyFile) {
        LogUtil.setTestMode(true);
        this.imageServer = propertyFile != null ? new ImageServer(this, propertyFile) : new ImageServer(this, port);
        this.getArgsManager().setIsOffScreen(true);
        this.imageServer.init();
    }

    @Override
    public void addErrorButtons(final JDialog dialog, List buttonList, final String msg, final Throwable exc) {
        JButton supportBtn = new JButton("Support Form");
        supportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IntegratedDataViewer.this.getIdvUIManager().showSupportForm(msg, LogUtil.getStackTrace(exc), dialog);
            }
        });
        buttonList.add(supportBtn);
    }

    public String listApi(Object o) {
        StringBuffer sb = new StringBuffer();
        if (o instanceof DisplayControl) {
            DisplaySettingsDialog dsd = new DisplaySettingsDialog(this, (DisplayControlImpl)o, false);
            List<PropertyValue> props = dsd.getPropertyValues();
            for (int i = 0; i < props.size(); ++i) {
                PropertyValue p = props.get(i);
                Object v = p.getValue();
                String type = "n/a";
                if (v != null) {
                    type = v.getClass().getName();
                }
                sb.append(Misc.getSetterMethod(p.getName()) + "(" + type + ")  = " + DisplaySettingsDialog.getValueLabel(v) + "<br>");
            }
            return sb.toString();
        }
        List methods = XmlEncoder.findPropertyMethods(o.getClass(), false);
        for (int i = 0; i < methods.size(); ++i) {
            Method m = (Method)methods.get(i);
            sb.append(m.getName());
            sb.append("<br>");
        }
        return sb.toString();
    }
}

