/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JLabel;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class InstallManager
extends IdvManager {
    public static final String PROP_BUILDPROPERTIES = "idv.install.buildproperties";
    public static final String PROP_BUILDDATE = "idv.build.date";
    public static final String PROP_CURRENTJARS = "idv.install.currentjars";
    public static final String PROP_NIGHTLYJARS = "idv.install.nightlyjars";
    public static final String PREF_CHECKFORNEWRELEASE = "idv.install.checkfornewrelease";
    public static final String PREF_LASTTIMECHECKEDFORNEWRELEASE = "idv.install.lasttimecheckedfornewrelease";

    public InstallManager(IntegratedDataViewer idv) {
        super(idv);
    }

    public boolean isInstallFromJars() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        String jarFile = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        return jarFile.endsWith(".jar");
    }

    public boolean isRestartable() {
        String javaBin = this.getJavaPath();
        if (javaBin == null) {
            return false;
        }
        if (!new File(javaBin).exists()) {
            System.err.println("No java at:" + javaBin);
            return false;
        }
        return this.isInstallFromJars();
    }

    public void installFromNightlyBuild() {
        if (!GuiUtils.showYesNoDialog(null, "Are you sure you want to install the latest nightly build?", "Install")) {
            return;
        }
        this.installNewRelease(this.getProperty(PROP_NIGHTLYJARS, ""));
    }

    public void installNewRelease(String jarsPath) {
        if (!this.isInstallFromJars()) {
            LogUtil.userMessage("You are not running from the installer");
            return;
        }
        if (jarsPath == null || jarsPath.length() == 0) {
            LogUtil.userMessage("No install path found");
            return;
        }
        this.installJars(jarsPath);
    }

    public void testcp() {
        Hashtable jarDateMap = new Hashtable();
        String cp = System.getProperty("java.class.path");
        if (cp == null) {
            return;
        }
        boolean anyChanged = false;
        for (String path : StringUtil.split(cp, ":", true, true)) {
            File f = new File(path);
            if (!f.exists() || !f.isFile() || !path.endsWith(".jar")) continue;
            String jarName = f.getName();
            System.err.println("path:" + jarName);
            Date d = (Date)jarDateMap.get(jarName);
            if (d == null || d.getTime() <= f.lastModified()) continue;
            anyChanged = true;
            break;
        }
    }

    private void installJars(String zipFileUrl) {
        if (!this.isRestartable()) {
            LogUtil.userMessage("You will need to restart the IDV for this change to take effect");
            return;
        }
        String tmpBundle = this.getStore().getTmpFile("bundle.xidv");
        try {
            this.getPersistenceManager().doSave(tmpBundle);
            String jarFile = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            File dir = new File(jarFile).getParentFile();
            InputStream is = IOUtil.getInputStream(zipFileUrl, this.getClass());
            ZipInputStream zin = new ZipInputStream(is);
            ZipEntry ze = null;
            System.err.println("Writing new jars to: " + dir);
            while ((ze = zin.getNextEntry()) != null) {
                String entryName = ze.getName();
                if (ze.isDirectory() || !entryName.endsWith(".jar")) continue;
                System.err.println("  writing jar:" + entryName);
                String dest = IOUtil.joinDir(dir, entryName);
                IOUtil.writeTo(zin, new FileOutputStream(dest));
            }
            zin.close();
            is.close();
        }
        catch (Throwable exc) {
            InstallManager.logException("Error fetching release: " + zipFileUrl, exc);
            return;
        }
        if (GuiUtils.askYesNo("Restart", new JLabel("<html>You will need to restart the IDV for this change to take effect<br>Do you want to restart?"))) {
            try {
                this.restart(null, tmpBundle);
            }
            catch (Throwable exc) {
                exc.printStackTrace();
                InstallManager.logException("Restarting the IDV", exc);
            }
        }
    }

    protected void automaticallyCheckForUpdates() {
    }

    public void checkForUpdates() {
        if (!this.haveNewRelease()) {
            LogUtil.userMessage("You are running the latest version from: " + this.getStateManager().getBuildDate());
        }
        if (!GuiUtils.showYesNoDialog(null, "<html>A new IDV release is available.<br>Would you like to install it?</html>", "Install")) {
            return;
        }
        this.installNewRelease(this.getProperty(PROP_CURRENTJARS, ""));
    }

    public boolean haveNewRelease() {
        try {
            String buildPropertiesPath = this.getProperty(PROP_BUILDPROPERTIES, "");
            if (buildPropertiesPath == null || buildPropertiesPath.length() == 0) {
                return false;
            }
            Properties props = Misc.readProperties(buildPropertiesPath, null, this.getClass());
            String currentBuildDateString = (String)props.get(PROP_BUILDDATE);
            if (currentBuildDateString == null) {
                return false;
            }
            String myBuildDateString = this.getStateManager().getBuildDate();
            Date currentBuildDate = DateUtil.parse(currentBuildDateString);
            Date myBuildDate = DateUtil.parse(myBuildDateString);
            return myBuildDate.getTime() < currentBuildDate.getTime();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public void restart() throws Exception {
        this.restart(this.getArgsManager().getOriginalArgs(), null);
    }

    private String getJavaPath() {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + "/bin/java";
        return javaBin;
    }

    private void restart(String[] cmdLineArgs, String loadBundle) throws Exception {
        if (!this.isRestartable()) {
            return;
        }
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        ArrayList<String> args = new ArrayList<String>();
        String jarFile = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        String javaBin = this.getJavaPath();
        args.add(javaBin);
        args.addAll(bean.getInputArguments());
        args.add("-jar");
        args.add(jarFile);
        if (loadBundle != null) {
            args.add(loadBundle);
        }
        args.add("-nodefault");
        System.err.println("Restarting the IDV with:" + args);
        String[] toExec = Misc.listToStringArray(args);
        try {
            Process p = Runtime.getRuntime().exec(toExec);
            OutputStream out = p.getOutputStream();
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Misc.sleep(1000L);
        System.exit(0);
    }
}

