/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.net.Socket;
import java.util.Date;
import java.util.Hashtable;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.HttpServer;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;

public class ImageServer
extends HttpServer {
    public static final String ARG_REQUEST = "request";
    public static final String ARG_FILE = "file";
    public static final String ARG_BUNDLE = "bundle";
    public static final String ARG_DATASOURCE = "datasource";
    public static final String ARG_PARAM = "param";
    public static final String ARG_DISPLAY = "display";
    public static final String ARG_PROPERTIES = "properties";
    public static final String ARG_WIDTH = "width";
    public static final String ARG_HEIGHT = "height";
    public static final String REQ_MAKEMOVIE = "makemovie";
    public static final String REQ_MAKEIMAGE = "makeimage";
    public static final String REQ_EXIT = "exit";
    IntegratedDataViewer idv;

    public ImageServer(IntegratedDataViewer idv, int port) {
        super(port);
        this.idv = idv;
    }

    public ImageServer(IntegratedDataViewer idv, String propertyFile) {
        super(propertyFile);
        this.idv = idv;
    }

    @Override
    protected HttpServer.RequestHandler doMakeRequestHandler(Socket socket) throws Exception {
        return new ImageRequestHandler(this.idv, this, socket);
    }

    public static class ImageRequestHandler
    extends HttpServer.RequestHandler {
        IntegratedDataViewer idv;

        public ImageRequestHandler(IntegratedDataViewer idv, HttpServer server, Socket socket) throws Exception {
            super(server, socket);
            this.idv = idv;
        }

        @Override
        protected void handleRequest(String path, Hashtable formArgs, Hashtable httpArgs, String content) throws Exception {
            try {
                this.handleRequestInner(path, formArgs, httpArgs, content);
            }
            catch (Throwable exc) {
                System.err.println("error:" + exc);
                exc.printStackTrace();
                try {
                    this.writeResult(false, "<html>Error handling request:<pre>" + exc + "</pre></html>", "text/html");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        protected void handleRequestInner(String path, Hashtable formArgs, Hashtable httpArgs, String content) throws Exception {
            boolean doMovie;
            String mimeType;
            String imageFile = (String)formArgs.get(ImageServer.ARG_FILE);
            String request = (String)formArgs.get(ImageServer.ARG_REQUEST);
            String dataSourceName = (String)formArgs.get(ImageServer.ARG_DATASOURCE);
            String paramName = (String)formArgs.get(ImageServer.ARG_PARAM);
            String displayName = (String)formArgs.get(ImageServer.ARG_DISPLAY);
            String properties = (String)formArgs.get(ImageServer.ARG_PROPERTIES);
            int width = Misc.getProperty(formArgs, ImageServer.ARG_WIDTH, -1);
            int height = Misc.getProperty(formArgs, ImageServer.ARG_HEIGHT, -1);
            if (width > 0 && height > 0) {
                this.idv.getStateManager().setViewSize(new Dimension(width, height));
            }
            if (request == null) {
                request = ImageServer.REQ_MAKEIMAGE;
            }
            if (request.equals(ImageServer.REQ_EXIT)) {
                this.writeResult(true, "<response>ok</response>", "text/xml");
                System.exit(0);
            }
            String string = mimeType = (doMovie = request.equals(ImageServer.REQ_MAKEMOVIE)) ? "video/quicktime" : "image/png";
            if (imageFile == null) {
                String uid = "image_" + Misc.getUniqueId() + (doMovie ? ".mov" : ".png");
                imageFile = this.idv.getObjectStore().getTmpFile(uid);
            }
            System.err.println("image:" + imageFile);
            String bundle = (String)this.server.getProperties().get(ImageServer.ARG_BUNDLE);
            if (bundle == null) {
                bundle = (String)formArgs.get(ImageServer.ARG_BUNDLE);
            }
            long t1 = System.currentTimeMillis();
            if (bundle != null) {
                if (!new File(bundle).exists()) {
                    throw new IllegalArgumentException("Bad bundle file:" + bundle);
                }
                this.log("Loading bundle:" + bundle);
                String xml = IOUtil.readContents(bundle, this.getClass());
                this.idv.getPersistenceManager().decodeXmlInner(xml, false, bundle, "", false);
                this.log("Done loading bundle");
            } else if (dataSourceName != null && paramName != null && displayName != null) {
                this.idv.createDisplay(dataSourceName, paramName, displayName, properties, false);
            } else {
                throw new IllegalStateException("No bundle or data specified");
            }
            long t2 = System.currentTimeMillis();
            this.log("Waiting until displays are done");
            IdvManager.waitUntilDisplaysAreDone(this.idv.getIdvUIManager());
            Misc.sleep(2000L);
            this.log("Done waiting");
            long t3 = System.currentTimeMillis();
            if (doMovie) {
                this.idv.getImageGenerator().captureMovie(imageFile);
            } else {
                this.log("Capturing image");
                this.idv.getImageGenerator().captureImage(imageFile);
                this.log("Done capturing image");
            }
            File f = new File(imageFile);
            this.writeBytes(new FileInputStream(f), mimeType, f.length());
            long t4 = System.currentTimeMillis();
            this.log("Total Time:" + (t4 - t1) + " Load bundle:" + (t2 - t1) + " Wait: " + (t3 - t2) + " Capture:" + (t4 - t3));
            this.idv.cleanup();
        }

        @Override
        protected void writeHeaderArgs() throws Exception {
            super.writeHeaderArgs();
            this.writeLine("Cache-Control: no-cache\r\n");
            this.writeLine("Last-Modified:" + new Date() + "\r\n");
        }
    }
}

