/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.io.File;
import java.util.Hashtable;
import ucar.unidata.idv.IntegratedDataViewer;

public class IdvServer {
    private Object MUTEX = new Object();
    private MyIdv idv;
    private int callCnt = 0;
    private File userDir;

    public IdvServer(File userDir) throws Exception {
        this.idv = new MyIdv(userDir == null ? null : userDir.toString());
        this.idv.getStateManager().putProperty("idv.map.map.level", "0");
        this.userDir = userDir;
    }

    public void evaluateIsl(StringBuffer isl) throws Exception {
        this.evaluateIsl(isl, new Hashtable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateIsl(StringBuffer isl, Hashtable properties) throws Exception {
        Object object = this.MUTEX;
        synchronized (object) {
            if (this.callCnt++ > 100) {
                this.idv.cleanup();
                this.idv = new MyIdv(this.userDir == null ? null : this.userDir.toString());
                this.idv.getStateManager().putProperty("idv.map.map.level", "0");
                this.callCnt = 0;
            }
            this.idv.getImageGenerator().processScriptFile("xml:" + isl, properties);
            this.idv.cleanup();
        }
    }

    public MyIdv getIdv() {
        return this.idv;
    }

    public class MyIdv
    extends IntegratedDataViewer {
        public MyIdv(String userDir) throws Exception {
            String[] stringArray;
            if (userDir == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "-userpath";
                stringArray = stringArray2;
                stringArray2[1] = userDir;
            }
            super(stringArray, false);
        }
    }
}

