/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ucar.unidata.data.gis.Transect;
import ucar.unidata.gis.maps.MapData;
import ucar.unidata.gis.maps.MapInfo;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.StateManager;
import ucar.unidata.idv.control.DisplaySetting;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.ui.XmlTree;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class IdvResourceManager
extends IdvManager
implements HyperlinkListener {
    private boolean debug = false;
    public static final String TAG_RESOURCES = "resources";
    public static final String TAG_RESOURCEBUNDLE = "resourcebundle";
    public static final String TAG_RESOURCE = "resource";
    public static final String TAG_PROPERTY = "property";
    public static final String ATTR_LOADMORE = "loadmore";
    public static final String ATTR_REMOVEPREVIOUS = "removeprevious";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ID = "id";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_LOCATION = "location";
    public static final String ATTR_RESOURCETYPE = "type";
    protected static List resources = new ArrayList();
    private NamedStationTable defaultTable;
    private String[] macroNames;
    private String[] macroValues;
    public static final IdvResource RSC_COLORTABLES = new IdvResource("idv.resource.colortables", "Color tables", "(\\.gp$|\\.ncmap$|\\.et$|\\.tbl$|\\.rgb$|colortables\\.xml$)", true);
    public static final IdvResource RSC_STATIONMODELS = new IdvResource("idv.resource.stationmodels", "Station models", "(stationmodels\\.xml$|.ism$)", true);
    public static final IdvResource RSC_VIEWPOINTS = new XmlIdvResource("idv.resource.viewpoints", "Viewpoints", "viewpoints\\.xml$", true);
    public static final IdvResource RSC_PROJECTIONS = new IdvResource("idv.resource.projections", "Map projections", "projections\\.xml$", true);
    public static final IdvResource RSC_PARAMDEFAULTS = new XmlIdvResource("idv.resource.paramdefaults", "Parameter defaults", "paramdefaults\\.xml$", true);
    public static final IdvResource RSC_DISPLAYSETTINGS = new IdvResource("idv.resource.displaysettings", "Display settings", "displaysettings\\.xml$", true);
    public static final IdvResource RSC_ALIASES = new XmlIdvResource("idv.resource.aliases", "Data aliases", "aliases\\.xml$", true);
    public static final IdvResource RSC_TRANSLATIONS = new XmlIdvResource("idv.resource.translations", "Int to string translations", "translations\\.xml$", true);
    public static final IdvResource RSC_BUNDLEXML = new XmlIdvResource("idv.resource.bundlexml", "List of favorite bundles", "bundles\\.xml$", true);
    public static final IdvResource RSC_DERIVED = new XmlIdvResource("idv.resource.derived", "Derived quantities and formulas", "derived\\.xml$", true);
    public static final IdvResource RSC_JYTHON = new IdvResource("idv.resource.jython", "Jython libraries", "\\.py$", true);
    public static final XmlIdvResource RSC_SKIN = new XmlIdvResource("idv.resource.skin", "UI Skin", "skin\\.xml$", false);
    public static final IdvResource RSC_QUICKLINKS = new IdvResource("idv.resource.quicklinks", "Quicklinks", "\\.qhtml$");
    public static final IdvResource RSC_TRANSECTS = new IdvResource("idv.resource.transects", "Map transects", "transects\\.xml$");
    public static final IdvResource RSC_MESSAGES = new IdvResource("idv.resource.messages", "Message catalog", "\\.pack$");
    public static final IdvResource RSC_GRIB1LOOKUPTABLES = new IdvResource("idv.resource.grib1lookuptables", "Grib 1 Lookup tables", ".*grib1.*\\.lst$");
    public static final IdvResource RSC_GRIB2LOOKUPTABLES = new IdvResource("idv.resource.grib2lookuptables", "Grib 2 Lookup tables", ".*grib2.*\\.lst$");
    public static final IdvResource RSC_GEMPAKGRIDPARAMTABLES = new IdvResource("idv.resource.gempakgridparam", "GEMPAK Grid Parameter tables", ".*grib.*\\.tbl$");
    public static final IdvResource RSC_JYTHONTOCOPY = new IdvResource("idv.resource.jythontocopy", "Jython libraries to copy");
    public static final XmlIdvResource RSC_IMAGEDEFAULTS = new XmlIdvResource("idv.resource.imagedefaults", "ADDE Image Defaults", "imagedefaults\\.xml$");
    public static final XmlIdvResource RSC_BACKGROUNDWMS = new XmlIdvResource("idv.resource.backgroundwms", "Background WMS images", "backgroundwms\\.xml$");
    public static final XmlIdvResource RSC_IMAGESETS = new XmlIdvResource("idv.resource.imagesets", "Image Sets", "imagesets\\.xml$");
    public static final XmlIdvResource RSC_AUTODISPLAYS = new XmlIdvResource("idv.resource.autodisplays", "Automatic display creation", "autodisplays\\.xml$");
    public static final XmlIdvResource RSC_TOOLBAR = new XmlIdvResource("idv.resource.toolbar", "Tool bar", "toolbar\\.xml$");
    public static final XmlIdvResource RSC_ACTIONS = new XmlIdvResource("idv.resource.actions", "Actions", "actions\\.xml$");
    public static final XmlIdvResource RSC_STATIONSYMBOLS = new XmlIdvResource("idv.resource.stationsymbols", "Station model symbols", "stationsymbols\\.xml$");
    public static final XmlIdvResource RSC_COLORPAIRS = new XmlIdvResource("idv.resource.colorpairs", "Color pairs");
    public static final XmlIdvResource RSC_VARIABLERENAMER = new XmlIdvResource("idv.resource.variablerenamer", "Variable renamer", "varrenamer\\.xml");
    public static final XmlIdvResource RSC_URLMAPS = new XmlIdvResource("idv.resource.urlmaps", "URL change maps", "urlmaps\\.xml");
    public static final IdvResource RSC_DATASOURCE = new XmlIdvResource("idv.resource.datasource", "Specification of the data sources", "datasource\\.xml$");
    public static final IdvResource RSC_ADDESERVER = new XmlIdvResource("idv.resource.addeservers", "Specification of the ADDE servers", "addeservers\\.xml$");
    public static final IdvResource RSC_CHOOSERS = new XmlIdvResource("idv.resource.choosers", "The definition of the user interface for data choosers", "choosers\\.xml$");
    public static final IdvResource RSC_BUNDLES = new IdvResource("idv.resource.bundles", "Default bundles that are evaluated at start up");
    public static final IdvResource RSC_CONTROLS = new XmlIdvResource("idv.resource.controls", "Available display controls", "controls\\.xml$", true);
    public static final IdvResource RSC_HELPTIPS = new XmlIdvResource("idv.resource.helptips", "Help tips", "helptips\\.xml$", true);
    public static final IdvResource RSC_LOCATIONS = new XmlIdvResource("idv.resource.locations", "Fixed station locations", "(locations.*\\.xml$|locations.*\\.csv$)");
    public static final IdvResource RSC_GLOBEMAPS = new XmlIdvResource("idv.resource.globemaps", "Maps for the globe displays", "globemaps\\.xml$");
    public static final IdvResource RSC_MAPS = new XmlIdvResource("idv.resource.maps", "Maps for the displays", "maps\\.xml$");
    public static final IdvResource RSC_MENUBAR = new XmlIdvResource("idv.resource.menubar", "Commands in the menu bar", "(defaultmenu\\.xml$|menubar\\.xml$)", true);
    public static final IdvResource RSC_PARAMGROUPS = new XmlIdvResource("idv.resource.paramgroups", "Parameter groups", "paramgroups\\.xml$");
    public static final IdvResource RSC_USERCHOOSER = new XmlIdvResource("idv.resource.userchooser", "End user constructed data choosers");
    public static final IdvResource RSC_PREFERENCES = new XmlIdvResource("idv.resource.preferences", "User preferences", "main\\.xml$");
    public static final IdvResource RSC_PLUGINS = new XmlIdvResource("idv.resource.plugins", "Plugins");
    public static final IdvResource RSC_PLUGININDEX = new XmlIdvResource("idv.resource.pluginindex", "Index of available plugins", "plugins\\.xml$", true);
    public static final IdvResource RSC_PROTOTYPES = new IdvResource("idv.resource.prototypes", "Prototypes");
    public static final IdvResource RSC_NJCONFIG = new IdvResource("idv.resource.njconfig", "NetCDF-Java Config", "nj.*Config\\.xml$");
    public static final IdvResource RSC_PUBLISHERS = new XmlIdvResource("idv.resource.publishers", "Publishers", "publishers\\.xml$");
    public static final IdvResource RSC_PUBLISHERTYPES = new XmlIdvResource("idv.resource.publishertypes", "Publisher Types", "publishertypes\\.xml$");
    private Hashtable locationFullNameMap = new Hashtable();
    private Hashtable typeToLocations = new Hashtable();
    private Hashtable locationNameMap = new Hashtable();
    private List locationList;
    private List<DisplaySetting> displaySettings;
    private List<DisplaySetting> localDisplaySettings;
    private long displaySettingsTimestamp = 0L;
    private List allResources = new ArrayList();
    private Hashtable resourceCollections = new Hashtable();
    private List rbiFiles;
    private List transects;
    private List nonLocalTransects;
    public static boolean hasInitializedTranslations = false;
    public static Map<String, Map<Integer, String>> translationTables = new Hashtable<String, Map<Integer, String>>();

    public IdvResourceManager(IntegratedDataViewer idv) {
        super(idv);
    }

    public List getResources() {
        return resources;
    }

    public List getResourcesForUser() {
        ArrayList<IdvResource> userResources = new ArrayList<IdvResource>();
        for (int i = 0; i < resources.size(); ++i) {
            IdvResource idvResource = (IdvResource)resources.get(i);
            if (!idvResource.forUser) continue;
            userResources.add(idvResource);
        }
        return userResources;
    }

    public ResourceCollection getResources(IdvResource resource) {
        ResourceCollection resourceCollection = this.getResources(resource.id);
        resourceCollection.addResources(resource.extraPaths);
        return resourceCollection;
    }

    public XmlResourceCollection getXmlResources(IdvResource resource) {
        XmlResourceCollection resourceCollection = this.getXmlResources(resource.id);
        resourceCollection.addResources(resource.extraPaths);
        return resourceCollection;
    }

    public void clearDefaultBundles() {
        this.getResources(RSC_BUNDLES).deleteAllFiles();
    }

    public void showHtmlView() {
        GuiUtils.showHtmlDialog(this.getHtmlView(), this);
    }

    public String getHtmlView() {
        StringBuffer buff = new StringBuffer("<h3>Resources</h3>\n<ul>\n");
        for (int i = 0; i < resources.size(); ++i) {
            IdvResource resource = (IdvResource)resources.get(i);
            buff.append("<li><b>" + resource.description + "\n</b> ");
            buff.append(resource.id + "<br>" + " pattern:" + (resource.fileNamePattern != null ? "\"" + resource.fileNamePattern + "\"" : "none"));
            buff.append("<ul>");
            ResourceCollection rc = this.getResources(resource);
            for (int resourceIdx = 0; resourceIdx < rc.size(); ++resourceIdx) {
                boolean isValid = rc.isValid(resourceIdx);
                if (isValid) {
                    buff.append("<li><font color=green>" + rc.get(resourceIdx) + "</font>");
                    continue;
                }
                buff.append("<li><font color=red> X " + rc.get(resourceIdx) + "</font>\n");
            }
            buff.append("</ul>\n");
        }
        buff.append("</ul>\n");
        return buff.toString();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String url = e.getURL() == null ? e.getDescription() : e.getURL().toString();
        if (url.startsWith("view:")) {
            String[] split = StringUtil.split(url = url.substring(5), ":", 2);
            ResourceCollection rc = this.getResources(split[0]);
            if (rc == null) {
                return;
            }
            int index = new Integer(split[1]);
            String contents = rc.read(index);
            JTextArea text = new JTextArea(contents);
            JComponent guiContents = GuiUtils.makeScrollPane(text, 50, 100);
            guiContents.setPreferredSize(new Dimension(500, 600));
            if (rc instanceof XmlResourceCollection) {
                XmlResourceCollection xrc = (XmlResourceCollection)rc;
                Element root = xrc.getRoot(index);
                XmlTree xmlTree = new XmlTree(root);
                xmlTree.setIncludeAttributes(true);
                xmlTree.setUseTagNameAsLabel(true);
                xmlTree.setXmlRoot(root);
                JTabbedPane tab = new JTabbedPane();
                tab.add("Xml", xmlTree);
                tab.add("Text", guiContents);
                guiContents = tab;
            }
            JFrame frame = GuiUtils.createFrame("Resource:" + rc.get(index));
            GuiUtils.packWindow(frame, guiContents, true);
        } else {
            this.getIdv().handleAction(url, null);
        }
    }

    public void processRbi(Element root) {
        this.processRbi(root, false);
    }

    protected void processRbi(Element root, boolean payAttentionToLoadMore) {
        XmlNodeList children = XmlUtil.getElements(root, TAG_RESOURCES);
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            boolean removePrevious = XmlUtil.getAttribute((Node)child, ATTR_REMOVEPREVIOUS, false);
            String resourceName = XmlUtil.getAttribute(child, ATTR_NAME);
            ResourceCollection rc = this.getResources(resourceName = StateManager.fixIds(resourceName));
            if (rc == null) {
                rc = XmlUtil.getAttribute((Node)child, ATTR_RESOURCETYPE, "text").equals("text") ? this.createResourceCollection(resourceName) : this.createXmlResourceCollection(resourceName);
            }
            if (removePrevious) {
                rc.removeAll();
            }
            if (payAttentionToLoadMore && !rc.getCanLoadMore()) continue;
            boolean loadMore = XmlUtil.getAttribute((Node)child, ATTR_LOADMORE, true);
            if (!loadMore) {
                rc.setCanLoadMore(false);
            }
            ArrayList<ResourceCollection.Resource> locationList = new ArrayList<ResourceCollection.Resource>();
            XmlNodeList resources = XmlUtil.getElements(child, TAG_RESOURCE);
            Object labelMap = null;
            for (int resourceIdx = 0; resourceIdx < resources.getLength(); ++resourceIdx) {
                Element resourceNode = (Element)resources.item(resourceIdx);
                String path = this.getResourcePath(XmlUtil.getAttribute(resourceNode, ATTR_LOCATION));
                if (path == null || path.length() == 0) continue;
                String label = XmlUtil.getAttribute((Node)resourceNode, ATTR_LABEL, (String)null);
                String id = XmlUtil.getAttribute((Node)resourceNode, ATTR_ID, (String)null);
                XmlNodeList propertyList = XmlUtil.getElements(resourceNode, TAG_PROPERTY);
                Hashtable<String, String> nodeProperties = null;
                for (int propIdx = 0; propIdx < propertyList.getLength(); ++propIdx) {
                    if (nodeProperties == null) {
                        nodeProperties = new Hashtable<String, String>();
                    }
                    Element propNode = (Element)propertyList.item(propIdx);
                    String propName = XmlUtil.getAttribute(propNode, ATTR_NAME);
                    String propValue = XmlUtil.getAttribute((Node)propNode, ATTR_VALUE, (String)null);
                    if (propValue == null) {
                        propValue = XmlUtil.getChildText(propNode);
                    }
                    nodeProperties.put(propName, propValue);
                }
                NamedNodeMap nnm = resourceNode.getAttributes();
                if (nnm != null) {
                    for (int attrIdx = 0; attrIdx < nnm.getLength(); ++attrIdx) {
                        Attr attr = (Attr)nnm.item(attrIdx);
                        if (attr.getNodeName().equals(ATTR_LOCATION) || attr.getNodeName().equals(ATTR_ID)) continue;
                        if (nodeProperties == null) {
                            nodeProperties = new Hashtable();
                        }
                        nodeProperties.put(attr.getNodeName(), attr.getNodeValue());
                    }
                }
                ArrayList<String> paths = new ArrayList<String>();
                if (path.startsWith("index:")) {
                    String index = IOUtil.readContents(path = path.substring(6), (String)null);
                    if (index != null) {
                        List<String> lines = StringUtil.split(index, "\n", true, true);
                        for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
                            String line = lines.get(lineIdx).trim();
                            if (line.startsWith("#")) continue;
                            paths.add(this.getResourcePath(line));
                        }
                    }
                } else {
                    paths.add(path);
                }
                for (int pathIdx = 0; pathIdx < paths.size(); ++pathIdx) {
                    path = (String)paths.get(pathIdx);
                    if (id != null) {
                        rc.setIdForPath(id, path);
                    }
                    locationList.add(new ResourceCollection.Resource(path, label, nodeProperties));
                }
            }
            rc.addResources(locationList);
        }
    }

    private void addResourceCollection(ResourceCollection rc) {
        this.resourceCollections.put(rc.getId(), rc);
        if (!this.allResources.contains(rc.getId())) {
            this.allResources.add(rc.getId());
        }
    }

    protected ResourceCollection createResourceCollection(String id) {
        ResourceCollection rc = this.getResources(id);
        if (rc == null) {
            rc = new ResourceCollection(id, this.getDescription(id));
            this.addResourceCollection(rc);
        }
        return rc;
    }

    protected XmlResourceCollection createXmlResourceCollection(String id) {
        XmlResourceCollection rc = this.getXmlResources(id);
        if (rc == null) {
            rc = new XmlResourceCollection(id, this.getDescription(id));
            this.addResourceCollection(rc);
        }
        return rc;
    }

    public ResourceCollection getResources(String id) {
        return (ResourceCollection)this.resourceCollections.get(id);
    }

    public void removeResources(String id) {
        this.resourceCollections.remove(id);
    }

    public XmlResourceCollection getXmlResources(String name) {
        return (XmlResourceCollection)this.resourceCollections.get(name);
    }

    private String getDescription(String id) {
        return id;
    }

    protected void init(List rbiFiles) {
        int i;
        this.rbiFiles = this.getResourcePaths(rbiFiles);
        for (i = 0; i < resources.size(); ++i) {
            IdvResource resource = (IdvResource)resources.get(i);
            resource.initResourceCollection(this);
        }
        for (i = 0; i < this.allResources.size(); ++i) {
            ResourceCollection rc;
            String resourceName = (String)this.allResources.get(i);
            List resourcesFromProperties = this.getResourceList(resourceName);
            if (resourcesFromProperties.size() <= 0 || (rc = this.getResources(resourceName)) == null) continue;
            rc.addResources(resourcesFromProperties);
            rc.setCanLoadMore(false);
        }
        XmlResourceCollection rbiCollection = new XmlResourceCollection("RBI files", this.rbiFiles);
        for (int i2 = 0; i2 < rbiCollection.size(); ++i2) {
            Element root = rbiCollection.getRoot(i2);
            if (root == null) continue;
            this.processRbi(root, true);
        }
        this.getIdv().getPluginManager();
        if (this.getArgsManager().listResources) {
            this.showHtmlView();
        }
    }

    protected List getResourceList(String propName) {
        String prop = this.getProperty(propName, NULL_STRING);
        if (prop == null) {
            return new ArrayList();
        }
        return this.getResourcePaths(StringUtil.split(prop, ";", true, true));
    }

    public List getResourcePaths(List paths) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < paths.size(); ++i) {
            String path = this.getResourcePath(paths.get(i).toString());
            if (path == null || path.length() == 0) continue;
            result.add(path);
        }
        return result;
    }

    public void clearResourceMacros() {
        this.macroNames = null;
        this.macroValues = null;
    }

    protected Hashtable getMacroMap() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (int i = 0; i < this.macroNames.length; ++i) {
            if (this.macroValues[i] == null || this.macroValues[i].length() == 0) continue;
            map.put(this.macroNames[i], this.macroValues[i]);
        }
        return map;
    }

    private void initResourceMacros() {
        this.macroNames = new String[]{"USERPATH", "SITEPATH", "IDVPATH", "DATAPATH", "APPPATH", "USERHOME", "VERSION", "VERSION.MAJOR", "VERSION.MINOR", "VERSION.REVISION"};
        this.macroValues = new String[]{this.getUserPath(), this.getSitePath(), this.getIdvResourcePath(), this.getDataResourcePath(), this.getAppResourcePath(), this.getUserHome(), this.getStateManager().getVersion(), this.getStateManager().getVersionMajor(), this.getStateManager().getVersionMinor(), this.getStateManager().getVersionRevision()};
    }

    public String getResourcePath(String path) {
        int i;
        if (this.macroNames == null || this.macroValues == null) {
            this.initResourceMacros();
        }
        for (i = 0; i < this.macroNames.length; ++i) {
            if (this.macroValues[i] == null || this.macroValues[i].length() <= 0) continue;
            path = StringUtil.replace(path, "%" + this.macroNames[i] + "%", this.macroValues[i]);
        }
        for (i = 0; i < this.macroNames.length; ++i) {
            if (path.indexOf("%" + this.macroNames[i] + "%") < 0) continue;
            return null;
        }
        return path;
    }

    public List getLocationList() {
        if (this.locationList == null) {
            try {
                this.locationList = NamedStationTable.createStationTables(this.getXmlResources(RSC_LOCATIONS));
                for (int i = 0; i < this.locationList.size(); ++i) {
                    NamedStationTable location = (NamedStationTable)this.locationList.get(i);
                    this.locationFullNameMap.put(location.getFullName().toLowerCase(), location);
                    this.locationNameMap.put(location.getName().toLowerCase(), location);
                }
            }
            catch (Throwable exc) {
                IdvResourceManager.logException("Creating location list", exc);
                return null;
            }
        }
        return this.locationList;
    }

    public String getIdvResourcePath() {
        return "/ucar/unidata/idv/resources";
    }

    public String getUserHome() {
        return Misc.getSystemProperty("user.home", ".");
    }

    public String getDataResourcePath() {
        return "/ucar/unidata/data";
    }

    public String getAppResourcePath() {
        String fromProperties = this.getProperty("idv.resourcepath", null);
        if (fromProperties != null) {
            return fromProperties;
        }
        Class<?> idvClass = this.getIdv().getClass();
        String path = idvClass.getName();
        path = StringUtil.replace(path, ".", "/");
        path = "/" + IOUtil.getFileRoot(path);
        return path;
    }

    public String getSitePath() {
        if (this.getArgsManager().sitePathFromArgs != null) {
            return this.getArgsManager().sitePathFromArgs;
        }
        return this.getStore().get("SitePath", NULL_STRING);
    }

    public String getUserPath() {
        return this.getStore().getUserDirectory().getPath();
    }

    public boolean removeLocalMaps(boolean forGlobe) {
        ResourceCollection rc = this.getResourceManager().getResources(forGlobe ? RSC_GLOBEMAPS : RSC_MAPS);
        for (int i = 0; i < rc.size(); ++i) {
            File f;
            if (!rc.isWritable(i) || !(f = new File(rc.get(i).toString())).exists()) continue;
            f.delete();
            return true;
        }
        return false;
    }

    public XmlResourceCollection getMapResources(boolean forGlobe) {
        XmlResourceCollection mapResources = this.getXmlResources(RSC_MAPS);
        XmlResourceCollection globeResources = this.getXmlResources(RSC_GLOBEMAPS);
        if (forGlobe && globeResources.size() > 0 && mapResources.size() > 0) {
            mapResources = new XmlResourceCollection(IdvResourceManager.RSC_GLOBEMAPS.id, mapResources);
            Object firstGlobeResource = globeResources.get(0);
            mapResources.removeResource(0);
            mapResources.addResourceAtStart(firstGlobeResource.toString());
        }
        return mapResources;
    }

    public List<MapData> getMaps() {
        MapInfo mapInfo = new MapInfo(this.getXmlResources(RSC_MAPS), false, false);
        ArrayList<MapData> results = new ArrayList<MapData>();
        List<MapData> maps = mapInfo.getMapDataList();
        Hashtable<String, String> seen = new Hashtable<String, String>();
        for (int i = 0; i < maps.size(); ++i) {
            MapData mapData = maps.get(i);
            String key = mapData.getSource() + "-----" + mapData.getDescription();
            if (seen.get(key) != null) continue;
            seen.put(key, key);
            results.add(mapData);
        }
        return results;
    }

    public MapInfo createMapInfo(boolean forGlobe) {
        return new MapInfo(this.getMapResources(forGlobe), true);
    }

    public void writeMapState(String mapsXml, boolean forGlobe) {
        try {
            ResourceCollection mapResources = this.getResources(forGlobe ? RSC_GLOBEMAPS : RSC_MAPS);
            mapResources.writeWritableResource(mapsXml);
            mapResources.clearCache();
        }
        catch (Exception exc) {
            IdvResourceManager.logException("Writing maps", exc);
        }
    }

    public NamedStationTable getDefaultStations() {
        if (this.defaultTable == null) {
            this.defaultTable = this.findLocations(this.getProperty("idv.locations.default", "NEXRAD Sites"));
            if (this.defaultTable == null) {
                this.defaultTable = (NamedStationTable)this.getLocationList().get(0);
            }
        }
        return this.defaultTable;
    }

    public List findLocationsByType(String type) {
        ArrayList<NamedStationTable> result = (ArrayList<NamedStationTable>)this.typeToLocations.get(type);
        if (result == null) {
            result = new ArrayList<NamedStationTable>();
            this.typeToLocations.put(type, result);
            List tables = this.getLocationList();
            for (int i = 0; i < tables.size(); ++i) {
                NamedStationTable table = (NamedStationTable)tables.get(i);
                if (!Misc.equals(table.getType(), type)) continue;
                result.add(table);
            }
        }
        return result;
    }

    public NamedStationTable findLocations(String name) {
        List tables = this.getLocationList();
        NamedStationTable stationTable = (NamedStationTable)this.locationFullNameMap.get(name.toLowerCase());
        if (stationTable != null) {
            return stationTable;
        }
        return (NamedStationTable)this.locationNameMap.get(name.toLowerCase());
    }

    public String getResourceUrlBase() {
        return "https://www.unidata.ucar.edu/georesources";
    }

    public List getTransects() {
        if (this.transects == null) {
            this.transects = new ArrayList();
            this.nonLocalTransects = new ArrayList();
            ResourceCollection rc = this.getResourceManager().getResources(RSC_TRANSECTS);
            Hashtable<String, String> seen = new Hashtable<String, String>();
            for (int resourceIdx = rc.size() - 1; resourceIdx >= 0; --resourceIdx) {
                int idx;
                String resourcePath = rc.get(resourceIdx).toString();
                if (StringUtil.stringMatch(resourcePath, "jar[0-9]+:") && !(resourcePath = resourcePath.substring((idx = resourcePath.indexOf(":")) + 1)).startsWith("/")) {
                    resourcePath = "/" + resourcePath;
                }
                if (seen.get(resourcePath) != null) continue;
                seen.put(resourcePath, "");
                String xml = rc.read(resourceIdx, false);
                if (xml == null) continue;
                boolean writable = rc.isWritable(resourceIdx);
                try {
                    Element root = XmlUtil.getRoot(xml);
                    List tmp = Transect.parseXml(root);
                    for (int transectIdx = 0; transectIdx < tmp.size(); ++transectIdx) {
                        Transect transect = (Transect)tmp.get(transectIdx);
                        transect.setEditable(writable);
                        if (this.transects.contains(transect)) continue;
                        this.transects.add(transect);
                        if (writable) continue;
                        this.nonLocalTransects.add(transect);
                    }
                    continue;
                }
                catch (Throwable parseExc) {
                    IdvResourceManager.logException("Error parsing transect xml", parseExc);
                }
            }
        }
        return this.transects;
    }

    public void writeTransects(List t) {
        this.getTransects();
        ArrayList<Transect> local = new ArrayList<Transect>();
        for (int i = 0; i < t.size(); ++i) {
            Transect transect = (Transect)t.get(i);
            if (this.nonLocalTransects.contains(transect)) continue;
            local.add(transect);
        }
        String xml = Transect.toXml(t);
        ResourceCollection rc = this.getResourceManager().getResources(RSC_TRANSECTS);
        try {
            rc.writeWritableResource(xml);
        }
        catch (Throwable parseExc) {
            IdvResourceManager.logException("Writing transects", parseExc);
        }
        this.transects = null;
        this.nonLocalTransects = null;
    }

    public List<DisplaySetting> getDisplaySettings() {
        if (this.displaySettings == null) {
            this.displaySettings = new ArrayList<DisplaySetting>();
            try {
                Hashtable<String, DisplaySetting> map = new Hashtable<String, DisplaySetting>();
                ResourceCollection rc = this.getResourceManager().getResources(RSC_DISPLAYSETTINGS);
                for (int i = 0; i < rc.size(); ++i) {
                    List tmp;
                    String xml = rc.read(i);
                    if (xml == null || (tmp = (List)this.getIdv().decodeObject(xml)) == null) continue;
                    boolean isLocal = rc.isWritable(i);
                    if (isLocal) {
                        this.localDisplaySettings = tmp;
                    }
                    ArrayList<DisplaySetting> uniqueOnes = new ArrayList<DisplaySetting>();
                    for (int displaySettingIdx = 0; displaySettingIdx < tmp.size(); ++displaySettingIdx) {
                        DisplaySetting displaySetting = (DisplaySetting)tmp.get(displaySettingIdx);
                        if (displaySetting.getName() == null) {
                            displaySetting.setName("");
                        }
                        if (map.get(displaySetting.getName()) != null) continue;
                        map.put(displaySetting.getName(), displaySetting);
                        displaySetting.setIsLocal(isLocal);
                        uniqueOnes.add(displaySetting);
                    }
                    this.displaySettings.addAll(uniqueOnes);
                }
            }
            catch (Throwable exc) {
                IdvResourceManager.logException("Reading display settings", exc);
            }
        }
        if (this.localDisplaySettings == null) {
            this.localDisplaySettings = new ArrayList<DisplaySetting>();
        }
        return this.displaySettings;
    }

    public DisplaySetting findDisplaySetting(String name) {
        List<DisplaySetting> displaySettings = this.getDisplaySettings();
        for (int i = 0; i < displaySettings.size(); ++i) {
            DisplaySetting displaySetting = displaySettings.get(i);
            if (!Misc.equals(name, displaySetting.getName())) continue;
            return displaySetting;
        }
        return null;
    }

    public void displaySettingChanged(DisplaySetting displaySetting) {
        if (!this.localDisplaySettings.contains(displaySetting)) {
            displaySetting.setIsLocal(true);
            this.localDisplaySettings.add(displaySetting);
        }
        this.writeDisplaySettings();
    }

    public void addDisplaySetting(DisplaySetting displaySetting) {
        displaySetting.setIsLocal(true);
        this.localDisplaySettings.add(displaySetting);
        this.displaySettings.add(displaySetting);
        this.writeDisplaySettings();
    }

    public void removeDisplaySettings(List<DisplaySetting> list) {
        for (int displaySettingIdx = 0; displaySettingIdx < list.size(); ++displaySettingIdx) {
            DisplaySetting displaySetting = list.get(displaySettingIdx);
            this.localDisplaySettings.remove(displaySetting);
            this.displaySettings.remove(displaySetting);
        }
        this.writeDisplaySettings();
    }

    public void removeDisplaySetting(DisplaySetting displaySetting) {
        this.removeDisplaySettings(Misc.newList(displaySetting));
    }

    private void writeDisplaySettings() {
        try {
            ++this.displaySettingsTimestamp;
            String xml = this.getIdv().encodeObject(this.localDisplaySettings, true, true);
            ResourceCollection rc = this.getResourceManager().getResources(RSC_DISPLAYSETTINGS);
            rc.writeWritableResource(xml);
        }
        catch (Throwable exc) {
            IdvResourceManager.logException("Writing display settings", exc);
        }
    }

    public long getDisplaySettingsTimestamp() {
        return this.displaySettingsTimestamp;
    }

    public Map<String, Map<Integer, String>> getTranslationsHashtable() {
        if (!hasInitializedTranslations) {
            Element root = this.getIdv().getResourceManager().getXmlResources(RSC_TRANSLATIONS).getRoot(0);
            List datachoices = XmlUtil.findChildren(root, "datachoice");
            for (int i = 0; i < datachoices.size(); ++i) {
                Element dataSource = (Element)datachoices.get(i);
                String dataSourceName = XmlUtil.getAttribute(dataSource, ATTR_NAME);
                List cases = XmlUtil.findChildren(dataSource, "case");
                Hashtable<Integer, String> translations = new Hashtable<Integer, String>();
                for (int j = 0; j < cases.size(); ++j) {
                    Element child = (Element)cases.get(j);
                    String value = XmlUtil.getAttribute(child, ATTR_VALUE);
                    String translation = XmlUtil.getAttribute(child, "translation");
                    translations.put(Integer.parseInt(value), translation);
                }
                translationTables.put(dataSourceName, translations);
            }
        }
        hasInitializedTranslations = true;
        return translationTables;
    }

    public static class XmlIdvResource
    extends IdvResource {
        public XmlIdvResource(String id) {
            this(id, id);
        }

        public XmlIdvResource(String id, String description) {
            this(id, description, null);
        }

        public XmlIdvResource(String id, String description, String fileNamePattern) {
            this(id, description, fileNamePattern, false);
        }

        public XmlIdvResource(String id, String description, String fileNamePattern, boolean forUser) {
            super(id, description, fileNamePattern, true, forUser);
        }

        @Override
        public ResourceCollection initResourceCollection(IdvResourceManager resourceManager) {
            return resourceManager.createXmlResourceCollection(this.id);
        }
    }

    public static class IdvResource {
        protected List extraPaths = new ArrayList();
        String id;
        String description;
        boolean isXml;
        boolean forUser = false;
        protected String fileNamePattern;
        protected Pattern pattern;

        public IdvResource(String id) {
            this(id, id, null);
        }

        public IdvResource(String id, String description) {
            this(id, description, null);
        }

        public IdvResource(String id, String description, String fileNamePattern) {
            this(id, description, fileNamePattern, false);
        }

        public IdvResource(String id, String description, String fileNamePattern, boolean isUser) {
            this(id, description, fileNamePattern, false, isUser);
        }

        public IdvResource(String id, String description, String fileNamePattern, boolean isXml, boolean forUser) {
            this.forUser = forUser;
            this.id = id;
            this.description = description;
            this.isXml = isXml;
            this.fileNamePattern = fileNamePattern;
            resources.add(this);
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public Pattern getPattern() {
            if (this.fileNamePattern == null) {
                return null;
            }
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.fileNamePattern);
            }
            return this.pattern;
        }

        public ResourceCollection initResourceCollection(IdvResourceManager resourceManager) {
            return resourceManager.createResourceCollection(this.id);
        }

        public void addExtraPath(String path) {
            this.extraPaths.add(path);
        }

        public String toString() {
            return this.id + " " + this.fileNamePattern;
        }
    }
}

