/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.gis.maps.MapData;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvPreferenceManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.view.geoloc.ProjectionManager;
import ucar.unidata.xml.PreferenceManager;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlObjectStore;
import ucar.unidata.xml.XmlUtil;

public class IdvProjectionManager
extends IdvManager {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(IdvProjectionManager.class.getName());
    private static final String PM_HELP_ID = "idv.tools.projectionmanager";
    public static final String PREF_PROJ_DFLT = "View.ProjectionDflt";
    private List projectionList;
    private List nonLocalProjections = new ArrayList();
    private ProjectionManager projectionManager;

    public IdvProjectionManager(IntegratedDataViewer idv) {
        super(idv);
    }

    protected void initProjections() {
        ProjectionImpl proj;
        int i;
        if (this.projectionList == null) {
            this.projectionList = new ArrayList();
        }
        XmlEncoder encoder = this.getIdv().getEncoderForRead();
        Hashtable<String, Object> seen = new Hashtable<String, Object>();
        ResourceCollection rc = this.getResourceManager().getResources(IdvResourceManager.RSC_PROJECTIONS);
        this.nonLocalProjections = new ArrayList();
        ArrayList localProjections = new ArrayList();
        for (int resourceIdx = 0; resourceIdx < rc.size(); ++resourceIdx) {
            String xml = rc.read(resourceIdx);
            List projs = null;
            if (xml == null) {
                if (resourceIdx == 0 && (projs = (List)this.getStore().get("View.Map.ProjectionList")) != null) {
                    this.getStore().remove("View.Map.ProjectionList");
                    this.getStore().save();
                }
            } else {
                Element root;
                block15: {
                    root = null;
                    try {
                        root = XmlUtil.getRoot(xml);
                    }
                    catch (Throwable parseExc) {
                        if (Misc.isHtml(xml)) break block15;
                        IdvProjectionManager.logException("Decoding projections", parseExc);
                    }
                }
                if (root != null) {
                    try {
                        projs = (List)encoder.toObject(root);
                    }
                    catch (Throwable exc) {
                        IdvProjectionManager.logException("Decoding projections", exc);
                    }
                }
            }
            if (projs == null) continue;
            if (!rc.isWritable(resourceIdx)) {
                this.nonLocalProjections.addAll(projs);
                continue;
            }
            localProjections.addAll(projs);
        }
        for (i = 0; i < this.nonLocalProjections.size(); ++i) {
            proj = (ProjectionImpl)this.nonLocalProjections.get(i);
            if (seen.get(proj.getName()) != null) continue;
            this.projectionList.add(proj);
            seen.put(proj.getName(), "");
        }
        for (i = 0; i < localProjections.size(); ++i) {
            proj = (ProjectionImpl)localProjections.get(i);
            if (this.contains(this.projectionList, proj)) continue;
            for (int projIdx = 0; projIdx < this.projectionList.size(); ++projIdx) {
                ProjectionImpl tmpProj = (ProjectionImpl)this.projectionList.get(projIdx);
                if (!Misc.equals(tmpProj.getName(), proj.getName())) continue;
                this.projectionList.set(projIdx, proj);
                proj = null;
                break;
            }
            if (proj == null) continue;
            this.projectionList.add(proj);
            seen.put(proj.getName(), proj);
        }
        if (this.projectionList.size() == 0) {
            this.projectionList = ProjectionManager.makeDefaultProjections();
        }
    }

    private boolean contains(List projs, ProjectionImpl proj) {
        for (int i = 0; i < projs.size(); ++i) {
            ProjectionImpl that = (ProjectionImpl)projs.get(i);
            if (!that.equals(proj) || !Misc.equals(that.getName(), proj.getName())) continue;
            return true;
        }
        return false;
    }

    public ProjectionImpl findProjectionByName(String n) {
        List projections = this.getProjections();
        for (int i = 0; i < projections.size(); ++i) {
            ProjectionImpl proj = (ProjectionImpl)projections.get(i);
            if (!proj.getName().equals(n)) continue;
            return proj;
        }
        return null;
    }

    private void updateProjections() {
        List<ViewManager> viewManagers = this.getIdv().getVMManager().getViewManagers();
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager vm = viewManagers.get(i);
            if (!(vm instanceof MapViewManager)) continue;
            try {
                ((MapViewManager)vm).updateProjection();
                continue;
            }
            catch (Throwable exc) {
                IdvProjectionManager.logException("Updating projections", exc);
            }
        }
    }

    public void storeProjections(List newProjections) {
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        ResourceCollection rc = idvResourceManager.getResources(IdvResourceManager.RSC_PROJECTIONS);
        ArrayList<ProjectionImpl> localProjections = new ArrayList<ProjectionImpl>();
        for (int i = 0; i < newProjections.size(); ++i) {
            ProjectionImpl proj = (ProjectionImpl)newProjections.get(i);
            if (this.contains(this.nonLocalProjections, proj)) continue;
            localProjections.add(proj);
        }
        if (rc.getWritable() != null) {
            try {
                String xml = this.getIdv().getEncoderForWrite().toXml(localProjections, true);
                FileOutputStream fos = new FileOutputStream(rc.getWritable());
                fos.write(xml.getBytes());
                fos.close();
            }
            catch (Throwable exc) {
                IdvProjectionManager.logException("Saving projections", exc);
            }
        }
    }

    public List getProjections() {
        return this.projectionList;
    }

    @Override
    public void show() {
        this.showProjectionManager();
    }

    private void showProjectionManager() {
        try {
            List projections = this.getProjections();
            List<MapData> maps = this.getIdv().getResourceManager().getMaps();
            if (this.projectionManager == null) {
                this.projectionManager = new ProjectionManager(null, projections, true, PM_HELP_ID, maps);
                this.projectionManager.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if (!e.getPropertyName().equals("ProjectionImpl")) {
                            return;
                        }
                        IdvProjectionManager.this.storeProjections(IdvProjectionManager.this.projectionManager.getProjections());
                        IdvProjectionManager.this.getStore().save();
                        IdvProjectionManager.this.updateProjections();
                    }
                });
            } else {
                this.projectionManager.setProjections(projections);
                this.projectionManager.setMaps(maps);
            }
            this.projectionManager.show();
        }
        catch (Exception exp) {
            IdvProjectionManager.logException("getUI ().getProjectionManager ()", exp);
        }
    }

    public void initPreferences(IdvPreferenceManager preferenceManager) {
        PreferenceManager projManager = new PreferenceManager(){

            @Override
            public void applyPreference(XmlObjectStore theStore, Object data) {
                IdvProjectionManager.this.applyProjectionPreferences(theStore, data);
            }
        };
        List projections = this.getProjections();
        ProjectionImpl defaultProjection = (ProjectionImpl)this.getStore().get(PREF_PROJ_DFLT);
        ProjectionManager pm = new ProjectionManager(null, projections, false, PM_HELP_ID);
        JPanel contents = GuiUtils.doLayout(new Component[]{pm.getContents()}, 1, GuiUtils.WT_Y, GuiUtils.WT_Y);
        preferenceManager.add("Map Projections", "Default Map Projections", projManager, contents, pm);
    }

    public void applyProjectionPreferences(XmlObjectStore store, Object data) {
        this.getIdv().getIdvProjectionManager().storeProjections(((ProjectionManager)data).getProjections());
    }

    public ProjectionImpl getDefaultProjection() {
        String projectionName;
        ProjectionImpl dfltProjection = (ProjectionImpl)this.getStore().get(PREF_PROJ_DFLT);
        List projections = this.getProjections();
        if (dfltProjection == null && projections.size() > 0 && (projectionName = this.getStateManager().getProperty("idv.projection.default", null)) != null) {
            projectionName = projectionName.trim();
            dfltProjection = (ProjectionImpl)projections.get(0);
            for (int projIdx = 0; projIdx < projections.size(); ++projIdx) {
                ProjectionImpl proj = (ProjectionImpl)projections.get(projIdx);
                if (!Misc.equals(projectionName, proj.getName()) && !proj.getName().endsWith(">" + projectionName)) continue;
                dfltProjection = proj;
                break;
            }
        }
        if (dfltProjection == null && projections.size() > 0) {
            dfltProjection = (ProjectionImpl)projections.get(0);
        }
        if (dfltProjection == null) {
            dfltProjection = this.makeDefaultProjection();
            this.getStore().put(PREF_PROJ_DFLT, (Object)dfltProjection);
        }
        return dfltProjection;
    }

    protected ProjectionImpl makeDefaultProjection() {
        return new LatLonProjection("World", new ProjectionRect(-180.0, -180.0, 180.0, 180.0));
    }
}

