/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.SystemMemoryManager;
import ucar.unidata.idv.SystemPreference;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.ui.CheckboxCategoryPanel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.xml.PreferenceManager;
import ucar.unidata.xml.XmlObjectStore;
import ucar.visad.Util;
import ucar.visad.display.EventMap;
import visad.DateTime;
import visad.Unit;
import visad.VisADException;
import visad.data.DataCacheManager;
import visad.util.ThreadManager;

public class IdvPreferenceManager
extends IdvManager
implements ActionListener {
    private static double latlonValue = -104.56284;
    private static DecimalFormat latlonFormat = new DecimalFormat();
    public static final List<String> DATE_FORMATS = Arrays.asList("yyyy-MM-dd HH:mm:ss z", "MM/dd/yy HH:mm z", "dd.MM.yy HH:mm z", "yyyy-MM-dd", "EEE, MMM dd yyyy HH:mm z", "HH:mm:ss", "HH:mm", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ssZ");
    private static Insets prefPanelSpacer = new Insets(0, 10, 0, 0);
    protected Hashtable choosersToShow = null;
    protected Hashtable controlDescriptorsToShow = null;
    protected boolean haveInitedControlDescriptorsToShow = false;
    protected boolean showAllControls = true;
    protected boolean showAllChoosers = true;
    private List panels = new ArrayList();
    private List managers = new ArrayList();
    protected boolean haveInitedChoosersToShow = false;
    private List dataList = new ArrayList();
    protected Hashtable cbxToCdMap;
    private Hashtable eventPanelMap;
    private List keyInfos;
    private JComponent keyPanel;
    private JComponent mousePanel;
    private PreferenceManager navManager;
    private JTabbedPane pane;
    private JPanel paneHolder;

    public IdvPreferenceManager(IntegratedDataViewer idv) {
        super(idv);
        this.init();
    }

    public void add(String tabLabel, String description, PreferenceManager listener, Container panel, Object data) {
        this.managers.add(listener);
        this.dataList.add(data);
        JLabel label = new JLabel(description, 0);
        JPanel full = GuiUtils.topCenter(GuiUtils.inset((Component)label, 6), panel);
        if (this.pane == null) {
            this.pane = new JTabbedPane();
            this.paneHolder.add((Component)this.pane, "Center");
        }
        this.pane.add(tabLabel, GuiUtils.top(full));
    }

    public void showTab(String tabNameToShow) {
        this.show();
        this.toFront();
        if (this.pane == null) {
            return;
        }
        for (int tabIdx = 0; tabIdx < this.pane.getTabCount(); ++tabIdx) {
            String tabName = this.pane.getTitleAt(tabIdx);
            if (!StringUtil.stringMatch(tabName, tabNameToShow)) continue;
            this.pane.setSelectedIndex(tabIdx);
            return;
        }
        System.err.println("Could not find preference tab:" + tabNameToShow);
    }

    private void init() {
        this.paneHolder = new JPanel(new BorderLayout());
        JPanel buttons = GuiUtils.makeApplyOkHelpCancelButtons(this);
        this.contents = GuiUtils.centerBottom(this.paneHolder, buttons);
        GuiUtils.setTimeZone(this.getDefaultTimeZone());
        GuiUtils.setDefaultDateFormat(this.getDefaultDateFormat());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.close();
        } else if (cmd.equals(GuiUtils.CMD_HELP)) {
            this.getIdvUIManager().showHelp("idv.tools.preferences");
        } else if (cmd.equals(GuiUtils.CMD_OK)) {
            if (!this.apply()) {
                return;
            }
            this.getIdv().applyPreferences();
            this.close();
        } else if (cmd.equals(GuiUtils.CMD_APPLY)) {
            if (!this.apply()) {
                return;
            }
            this.getIdv().applyPreferences();
        }
    }

    @Override
    protected void windowIsClosing() {
        if (this.paneHolder != null) {
            this.paneHolder.removeAll();
            this.pane = null;
        }
    }

    @Override
    public String getWindowTitle() {
        return "User Preferences";
    }

    @Override
    public void show() {
        if (this.pane == null) {
            this.getIdv().initPreferences(this);
        }
        super.show();
    }

    protected void initPreferences() {
        this.navManager = new PreferenceManager(){

            @Override
            public void applyPreference(XmlObjectStore theStore, Object data) {
            }
        };
        this.addBasicPreferences();
        new MapViewManager(this.getIdv()).initPreferences(this);
        this.add("Navigation", "", this.navManager, this.makeEventPanel(), new Hashtable());
        this.getIdv().getIdvUIManager().addToolbarPreferences(this);
        this.addChooserPreferences();
        this.addDisplayPreferences();
        this.addSystemPreferences();
    }

    public boolean apply() {
        try {
            for (int i = 0; i < this.managers.size(); ++i) {
                PreferenceManager manager = (PreferenceManager)this.managers.get(i);
                manager.applyPreference(this.getStore(), this.dataList.get(i));
            }
            this.getStore().save();
            GuiUtils.setTimeZone(this.getDefaultTimeZone());
            GuiUtils.setDefaultDateFormat(this.getDefaultDateFormat());
            return true;
        }
        catch (Exception exc) {
            LogUtil.logException("Error applying preferences", exc);
            return false;
        }
    }

    protected static void applyWidgets(Hashtable widgets, XmlObjectStore store) {
        Enumeration keys = widgets.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object widget = widgets.get(key);
            if (key.equals("idv.cachesize")) {
                double value = Misc.parseNumber(((JTextField)widget).getText().trim());
                store.put(key, value);
                continue;
            }
            if (key.equals("idv.threads.render.max")) {
                int value = (Integer)((JComboBox)widget).getSelectedItem();
                store.put(key, (Object)new Integer(value));
                ThreadManager.setGlobalMaxThreads(value);
                continue;
            }
            if (key.equals("idv.threads.render.data")) {
                int value = (Integer)((JComboBox)widget).getSelectedItem();
                store.put(key, (Object)new Integer(value));
                continue;
            }
            if (key.equals("idv.data.image.maxsize")) {
                int value = (int)Misc.parseNumber(((JTextField)widget).getText().trim());
                store.put(key, value);
                continue;
            }
            if (key.equals("idv.data.cache.percent")) {
                double value = Misc.parseNumber(((JTextField)widget).getText().trim()) / 100.0;
                store.put(key, value);
                DataCacheManager.getCacheManager().setMemoryPercent(value);
                continue;
            }
            if (key.equals("SitePath")) {
                String text = ((JTextField)widget).getText();
                if (text.trim().equals("")) {
                    store.remove(key);
                    continue;
                }
                store.put(key, (Object)text);
                continue;
            }
            if (widget instanceof JCheckBox) {
                store.put(key, ((JCheckBox)widget).isSelected());
                continue;
            }
            if (widget instanceof JTextField) {
                store.put(key, (Object)((JTextField)widget).getText());
                continue;
            }
            if (widget instanceof JRadioButton) {
                if (key.equals("WEIGHTED_AVERAGE") || key.equals("NEAREST_NEIGHBOR")) {
                    if (!((JRadioButton)widget).isSelected()) continue;
                    store.put("DisplayControlImpl.SamplingMode", (Object)((JRadioButton)widget).getText());
                    continue;
                }
                if (key.equals("Appearance_IDV") || key.equals("Appearance_DARK") || key.equals("Appearance_LIGHT")) {
                    if (!((JRadioButton)widget).isSelected()) continue;
                    store.put("AppearanceMode", (Object)((JRadioButton)widget).getText());
                    continue;
                }
                if (key.equals("SYSTEM_LOCALE") || key.equals("US_LOCALE")) {
                    if (key.equals("SYSTEM_LOCALE") && ((JRadioButton)widget).isSelected()) {
                        store.remove("Data.Locale");
                        continue;
                    }
                    if (!((JRadioButton)widget).isSelected()) continue;
                    store.put("Data.Locale", (Object)key);
                    continue;
                }
                if (!((JRadioButton)widget).isSelected()) continue;
                store.put("Data.VerticalCS", (Object)key);
                continue;
            }
            if (widget instanceof List) {
                List data = (List)widget;
                ArrayList<String> result = new ArrayList<String>();
                for (int i = 0; i < data.size(); ++i) {
                    widget = data.get(i);
                    if (!(widget instanceof JTextField)) continue;
                    result.add(((JTextField)widget).getText());
                }
                store.put(key, result);
                continue;
            }
            if (!(widget instanceof JComboBox)) continue;
            Object selected = ((JComboBox)widget).getSelectedItem();
            if (selected instanceof TwoFacedObject) {
                store.put(key, (Object)TwoFacedObject.getIdString(selected));
                continue;
            }
            store.put(key, (Object)selected.toString());
        }
    }

    protected void addDisplayPreferences() {
        this.cbxToCdMap = new Hashtable();
        ArrayList<JPanel> compList = new ArrayList<JPanel>();
        List controlDescriptors = this.getIdv().getAllControlDescriptors();
        final ArrayList<CheckboxCategoryPanel> catPanels = new ArrayList<CheckboxCategoryPanel>();
        Hashtable<String, CheckboxCategoryPanel> catMap = new Hashtable<String, CheckboxCategoryPanel>();
        for (int i = 0; i < controlDescriptors.size(); ++i) {
            ControlDescriptor cd = (ControlDescriptor)controlDescriptors.get(i);
            String displayCategory = cd.getDisplayCategory();
            CheckboxCategoryPanel catPanel = (CheckboxCategoryPanel)catMap.get(displayCategory);
            if (catPanel == null) {
                catPanel = new CheckboxCategoryPanel(displayCategory, false);
                catPanels.add(catPanel);
                catMap.put(displayCategory, catPanel);
                compList.add(catPanel.getTopPanel());
                compList.add(catPanel);
            }
            JCheckBox cbx = new JCheckBox(cd.getLabel(), this.shouldShowControl(cd, true));
            cbx.setToolTipText(cd.getDescription());
            this.cbxToCdMap.put(cbx, cd);
            catPanel.addItem(cbx);
            catPanel.add(GuiUtils.inset((Component)cbx, new Insets(0, 20, 0, 0)));
        }
        final JButton allOn = new JButton("All on");
        allOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (int i = 0; i < catPanels.size(); ++i) {
                    ((CheckboxCategoryPanel)catPanels.get(i)).toggleAll(true);
                }
            }
        });
        final JButton allOff = new JButton("All off");
        allOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (int i = 0; i < catPanels.size(); ++i) {
                    ((CheckboxCategoryPanel)catPanels.get(i)).toggleAll(false);
                }
            }
        });
        Boolean controlsAll = (Boolean)this.getIdv().getPreference("idv.showcontrols.all", Boolean.TRUE);
        final JRadioButton useAllBtn = new JRadioButton("Use all displays", (boolean)controlsAll);
        JRadioButton useTheseBtn = new JRadioButton("Use selected displays:", controlsAll == false);
        GuiUtils.buttonGroup(useAllBtn, useTheseBtn);
        final JPanel cbPanel = GuiUtils.vbox(compList);
        JScrollPane cbScroller = new JScrollPane(cbPanel);
        cbScroller.getVerticalScrollBar().setUnitIncrement(10);
        cbScroller.setPreferredSize(new Dimension(300, 300));
        JPanel exportComp = GuiUtils.right(GuiUtils.makeButton("Export to Plugin", this, "exportControlsToPlugin"));
        JPanel cbComp = GuiUtils.centerBottom(cbScroller, exportComp);
        JPanel bottomPanel = GuiUtils.leftCenter(GuiUtils.inset((Component)GuiUtils.top(GuiUtils.vbox(allOn, allOff)), 4), new Msg.SkipPanel(GuiUtils.hgrid(Misc.newList(cbComp, GuiUtils.filler()), 0)));
        JPanel controlsPanel = GuiUtils.inset((Component)GuiUtils.topCenter(GuiUtils.hbox(useAllBtn, useTheseBtn), bottomPanel), 6);
        GuiUtils.enableTree(cbPanel, !useAllBtn.isSelected());
        useAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GuiUtils.enableTree(cbPanel, !useAllBtn.isSelected());
                allOn.setEnabled(!useAllBtn.isSelected());
                allOff.setEnabled(!useAllBtn.isSelected());
            }
        });
        useTheseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GuiUtils.enableTree(cbPanel, !useAllBtn.isSelected());
                allOn.setEnabled(!useAllBtn.isSelected());
                allOff.setEnabled(!useAllBtn.isSelected());
            }
        });
        GuiUtils.enableTree(cbPanel, !useAllBtn.isSelected());
        allOn.setEnabled(!useAllBtn.isSelected());
        allOff.setEnabled(!useAllBtn.isSelected());
        PreferenceManager controlsManager = new PreferenceManager(){

            @Override
            public void applyPreference(XmlObjectStore theStore, Object data) {
                IdvPreferenceManager.this.controlDescriptorsToShow = new Hashtable();
                Hashtable table = (Hashtable)data;
                List controlDescriptors = IdvPreferenceManager.this.getIdv().getAllControlDescriptors();
                Enumeration keys = table.keys();
                while (keys.hasMoreElements()) {
                    JCheckBox cbx = (JCheckBox)keys.nextElement();
                    ControlDescriptor cd = (ControlDescriptor)table.get(cbx);
                    IdvPreferenceManager.this.controlDescriptorsToShow.put(cd.getControlId(), new Boolean(cbx.isSelected()));
                }
                IdvPreferenceManager.this.showAllControls = useAllBtn.isSelected();
                theStore.put("idv.controlstoshow", (Object)IdvPreferenceManager.this.controlDescriptorsToShow);
                theStore.put("idv.showcontrols.all", (Object)new Boolean(IdvPreferenceManager.this.showAllControls));
            }
        };
        this.add("Available Displays", "What displays should be available in the user interface?", controlsManager, controlsPanel, this.cbxToCdMap);
    }

    protected void addSystemPreferences() {
        Hashtable<String, JComponent> systemWidgets = new Hashtable<String, JComponent>();
        ArrayList<Component> systemComps = new ArrayList<Component>();
        final AtomicLong memVal = new AtomicLong(this.getStore().get("idv.memory", SystemMemoryManager.getDefaultMemory()));
        final SystemPreference systemPref = new SystemPreference(memVal);
        PreferenceManager systemManager = new PreferenceManager(){

            @Override
            public void applyPreference(XmlObjectStore theStore, Object data) {
                systemPref.getSystemManager().applyPreference(theStore, memVal);
                IdvPreferenceManager.applyWidgets((Hashtable)data, theStore);
            }
        };
        systemComps.add(GuiUtils.topCenter(GuiUtils.rLabel("Memory:"), GuiUtils.filler()));
        systemComps.add(systemPref.getComponent(false));
        systemComps.add(GuiUtils.rLabel("Caching:"));
        JCheckBox cacheCbx = new JCheckBox("Cache Data in Memory", this.getStore().get("idv.docache", true));
        systemWidgets.put("idv.docache", cacheCbx);
        JTextField diskCacheSizeFld = new JTextField(Misc.format(this.getStore().get("idv.cachesize", 20.0)), 5);
        List cacheComps = Misc.newList(new JLabel("   Disk Cache Size: "), diskCacheSizeFld, new JLabel(" (MB)  (for temporary files)"));
        systemWidgets.put("idv.cachesize", diskCacheSizeFld);
        JCheckBox gribIdxCacheCbx = new JCheckBox("Write Grib Index in Disk Cache", this.getStore().get("idv.data.gribindexincache", true));
        systemWidgets.put("idv.data.gribindexincache", gribIdxCacheCbx);
        Vector<Integer> threadCnt = new Vector<Integer>();
        for (int i = 1; i <= Runtime.getRuntime().availableProcessors(); ++i) {
            threadCnt.add(new Integer(i));
        }
        JComboBox maxRenderThreadsFld = new JComboBox(threadCnt);
        maxRenderThreadsFld.setSelectedItem(new Integer(this.getIdv().getMaxRenderThreadCount()));
        systemWidgets.put("idv.threads.render.max", maxRenderThreadsFld);
        Vector<Integer> threadCnt2 = new Vector<Integer>();
        for (int i = 1; i <= 12; ++i) {
            threadCnt2.add(new Integer(i));
        }
        JComboBox maxDataThreadsFld = new JComboBox(threadCnt2);
        maxDataThreadsFld.setSelectedItem(new Integer(this.getIdv().getMaxDataThreadCount()));
        systemWidgets.put("idv.threads.render.data", maxDataThreadsFld);
        systemComps.add(GuiUtils.left(cacheCbx));
        systemComps.add(GuiUtils.filler());
        systemComps.add(GuiUtils.left(GuiUtils.hbox(cacheComps)));
        systemComps.add(GuiUtils.filler());
        systemComps.add(GuiUtils.left(gribIdxCacheCbx));
        systemComps.add(GuiUtils.rLabel("Thread Count:"));
        systemComps.add(GuiUtils.left(GuiUtils.hbox((Component)new JLabel("Rendering: "), maxRenderThreadsFld, (Component)new JLabel("   Data Reading: "), maxDataThreadsFld)));
        systemComps.add(GuiUtils.rLabel("Data Cache Memory Percent:"));
        JTextField cacheSizeFld = new JTextField("" + (int)(100.0 * this.getStore().get("idv.data.cache.percent", 0.25)), 7);
        systemWidgets.put("idv.data.cache.percent", cacheSizeFld);
        systemComps.add(GuiUtils.left(GuiUtils.hbox(cacheSizeFld, new JLabel(" (Percent of available memory to be used in the data cache)"))));
        systemComps.add(GuiUtils.rLabel("Max Image Size:"));
        JTextField imageSizeFld = new JTextField(Misc.format(this.getStore().get("idv.data.image.maxsize", -1)), 7);
        systemWidgets.put("idv.data.image.maxsize", imageSizeFld);
        systemComps.add(GuiUtils.left(GuiUtils.hbox(imageSizeFld, new JLabel(" (Pixels, -1=no limit)"))));
        systemComps.add(GuiUtils.rLabel("Java 3D:"));
        JCheckBox geomByRefCbx = new JCheckBox("Enable geometry by reference", this.getStateManager().getPreferenceOrProperty("visad.java3d.geometryByRef", true));
        systemWidgets.put("visad.java3d.geometryByRef", geomByRefCbx);
        JCheckBox imageByRefCbx = new JCheckBox("Enable access to image data by reference", this.getStateManager().getPreferenceOrProperty("visad.java3d.imageByRef", true));
        systemWidgets.put("visad.java3d.imageByRef", imageByRefCbx);
        JCheckBox nPowerOf2Cbx = new JCheckBox("Enable Non-Power of Two (NPOT) textures", this.getStateManager().getPreferenceOrProperty("visad.java3d.textureNpot", false));
        systemWidgets.put("visad.java3d.textureNpot", nPowerOf2Cbx);
        systemComps.add(GuiUtils.left(geomByRefCbx));
        systemComps.add(GuiUtils.filler());
        systemComps.add(GuiUtils.left(imageByRefCbx));
        systemComps.add(GuiUtils.filler());
        systemComps.add(GuiUtils.left(nPowerOf2Cbx));
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel systemPrefs = GuiUtils.inset((Component)GuiUtils.topLeft(GuiUtils.doLayout(systemComps, 2, GuiUtils.WT_N, GuiUtils.WT_N)), 5);
        this.add("System", "System Preferences (requires a restart to take effect)", systemManager, GuiUtils.topCenter(systemPrefs, new JPanel()), systemWidgets);
    }

    public void exportControlsToPlugin() {
        Hashtable selected = new Hashtable();
        Hashtable table = this.cbxToCdMap;
        List controlDescriptors = this.getIdv().getAllControlDescriptors();
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        sb.append("<controls>\n");
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            JCheckBox cbx = (JCheckBox)keys.nextElement();
            if (!cbx.isSelected()) continue;
            ControlDescriptor cd = (ControlDescriptor)table.get(cbx);
            cd.getDescriptorXml(sb);
        }
        sb.append("</controls>\n");
        this.getIdv().getPluginManager().addText(sb.toString(), "controls.xml");
    }

    protected void addChooserPreferences() {
        Hashtable<String, JCheckBox> choosersData = new Hashtable<String, JCheckBox>();
        Boolean choosersAll = (Boolean)this.getIdv().getPreference("idv.choosers.all", Boolean.TRUE);
        List chooserIdList = this.getIdv().getIdvChooserManager().getChooserIds();
        final ArrayList<JCheckBox> choosersList = new ArrayList<JCheckBox>();
        final JRadioButton useAllBtn = new JRadioButton("Use all choosers", (boolean)choosersAll);
        JRadioButton useTheseBtn = new JRadioButton("Use selected choosers:", choosersAll == false);
        GuiUtils.buttonGroup(useAllBtn, useTheseBtn);
        final JButton allOn = new JButton("All on");
        allOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (int i = 0; i < choosersList.size(); ++i) {
                    ((JCheckBox)choosersList.get(i)).setSelected(true);
                }
            }
        });
        final JButton allOff = new JButton("All off");
        allOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (int i = 0; i < choosersList.size(); ++i) {
                    ((JCheckBox)choosersList.get(i)).setSelected(false);
                }
            }
        });
        for (int i = 0; i < chooserIdList.size(); ++i) {
            String chooserId = (String)chooserIdList.get(i);
            String name = this.getIdv().getIdvChooserManager().getChooserName(chooserId);
            JCheckBox cb = new JCheckBox(name, this.shouldShowChooser(chooserId, true));
            choosersData.put(chooserId, cb);
            choosersList.add(cb);
        }
        final JPanel chooserPanel = GuiUtils.top(GuiUtils.vbox(choosersList));
        GuiUtils.enableTree(chooserPanel, !useAllBtn.isSelected());
        GuiUtils.enableTree(allOn, !useAllBtn.isSelected());
        GuiUtils.enableTree(allOff, !useAllBtn.isSelected());
        JScrollPane chooserScroller = new JScrollPane(chooserPanel);
        chooserScroller.getVerticalScrollBar().setUnitIncrement(10);
        chooserScroller.setPreferredSize(new Dimension(300, 300));
        JPanel widgetPanel = GuiUtils.topCenter(GuiUtils.hbox(useAllBtn, useTheseBtn), GuiUtils.leftCenter(GuiUtils.inset((Component)GuiUtils.top(GuiUtils.vbox(allOn, allOff)), 4), chooserScroller));
        JPanel choosersPanel = GuiUtils.topCenter(GuiUtils.inset((Component)new JLabel("Note: This will take effect the next run"), 4), widgetPanel);
        choosersPanel = GuiUtils.inset((Component)GuiUtils.left(choosersPanel), 6);
        useAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GuiUtils.enableTree(chooserPanel, !useAllBtn.isSelected());
                GuiUtils.enableTree(allOn, !useAllBtn.isSelected());
                GuiUtils.enableTree(allOff, !useAllBtn.isSelected());
            }
        });
        useTheseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GuiUtils.enableTree(chooserPanel, !useAllBtn.isSelected());
                GuiUtils.enableTree(allOn, !useAllBtn.isSelected());
                GuiUtils.enableTree(allOff, !useAllBtn.isSelected());
            }
        });
        PreferenceManager choosersManager = new PreferenceManager(){

            @Override
            public void applyPreference(XmlObjectStore theStore, Object data) {
                Hashtable<String, Boolean> newToShow = new Hashtable<String, Boolean>();
                Hashtable table = (Hashtable)data;
                Enumeration keys = table.keys();
                while (keys.hasMoreElements()) {
                    String chooserId = (String)keys.nextElement();
                    JCheckBox chooserCB = (JCheckBox)table.get(chooserId);
                    newToShow.put(chooserId, new Boolean(chooserCB.isSelected()));
                }
                IdvPreferenceManager.this.choosersToShow = newToShow;
                theStore.put("idv.choosers.all", (Object)new Boolean(useAllBtn.isSelected()));
                theStore.put("idv.choosers", (Object)IdvPreferenceManager.this.choosersToShow);
            }
        };
        this.add("Available Choosers", "What data choosers should be shown in the user interface?", choosersManager, choosersPanel, choosersData);
    }

    public TimeZone getDefaultTimeZone() {
        String timezoneString = this.getStore().get("Data.TimeZone", "GMT");
        return TimeZone.getTimeZone(timezoneString);
    }

    public String getDefaultDateFormat() {
        return this.getStore().get("Data.DateFormat", "yyyy-MM-dd HH:mm:ss z");
    }

    protected void addBasicPreferences() {
        PreferenceManager basicManager = new PreferenceManager(){

            @Override
            public void applyPreference(XmlObjectStore theStore, Object data) {
                boolean oldIconsValue = IdvPreferenceManager.this.getStateManager().getPreferenceOrProperty("idv.legend.showicons", false);
                IdvPreferenceManager.this.getIdv().getArgsManager().sitePathFromArgs = null;
                IdvPreferenceManager.applyWidgets((Hashtable)data, theStore);
                IdvPreferenceManager.this.getIdv().getIdvUIManager().setDateFormat();
                IdvPreferenceManager.this.getIdv().initCacheManager();
                IdvPreferenceManager.this.applyEventPreferences(theStore);
                boolean newIconsValue = IdvPreferenceManager.this.getStateManager().getPreferenceOrProperty("idv.legend.showicons", false);
                if (oldIconsValue != newIconsValue) {
                    IdvPreferenceManager.this.getVMManager().updateAllLegends();
                }
            }
        };
        Hashtable<String, JComponent> widgets = new Hashtable<String, JComponent>();
        ArrayList miscList = new ArrayList();
        JTextField sitePathField = new JTextField(this.getStore().get("SitePath", ""), 40);
        widgets.put("SitePath", sitePathField);
        JTextField jythonEditorField = new JTextField(this.getStateManager().getPreferenceOrProperty("idv.jython.editor", ""), 40);
        widgets.put("idv.jython.editor", jythonEditorField);
        JComboBox lookAndFeelBox = null;
        if (!GuiUtils.isMac()) {
            UIManager.LookAndFeelInfo[] landfs = UIManager.getInstalledLookAndFeels();
            Vector<TwoFacedObject> lookAndFeelItems = new Vector<TwoFacedObject>();
            TwoFacedObject selectedLookAndFeel = null;
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            for (int i = 0; i < landfs.length; ++i) {
                TwoFacedObject tfo = new TwoFacedObject((Object)landfs[i].getName(), landfs[i].getClassName());
                lookAndFeelItems.add(tfo);
                if (!lookAndFeel.getClass().getName().equals(landfs[i].getClassName())) continue;
                selectedLookAndFeel = tfo;
            }
            lookAndFeelBox = new JComboBox(lookAndFeelItems);
            if (selectedLookAndFeel != null) {
                lookAndFeelBox.setSelectedItem(selectedLookAndFeel);
            }
            widgets.put("idv.ui.lookandfeel", lookAndFeelBox);
        }
        GuiUtils.setHFill();
        JPanel editorComp = GuiUtils.doLayout(new Component[]{jythonEditorField, GuiUtils.makeFileBrowseButton(jythonEditorField)}, 2, GuiUtils.WT_YN, GuiUtils.WT_N);
        JComponent topPanel = lookAndFeelBox != null ? GuiUtils.formLayout(new Component[]{GuiUtils.rLabel("Resource Sitepath:"), GuiUtils.left(sitePathField), GuiUtils.rLabel("External Editor:"), GuiUtils.left(editorComp), GuiUtils.rLabel("Look & Feel:"), GuiUtils.left(lookAndFeelBox)}) : GuiUtils.formLayout(new Component[]{GuiUtils.rLabel("Resource Sitepath:"), GuiUtils.left(sitePathField), GuiUtils.rLabel("External Editor:"), GuiUtils.left(editorComp)});
        Object[][] prefs1 = new Object[][]{{"General:", null}, {"Show Help Tip Dialog On Start", "help.helptip.Show"}, {"Confirm Before Exiting", "idv.ui.showquitconfirm"}, {"Show Dashboard On Start", "idv.ui.showdashboard", Boolean.TRUE}, {"Show Hidden Files in File Chooser", "idv.showhiddenfiles", Boolean.FALSE}, {"Show Toolbar in Windows", "idv.window.showtoolbar", Boolean.TRUE}};
        JPanel panel1 = IdvPreferenceManager.makePrefPanel(prefs1, widgets, this.getStore());
        Object[][] prefs2 = new Object[][]{{"When Opening a Bundle:", null}, {"Prompt user to remove displays and data", "idv.open.ask"}, {"Remove all displays and data sources", "idv.open.remove"}, {"Ask where to put zipped data files", "idv.zidv.ask"}};
        JPanel panel2 = IdvPreferenceManager.makePrefPanel(prefs2, widgets, this.getStore());
        String defaultAppearanceMode = this.getStore().get("AppearanceMode", "idv");
        JRadioButton appearanceIdv = new JRadioButton("idv", defaultAppearanceMode.equals("idv"));
        appearanceIdv.setToolTipText("IDV appearance");
        JRadioButton appearanceDark = new JRadioButton("dark", defaultAppearanceMode.equals("dark"));
        appearanceDark.setToolTipText("DARK appearance");
        JRadioButton appearanceLight = new JRadioButton("light", defaultAppearanceMode.equals("light"));
        appearanceLight.setToolTipText("LIGHT appearance");
        GuiUtils.buttonGroup(appearanceIdv, appearanceDark, appearanceLight);
        Object[][] prefs3 = new Object[][]{{"Display Controls:", null}, {"Show windows when they are created", "Display.showControlWindow"}, {"Show icons in legend", "idv.legend.showicons", Boolean.FALSE, "<html>Show the toggle and delete icons in the legend"}, {"Use Fast Rendering", "idv.fastrender", Boolean.TRUE, "<html>Turn this on for better performance at<br> the risk of having funky displays</html>"}, {"Auto-select data when loading a template", "idv.autoselectdata", Boolean.FALSE, "<html>When loading a display template should the data be automatically selected</html>"}, {"When Display Control Window is Closed:", null}, {"Remove the display", "DisplayControl.RemoveOnWindowClose", Boolean.FALSE}, {"Remove standalone displays", "idv.displaycontrol.standalone.removeonclose", Boolean.FALSE}};
        JPanel panel3 = IdvPreferenceManager.makePrefPanel(prefs3, widgets, this.getStore());
        JPanel panel4 = GuiUtils.hbox((Component)GuiUtils.left(GuiUtils.rLabel("IDV Appearance: ")), (Component)GuiUtils.left(appearanceIdv), (Component)GuiUtils.left(appearanceDark), GuiUtils.left(appearanceLight));
        widgets.put("Appearance_IDV", appearanceIdv);
        widgets.put("Appearance_DARK", appearanceDark);
        widgets.put("Appearance_LIGHT", appearanceLight);
        JLabel timeLabel = GuiUtils.rLabel("");
        try {
            timeLabel.setText("ex:  " + new DateTime().toString());
        }
        catch (Exception ve) {
            timeLabel.setText("Can't format date: " + ve);
        }
        final JComboBox dateFormatBox = GuiUtils.getEditableBox(new LinkedList<String>(DATE_FORMATS), this.getDefaultDateFormat());
        widgets.put("Data.DateFormat", dateFormatBox);
        final JComboBox timeZoneBox = new JComboBox();
        String timezoneString = this.getStore().get("Data.TimeZone", "GMT");
        Object[] zones = TimeZone.getAvailableIDs();
        Arrays.sort(zones);
        GuiUtils.setListData(timeZoneBox, zones);
        timeZoneBox.setSelectedItem(timezoneString);
        Dimension d = timeZoneBox.getPreferredSize();
        GuiUtils.setPreferredWidth(timeZoneBox, (int)((double)d.width * 0.6));
        widgets.put("Data.TimeZone", timeZoneBox);
        ObjectListener timeLabelListener = new ObjectListener(timeLabel){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JLabel label = (JLabel)this.theObject;
                String format = dateFormatBox.getSelectedItem().toString();
                String zone = timeZoneBox.getSelectedItem().toString();
                try {
                    TimeZone tz = TimeZone.getTimeZone(zone);
                    if (format.equals("yyyy-MM-dd HH:mm:ss z") && zone.equals("GMT")) {
                        format = "yyyy-MM-dd HH:mm:ss'Z'";
                    }
                    label.setText("ex:  " + new DateTime().formattedString(format, tz));
                }
                catch (Exception ve) {
                    label.setText("Invalid format or time zone");
                    LogUtil.userMessage("Invalid format or time zone");
                }
            }
        };
        dateFormatBox.addActionListener(timeLabelListener);
        timeZoneBox.addActionListener(timeLabelListener);
        String defaultLocale = this.getStore().get("Data.Locale", "SYSTEM_LOCALE");
        JRadioButton sysLocale = new JRadioButton("System Default", defaultLocale.equals("SYSTEM_LOCALE"));
        sysLocale.setToolTipText("Use the system default locale for number formatting");
        JRadioButton usLocale = new JRadioButton("English/US", !defaultLocale.equals("SYSTEM_LOCALE"));
        usLocale.setToolTipText("Use the US number formatting");
        GuiUtils.buttonGroup(sysLocale, usLocale);
        widgets.put("SYSTEM_LOCALE", sysLocale);
        widgets.put("US_LOCALE", usLocale);
        String probeFormat = this.getStore().get("DisplayControlImpl.ProbeFormat", "<b>%value%</b> [%unit%] ");
        JComboBox probeFormatFld = GuiUtils.getEditableBox(Misc.newList("<b>%value%</b> [%unit%] ", "%rawvalue% [%rawunit%]", "%value%", "%rawvalue%", "%value% <i>%unit%</i>"), probeFormat);
        widgets.put("DisplayControlImpl.ProbeFormat", probeFormatFld);
        String defaultMode = this.getStore().get("DisplayControlImpl.SamplingMode", "Weighted Average");
        JRadioButton wa = new JRadioButton("Weighted Average", defaultMode.equals("Weighted Average"));
        wa.setToolTipText("Use a weighted average sampling");
        JRadioButton nn = new JRadioButton("Nearest Neighbor", defaultMode.equals("Nearest Neighbor"));
        nn.setToolTipText("Use a nearest neighbor sampling");
        GuiUtils.buttonGroup(wa, nn);
        widgets.put("WEIGHTED_AVERAGE", wa);
        widgets.put("NEAREST_NEIGHBOR", nn);
        String defaultVertCS = this.getStore().get("Data.VerticalCS", "ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem");
        JRadioButton sa = new JRadioButton("Standard Atmosphere", defaultVertCS.equals("ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem"));
        sa.setToolTipText("Use a standard atmosphere height approximation");
        JRadioButton v5d = new JRadioButton("Logarithmic", defaultVertCS.equals("visad.data.vis5d.Vis5DVerticalSystem$Vis5DVerticalCoordinateSystem"));
        v5d.setToolTipText("Use a logarithmic pressure to height vertical transformation");
        widgets.put("ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem", sa);
        widgets.put("visad.data.vis5d.Vis5DVerticalSystem$Vis5DVerticalCoordinateSystem", v5d);
        GuiUtils.buttonGroup(sa, v5d);
        JCheckBox largeRemoteDataRequestWarnCbx = new JCheckBox("Warn on Large Remote Data Requests (experimental)", this.getStore().get("idv.largeremoterequest.warn", false));
        widgets.put("idv.largeremoterequest.warn", largeRemoteDataRequestWarnCbx);
        String formatString = this.getStore().get("Data.LatLonFormat", "##0.0");
        JComboBox formatBox = GuiUtils.getEditableBox(IdvPreferenceManager.getDefaultFormatList(), formatString);
        JLabel formatLabel = new JLabel("");
        try {
            latlonFormat.applyPattern(formatString);
            formatLabel.setText("ex: " + latlonFormat.format(latlonValue));
        }
        catch (IllegalArgumentException iae) {
            formatLabel.setText("Bad format: " + formatString);
        }
        formatBox.addActionListener(new ObjectListener(formatLabel){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JLabel label = (JLabel)this.theObject;
                JComboBox box = (JComboBox)ae.getSource();
                String pattern = box.getSelectedItem().toString();
                try {
                    latlonFormat.applyPattern(pattern);
                    label.setText("ex: " + latlonFormat.format(latlonValue));
                }
                catch (IllegalArgumentException iae) {
                    label.setText("bad pattern: " + pattern);
                    LogUtil.userMessage("Bad format:" + pattern);
                }
            }
        });
        widgets.put("Data.LatLonFormat", formatBox);
        ArrayList<JComponent> formatComps = new ArrayList<JComponent>();
        GuiUtils.tmpInsets = new Insets(0, 5, 0, 5);
        JPanel datePanel = GuiUtils.doLayout(new Component[]{new JLabel("Pattern:"), new JLabel("Time Zone:"), dateFormatBox, GuiUtils.hbox(timeZoneBox, this.getIdv().makeHelpButton("idv.tools.preferences.dateformat"))}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        formatComps.add(GuiUtils.rLabel("Date Format:"));
        formatComps.add(GuiUtils.left(GuiUtils.hbox((Component)dateFormatBox, (Component)this.getIdv().makeHelpButton("idv.tools.preferences.dateformat"), (Component)timeLabel, 5)));
        formatComps.add(GuiUtils.rLabel("Time Zone:"));
        formatComps.add(GuiUtils.left(timeZoneBox));
        formatComps.add(GuiUtils.rLabel("Lat/Lon Format:"));
        formatComps.add(GuiUtils.left(GuiUtils.hbox((Component)formatBox, (Component)this.getIdv().makeHelpButton("idv.tools.preferences.latlonformat"), (Component)formatLabel, 5)));
        formatComps.add(GuiUtils.rLabel("Number Style:"));
        formatComps.add(GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.hbox(sysLocale, usLocale), (Component)this.getIdv().makeHelpButton("idv.tools.preferences.numberstyle"), (Component)new JLabel(""), 5)));
        formatComps.add(GuiUtils.rLabel("Probe Format:"));
        formatComps.add(GuiUtils.left(GuiUtils.hbox((Component)probeFormatFld, (Component)this.getIdv().makeHelpButton("idv.tools.preferences.probeformat"), 5)));
        Unit distanceUnit = null;
        try {
            distanceUnit = Util.parseUnit(this.getStore().get("idv.distanceunit", "km"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        JComboBox unitBox = this.getIdv().getDisplayConventions().makeUnitBox(distanceUnit, null);
        widgets.put("idv.distanceunit", unitBox);
        formatComps.add(GuiUtils.rLabel("Distance Unit:"));
        formatComps.add(GuiUtils.left(unitBox));
        formatComps.add(GuiUtils.rLabel("Sampling Mode:"));
        formatComps.add(GuiUtils.left(GuiUtils.hbox(wa, nn)));
        formatComps.add(GuiUtils.rLabel("Pressure to Height:"));
        formatComps.add(GuiUtils.left(GuiUtils.hbox(sa, v5d)));
        formatComps.add(GuiUtils.rLabel("Data Requests:"));
        formatComps.add(GuiUtils.left(largeRemoteDataRequestWarnCbx));
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel formatPrefs = GuiUtils.inset((Component)GuiUtils.topLeft(GuiUtils.doLayout(formatComps, 2, GuiUtils.WT_N, GuiUtils.WT_N)), 5);
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel rightPanel = GuiUtils.inset((Component)GuiUtils.vbox((Component)panel3, panel4), new Insets(0, 40, 0, 0));
        JPanel leftPanel = GuiUtils.inset((Component)GuiUtils.vbox((Component)panel1, panel2), new Insets(0, 40, 0, 0));
        List panelComps = Misc.newList(GuiUtils.top(leftPanel), GuiUtils.top(rightPanel));
        JPanel panels = GuiUtils.doLayout(panelComps, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        panels = GuiUtils.inset((Component)panels, new Insets(15, 0, 0, 0));
        JPanel miscContents = GuiUtils.inset((Component)GuiUtils.centerBottom(GuiUtils.left(panels), topPanel), 10);
        this.add("General", "General Preferences", basicManager, GuiUtils.topCenter(miscContents, new JPanel()), widgets);
        this.add("Formats & Data", "Formatting and Data Handling Preferences", this.navManager, GuiUtils.topCenter(GuiUtils.top(formatPrefs), new JPanel()), new Hashtable());
    }

    public static JPanel makePrefPanel(Object[][] objects, Hashtable widgets, XmlObjectStore store) {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        for (int i = 0; i < objects.length; ++i) {
            String name = (String)objects[i][0];
            String id = (String)objects[i][1];
            if (id == null) {
                if (i > 0) {
                    comps.add(new JLabel(" "));
                }
                comps.add(new JLabel(name));
                continue;
            }
            boolean value = objects[i].length > 2 ? (Boolean)objects[i][2] : true;
            JCheckBox cb = new JCheckBox(name, store.get(id, value));
            if (objects[i].length > 3) {
                cb.setToolTipText(objects[i][3].toString());
            }
            widgets.put(id, cb);
            comps.add(GuiUtils.inset((Component)cb, prefPanelSpacer));
        }
        return GuiUtils.vbox(comps);
    }

    public boolean[] getDoRemoveBeforeOpening(String name) {
        boolean shouldAsk = this.getStore().get("idv.open.ask", true);
        boolean shouldRemove = this.getStore().get("idv.open.remove", true);
        boolean shouldMerge = this.getStore().get("idv.open.merge", true);
        boolean matchDisplayRegion = this.getStateManager().getProperty("idv.usedisplayarea", false);
        if (shouldAsk) {
            JCheckBox makeAsPreferenceCbx = new JCheckBox("Make this my preference", true);
            JCheckBox askCbx = new JCheckBox("Don't show this window again", false);
            JCheckBox removeCbx = new JCheckBox("Remove all displays & data", shouldRemove);
            JCheckBox changeDataCbx = this.getIdv().getChangeDataPathCbx();
            JCheckBox useRegionCbx = new JCheckBox("Match Display Region", matchDisplayRegion);
            JPanel btnPanel = GuiUtils.left(removeCbx);
            JCheckBox mergeCbx = new JCheckBox("Try to add displays to current windows", shouldMerge);
            JPanel inner = GuiUtils.vbox(new Component[]{btnPanel, mergeCbx, changeDataCbx, useRegionCbx, GuiUtils.filler(10, 10), askCbx});
            inner = GuiUtils.leftCenter(new JLabel("     "), inner);
            String label = name != null ? "  Before opening the bundle, " + name + ", do you want to:  " : "  Before opening this bundle do you want to:  ";
            label = "  Before opening this bundle do you want to:  ";
            JPanel panel = GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.cLabel(label), 5), inner);
            if (!GuiUtils.showOkCancelDialog(null, "Open bundle", panel = GuiUtils.inset((Component)panel, 5), null)) {
                return new boolean[]{false, false, false, shouldAsk};
            }
            shouldRemove = removeCbx.isSelected();
            shouldMerge = mergeCbx.isSelected();
            matchDisplayRegion = useRegionCbx.isSelected();
            this.getStateManager().putProperty("idv.usedisplayarea", matchDisplayRegion);
            if (makeAsPreferenceCbx.isSelected()) {
                this.getStore().put("idv.open.remove", shouldRemove);
            }
            this.getStore().put("idv.open.merge", shouldMerge);
            this.getStore().put("idv.open.ask", !askCbx.isSelected());
            this.getStore().save();
        }
        return new boolean[]{true, shouldRemove, shouldMerge, shouldAsk, matchDisplayRegion};
    }

    public boolean shouldShowControl(ControlDescriptor cd) {
        return this.shouldShowControl(cd, false);
    }

    public boolean shouldShowControl(ControlDescriptor cd, boolean ignoreAllFlag) {
        if (!this.haveInitedControlDescriptorsToShow) {
            String prop;
            this.haveInitedControlDescriptorsToShow = true;
            this.showAllControls = (Boolean)this.getIdv().getPreference("idv.showcontrols.all", Boolean.TRUE);
            this.controlDescriptorsToShow = (Hashtable)this.getIdv().getPreference("idv.controlstoshow");
            if (this.controlDescriptorsToShow == null && (prop = this.getIdv().getProperty("idv.controlstoshow", null)) != null) {
                List<String> controlIds = StringUtil.split(prop, ",");
                for (int i = 0; i < controlIds.size(); ++i) {
                    String name = controlIds.get(i);
                    if (this.controlDescriptorsToShow == null) {
                        this.controlDescriptorsToShow = new Hashtable();
                    }
                    this.controlDescriptorsToShow.put(name, new Boolean(true));
                }
            }
        }
        if (!ignoreAllFlag && this.showAllControls) {
            return true;
        }
        if (this.controlDescriptorsToShow != null) {
            Boolean b = (Boolean)this.controlDescriptorsToShow.get(cd.getControlId());
            if (b == null) {
                return true;
            }
            return b;
        }
        return true;
    }

    public boolean shouldShowChooser(String chooserName) {
        return this.shouldShowChooser(chooserName, false);
    }

    protected boolean shouldShowChooser(String chooserName, boolean ignoreAllFlag) {
        if (chooserName == null) {
            return false;
        }
        if (!this.haveInitedChoosersToShow) {
            String prop;
            this.haveInitedChoosersToShow = true;
            this.showAllChoosers = (Boolean)this.getIdv().getPreference("idv.choosers.all", Boolean.TRUE);
            this.choosersToShow = (Hashtable)this.getIdv().getPreference("idv.choosers");
            if (this.choosersToShow == null && (prop = this.getIdv().getProperty("idv.choosers", null)) != null) {
                List<String> chooserIds = StringUtil.split(prop, ",");
                for (int i = 0; i < chooserIds.size(); ++i) {
                    String name = chooserIds.get(i);
                    if (this.choosersToShow == null) {
                        this.choosersToShow = new Hashtable();
                    }
                    this.choosersToShow.put(name, Boolean.TRUE);
                }
            }
        }
        if (!ignoreAllFlag && this.showAllChoosers) {
            return true;
        }
        if (this.choosersToShow != null) {
            Object o = this.choosersToShow.get(chooserName);
            if (o == null) {
                return true;
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return true;
        }
        return true;
    }

    private static List getDefaultFormatList() {
        ArrayList<String> formatList = new ArrayList<String>();
        String[] formats = new String[]{"##0", "##0.0", "##0.0#", "##0.0##", "0.0", "0.00", "0.000"};
        for (int i = 0; i < formats.length; ++i) {
            formatList.add(formats[i]);
        }
        return formatList;
    }

    public Unit getDefaultDistanceUnit() {
        try {
            return Util.parseUnit(this.getIdv().getObjectStore().get("idv.distanceunit", "km"));
        }
        catch (Exception exc) {
            return null;
        }
    }

    public int[][][] getMouseMap() {
        int[][][] map = (int[][][])this.getStore().get("idv.event.mousemap");
        if (map == null) {
            map = EventMap.IDV_MOUSE_FUNCTIONS;
        }
        return map;
    }

    public int[][] getWheelMap() {
        int[][] map = (int[][])this.getStore().get("idv.event.wheelmap");
        if (map == null) {
            map = EventMap.IDV_WHEEL_FUNCTIONS;
        }
        return map;
    }

    public int[][] getKeyboardMap() {
        int[][] map = (int[][])this.getStore().get("idv.event.keyboardmap");
        if (map == null) {
            map = EventMap.IDV_KEYBOARD_FUNCTIONS;
        }
        return map;
    }

    protected void applyEventPreferences(XmlObjectStore theStore) {
        try {
            JComboBox box;
            int shift;
            int control;
            int[][][] map = new int[3][2][2];
            for (int mouse = 0; mouse < 3; ++mouse) {
                for (control = 0; control < 2; ++control) {
                    for (shift = 0; shift < 2; ++shift) {
                        box = (JComboBox)this.eventPanelMap.get("mouse_" + mouse + "_" + control + "_" + shift);
                        map[mouse][control][shift] = GuiUtils.getValueFromBox(box);
                    }
                }
            }
            theStore.put("idv.event.mousemap", (Object)map);
            int[][] wheel = new int[2][2];
            for (control = 0; control < 2; ++control) {
                for (shift = 0; shift < 2; ++shift) {
                    box = (JComboBox)this.eventPanelMap.get("wheel_" + control + "_" + shift);
                    wheel[control][shift] = GuiUtils.getValueFromBox(box);
                }
            }
            theStore.put("idv.event.wheelmap", (Object)wheel);
            int[][] keyboardMap = new int[this.keyInfos.size()][3];
            for (int i = 0; i < this.keyInfos.size(); ++i) {
                KeyboardInfo ki = (KeyboardInfo)this.keyInfos.get(i);
                ki.set(keyboardMap[i]);
            }
            theStore.put("idv.event.keyboardmap", (Object)keyboardMap);
            List<ViewManager> vms = this.getIdv().getVMManager().getViewManagers();
            for (int i = 0; i < vms.size(); ++i) {
                ViewManager vm = vms.get(i);
                vm.getMaster().setMouseFunctions(map);
                vm.getMaster().setKeyboardEventMap(keyboardMap);
                if (!(vm.getMaster() instanceof NavigatedDisplay)) continue;
                ((NavigatedDisplay)vm.getMaster()).setWheelEventMap(wheel);
            }
        }
        catch (VisADException vae) {
            LogUtil.logException("Setting mouse event maps", vae);
        }
    }

    private JComboBox makeMouseEventBox(int[][][] map, int mouse, int control, int shift) {
        int function = map[mouse][control][shift];
        JComboBox box = GuiUtils.makeComboBox(EventMap.MOUSE_FUNCTION_VALUES, EventMap.MOUSE_FUNCTION_NAMES, function);
        this.eventPanelMap.put("mouse_" + mouse + "_" + control + "_" + shift, box);
        return box;
    }

    private JComboBox makeWheelEventBox(int[][] map, int control, int shift) {
        int function = map[control][shift];
        JComboBox box = GuiUtils.makeComboBox(EventMap.WHEEL_FUNCTION_VALUES, EventMap.WHEEL_FUNCTION_NAMES, function);
        this.eventPanelMap.put("wheel_" + control + "_" + shift, box);
        return box;
    }

    public void applyEventsToGui(List functions) {
        if (functions.size() == 0) {
            GuiUtils.enableTree(this.mousePanel, true);
            GuiUtils.enableTree(this.keyPanel, true);
            return;
        }
        GuiUtils.enableTree(this.mousePanel, false);
        GuiUtils.enableTree(this.keyPanel, false);
        int[][][] mouseFunctions = (int[][][])functions.get(0);
        int[][] wheelFunctions = (int[][])functions.get(1);
        int[][] keyFunctions = (int[][])functions.get(2);
        for (int mouse = 0; mouse < 3; ++mouse) {
            for (int control = 0; control < 2; ++control) {
                for (int shift = 0; shift < 2; ++shift) {
                    JComboBox box = (JComboBox)this.eventPanelMap.get("mouse_" + mouse + "_" + control + "_" + shift);
                    GuiUtils.setValueOfBox(box, mouseFunctions[mouse][control][shift], EventMap.MOUSE_FUNCTION_VALUES, EventMap.MOUSE_FUNCTION_NAMES);
                }
            }
        }
        for (int control = 0; control < 2; ++control) {
            for (int shift = 0; shift < 2; ++shift) {
                JComboBox box = (JComboBox)this.eventPanelMap.get("wheel_" + control + "_" + shift);
                GuiUtils.setValueOfBox(box, wheelFunctions[control][shift], EventMap.WHEEL_FUNCTION_VALUES, EventMap.WHEEL_FUNCTION_NAMES);
            }
        }
        for (int i = 0; i < this.keyInfos.size(); ++i) {
            KeyboardInfo ki = (KeyboardInfo)this.keyInfos.get(i);
            ki.applyToGui(keyFunctions);
        }
    }

    private boolean navEquals(List l1, List l2) {
        if (l1.size() != 3 || l2.size() != 3) {
            return false;
        }
        if (!Misc.arraysEquals((int[][][])l1.get(0), (int[][][])l2.get(0)) && Misc.arraysEquals((int[][])l1.get(1), (int[][])l2.get(1))) {
            return false;
        }
        int[][] a1 = (int[][])l1.get(2);
        int[][] a2 = (int[][])l2.get(2);
        for (int i = 0; i < a1.length; ++i) {
            int[] tmp = a1[i];
            boolean found = false;
            for (int j = 0; j < a2.length && !found; ++j) {
                found = Arrays.equals(tmp, a2[j]);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    protected JComponent makeEventPanel() {
        this.eventPanelMap = new Hashtable();
        this.keyInfos = new ArrayList();
        int[][][] mouse = this.getMouseMap();
        int[][] wheel = this.getWheelMap();
        int[][] keyboard = this.getKeyboardMap();
        List current = Misc.newList(mouse, wheel, keyboard);
        String[] predefinedNames = new String[]{"IDV", "VisAD", "Google Earth", "Custom:"};
        List[] predefinedData = new List[]{Misc.newList(EventMap.IDV_MOUSE_FUNCTIONS, EventMap.IDV_WHEEL_FUNCTIONS, EventMap.IDV_KEYBOARD_FUNCTIONS), Misc.newList(EventMap.VISAD_MOUSE_FUNCTIONS, EventMap.IDV_WHEEL_FUNCTIONS, EventMap.IDV_KEYBOARD_FUNCTIONS), Misc.newList(EventMap.GEARTH_MOUSE_FUNCTIONS, EventMap.GEARTH_WHEEL_FUNCTIONS, EventMap.GEARTH_KEYBOARD_FUNCTIONS), new ArrayList()};
        ButtonGroup bg = new ButtonGroup();
        ArrayList<AbstractButton> radioBtns = new ArrayList<AbstractButton>();
        AbstractButton rb = null;
        boolean anyOn = false;
        for (int i = 0; i < predefinedNames.length; ++i) {
            List list = predefinedData[i];
            rb = new JRadioButton(predefinedNames[i]);
            radioBtns.add(rb);
            if (this.navEquals(current, list)) {
                rb.setSelected(true);
                anyOn = true;
            }
            bg.add(rb);
            rb.addActionListener(GuiUtils.makeActionListener(this, "applyEventsToGui", list));
        }
        if (!anyOn) {
            rb.setSelected(true);
        }
        JPanel buttons = GuiUtils.hbox(radioBtns);
        buttons.setBorder(new TitledBorder("Navigation Mode"));
        ArrayList<Component> comps = new ArrayList<Component>();
        JLabel keyLabel = GuiUtils.makeVerticalLabel("Key Combination");
        comps.add(GuiUtils.filler());
        String[] labels = new String[]{"Left", "Middle", "Right"};
        for (int mouseBtn = 0; mouseBtn < 3; ++mouseBtn) {
            comps.add(GuiUtils.bottom(GuiUtils.cLabel(labels[mouseBtn] + " (MB" + (mouseBtn + 1) + ")")));
        }
        comps.add(GuiUtils.cLabel("Scroll Wheel"));
        int CONTROL_OFF = 0;
        int CONTROL_ON = 1;
        int SHIFT_OFF = 0;
        int SHIFT_ON = 1;
        comps.add(GuiUtils.rLabel("None:"));
        comps.add(this.makeMouseEventBox(mouse, 0, CONTROL_OFF, SHIFT_OFF));
        comps.add(this.makeMouseEventBox(mouse, 1, CONTROL_OFF, SHIFT_OFF));
        comps.add(this.makeMouseEventBox(mouse, 2, CONTROL_OFF, SHIFT_OFF));
        comps.add(this.makeWheelEventBox(wheel, CONTROL_OFF, SHIFT_OFF));
        comps.add(GuiUtils.rLabel("Control:"));
        comps.add(this.makeMouseEventBox(mouse, 0, CONTROL_ON, SHIFT_OFF));
        comps.add(this.makeMouseEventBox(mouse, 1, CONTROL_ON, SHIFT_OFF));
        comps.add(this.makeMouseEventBox(mouse, 2, CONTROL_ON, SHIFT_OFF));
        comps.add(this.makeWheelEventBox(wheel, CONTROL_ON, SHIFT_OFF));
        comps.add(GuiUtils.rLabel("Shift:"));
        comps.add(this.makeMouseEventBox(mouse, 0, CONTROL_OFF, SHIFT_ON));
        comps.add(this.makeMouseEventBox(mouse, 1, CONTROL_OFF, SHIFT_ON));
        comps.add(this.makeMouseEventBox(mouse, 2, CONTROL_OFF, SHIFT_ON));
        comps.add(this.makeWheelEventBox(wheel, CONTROL_OFF, SHIFT_ON));
        comps.add(GuiUtils.rLabel("Control+Shift:"));
        comps.add(this.makeMouseEventBox(mouse, 0, CONTROL_ON, SHIFT_ON));
        comps.add(this.makeMouseEventBox(mouse, 1, CONTROL_ON, SHIFT_ON));
        comps.add(this.makeMouseEventBox(mouse, 2, CONTROL_ON, SHIFT_ON));
        comps.add(this.makeWheelEventBox(wheel, CONTROL_ON, SHIFT_ON));
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        this.mousePanel = GuiUtils.doLayout(comps, 5, GuiUtils.WT_N, GuiUtils.WT_N);
        this.mousePanel = GuiUtils.leftCenter(keyLabel, this.mousePanel);
        ArrayList<JLabel> keyComps = new ArrayList<JLabel>();
        keyComps.add(GuiUtils.cLabel(" Function "));
        keyComps.add(GuiUtils.cLabel(" Key "));
        keyComps.add(GuiUtils.cLabel(" Control "));
        keyComps.add(GuiUtils.cLabel(" Shift "));
        int[] defaultFunc = new int[]{0, -1, EventMap.NO_MASK};
        for (int i = 0; i < EventMap.KEY_FUNCTION_VALUES.length; ++i) {
            int[] func = this.findKeyFunction(EventMap.KEY_FUNCTION_VALUES[i], keyboard);
            if (func == null) {
                func = defaultFunc;
            }
            keyComps.add(new JLabel(EventMap.KEY_FUNCTION_NAMES[i] + "   "));
            this.keyInfos.add(new KeyboardInfo(func, keyComps));
        }
        GuiUtils.tmpInsets = new Insets(3, 0, 0, 0);
        this.keyPanel = GuiUtils.doLayout(keyComps, 4, GuiUtils.WT_N, GuiUtils.WT_N);
        JTabbedPane tab = new JTabbedPane();
        tab.add("Mouse", GuiUtils.top(GuiUtils.inset((Component)this.mousePanel, 10)));
        tab.add("Keyboard", GuiUtils.top(GuiUtils.inset((Component)this.keyPanel, 10)));
        if (anyOn) {
            GuiUtils.enableTree(this.mousePanel, false);
            GuiUtils.enableTree(this.keyPanel, false);
        }
        return GuiUtils.topCenter(buttons, tab);
    }

    private int[] findKeyFunction(int func, int[][] keyMap) {
        for (int i = 0; i < keyMap.length; ++i) {
            if (keyMap[i][0] != func) continue;
            return keyMap[i];
        }
        return null;
    }

    private static class KeyboardInfo {
        static Vector items = new Vector();
        JCheckBox controlCbx;
        int function;
        JComboBox keyBox;
        JCheckBox shiftCbx;

        public KeyboardInfo(int[] func, List keyComps) {
            this.function = func[0];
            if (items.size() == 0) {
                items.add("none");
                items.add(this.getKeyText(38, false));
                items.add(this.getKeyText(40, false));
                items.add(this.getKeyText(37, false));
                items.add(this.getKeyText(39, false));
                items.add("R");
                items.add("U");
            }
            this.keyBox = new JComboBox(items);
            this.keyBox.setEditable(true);
            keyComps.add(this.keyBox);
            this.controlCbx = new JCheckBox("");
            this.shiftCbx = new JCheckBox("");
            keyComps.add(GuiUtils.inset((Component)this.controlCbx, new Insets(0, 10, 0, 0)));
            keyComps.add(GuiUtils.inset((Component)this.shiftCbx, new Insets(0, 10, 0, 0)));
            this.applyToGui(func);
        }

        public void set(int[] funcs) {
            funcs[0] = this.function;
            funcs[2] = EventMap.NO_MASK;
            if (this.shiftCbx.isSelected() && this.controlCbx.isSelected()) {
                funcs[2] = 3;
            } else if (this.shiftCbx.isSelected()) {
                funcs[2] = 1;
            } else if (this.controlCbx.isSelected()) {
                funcs[2] = 2;
            }
            String key = this.keyBox.getSelectedItem().toString().trim().toUpperCase();
            if (key.equals("NONE")) {
                funcs[1] = 0;
            } else if (key.equals(this.getKeyText(38, true))) {
                funcs[1] = 38;
            } else if (key.equals(this.getKeyText(40, true))) {
                funcs[1] = 40;
            } else if (key.equals(this.getKeyText(39, true))) {
                funcs[1] = 39;
            } else if (key.equals(this.getKeyText(37, true))) {
                funcs[1] = 37;
            } else {
                if (key.length() > 1) {
                    throw new IllegalArgumentException("Unknown key:" + key);
                }
                funcs[1] = GuiUtils.charToKeyCode(key);
            }
        }

        private String getKeyText(int key, boolean upCase) {
            String s = KeyEvent.getKeyText(key);
            return upCase ? s.toUpperCase() : s;
        }

        public void applyToGui(int[][] funcs) {
            for (int i = 0; i < funcs.length; ++i) {
                if (funcs[i][0] != this.function) continue;
                this.applyToGui(funcs[i]);
                break;
            }
        }

        public void applyToGui(int[] func) {
            String keyText;
            String string = keyText = func[1] <= 0 ? "none" : this.getKeyText(func[1], false);
            if (!items.contains(keyText)) {
                items.add(keyText);
            }
            this.keyBox.setSelectedItem(keyText);
            this.controlCbx.setSelected(func[2] != EventMap.NO_MASK && (func[2] & 2) != 0);
            this.shiftCbx.setSelected(func[2] != EventMap.NO_MASK && (func[2] & 1) != 0);
        }
    }
}

