/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.DataManager;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceResults;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.grid.GeoGridDataSource;
import ucar.unidata.data.grid.GridDataSource;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.DataSourceHistory;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.LibVersionUtil;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.SavedBundle;
import ucar.unidata.idv.ServerUrlRemapper;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.collab.CollabManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.MapDisplayControl;
import ucar.unidata.idv.ui.DataSelector;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.idv.ui.IslDialog;
import ucar.unidata.idv.ui.LoadBundleDialog;
import ucar.unidata.idv.ui.QuicklinkPanel;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LayoutUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectPair;
import ucar.unidata.util.Prototypable;
import ucar.unidata.util.PrototypeManager;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import visad.util.ThreadManager;

public class IdvPersistenceManager
extends IdvManager
implements PrototypeManager {
    public static final String PROP_BUNDLEPATH = "idv.bundlepath";
    public static final String PROP_ZIDVPATH = "idv.zidvpath";
    public static final String PROP_TIMESLIST = "idv.timeslist";
    public static final String PROP_DRIVERTIMESTART = "idv.drivertimestart";
    public static final String PROP_DRIVERTIMEEND = "idv.drivertimeend";
    public static final String PROP_GEOSELECTION = "idv.geoselection";
    public static final String PROP_ENSLIST = "idv.enslist";
    public static final String CAT_GENERAL = "General";
    public static final String CAT_TOOLBAR = "Toolbar";
    public static final int BUNDLES_ALL = -1;
    public static final int BUNDLES_FAVORITES = 0;
    public static final int BUNDLES_DISPLAY = 1;
    public static final int BUNDLES_DATA = 2;
    public static final String CATEGORY_SEPARATOR = ">";
    public static final String CATEGORY_SEPARATOR_XML = "&gt;";
    private List fileMapping;
    private boolean addWindows = false;
    private String currentTemplateName;
    private List<SavedBundle> bundlesFromXml;
    private JCheckBox saveViewStateCbx;
    private JCheckBox saveDisplaysCbx;
    private JCheckBox saveDataSourcesCbx;
    private JCheckBox saveDataCbx;
    private JCheckBox makeDataEditableCbx;
    private boolean makeDataEditable = false;
    private JCheckBox makeDataRelativeCbx;
    private boolean makeDataRelative = false;
    private JComboBox saveJythonBox;
    private JComboBox publishCbx;
    private boolean saveViewState = true;
    private boolean saveDisplays = true;
    private boolean saveDataSources = true;
    private boolean saveJython = false;
    private boolean saveData = false;
    private List<SavedBundle> displayTemplates;
    private List<SavedBundle> dataSourceBundles;
    String currentFileName = null;
    IslDialog islDialog;
    private JCheckBox includeBundleCbx;
    private JTextField bundlePrefixFld;
    private JComponent bundleUrlComp;
    private boolean catSelected;
    public static String bundleIdvVersion;

    public IdvPersistenceManager(IntegratedDataViewer idv) {
        super(idv);
        this.cleanupOldSavedBundles();
        if (this.getPrototypeFile(this.getClass()) != null && Misc.getPrototypeManager() == null) {
            Misc.setPrototypeManager(this);
        }
        this.makeDataEditableCbx = new JCheckBox("Enable user to change data", false);
        this.makeDataEditableCbx.setToolTipText("When loading in this saved bundle do you want to be able to change the file paths of the data");
        this.makeDataRelativeCbx = new JCheckBox("Save with relative paths", false);
        this.makeDataRelativeCbx.setToolTipText("Write out this bundle with the data sources having paths relative to the bundle when loaded");
        this.saveViewStateCbx = new JCheckBox("Views", true);
        int keyCode = GuiUtils.charToKeyCode(this.saveViewStateCbx.getText());
        if (keyCode != -1) {
            this.saveViewStateCbx.setMnemonic(keyCode);
        }
        this.saveViewStateCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IdvPersistenceManager.this.saveViewState = IdvPersistenceManager.this.saveViewStateCbx.isSelected();
            }
        });
        this.saveDisplaysCbx = new JCheckBox("Displays", true);
        keyCode = GuiUtils.charToKeyCode(this.saveDisplaysCbx.getText());
        if (keyCode != -1) {
            this.saveDisplaysCbx.setMnemonic(keyCode);
        }
        this.saveDisplaysCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IdvPersistenceManager.this.saveDisplays = IdvPersistenceManager.this.saveDisplaysCbx.isSelected();
            }
        });
        this.saveDataSourcesCbx = new JCheckBox("Data Sources", true);
        keyCode = GuiUtils.charToKeyCode("S");
        if (keyCode != -1) {
            this.saveDataSourcesCbx.setMnemonic(keyCode);
        }
        this.saveDataSourcesCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IdvPersistenceManager.this.saveDataSources = IdvPersistenceManager.this.saveDataSourcesCbx.isSelected();
                if (!IdvPersistenceManager.this.saveDataSources) {
                    IdvPersistenceManager.this.saveDataCbx.setSelected(false);
                    IdvPersistenceManager.this.saveData = false;
                }
            }
        });
        this.saveJythonBox = new JComboBox(new Vector(Misc.newList("No Jython", "All Local Jython", "Selected Jython")));
        ActionListener jythonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IdvPersistenceManager.this.saveJython = IdvPersistenceManager.this.saveJythonBox.getSelectedIndex() != 0;
            }
        };
        this.saveJythonBox.addActionListener(jythonListener);
        this.saveDataCbx = new JCheckBox("Data", this.saveData);
        keyCode = GuiUtils.charToKeyCode("A");
        if (keyCode != -1) {
            this.saveDataCbx.setMnemonic(keyCode);
        }
        this.saveDataCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IdvPersistenceManager.this.saveData = IdvPersistenceManager.this.saveDataCbx.isSelected();
                if (IdvPersistenceManager.this.saveData) {
                    IdvPersistenceManager.this.saveDataSourcesCbx.setSelected(true);
                    IdvPersistenceManager.this.saveDataSources = true;
                }
            }
        });
    }

    private void cleanupOldSavedBundles() {
        boolean didAny = false;
        File savedBundlesDir = this.getStore().getSavedBundlesDir();
        IOUtil.makeDir(savedBundlesDir);
        File[] fileArray = new File[2];
        String string = this.getStore().getUserDirectory().toString();
        this.getStore();
        fileArray[0] = new File(IOUtil.joinDir(string, "bundles"));
        fileArray[1] = new File(IOUtil.joinDir(this.getStore().getUserDirectory().toString(), "displaytemplates"));
        File[] dirs = fileArray;
        int[] types = new int[]{0, 1};
        for (int i = 0; i < dirs.length; ++i) {
            List<File> oldFiles = IOUtil.getFiles(null, dirs[i], true, this.getArgsManager().getXidvFileFilter());
            for (int fileIdx = 0; fileIdx < oldFiles.size(); ++fileIdx) {
                didAny = true;
                File file = oldFiles.get(fileIdx);
                try {
                    List<String> categories = IdvPersistenceManager.fileToCategories(dirs[i].toString(), file.getParent().toString());
                    String name = IOUtil.stripExtension(IOUtil.getFileTail(file.toString()));
                    File newFile = new File("");
                    SavedBundle savedBundle = new SavedBundle(newFile.toString(), name, categories, null, true, types[i]);
                    continue;
                }
                catch (Exception exc) {
                    LogUtil.consoleMessage("Error cleaning up old bundles.\ndir:" + dirs[i] + "\nfile:" + file + "\nparent:" + file.getParent() + "\nError:" + exc);
                }
            }
        }
    }

    public void getControlDescriptors(List l) {
        List<SavedBundle> templates = this.getDisplayTemplates();
        for (int i = 0; i < templates.size(); ++i) {
            SavedBundle bundle = templates.get(i);
            l.add(new ControlDescriptor(this.getIdv(), bundle.getUrl(), (DisplayControl)bundle.getPrototype()));
        }
    }

    public void setFileMapping(List ids, List files) {
        for (int i = 0; i < ids.size(); ++i) {
            this.addFileMapping((String)ids.get(i), (List)files.get(i));
        }
    }

    public void clearFileMapping() {
        this.fileMapping = null;
    }

    public void setAddWindows(boolean bl) {
        this.addWindows = bl;
    }

    public void addFileMapping(String identifier, List files) {
        if (this.fileMapping == null) {
            this.fileMapping = new ArrayList();
        }
        this.fileMapping.add(new ObjectPair(identifier, files));
    }

    public JPanel getFileAccessory() {
        List fileAccessories = Misc.newList(this.saveViewStateCbx, this.saveDisplaysCbx, this.saveDataSourcesCbx);
        fileAccessories.add(GuiUtils.left(GuiUtils.inset((Component)this.saveJythonBox, new Insets(0, 3, 0, 0))));
        fileAccessories.add(GuiUtils.filler(1, 10));
        fileAccessories.add(this.makeDataRelativeCbx);
        if (this.publishCbx == null) {
            this.publishCbx = this.getIdv().getPublishManager().makeSelector();
        }
        if (this.publishCbx != null) {
            fileAccessories.add(GuiUtils.filler(1, 10));
            fileAccessories.add(this.publishCbx);
        }
        return GuiUtils.top(GuiUtils.vbox(Misc.newList(new JLabel("What should be saved?"), GuiUtils.vbox(fileAccessories))));
    }

    private void loadBundlesInDirectory(List<SavedBundle> allBundles, List categories, File file) {
        String[] localBundles = file.list(this.getArgsManager().getXidvZidvFileFilter());
        for (int i = 0; i < localBundles.length; ++i) {
            String filename = IOUtil.joinDir(file.toString(), localBundles[i]);
            allBundles.add(new SavedBundle(filename, IOUtil.stripExtension(localBundles[i]), categories, null, true, 0));
        }
    }

    public static String categoriesToString(List cats) {
        return StringUtil.join(CATEGORY_SEPARATOR, cats);
    }

    public static List stringToCategories(String category) {
        category = category.replaceAll(CATEGORY_SEPARATOR_XML, CATEGORY_SEPARATOR);
        return StringUtil.split(category, CATEGORY_SEPARATOR, true, true);
    }

    public static List<String> fileToCategories(String root, String filename) {
        int idx = root.length() + 1;
        return StringUtil.split(filename.substring(idx), File.separator);
    }

    public static String getBundleXml(List<SavedBundle> bundles, boolean includeCategoryInUrl) {
        Document doc = XmlUtil.makeDocument();
        Element root = doc.createElement("bundles");
        for (SavedBundle savedBundle : bundles) {
            savedBundle.toXml(doc, root, includeCategoryInUrl);
        }
        return XmlUtil.toString(root);
    }

    public List<SavedBundle> getXmlBundles(int type) {
        if (this.bundlesFromXml == null) {
            this.bundlesFromXml = new ArrayList<SavedBundle>();
            XmlResourceCollection resources = this.getResourceManager().getXmlResources(IdvResourceManager.RSC_BUNDLEXML);
            try {
                for (int i = 0; i < resources.size(); ++i) {
                    Element root = resources.getRoot(i);
                    if (root == null) continue;
                    String path = resources.get(i).toString();
                    String dirRoot = IOUtil.getFileRoot(path);
                    this.bundlesFromXml.addAll(SavedBundle.processBundleXml(root, dirRoot, this.getResourceManager(), resources.isWritable(i)));
                }
            }
            catch (Exception exc) {
                LogUtil.logException("Error loading bundles xml", exc);
            }
        }
        ArrayList<SavedBundle> subset = new ArrayList<SavedBundle>();
        for (SavedBundle savedBundle : this.bundlesFromXml) {
            if (type != -1 && savedBundle.getType() != type) continue;
            subset.add(savedBundle);
        }
        return subset;
    }

    public List<SavedBundle> getFavorites() {
        List<SavedBundle> allBundles = this.getLocalBundles();
        allBundles.addAll(this.getXmlBundles(0));
        return allBundles;
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public void setCurrentFileName(String f) {
        this.currentFileName = f;
    }

    public void doSaveAs() {
        String filename = FileManager.getWriteFile(this.getArgsManager().getBundleFileFilters(), null, (JComponent)this.getFileAccessory());
        if (filename == null) {
            return;
        }
        this.setCurrentFileName(filename);
        boolean prevMakeDataEditable = this.makeDataEditable;
        this.makeDataEditable = this.makeDataEditableCbx.isSelected();
        boolean prevMakeDataRelative = this.makeDataRelative;
        this.makeDataRelative = this.makeDataRelativeCbx.isSelected();
        if (this.doSave(filename)) {
            this.getPublishManager().publishContent(filename, null, this.publishCbx);
            this.getIdv().addToHistoryList(filename);
        }
        this.makeDataEditable = prevMakeDataEditable;
        this.makeDataRelative = prevMakeDataRelative;
    }

    public void doSaveAs(String filename) {
        if (filename == null) {
            return;
        }
        this.setCurrentFileName(filename);
        boolean prevMakeDataEditable = this.makeDataEditable;
        this.makeDataEditable = this.makeDataEditableCbx.isSelected();
        boolean prevMakeDataRelative = this.makeDataRelative;
        this.makeDataRelative = this.makeDataRelativeCbx.isSelected();
        if (this.doSave(filename, true, true)) {
            this.getPublishManager().publishContent(filename, null, this.publishCbx);
            this.getIdv().addToHistoryList(filename);
        }
        this.makeDataEditable = prevMakeDataEditable;
        this.makeDataRelative = prevMakeDataRelative;
    }

    private void addBundleCategories(JComboBox catBox, List defaultCategories, String topDir) {
        int i;
        catBox.removeAllItems();
        List<File> subdirs = IOUtil.getDirectories(new File(topDir), true);
        for (i = 0; i < defaultCategories.size(); ++i) {
            String defaultCategory = (String)defaultCategories.get(i);
            catBox.addItem(defaultCategory);
            if (i != 0) continue;
            catBox.setSelectedItem(defaultCategory);
        }
        for (i = 0; i < subdirs.size(); ++i) {
            File subDir = subdirs.get(i);
            String fullPath = subDir.toString();
            String dirName = fullPath.substring(topDir.length() + 1);
            String thisCategory = IdvPersistenceManager.categoriesToString(StringUtil.split(dirName, File.separator, true, true));
            if (defaultCategories.contains(thisCategory)) continue;
            catBox.addItem(thisCategory);
        }
    }

    public void moveCategory(List fromCategories, List toCategories, int bundleType) {
        File fromFile = new File(IOUtil.joinDir(this.getBundleDirectory(bundleType), StringUtil.join(File.separator + "", fromCategories)));
        String tail = IOUtil.getFileTail(fromFile.toString());
        toCategories.add(tail);
        File toFile = new File(IOUtil.joinDir(this.getBundleDirectory(bundleType), StringUtil.join(File.separator + "", toCategories)));
        if (toFile.exists()) {
            LogUtil.userMessage("The destination category already contains a category with name: " + tail);
            return;
        }
        if (!fromFile.renameTo(toFile)) {
            LogUtil.userMessage("There was some problem moving the given bundle category");
        }
        this.flushState(bundleType);
    }

    public void export(SavedBundle bundle, int bundleType) {
        String filename = FileManager.getWriteFile(this.getArgsManager().getXidvFileFilter(), null);
        if (filename == null) {
            return;
        }
        try {
            IOUtil.copyFile(new File(bundle.getUrl()), new File(filename));
        }
        catch (Exception exc) {
            IdvPersistenceManager.logException("Exporting a bundle", exc);
        }
    }

    public void rename(SavedBundle bundle, int bundleType) {
        File newFile;
        String ext = IOUtil.getFileExtension(bundle.getUrl());
        String filename = IOUtil.stripExtension(IOUtil.getFileTail(bundle.getUrl()));
        while (true) {
            if ((filename = GuiUtils.getInput("Enter a new name", "Name: ", filename)) == null) {
                return;
            }
            if ((filename = IOUtil.cleanFileName(filename).trim()).length() == 0) {
                return;
            }
            newFile = new File(IOUtil.joinDir(IOUtil.getFileRoot(bundle.getUrl()), filename + ext));
            if (!newFile.exists()) break;
            LogUtil.userMessage("A file with the name: " + filename + " already exists");
        }
        File oldFile = new File(bundle.getUrl());
        oldFile.renameTo(newFile);
        this.flushState(bundleType);
    }

    public void copyBundle(SavedBundle bundle, List categories, int bundleType) {
        this.moveOrCopyBundle(bundle, categories, bundleType, false);
    }

    public void moveBundle(SavedBundle bundle, List categories, int bundleType) {
        this.moveOrCopyBundle(bundle, categories, bundleType, true);
    }

    public void moveOrCopyBundle(SavedBundle bundle, List categories, int bundleType, boolean move) {
        File fromFile = new File(bundle.getUrl());
        String tail = IOUtil.getFileTail(bundle.getUrl());
        categories.add(tail);
        File toFile = new File(IOUtil.joinDir(this.getBundleDirectory(bundleType), StringUtil.join(File.separator + "", categories)));
        if (toFile.exists()) {
            LogUtil.userMessage("The destination category already contains a bundle with name: " + tail);
            return;
        }
        if (move) {
            fromFile.renameTo(toFile);
        } else {
            try {
                IOUtil.moveFile(fromFile, toFile);
            }
            catch (Exception exc) {
                IdvPersistenceManager.logException("Moving a bundle", exc);
            }
        }
        this.flushState(bundleType);
    }

    public JComboBox makeCategoryBox() {
        JComboBox catBox = new JComboBox();
        catBox.setToolTipText("<html>Categories can be entered manually. <br>Use '>' as the category delimiter. e.g.:<br>General > Subcategory</html>");
        catBox.setEditable(true);
        return catBox;
    }

    private String getCategorizedFile(String title, String filename, List<SavedBundle> bundles, String topDir, List defaultCategories, String suffix, boolean showSubsetPanel) {
        File fullFile;
        if (filename == null) {
            filename = "";
        }
        final JComboBox catBox = this.makeCategoryBox();
        JCheckBox zidvCbx = new JCheckBox("Save as zipped data bundle", false);
        zidvCbx.setToolTipText("Select this to save the data along with the bundle");
        JComponent zidvComp = suffix == null ? zidvCbx : new JPanel();
        this.addBundleCategories(catBox, defaultCategories, topDir);
        this.catSelected = false;
        catBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdvPersistenceManager.this.catSelected = true;
            }
        });
        final JComboBox fileBox = new JComboBox();
        fileBox.setEditable(true);
        fileBox.setPreferredSize(new Dimension(150, 20));
        ArrayList<Object> tails = new ArrayList<Object>();
        if (bundles != null) {
            for (int i = 0; i < bundles.size(); ++i) {
                SavedBundle bundle = bundles.get(i);
                if (!new File(bundle.getUrl()).canWrite()) continue;
                String tail = IOUtil.stripExtension(IOUtil.getFileTail(bundle.getUrl()));
                tails.add(new TwoFacedObject((Object)tail, bundle));
            }
            Collections.sort(tails);
        }
        tails.add(0, filename);
        GuiUtils.setListData(fileBox, tails);
        fileBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object selected = fileBox.getSelectedItem();
                if (!(selected instanceof TwoFacedObject)) {
                    return;
                }
                TwoFacedObject tfo = (TwoFacedObject)selected;
                List cats = ((SavedBundle)tfo.getId()).getCategories();
                if (cats.size() > 0 && !IdvPersistenceManager.this.catSelected) {
                    catBox.setSelectedItem(StringUtil.join(IdvPersistenceManager.CATEGORY_SEPARATOR, cats));
                }
            }
        });
        GuiUtils.tmpInsets = new Insets(0, 3, 0, 3);
        JPanel catPanel = GuiUtils.left(catBox);
        GuiUtils.tmpInsets = new Insets(3, 3, 3, 3);
        JPanel panel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Category: "), catPanel, GuiUtils.rLabel("Name: "), fileBox}, 4, GuiUtils.WT_NY, GuiUtils.WT_N);
        if (showSubsetPanel) {
            JPanel extra = this.getFileAccessory();
            zidvComp = GuiUtils.inset((Component)zidvComp, new Insets(0, 0, 0, 0));
            panel = GuiUtils.vbox((Component)panel, GuiUtils.vbox((Component)extra, zidvComp));
        } else {
            panel = GuiUtils.vbox((Component)panel, zidvComp);
        }
        while (true) {
            if (!GuiUtils.askOkCancel(title, panel)) {
                return null;
            }
            filename = fileBox.getSelectedItem().toString().trim();
            if ((filename = IOUtil.cleanFileName(filename)).length() == 0) {
                LogUtil.userMessage("Please enter a name");
                continue;
            }
            String defaultCategory = catBox.getSelectedItem().toString().trim();
            if ((defaultCategory = IOUtil.cleanFileName(defaultCategory)).length() == 0) {
                LogUtil.userMessage("Please enter a category");
                continue;
            }
            String category = StringUtil.join(File.separator, IdvPersistenceManager.stringToCategories(defaultCategory));
            File catDir = new File(IOUtil.joinDir(topDir, category));
            if (!catDir.exists()) {
                catDir.mkdirs();
            }
            String tmpSuffix = suffix;
            if (suffix == null) {
                tmpSuffix = zidvCbx.isSelected() ? this.getArgsManager().getZidvFileFilter().getPreferredSuffix() : this.getArgsManager().getXidvFileFilter().getPreferredSuffix();
            }
            if (!(fullFile = new File(IOUtil.joinDir(catDir.toString(), filename + tmpSuffix))).exists()) break;
            int result = GuiUtils.showYesNoCancelDialog(null, "The file: " + filename + " already exists. Do you want to overwite it? ", "File exists");
            if (result == 2) {
                return null;
            }
            if (result != 1) break;
        }
        return fullFile.toString();
    }

    public void doImport(int bundleType, String file, String category) {
        String path = StringUtil.join(File.separator, IdvPersistenceManager.stringToCategories(category));
        String dir = IOUtil.joinDir(this.getBundleDirectory(bundleType), path);
        String filename = IOUtil.getFileTail(file);
        IOUtil.makeDir(dir);
        File dest = new File(IOUtil.joinDir(dir, filename));
        if (dest.exists() && JOptionPane.showConfirmDialog(null, "File:" + filename + " exists. Do you want to overwrite?", "File exists", 0) == 1) {
            return;
        }
        try {
            IOUtil.copyFile(new File(file), dest);
        }
        catch (Throwable e) {
            IdvPersistenceManager.logException("Importing bundle", e);
        }
        this.flushState(bundleType);
    }

    private List getCategories(int bundleType, List cats) {
        List<SavedBundle> favs = this.getBundles(bundleType);
        for (int i = 0; i < favs.size(); ++i) {
            SavedBundle bundle = favs.get(i);
            String bundleCat = IdvPersistenceManager.categoriesToString(bundle.getCategories());
            if (cats.contains(bundleCat)) continue;
            cats.add(bundleCat);
        }
        return cats;
    }

    public List getFavoritesCategories() {
        return this.getCategories(0, Misc.newList(CAT_GENERAL, CAT_TOOLBAR));
    }

    public void doSaveAsFavorite() {
        List cats = this.getFavoritesCategories();
        String fullFile = this.getCategorizedFile("Save As Favorite", "", this.getLocalBundles(), this.getStore().getLocalBundlesDir(), cats, null, true);
        if (fullFile == null) {
            return;
        }
        this.doSave(fullFile);
        this.getIdvUIManager().displayTemplatesChanged();
        QuicklinkPanel.updateQuicklinks();
    }

    public void doSave() {
        String filename = this.getCurrentFileName();
        this.doSave(filename);
        this.getIdv().addToHistoryList(filename);
    }

    public void doSaveAsDefault() {
        this.doSave(this.getResourceManager().getResources(IdvResourceManager.RSC_BUNDLES).getWritable(), false);
    }

    public void doOpenDefault() {
        String fileName = this.getResourceManager().getResources(IdvResourceManager.RSC_BUNDLES).getWritable();
        File file = new File(fileName);
        if (!file.exists()) {
            LogUtil.userMessage("The default bundle: " + fileName + " does not exist.");
            return;
        }
        this.decodeXmlFile(fileName, true);
    }

    public boolean doSave(String filename) {
        return this.doSave(filename, true);
    }

    public String getJnlpBundle(String xml) {
        return this.getJnlpBundle(xml, true, null);
    }

    public String getJnlpBundle(String xml, boolean embedBundle, String extraArgs) {
        String templateFile = this.getProperty("idv.jnlp.template", "no template");
        String template = IOUtil.readContents(templateFile, this.getClass(), NULL_STRING);
        String codeBase = this.getProperty("idv.jnlp.codebase", NULL_STRING);
        String title = this.getProperty("idv.jnlp.title", "");
        if (template == null) {
            LogUtil.userErrorMessage(log_, "Failed to read jnlp template file: " + templateFile);
            return null;
        }
        if (codeBase == null) {
            LogUtil.userErrorMessage(log_, "Failed to read jnlp codebase");
            return null;
        }
        StringBuffer args = new StringBuffer("");
        for (int i = 0; i < this.getArgsManager().persistentCommandLineArgs.size(); ++i) {
            args.append("<argument>" + this.getArgsManager().persistentCommandLineArgs.get(i) + "</argument>\n");
        }
        String jnlp = template;
        if (embedBundle) {
            String b64Xml = new String(XmlUtil.encodeBase64(xml.getBytes()));
            args.append("<argument>-b64bundle</argument>\n");
            args.append("<argument>");
            args.append(b64Xml);
            args.append("</argument>\n");
        }
        if (extraArgs != null) {
            args.append(extraArgs);
        }
        jnlp = StringUtil.replace(jnlp, "%CODEBASE%", codeBase);
        jnlp = StringUtil.replace(jnlp, "%TITLE%", title);
        jnlp = StringUtil.replace(jnlp, "%ARGS%", args.toString());
        jnlp = StringUtil.replace(jnlp, "%IDVCLASS%", this.getIdv().getClass().getName());
        jnlp = StringUtil.replace(jnlp, "%DESCRIPTION%", "");
        return jnlp;
    }

    public boolean doSave(String filename, boolean usePersistenceManager) {
        return this.doSave(filename, true, false);
    }

    public boolean doSave(String filename, boolean usePersistenceManager, boolean fromIsl) {
        try {
            boolean doJnlp = filename.endsWith(".jnlp") || filename.endsWith(".sh") || filename.endsWith(".bat");
            boolean doIsl = this.getArgsManager().isIslFile(filename);
            boolean doZidv = this.getArgsManager().isZidvFile(filename);
            List zidvFiles = null;
            if (doZidv && (zidvFiles = fromIsl ? this.showDataEmbedNoGui(this.getDataSourcesToPersist()) : this.showDataEmbedGui(this.getDataSourcesToPersist())) == null) {
                return false;
            }
            String xml = this.getBundleXml(!doJnlp, usePersistenceManager);
            if (xml == null) {
                this.clearDataSourcesState();
                return false;
            }
            if (doJnlp) {
                JPanel bundlePanel;
                String shellFile = null;
                if (filename.endsWith(".sh") || filename.endsWith(".bat")) {
                    shellFile = filename;
                    filename = IOUtil.stripExtension(filename) + ".jnlp";
                }
                if (this.includeBundleCbx == null) {
                    this.includeBundleCbx = new JCheckBox("Include Bundle in JNLP File", true);
                    this.includeBundleCbx.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            GuiUtils.enableTree(IdvPersistenceManager.this.bundleUrlComp, !IdvPersistenceManager.this.includeBundleCbx.isSelected());
                        }
                    });
                    this.bundlePrefixFld = new JTextField("", 40);
                    this.bundleUrlComp = GuiUtils.vbox(new JLabel("Web URL directory where bundle will be: "), GuiUtils.leftCenter(new JLabel("       "), this.bundlePrefixFld));
                    GuiUtils.enableTree(this.bundleUrlComp, false);
                }
                if (!GuiUtils.askOkCancel("Saving JNLP File", bundlePanel = GuiUtils.vbox(this.includeBundleCbx, new JLabel(" "), this.bundleUrlComp))) {
                    return false;
                }
                boolean embedBundle = this.includeBundleCbx.isSelected();
                String bundleXml = xml;
                String bundleArg = null;
                String bundleFile = IOUtil.stripExtension(filename) + this.getArgsManager().getXidvFileFilter().getPreferredSuffix();
                if (!embedBundle) {
                    String bundlePath = this.bundlePrefixFld.getText().trim();
                    if (bundlePath.length() > 0 && !bundlePath.endsWith("/")) {
                        bundlePath = bundlePath + "/";
                    }
                    bundlePath = bundlePath + IOUtil.getFileTail(bundleFile);
                    bundleArg = "<argument>" + bundlePath + "</argument>";
                }
                xml = this.getJnlpBundle(xml, embedBundle, !embedBundle ? bundleArg : null);
                if (!embedBundle) {
                    IOUtil.writeFile(bundleFile, bundleXml);
                }
                if (xml == null) {
                    return false;
                }
                if (shellFile != null) {
                    String shContent;
                    if (shellFile.endsWith(".sh")) {
                        shContent = "runidv.sh " + IOUtil.getFileTail(filename);
                        IOUtil.writeFile(shellFile, shContent);
                    } else if (filename.endsWith(".bat")) {
                        shContent = "runidv.bat " + IOUtil.getFileTail(filename);
                        IOUtil.writeFile(shellFile, shContent);
                    }
                }
            }
            if (doZidv) {
                GuiUtils.ProgressDialog dialog = new GuiUtils.ProgressDialog("Creating Zipped Bundle", true);
                dialog.setText("Writing " + filename);
                String tail = IOUtil.stripExtension(IOUtil.getFileTail(filename));
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(filename));
                String fileSuffix = this.getArgsManager().getXidvFileFilter().getPreferredSuffix();
                zos.putNextEntry(new ZipEntry(tail + fileSuffix));
                byte[] bytes = xml.getBytes();
                zos.write(bytes, 0, bytes.length);
                zos.closeEntry();
                for (int i = 0; i < zidvFiles.size(); ++i) {
                    String file = (String)zidvFiles.get(i);
                    ZipEntry zipEntry = new ZipEntry(IOUtil.getFileTail(file));
                    dialog.setText("Writing " + zipEntry.getName());
                    zos.putNextEntry(zipEntry);
                    IOUtil.writeTo(IOUtil.getInputStream(file, this.getClass()), zos);
                    zos.closeEntry();
                    if (!dialog.isCancelled()) continue;
                    dialog.dispose();
                    zos.close();
                    return false;
                }
                dialog.dispose();
                zos.close();
                return true;
            }
            if (doIsl) {
                if (this.islDialog == null) {
                    this.islDialog = new IslDialog(this);
                }
                this.islDialog.writeIsl(filename, xml);
            } else {
                IOUtil.writeFile(filename, xml);
            }
        }
        catch (Throwable e) {
            IdvPersistenceManager.logException("doSave", e);
            return false;
        }
        return true;
    }

    public String getBundleXml(boolean formatXml) throws Exception {
        return this.getBundleXml(formatXml, true);
    }

    private void clearDataSourcesState() {
        this.clearDataSourcesState(this.getDataSourcesToPersist());
    }

    private void clearDataSourcesState(List dataSources) {
        for (int dataSourceIdx = 0; dataSourceIdx < dataSources.size(); ++dataSourceIdx) {
            DataSource dataSource = (DataSource)dataSources.get(dataSourceIdx);
            dataSource.resetTmpState();
        }
    }

    public String getBundleXml(boolean formatXml, boolean usePersistenceManager) throws Exception {
        XmlEncoder encoder = this.getIdv().getEncoderForWrite();
        Hashtable data = new Hashtable();
        if (!this.addToBundle(data, usePersistenceManager, this.getIdv().getDisplayControls())) {
            this.clearDataSourcesState();
            return null;
        }
        String xml = encoder.toXml(data, formatXml);
        this.clearDataSourcesState();
        return xml;
    }

    public DisplayControl instantiateFromTemplate(String templateFile) {
        try {
            String xml = IOUtil.readContents(templateFile);
            return (DisplayControl)this.getIdv().getEncoderForRead().toObject(xml);
        }
        catch (Throwable exc) {
            IdvPersistenceManager.logException("Unable to load template:" + templateFile, exc);
            return null;
        }
    }

    public List getAllCategories(int bundleType) {
        String bundleDir = this.getBundleDirectory(bundleType);
        List<File> directories = IOUtil.getDirectories(new File(bundleDir), true);
        ArrayList<String> allCategories = new ArrayList<String>();
        for (int i = 0; i < directories.size(); ++i) {
            allCategories.add(IdvPersistenceManager.categoriesToString(IdvPersistenceManager.fileToCategories(bundleDir, directories.get(i).toString())));
        }
        return allCategories;
    }

    public String getBundleTitle(int bundleType) {
        if (bundleType == 0) {
            return "Favorite Bundles";
        }
        if (bundleType == 1) {
            return "Display Templates";
        }
        if (bundleType == 2) {
            return "Favorite Data Sources";
        }
        throw new IllegalArgumentException("Unknown bundle type:" + bundleType);
    }

    public String getBundleDirectory(int bundleType) {
        if (bundleType == 0) {
            return this.getStore().getLocalBundlesDir();
        }
        if (bundleType == 1) {
            return this.getStore().getDisplayTemplateDir();
        }
        if (bundleType == 2) {
            return this.getStore().getDataSourcesDir();
        }
        throw new IllegalArgumentException("Unknown bundle type:" + bundleType);
    }

    public List<SavedBundle> getBundles(int bundleType) {
        if (bundleType == 0) {
            return this.getFavorites();
        }
        if (bundleType == 1) {
            return this.getDisplayTemplates();
        }
        if (bundleType == 2) {
            return this.getDataSourceBundles();
        }
        throw new IllegalArgumentException("Unknown bundle type:" + bundleType);
    }

    public void initBundleMenu(int bundleType, JMenu bundleMenu) {
        if (bundleType == 0) {
            JMenuItem mi = new JMenuItem("Save As Favorite...");
            mi.setMnemonic(GuiUtils.charToKeyCode("S"));
            GuiUtils.setIcon(mi, "/auxdata/ui/icons/disk_multiple.png");
            bundleMenu.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    IdvPersistenceManager.this.doSaveAsFavorite();
                }
            });
        }
    }

    public List getWritableBundles(int bundleType) {
        List<SavedBundle> allBundles = this.getBundles(bundleType);
        ArrayList<SavedBundle> bundles = new ArrayList<SavedBundle>();
        for (int i = 0; i < allBundles.size(); ++i) {
            SavedBundle bundle = allBundles.get(i);
            if (!new File(bundle.getUrl()).canWrite()) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    public void saveDataSource(DataSource dataSource) {
        List cats = this.getCategories(2, Misc.newList(CAT_GENERAL));
        String fullFile = this.getCategorizedFile("Save Data Source", dataSource.toString(), this.getBundles(2), this.getBundleDirectory(2), cats, ".xidv", false);
        if (fullFile == null) {
            return;
        }
        String xml = this.encodeSpecial(dataSource);
        try {
            IOUtil.writeFile(fullFile, xml);
            this.dataSourceBundles = null;
            QuicklinkPanel.updateQuicklinks();
        }
        catch (Exception exc) {
            IdvPersistenceManager.logException("Saving data source bundle", exc);
        }
    }

    public void saveDisplayControlFavorite(DisplayControl displayControl, String templateName) {
        List cats = this.getCategories(1, Misc.newList(CAT_GENERAL));
        String fullFile = this.getCategorizedFile("Save Display Template", templateName, this.getBundles(1), this.getBundleDirectory(1), cats, ".xidv", false);
        if (fullFile == null) {
            return;
        }
        this.saveDisplayControl(displayControl, new File(fullFile));
    }

    public void saveDisplayControl(DisplayControl displayControl) {
        String filename = FileManager.getWriteFile(this.getArgsManager().getXidvFileFilter(), null);
        if (filename == null) {
            return;
        }
        this.saveDisplayControl(displayControl, new File(filename));
    }

    private String encodeSpecial(Object object) {
        try {
            XmlEncoder encoder = this.getIdv().getEncoderForWrite();
            boolean tmpSaveViewState = this.getSaveViewState();
            boolean tmpSaveDataSources = this.getSaveDataSources();
            boolean tmpSaveJython = this.getSaveJython();
            boolean tmpSaveData = this.getSaveData();
            this.saveViewState = false;
            this.saveDataSources = false;
            this.saveJython = false;
            this.saveData = false;
            String xml = encoder.toXml(object);
            this.saveViewState = tmpSaveViewState;
            this.saveDataSources = tmpSaveDataSources;
            this.saveJython = tmpSaveJython;
            this.saveData = tmpSaveData;
            return xml;
        }
        catch (Exception exc) {
            IdvPersistenceManager.logException("Saving display template", exc);
            return null;
        }
    }

    public void saveDisplayControl(DisplayControl displayControl, File file) {
        try {
            String name = file.getName();
            this.currentTemplateName = IOUtil.stripExtension(name);
            String xml = this.encodeSpecial(displayControl);
            IOUtil.writeFile(file, xml);
            this.currentTemplateName = name;
            this.flushState(1);
        }
        catch (Exception exc) {
            IdvPersistenceManager.logException("Saving display template", exc);
        }
    }

    public List<SavedBundle> getLocalBundles() {
        ArrayList<SavedBundle> allBundles = new ArrayList<SavedBundle>();
        List bundleDirs = Misc.newList(this.getStore().getLocalBundlesDir());
        String sitePath = this.getResourceManager().getSitePath();
        if (sitePath != null) {
            bundleDirs.add(IOUtil.joinDir(sitePath, "bundles"));
        }
        for (int i = 0; i < bundleDirs.size(); ++i) {
            String topDir = (String)bundleDirs.get(i);
            List<File> subdirs = IOUtil.getDirectories(Misc.newList(topDir), true);
            for (int subDirIdx = 0; subDirIdx < subdirs.size(); ++subDirIdx) {
                File subdir = subdirs.get(subDirIdx);
                this.loadBundlesInDirectory(allBundles, IdvPersistenceManager.fileToCategories(topDir, subdir.getPath()), subdir);
            }
        }
        return allBundles;
    }

    public List<SavedBundle> getDataSourceBundles() {
        if (this.dataSourceBundles == null) {
            this.dataSourceBundles = new ArrayList<SavedBundle>();
            String topDir = this.getBundleDirectory(2);
            List<File> dirs = IOUtil.getDirectories(new File(topDir), true);
            for (int dirIdx = 0; dirIdx < dirs.size(); ++dirIdx) {
                File file = dirs.get(dirIdx);
                String[] templateFiles = file.list(this.getArgsManager().getXidvFileFilter());
                for (int i = 0; i < templateFiles.length; ++i) {
                    String filename = IOUtil.joinDir(file.toString(), templateFiles[i]);
                    List<String> categories = IdvPersistenceManager.fileToCategories(topDir, file.toString());
                    String name = IOUtil.stripExtension(templateFiles[i]);
                    this.dataSourceBundles.add(new SavedBundle(filename, name, categories, null, true, 2));
                }
            }
            this.dataSourceBundles.addAll(this.getXmlBundles(2));
        }
        return this.dataSourceBundles;
    }

    public List<SavedBundle> getDisplayTemplates() {
        if (this.displayTemplates == null) {
            this.displayTemplates = new ArrayList<SavedBundle>();
            String topDir = this.getBundleDirectory(1);
            List<File> dirs = IOUtil.getDirectories(new File(topDir), true);
            for (int dirIdx = 0; dirIdx < dirs.size(); ++dirIdx) {
                File file = dirs.get(dirIdx);
                String[] templateFiles = file.list(this.getArgsManager().getXidvFileFilter());
                for (int i = 0; i < templateFiles.length; ++i) {
                    String filename = IOUtil.joinDir(file.toString(), templateFiles[i]);
                    DisplayControl dc = this.instantiateFromTemplate(filename);
                    if (dc == null) continue;
                    List<String> categories = IdvPersistenceManager.fileToCategories(topDir, file.toString());
                    String name = IOUtil.stripExtension(templateFiles[i]);
                    this.displayTemplates.add(new SavedBundle(filename, name, categories, dc, true, 1));
                }
            }
            this.displayTemplates.addAll(this.getXmlBundles(1));
        }
        return this.displayTemplates;
    }

    public boolean open(SavedBundle bundle) {
        return this.open(bundle, true);
    }

    public boolean open(SavedBundle bundle, boolean askToRemove) {
        return this.decodeXmlFile(bundle.getUrl(), bundle.getName(), askToRemove);
    }

    private void flushState(int type) {
        if (type == 1 || type == -1) {
            this.displayTemplates = null;
            this.getIdvUIManager().displayTemplatesChanged();
        }
        if (type == 2 || type == -1) {
            this.dataSourceBundles = null;
        }
        if (type == 0 || type == -1) {
            this.getIdvUIManager().favoriteBundlesChanged();
        }
        QuicklinkPanel.updateQuicklinks();
    }

    public void deleteBundle(String templateFile) {
        File file = new File(templateFile);
        file.delete();
        this.flushState(-1);
    }

    public void deleteBundleCategory(int bundleType, String category) {
        String path = StringUtil.join(File.separator, IdvPersistenceManager.stringToCategories(category));
        path = IOUtil.joinDir(this.getBundleDirectory(bundleType), path);
        IOUtil.deleteDirectory(new File(path));
        this.flushState(bundleType);
    }

    public boolean addBundleCategory(int bundleType, String category) {
        String path = StringUtil.join(File.separator, IdvPersistenceManager.stringToCategories(category));
        File f = new File(IOUtil.joinDir(this.getBundleDirectory(bundleType), path));
        if (f.exists()) {
            return false;
        }
        IOUtil.makeDir(f);
        return true;
    }

    protected List getDataSourcesToPersist() {
        ArrayList sources = new ArrayList();
        List currentSources = this.getIdv().getDataSources();
        for (int i = 0; i < currentSources.size(); ++i) {
            Object source = currentSources.get(i);
            if (DataManager.isFormulaDataSource(source)) continue;
            sources.add(source);
        }
        return sources;
    }

    protected boolean addToBundle(Hashtable data, boolean usePersistenceManager, List displayControls) throws Exception {
        return this.addToBundle(data, !usePersistenceManager || this.getSaveDataSources() ? this.getDataSourcesToPersist() : null, !usePersistenceManager || this.getSaveDisplays() ? displayControls : null, !usePersistenceManager || this.getSaveViewState() ? this.getVMManager().getViewManagers() : null, usePersistenceManager && this.getSaveJython() ? this.getJythonManager().getUsersJythonText() : null);
    }

    private boolean showDataRelativeGui(List dataSources) {
        JCheckBox cbx;
        ArrayList<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
        ArrayList fields = new ArrayList();
        ArrayList<DataSource> workingSet = new ArrayList<DataSource>();
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        for (int i = 0; i < dataSources.size(); ++i) {
            JComponent fileFldComp;
            DataSource dataSource = (DataSource)dataSources.get(i);
            List files = dataSource.getDataPaths();
            if (files == null || files.size() == 0 || !new File(files.get(0).toString()).exists()) continue;
            workingSet.add(dataSource);
            cbx = new JCheckBox(DataSelector.getNameForDataSource(dataSource));
            checkBoxes.add(cbx);
            comps.add(cbx);
            ArrayList<JTextField> fileFields = new ArrayList<JTextField>();
            fields.add(fileFields);
            for (int fileIdx = 0; fileIdx < files.size(); ++fileIdx) {
                String file = files.get(fileIdx).toString();
                String bpath = (String)this.getIdv().getStateManager().getProperty(PROP_BUNDLEPATH);
                String bdir = IOUtil.getFileRoot(this.currentFileName);
                file = file.contains(bdir) ? "%idv.bundlepath%" + file.replace(bdir, "") : "%idv.bundlepath%/" + IOUtil.getFileTail(file);
                JTextField fld = new JTextField(file);
                fileFields.add(fld);
            }
            if (fileFields.size() < 3) {
                fileFldComp = GuiUtils.vbox(fileFields);
            } else {
                fileFldComp = GuiUtils.makeScrollPane(GuiUtils.vbox(fileFields), 200, 100);
                fileFldComp.setPreferredSize(new Dimension(200, 100));
            }
            JLabel label = new JLabel(files.size() == 1 ? "File:  " : "Files:  ");
            comps.add(GuiUtils.leftCenter(GuiUtils.top(label), fileFldComp));
        }
        if (checkBoxes.size() == 0) {
            return true;
        }
        JLabel label = GuiUtils.cLabel("Select the data sources that should be saved with relative paths");
        JPanel panel = GuiUtils.vbox((Component)GuiUtils.inset((Component)label, 5), GuiUtils.vbox(comps));
        if (!GuiUtils.askOkCancel("Make Data Sources Relative", panel)) {
            return false;
        }
        for (int i = 0; i < workingSet.size(); ++i) {
            cbx = (JCheckBox)checkBoxes.get(i);
            if (!cbx.isSelected()) continue;
            DataSource dataSource = (DataSource)workingSet.get(i);
            List fileFields = (List)fields.get(i);
            ArrayList<String> relativeFiles = new ArrayList<String>();
            for (int fileIdx = 0; fileIdx < fileFields.size(); ++fileIdx) {
                String file = ((JTextField)fileFields.get(fileIdx)).getText().trim();
                if (file.length() <= 0) continue;
                relativeFiles.add(file);
            }
            dataSource.setTmpPaths(relativeFiles);
        }
        return true;
    }

    private List showDataEmbedGui(List dataSources) throws IOException {
        JPanel panel;
        ArrayList<DataSourceComponent> fileDataSources = new ArrayList<DataSourceComponent>();
        ArrayList<DataSourceComponent> copyDataSources = new ArrayList<DataSourceComponent>();
        ArrayList<Component> fileComps = new ArrayList<Component>();
        ArrayList<Component> copyComps = new ArrayList<Component>();
        ArrayList<JLabel> notSavedLabels = new ArrayList<JLabel>();
        JRadioButton defaultRB = new JRadioButton("Save All Displayed Data", true);
        final JRadioButton selectRB = new JRadioButton("Save Selected Data");
        Vector<Integer> tCnt2 = new Vector<Integer>();
        for (int i = 1; i <= 25; ++i) {
            tCnt2.add(new Integer(i));
        }
        JComboBox timeStrideFld = new JComboBox(tCnt2);
        ButtonGroup dataBG = new ButtonGroup();
        dataBG.add(defaultRB);
        dataBG.add(selectRB);
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource dataSource = (DataSource)dataSources.get(i);
            List files = dataSource.getDataPaths();
            DataSourceComponent dsc = new DataSourceComponent(dataSource);
            defaultRB.addActionListener(new DeselectAL(dsc.cbx));
            dsc.cbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox cbx = (JCheckBox)e.getSource();
                    if (cbx.isSelected()) {
                        selectRB.setSelected(true);
                    }
                }
            });
            String dataSourceName = DataSelector.getNameForDataSource(dataSource);
            if (dataSource.canSaveDataToLocalDisk()) {
                copyDataSources.add(dsc);
                dsc.cbx.setText(dataSourceName);
                copyComps.add(dsc.cbx);
                continue;
            }
            if (files == null || files.size() == 0) {
                notSavedLabels.add(new JLabel(dataSourceName));
                continue;
            }
            Object sampleFile = files.get(0);
            if (sampleFile.getClass().isArray()) {
                sampleFile = ((Object[])sampleFile)[0];
            }
            if (!new File(sampleFile.toString()).exists()) {
                notSavedLabels.add(new JLabel(dataSourceName));
                continue;
            }
            fileDataSources.add(dsc);
            dsc.cbx.setText(dataSourceName);
            fileComps.add(dsc.cbx);
            long size = 0L;
            for (int fileIdx = 0; fileIdx < files.size(); ++fileIdx) {
                String file = files.get(fileIdx).toString();
                File f = new File(file);
                size += f.length();
            }
            fileComps.add(GuiUtils.filler());
            String sizeStr = size / 1000L + " K bytes";
            fileComps.add(new JLabel(files.size() + (files.size() == 1 ? " File " : " Files ") + sizeStr));
            fileComps.add(new JLabel(" "));
            fileComps.add(new JLabel(" "));
        }
        if (notSavedLabels.size() == 0 && fileDataSources.size() == 0 && copyDataSources.size() == 0) {
            return new ArrayList();
        }
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        if (!fileComps.isEmpty()) {
            copyComps.add(new JSeparator(0));
        }
        copyComps.addAll(fileComps);
        if (copyComps.size() > 0) {
            comps.add(selectRB);
            JPanel vcc = GuiUtils.inset((Component)GuiUtils.vbox(copyComps), 10, 5);
            if (copyComps.size() > 5) {
                JScrollPane sp = GuiUtils.makeScrollPane(GuiUtils.top(vcc), 400, 400);
                sp.setPreferredSize(new Dimension(400, 400));
                comps.add(sp);
            } else {
                comps.add(vcc);
            }
        }
        if (notSavedLabels.size() > 0) {
            if (copyComps.size() == 0 && fileDataSources.size() == 0) {
                comps.add(new JLabel("No data will be included in the bundle"));
            }
            notSavedLabels.add(0, new JLabel("Other data sources:"));
            notSavedLabels.add(0, new JLabel(" "));
            comps.add(GuiUtils.vbox(notSavedLabels));
        }
        if (!GuiUtils.askOkCancel("Save Data", panel = LayoutUtil.topCenterBottom(defaultRB, GuiUtils.hbox(new JLabel("Time Stride for Gridded Data: "), timeStrideFld), GuiUtils.vbox(comps)))) {
            return null;
        }
        File dir = this.getIdv().getObjectStore().getUniqueTmpDirectory();
        for (int i = 0; i < copyDataSources.size(); ++i) {
            List files;
            DataSourceComponent dsc = (DataSourceComponent)copyDataSources.get(i);
            dsc.dataSource.setDefaultSave(defaultRB.isSelected());
            if (!dsc.cbx.isSelected() && !defaultRB.isSelected()) continue;
            if (dsc.dataSource instanceof GeoGridDataSource && timeStrideFld.getSelectedItem() != null) {
                ((GeoGridDataSource)dsc.dataSource).getProperties().put("timestride", timeStrideFld.getSelectedItem());
            }
            if ((files = dsc.dataSource.saveDataToLocalDisk(false, IOUtil.joinDir(dir, "data_" + i))) == null) continue;
            dsc.files = files;
            fileDataSources.add(dsc);
        }
        ArrayList<String> filesToEmbed = new ArrayList<String>();
        for (int i = 0; i < fileDataSources.size(); ++i) {
            DataSourceComponent dsc = (DataSourceComponent)fileDataSources.get(i);
            if (!dsc.cbx.isSelected() && !defaultRB.isSelected()) continue;
            DataSource dataSource = dsc.dataSource;
            List files = dsc.files != null ? dsc.files : dataSource.getDataPaths();
            ArrayList<String> relativeFiles = new ArrayList<String>();
            for (int fileIdx = 0; fileIdx < files.size(); ++fileIdx) {
                Object o = files.get(fileIdx);
                String file = null;
                String newFile = null;
                if (o.getClass().isArray()) {
                    file = ((Object[])o)[0].toString();
                    newFile = ((Object[])o)[1].toString();
                } else {
                    newFile = file = (String)o;
                }
                filesToEmbed.add(file);
                file = "%idv.zidvpath%/" + IOUtil.getFileTail(newFile);
                relativeFiles.add(file);
            }
            dataSource.setTmpPaths(relativeFiles);
        }
        return filesToEmbed;
    }

    private List showDataEmbedNoGui(List dataSources) throws IOException {
        DataSourceComponent dsc;
        ArrayList<DataSourceComponent> fileDataSources = new ArrayList<DataSourceComponent>();
        ArrayList<DataSourceComponent> copyDataSources = new ArrayList<DataSourceComponent>();
        ArrayList fileComps = new ArrayList();
        ArrayList notSavedLabels = new ArrayList();
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource dataSource = (DataSource)dataSources.get(i);
            List files = dataSource.getDataPaths();
            dsc = new DataSourceComponent(dataSource);
            String dataSourceName = DataSelector.getNameForDataSource(dataSource);
            if (!dataSource.canSaveDataToLocalDisk()) continue;
            copyDataSources.add(dsc);
        }
        if (notSavedLabels.size() == 0 && fileDataSources.size() == 0 && copyDataSources.size() == 0) {
            return new ArrayList();
        }
        File dir = this.getIdv().getObjectStore().getUniqueTmpDirectory();
        for (int i = 0; i < copyDataSources.size(); ++i) {
            DataSourceComponent dsc2 = (DataSourceComponent)copyDataSources.get(i);
            dsc2.dataSource.setDefaultSave(true);
            List files = dsc2.dataSource.saveDataToLocalDisk(false, IOUtil.joinDir(dir, "data_" + i));
            if (files == null) continue;
            dsc2.files = files;
            fileDataSources.add(dsc2);
        }
        ArrayList<String> filesToEmbed = new ArrayList<String>();
        for (int i = 0; i < fileDataSources.size(); ++i) {
            dsc = (DataSourceComponent)fileDataSources.get(i);
            DataSource dataSource = dsc.dataSource;
            List files = dsc.files != null ? dsc.files : dataSource.getDataPaths();
            ArrayList<String> relativeFiles = new ArrayList<String>();
            for (int fileIdx = 0; fileIdx < files.size(); ++fileIdx) {
                Object o = files.get(fileIdx);
                String file = null;
                String newFile = null;
                if (o.getClass().isArray()) {
                    file = ((Object[])o)[0].toString();
                    newFile = ((Object[])o)[1].toString();
                } else {
                    newFile = file = (String)o;
                }
                filesToEmbed.add(file);
                file = "%idv.zidvpath%/" + IOUtil.getFileTail(newFile);
                relativeFiles.add(file);
            }
            dataSource.setTmpPaths(relativeFiles);
        }
        return filesToEmbed;
    }

    private boolean showDataEditableGui(List dataSources) {
        JCheckBox cbx;
        ArrayList<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
        ArrayList<DataSource> workingSet = new ArrayList<DataSource>();
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource dataSource = (DataSource)dataSources.get(i);
            List strings = dataSource.getDataPaths();
            if (strings == null || strings.size() <= 0) continue;
            workingSet.add(dataSource);
            cbx = new JCheckBox(DataSelector.getNameForDataSource(dataSource));
            checkBoxes.add(cbx);
        }
        if (checkBoxes.size() == 0) {
            return true;
        }
        JPanel panel = GuiUtils.vbox((Component)GuiUtils.inset((Component)GuiUtils.cLabel("Select the data sources that should be saved with editable paths"), 5), GuiUtils.vbox(checkBoxes));
        if (!GuiUtils.askOkCancel("Data Sources", panel)) {
            return false;
        }
        for (int i = 0; i < workingSet.size(); ++i) {
            DataSource dataSource = (DataSource)workingSet.get(i);
            cbx = (JCheckBox)checkBoxes.get(i);
            dataSource.setDataIsEditable(cbx.isSelected());
        }
        return true;
    }

    protected boolean addToBundle(Hashtable data, List dataSources, List displayControls, List viewManagers, String jython) {
        data.put("version", this.getStateManager().getVersion());
        data.put("ncidvversion", LibVersionUtil.getNcidvVersion());
        if (dataSources != null) {
            if (this.makeDataRelative && !this.showDataRelativeGui(dataSources)) {
                return false;
            }
            if (this.makeDataEditable && !this.showDataEditableGui(dataSources)) {
                return false;
            }
            data.put("datasources", dataSources);
        }
        if (jython != null) {
            if (this.saveJythonBox.getSelectedIndex() == 2) {
                final JTextArea fromTextArea = new JTextArea(jython);
                fromTextArea.setEditable(false);
                final JTextArea toTextArea = new JTextArea();
                JButton appendBtn = new JButton("Copy Selected ->");
                appendBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        toTextArea.setText(toTextArea.getText() + "\n" + fromTextArea.getSelectedText());
                    }
                });
                JScrollPane fromSP = new JScrollPane(fromTextArea);
                JScrollPane toSP = new JScrollPane(toTextArea);
                toSP.setPreferredSize(new Dimension(300, 400));
                fromSP.setPreferredSize(new Dimension(300, 400));
                JPanel contents = GuiUtils.doLayout(new Component[]{fromSP, GuiUtils.top(appendBtn), toSP}, 3, GuiUtils.WT_YNY, GuiUtils.WT_Y);
                contents = GuiUtils.topCenter(GuiUtils.cLabel("Please select the Jython you want to include in the bundle"), contents);
                if (!GuiUtils.showOkCancelDialog(null, "Save Jython", GuiUtils.inset((Component)contents, 5), null)) {
                    return false;
                }
                jython = toTextArea.getText();
            }
            data.put("jython", jython);
        }
        if (displayControls != null) {
            data.put("displaycontrols", displayControls);
        }
        if (viewManagers != null) {
            MapViewManager firstMvm = null;
            boolean gotMain3D = false;
            for (int i = 0; !gotMain3D && i < viewManagers.size(); ++i) {
                if (!(viewManagers.get(i) instanceof MapViewManager)) continue;
                MapViewManager mvm = (MapViewManager)viewManagers.get(i);
                if (mvm.getViewDescriptor() != null && mvm.getViewDescriptor().equals(ViewDescriptor.LASTACTIVE)) {
                    gotMain3D = true;
                }
                if (firstMvm != null) continue;
                firstMvm = mvm;
            }
            if (gotMain3D || firstMvm != null) {
                // empty if block
            }
            data.put("viewmanagers", viewManagers);
            List windows = this.getIdvUIManager().getWindowsToPersist();
            data.put("windows", windows);
        }
        this.getIdvUIManager().addStateToBundle(data);
        return true;
    }

    public void loadB64Bundle(String base64Bundle) {
        LogUtil.message("Loading bundle");
        this.showWaitCursor();
        this.decodeBase64Bundle(base64Bundle);
        this.showNormalCursor();
        LogUtil.clearMessage("Loading bundle");
    }

    public void decodeBase64Bundle(String base64Bundle) {
        try {
            LogUtil.consoleMessage("Decoding a base 64 bundle\n");
            String xml = new String(XmlUtil.decodeBase64(base64Bundle));
            if (this.getArgsManager().printJnlpBundles) {
                System.out.println(xml);
            }
            this.decodeXml(xml, false, null, true);
        }
        catch (Throwable exc) {
            IdvPersistenceManager.logException("Decoding base 64 bundle", exc);
        }
    }

    public void decodeJnlpFile(String filename) {
        String xml = this.extractBundleFromJnlp(filename);
        this.decodeXml(xml, false, null, true);
    }

    public String extractBundleFromJnlp(String filename) {
        try {
            Element root = XmlUtil.getRoot(filename, this.getClass());
            if (root == null) {
                throw new IllegalArgumentException("Could not load JNLP file:" + filename);
            }
            List arguments = XmlUtil.findDescendants(root, "argument");
            boolean nextOneBundle = false;
            for (int i = 0; i < arguments.size(); ++i) {
                Node n = (Node)arguments.get(i);
                String value = XmlUtil.getChildText(n);
                if (value == null) continue;
                if (nextOneBundle) {
                    String xml = new String(XmlUtil.decodeBase64(value));
                    System.err.println("XXXXXXXXXXXXXXX" + this.getArgsManager().printJnlpBundles);
                    if (this.getArgsManager().printJnlpBundles) {
                        System.out.println(xml);
                    }
                    return xml;
                }
                if (!value.equals("-b64bundle")) continue;
                nextOneBundle = true;
            }
        }
        catch (Throwable exc) {
            IdvPersistenceManager.logException("decoding jnlp file:" + filename, exc);
        }
        return null;
    }

    public boolean decodeXmlFile(String xmlFile, boolean checkToRemove) {
        return this.decodeXmlFile(xmlFile, checkToRemove, false);
    }

    public boolean decodeXmlFile(String xmlFile, boolean checkToRemove, boolean letUserChangeData) {
        return this.decodeXmlFile(xmlFile, null, checkToRemove, letUserChangeData, null);
    }

    public boolean decodeXmlFile(String xmlFile, boolean checkToRemove, Hashtable bundleProperties) {
        return this.decodeXmlFile(xmlFile, null, checkToRemove, bundleProperties);
    }

    public boolean decodeXmlFile(String xmlFile, String label, boolean checkToRemove) {
        return this.decodeXmlFile(xmlFile, label, checkToRemove, null);
    }

    public boolean decodeXmlFile(String xmlFile, String label, boolean checkToRemove, Hashtable bundleProperties) {
        return this.decodeXmlFile(xmlFile, label, checkToRemove, false, bundleProperties);
    }

    public boolean decodeXmlFile(String xmlFile, String label, boolean checkToRemove, boolean letUserChangeData, Hashtable bundleProperties) {
        String name = label != null ? label : IOUtil.getFileTail(xmlFile);
        boolean shouldMerge = this.getStore().get("idv.open.merge", true);
        boolean didRemoveAll = false;
        if (checkToRemove) {
            boolean[] ok = this.getPreferenceManager().getDoRemoveBeforeOpening(name);
            if (!ok[0]) {
                return false;
            }
            if (ok[3]) {
                letUserChangeData = this.getIdv().getChangeDataPaths();
            }
            if (ok[1]) {
                this.getIdv().removeAllDisplays();
                this.getIdv().removeAllDataSources();
                didRemoveAll = true;
            }
            shouldMerge = ok[2];
        } else if (shouldMerge) {
            didRemoveAll = true;
        }
        boolean isZidv = this.getArgsManager().isZidvFile(xmlFile);
        if (!isZidv && !this.getArgsManager().isXidvFile(xmlFile)) {
            try {
                ZipInputStream zin = new ZipInputStream(IOUtil.getInputStream(xmlFile));
                isZidv = zin.getNextEntry() != null;
            }
            catch (Exception zin) {
                // empty catch block
            }
        }
        String bundleContents = null;
        try {
            if (isZidv) {
                ZipEntry ze;
                boolean ask = this.getStore().get("idv.zidv.ask", true);
                boolean toTmp = this.getStore().get("idv.zidv.savetotmp", true);
                String dir = this.getStore().get("idv.zidv.directory", "");
                if (ask || dir.length() == 0 && !toTmp) {
                    JCheckBox askCbx = new JCheckBox("Don't show this again", !ask);
                    JRadioButton tmpBtn = new JRadioButton("Write to temporary directory", toTmp);
                    JRadioButton dirBtn = new JRadioButton("Write to:", !toTmp);
                    GuiUtils.buttonGroup(tmpBtn, dirBtn);
                    JTextField dirFld = new JTextField(dir, 30);
                    JPanel dirComp = GuiUtils.centerRight(dirFld, GuiUtils.makeFileBrowseButton(dirFld, true, null));
                    JPanel contents = GuiUtils.vbox(GuiUtils.inset((Component)new JLabel("Where should the data files be written to?"), 5), tmpBtn, GuiUtils.hbox(dirBtn, dirComp), GuiUtils.inset((Component)askCbx, new Insets(5, 0, 0, 0)));
                    contents = GuiUtils.inset((Component)contents, 5);
                    if (!GuiUtils.showOkCancelDialog(null, "Zip file data", contents, null)) {
                        return false;
                    }
                    ask = !askCbx.isSelected();
                    toTmp = tmpBtn.isSelected();
                    dir = dirFld.getText().toString().trim();
                    this.getStore().put("idv.zidv.ask", ask);
                    this.getStore().put("idv.zidv.savetotmp", toTmp);
                    this.getStore().put("idv.zidv.directory", (Object)dir);
                    this.getStore().save();
                }
                String tmpDir = dir;
                if (toTmp) {
                    tmpDir = this.getIdv().getObjectStore().getUserTmpDirectory();
                    tmpDir = IOUtil.joinDir(tmpDir, Misc.getUniqueId());
                }
                IOUtil.makeDir(tmpDir);
                this.getStateManager().putProperty(PROP_ZIDVPATH, tmpDir);
                ZipInputStream zin = new ZipInputStream(IOUtil.getInputStream(xmlFile));
                while ((ze = zin.getNextEntry()) != null) {
                    String entryName = ze.getName();
                    if (this.getArgsManager().isXidvFile(entryName.toLowerCase())) {
                        bundleContents = new String(IOUtil.readBytes(zin, null, false));
                        continue;
                    }
                    if (IOUtil.writeTo(zin, new FileOutputStream(IOUtil.joinDir(tmpDir, entryName))) >= 0L) continue;
                    return false;
                }
            } else {
                Trace.call1("Decode.readContents");
                bundleContents = IOUtil.readContents(xmlFile);
                Trace.call2("Decode.readContents");
            }
            Trace.call1("Decode.decodeXml");
            this.decodeXml(bundleContents, false, xmlFile, name, true, shouldMerge, bundleProperties, didRemoveAll, letUserChangeData);
            Trace.call2("Decode.decodeXml");
            return true;
        }
        catch (Throwable exc) {
            if (this.contents == null) {
                IdvPersistenceManager.logException("Unable to load bundle:" + xmlFile, exc);
            } else {
                IdvPersistenceManager.logException("Unable to evaluate bundle:" + xmlFile, exc);
            }
            return false;
        }
    }

    public void decodeXml(String xml, boolean fromCollab, String label, boolean showDialog) {
        this.decodeXml(xml, fromCollab, null, label, showDialog, true, null, false, false);
    }

    public void decodeXml(final String xml, final boolean fromCollab, final String xmlFile, final String label, final boolean showDialog, final boolean shouldMerge, final Hashtable bundleProperties, final boolean didRemoveAll, final boolean letUserChangeData) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IdvPersistenceManager.this.decodeXmlInner(xml, fromCollab, xmlFile, label, showDialog, shouldMerge, bundleProperties, didRemoveAll, letUserChangeData);
            }
        };
        if (!this.getStateManager().getShouldLoadBundlesSynchronously()) {
            Misc.run(runnable);
        } else {
            runnable.run();
        }
    }

    protected synchronized void decodeXmlInner(String xml, boolean fromCollab, String xmlFile, String label, boolean showDialog) {
        this.decodeXmlInner(xml, fromCollab, xmlFile, label, showDialog, true, null, false, false);
    }

    protected String applyPropertiesToBundle(String xml) {
        return xml;
    }

    protected synchronized void decodeXmlInner(String xml, boolean fromCollab, String xmlFile, String label, boolean showDialog, boolean shouldMerge, Hashtable bundleProperties, boolean didRemoveAll, boolean letUserChangeData) {
        LoadBundleDialog loadDialog = new LoadBundleDialog(this, label);
        boolean inError = false;
        if (!fromCollab) {
            this.showWaitCursor();
            if (showDialog) {
                loadDialog.showDialog();
            }
        }
        if (xmlFile != null) {
            this.getStateManager().putProperty(PROP_BUNDLEPATH, IOUtil.getFileRoot(xmlFile));
        }
        this.getStateManager().putProperty("idv.loadingxml", true);
        Object datasource = null;
        try {
            xml = this.applyPropertiesToBundle(xml);
            if (xml == null) {
                return;
            }
            Trace.call1("Remapping URLs");
            ServerUrlRemapper sur = new ServerUrlRemapper(this.getIdv());
            Element bundleRoot = sur.remapUrlsInBundle(xml);
            if (bundleRoot == null) {
                return;
            }
            sur = null;
            Trace.call2("Remapping URLs");
            Trace.call1("Decode.toObject");
            Object data = this.getIdv().getEncoderForRead().toObject(bundleRoot);
            Trace.call2("Decode.toObject");
            if (data != null) {
                Hashtable properties = new Hashtable();
                if (data instanceof Hashtable) {
                    Hashtable ht = (Hashtable)data;
                    this.instantiateFromBundle(ht, fromCollab, loadDialog, shouldMerge, bundleProperties, didRemoveAll, letUserChangeData);
                } else if (data instanceof DisplayControl) {
                    ((DisplayControl)data).initAfterUnPersistence(this.getIdv(), properties);
                    loadDialog.addDisplayControl((DisplayControl)data);
                } else if (data instanceof DataSource) {
                    datasource = (DataSource)data;
                    this.getIdv().getDataManager().addDataSource((DataSource)datasource);
                } else if (data instanceof ColorTable) {
                    this.getColorTableManager().doImport(data, true);
                } else {
                    LogUtil.userErrorMessage(log_, "Decoding xml. Unknown object type:" + data.getClass().getName());
                }
                if (!fromCollab && this.getIdv().haveCollabManager()) {
                    CollabManager collabManager = this.getCollabManager();
                    this.getCollabManager();
                    collabManager.write(CollabManager.MSG_BUNDLE, xml);
                }
            }
        }
        catch (Throwable exc) {
            if (xmlFile != null) {
                IdvPersistenceManager.logException("Error loading bundle: " + xmlFile, exc);
            } else {
                IdvPersistenceManager.logException("Error loading bundle", exc);
            }
            inError = true;
        }
        if (!fromCollab) {
            this.showNormalCursor();
        }
        this.getStateManager().putProperty(PROP_BUNDLEPATH, "");
        this.getStateManager().putProperty(PROP_ZIDVPATH, "");
        this.getStateManager().putProperty("idv.loadingxml", false);
        if (!inError && this.getIdv().getInteractiveMode() && xmlFile != null) {
            if (datasource != null) {
                String identifier = datasource.getClass().getName() + "_" + xmlFile;
                identifier = new String(XmlUtil.encodeBase64(identifier.getBytes()));
                this.getIdv().addToHistoryList(new DataSourceHistory(datasource.toString(), xml, identifier));
            } else {
                this.getIdv().addToHistoryList(xmlFile);
            }
        }
        loadDialog.dispose();
        if (loadDialog.getShouldRemoveItems()) {
            List displayControls = loadDialog.getDisplayControls();
            for (int i = 0; i < displayControls.size(); ++i) {
                try {
                    ((DisplayControl)displayControls.get(i)).doRemove();
                    continue;
                }
                catch (Exception data) {
                    // empty catch block
                }
            }
            List dataSources = loadDialog.getDataSources();
            for (int i = 0; i < dataSources.size(); ++i) {
                this.getIdv().removeDataSource((DataSource)dataSources.get(i));
            }
        }
        loadDialog.clear();
    }

    private boolean updateDataPaths(List dataSources, boolean letUserChangeData) {
        String bundlePath = (String)this.getStateManager().getProperty(PROP_BUNDLEPATH);
        if (bundlePath == null) {
            bundlePath = "";
        }
        String zidvPath = (String)this.getStateManager().getProperty(PROP_ZIDVPATH);
        for (int dataSourceIdx = 0; dataSourceIdx < dataSources.size(); ++dataSourceIdx) {
            DataSource dataSource = (DataSource)dataSources.get(dataSourceIdx);
            List tmpPaths = dataSource.getTmpPaths();
            if (tmpPaths == null || tmpPaths.size() == 0) continue;
            ArrayList<String> newPaths = new ArrayList<String>();
            String[] macros = new String[]{"%idv.bundlepath%", "%idv.zidvpath%"};
            String[] values = new String[]{bundlePath, zidvPath, "."};
            for (int i = 0; i < tmpPaths.size(); ++i) {
                String source = (String)tmpPaths.get(i);
                boolean gotit = false;
                for (int macroIdx = 0; !gotit && macroIdx < macros.length; ++macroIdx) {
                    for (int valueIdx = 0; !gotit && valueIdx < values.length; ++valueIdx) {
                        String tmp;
                        if (values[valueIdx] == null || !new File(tmp = StringUtil.replace(source, macros[macroIdx], values[valueIdx])).exists()) continue;
                        source = tmp;
                        gotit = true;
                    }
                }
                newPaths.add(source);
            }
            dataSource.setTmpPaths(newPaths);
        }
        ArrayList<JPanel> editableComps = new ArrayList<JPanel>();
        ArrayList<DataSource> dataEditableSources = new ArrayList<DataSource>();
        ArrayList dataEditableWidgets = new ArrayList();
        double[] stretchy = new double[dataSources.size()];
        for (int dataSourceIdx = 0; dataSourceIdx < dataSources.size(); ++dataSourceIdx) {
            DataSource dataSource = (DataSource)dataSources.get(dataSourceIdx);
            if (!dataSource.getDataIsEditable() && !letUserChangeData) continue;
            List dataPaths = dataSource.getTmpPaths();
            if (dataPaths == null || dataPaths.size() == 0) {
                dataPaths = dataSource.getDataPaths();
            }
            if (dataPaths == null || dataPaths.size() == 0) continue;
            dataEditableSources.add(dataSource);
            JLabel label = new JLabel(dataSource.toString());
            JButton chooserBtn = GuiUtils.makeButton("Change Data:", this, "changeData", new Object[]{dataSource, label});
            JPanel widgetContents = GuiUtils.leftCenter(chooserBtn, GuiUtils.inset((Component)label, 5));
            widgetContents = GuiUtils.inset((Component)widgetContents, new Insets(10, 0, 0, 0));
            editableComps.add(widgetContents);
        }
        if (!this.getArgsManager().getIsOffScreen() && editableComps.size() > 0) {
            JPanel panel = GuiUtils.doLayout(editableComps, 1, GuiUtils.WT_Y, stretchy);
            panel = GuiUtils.inset((Component)GuiUtils.topCenter(GuiUtils.cLabel("You can choose new files for the following data sources"), panel), 5);
            if (!GuiUtils.showOkCancelDialog(null, "Data Sources", panel, null)) {
                return false;
            }
        }
        return true;
    }

    public void changeData(Object[] input) {
        DataSource dataSource = (DataSource)input[0];
        JLabel label = (JLabel)input[1];
        if (this.changeState(dataSource, false)) {
            label.setText(dataSource.toString());
        }
    }

    public boolean changeState(DataSource dataSource) {
        return this.changeState(dataSource, true);
    }

    public boolean changeState(DataSource dataSource, boolean andReload) {
        ArrayList choosers = new ArrayList();
        JComponent comp = this.getIdv().getIdvChooserManager().createChoosers(false, choosers, null);
        final Object[] result = new Object[]{null};
        final Hashtable[] properties = new Hashtable[]{null};
        final JDialog dialog = GuiUtils.createDialog(null, "Change data for: " + dataSource, true);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object[] newData = (Object[])ae.getSource();
                result[0] = newData[0];
                properties[0] = (Hashtable)newData[1];
                dialog.dispose();
            }
        };
        for (int i = 0; i < choosers.size(); ++i) {
            IdvChooser chooser = (IdvChooser)choosers.get(i);
            chooser.setDataSourceListener(listener);
        }
        JButton cancelBtn = GuiUtils.makeButton("Cancel", dialog, "dispose");
        comp = GuiUtils.inset((Component)GuiUtils.topCenterBottom(GuiUtils.inset((Component)new JLabel("Select new data for: " + dataSource), 5), comp, GuiUtils.wrap(cancelBtn)), 5);
        dialog.getContentPane().add(comp);
        dialog.pack();
        dialog.setVisible(true);
        if (result[0] == null) {
            return false;
        }
        try {
            dataSource.updateState(result[0], properties[0]);
            if (andReload) {
                dataSource.reloadData();
            }
            return true;
        }
        catch (Exception exc) {
            IdvPersistenceManager.logException("Updating data source", exc);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void instantiateFromBundle(Hashtable ht, boolean fromCollab, LoadBundleDialog loadDialog, boolean shouldMerge, Hashtable bundleProperties, boolean didRemoveAll, boolean letUserChangeData) throws Exception {
        String jython;
        String version;
        if (!loadDialog.okToRun()) {
            return;
        }
        bundleIdvVersion = version = (String)ht.get("version");
        if (version == null) {
            version = this.getStateManager().getVersion();
        }
        if ((jython = (String)ht.get("jython")) != null) {
            final String theJython = jython;
            if (this.getArgsManager().getIsOffScreen()) {
                this.getJythonManager().appendTmpJython(theJython);
            } else {
                JLabel label = new JLabel("<html>The bundle contained the following jython library.<p>&nbsp;&nbsp; What would you like to do with this?<br></html>");
                final JDialog dialog = GuiUtils.createDialog("Load Jython Library", true);
                final JTextArea textArea = new JTextArea(jython);
                textArea.setEditable(false);
                JButton dontLoadBtn = new JButton("Don't load it");
                JButton addItBtn = new JButton("Add it to my local library");
                JButton addTmpBtn = new JButton("Add it to my temporary library");
                JButton addSelectedBtn = new JButton("Add selected text");
                addItBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        IdvPersistenceManager.this.getJythonManager().appendJythonFromBundle(theJython);
                        dialog.dispose();
                    }
                });
                addTmpBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        IdvPersistenceManager.this.getJythonManager().appendTmpJython(theJython);
                        dialog.dispose();
                    }
                });
                addSelectedBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        String text = textArea.getSelectedText();
                        if (text != null && text.length() > 0) {
                            IdvPersistenceManager.this.getJythonManager().appendJythonFromBundle(text);
                        }
                        dialog.dispose();
                    }
                });
                dontLoadBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        dialog.dispose();
                    }
                });
                JPanel buttons = GuiUtils.hbox(Misc.newList(addItBtn, addTmpBtn, addSelectedBtn, dontLoadBtn), 5);
                JPanel comp = GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.vbox((Component)GuiUtils.inset((Component)label, 5), buttons), 5), GuiUtils.makeScrollPane(textArea, 300, 500));
                dialog.getContentPane().add(comp);
                GuiUtils.showInCenter(dialog);
            }
        }
        List overrideTimes = bundleProperties == null ? null : (List)bundleProperties.get(PROP_TIMESLIST);
        List overrideEnsMembers = bundleProperties == null ? null : (List)bundleProperties.get(PROP_ENSLIST);
        GeoSelection overrideGeoSelection = bundleProperties == null ? null : (GeoSelection)bundleProperties.get(PROP_GEOSELECTION);
        Date aniTDTstart = bundleProperties == null ? null : (Date)bundleProperties.get(PROP_DRIVERTIMESTART);
        Date aniTDTend = bundleProperties == null ? null : (Date)bundleProperties.get(PROP_DRIVERTIMEEND);
        GeoSelection baseGeoSelection = null;
        List dataSources = (List)ht.get("datasources");
        if (dataSources != null) {
            if (!this.updateDataPaths(dataSources, letUserChangeData)) {
                return;
            }
            ArrayList localFileMapping = null;
            if (this.fileMapping != null && this.fileMapping.size() > 0) {
                localFileMapping = new ArrayList(this.fileMapping);
            }
            ThreadManager threadManager = new ThreadManager("Data source initialization");
            for (int i = 0; i < dataSources.size(); ++i) {
                final DataSource dataSource = (DataSource)dataSources.get(i);
                dataSource.setInError(false);
                loadDialog.setMessage1("Loading data source " + (i + 1) + " of " + dataSources.size());
                loadDialog.setMessage2("(" + DataSelector.getNameForDataSource(dataSource) + ")");
                if (localFileMapping != null) {
                    for (int mappingIdx = 0; mappingIdx < localFileMapping.size(); ++mappingIdx) {
                        ObjectPair pair = (ObjectPair)localFileMapping.get(mappingIdx);
                        String identifier = (String)pair.getObject1();
                        List files = (List)pair.getObject2();
                        if (!dataSource.identifiedByName(identifier)) continue;
                        localFileMapping.remove(mappingIdx);
                        dataSource.setNewFiles(files);
                        break;
                    }
                }
                long t1 = System.currentTimeMillis();
                threadManager.addRunnable(new ThreadManager.MyRunnable(){

                    @Override
                    public void run() throws Exception {
                        dataSource.initAfterUnpersistence();
                    }
                });
            }
            long t1 = System.currentTimeMillis();
            try {
                threadManager.runInParallel(this.getIdv().getMaxDataThreadCount());
            }
            catch (Exception exc) {
                List<Exception> exceptions = threadManager.getExceptions();
                if (exceptions.size() == 0) {
                    exceptions.add(exc);
                }
                LogUtil.printExceptions(exceptions);
            }
            long t2 = System.currentTimeMillis();
            for (int i = 0; i < dataSources.size(); ++i) {
                DataSource dataSource = (DataSource)dataSources.get(i);
                if (overrideTimes != null) {
                    dataSource.setDateTimeSelection(overrideTimes);
                }
                if (overrideGeoSelection != null) {
                    if (baseGeoSelection == null) {
                        baseGeoSelection = dataSource.getDataSelection().getGeoSelection();
                    }
                    GeoSelection ogeoselection = new GeoSelection(overrideGeoSelection);
                    dataSource.getDataSelection().setGeoSelection(ogeoselection);
                }
                if (overrideEnsMembers != null && dataSource instanceof GridDataSource) {
                    ((GridDataSource)dataSource).setEnsembleSelection(overrideEnsMembers);
                }
                if (!loadDialog.okToRun()) {
                    return;
                }
                if (dataSource.getInError() || !this.getDataManager().addDataSource(dataSource)) continue;
                loadDialog.addDataSource(dataSource);
            }
            if (localFileMapping != null && localFileMapping.size() > 0) {
                throw new IllegalArgumentException("Did not find the data source to use for the file override: " + localFileMapping);
            }
            this.clearDataSourcesState(dataSources);
            this.clearFileMapping();
        }
        if (!loadDialog.okToRun()) {
            return;
        }
        if (!fromCollab) {
            this.getIdvUIManager().applyDataHolderState((Hashtable)ht.get("mischashtable"));
        }
        this.getVMManager().setDisplayMastersInactive();
        try {
            List<ViewManager> currentViewManagers = this.getVMManager().getViewManagers();
            List windows = (List)ht.get("windows");
            List newViewManagers = (List)ht.get("viewmanagers");
            if (newViewManagers != null) {
                this.getVMManager().unpersistViewManagers(newViewManagers);
                for (ViewManager t2 : newViewManagers) {
                }
            }
            List newControls = (List)ht.get("displaycontrols");
            if (!shouldMerge && newViewManagers != null) {
                for (int i = 0; i < newViewManagers.size(); ++i) {
                    ViewManager newViewManager = (ViewManager)newViewManagers.get(i);
                    List oldAliases = newViewManager.getAliases();
                    ArrayList<ViewDescriptor> newAliases = new ArrayList<ViewDescriptor>();
                    for (int aliasIdx = 0; aliasIdx < oldAliases.size(); ++aliasIdx) {
                        ViewDescriptor oldVd = (ViewDescriptor)oldAliases.get(aliasIdx);
                        ViewDescriptor newVd = new ViewDescriptor();
                        newVd.setClassNames(oldVd.getClassNames());
                        newAliases.add(newVd);
                        if (newControls == null) continue;
                        for (int controlIdx = 0; controlIdx < newControls.size(); ++controlIdx) {
                            DisplayControlImpl dc = (DisplayControlImpl)newControls.get(controlIdx);
                            dc.resetViewManager(oldVd.getName(), newVd.getName());
                        }
                    }
                    newViewManager.setAliases(newAliases);
                }
            }
            if (newViewManagers != null) {
                if (this.getArgsManager().getIsOffScreen() && !this.addWindows) {
                    Trace.call1("Decode.addViewManagers");
                    this.getVMManager().addViewManagers(newViewManagers);
                    Trace.call2("Decode.addViewManagers");
                } else if (windows != null) {
                    this.getIdvUIManager().unpersistWindowInfo(windows, newViewManagers, shouldMerge, fromCollab, didRemoveAll);
                }
            }
            if (newViewManagers != null && windows == null) {
                for (int i = 0; i < newViewManagers.size(); ++i) {
                    ViewManager vm;
                    int currentIdx;
                    ViewManager viewManager = (ViewManager)newViewManagers.get(i);
                    if (shouldMerge && viewManager.getViewDescriptor() == null) {
                        for (currentIdx = 0; currentIdx < currentViewManagers.size(); ++currentIdx) {
                            vm = currentViewManagers.get(currentIdx);
                            if (!vm.isCompatibleWith(viewManager)) continue;
                            currentViewManagers.remove(currentIdx);
                            vm.initWith(viewManager);
                            viewManager = null;
                            break;
                        }
                    }
                    if (viewManager != null) {
                        this.getVMManager().addViewManagers(Misc.newList(viewManager));
                        this.getIdvUIManager().createNewWindow(Misc.newList(viewManager));
                    }
                    if (!shouldMerge) continue;
                    for (currentIdx = 0; currentIdx < currentViewManagers.size(); ++currentIdx) {
                        vm = currentViewManagers.get(currentIdx);
                        IdvWindow window = vm.getDisplayWindow();
                        if (window == null || window.getHasBeenDisposed()) continue;
                        window.dispose();
                    }
                }
            } else if (newViewManagers != null) {
                this.getVMManager().addViewManagers(newViewManagers);
            }
            if (loadDialog.okToRun()) {
                List commandsToRun;
                if (newControls != null) {
                    if (this.getIdv().getArgsManager().getIsOffScreen()) {
                        // empty if block
                    }
                    final Hashtable properties = new Hashtable();
                    Trace.call1("Decode.init displays");
                    ThreadManager displaysThreadManager = new ThreadManager("display initialization");
                    int numberOfInitSteps = this.getIdv().getUseTimeDriver() ? 2 : 1;
                    for (int initStep = 0; initStep < numberOfInitSteps; ++initStep) {
                        for (int i = 0; i < newControls.size(); ++i) {
                            final DisplayControl displayControl = (DisplayControl)newControls.get(i);
                            if (this.getIdv().getUseTimeDriver() && (initStep == 0 && !displayControl.getIsTimeDriver() || initStep == 1 && displayControl.getIsTimeDriver())) continue;
                            loadDialog.setMessage1("Loading display " + (i + 1) + " of " + newControls.size());
                            loadDialog.setMessage2("(" + displayControl.getLabel() + ")");
                            if (this.getIdv().haveCollabManager() && fromCollab && this.getCollabManager().haveDisplayControl(displayControl)) continue;
                            displaysThreadManager.addRunnable(new ThreadManager.MyRunnable(){

                                @Override
                                public void run() throws Exception {
                                    displayControl.initAfterUnPersistence(IdvPersistenceManager.this.getIdv(), properties);
                                }
                            });
                            loadDialog.addDisplayControl(displayControl);
                            if (loadDialog.okToRun()) continue;
                            return;
                        }
                    }
                    long tt1 = System.currentTimeMillis();
                    displaysThreadManager.runSequentially();
                    long tt2 = System.currentTimeMillis();
                    Trace.call2("Decode.init displays");
                }
                if (fromCollab || (commandsToRun = (List)ht.get("commandstorun")) != null) {
                    // empty if block
                }
            }
            if (newControls != null && overrideGeoSelection != null) {
                LatLonRect baseLLR = baseGeoSelection != null ? baseGeoSelection.getLatLonRect() : null;
                LatLonRect newLLR = overrideGeoSelection.getLatLonRect();
                if (newLLR != null) {
                    System.err.println("baseBounds:" + baseLLR + " new bounds:" + newLLR);
                    boolean useDataProjection = true;
                    for (int controlIdx = 0; controlIdx < newControls.size(); ++controlIdx) {
                        DisplayControlImpl dc = (DisplayControlImpl)newControls.get(controlIdx);
                        if (!(dc instanceof MapDisplayControl) && useDataProjection) {
                            dc.relocateDisplay(baseLLR, newLLR, true);
                            useDataProjection = false;
                        } else {
                            dc.relocateDisplay(baseLLR, newLLR, false);
                        }
                        if (controlIdx != newControls.size() - 1) continue;
                        dc.saveProjection();
                    }
                }
            }
        }
        finally {
            this.getVMManager().setDisplayMastersActive();
            this.getStateManager().putProperty("idv.usedisplayarea", false);
            if (aniTDTstart != null || aniTDTend != null) {
                List<ViewManager> vms = this.getVMManager().getViewManagers();
                for (ViewManager viewManager : vms) {
                    viewManager.setTimeDriverTimes(aniTDTstart, aniTDTend);
                }
            }
        }
        loadDialog.setMessage("Activating displays");
        Trace.msg("Decode.end");
    }

    public DataSourceResults makeDataSourceFromXml(String dataSourceXml) {
        try {
            DataSource dataSource = (DataSource)this.getIdv().decodeObject(dataSourceXml);
            dataSource.initAfterUnpersistence();
            if (dataSource.getInError()) {
                return null;
            }
            this.getDataManager().addDataSource(dataSource);
            return new DataSourceResults(dataSource, dataSourceXml);
        }
        catch (Exception exc) {
            IdvPersistenceManager.logException("Creating data source", exc);
            return new DataSourceResults(dataSourceXml, exc);
        }
    }

    public boolean getSaveViewState() {
        return this.saveViewState;
    }

    public boolean getSaveDisplays() {
        return this.saveDisplays;
    }

    public boolean getSaveDataSources() {
        return this.saveDataSources;
    }

    public boolean getSaveJython() {
        return this.saveJython;
    }

    public boolean getSaveData() {
        return this.saveData;
    }

    public String getCurrentTemplateName() {
        return this.currentTemplateName;
    }

    private File getPrototypeFile(Class c) {
        String filename = c.getName() + ".xml";
        ResourceCollection rc = this.getResourceManager().getResources(IdvResourceManager.RSC_PROTOTYPES);
        String dir = rc.getWritable();
        if (dir == null) {
            LogUtil.consoleMessage("No prototype resoruce path defined");
            return null;
        }
        IOUtil.makeDir(dir);
        String fullPath = IOUtil.joinDir(dir, filename);
        return new File(fullPath);
    }

    @Override
    public void writePrototype(Object object) {
        try {
            String xml = this.encodeSpecial(object);
            File file = this.getPrototypeFile(object.getClass());
            if (file != null) {
                IOUtil.writeFile(file, xml);
            }
        }
        catch (Exception exc) {
            IdvPersistenceManager.logException("writing prototype: " + object.getClass().getName(), exc);
        }
    }

    public void clearPrototype(Class c) {
        try {
            File f = this.getPrototypeFile(c);
            if (f != null && f.exists()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object getPrototype(Class c) {
        try {
            File f = this.getPrototypeFile(c);
            if (f == null || !f.exists()) {
                return null;
            }
            String xml = IOUtil.readContents(f.toString());
            Object prototype = this.getIdv().getEncoderForRead().toObject(xml);
            if (prototype instanceof Prototypable) {
                ((Prototypable)prototype).initAsPrototype();
            }
            return prototype;
        }
        catch (Exception exc) {
            IdvPersistenceManager.logException("reading prototype: " + c.getName(), exc);
            return null;
        }
    }

    public static String getBundleIdvVersion() {
        return bundleIdvVersion;
    }

    private static class DataSourceComponent {
        DataSource dataSource;
        JCheckBox cbx = new JCheckBox();
        List files;

        public DataSourceComponent(DataSource ds) {
            this.dataSource = ds;
        }
    }

    private final class DeselectAL
    implements ActionListener {
        private final JToggleButton cbx;

        private DeselectAL(JToggleButton cbx) {
            this.cbx = cbx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cbx.setSelected(false);
        }
    }
}

