/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.io.File;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import ucar.unidata.idv.IdvConstants;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.StateManager;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlObjectStore;

public class IdvObjectStore
extends XmlObjectStore
implements IdvConstants {
    public static final String PROP_TMPDIR = "idv.tmpdir";
    public static final String DIR_BUNDLES = "bundles";
    public static final String DIR_SAVEDBUNDLES = "savedbundles";
    private IntegratedDataViewer idv;
    String systemDirectory;
    File userDirectory;
    boolean madeUserDirectory = false;
    boolean usingNormalUserDirectory = true;

    public IdvObjectStore(IntegratedDataViewer idv, String systemName, String appName, XmlEncoder encoder, String overrideUserDirectory) {
        super(encoder);
        this.idv = idv;
        if (overrideUserDirectory != null) {
            this.systemDirectory = overrideUserDirectory;
            this.userDirectory = new File(overrideUserDirectory);
            this.usingNormalUserDirectory = false;
        } else {
            String userHome = Misc.getSystemProperty("user.home", ".");
            this.systemDirectory = IOUtil.joinDir(userHome, "." + systemName);
            if (systemName.equals("unidata/idv") && !new File(this.systemDirectory).exists()) {
                File metappsDir = new File(IOUtil.joinDir(userHome, ".metapps"));
                File toDir = new File(this.systemDirectory);
                IOUtil.makeDirRecursive(new File(IOUtil.joinDir(userHome, ".unidata")));
                if (metappsDir.exists()) {
                    JLabel label = new JLabel("<html>The IDV is moving the user state directory (.metapps):<br><i>&nbsp;&nbsp;" + metappsDir + "</i><br> to:<br>&nbsp&nbsp;<i>" + toDir + "</i><p><br>This shouldn't be a problem and will just take a second");
                    boolean ok = metappsDir.renameTo(toDir);
                    if (!ok) {
                        JLabel msg = new JLabel("<html>The IDV attempted to move the user directory to a new location.<br>For some reason the directory move failed.<p><br>Please move the directory:<br><i>&nbsp;&nbsp;" + metappsDir + "</i><br> to:<br>&nbsp;&nbsp;<i>" + toDir + "</i><p><br>And then restart the IDV");
                        JOptionPane.showMessageDialog(null, msg, "Error", 0);
                        System.exit(0);
                    }
                }
            }
            IOUtil.makeDirRecursive(new File(this.systemDirectory));
            this.userDirectory = new File(IOUtil.joinDir(this.systemDirectory, appName));
        }
        if (!this.userDirectory.exists()) {
            this.madeUserDirectory = true;
            IOUtil.makeDir(this.userDirectory);
        }
        this.getPluginsDir();
    }

    public boolean getMadeUserDirectory() {
        return this.madeUserDirectory;
    }

    public String getSystemDirectory() {
        return this.systemDirectory;
    }

    @Override
    protected Hashtable processTable(Hashtable newTable) {
        this.idv.getStateManager();
        return StateManager.processPropertyTable(newTable);
    }

    public String getJythonCacheDir() {
        String dirName = "jython";
        String jythonVersion = this.idv.getStateManager().getJythonVersion();
        if (jythonVersion != null) {
            dirName = dirName + jythonVersion;
        }
        if (!this.usingNormalUserDirectory) {
            return IOUtil.makeDir(IOUtil.joinDir(this.userDirectory, dirName));
        }
        if (!this.userDirectoryOk()) {
            return null;
        }
        return IOUtil.makeDir(IOUtil.joinDir(this.systemDirectory, dirName));
    }

    @Override
    public File getUserDirectory() {
        return this.userDirectory;
    }

    public void setOverrideDirectory(File newDirectory) {
        this.userDirectory = newDirectory;
        this.systemDirectory = newDirectory.toString();
    }

    public String getDisplayTemplateDir() {
        String tmpDir = IOUtil.joinDir(this.getUserDirectory().toString(), "displaytemplates");
        IOUtil.makeDir(tmpDir);
        return tmpDir;
    }

    public String getDataSourcesDir() {
        String tmpDir = IOUtil.joinDir(this.getUserDirectory().toString(), "datasources");
        IOUtil.makeDir(tmpDir);
        return tmpDir;
    }

    public String getPluginsDir() {
        String tmpDir = IOUtil.joinDir(this.getUserDirectory().toString(), "plugins");
        IOUtil.makeDir(tmpDir);
        return tmpDir;
    }

    public String getLocalBundlesDir() {
        String tmpDir = IOUtil.joinDir(this.getUserDirectory().toString(), DIR_BUNDLES);
        IOUtil.makeDir(tmpDir);
        return tmpDir;
    }

    public File getSavedBundlesDir() {
        String tmpDir = IOUtil.joinDir(this.getUserDirectory().toString(), DIR_SAVEDBUNDLES);
        IOUtil.makeDir(tmpDir);
        return new File(tmpDir);
    }

    @Override
    public synchronized Object get(String key) {
        Object obj = super.get(key = StateManager.fixIds(key));
        if (obj == null) {
            obj = this.idv.getStateManager().getProperty(key);
        }
        return obj;
    }
}

