/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ui.ImageGenerator;
import ucar.unidata.util.HttpServer;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.xml.XmlUtil;

public class IdvMonitor
extends HttpServer {
    public static final String CMD_PING = "/ping";
    public static final String CMD_LOADBUNDLE = "/loadbundle";
    public static final String CMD_LOADISL = "/loadisl";
    public static final String ARG_BUNDLE = "bundle";
    public static final String ARG_ISL = "isl";
    public static final String ARG_ISLPATH = "islpath";
    private IntegratedDataViewer idv;
    private InetAddress localHost;

    public IdvMonitor(IntegratedDataViewer idv, int port) {
        super(port);
        this.idv = idv;
    }

    @Override
    protected HttpServer.RequestHandler doMakeRequestHandler(Socket socket) throws Exception {
        InetAddress inet;
        if (this.localHost == null) {
            this.localHost = InetAddress.getLocalHost();
        }
        if (!(inet = socket.getInetAddress()).getHostAddress().equals("127.0.0.1")) {
            return null;
        }
        return new MonitorRequestHandler(this.idv, this, socket);
    }

    private String getReturnXml(boolean ok, String msg) {
        msg = XmlUtil.encodeString(msg);
        System.err.println("msg:" + msg);
        return "<result ok=\"" + ok + "\">" + msg + "</result>";
    }

    public class MonitorRequestHandler
    extends HttpServer.RequestHandler {
        IntegratedDataViewer idv;

        public MonitorRequestHandler(IntegratedDataViewer idv, HttpServer server, Socket socket) throws Exception {
            super(server, socket);
            this.idv = idv;
        }

        private void decorateHtml(StringBuffer sb) throws Exception {
            String header = "<a href=stack.html>Stack Trace</a>&nbsp;|&nbsp;<a href=info.html>System Information</a>&nbsp;|&nbsp;<a href=shutdown.html>Shutdown</a><hr>";
            this.writeResult(true, header + sb.toString(), "text/html");
        }

        @Override
        protected void handleRequest(String path, Hashtable formArgs, Hashtable httpArgs, String content) throws Exception {
            if (path.equals("/stack.html")) {
                StringBuffer stack = LogUtil.getStackDump(true);
                this.decorateHtml(stack);
            } else if (path.equals("/info.html")) {
                StringBuffer extra = this.idv.getIdvUIManager().getSystemInfo();
                extra.append("<H3>Data Sources</H3>");
                extra.append("<div style=\"margin-left:20px;\">");
                extra.append(this.idv.getDataManager().getDataSourceHtml());
                extra.append("</div>");
                extra.append(this.idv.getPluginManager().getPluginHtml());
                extra.append(this.idv.getResourceManager().getHtmlView());
                this.decorateHtml(extra);
            } else if (path.equals("/shutdown.html")) {
                this.decorateHtml(new StringBuffer("Really shutdown the IDV?<br><a href=\"reallyshutdown.html\">Yes</a>"));
            } else if (path.equals("/reallyshutdown.html")) {
                this.writeResult(true, "OK, IDV is shutting down", "text/html");
                System.exit(0);
            } else if (path.equals(IdvMonitor.CMD_PING)) {
                this.writeResult(true, "ok", "text/html");
            } else if (path.equals(IdvMonitor.CMD_LOADBUNDLE)) {
                String bundle = (String)formArgs.get(IdvMonitor.ARG_BUNDLE);
                if (bundle == null) {
                    this.writeResult(false, "No bundle argument given", "text/html");
                    return;
                }
                String xml = IOUtil.readContents(bundle, this.getClass());
                this.idv.getPersistenceManager().decodeXmlInner(xml, false, bundle, "", false);
                this.writeResult(true, "ok", "text/html");
            } else if (path.equals(IdvMonitor.CMD_LOADISL)) {
                String islPath;
                String isl = (String)formArgs.get(IdvMonitor.ARG_ISL);
                if (isl == null && (islPath = (String)formArgs.get(IdvMonitor.ARG_ISLPATH)) != null) {
                    isl = IOUtil.readContents(islPath, this.getClass());
                }
                if (isl == null) {
                    this.writeResult(false, IdvMonitor.this.getReturnXml(false, "No isl argument given"), "text/xml");
                    return;
                }
                String tmpFile = this.idv.getStore().getTmpFile("tmp.isl");
                IOUtil.writeFile(tmpFile, isl);
                ImageGenerator imageGenerator = this.idv.getImageGenerator();
                if (!imageGenerator.processScriptFile(tmpFile, new Hashtable(), false)) {
                    String error = imageGenerator.getError();
                    this.writeResult(true, IdvMonitor.this.getReturnXml(false, error), "text/xml");
                }
                List<String> results = imageGenerator.getResults();
                String result = "";
                if (results.size() > 0) {
                    result = results.get(0);
                }
                this.writeResult(true, IdvMonitor.this.getReturnXml(true, result), "text/xml");
            } else {
                this.decorateHtml(new StringBuffer("Unknown url:" + path));
            }
        }
    }
}

