/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import ucar.unidata.data.DataManager;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.idv.ArgsManager;
import ucar.unidata.idv.IdvConstants;
import ucar.unidata.idv.IdvObjectStore;
import ucar.unidata.idv.IdvPersistenceManager;
import ucar.unidata.idv.IdvPreferenceManager;
import ucar.unidata.idv.IdvProjectionManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.InstallManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.JythonManager;
import ucar.unidata.idv.StateManager;
import ucar.unidata.idv.VMManager;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.collab.CollabManager;
import ucar.unidata.idv.publish.PublishManager;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.idv.ui.ImageGenerator;
import ucar.unidata.ui.WindowHolder;
import ucar.unidata.ui.colortable.ColorTableManager;
import ucar.unidata.ui.symbol.StationModelManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import visad.ActionImpl;

public abstract class IdvManager
extends WindowHolder
implements IdvConstants {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(IdvManager.class.getName());
    private IntegratedDataViewer idv;

    public IdvManager(IntegratedDataViewer idv) {
        this.idv = idv;
    }

    public IntegratedDataViewer getIdv() {
        return this.idv;
    }

    protected Class getIdvClass() {
        return this.getIdv().getClass();
    }

    protected IdvObjectStore getStore() {
        return this.idv.getStore();
    }

    protected IdvResourceManager getResourceManager() {
        return this.idv.getResourceManager();
    }

    public StationModelManager getStationModelManager() {
        return this.getIdv().getStationModelManager();
    }

    public IdvProjectionManager getIdvProjectionManager() {
        return this.getIdv().getIdvProjectionManager();
    }

    public IdvPersistenceManager getPersistenceManager() {
        return this.idv.getPersistenceManager();
    }

    public IdvPreferenceManager getPreferenceManager() {
        return this.idv.getPreferenceManager();
    }

    public ColorTableManager getColorTableManager() {
        return this.getIdv().getColorTableManager();
    }

    protected IdvUIManager getIdvUIManager() {
        return this.idv.getIdvUIManager();
    }

    protected ImageGenerator getImageGenerator() {
        return this.idv.getImageGenerator();
    }

    protected IdvChooserManager getIdvChooserManager() {
        return this.idv.getIdvChooserManager();
    }

    protected JythonManager getJythonManager() {
        return this.idv.getJythonManager();
    }

    protected ArgsManager getArgsManager() {
        return this.idv.getArgsManager();
    }

    protected VMManager getVMManager() {
        return this.idv.getVMManager();
    }

    protected PublishManager getPublishManager() {
        return this.idv.getPublishManager();
    }

    protected StateManager getStateManager() {
        return this.idv.getStateManager();
    }

    protected DataManager getDataManager() {
        return this.idv.getDataManager();
    }

    protected InstallManager getInstallManager() {
        return this.idv.getInstallManager();
    }

    protected CollabManager getCollabManager() {
        return this.idv.getCollabManager();
    }

    public static void logException(String msg, Throwable excp) {
        LogUtil.printException(log_, msg, excp);
    }

    protected void showWaitCursor() {
        this.idv.showWaitCursor();
    }

    protected void showNormalCursor() {
        this.idv.showNormalCursor();
    }

    public boolean getProperty(String name, boolean dflt) {
        return this.getStateManager().getProperty(name, dflt);
    }

    public int getProperty(String name, int dflt) {
        return this.getStateManager().getProperty(name, dflt);
    }

    public String getProperty(String name, String dflt) {
        return this.getStateManager().getProperty(name, dflt);
    }

    public static void waitUntilDisplaysAreDone(IdvUIManager uiManager) {
        long timeToWait = 100L;
        IdvManager.waitUntilDisplaysAreDone(uiManager, timeToWait);
    }

    public static void waitUntilDisplaysAreDone(IdvUIManager uiManager, long timeToWait) {
        block2: {
            Trace.call1("Waiting on displays");
            int successiveTimesWithNoActive = 0;
            int sleepTime = 10;
            long firstTime = System.currentTimeMillis();
            boolean cnt = false;
            do {
                boolean anyActive;
                boolean cursorCount = uiManager.getWaitCursorCount() > 0;
                boolean actionCount = ActionImpl.getTaskCount() > 0;
                boolean dataActive = DataSourceImpl.getOutstandingGetDataCalls() > 0;
                boolean anyJ3dActive = IdvManager.anyJava3dThreadsActive();
                boolean allDisplaysInitialized = uiManager.getIdv().getAllDisplaysIntialized();
                boolean bl = anyActive = actionCount || cursorCount || dataActive || !allDisplaysInitialized || anyJ3dActive;
                if (dataActive) {
                    firstTime = System.currentTimeMillis();
                }
                successiveTimesWithNoActive = anyActive ? 0 : ++successiveTimesWithNoActive;
                if (timeToWait == 0L && !anyActive || (long)(successiveTimesWithNoActive * sleepTime) > timeToWait) break block2;
                Misc.sleep(sleepTime);
            } while (System.currentTimeMillis() - firstTime <= 120000L);
            System.err.println("Error waiting for to be done:" + LogUtil.getStackDump(false));
            return;
        }
        Trace.call2("Waiting on displays");
    }

    private static boolean anyJava3dThreadsActive() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] ids = threadBean.getAllThreadIds();
        for (int i = 0; i < ids.length; ++i) {
            ThreadInfo info = threadBean.getThreadInfo(ids[i], Integer.MAX_VALUE);
            if (info == null || info.getThreadState() != Thread.State.RUNNABLE || info.getThreadName().indexOf("J3D") < 0) continue;
            return true;
        }
        return false;
    }
}

