/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ucar.unidata.idv.SystemMemoryManager;
import ucar.unidata.util.IOUtil;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlUtil;

public class IdvCommandLinePrefs {
    private static final String DEFAULT_USER_PREF_FILE = "main.xml";
    private static final String DEFAULT_USER_PREF_PATH = IOUtil.joinDirs(System.getProperty("user.home"), ".unidata", "idv", "DefaultIdv");
    private static final String IDV_MEMORY = "idv.memory";

    public static void main(String ... args) {
        StringBuilder sb = new StringBuilder();
        File prefFile = new File(IdvCommandLinePrefs.getPreferences(args));
        try {
            Map<Object, Object> userPrefMap = IdvCommandLinePrefs.getPrefMap(args);
            for (Map.Entry<Object, Object> e : userPrefMap.entrySet()) {
                String s = e.getKey().toString().replace(".", "_") + "=\"" + e.getValue() + "\"" + System.getProperty("line.separator");
                sb.append(s);
            }
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        System.out.println(sb.toString());
    }

    private static Map<Object, Object> getPrefMap(String ... args) throws IOException, Exception {
        HashMap<Object, Object> userPrefMap = new HashMap<Object, Object>();
        File f = new File(IdvCommandLinePrefs.getPreferences(args));
        if (f.exists()) {
            userPrefMap.putAll((Map)new XmlEncoder().createObject(XmlUtil.getRoot(f.getPath(), XmlUtil.class)));
        }
        IdvCommandLinePrefs.vetSettings(userPrefMap);
        return userPrefMap;
    }

    private static void vetSettings(Map<Object, Object> userPrefMap) {
        IdvCommandLinePrefs.checkMemory(userPrefMap);
    }

    private static void checkMemory(Map<Object, Object> userPrefMap) {
        if (userPrefMap.containsKey(IDV_MEMORY)) {
            userPrefMap.put(IDV_MEMORY, SystemMemoryManager.checkAndRepair((Long)userPrefMap.get(IDV_MEMORY)));
        } else {
            userPrefMap.put(IDV_MEMORY, SystemMemoryManager.getDefaultMemory());
        }
    }

    private static String getPreferences(String ... args) {
        String userPath = null;
        for (int i = 1; i < args.length; ++i) {
            if (!args[i - 1].equals("-userpath")) continue;
            userPath = args[i];
        }
        return userPath == null ? IOUtil.joinDir(DEFAULT_USER_PREF_PATH, DEFAULT_USER_PREF_FILE) : IOUtil.joinDir(userPath, DEFAULT_USER_PREF_FILE);
    }
}

