/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Container;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import ucar.unidata.idv.DisplayInfo;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.util.BooleanProperty;
import ucar.unidata.util.GuiUtils;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.HovmollerDisplay;
import visad.VisADException;

public class HovmollerViewManager
extends ViewManager {
    public static final String PREF_GRIDLINES = "HovmollerView.Gridlines";
    private boolean clipOn = false;

    public HovmollerViewManager() {
    }

    public HovmollerViewManager(ViewContext viewContext) {
        super(viewContext);
    }

    public HovmollerViewManager(ViewContext viewContext, ViewDescriptor desc, String properties) throws VisADException, RemoteException {
        super(viewContext, desc, properties);
    }

    public HovmollerDisplay getHovmollerDisplay() {
        return (HovmollerDisplay)this.getMaster();
    }

    @Override
    protected DisplayMaster doMakeDisplayMaster() throws VisADException, RemoteException {
        return new HovmollerDisplay();
    }

    @Override
    public boolean getUseFastRendering(boolean b) {
        return true;
    }

    @Override
    public boolean addDisplayInfo(DisplayInfo displayInfo) throws RemoteException, VisADException {
        if (this.getIsDestroyed()) {
            return false;
        }
        return super.addDisplayInfo(displayInfo);
    }

    @Override
    protected void handleBooleanPropertyChange(String id, boolean value) throws Exception {
        if (id.equals(PREF_GRIDLINES)) {
            if (this.hasDisplayMaster()) {
                this.getHovmollerDisplay().setGridLinesVisible(value);
            }
        } else {
            super.handleBooleanPropertyChange(id, value);
        }
    }

    @Override
    public boolean applyProperties() {
        boolean val = super.applyProperties();
        if (val) {
            this.notifyDisplayControls("View.DisplayListFont");
        }
        return val;
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
    }

    @Override
    protected JMenu makeShowMenu() {
        JMenu showMenu = super.makeShowMenu();
        this.createCBMI(showMenu, PREF_GRIDLINES);
        return showMenu;
    }

    @Override
    protected void getInitialBooleanProperties(List props) {
        super.getInitialBooleanProperties(props);
        props.add(new BooleanProperty(PREF_GRIDLINES, "Show Grid Lines", "", false));
    }

    @Override
    protected Container doMakeContents() {
        JComponent navComponent = this.getComponent();
        navComponent.setPreferredSize(this.getMySize());
        return navComponent;
    }

    @Override
    protected void initBooleanProperties() {
        super.initBooleanProperties();
        BooleanProperty bp = this.getBooleanProperty("View.ShowScales");
        if (bp != null) {
            bp.setDefault(true);
        }
        if ((bp = this.getBooleanProperty(PREF_GRIDLINES)) != null) {
            bp.setDefault(false);
        }
        if ((bp = this.getBooleanProperty("View.Wireframe")) != null) {
            bp.setDefault(true);
        }
    }

    @Override
    public void initializeViewMenu(JMenu viewMenu) {
        this.showControlMenu = false;
        super.initializeViewMenu(viewMenu);
        viewMenu.add(this.makeColorMenu());
        viewMenu.addSeparator();
        this.createCBMI(viewMenu, "View.ShareViews");
        viewMenu.add(GuiUtils.makeMenuItem("Set Share Group", this, "showSharableDialog"));
        viewMenu.addSeparator();
        viewMenu.add(GuiUtils.makeMenuItem("Properties", this, "showPropertiesDialog"));
    }

    public boolean getShowGridLines() {
        return this.getBp(PREF_GRIDLINES);
    }

    public void setClipping(boolean value) {
        this.clipOn = value;
        if (this.getHovmollerDisplay() != null) {
            this.getHovmollerDisplay().enableClipping(this.clipOn);
        }
    }

    public boolean getClipping() {
        return this.clipOn;
    }

    @Override
    public boolean animationOk() {
        return false;
    }

    @Override
    public boolean getShowSideLegend() {
        return false;
    }
}

