/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.util.List;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.Misc;

public abstract class History {
    private String name;
    private String alias = "";

    public History() {
    }

    public History(String name) {
        this.name = name;
    }

    public boolean hasAlias() {
        return this.alias != null && this.alias.length() > 0;
    }

    public abstract boolean process(IntegratedDataViewer var1);

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setAlias(String value) {
        this.alias = value;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        if (this.alias != null && this.alias.length() > 0) {
            return this.alias + " " + this.name;
        }
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof History)) {
            return false;
        }
        return Misc.equals(this.name, ((History)o).name);
    }

    public static History findWithAlias(String alias, List historyList, Class theClass) {
        if (alias.length() == 0) {
            return null;
        }
        for (int i = 0; i < historyList.size(); ++i) {
            History history = (History)historyList.get(i);
            if (!Misc.equals(history.getAlias(), alias) || theClass != null && !theClass.equals(history.getClass())) continue;
            return history;
        }
        return null;
    }
}

